/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.affiliate.api;

import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import travel.wink.sdk.affiliate.invoker.ApiClient;
import travel.wink.sdk.affiliate.model.EngineConfigurationViewAffiliate;
import travel.wink.sdk.affiliate.model.RemoveEntryResponseAffiliate;
import travel.wink.sdk.affiliate.model.UpsertEngineConfigurationRequestAffiliate;

public class CustomizationApi {
    private ApiClient apiClient;

    public CustomizationApi() {
        this(new ApiClient());
    }

    @Autowired
    public CustomizationApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    private WebClient.ResponseSpec createCustomizationRequestCreation(String companyIdentifier, UpsertEngineConfigurationRequestAffiliate upsertEngineConfigurationRequestAffiliate, String winkVersion) throws WebClientResponseException {
        UpsertEngineConfigurationRequestAffiliate postBody = upsertEngineConfigurationRequestAffiliate;
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling createCustomization", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (upsertEngineConfigurationRequestAffiliate == null) {
            throw new WebClientResponseException("Missing the required parameter 'upsertEngineConfigurationRequestAffiliate' when calling createCustomization", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("companyIdentifier", companyIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<EngineConfigurationViewAffiliate> localVarReturnType = new ParameterizedTypeReference<EngineConfigurationViewAffiliate>(this){};
        return this.apiClient.invokeAPI("/api/company/{companyIdentifier}/configuration", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<EngineConfigurationViewAffiliate> createCustomization(String companyIdentifier, UpsertEngineConfigurationRequestAffiliate upsertEngineConfigurationRequestAffiliate, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<EngineConfigurationViewAffiliate> localVarReturnType = new ParameterizedTypeReference<EngineConfigurationViewAffiliate>(this){};
        return this.createCustomizationRequestCreation(companyIdentifier, upsertEngineConfigurationRequestAffiliate, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<EngineConfigurationViewAffiliate>> createCustomizationWithHttpInfo(String companyIdentifier, UpsertEngineConfigurationRequestAffiliate upsertEngineConfigurationRequestAffiliate, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<EngineConfigurationViewAffiliate> localVarReturnType = new ParameterizedTypeReference<EngineConfigurationViewAffiliate>(this){};
        return this.createCustomizationRequestCreation(companyIdentifier, upsertEngineConfigurationRequestAffiliate, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec createCustomizationWithResponseSpec(String companyIdentifier, UpsertEngineConfigurationRequestAffiliate upsertEngineConfigurationRequestAffiliate, String winkVersion) throws WebClientResponseException {
        return this.createCustomizationRequestCreation(companyIdentifier, upsertEngineConfigurationRequestAffiliate, winkVersion);
    }

    private WebClient.ResponseSpec removeApplicationConfigurationRequestCreation(String companyIdentifier, String engineConfigurationIdentifier, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling removeApplicationConfiguration", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (engineConfigurationIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'engineConfigurationIdentifier' when calling removeApplicationConfiguration", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("companyIdentifier", companyIdentifier);
        pathParams.put("engineConfigurationIdentifier", engineConfigurationIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<RemoveEntryResponseAffiliate> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponseAffiliate>(this){};
        return this.apiClient.invokeAPI("/api/company/{companyIdentifier}/configuration/{engineConfigurationIdentifier}", HttpMethod.DELETE, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<RemoveEntryResponseAffiliate> removeApplicationConfiguration(String companyIdentifier, String engineConfigurationIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<RemoveEntryResponseAffiliate> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponseAffiliate>(this){};
        return this.removeApplicationConfigurationRequestCreation(companyIdentifier, engineConfigurationIdentifier, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<RemoveEntryResponseAffiliate>> removeApplicationConfigurationWithHttpInfo(String companyIdentifier, String engineConfigurationIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<RemoveEntryResponseAffiliate> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponseAffiliate>(this){};
        return this.removeApplicationConfigurationRequestCreation(companyIdentifier, engineConfigurationIdentifier, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec removeApplicationConfigurationWithResponseSpec(String companyIdentifier, String engineConfigurationIdentifier, String winkVersion) throws WebClientResponseException {
        return this.removeApplicationConfigurationRequestCreation(companyIdentifier, engineConfigurationIdentifier, winkVersion);
    }

    private WebClient.ResponseSpec showApplicationConfigurationRequestCreation(String companyIdentifier, String engineConfigurationIdentifier, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling showApplicationConfiguration", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (engineConfigurationIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'engineConfigurationIdentifier' when calling showApplicationConfiguration", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("companyIdentifier", companyIdentifier);
        pathParams.put("engineConfigurationIdentifier", engineConfigurationIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<EngineConfigurationViewAffiliate> localVarReturnType = new ParameterizedTypeReference<EngineConfigurationViewAffiliate>(this){};
        return this.apiClient.invokeAPI("/api/company/{companyIdentifier}/configuration/{engineConfigurationIdentifier}", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<EngineConfigurationViewAffiliate> showApplicationConfiguration(String companyIdentifier, String engineConfigurationIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<EngineConfigurationViewAffiliate> localVarReturnType = new ParameterizedTypeReference<EngineConfigurationViewAffiliate>(this){};
        return this.showApplicationConfigurationRequestCreation(companyIdentifier, engineConfigurationIdentifier, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<EngineConfigurationViewAffiliate>> showApplicationConfigurationWithHttpInfo(String companyIdentifier, String engineConfigurationIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<EngineConfigurationViewAffiliate> localVarReturnType = new ParameterizedTypeReference<EngineConfigurationViewAffiliate>(this){};
        return this.showApplicationConfigurationRequestCreation(companyIdentifier, engineConfigurationIdentifier, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showApplicationConfigurationWithResponseSpec(String companyIdentifier, String engineConfigurationIdentifier, String winkVersion) throws WebClientResponseException {
        return this.showApplicationConfigurationRequestCreation(companyIdentifier, engineConfigurationIdentifier, winkVersion);
    }

    private WebClient.ResponseSpec showApplicationConfigurationsByOwnerRequestCreation(String companyIdentifier, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling showApplicationConfigurationsByOwner", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("companyIdentifier", companyIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<EngineConfigurationViewAffiliate> localVarReturnType = new ParameterizedTypeReference<EngineConfigurationViewAffiliate>(this){};
        return this.apiClient.invokeAPI("/api/company/{companyIdentifier}/configuration/list", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Flux<EngineConfigurationViewAffiliate> showApplicationConfigurationsByOwner(String companyIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<EngineConfigurationViewAffiliate> localVarReturnType = new ParameterizedTypeReference<EngineConfigurationViewAffiliate>(this){};
        return this.showApplicationConfigurationsByOwnerRequestCreation(companyIdentifier, winkVersion).bodyToFlux((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<List<EngineConfigurationViewAffiliate>>> showApplicationConfigurationsByOwnerWithHttpInfo(String companyIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<EngineConfigurationViewAffiliate> localVarReturnType = new ParameterizedTypeReference<EngineConfigurationViewAffiliate>(this){};
        return this.showApplicationConfigurationsByOwnerRequestCreation(companyIdentifier, winkVersion).toEntityList((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showApplicationConfigurationsByOwnerWithResponseSpec(String companyIdentifier, String winkVersion) throws WebClientResponseException {
        return this.showApplicationConfigurationsByOwnerRequestCreation(companyIdentifier, winkVersion);
    }

    private WebClient.ResponseSpec showPrimaryApplicationConfigurationRequestCreation(String companyIdentifier, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling showPrimaryApplicationConfiguration", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("companyIdentifier", companyIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<EngineConfigurationViewAffiliate> localVarReturnType = new ParameterizedTypeReference<EngineConfigurationViewAffiliate>(this){};
        return this.apiClient.invokeAPI("/api/company/{companyIdentifier}/configuration", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<EngineConfigurationViewAffiliate> showPrimaryApplicationConfiguration(String companyIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<EngineConfigurationViewAffiliate> localVarReturnType = new ParameterizedTypeReference<EngineConfigurationViewAffiliate>(this){};
        return this.showPrimaryApplicationConfigurationRequestCreation(companyIdentifier, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<EngineConfigurationViewAffiliate>> showPrimaryApplicationConfigurationWithHttpInfo(String companyIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<EngineConfigurationViewAffiliate> localVarReturnType = new ParameterizedTypeReference<EngineConfigurationViewAffiliate>(this){};
        return this.showPrimaryApplicationConfigurationRequestCreation(companyIdentifier, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showPrimaryApplicationConfigurationWithResponseSpec(String companyIdentifier, String winkVersion) throws WebClientResponseException {
        return this.showPrimaryApplicationConfigurationRequestCreation(companyIdentifier, winkVersion);
    }

    private WebClient.ResponseSpec updateCustomizationRequestCreation(String companyIdentifier, String engineConfigurationIdentifier, UpsertEngineConfigurationRequestAffiliate upsertEngineConfigurationRequestAffiliate, String winkVersion) throws WebClientResponseException {
        UpsertEngineConfigurationRequestAffiliate postBody = upsertEngineConfigurationRequestAffiliate;
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling updateCustomization", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (engineConfigurationIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'engineConfigurationIdentifier' when calling updateCustomization", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (upsertEngineConfigurationRequestAffiliate == null) {
            throw new WebClientResponseException("Missing the required parameter 'upsertEngineConfigurationRequestAffiliate' when calling updateCustomization", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("companyIdentifier", companyIdentifier);
        pathParams.put("engineConfigurationIdentifier", engineConfigurationIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<EngineConfigurationViewAffiliate> localVarReturnType = new ParameterizedTypeReference<EngineConfigurationViewAffiliate>(this){};
        return this.apiClient.invokeAPI("/api/company/{companyIdentifier}/configuration/{engineConfigurationIdentifier}", HttpMethod.PUT, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<EngineConfigurationViewAffiliate> updateCustomization(String companyIdentifier, String engineConfigurationIdentifier, UpsertEngineConfigurationRequestAffiliate upsertEngineConfigurationRequestAffiliate, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<EngineConfigurationViewAffiliate> localVarReturnType = new ParameterizedTypeReference<EngineConfigurationViewAffiliate>(this){};
        return this.updateCustomizationRequestCreation(companyIdentifier, engineConfigurationIdentifier, upsertEngineConfigurationRequestAffiliate, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<EngineConfigurationViewAffiliate>> updateCustomizationWithHttpInfo(String companyIdentifier, String engineConfigurationIdentifier, UpsertEngineConfigurationRequestAffiliate upsertEngineConfigurationRequestAffiliate, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<EngineConfigurationViewAffiliate> localVarReturnType = new ParameterizedTypeReference<EngineConfigurationViewAffiliate>(this){};
        return this.updateCustomizationRequestCreation(companyIdentifier, engineConfigurationIdentifier, upsertEngineConfigurationRequestAffiliate, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec updateCustomizationWithResponseSpec(String companyIdentifier, String engineConfigurationIdentifier, UpsertEngineConfigurationRequestAffiliate upsertEngineConfigurationRequestAffiliate, String winkVersion) throws WebClientResponseException {
        return this.updateCustomizationRequestCreation(companyIdentifier, engineConfigurationIdentifier, upsertEngineConfigurationRequestAffiliate, winkVersion);
    }
}

