/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.affiliate.api;

import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import travel.wink.sdk.affiliate.invoker.ApiClient;
import travel.wink.sdk.affiliate.model.CountryAffiliate;
import travel.wink.sdk.affiliate.model.DynamicSellerListRequestAffiliate;
import travel.wink.sdk.affiliate.model.GeoNameAffiliate;
import travel.wink.sdk.affiliate.model.InventorySupplierAffiliate;
import travel.wink.sdk.affiliate.model.InventoryViewAffiliate;
import travel.wink.sdk.affiliate.model.PageInventorySupplierAffiliate;
import travel.wink.sdk.affiliate.model.PageInventoryViewAffiliate;

public class DiscoverApi {
    private ApiClient apiClient;

    public DiscoverApi() {
        this(new ApiClient());
    }

    @Autowired
    public DiscoverApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    private WebClient.ResponseSpec showCitiesForInventoryRequestCreation(String companyIdentifier, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling showCitiesForInventory", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("companyIdentifier", companyIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<GeoNameAffiliate> localVarReturnType = new ParameterizedTypeReference<GeoNameAffiliate>(this){};
        return this.apiClient.invokeAPI("/api/company/{companyIdentifier}/inventory/supplier/city/list", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Flux<GeoNameAffiliate> showCitiesForInventory(String companyIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<GeoNameAffiliate> localVarReturnType = new ParameterizedTypeReference<GeoNameAffiliate>(this){};
        return this.showCitiesForInventoryRequestCreation(companyIdentifier, winkVersion).bodyToFlux((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<List<GeoNameAffiliate>>> showCitiesForInventoryWithHttpInfo(String companyIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<GeoNameAffiliate> localVarReturnType = new ParameterizedTypeReference<GeoNameAffiliate>(this){};
        return this.showCitiesForInventoryRequestCreation(companyIdentifier, winkVersion).toEntityList((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showCitiesForInventoryWithResponseSpec(String companyIdentifier, String winkVersion) throws WebClientResponseException {
        return this.showCitiesForInventoryRequestCreation(companyIdentifier, winkVersion);
    }

    private WebClient.ResponseSpec showCitiesForInventory1RequestCreation(String companyIdentifier, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling showCitiesForInventory1", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("companyIdentifier", companyIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<GeoNameAffiliate> localVarReturnType = new ParameterizedTypeReference<GeoNameAffiliate>(this){};
        return this.apiClient.invokeAPI("/api/company/{companyIdentifier}/inventory/city/list", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Flux<GeoNameAffiliate> showCitiesForInventory1(String companyIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<GeoNameAffiliate> localVarReturnType = new ParameterizedTypeReference<GeoNameAffiliate>(this){};
        return this.showCitiesForInventory1RequestCreation(companyIdentifier, winkVersion).bodyToFlux((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<List<GeoNameAffiliate>>> showCitiesForInventory1WithHttpInfo(String companyIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<GeoNameAffiliate> localVarReturnType = new ParameterizedTypeReference<GeoNameAffiliate>(this){};
        return this.showCitiesForInventory1RequestCreation(companyIdentifier, winkVersion).toEntityList((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showCitiesForInventory1WithResponseSpec(String companyIdentifier, String winkVersion) throws WebClientResponseException {
        return this.showCitiesForInventory1RequestCreation(companyIdentifier, winkVersion);
    }

    private WebClient.ResponseSpec showCountriesForInventoryRequestCreation(String companyIdentifier, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling showCountriesForInventory", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("companyIdentifier", companyIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<CountryAffiliate> localVarReturnType = new ParameterizedTypeReference<CountryAffiliate>(this){};
        return this.apiClient.invokeAPI("/api/company/{companyIdentifier}/inventory/country/list", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Flux<CountryAffiliate> showCountriesForInventory(String companyIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<CountryAffiliate> localVarReturnType = new ParameterizedTypeReference<CountryAffiliate>(this){};
        return this.showCountriesForInventoryRequestCreation(companyIdentifier, winkVersion).bodyToFlux((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<List<CountryAffiliate>>> showCountriesForInventoryWithHttpInfo(String companyIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<CountryAffiliate> localVarReturnType = new ParameterizedTypeReference<CountryAffiliate>(this){};
        return this.showCountriesForInventoryRequestCreation(companyIdentifier, winkVersion).toEntityList((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showCountriesForInventoryWithResponseSpec(String companyIdentifier, String winkVersion) throws WebClientResponseException {
        return this.showCountriesForInventoryRequestCreation(companyIdentifier, winkVersion);
    }

    private WebClient.ResponseSpec showCountriesForInventorySupplierRequestCreation(String companyIdentifier, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling showCountriesForInventorySupplier", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("companyIdentifier", companyIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<CountryAffiliate> localVarReturnType = new ParameterizedTypeReference<CountryAffiliate>(this){};
        return this.apiClient.invokeAPI("/api/company/{companyIdentifier}/inventory/supplier/country/list", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Flux<CountryAffiliate> showCountriesForInventorySupplier(String companyIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<CountryAffiliate> localVarReturnType = new ParameterizedTypeReference<CountryAffiliate>(this){};
        return this.showCountriesForInventorySupplierRequestCreation(companyIdentifier, winkVersion).bodyToFlux((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<List<CountryAffiliate>>> showCountriesForInventorySupplierWithHttpInfo(String companyIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<CountryAffiliate> localVarReturnType = new ParameterizedTypeReference<CountryAffiliate>(this){};
        return this.showCountriesForInventorySupplierRequestCreation(companyIdentifier, winkVersion).toEntityList((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showCountriesForInventorySupplierWithResponseSpec(String companyIdentifier, String winkVersion) throws WebClientResponseException {
        return this.showCountriesForInventorySupplierRequestCreation(companyIdentifier, winkVersion);
    }

    private WebClient.ResponseSpec showDynamicSellerInventoryRequestCreation(String companyIdentifier, DynamicSellerListRequestAffiliate dynamicSellerListRequestAffiliate, String winkVersion) throws WebClientResponseException {
        DynamicSellerListRequestAffiliate postBody = dynamicSellerListRequestAffiliate;
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling showDynamicSellerInventory", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (dynamicSellerListRequestAffiliate == null) {
            throw new WebClientResponseException("Missing the required parameter 'dynamicSellerListRequestAffiliate' when calling showDynamicSellerInventory", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("companyIdentifier", companyIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<PageInventoryViewAffiliate> localVarReturnType = new ParameterizedTypeReference<PageInventoryViewAffiliate>(this){};
        return this.apiClient.invokeAPI("/api/company/{companyIdentifier}/inventory/grid", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<PageInventoryViewAffiliate> showDynamicSellerInventory(String companyIdentifier, DynamicSellerListRequestAffiliate dynamicSellerListRequestAffiliate, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<PageInventoryViewAffiliate> localVarReturnType = new ParameterizedTypeReference<PageInventoryViewAffiliate>(this){};
        return this.showDynamicSellerInventoryRequestCreation(companyIdentifier, dynamicSellerListRequestAffiliate, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<PageInventoryViewAffiliate>> showDynamicSellerInventoryWithHttpInfo(String companyIdentifier, DynamicSellerListRequestAffiliate dynamicSellerListRequestAffiliate, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<PageInventoryViewAffiliate> localVarReturnType = new ParameterizedTypeReference<PageInventoryViewAffiliate>(this){};
        return this.showDynamicSellerInventoryRequestCreation(companyIdentifier, dynamicSellerListRequestAffiliate, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showDynamicSellerInventoryWithResponseSpec(String companyIdentifier, DynamicSellerListRequestAffiliate dynamicSellerListRequestAffiliate, String winkVersion) throws WebClientResponseException {
        return this.showDynamicSellerInventoryRequestCreation(companyIdentifier, dynamicSellerListRequestAffiliate, winkVersion);
    }

    private WebClient.ResponseSpec showDynamicSellerInventoryByIdRequestCreation(String companyIdentifier, String dynamicListIdentifier, Integer page, Integer size, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling showDynamicSellerInventoryById", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (dynamicListIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'dynamicListIdentifier' when calling showDynamicSellerInventoryById", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("companyIdentifier", companyIdentifier);
        pathParams.put("dynamicListIdentifier", dynamicListIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "page", page));
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "size", size));
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<PageInventorySupplierAffiliate> localVarReturnType = new ParameterizedTypeReference<PageInventorySupplierAffiliate>(this){};
        return this.apiClient.invokeAPI("/api/company/{companyIdentifier}/inventory/supplier/grid/{dynamicListIdentifier}", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<PageInventorySupplierAffiliate> showDynamicSellerInventoryById(String companyIdentifier, String dynamicListIdentifier, Integer page, Integer size, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<PageInventorySupplierAffiliate> localVarReturnType = new ParameterizedTypeReference<PageInventorySupplierAffiliate>(this){};
        return this.showDynamicSellerInventoryByIdRequestCreation(companyIdentifier, dynamicListIdentifier, page, size, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<PageInventorySupplierAffiliate>> showDynamicSellerInventoryByIdWithHttpInfo(String companyIdentifier, String dynamicListIdentifier, Integer page, Integer size, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<PageInventorySupplierAffiliate> localVarReturnType = new ParameterizedTypeReference<PageInventorySupplierAffiliate>(this){};
        return this.showDynamicSellerInventoryByIdRequestCreation(companyIdentifier, dynamicListIdentifier, page, size, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showDynamicSellerInventoryByIdWithResponseSpec(String companyIdentifier, String dynamicListIdentifier, Integer page, Integer size, String winkVersion) throws WebClientResponseException {
        return this.showDynamicSellerInventoryByIdRequestCreation(companyIdentifier, dynamicListIdentifier, page, size, winkVersion);
    }

    private WebClient.ResponseSpec showDynamicSellerInventoryById1RequestCreation(String companyIdentifier, String dynamicListIdentifier, Integer page, Integer size, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling showDynamicSellerInventoryById1", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (dynamicListIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'dynamicListIdentifier' when calling showDynamicSellerInventoryById1", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("companyIdentifier", companyIdentifier);
        pathParams.put("dynamicListIdentifier", dynamicListIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "page", page));
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "size", size));
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<PageInventoryViewAffiliate> localVarReturnType = new ParameterizedTypeReference<PageInventoryViewAffiliate>(this){};
        return this.apiClient.invokeAPI("/api/company/{companyIdentifier}/inventory/grid/{dynamicListIdentifier}", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<PageInventoryViewAffiliate> showDynamicSellerInventoryById1(String companyIdentifier, String dynamicListIdentifier, Integer page, Integer size, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<PageInventoryViewAffiliate> localVarReturnType = new ParameterizedTypeReference<PageInventoryViewAffiliate>(this){};
        return this.showDynamicSellerInventoryById1RequestCreation(companyIdentifier, dynamicListIdentifier, page, size, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<PageInventoryViewAffiliate>> showDynamicSellerInventoryById1WithHttpInfo(String companyIdentifier, String dynamicListIdentifier, Integer page, Integer size, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<PageInventoryViewAffiliate> localVarReturnType = new ParameterizedTypeReference<PageInventoryViewAffiliate>(this){};
        return this.showDynamicSellerInventoryById1RequestCreation(companyIdentifier, dynamicListIdentifier, page, size, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showDynamicSellerInventoryById1WithResponseSpec(String companyIdentifier, String dynamicListIdentifier, Integer page, Integer size, String winkVersion) throws WebClientResponseException {
        return this.showDynamicSellerInventoryById1RequestCreation(companyIdentifier, dynamicListIdentifier, page, size, winkVersion);
    }

    private WebClient.ResponseSpec showInventorySupplierRequestCreation(String companyIdentifier, String supplierIdentifier, String salesChannelIdentifier, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling showInventorySupplier", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (supplierIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'supplierIdentifier' when calling showInventorySupplier", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (salesChannelIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'salesChannelIdentifier' when calling showInventorySupplier", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("companyIdentifier", companyIdentifier);
        pathParams.put("supplierIdentifier", supplierIdentifier);
        pathParams.put("salesChannelIdentifier", salesChannelIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<InventorySupplierAffiliate> localVarReturnType = new ParameterizedTypeReference<InventorySupplierAffiliate>(this){};
        return this.apiClient.invokeAPI("/api/company/{companyIdentifier}/inventory/supplier/{supplierIdentifier}/sales-channel/{salesChannelIdentifier}", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<InventorySupplierAffiliate> showInventorySupplier(String companyIdentifier, String supplierIdentifier, String salesChannelIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<InventorySupplierAffiliate> localVarReturnType = new ParameterizedTypeReference<InventorySupplierAffiliate>(this){};
        return this.showInventorySupplierRequestCreation(companyIdentifier, supplierIdentifier, salesChannelIdentifier, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<InventorySupplierAffiliate>> showInventorySupplierWithHttpInfo(String companyIdentifier, String supplierIdentifier, String salesChannelIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<InventorySupplierAffiliate> localVarReturnType = new ParameterizedTypeReference<InventorySupplierAffiliate>(this){};
        return this.showInventorySupplierRequestCreation(companyIdentifier, supplierIdentifier, salesChannelIdentifier, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showInventorySupplierWithResponseSpec(String companyIdentifier, String supplierIdentifier, String salesChannelIdentifier, String winkVersion) throws WebClientResponseException {
        return this.showInventorySupplierRequestCreation(companyIdentifier, supplierIdentifier, salesChannelIdentifier, winkVersion);
    }

    private WebClient.ResponseSpec showLatestInventoryRequestCreation(String companyIdentifier, Integer page, Integer size, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling showLatestInventory", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("companyIdentifier", companyIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "page", page));
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "size", size));
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<InventoryViewAffiliate> localVarReturnType = new ParameterizedTypeReference<InventoryViewAffiliate>(this){};
        return this.apiClient.invokeAPI("/api/company/{companyIdentifier}/inventory/list", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Flux<InventoryViewAffiliate> showLatestInventory(String companyIdentifier, Integer page, Integer size, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<InventoryViewAffiliate> localVarReturnType = new ParameterizedTypeReference<InventoryViewAffiliate>(this){};
        return this.showLatestInventoryRequestCreation(companyIdentifier, page, size, winkVersion).bodyToFlux((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<List<InventoryViewAffiliate>>> showLatestInventoryWithHttpInfo(String companyIdentifier, Integer page, Integer size, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<InventoryViewAffiliate> localVarReturnType = new ParameterizedTypeReference<InventoryViewAffiliate>(this){};
        return this.showLatestInventoryRequestCreation(companyIdentifier, page, size, winkVersion).toEntityList((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showLatestInventoryWithResponseSpec(String companyIdentifier, Integer page, Integer size, String winkVersion) throws WebClientResponseException {
        return this.showLatestInventoryRequestCreation(companyIdentifier, page, size, winkVersion);
    }

    private WebClient.ResponseSpec showLatestInventorySupplierListRequestCreation(String companyIdentifier, Integer page, Integer size, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling showLatestInventorySupplierList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("companyIdentifier", companyIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "page", page));
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "size", size));
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<InventorySupplierAffiliate> localVarReturnType = new ParameterizedTypeReference<InventorySupplierAffiliate>(this){};
        return this.apiClient.invokeAPI("/api/company/{companyIdentifier}/inventory/supplier/list", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Flux<InventorySupplierAffiliate> showLatestInventorySupplierList(String companyIdentifier, Integer page, Integer size, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<InventorySupplierAffiliate> localVarReturnType = new ParameterizedTypeReference<InventorySupplierAffiliate>(this){};
        return this.showLatestInventorySupplierListRequestCreation(companyIdentifier, page, size, winkVersion).bodyToFlux((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<List<InventorySupplierAffiliate>>> showLatestInventorySupplierListWithHttpInfo(String companyIdentifier, Integer page, Integer size, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<InventorySupplierAffiliate> localVarReturnType = new ParameterizedTypeReference<InventorySupplierAffiliate>(this){};
        return this.showLatestInventorySupplierListRequestCreation(companyIdentifier, page, size, winkVersion).toEntityList((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showLatestInventorySupplierListWithResponseSpec(String companyIdentifier, Integer page, Integer size, String winkVersion) throws WebClientResponseException {
        return this.showLatestInventorySupplierListRequestCreation(companyIdentifier, page, size, winkVersion);
    }

    private WebClient.ResponseSpec showSuppliersForDynamicSellerInventoryRequestCreation(String companyIdentifier, DynamicSellerListRequestAffiliate dynamicSellerListRequestAffiliate, String winkVersion) throws WebClientResponseException {
        DynamicSellerListRequestAffiliate postBody = dynamicSellerListRequestAffiliate;
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling showSuppliersForDynamicSellerInventory", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (dynamicSellerListRequestAffiliate == null) {
            throw new WebClientResponseException("Missing the required parameter 'dynamicSellerListRequestAffiliate' when calling showSuppliersForDynamicSellerInventory", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("companyIdentifier", companyIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<PageInventorySupplierAffiliate> localVarReturnType = new ParameterizedTypeReference<PageInventorySupplierAffiliate>(this){};
        return this.apiClient.invokeAPI("/api/company/{companyIdentifier}/inventory/supplier/grid", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<PageInventorySupplierAffiliate> showSuppliersForDynamicSellerInventory(String companyIdentifier, DynamicSellerListRequestAffiliate dynamicSellerListRequestAffiliate, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<PageInventorySupplierAffiliate> localVarReturnType = new ParameterizedTypeReference<PageInventorySupplierAffiliate>(this){};
        return this.showSuppliersForDynamicSellerInventoryRequestCreation(companyIdentifier, dynamicSellerListRequestAffiliate, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<PageInventorySupplierAffiliate>> showSuppliersForDynamicSellerInventoryWithHttpInfo(String companyIdentifier, DynamicSellerListRequestAffiliate dynamicSellerListRequestAffiliate, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<PageInventorySupplierAffiliate> localVarReturnType = new ParameterizedTypeReference<PageInventorySupplierAffiliate>(this){};
        return this.showSuppliersForDynamicSellerInventoryRequestCreation(companyIdentifier, dynamicSellerListRequestAffiliate, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showSuppliersForDynamicSellerInventoryWithResponseSpec(String companyIdentifier, DynamicSellerListRequestAffiliate dynamicSellerListRequestAffiliate, String winkVersion) throws WebClientResponseException {
        return this.showSuppliersForDynamicSellerInventoryRequestCreation(companyIdentifier, dynamicSellerListRequestAffiliate, winkVersion);
    }
}

