/*
 * Wink API
 * ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Affiliate](/affiliate): All APIs related to selling travel inventory as an affiliate. - [Analytics](/analytics): All APIs related to tracking metrics across a wide variety of data source segments including, more entertaining, leaderboard metrics. - [Booking](/booking): All APIs related to creating platform bookings. - [Channel Manager](/channel-manager): All APIs related to channel managers who want to integrate with our platform. - [Extranet](/extranet): All APIs related to managing travel inventory and suppliers. - [Inventory](/inventory): All APIs related to retrieve known travel inventory as it was found using the Lookup API.. - [Lookup](/lookup): All APIs related to locating inventory by region, locale and property flags. - [Reference](/reference): All APIs related to retrieving platform-supported taxonomies. - [TripPay Acquiring](/payment-acquiring): All APIs related to capture payment details such as a Stripe payment intent. - [TripPay](/payment): All APIs related to TripPay account management, booking, mapping and integration features.  ## SDKs We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).  - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)  ## Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Wink-Version` header. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints.  ## Release history - 2022-10-15: v2.0 - Removed HATEOAS and added Wink-Version header - 2022-05-08: v1 - Exposed channel manager API - 2021-07-01: v1 - Initial release  # Affiliate API Welcome to the Affiliate API - A programmer-friendly way to search for and display bespoke travel inventory for your audience. Use this API to help you prepare travel inventory for sale.  # Intended Audience Programmers are a requirement to start integrating with wink. You will benefit from an API integration if you are new or existing travel related company that want easy access to great inventory.## Examples: - Hotel brands / chains that want to make their own booking engine - Travel tech companies that want to create the next hot mobile travel app - Destination sites that want to make their own booking engine - Bloggers and influencers who want to sell travel inventory to their audience - OTAs that want access direct relationships with suppliers and better quality hotel inventory
 *
 * The version of the OpenAPI document: 29.12.0
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.affiliate.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.OffsetDateTime;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import travel.wink.sdk.affiliate.model.AuthenticatedUserAffiliate;
import travel.wink.sdk.affiliate.model.BookingContractItemAffiliate;
import travel.wink.sdk.affiliate.model.BookingContractPaymentDetailsAffiliate;
import travel.wink.sdk.affiliate.model.CustomMonetaryAmount;
import travel.wink.sdk.affiliate.model.PayoutAffiliate;
import travel.wink.sdk.affiliate.model.QuoteAffiliate;
import travel.wink.sdk.affiliate.model.RefundAffiliate;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * Booking contract created by TripPay
 */
@JsonPropertyOrder({
  BookingContractAffiliate.JSON_PROPERTY_BOOKING_CONTRACT_IDENTIFIER,
  BookingContractAffiliate.JSON_PROPERTY_CREATED_DATE,
  BookingContractAffiliate.JSON_PROPERTY_LAST_UPDATE,
  BookingContractAffiliate.JSON_PROPERTY_FEDERATED_ORGANIZATION_IDENTIFIER,
  BookingContractAffiliate.JSON_PROPERTY_FEDERATED_ORGANIZATION_NAME,
  BookingContractAffiliate.JSON_PROPERTY_USER,
  BookingContractAffiliate.JSON_PROPERTY_IP_ADDRESS,
  BookingContractAffiliate.JSON_PROPERTY_TRACE_ID,
  BookingContractAffiliate.JSON_PROPERTY_SOURCE_URL,
  BookingContractAffiliate.JSON_PROPERTY_IDENTIFIER,
  BookingContractAffiliate.JSON_PROPERTY_SUPPLIER_IDENTIFIER,
  BookingContractAffiliate.JSON_PROPERTY_SUPPLIER_NAME,
  BookingContractAffiliate.JSON_PROPERTY_DISPLAY_PRICE_QUOTE,
  BookingContractAffiliate.JSON_PROPERTY_SUPPLIER_PRICE_QUOTE,
  BookingContractAffiliate.JSON_PROPERTY_INTERNAL_PRICE_QUOTE,
  BookingContractAffiliate.JSON_PROPERTY_CAPTURE_PRICE_QUOTE,
  BookingContractAffiliate.JSON_PROPERTY_ITEM_LIST,
  BookingContractAffiliate.JSON_PROPERTY_EXTERNAL_SUPPLIER_IDENTIFIER,
  BookingContractAffiliate.JSON_PROPERTY_EXTERNAL_SUPPLIER_BOOKING_CODE,
  BookingContractAffiliate.JSON_PROPERTY_PAYMENT,
  BookingContractAffiliate.JSON_PROPERTY_CANCELLED,
  BookingContractAffiliate.JSON_PROPERTY_CANCELLED_ON,
  BookingContractAffiliate.JSON_PROPERTY_CANCELLER,
  BookingContractAffiliate.JSON_PROPERTY_CANCELLATION_TYPE,
  BookingContractAffiliate.JSON_PROPERTY_CANCELLER_USER_IDENTIFIER,
  BookingContractAffiliate.JSON_PROPERTY_CANCEL_REASON,
  BookingContractAffiliate.JSON_PROPERTY_FUNDS_PROCESSED,
  BookingContractAffiliate.JSON_PROPERTY_REFUNDS,
  BookingContractAffiliate.JSON_PROPERTY_PAYOUTS,
  BookingContractAffiliate.JSON_PROPERTY_SOURCE_CURRENCY,
  BookingContractAffiliate.JSON_PROPERTY_DISPLAY_CURRENCY,
  BookingContractAffiliate.JSON_PROPERTY_SUPPLIER_CURRENCY,
  BookingContractAffiliate.JSON_PROPERTY_INTERNAL_CURRENCY,
  BookingContractAffiliate.JSON_PROPERTY_CAPTURE_CURRENCY,
  BookingContractAffiliate.JSON_PROPERTY_SOURCE_AMOUNT,
  BookingContractAffiliate.JSON_PROPERTY_DISPLAY_AMOUNT,
  BookingContractAffiliate.JSON_PROPERTY_SUPPLIER_AMOUNT,
  BookingContractAffiliate.JSON_PROPERTY_INTERNAL_AMOUNT,
  BookingContractAffiliate.JSON_PROPERTY_CAPTURE_AMOUNT,
  BookingContractAffiliate.JSON_PROPERTY_SOURCE_AMOUNT_REFUND_MODIFIER,
  BookingContractAffiliate.JSON_PROPERTY_DISPLAY_AMOUNT_REFUND_MODIFIER,
  BookingContractAffiliate.JSON_PROPERTY_SUPPLIER_AMOUNT_REFUND_MODIFIER,
  BookingContractAffiliate.JSON_PROPERTY_INTERNAL_AMOUNT_REFUND_MODIFIER,
  BookingContractAffiliate.JSON_PROPERTY_CAPTURE_AMOUNT_REFUND_MODIFIER,
  BookingContractAffiliate.JSON_PROPERTY_NET_SOURCE_AMOUNT,
  BookingContractAffiliate.JSON_PROPERTY_NET_DISPLAY_AMOUNT,
  BookingContractAffiliate.JSON_PROPERTY_NET_SUPPLIER_AMOUNT,
  BookingContractAffiliate.JSON_PROPERTY_NET_INTERNAL_AMOUNT,
  BookingContractAffiliate.JSON_PROPERTY_NET_CAPTURE_AMOUNT,
  BookingContractAffiliate.JSON_PROPERTY_TOTAL_TOKENS_EARNED,
  BookingContractAffiliate.JSON_PROPERTY_METADATA,
  BookingContractAffiliate.JSON_PROPERTY_TOTAL_TRIP_PAY_FEE_IN_PERCENT,
  BookingContractAffiliate.JSON_PROPERTY_HAS_REFUNDS,
  BookingContractAffiliate.JSON_PROPERTY_ORIGINAL_COMMISSIONS_IN_PERCENT,
  BookingContractAffiliate.JSON_PROPERTY_ORIGINAL_FEES_IN_PERCENT,
  BookingContractAffiliate.JSON_PROPERTY_TOTAL_COMMISSIONS_IN_PERCENT_WITH_REFUND,
  BookingContractAffiliate.JSON_PROPERTY_TOTAL_FEES_IN_PERCENT_WITH_REFUND,
  BookingContractAffiliate.JSON_PROPERTY_TOTAL_TRIP_PAY_FEE_IN_PERCENT_WITH_REFUND,
  BookingContractAffiliate.JSON_PROPERTY_NET_TOTAL_FEES_SUPPLIER_AMOUNT,
  BookingContractAffiliate.JSON_PROPERTY_TOTAL_FEES_SUPPLIER_AMOUNT,
  BookingContractAffiliate.JSON_PROPERTY_NET_TOTAL_TRIP_PAY_FEE_SUPPLIER_AMOUNT,
  BookingContractAffiliate.JSON_PROPERTY_TOTAL_TRIP_PAY_FEE_SUPPLIER_AMOUNT,
  BookingContractAffiliate.JSON_PROPERTY_NET_COMMISSIONABLE_TOTAL_SUPPLIER_AMOUNT,
  BookingContractAffiliate.JSON_PROPERTY_COMMISSIONABLE_TOTAL_SUPPLIER_AMOUNT,
  BookingContractAffiliate.JSON_PROPERTY_NET_TOTAL_FEES_AND_COMMISSIONS_SUPPLIER_AMOUNT,
  BookingContractAffiliate.JSON_PROPERTY_TOTAL_FEES_AND_COMMISSIONS_SUPPLIER_AMOUNT,
  BookingContractAffiliate.JSON_PROPERTY_CANCELLABLE_WITH_NO_CHARGES,
  BookingContractAffiliate.JSON_PROPERTY_IS_CANCELLABLE_WITH_POTENTIAL_CHARGES,
  BookingContractAffiliate.JSON_PROPERTY_NET_COMMISSIONABLE_TOTAL_SOURCE_AMOUNT,
  BookingContractAffiliate.JSON_PROPERTY_NET_COMMISSIONABLE_TOTAL_CAPTURE_AMOUNT,
  BookingContractAffiliate.JSON_PROPERTY_NET_COMMISSIONABLE_TOTAL_DISPLAY_AMOUNT,
  BookingContractAffiliate.JSON_PROPERTY_NET_COMMISSIONABLE_TOTAL_INTERNAL_AMOUNT,
  BookingContractAffiliate.JSON_PROPERTY_NET_TOTAL_FEES_AND_COMMISSIONS_SOURCE_AMOUNT,
  BookingContractAffiliate.JSON_PROPERTY_NET_TOTAL_FEES_AND_COMMISSIONS_CAPTURE_AMOUNT,
  BookingContractAffiliate.JSON_PROPERTY_NET_TOTAL_FEES_AND_COMMISSIONS_DISPLAY_AMOUNT,
  BookingContractAffiliate.JSON_PROPERTY_NET_TOTAL_FEES_AND_COMMISSIONS_INTERNAL_AMOUNT,
  BookingContractAffiliate.JSON_PROPERTY_NET_TOTAL_FEES_SOURCE_AMOUNT,
  BookingContractAffiliate.JSON_PROPERTY_NET_TOTAL_FEES_CAPTURE_AMOUNT,
  BookingContractAffiliate.JSON_PROPERTY_NET_TOTAL_FEES_DISPLAY_AMOUNT,
  BookingContractAffiliate.JSON_PROPERTY_NET_TOTAL_FEES_INTERNAL_AMOUNT,
  BookingContractAffiliate.JSON_PROPERTY_NET_TOTAL_TRIP_PAY_FEE_SOURCE_AMOUNT,
  BookingContractAffiliate.JSON_PROPERTY_NET_TOTAL_TRIP_PAY_FEE_CAPTURE_AMOUNT,
  BookingContractAffiliate.JSON_PROPERTY_NET_TOTAL_TRIP_PAY_FEE_DISPLAY_AMOUNT,
  BookingContractAffiliate.JSON_PROPERTY_NET_TOTAL_TRIP_PAY_FEE_INTERNAL_AMOUNT,
  BookingContractAffiliate.JSON_PROPERTY_NET_TOTAL_SALES_SOURCE_AMOUNT,
  BookingContractAffiliate.JSON_PROPERTY_NET_TOTAL_SALES_CAPTURE_AMOUNT,
  BookingContractAffiliate.JSON_PROPERTY_NET_TOTAL_SALES_DISPLAY_AMOUNT,
  BookingContractAffiliate.JSON_PROPERTY_NET_TOTAL_SALES_SUPPLIER_AMOUNT,
  BookingContractAffiliate.JSON_PROPERTY_NET_TOTAL_SALES_INTERNAL_AMOUNT,
  BookingContractAffiliate.JSON_PROPERTY_COMMISSIONABLE_TOTAL_SOURCE_AMOUNT,
  BookingContractAffiliate.JSON_PROPERTY_COMMISSIONABLE_TOTAL_CAPTURE_AMOUNT,
  BookingContractAffiliate.JSON_PROPERTY_COMMISSIONABLE_TOTAL_DISPLAY_AMOUNT,
  BookingContractAffiliate.JSON_PROPERTY_COMMISSIONABLE_TOTAL_INTERNAL_AMOUNT,
  BookingContractAffiliate.JSON_PROPERTY_TOTAL_FEES_AND_COMMISSIONS_SOURCE_AMOUNT,
  BookingContractAffiliate.JSON_PROPERTY_TOTAL_FEES_AND_COMMISSIONS_CAPTURE_AMOUNT,
  BookingContractAffiliate.JSON_PROPERTY_TOTAL_FEES_AND_COMMISSIONS_DISPLAY_AMOUNT,
  BookingContractAffiliate.JSON_PROPERTY_TOTAL_FEES_AND_COMMISSIONS_INTERNAL_AMOUNT,
  BookingContractAffiliate.JSON_PROPERTY_TOTAL_FEES_SOURCE_AMOUNT,
  BookingContractAffiliate.JSON_PROPERTY_TOTAL_FEES_CAPTURE_AMOUNT,
  BookingContractAffiliate.JSON_PROPERTY_TOTAL_FEES_DISPLAY_AMOUNT,
  BookingContractAffiliate.JSON_PROPERTY_TOTAL_FEES_INTERNAL_AMOUNT,
  BookingContractAffiliate.JSON_PROPERTY_TOTAL_TRIP_PAY_FEE_SOURCE_AMOUNT,
  BookingContractAffiliate.JSON_PROPERTY_TOTAL_TRIP_PAY_FEE_CAPTURE_AMOUNT,
  BookingContractAffiliate.JSON_PROPERTY_TOTAL_TRIP_PAY_FEE_DISPLAY_AMOUNT,
  BookingContractAffiliate.JSON_PROPERTY_TOTAL_TRIP_PAY_FEE_INTERNAL_AMOUNT,
  BookingContractAffiliate.JSON_PROPERTY_TOTAL_SALES_SOURCE_AMOUNT,
  BookingContractAffiliate.JSON_PROPERTY_TOTAL_SALES_CAPTURE_AMOUNT,
  BookingContractAffiliate.JSON_PROPERTY_TOTAL_SALES_DISPLAY_AMOUNT,
  BookingContractAffiliate.JSON_PROPERTY_TOTAL_SALES_SUPPLIER_AMOUNT,
  BookingContractAffiliate.JSON_PROPERTY_TOTAL_SALES_INTERNAL_AMOUNT,
  BookingContractAffiliate.JSON_PROPERTY_FUNDS_AVAILABLE_DATE,
  BookingContractAffiliate.JSON_PROPERTY_TOTAL_FEES_IN_PERCENT,
  BookingContractAffiliate.JSON_PROPERTY_TOTAL_COMMISSIONS_IN_PERCENT,
  BookingContractAffiliate.JSON_PROPERTY_TOTAL_FEES_AND_COMMISSIONS_IN_PERCENT_WITH_REFUND,
  BookingContractAffiliate.JSON_PROPERTY_TOTAL_FEES_AND_COMMISSIONS_IN_PERCENT,
  BookingContractAffiliate.JSON_PROPERTY_NET_TOTAL_CUSTOMERS_SOURCE_AMOUNT,
  BookingContractAffiliate.JSON_PROPERTY_NET_TOTAL_CUSTOMERS_CAPTURE_AMOUNT,
  BookingContractAffiliate.JSON_PROPERTY_NET_TOTAL_CUSTOMERS_DISPLAY_AMOUNT,
  BookingContractAffiliate.JSON_PROPERTY_NET_TOTAL_CUSTOMERS_SUPPLIER_AMOUNT,
  BookingContractAffiliate.JSON_PROPERTY_NET_TOTAL_CUSTOMERS_INTERNAL_AMOUNT,
  BookingContractAffiliate.JSON_PROPERTY_HAS_SUCCESSFUL_REFUNDS,
  BookingContractAffiliate.JSON_PROPERTY_HAS_PENDING_REFUNDS,
  BookingContractAffiliate.JSON_PROPERTY_HAS_FAILED_REFUNDS,
  BookingContractAffiliate.JSON_PROPERTY_LODGING,
  BookingContractAffiliate.JSON_PROPERTY_CANCELLABLE_BY_SUPPLIER,
  BookingContractAffiliate.JSON_PROPERTY_CANCELLABLE_BY_TRAVELER
})
@JsonTypeName("BookingContract_Affiliate")
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-10-16T10:17:15.847873815+07:00[Asia/Bangkok]")
public class BookingContractAffiliate {
  public static final String JSON_PROPERTY_BOOKING_CONTRACT_IDENTIFIER = "bookingContractIdentifier";
  private UUID bookingContractIdentifier;

  public static final String JSON_PROPERTY_CREATED_DATE = "createdDate";
  private java.time.LocalDateTime createdDate;

  public static final String JSON_PROPERTY_LAST_UPDATE = "lastUpdate";
  private java.time.LocalDateTime lastUpdate;

  public static final String JSON_PROPERTY_FEDERATED_ORGANIZATION_IDENTIFIER = "federatedOrganizationIdentifier";
  private String federatedOrganizationIdentifier;

  public static final String JSON_PROPERTY_FEDERATED_ORGANIZATION_NAME = "federatedOrganizationName";
  private String federatedOrganizationName;

  public static final String JSON_PROPERTY_USER = "user";
  private AuthenticatedUserAffiliate user;

  public static final String JSON_PROPERTY_IP_ADDRESS = "ipAddress";
  private String ipAddress;

  public static final String JSON_PROPERTY_TRACE_ID = "traceId";
  private String traceId;

  public static final String JSON_PROPERTY_SOURCE_URL = "sourceUrl";
  private String sourceUrl;

  public static final String JSON_PROPERTY_IDENTIFIER = "identifier";
  private UUID identifier;

  public static final String JSON_PROPERTY_SUPPLIER_IDENTIFIER = "supplierIdentifier";
  private UUID supplierIdentifier;

  public static final String JSON_PROPERTY_SUPPLIER_NAME = "supplierName";
  private String supplierName;

  public static final String JSON_PROPERTY_DISPLAY_PRICE_QUOTE = "displayPriceQuote";
  private QuoteAffiliate displayPriceQuote;

  public static final String JSON_PROPERTY_SUPPLIER_PRICE_QUOTE = "supplierPriceQuote";
  private QuoteAffiliate supplierPriceQuote;

  public static final String JSON_PROPERTY_INTERNAL_PRICE_QUOTE = "internalPriceQuote";
  private QuoteAffiliate internalPriceQuote;

  public static final String JSON_PROPERTY_CAPTURE_PRICE_QUOTE = "capturePriceQuote";
  private QuoteAffiliate capturePriceQuote;

  public static final String JSON_PROPERTY_ITEM_LIST = "itemList";
  private List<BookingContractItemAffiliate> itemList;

  public static final String JSON_PROPERTY_EXTERNAL_SUPPLIER_IDENTIFIER = "externalSupplierIdentifier";
  private String externalSupplierIdentifier;

  public static final String JSON_PROPERTY_EXTERNAL_SUPPLIER_BOOKING_CODE = "externalSupplierBookingCode";
  private String externalSupplierBookingCode;

  public static final String JSON_PROPERTY_PAYMENT = "payment";
  private BookingContractPaymentDetailsAffiliate payment;

  public static final String JSON_PROPERTY_CANCELLED = "cancelled";
  private Boolean cancelled = false;

  public static final String JSON_PROPERTY_CANCELLED_ON = "cancelledOn";
  private java.time.LocalDateTime cancelledOn;

  /**
   * Type of entity that cancelled the booking.
   */
  public enum CancellerEnum {
    SALES_CHANNEL("SALES_CHANNEL"),
    
    SUPPLIER("SUPPLIER"),
    
    TRAVELER("TRAVELER"),
    
    ACQUIRER("ACQUIRER"),
    
    ADMINISTRATOR("ADMINISTRATOR");

    private String value;

    CancellerEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static CancellerEnum fromValue(String value) {
      for (CancellerEnum b : CancellerEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_CANCELLER = "canceller";
  private CancellerEnum canceller;

  /**
   * Reason type.
   */
  public enum CancellationTypeEnum {
    DUPLICATE("DUPLICATE"),
    
    CANCELLATION("CANCELLATION"),
    
    NO_SHOW("NO_SHOW"),
    
    CC_INVALID("CC_INVALID"),
    
    CC_INSUFFICIENT("CC_INSUFFICIENT"),
    
    DISCRETIONARY("DISCRETIONARY");

    private String value;

    CancellationTypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static CancellationTypeEnum fromValue(String value) {
      for (CancellationTypeEnum b : CancellationTypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_CANCELLATION_TYPE = "cancellationType";
  private CancellationTypeEnum cancellationType;

  public static final String JSON_PROPERTY_CANCELLER_USER_IDENTIFIER = "cancellerUserIdentifier";
  private String cancellerUserIdentifier;

  public static final String JSON_PROPERTY_CANCEL_REASON = "cancelReason";
  private String cancelReason;

  public static final String JSON_PROPERTY_FUNDS_PROCESSED = "fundsProcessed";
  private Boolean fundsProcessed;

  public static final String JSON_PROPERTY_REFUNDS = "refunds";
  private List<RefundAffiliate> refunds;

  public static final String JSON_PROPERTY_PAYOUTS = "payouts";
  private List<PayoutAffiliate> payouts;

  public static final String JSON_PROPERTY_SOURCE_CURRENCY = "sourceCurrency";
  private String sourceCurrency;

  public static final String JSON_PROPERTY_DISPLAY_CURRENCY = "displayCurrency";
  private String displayCurrency;

  public static final String JSON_PROPERTY_SUPPLIER_CURRENCY = "supplierCurrency";
  private String supplierCurrency;

  public static final String JSON_PROPERTY_INTERNAL_CURRENCY = "internalCurrency";
  private String internalCurrency;

  public static final String JSON_PROPERTY_CAPTURE_CURRENCY = "captureCurrency";
  private String captureCurrency;

  public static final String JSON_PROPERTY_SOURCE_AMOUNT = "sourceAmount";
  private BigDecimal sourceAmount;

  public static final String JSON_PROPERTY_DISPLAY_AMOUNT = "displayAmount";
  private BigDecimal displayAmount;

  public static final String JSON_PROPERTY_SUPPLIER_AMOUNT = "supplierAmount";
  private BigDecimal supplierAmount;

  public static final String JSON_PROPERTY_INTERNAL_AMOUNT = "internalAmount";
  private BigDecimal internalAmount;

  public static final String JSON_PROPERTY_CAPTURE_AMOUNT = "captureAmount";
  private BigDecimal captureAmount;

  public static final String JSON_PROPERTY_SOURCE_AMOUNT_REFUND_MODIFIER = "sourceAmountRefundModifier";
  private BigDecimal sourceAmountRefundModifier;

  public static final String JSON_PROPERTY_DISPLAY_AMOUNT_REFUND_MODIFIER = "displayAmountRefundModifier";
  private BigDecimal displayAmountRefundModifier;

  public static final String JSON_PROPERTY_SUPPLIER_AMOUNT_REFUND_MODIFIER = "supplierAmountRefundModifier";
  private BigDecimal supplierAmountRefundModifier;

  public static final String JSON_PROPERTY_INTERNAL_AMOUNT_REFUND_MODIFIER = "internalAmountRefundModifier";
  private BigDecimal internalAmountRefundModifier;

  public static final String JSON_PROPERTY_CAPTURE_AMOUNT_REFUND_MODIFIER = "captureAmountRefundModifier";
  private BigDecimal captureAmountRefundModifier;

  public static final String JSON_PROPERTY_NET_SOURCE_AMOUNT = "netSourceAmount";
  private BigDecimal netSourceAmount;

  public static final String JSON_PROPERTY_NET_DISPLAY_AMOUNT = "netDisplayAmount";
  private BigDecimal netDisplayAmount;

  public static final String JSON_PROPERTY_NET_SUPPLIER_AMOUNT = "netSupplierAmount";
  private BigDecimal netSupplierAmount;

  public static final String JSON_PROPERTY_NET_INTERNAL_AMOUNT = "netInternalAmount";
  private BigDecimal netInternalAmount;

  public static final String JSON_PROPERTY_NET_CAPTURE_AMOUNT = "netCaptureAmount";
  private BigDecimal netCaptureAmount;

  public static final String JSON_PROPERTY_TOTAL_TOKENS_EARNED = "totalTokensEarned";
  private Long totalTokensEarned;

  public static final String JSON_PROPERTY_METADATA = "metadata";
  private Map<String, String> metadata = new HashMap<>();

  public static final String JSON_PROPERTY_TOTAL_TRIP_PAY_FEE_IN_PERCENT = "totalTripPayFeeInPercent";
  private Float totalTripPayFeeInPercent;

  public static final String JSON_PROPERTY_HAS_REFUNDS = "hasRefunds";
  private Boolean hasRefunds;

  public static final String JSON_PROPERTY_ORIGINAL_COMMISSIONS_IN_PERCENT = "originalCommissionsInPercent";
  private BigDecimal originalCommissionsInPercent;

  public static final String JSON_PROPERTY_ORIGINAL_FEES_IN_PERCENT = "originalFeesInPercent";
  private BigDecimal originalFeesInPercent;

  public static final String JSON_PROPERTY_TOTAL_COMMISSIONS_IN_PERCENT_WITH_REFUND = "totalCommissionsInPercentWithRefund";
  private Float totalCommissionsInPercentWithRefund;

  public static final String JSON_PROPERTY_TOTAL_FEES_IN_PERCENT_WITH_REFUND = "totalFeesInPercentWithRefund";
  private Float totalFeesInPercentWithRefund;

  public static final String JSON_PROPERTY_TOTAL_TRIP_PAY_FEE_IN_PERCENT_WITH_REFUND = "totalTripPayFeeInPercentWithRefund";
  private Float totalTripPayFeeInPercentWithRefund;

  public static final String JSON_PROPERTY_NET_TOTAL_FEES_SUPPLIER_AMOUNT = "netTotalFeesSupplierAmount";
  private CustomMonetaryAmount netTotalFeesSupplierAmount;

  public static final String JSON_PROPERTY_TOTAL_FEES_SUPPLIER_AMOUNT = "totalFeesSupplierAmount";
  private CustomMonetaryAmount totalFeesSupplierAmount;

  public static final String JSON_PROPERTY_NET_TOTAL_TRIP_PAY_FEE_SUPPLIER_AMOUNT = "netTotalTripPayFeeSupplierAmount";
  private CustomMonetaryAmount netTotalTripPayFeeSupplierAmount;

  public static final String JSON_PROPERTY_TOTAL_TRIP_PAY_FEE_SUPPLIER_AMOUNT = "totalTripPayFeeSupplierAmount";
  private CustomMonetaryAmount totalTripPayFeeSupplierAmount;

  public static final String JSON_PROPERTY_NET_COMMISSIONABLE_TOTAL_SUPPLIER_AMOUNT = "netCommissionableTotalSupplierAmount";
  private CustomMonetaryAmount netCommissionableTotalSupplierAmount;

  public static final String JSON_PROPERTY_COMMISSIONABLE_TOTAL_SUPPLIER_AMOUNT = "commissionableTotalSupplierAmount";
  private CustomMonetaryAmount commissionableTotalSupplierAmount;

  public static final String JSON_PROPERTY_NET_TOTAL_FEES_AND_COMMISSIONS_SUPPLIER_AMOUNT = "netTotalFeesAndCommissionsSupplierAmount";
  private CustomMonetaryAmount netTotalFeesAndCommissionsSupplierAmount;

  public static final String JSON_PROPERTY_TOTAL_FEES_AND_COMMISSIONS_SUPPLIER_AMOUNT = "totalFeesAndCommissionsSupplierAmount";
  private CustomMonetaryAmount totalFeesAndCommissionsSupplierAmount;

  public static final String JSON_PROPERTY_CANCELLABLE_WITH_NO_CHARGES = "cancellableWithNoCharges";
  private Boolean cancellableWithNoCharges;

  public static final String JSON_PROPERTY_IS_CANCELLABLE_WITH_POTENTIAL_CHARGES = "isCancellableWithPotentialCharges";
  private Boolean isCancellableWithPotentialCharges;

  public static final String JSON_PROPERTY_NET_COMMISSIONABLE_TOTAL_SOURCE_AMOUNT = "netCommissionableTotalSourceAmount";
  private CustomMonetaryAmount netCommissionableTotalSourceAmount;

  public static final String JSON_PROPERTY_NET_COMMISSIONABLE_TOTAL_CAPTURE_AMOUNT = "netCommissionableTotalCaptureAmount";
  private CustomMonetaryAmount netCommissionableTotalCaptureAmount;

  public static final String JSON_PROPERTY_NET_COMMISSIONABLE_TOTAL_DISPLAY_AMOUNT = "netCommissionableTotalDisplayAmount";
  private CustomMonetaryAmount netCommissionableTotalDisplayAmount;

  public static final String JSON_PROPERTY_NET_COMMISSIONABLE_TOTAL_INTERNAL_AMOUNT = "netCommissionableTotalInternalAmount";
  private CustomMonetaryAmount netCommissionableTotalInternalAmount;

  public static final String JSON_PROPERTY_NET_TOTAL_FEES_AND_COMMISSIONS_SOURCE_AMOUNT = "netTotalFeesAndCommissionsSourceAmount";
  private CustomMonetaryAmount netTotalFeesAndCommissionsSourceAmount;

  public static final String JSON_PROPERTY_NET_TOTAL_FEES_AND_COMMISSIONS_CAPTURE_AMOUNT = "netTotalFeesAndCommissionsCaptureAmount";
  private CustomMonetaryAmount netTotalFeesAndCommissionsCaptureAmount;

  public static final String JSON_PROPERTY_NET_TOTAL_FEES_AND_COMMISSIONS_DISPLAY_AMOUNT = "netTotalFeesAndCommissionsDisplayAmount";
  private CustomMonetaryAmount netTotalFeesAndCommissionsDisplayAmount;

  public static final String JSON_PROPERTY_NET_TOTAL_FEES_AND_COMMISSIONS_INTERNAL_AMOUNT = "netTotalFeesAndCommissionsInternalAmount";
  private CustomMonetaryAmount netTotalFeesAndCommissionsInternalAmount;

  public static final String JSON_PROPERTY_NET_TOTAL_FEES_SOURCE_AMOUNT = "netTotalFeesSourceAmount";
  private CustomMonetaryAmount netTotalFeesSourceAmount;

  public static final String JSON_PROPERTY_NET_TOTAL_FEES_CAPTURE_AMOUNT = "netTotalFeesCaptureAmount";
  private CustomMonetaryAmount netTotalFeesCaptureAmount;

  public static final String JSON_PROPERTY_NET_TOTAL_FEES_DISPLAY_AMOUNT = "netTotalFeesDisplayAmount";
  private CustomMonetaryAmount netTotalFeesDisplayAmount;

  public static final String JSON_PROPERTY_NET_TOTAL_FEES_INTERNAL_AMOUNT = "netTotalFeesInternalAmount";
  private CustomMonetaryAmount netTotalFeesInternalAmount;

  public static final String JSON_PROPERTY_NET_TOTAL_TRIP_PAY_FEE_SOURCE_AMOUNT = "netTotalTripPayFeeSourceAmount";
  private CustomMonetaryAmount netTotalTripPayFeeSourceAmount;

  public static final String JSON_PROPERTY_NET_TOTAL_TRIP_PAY_FEE_CAPTURE_AMOUNT = "netTotalTripPayFeeCaptureAmount";
  private CustomMonetaryAmount netTotalTripPayFeeCaptureAmount;

  public static final String JSON_PROPERTY_NET_TOTAL_TRIP_PAY_FEE_DISPLAY_AMOUNT = "netTotalTripPayFeeDisplayAmount";
  private CustomMonetaryAmount netTotalTripPayFeeDisplayAmount;

  public static final String JSON_PROPERTY_NET_TOTAL_TRIP_PAY_FEE_INTERNAL_AMOUNT = "netTotalTripPayFeeInternalAmount";
  private CustomMonetaryAmount netTotalTripPayFeeInternalAmount;

  public static final String JSON_PROPERTY_NET_TOTAL_SALES_SOURCE_AMOUNT = "netTotalSalesSourceAmount";
  private CustomMonetaryAmount netTotalSalesSourceAmount;

  public static final String JSON_PROPERTY_NET_TOTAL_SALES_CAPTURE_AMOUNT = "netTotalSalesCaptureAmount";
  private CustomMonetaryAmount netTotalSalesCaptureAmount;

  public static final String JSON_PROPERTY_NET_TOTAL_SALES_DISPLAY_AMOUNT = "netTotalSalesDisplayAmount";
  private CustomMonetaryAmount netTotalSalesDisplayAmount;

  public static final String JSON_PROPERTY_NET_TOTAL_SALES_SUPPLIER_AMOUNT = "netTotalSalesSupplierAmount";
  private CustomMonetaryAmount netTotalSalesSupplierAmount;

  public static final String JSON_PROPERTY_NET_TOTAL_SALES_INTERNAL_AMOUNT = "netTotalSalesInternalAmount";
  private CustomMonetaryAmount netTotalSalesInternalAmount;

  public static final String JSON_PROPERTY_COMMISSIONABLE_TOTAL_SOURCE_AMOUNT = "commissionableTotalSourceAmount";
  private CustomMonetaryAmount commissionableTotalSourceAmount;

  public static final String JSON_PROPERTY_COMMISSIONABLE_TOTAL_CAPTURE_AMOUNT = "commissionableTotalCaptureAmount";
  private CustomMonetaryAmount commissionableTotalCaptureAmount;

  public static final String JSON_PROPERTY_COMMISSIONABLE_TOTAL_DISPLAY_AMOUNT = "commissionableTotalDisplayAmount";
  private CustomMonetaryAmount commissionableTotalDisplayAmount;

  public static final String JSON_PROPERTY_COMMISSIONABLE_TOTAL_INTERNAL_AMOUNT = "commissionableTotalInternalAmount";
  private CustomMonetaryAmount commissionableTotalInternalAmount;

  public static final String JSON_PROPERTY_TOTAL_FEES_AND_COMMISSIONS_SOURCE_AMOUNT = "totalFeesAndCommissionsSourceAmount";
  private CustomMonetaryAmount totalFeesAndCommissionsSourceAmount;

  public static final String JSON_PROPERTY_TOTAL_FEES_AND_COMMISSIONS_CAPTURE_AMOUNT = "totalFeesAndCommissionsCaptureAmount";
  private CustomMonetaryAmount totalFeesAndCommissionsCaptureAmount;

  public static final String JSON_PROPERTY_TOTAL_FEES_AND_COMMISSIONS_DISPLAY_AMOUNT = "totalFeesAndCommissionsDisplayAmount";
  private CustomMonetaryAmount totalFeesAndCommissionsDisplayAmount;

  public static final String JSON_PROPERTY_TOTAL_FEES_AND_COMMISSIONS_INTERNAL_AMOUNT = "totalFeesAndCommissionsInternalAmount";
  private CustomMonetaryAmount totalFeesAndCommissionsInternalAmount;

  public static final String JSON_PROPERTY_TOTAL_FEES_SOURCE_AMOUNT = "totalFeesSourceAmount";
  private CustomMonetaryAmount totalFeesSourceAmount;

  public static final String JSON_PROPERTY_TOTAL_FEES_CAPTURE_AMOUNT = "totalFeesCaptureAmount";
  private CustomMonetaryAmount totalFeesCaptureAmount;

  public static final String JSON_PROPERTY_TOTAL_FEES_DISPLAY_AMOUNT = "totalFeesDisplayAmount";
  private CustomMonetaryAmount totalFeesDisplayAmount;

  public static final String JSON_PROPERTY_TOTAL_FEES_INTERNAL_AMOUNT = "totalFeesInternalAmount";
  private CustomMonetaryAmount totalFeesInternalAmount;

  public static final String JSON_PROPERTY_TOTAL_TRIP_PAY_FEE_SOURCE_AMOUNT = "totalTripPayFeeSourceAmount";
  private CustomMonetaryAmount totalTripPayFeeSourceAmount;

  public static final String JSON_PROPERTY_TOTAL_TRIP_PAY_FEE_CAPTURE_AMOUNT = "totalTripPayFeeCaptureAmount";
  private CustomMonetaryAmount totalTripPayFeeCaptureAmount;

  public static final String JSON_PROPERTY_TOTAL_TRIP_PAY_FEE_DISPLAY_AMOUNT = "totalTripPayFeeDisplayAmount";
  private CustomMonetaryAmount totalTripPayFeeDisplayAmount;

  public static final String JSON_PROPERTY_TOTAL_TRIP_PAY_FEE_INTERNAL_AMOUNT = "totalTripPayFeeInternalAmount";
  private CustomMonetaryAmount totalTripPayFeeInternalAmount;

  public static final String JSON_PROPERTY_TOTAL_SALES_SOURCE_AMOUNT = "totalSalesSourceAmount";
  private CustomMonetaryAmount totalSalesSourceAmount;

  public static final String JSON_PROPERTY_TOTAL_SALES_CAPTURE_AMOUNT = "totalSalesCaptureAmount";
  private CustomMonetaryAmount totalSalesCaptureAmount;

  public static final String JSON_PROPERTY_TOTAL_SALES_DISPLAY_AMOUNT = "totalSalesDisplayAmount";
  private CustomMonetaryAmount totalSalesDisplayAmount;

  public static final String JSON_PROPERTY_TOTAL_SALES_SUPPLIER_AMOUNT = "totalSalesSupplierAmount";
  private CustomMonetaryAmount totalSalesSupplierAmount;

  public static final String JSON_PROPERTY_TOTAL_SALES_INTERNAL_AMOUNT = "totalSalesInternalAmount";
  private CustomMonetaryAmount totalSalesInternalAmount;

  public static final String JSON_PROPERTY_FUNDS_AVAILABLE_DATE = "fundsAvailableDate";
  private LocalDate fundsAvailableDate;

  public static final String JSON_PROPERTY_TOTAL_FEES_IN_PERCENT = "totalFeesInPercent";
  private Float totalFeesInPercent;

  public static final String JSON_PROPERTY_TOTAL_COMMISSIONS_IN_PERCENT = "totalCommissionsInPercent";
  private Float totalCommissionsInPercent;

  public static final String JSON_PROPERTY_TOTAL_FEES_AND_COMMISSIONS_IN_PERCENT_WITH_REFUND = "totalFeesAndCommissionsInPercentWithRefund";
  private Float totalFeesAndCommissionsInPercentWithRefund;

  public static final String JSON_PROPERTY_TOTAL_FEES_AND_COMMISSIONS_IN_PERCENT = "totalFeesAndCommissionsInPercent";
  private Float totalFeesAndCommissionsInPercent;

  public static final String JSON_PROPERTY_NET_TOTAL_CUSTOMERS_SOURCE_AMOUNT = "netTotalCustomersSourceAmount";
  private CustomMonetaryAmount netTotalCustomersSourceAmount;

  public static final String JSON_PROPERTY_NET_TOTAL_CUSTOMERS_CAPTURE_AMOUNT = "netTotalCustomersCaptureAmount";
  private CustomMonetaryAmount netTotalCustomersCaptureAmount;

  public static final String JSON_PROPERTY_NET_TOTAL_CUSTOMERS_DISPLAY_AMOUNT = "netTotalCustomersDisplayAmount";
  private CustomMonetaryAmount netTotalCustomersDisplayAmount;

  public static final String JSON_PROPERTY_NET_TOTAL_CUSTOMERS_SUPPLIER_AMOUNT = "netTotalCustomersSupplierAmount";
  private CustomMonetaryAmount netTotalCustomersSupplierAmount;

  public static final String JSON_PROPERTY_NET_TOTAL_CUSTOMERS_INTERNAL_AMOUNT = "netTotalCustomersInternalAmount";
  private CustomMonetaryAmount netTotalCustomersInternalAmount;

  public static final String JSON_PROPERTY_HAS_SUCCESSFUL_REFUNDS = "hasSuccessfulRefunds";
  private Boolean hasSuccessfulRefunds;

  public static final String JSON_PROPERTY_HAS_PENDING_REFUNDS = "hasPendingRefunds";
  private Boolean hasPendingRefunds;

  public static final String JSON_PROPERTY_HAS_FAILED_REFUNDS = "hasFailedRefunds";
  private Boolean hasFailedRefunds;

  public static final String JSON_PROPERTY_LODGING = "lodging";
  private BookingContractItemAffiliate lodging;

  public static final String JSON_PROPERTY_CANCELLABLE_BY_SUPPLIER = "cancellableBySupplier";
  private Boolean cancellableBySupplier;

  public static final String JSON_PROPERTY_CANCELLABLE_BY_TRAVELER = "cancellableByTraveler";
  private Boolean cancellableByTraveler;

  public BookingContractAffiliate() {
  }

  public BookingContractAffiliate bookingContractIdentifier(UUID bookingContractIdentifier) {
    
    this.bookingContractIdentifier = bookingContractIdentifier;
    return this;
  }

   /**
   * Document UUID
   * @return bookingContractIdentifier
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_BOOKING_CONTRACT_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public UUID getBookingContractIdentifier() {
    return bookingContractIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_BOOKING_CONTRACT_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setBookingContractIdentifier(UUID bookingContractIdentifier) {
    this.bookingContractIdentifier = bookingContractIdentifier;
  }


  public BookingContractAffiliate createdDate(java.time.LocalDateTime createdDate) {
    
    this.createdDate = createdDate;
    return this;
  }

   /**
   * Datetime this record was first created
   * @return createdDate
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_CREATED_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public java.time.LocalDateTime getCreatedDate() {
    return createdDate;
  }


  @JsonProperty(JSON_PROPERTY_CREATED_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCreatedDate(java.time.LocalDateTime createdDate) {
    this.createdDate = createdDate;
  }


  public BookingContractAffiliate lastUpdate(java.time.LocalDateTime lastUpdate) {
    
    this.lastUpdate = lastUpdate;
    return this;
  }

   /**
   * Datetime this record was last updated
   * @return lastUpdate
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_LAST_UPDATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public java.time.LocalDateTime getLastUpdate() {
    return lastUpdate;
  }


  @JsonProperty(JSON_PROPERTY_LAST_UPDATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLastUpdate(java.time.LocalDateTime lastUpdate) {
    this.lastUpdate = lastUpdate;
  }


  public BookingContractAffiliate federatedOrganizationIdentifier(String federatedOrganizationIdentifier) {
    
    this.federatedOrganizationIdentifier = federatedOrganizationIdentifier;
    return this;
  }

   /**
   * The auth realm owner ID
   * @return federatedOrganizationIdentifier
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_FEDERATED_ORGANIZATION_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getFederatedOrganizationIdentifier() {
    return federatedOrganizationIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_FEDERATED_ORGANIZATION_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFederatedOrganizationIdentifier(String federatedOrganizationIdentifier) {
    this.federatedOrganizationIdentifier = federatedOrganizationIdentifier;
  }


  public BookingContractAffiliate federatedOrganizationName(String federatedOrganizationName) {
    
    this.federatedOrganizationName = federatedOrganizationName;
    return this;
  }

   /**
   * The auth realm owner name
   * @return federatedOrganizationName
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_FEDERATED_ORGANIZATION_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getFederatedOrganizationName() {
    return federatedOrganizationName;
  }


  @JsonProperty(JSON_PROPERTY_FEDERATED_ORGANIZATION_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFederatedOrganizationName(String federatedOrganizationName) {
    this.federatedOrganizationName = federatedOrganizationName;
  }


  public BookingContractAffiliate user(AuthenticatedUserAffiliate user) {
    
    this.user = user;
    return this;
  }

   /**
   * Get user
   * @return user
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_USER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public AuthenticatedUserAffiliate getUser() {
    return user;
  }


  @JsonProperty(JSON_PROPERTY_USER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setUser(AuthenticatedUserAffiliate user) {
    this.user = user;
  }


  public BookingContractAffiliate ipAddress(String ipAddress) {
    
    this.ipAddress = ipAddress;
    return this;
  }

   /**
   * Caller&#39;s IP address
   * @return ipAddress
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_IP_ADDRESS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getIpAddress() {
    return ipAddress;
  }


  @JsonProperty(JSON_PROPERTY_IP_ADDRESS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIpAddress(String ipAddress) {
    this.ipAddress = ipAddress;
  }


  public BookingContractAffiliate traceId(String traceId) {
    
    this.traceId = traceId;
    return this;
  }

   /**
   * Way to track which booking contracts were made together
   * @return traceId
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_TRACE_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getTraceId() {
    return traceId;
  }


  @JsonProperty(JSON_PROPERTY_TRACE_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTraceId(String traceId) {
    this.traceId = traceId;
  }


  public BookingContractAffiliate sourceUrl(String sourceUrl) {
    
    this.sourceUrl = sourceUrl;
    return this;
  }

   /**
   * Where did the booking occur
   * @return sourceUrl
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_SOURCE_URL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getSourceUrl() {
    return sourceUrl;
  }


  @JsonProperty(JSON_PROPERTY_SOURCE_URL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSourceUrl(String sourceUrl) {
    this.sourceUrl = sourceUrl;
  }


  public BookingContractAffiliate identifier(UUID identifier) {
    
    this.identifier = identifier;
    return this;
  }

   /**
   * Unique identifier used to track the contract. Create a UUID for this purpose.
   * @return identifier
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public UUID getIdentifier() {
    return identifier;
  }


  @JsonProperty(JSON_PROPERTY_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIdentifier(UUID identifier) {
    this.identifier = identifier;
  }


  public BookingContractAffiliate supplierIdentifier(UUID supplierIdentifier) {
    
    this.supplierIdentifier = supplierIdentifier;
    return this;
  }

   /**
   * Supplier identifier
   * @return supplierIdentifier
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_SUPPLIER_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public UUID getSupplierIdentifier() {
    return supplierIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_SUPPLIER_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSupplierIdentifier(UUID supplierIdentifier) {
    this.supplierIdentifier = supplierIdentifier;
  }


  public BookingContractAffiliate supplierName(String supplierName) {
    
    this.supplierName = supplierName;
    return this;
  }

   /**
   * Supplier name
   * @return supplierName
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_SUPPLIER_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getSupplierName() {
    return supplierName;
  }


  @JsonProperty(JSON_PROPERTY_SUPPLIER_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSupplierName(String supplierName) {
    this.supplierName = supplierName;
  }


  public BookingContractAffiliate displayPriceQuote(QuoteAffiliate displayPriceQuote) {
    
    this.displayPriceQuote = displayPriceQuote;
    return this;
  }

   /**
   * Get displayPriceQuote
   * @return displayPriceQuote
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_DISPLAY_PRICE_QUOTE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public QuoteAffiliate getDisplayPriceQuote() {
    return displayPriceQuote;
  }


  @JsonProperty(JSON_PROPERTY_DISPLAY_PRICE_QUOTE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDisplayPriceQuote(QuoteAffiliate displayPriceQuote) {
    this.displayPriceQuote = displayPriceQuote;
  }


  public BookingContractAffiliate supplierPriceQuote(QuoteAffiliate supplierPriceQuote) {
    
    this.supplierPriceQuote = supplierPriceQuote;
    return this;
  }

   /**
   * Get supplierPriceQuote
   * @return supplierPriceQuote
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_SUPPLIER_PRICE_QUOTE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public QuoteAffiliate getSupplierPriceQuote() {
    return supplierPriceQuote;
  }


  @JsonProperty(JSON_PROPERTY_SUPPLIER_PRICE_QUOTE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSupplierPriceQuote(QuoteAffiliate supplierPriceQuote) {
    this.supplierPriceQuote = supplierPriceQuote;
  }


  public BookingContractAffiliate internalPriceQuote(QuoteAffiliate internalPriceQuote) {
    
    this.internalPriceQuote = internalPriceQuote;
    return this;
  }

   /**
   * Get internalPriceQuote
   * @return internalPriceQuote
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_INTERNAL_PRICE_QUOTE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public QuoteAffiliate getInternalPriceQuote() {
    return internalPriceQuote;
  }


  @JsonProperty(JSON_PROPERTY_INTERNAL_PRICE_QUOTE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setInternalPriceQuote(QuoteAffiliate internalPriceQuote) {
    this.internalPriceQuote = internalPriceQuote;
  }


  public BookingContractAffiliate capturePriceQuote(QuoteAffiliate capturePriceQuote) {
    
    this.capturePriceQuote = capturePriceQuote;
    return this;
  }

   /**
   * Get capturePriceQuote
   * @return capturePriceQuote
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_CAPTURE_PRICE_QUOTE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public QuoteAffiliate getCapturePriceQuote() {
    return capturePriceQuote;
  }


  @JsonProperty(JSON_PROPERTY_CAPTURE_PRICE_QUOTE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCapturePriceQuote(QuoteAffiliate capturePriceQuote) {
    this.capturePriceQuote = capturePriceQuote;
  }


  public BookingContractAffiliate itemList(List<BookingContractItemAffiliate> itemList) {
    
    this.itemList = itemList;
    return this;
  }

  public BookingContractAffiliate addItemListItem(BookingContractItemAffiliate itemListItem) {
    if (this.itemList == null) {
      this.itemList = new ArrayList<>();
    }
    this.itemList.add(itemListItem);
    return this;
  }

   /**
   * Holds one booking line item for a specific supplier.
   * @return itemList
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_ITEM_LIST)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<BookingContractItemAffiliate> getItemList() {
    return itemList;
  }


  @JsonProperty(JSON_PROPERTY_ITEM_LIST)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setItemList(List<BookingContractItemAffiliate> itemList) {
    this.itemList = itemList;
  }


  public BookingContractAffiliate externalSupplierIdentifier(String externalSupplierIdentifier) {
    
    this.externalSupplierIdentifier = externalSupplierIdentifier;
    return this;
  }

   /**
   * Contract creator can choose to geoname this record with her own identifier
   * @return externalSupplierIdentifier
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_EXTERNAL_SUPPLIER_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getExternalSupplierIdentifier() {
    return externalSupplierIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_EXTERNAL_SUPPLIER_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setExternalSupplierIdentifier(String externalSupplierIdentifier) {
    this.externalSupplierIdentifier = externalSupplierIdentifier;
  }


  public BookingContractAffiliate externalSupplierBookingCode(String externalSupplierBookingCode) {
    
    this.externalSupplierBookingCode = externalSupplierBookingCode;
    return this;
  }

   /**
   * External booking code generated by the affiliate
   * @return externalSupplierBookingCode
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_EXTERNAL_SUPPLIER_BOOKING_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getExternalSupplierBookingCode() {
    return externalSupplierBookingCode;
  }


  @JsonProperty(JSON_PROPERTY_EXTERNAL_SUPPLIER_BOOKING_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setExternalSupplierBookingCode(String externalSupplierBookingCode) {
    this.externalSupplierBookingCode = externalSupplierBookingCode;
  }


  public BookingContractAffiliate payment(BookingContractPaymentDetailsAffiliate payment) {
    
    this.payment = payment;
    return this;
  }

   /**
   * Get payment
   * @return payment
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_PAYMENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public BookingContractPaymentDetailsAffiliate getPayment() {
    return payment;
  }


  @JsonProperty(JSON_PROPERTY_PAYMENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPayment(BookingContractPaymentDetailsAffiliate payment) {
    this.payment = payment;
  }


  public BookingContractAffiliate cancelled(Boolean cancelled) {
    
    this.cancelled = cancelled;
    return this;
  }

   /**
   * Optional geoname externalIdentifier to remote inventory.
   * @return cancelled
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_CANCELLED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getCancelled() {
    return cancelled;
  }


  @JsonProperty(JSON_PROPERTY_CANCELLED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCancelled(Boolean cancelled) {
    this.cancelled = cancelled;
  }


  public BookingContractAffiliate cancelledOn(java.time.LocalDateTime cancelledOn) {
    
    this.cancelledOn = cancelledOn;
    return this;
  }

   /**
   * When the booking was cancelled.
   * @return cancelledOn
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_CANCELLED_ON)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public java.time.LocalDateTime getCancelledOn() {
    return cancelledOn;
  }


  @JsonProperty(JSON_PROPERTY_CANCELLED_ON)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCancelledOn(java.time.LocalDateTime cancelledOn) {
    this.cancelledOn = cancelledOn;
  }


  public BookingContractAffiliate canceller(CancellerEnum canceller) {
    
    this.canceller = canceller;
    return this;
  }

   /**
   * Type of entity that cancelled the booking.
   * @return canceller
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_CANCELLER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CancellerEnum getCanceller() {
    return canceller;
  }


  @JsonProperty(JSON_PROPERTY_CANCELLER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCanceller(CancellerEnum canceller) {
    this.canceller = canceller;
  }


  public BookingContractAffiliate cancellationType(CancellationTypeEnum cancellationType) {
    
    this.cancellationType = cancellationType;
    return this;
  }

   /**
   * Reason type.
   * @return cancellationType
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_CANCELLATION_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CancellationTypeEnum getCancellationType() {
    return cancellationType;
  }


  @JsonProperty(JSON_PROPERTY_CANCELLATION_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCancellationType(CancellationTypeEnum cancellationType) {
    this.cancellationType = cancellationType;
  }


  public BookingContractAffiliate cancellerUserIdentifier(String cancellerUserIdentifier) {
    
    this.cancellerUserIdentifier = cancellerUserIdentifier;
    return this;
  }

   /**
   * User identifier that cancelled the entity.
   * @return cancellerUserIdentifier
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_CANCELLER_USER_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getCancellerUserIdentifier() {
    return cancellerUserIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_CANCELLER_USER_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCancellerUserIdentifier(String cancellerUserIdentifier) {
    this.cancellerUserIdentifier = cancellerUserIdentifier;
  }


  public BookingContractAffiliate cancelReason(String cancelReason) {
    
    this.cancelReason = cancelReason;
    return this;
  }

   /**
   * Reason for cancellation.
   * @return cancelReason
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_CANCEL_REASON)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getCancelReason() {
    return cancelReason;
  }


  @JsonProperty(JSON_PROPERTY_CANCEL_REASON)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCancelReason(String cancelReason) {
    this.cancelReason = cancelReason;
  }


  public BookingContractAffiliate fundsProcessed(Boolean fundsProcessed) {
    
    this.fundsProcessed = fundsProcessed;
    return this;
  }

   /**
   * Whether a funds transfer request has been created for this booking.
   * @return fundsProcessed
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_FUNDS_PROCESSED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getFundsProcessed() {
    return fundsProcessed;
  }


  @JsonProperty(JSON_PROPERTY_FUNDS_PROCESSED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFundsProcessed(Boolean fundsProcessed) {
    this.fundsProcessed = fundsProcessed;
  }


  public BookingContractAffiliate refunds(List<RefundAffiliate> refunds) {
    
    this.refunds = refunds;
    return this;
  }

  public BookingContractAffiliate addRefundsItem(RefundAffiliate refundsItem) {
    if (this.refunds == null) {
      this.refunds = new ArrayList<>();
    }
    this.refunds.add(refundsItem);
    return this;
  }

   /**
   * An optional list of refunds that occurred with this booking. If the refund amount(s) is the same as the total price, the booking also gets cancelled.
   * @return refunds
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_REFUNDS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<RefundAffiliate> getRefunds() {
    return refunds;
  }


  @JsonProperty(JSON_PROPERTY_REFUNDS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRefunds(List<RefundAffiliate> refunds) {
    this.refunds = refunds;
  }


  public BookingContractAffiliate payouts(List<PayoutAffiliate> payouts) {
    
    this.payouts = payouts;
    return this;
  }

  public BookingContractAffiliate addPayoutsItem(PayoutAffiliate payoutsItem) {
    if (this.payouts == null) {
      this.payouts = new ArrayList<>();
    }
    this.payouts.add(payoutsItem);
    return this;
  }

   /**
   * An optional list of refunds that occurred with this booking. If the refund amount(s) is the same as the total price, the booking also gets cancelled.
   * @return payouts
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_PAYOUTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<PayoutAffiliate> getPayouts() {
    return payouts;
  }


  @JsonProperty(JSON_PROPERTY_PAYOUTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPayouts(List<PayoutAffiliate> payouts) {
    this.payouts = payouts;
  }


  public BookingContractAffiliate sourceCurrency(String sourceCurrency) {
    
    this.sourceCurrency = sourceCurrency;
    return this;
  }

   /**
   * The source currency
   * @return sourceCurrency
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_SOURCE_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getSourceCurrency() {
    return sourceCurrency;
  }


  @JsonProperty(JSON_PROPERTY_SOURCE_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSourceCurrency(String sourceCurrency) {
    this.sourceCurrency = sourceCurrency;
  }


  public BookingContractAffiliate displayCurrency(String displayCurrency) {
    
    this.displayCurrency = displayCurrency;
    return this;
  }

   /**
   * The display currency
   * @return displayCurrency
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_DISPLAY_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getDisplayCurrency() {
    return displayCurrency;
  }


  @JsonProperty(JSON_PROPERTY_DISPLAY_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDisplayCurrency(String displayCurrency) {
    this.displayCurrency = displayCurrency;
  }


  public BookingContractAffiliate supplierCurrency(String supplierCurrency) {
    
    this.supplierCurrency = supplierCurrency;
    return this;
  }

   /**
   * The supplier currency
   * @return supplierCurrency
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_SUPPLIER_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getSupplierCurrency() {
    return supplierCurrency;
  }


  @JsonProperty(JSON_PROPERTY_SUPPLIER_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSupplierCurrency(String supplierCurrency) {
    this.supplierCurrency = supplierCurrency;
  }


  public BookingContractAffiliate internalCurrency(String internalCurrency) {
    
    this.internalCurrency = internalCurrency;
    return this;
  }

   /**
   * The internal currency
   * @return internalCurrency
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_INTERNAL_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getInternalCurrency() {
    return internalCurrency;
  }


  @JsonProperty(JSON_PROPERTY_INTERNAL_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setInternalCurrency(String internalCurrency) {
    this.internalCurrency = internalCurrency;
  }


  public BookingContractAffiliate captureCurrency(String captureCurrency) {
    
    this.captureCurrency = captureCurrency;
    return this;
  }

   /**
   * The capture currency
   * @return captureCurrency
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_CAPTURE_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getCaptureCurrency() {
    return captureCurrency;
  }


  @JsonProperty(JSON_PROPERTY_CAPTURE_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCaptureCurrency(String captureCurrency) {
    this.captureCurrency = captureCurrency;
  }


  public BookingContractAffiliate sourceAmount(BigDecimal sourceAmount) {
    
    this.sourceAmount = sourceAmount;
    return this;
  }

   /**
   * The total initial price as quoted in the original TripPay contract.
   * @return sourceAmount
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_SOURCE_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public BigDecimal getSourceAmount() {
    return sourceAmount;
  }


  @JsonProperty(JSON_PROPERTY_SOURCE_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSourceAmount(BigDecimal sourceAmount) {
    this.sourceAmount = sourceAmount;
  }


  public BookingContractAffiliate displayAmount(BigDecimal displayAmount) {
    
    this.displayAmount = displayAmount;
    return this;
  }

   /**
   * The total display price.
   * @return displayAmount
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_DISPLAY_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public BigDecimal getDisplayAmount() {
    return displayAmount;
  }


  @JsonProperty(JSON_PROPERTY_DISPLAY_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDisplayAmount(BigDecimal displayAmount) {
    this.displayAmount = displayAmount;
  }


  public BookingContractAffiliate supplierAmount(BigDecimal supplierAmount) {
    
    this.supplierAmount = supplierAmount;
    return this;
  }

   /**
   * The total supplier price.
   * @return supplierAmount
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_SUPPLIER_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public BigDecimal getSupplierAmount() {
    return supplierAmount;
  }


  @JsonProperty(JSON_PROPERTY_SUPPLIER_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSupplierAmount(BigDecimal supplierAmount) {
    this.supplierAmount = supplierAmount;
  }


  public BookingContractAffiliate internalAmount(BigDecimal internalAmount) {
    
    this.internalAmount = internalAmount;
    return this;
  }

   /**
   * Get internalAmount
   * @return internalAmount
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_INTERNAL_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public BigDecimal getInternalAmount() {
    return internalAmount;
  }


  @JsonProperty(JSON_PROPERTY_INTERNAL_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setInternalAmount(BigDecimal internalAmount) {
    this.internalAmount = internalAmount;
  }


  public BookingContractAffiliate captureAmount(BigDecimal captureAmount) {
    
    this.captureAmount = captureAmount;
    return this;
  }

   /**
   * The total capture price.
   * @return captureAmount
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_CAPTURE_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public BigDecimal getCaptureAmount() {
    return captureAmount;
  }


  @JsonProperty(JSON_PROPERTY_CAPTURE_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCaptureAmount(BigDecimal captureAmount) {
    this.captureAmount = captureAmount;
  }


  public BookingContractAffiliate sourceAmountRefundModifier(BigDecimal sourceAmountRefundModifier) {
    
    this.sourceAmountRefundModifier = sourceAmountRefundModifier;
    return this;
  }

   /**
   * The source amount still due after a partial refund occurs.
   * @return sourceAmountRefundModifier
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_SOURCE_AMOUNT_REFUND_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public BigDecimal getSourceAmountRefundModifier() {
    return sourceAmountRefundModifier;
  }


  @JsonProperty(JSON_PROPERTY_SOURCE_AMOUNT_REFUND_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSourceAmountRefundModifier(BigDecimal sourceAmountRefundModifier) {
    this.sourceAmountRefundModifier = sourceAmountRefundModifier;
  }


  public BookingContractAffiliate displayAmountRefundModifier(BigDecimal displayAmountRefundModifier) {
    
    this.displayAmountRefundModifier = displayAmountRefundModifier;
    return this;
  }

   /**
   * The display amount still due after a partial refund occurs.
   * @return displayAmountRefundModifier
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_DISPLAY_AMOUNT_REFUND_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public BigDecimal getDisplayAmountRefundModifier() {
    return displayAmountRefundModifier;
  }


  @JsonProperty(JSON_PROPERTY_DISPLAY_AMOUNT_REFUND_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDisplayAmountRefundModifier(BigDecimal displayAmountRefundModifier) {
    this.displayAmountRefundModifier = displayAmountRefundModifier;
  }


  public BookingContractAffiliate supplierAmountRefundModifier(BigDecimal supplierAmountRefundModifier) {
    
    this.supplierAmountRefundModifier = supplierAmountRefundModifier;
    return this;
  }

   /**
   * The supplier amount still due after a partial refund occurs.
   * @return supplierAmountRefundModifier
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_SUPPLIER_AMOUNT_REFUND_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public BigDecimal getSupplierAmountRefundModifier() {
    return supplierAmountRefundModifier;
  }


  @JsonProperty(JSON_PROPERTY_SUPPLIER_AMOUNT_REFUND_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSupplierAmountRefundModifier(BigDecimal supplierAmountRefundModifier) {
    this.supplierAmountRefundModifier = supplierAmountRefundModifier;
  }


  public BookingContractAffiliate internalAmountRefundModifier(BigDecimal internalAmountRefundModifier) {
    
    this.internalAmountRefundModifier = internalAmountRefundModifier;
    return this;
  }

   /**
   * The internal amount still due after a partial refund occurs.
   * @return internalAmountRefundModifier
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_INTERNAL_AMOUNT_REFUND_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public BigDecimal getInternalAmountRefundModifier() {
    return internalAmountRefundModifier;
  }


  @JsonProperty(JSON_PROPERTY_INTERNAL_AMOUNT_REFUND_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setInternalAmountRefundModifier(BigDecimal internalAmountRefundModifier) {
    this.internalAmountRefundModifier = internalAmountRefundModifier;
  }


  public BookingContractAffiliate captureAmountRefundModifier(BigDecimal captureAmountRefundModifier) {
    
    this.captureAmountRefundModifier = captureAmountRefundModifier;
    return this;
  }

   /**
   * The capture amount still due after a partial refund occurs.
   * @return captureAmountRefundModifier
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_CAPTURE_AMOUNT_REFUND_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public BigDecimal getCaptureAmountRefundModifier() {
    return captureAmountRefundModifier;
  }


  @JsonProperty(JSON_PROPERTY_CAPTURE_AMOUNT_REFUND_MODIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCaptureAmountRefundModifier(BigDecimal captureAmountRefundModifier) {
    this.captureAmountRefundModifier = captureAmountRefundModifier;
  }


  public BookingContractAffiliate netSourceAmount(BigDecimal netSourceAmount) {
    
    this.netSourceAmount = netSourceAmount;
    return this;
  }

   /**
   * The total initial price as quoted in the original TripPay contract.
   * @return netSourceAmount
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_NET_SOURCE_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public BigDecimal getNetSourceAmount() {
    return netSourceAmount;
  }


  @JsonProperty(JSON_PROPERTY_NET_SOURCE_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setNetSourceAmount(BigDecimal netSourceAmount) {
    this.netSourceAmount = netSourceAmount;
  }


  public BookingContractAffiliate netDisplayAmount(BigDecimal netDisplayAmount) {
    
    this.netDisplayAmount = netDisplayAmount;
    return this;
  }

   /**
   * The total display price.
   * @return netDisplayAmount
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_NET_DISPLAY_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public BigDecimal getNetDisplayAmount() {
    return netDisplayAmount;
  }


  @JsonProperty(JSON_PROPERTY_NET_DISPLAY_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setNetDisplayAmount(BigDecimal netDisplayAmount) {
    this.netDisplayAmount = netDisplayAmount;
  }


  public BookingContractAffiliate netSupplierAmount(BigDecimal netSupplierAmount) {
    
    this.netSupplierAmount = netSupplierAmount;
    return this;
  }

   /**
   * The total supplier price.
   * @return netSupplierAmount
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_NET_SUPPLIER_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public BigDecimal getNetSupplierAmount() {
    return netSupplierAmount;
  }


  @JsonProperty(JSON_PROPERTY_NET_SUPPLIER_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setNetSupplierAmount(BigDecimal netSupplierAmount) {
    this.netSupplierAmount = netSupplierAmount;
  }


  public BookingContractAffiliate netInternalAmount(BigDecimal netInternalAmount) {
    
    this.netInternalAmount = netInternalAmount;
    return this;
  }

   /**
   * Get netInternalAmount
   * @return netInternalAmount
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_NET_INTERNAL_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public BigDecimal getNetInternalAmount() {
    return netInternalAmount;
  }


  @JsonProperty(JSON_PROPERTY_NET_INTERNAL_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setNetInternalAmount(BigDecimal netInternalAmount) {
    this.netInternalAmount = netInternalAmount;
  }


  public BookingContractAffiliate netCaptureAmount(BigDecimal netCaptureAmount) {
    
    this.netCaptureAmount = netCaptureAmount;
    return this;
  }

   /**
   * The total capture price.
   * @return netCaptureAmount
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_NET_CAPTURE_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public BigDecimal getNetCaptureAmount() {
    return netCaptureAmount;
  }


  @JsonProperty(JSON_PROPERTY_NET_CAPTURE_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setNetCaptureAmount(BigDecimal netCaptureAmount) {
    this.netCaptureAmount = netCaptureAmount;
  }


  public BookingContractAffiliate totalTokensEarned(Long totalTokensEarned) {
    
    this.totalTokensEarned = totalTokensEarned;
    return this;
  }

   /**
   * Total amount of tokens minted on this contract.
   * @return totalTokensEarned
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_TOTAL_TOKENS_EARNED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Long getTotalTokensEarned() {
    return totalTokensEarned;
  }


  @JsonProperty(JSON_PROPERTY_TOTAL_TOKENS_EARNED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTotalTokensEarned(Long totalTokensEarned) {
    this.totalTokensEarned = totalTokensEarned;
  }


  public BookingContractAffiliate metadata(Map<String, String> metadata) {
    
    this.metadata = metadata;
    return this;
  }

  public BookingContractAffiliate putMetadataItem(String key, String metadataItem) {
    if (this.metadata == null) {
      this.metadata = new HashMap<>();
    }
    this.metadata.put(key, metadataItem);
    return this;
  }

   /**
   * Place to add more data related to the booking contract.
   * @return metadata
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_METADATA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Map<String, String> getMetadata() {
    return metadata;
  }


  @JsonProperty(JSON_PROPERTY_METADATA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMetadata(Map<String, String> metadata) {
    this.metadata = metadata;
  }


  public BookingContractAffiliate totalTripPayFeeInPercent(Float totalTripPayFeeInPercent) {
    
    this.totalTripPayFeeInPercent = totalTripPayFeeInPercent;
    return this;
  }

   /**
   * All amounts that are not of type SALE before a refund was applied
   * @return totalTripPayFeeInPercent
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_TOTAL_TRIP_PAY_FEE_IN_PERCENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Float getTotalTripPayFeeInPercent() {
    return totalTripPayFeeInPercent;
  }


  @JsonProperty(JSON_PROPERTY_TOTAL_TRIP_PAY_FEE_IN_PERCENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTotalTripPayFeeInPercent(Float totalTripPayFeeInPercent) {
    this.totalTripPayFeeInPercent = totalTripPayFeeInPercent;
  }


  public BookingContractAffiliate hasRefunds(Boolean hasRefunds) {
    
    this.hasRefunds = hasRefunds;
    return this;
  }

   /**
   * Indicates whether any refund in any state is present.
   * @return hasRefunds
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_HAS_REFUNDS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getHasRefunds() {
    return hasRefunds;
  }


  @JsonProperty(JSON_PROPERTY_HAS_REFUNDS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setHasRefunds(Boolean hasRefunds) {
    this.hasRefunds = hasRefunds;
  }


  public BookingContractAffiliate originalCommissionsInPercent(BigDecimal originalCommissionsInPercent) {
    
    this.originalCommissionsInPercent = originalCommissionsInPercent;
    return this;
  }

   /**
   * All amounts that are not of type SALE before a refund was applied
   * @return originalCommissionsInPercent
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_ORIGINAL_COMMISSIONS_IN_PERCENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public BigDecimal getOriginalCommissionsInPercent() {
    return originalCommissionsInPercent;
  }


  @JsonProperty(JSON_PROPERTY_ORIGINAL_COMMISSIONS_IN_PERCENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setOriginalCommissionsInPercent(BigDecimal originalCommissionsInPercent) {
    this.originalCommissionsInPercent = originalCommissionsInPercent;
  }


  public BookingContractAffiliate originalFeesInPercent(BigDecimal originalFeesInPercent) {
    
    this.originalFeesInPercent = originalFeesInPercent;
    return this;
  }

   /**
   * All amounts that are not of type SALE before a refund was applied
   * @return originalFeesInPercent
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_ORIGINAL_FEES_IN_PERCENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public BigDecimal getOriginalFeesInPercent() {
    return originalFeesInPercent;
  }


  @JsonProperty(JSON_PROPERTY_ORIGINAL_FEES_IN_PERCENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setOriginalFeesInPercent(BigDecimal originalFeesInPercent) {
    this.originalFeesInPercent = originalFeesInPercent;
  }


  public BookingContractAffiliate totalCommissionsInPercentWithRefund(Float totalCommissionsInPercentWithRefund) {
    
    this.totalCommissionsInPercentWithRefund = totalCommissionsInPercentWithRefund;
    return this;
  }

   /**
   * All amounts that are not of type SALE
   * @return totalCommissionsInPercentWithRefund
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_TOTAL_COMMISSIONS_IN_PERCENT_WITH_REFUND)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Float getTotalCommissionsInPercentWithRefund() {
    return totalCommissionsInPercentWithRefund;
  }


  @JsonProperty(JSON_PROPERTY_TOTAL_COMMISSIONS_IN_PERCENT_WITH_REFUND)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTotalCommissionsInPercentWithRefund(Float totalCommissionsInPercentWithRefund) {
    this.totalCommissionsInPercentWithRefund = totalCommissionsInPercentWithRefund;
  }


  public BookingContractAffiliate totalFeesInPercentWithRefund(Float totalFeesInPercentWithRefund) {
    
    this.totalFeesInPercentWithRefund = totalFeesInPercentWithRefund;
    return this;
  }

   /**
   * All amounts that are not of type SALE
   * @return totalFeesInPercentWithRefund
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_TOTAL_FEES_IN_PERCENT_WITH_REFUND)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Float getTotalFeesInPercentWithRefund() {
    return totalFeesInPercentWithRefund;
  }


  @JsonProperty(JSON_PROPERTY_TOTAL_FEES_IN_PERCENT_WITH_REFUND)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTotalFeesInPercentWithRefund(Float totalFeesInPercentWithRefund) {
    this.totalFeesInPercentWithRefund = totalFeesInPercentWithRefund;
  }


  public BookingContractAffiliate totalTripPayFeeInPercentWithRefund(Float totalTripPayFeeInPercentWithRefund) {
    
    this.totalTripPayFeeInPercentWithRefund = totalTripPayFeeInPercentWithRefund;
    return this;
  }

   /**
   * All amounts that are not of type SALE
   * @return totalTripPayFeeInPercentWithRefund
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_TOTAL_TRIP_PAY_FEE_IN_PERCENT_WITH_REFUND)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Float getTotalTripPayFeeInPercentWithRefund() {
    return totalTripPayFeeInPercentWithRefund;
  }


  @JsonProperty(JSON_PROPERTY_TOTAL_TRIP_PAY_FEE_IN_PERCENT_WITH_REFUND)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTotalTripPayFeeInPercentWithRefund(Float totalTripPayFeeInPercentWithRefund) {
    this.totalTripPayFeeInPercentWithRefund = totalTripPayFeeInPercentWithRefund;
  }


  public BookingContractAffiliate netTotalFeesSupplierAmount(CustomMonetaryAmount netTotalFeesSupplierAmount) {
    
    this.netTotalFeesSupplierAmount = netTotalFeesSupplierAmount;
    return this;
  }

   /**
   * Get netTotalFeesSupplierAmount
   * @return netTotalFeesSupplierAmount
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_NET_TOTAL_FEES_SUPPLIER_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomMonetaryAmount getNetTotalFeesSupplierAmount() {
    return netTotalFeesSupplierAmount;
  }


  @JsonProperty(JSON_PROPERTY_NET_TOTAL_FEES_SUPPLIER_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setNetTotalFeesSupplierAmount(CustomMonetaryAmount netTotalFeesSupplierAmount) {
    this.netTotalFeesSupplierAmount = netTotalFeesSupplierAmount;
  }


  public BookingContractAffiliate totalFeesSupplierAmount(CustomMonetaryAmount totalFeesSupplierAmount) {
    
    this.totalFeesSupplierAmount = totalFeesSupplierAmount;
    return this;
  }

   /**
   * Get totalFeesSupplierAmount
   * @return totalFeesSupplierAmount
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_TOTAL_FEES_SUPPLIER_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomMonetaryAmount getTotalFeesSupplierAmount() {
    return totalFeesSupplierAmount;
  }


  @JsonProperty(JSON_PROPERTY_TOTAL_FEES_SUPPLIER_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTotalFeesSupplierAmount(CustomMonetaryAmount totalFeesSupplierAmount) {
    this.totalFeesSupplierAmount = totalFeesSupplierAmount;
  }


  public BookingContractAffiliate netTotalTripPayFeeSupplierAmount(CustomMonetaryAmount netTotalTripPayFeeSupplierAmount) {
    
    this.netTotalTripPayFeeSupplierAmount = netTotalTripPayFeeSupplierAmount;
    return this;
  }

   /**
   * Get netTotalTripPayFeeSupplierAmount
   * @return netTotalTripPayFeeSupplierAmount
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_NET_TOTAL_TRIP_PAY_FEE_SUPPLIER_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomMonetaryAmount getNetTotalTripPayFeeSupplierAmount() {
    return netTotalTripPayFeeSupplierAmount;
  }


  @JsonProperty(JSON_PROPERTY_NET_TOTAL_TRIP_PAY_FEE_SUPPLIER_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setNetTotalTripPayFeeSupplierAmount(CustomMonetaryAmount netTotalTripPayFeeSupplierAmount) {
    this.netTotalTripPayFeeSupplierAmount = netTotalTripPayFeeSupplierAmount;
  }


  public BookingContractAffiliate totalTripPayFeeSupplierAmount(CustomMonetaryAmount totalTripPayFeeSupplierAmount) {
    
    this.totalTripPayFeeSupplierAmount = totalTripPayFeeSupplierAmount;
    return this;
  }

   /**
   * Get totalTripPayFeeSupplierAmount
   * @return totalTripPayFeeSupplierAmount
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_TOTAL_TRIP_PAY_FEE_SUPPLIER_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomMonetaryAmount getTotalTripPayFeeSupplierAmount() {
    return totalTripPayFeeSupplierAmount;
  }


  @JsonProperty(JSON_PROPERTY_TOTAL_TRIP_PAY_FEE_SUPPLIER_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTotalTripPayFeeSupplierAmount(CustomMonetaryAmount totalTripPayFeeSupplierAmount) {
    this.totalTripPayFeeSupplierAmount = totalTripPayFeeSupplierAmount;
  }


  public BookingContractAffiliate netCommissionableTotalSupplierAmount(CustomMonetaryAmount netCommissionableTotalSupplierAmount) {
    
    this.netCommissionableTotalSupplierAmount = netCommissionableTotalSupplierAmount;
    return this;
  }

   /**
   * Get netCommissionableTotalSupplierAmount
   * @return netCommissionableTotalSupplierAmount
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_NET_COMMISSIONABLE_TOTAL_SUPPLIER_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomMonetaryAmount getNetCommissionableTotalSupplierAmount() {
    return netCommissionableTotalSupplierAmount;
  }


  @JsonProperty(JSON_PROPERTY_NET_COMMISSIONABLE_TOTAL_SUPPLIER_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setNetCommissionableTotalSupplierAmount(CustomMonetaryAmount netCommissionableTotalSupplierAmount) {
    this.netCommissionableTotalSupplierAmount = netCommissionableTotalSupplierAmount;
  }


  public BookingContractAffiliate commissionableTotalSupplierAmount(CustomMonetaryAmount commissionableTotalSupplierAmount) {
    
    this.commissionableTotalSupplierAmount = commissionableTotalSupplierAmount;
    return this;
  }

   /**
   * Get commissionableTotalSupplierAmount
   * @return commissionableTotalSupplierAmount
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_COMMISSIONABLE_TOTAL_SUPPLIER_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomMonetaryAmount getCommissionableTotalSupplierAmount() {
    return commissionableTotalSupplierAmount;
  }


  @JsonProperty(JSON_PROPERTY_COMMISSIONABLE_TOTAL_SUPPLIER_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCommissionableTotalSupplierAmount(CustomMonetaryAmount commissionableTotalSupplierAmount) {
    this.commissionableTotalSupplierAmount = commissionableTotalSupplierAmount;
  }


  public BookingContractAffiliate netTotalFeesAndCommissionsSupplierAmount(CustomMonetaryAmount netTotalFeesAndCommissionsSupplierAmount) {
    
    this.netTotalFeesAndCommissionsSupplierAmount = netTotalFeesAndCommissionsSupplierAmount;
    return this;
  }

   /**
   * Get netTotalFeesAndCommissionsSupplierAmount
   * @return netTotalFeesAndCommissionsSupplierAmount
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_NET_TOTAL_FEES_AND_COMMISSIONS_SUPPLIER_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomMonetaryAmount getNetTotalFeesAndCommissionsSupplierAmount() {
    return netTotalFeesAndCommissionsSupplierAmount;
  }


  @JsonProperty(JSON_PROPERTY_NET_TOTAL_FEES_AND_COMMISSIONS_SUPPLIER_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setNetTotalFeesAndCommissionsSupplierAmount(CustomMonetaryAmount netTotalFeesAndCommissionsSupplierAmount) {
    this.netTotalFeesAndCommissionsSupplierAmount = netTotalFeesAndCommissionsSupplierAmount;
  }


  public BookingContractAffiliate totalFeesAndCommissionsSupplierAmount(CustomMonetaryAmount totalFeesAndCommissionsSupplierAmount) {
    
    this.totalFeesAndCommissionsSupplierAmount = totalFeesAndCommissionsSupplierAmount;
    return this;
  }

   /**
   * Get totalFeesAndCommissionsSupplierAmount
   * @return totalFeesAndCommissionsSupplierAmount
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_TOTAL_FEES_AND_COMMISSIONS_SUPPLIER_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomMonetaryAmount getTotalFeesAndCommissionsSupplierAmount() {
    return totalFeesAndCommissionsSupplierAmount;
  }


  @JsonProperty(JSON_PROPERTY_TOTAL_FEES_AND_COMMISSIONS_SUPPLIER_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTotalFeesAndCommissionsSupplierAmount(CustomMonetaryAmount totalFeesAndCommissionsSupplierAmount) {
    this.totalFeesAndCommissionsSupplierAmount = totalFeesAndCommissionsSupplierAmount;
  }


  public BookingContractAffiliate cancellableWithNoCharges(Boolean cancellableWithNoCharges) {
    
    this.cancellableWithNoCharges = cancellableWithNoCharges;
    return this;
  }

   /**
   * Whether the cancellation comes at no cost to the traveler.
   * @return cancellableWithNoCharges
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_CANCELLABLE_WITH_NO_CHARGES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getCancellableWithNoCharges() {
    return cancellableWithNoCharges;
  }


  @JsonProperty(JSON_PROPERTY_CANCELLABLE_WITH_NO_CHARGES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCancellableWithNoCharges(Boolean cancellableWithNoCharges) {
    this.cancellableWithNoCharges = cancellableWithNoCharges;
  }


  public BookingContractAffiliate isCancellableWithPotentialCharges(Boolean isCancellableWithPotentialCharges) {
    
    this.isCancellableWithPotentialCharges = isCancellableWithPotentialCharges;
    return this;
  }

   /**
   * Whether a cancellation comes with partial charges. I.e. Only some of the items in contract are not fully refundable.
   * @return isCancellableWithPotentialCharges
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_IS_CANCELLABLE_WITH_POTENTIAL_CHARGES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getIsCancellableWithPotentialCharges() {
    return isCancellableWithPotentialCharges;
  }


  @JsonProperty(JSON_PROPERTY_IS_CANCELLABLE_WITH_POTENTIAL_CHARGES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIsCancellableWithPotentialCharges(Boolean isCancellableWithPotentialCharges) {
    this.isCancellableWithPotentialCharges = isCancellableWithPotentialCharges;
  }


  public BookingContractAffiliate netCommissionableTotalSourceAmount(CustomMonetaryAmount netCommissionableTotalSourceAmount) {
    
    this.netCommissionableTotalSourceAmount = netCommissionableTotalSourceAmount;
    return this;
  }

   /**
   * Get netCommissionableTotalSourceAmount
   * @return netCommissionableTotalSourceAmount
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_NET_COMMISSIONABLE_TOTAL_SOURCE_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomMonetaryAmount getNetCommissionableTotalSourceAmount() {
    return netCommissionableTotalSourceAmount;
  }


  @JsonProperty(JSON_PROPERTY_NET_COMMISSIONABLE_TOTAL_SOURCE_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setNetCommissionableTotalSourceAmount(CustomMonetaryAmount netCommissionableTotalSourceAmount) {
    this.netCommissionableTotalSourceAmount = netCommissionableTotalSourceAmount;
  }


  public BookingContractAffiliate netCommissionableTotalCaptureAmount(CustomMonetaryAmount netCommissionableTotalCaptureAmount) {
    
    this.netCommissionableTotalCaptureAmount = netCommissionableTotalCaptureAmount;
    return this;
  }

   /**
   * Get netCommissionableTotalCaptureAmount
   * @return netCommissionableTotalCaptureAmount
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_NET_COMMISSIONABLE_TOTAL_CAPTURE_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomMonetaryAmount getNetCommissionableTotalCaptureAmount() {
    return netCommissionableTotalCaptureAmount;
  }


  @JsonProperty(JSON_PROPERTY_NET_COMMISSIONABLE_TOTAL_CAPTURE_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setNetCommissionableTotalCaptureAmount(CustomMonetaryAmount netCommissionableTotalCaptureAmount) {
    this.netCommissionableTotalCaptureAmount = netCommissionableTotalCaptureAmount;
  }


  public BookingContractAffiliate netCommissionableTotalDisplayAmount(CustomMonetaryAmount netCommissionableTotalDisplayAmount) {
    
    this.netCommissionableTotalDisplayAmount = netCommissionableTotalDisplayAmount;
    return this;
  }

   /**
   * Get netCommissionableTotalDisplayAmount
   * @return netCommissionableTotalDisplayAmount
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_NET_COMMISSIONABLE_TOTAL_DISPLAY_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomMonetaryAmount getNetCommissionableTotalDisplayAmount() {
    return netCommissionableTotalDisplayAmount;
  }


  @JsonProperty(JSON_PROPERTY_NET_COMMISSIONABLE_TOTAL_DISPLAY_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setNetCommissionableTotalDisplayAmount(CustomMonetaryAmount netCommissionableTotalDisplayAmount) {
    this.netCommissionableTotalDisplayAmount = netCommissionableTotalDisplayAmount;
  }


  public BookingContractAffiliate netCommissionableTotalInternalAmount(CustomMonetaryAmount netCommissionableTotalInternalAmount) {
    
    this.netCommissionableTotalInternalAmount = netCommissionableTotalInternalAmount;
    return this;
  }

   /**
   * Get netCommissionableTotalInternalAmount
   * @return netCommissionableTotalInternalAmount
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_NET_COMMISSIONABLE_TOTAL_INTERNAL_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomMonetaryAmount getNetCommissionableTotalInternalAmount() {
    return netCommissionableTotalInternalAmount;
  }


  @JsonProperty(JSON_PROPERTY_NET_COMMISSIONABLE_TOTAL_INTERNAL_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setNetCommissionableTotalInternalAmount(CustomMonetaryAmount netCommissionableTotalInternalAmount) {
    this.netCommissionableTotalInternalAmount = netCommissionableTotalInternalAmount;
  }


  public BookingContractAffiliate netTotalFeesAndCommissionsSourceAmount(CustomMonetaryAmount netTotalFeesAndCommissionsSourceAmount) {
    
    this.netTotalFeesAndCommissionsSourceAmount = netTotalFeesAndCommissionsSourceAmount;
    return this;
  }

   /**
   * Get netTotalFeesAndCommissionsSourceAmount
   * @return netTotalFeesAndCommissionsSourceAmount
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_NET_TOTAL_FEES_AND_COMMISSIONS_SOURCE_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomMonetaryAmount getNetTotalFeesAndCommissionsSourceAmount() {
    return netTotalFeesAndCommissionsSourceAmount;
  }


  @JsonProperty(JSON_PROPERTY_NET_TOTAL_FEES_AND_COMMISSIONS_SOURCE_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setNetTotalFeesAndCommissionsSourceAmount(CustomMonetaryAmount netTotalFeesAndCommissionsSourceAmount) {
    this.netTotalFeesAndCommissionsSourceAmount = netTotalFeesAndCommissionsSourceAmount;
  }


  public BookingContractAffiliate netTotalFeesAndCommissionsCaptureAmount(CustomMonetaryAmount netTotalFeesAndCommissionsCaptureAmount) {
    
    this.netTotalFeesAndCommissionsCaptureAmount = netTotalFeesAndCommissionsCaptureAmount;
    return this;
  }

   /**
   * Get netTotalFeesAndCommissionsCaptureAmount
   * @return netTotalFeesAndCommissionsCaptureAmount
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_NET_TOTAL_FEES_AND_COMMISSIONS_CAPTURE_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomMonetaryAmount getNetTotalFeesAndCommissionsCaptureAmount() {
    return netTotalFeesAndCommissionsCaptureAmount;
  }


  @JsonProperty(JSON_PROPERTY_NET_TOTAL_FEES_AND_COMMISSIONS_CAPTURE_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setNetTotalFeesAndCommissionsCaptureAmount(CustomMonetaryAmount netTotalFeesAndCommissionsCaptureAmount) {
    this.netTotalFeesAndCommissionsCaptureAmount = netTotalFeesAndCommissionsCaptureAmount;
  }


  public BookingContractAffiliate netTotalFeesAndCommissionsDisplayAmount(CustomMonetaryAmount netTotalFeesAndCommissionsDisplayAmount) {
    
    this.netTotalFeesAndCommissionsDisplayAmount = netTotalFeesAndCommissionsDisplayAmount;
    return this;
  }

   /**
   * Get netTotalFeesAndCommissionsDisplayAmount
   * @return netTotalFeesAndCommissionsDisplayAmount
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_NET_TOTAL_FEES_AND_COMMISSIONS_DISPLAY_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomMonetaryAmount getNetTotalFeesAndCommissionsDisplayAmount() {
    return netTotalFeesAndCommissionsDisplayAmount;
  }


  @JsonProperty(JSON_PROPERTY_NET_TOTAL_FEES_AND_COMMISSIONS_DISPLAY_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setNetTotalFeesAndCommissionsDisplayAmount(CustomMonetaryAmount netTotalFeesAndCommissionsDisplayAmount) {
    this.netTotalFeesAndCommissionsDisplayAmount = netTotalFeesAndCommissionsDisplayAmount;
  }


  public BookingContractAffiliate netTotalFeesAndCommissionsInternalAmount(CustomMonetaryAmount netTotalFeesAndCommissionsInternalAmount) {
    
    this.netTotalFeesAndCommissionsInternalAmount = netTotalFeesAndCommissionsInternalAmount;
    return this;
  }

   /**
   * Get netTotalFeesAndCommissionsInternalAmount
   * @return netTotalFeesAndCommissionsInternalAmount
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_NET_TOTAL_FEES_AND_COMMISSIONS_INTERNAL_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomMonetaryAmount getNetTotalFeesAndCommissionsInternalAmount() {
    return netTotalFeesAndCommissionsInternalAmount;
  }


  @JsonProperty(JSON_PROPERTY_NET_TOTAL_FEES_AND_COMMISSIONS_INTERNAL_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setNetTotalFeesAndCommissionsInternalAmount(CustomMonetaryAmount netTotalFeesAndCommissionsInternalAmount) {
    this.netTotalFeesAndCommissionsInternalAmount = netTotalFeesAndCommissionsInternalAmount;
  }


  public BookingContractAffiliate netTotalFeesSourceAmount(CustomMonetaryAmount netTotalFeesSourceAmount) {
    
    this.netTotalFeesSourceAmount = netTotalFeesSourceAmount;
    return this;
  }

   /**
   * Get netTotalFeesSourceAmount
   * @return netTotalFeesSourceAmount
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_NET_TOTAL_FEES_SOURCE_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomMonetaryAmount getNetTotalFeesSourceAmount() {
    return netTotalFeesSourceAmount;
  }


  @JsonProperty(JSON_PROPERTY_NET_TOTAL_FEES_SOURCE_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setNetTotalFeesSourceAmount(CustomMonetaryAmount netTotalFeesSourceAmount) {
    this.netTotalFeesSourceAmount = netTotalFeesSourceAmount;
  }


  public BookingContractAffiliate netTotalFeesCaptureAmount(CustomMonetaryAmount netTotalFeesCaptureAmount) {
    
    this.netTotalFeesCaptureAmount = netTotalFeesCaptureAmount;
    return this;
  }

   /**
   * Get netTotalFeesCaptureAmount
   * @return netTotalFeesCaptureAmount
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_NET_TOTAL_FEES_CAPTURE_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomMonetaryAmount getNetTotalFeesCaptureAmount() {
    return netTotalFeesCaptureAmount;
  }


  @JsonProperty(JSON_PROPERTY_NET_TOTAL_FEES_CAPTURE_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setNetTotalFeesCaptureAmount(CustomMonetaryAmount netTotalFeesCaptureAmount) {
    this.netTotalFeesCaptureAmount = netTotalFeesCaptureAmount;
  }


  public BookingContractAffiliate netTotalFeesDisplayAmount(CustomMonetaryAmount netTotalFeesDisplayAmount) {
    
    this.netTotalFeesDisplayAmount = netTotalFeesDisplayAmount;
    return this;
  }

   /**
   * Get netTotalFeesDisplayAmount
   * @return netTotalFeesDisplayAmount
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_NET_TOTAL_FEES_DISPLAY_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomMonetaryAmount getNetTotalFeesDisplayAmount() {
    return netTotalFeesDisplayAmount;
  }


  @JsonProperty(JSON_PROPERTY_NET_TOTAL_FEES_DISPLAY_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setNetTotalFeesDisplayAmount(CustomMonetaryAmount netTotalFeesDisplayAmount) {
    this.netTotalFeesDisplayAmount = netTotalFeesDisplayAmount;
  }


  public BookingContractAffiliate netTotalFeesInternalAmount(CustomMonetaryAmount netTotalFeesInternalAmount) {
    
    this.netTotalFeesInternalAmount = netTotalFeesInternalAmount;
    return this;
  }

   /**
   * Get netTotalFeesInternalAmount
   * @return netTotalFeesInternalAmount
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_NET_TOTAL_FEES_INTERNAL_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomMonetaryAmount getNetTotalFeesInternalAmount() {
    return netTotalFeesInternalAmount;
  }


  @JsonProperty(JSON_PROPERTY_NET_TOTAL_FEES_INTERNAL_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setNetTotalFeesInternalAmount(CustomMonetaryAmount netTotalFeesInternalAmount) {
    this.netTotalFeesInternalAmount = netTotalFeesInternalAmount;
  }


  public BookingContractAffiliate netTotalTripPayFeeSourceAmount(CustomMonetaryAmount netTotalTripPayFeeSourceAmount) {
    
    this.netTotalTripPayFeeSourceAmount = netTotalTripPayFeeSourceAmount;
    return this;
  }

   /**
   * Get netTotalTripPayFeeSourceAmount
   * @return netTotalTripPayFeeSourceAmount
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_NET_TOTAL_TRIP_PAY_FEE_SOURCE_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomMonetaryAmount getNetTotalTripPayFeeSourceAmount() {
    return netTotalTripPayFeeSourceAmount;
  }


  @JsonProperty(JSON_PROPERTY_NET_TOTAL_TRIP_PAY_FEE_SOURCE_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setNetTotalTripPayFeeSourceAmount(CustomMonetaryAmount netTotalTripPayFeeSourceAmount) {
    this.netTotalTripPayFeeSourceAmount = netTotalTripPayFeeSourceAmount;
  }


  public BookingContractAffiliate netTotalTripPayFeeCaptureAmount(CustomMonetaryAmount netTotalTripPayFeeCaptureAmount) {
    
    this.netTotalTripPayFeeCaptureAmount = netTotalTripPayFeeCaptureAmount;
    return this;
  }

   /**
   * Get netTotalTripPayFeeCaptureAmount
   * @return netTotalTripPayFeeCaptureAmount
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_NET_TOTAL_TRIP_PAY_FEE_CAPTURE_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomMonetaryAmount getNetTotalTripPayFeeCaptureAmount() {
    return netTotalTripPayFeeCaptureAmount;
  }


  @JsonProperty(JSON_PROPERTY_NET_TOTAL_TRIP_PAY_FEE_CAPTURE_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setNetTotalTripPayFeeCaptureAmount(CustomMonetaryAmount netTotalTripPayFeeCaptureAmount) {
    this.netTotalTripPayFeeCaptureAmount = netTotalTripPayFeeCaptureAmount;
  }


  public BookingContractAffiliate netTotalTripPayFeeDisplayAmount(CustomMonetaryAmount netTotalTripPayFeeDisplayAmount) {
    
    this.netTotalTripPayFeeDisplayAmount = netTotalTripPayFeeDisplayAmount;
    return this;
  }

   /**
   * Get netTotalTripPayFeeDisplayAmount
   * @return netTotalTripPayFeeDisplayAmount
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_NET_TOTAL_TRIP_PAY_FEE_DISPLAY_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomMonetaryAmount getNetTotalTripPayFeeDisplayAmount() {
    return netTotalTripPayFeeDisplayAmount;
  }


  @JsonProperty(JSON_PROPERTY_NET_TOTAL_TRIP_PAY_FEE_DISPLAY_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setNetTotalTripPayFeeDisplayAmount(CustomMonetaryAmount netTotalTripPayFeeDisplayAmount) {
    this.netTotalTripPayFeeDisplayAmount = netTotalTripPayFeeDisplayAmount;
  }


  public BookingContractAffiliate netTotalTripPayFeeInternalAmount(CustomMonetaryAmount netTotalTripPayFeeInternalAmount) {
    
    this.netTotalTripPayFeeInternalAmount = netTotalTripPayFeeInternalAmount;
    return this;
  }

   /**
   * Get netTotalTripPayFeeInternalAmount
   * @return netTotalTripPayFeeInternalAmount
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_NET_TOTAL_TRIP_PAY_FEE_INTERNAL_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomMonetaryAmount getNetTotalTripPayFeeInternalAmount() {
    return netTotalTripPayFeeInternalAmount;
  }


  @JsonProperty(JSON_PROPERTY_NET_TOTAL_TRIP_PAY_FEE_INTERNAL_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setNetTotalTripPayFeeInternalAmount(CustomMonetaryAmount netTotalTripPayFeeInternalAmount) {
    this.netTotalTripPayFeeInternalAmount = netTotalTripPayFeeInternalAmount;
  }


  public BookingContractAffiliate netTotalSalesSourceAmount(CustomMonetaryAmount netTotalSalesSourceAmount) {
    
    this.netTotalSalesSourceAmount = netTotalSalesSourceAmount;
    return this;
  }

   /**
   * Get netTotalSalesSourceAmount
   * @return netTotalSalesSourceAmount
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_NET_TOTAL_SALES_SOURCE_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomMonetaryAmount getNetTotalSalesSourceAmount() {
    return netTotalSalesSourceAmount;
  }


  @JsonProperty(JSON_PROPERTY_NET_TOTAL_SALES_SOURCE_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setNetTotalSalesSourceAmount(CustomMonetaryAmount netTotalSalesSourceAmount) {
    this.netTotalSalesSourceAmount = netTotalSalesSourceAmount;
  }


  public BookingContractAffiliate netTotalSalesCaptureAmount(CustomMonetaryAmount netTotalSalesCaptureAmount) {
    
    this.netTotalSalesCaptureAmount = netTotalSalesCaptureAmount;
    return this;
  }

   /**
   * Get netTotalSalesCaptureAmount
   * @return netTotalSalesCaptureAmount
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_NET_TOTAL_SALES_CAPTURE_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomMonetaryAmount getNetTotalSalesCaptureAmount() {
    return netTotalSalesCaptureAmount;
  }


  @JsonProperty(JSON_PROPERTY_NET_TOTAL_SALES_CAPTURE_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setNetTotalSalesCaptureAmount(CustomMonetaryAmount netTotalSalesCaptureAmount) {
    this.netTotalSalesCaptureAmount = netTotalSalesCaptureAmount;
  }


  public BookingContractAffiliate netTotalSalesDisplayAmount(CustomMonetaryAmount netTotalSalesDisplayAmount) {
    
    this.netTotalSalesDisplayAmount = netTotalSalesDisplayAmount;
    return this;
  }

   /**
   * Get netTotalSalesDisplayAmount
   * @return netTotalSalesDisplayAmount
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_NET_TOTAL_SALES_DISPLAY_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomMonetaryAmount getNetTotalSalesDisplayAmount() {
    return netTotalSalesDisplayAmount;
  }


  @JsonProperty(JSON_PROPERTY_NET_TOTAL_SALES_DISPLAY_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setNetTotalSalesDisplayAmount(CustomMonetaryAmount netTotalSalesDisplayAmount) {
    this.netTotalSalesDisplayAmount = netTotalSalesDisplayAmount;
  }


  public BookingContractAffiliate netTotalSalesSupplierAmount(CustomMonetaryAmount netTotalSalesSupplierAmount) {
    
    this.netTotalSalesSupplierAmount = netTotalSalesSupplierAmount;
    return this;
  }

   /**
   * Get netTotalSalesSupplierAmount
   * @return netTotalSalesSupplierAmount
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_NET_TOTAL_SALES_SUPPLIER_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomMonetaryAmount getNetTotalSalesSupplierAmount() {
    return netTotalSalesSupplierAmount;
  }


  @JsonProperty(JSON_PROPERTY_NET_TOTAL_SALES_SUPPLIER_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setNetTotalSalesSupplierAmount(CustomMonetaryAmount netTotalSalesSupplierAmount) {
    this.netTotalSalesSupplierAmount = netTotalSalesSupplierAmount;
  }


  public BookingContractAffiliate netTotalSalesInternalAmount(CustomMonetaryAmount netTotalSalesInternalAmount) {
    
    this.netTotalSalesInternalAmount = netTotalSalesInternalAmount;
    return this;
  }

   /**
   * Get netTotalSalesInternalAmount
   * @return netTotalSalesInternalAmount
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_NET_TOTAL_SALES_INTERNAL_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomMonetaryAmount getNetTotalSalesInternalAmount() {
    return netTotalSalesInternalAmount;
  }


  @JsonProperty(JSON_PROPERTY_NET_TOTAL_SALES_INTERNAL_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setNetTotalSalesInternalAmount(CustomMonetaryAmount netTotalSalesInternalAmount) {
    this.netTotalSalesInternalAmount = netTotalSalesInternalAmount;
  }


  public BookingContractAffiliate commissionableTotalSourceAmount(CustomMonetaryAmount commissionableTotalSourceAmount) {
    
    this.commissionableTotalSourceAmount = commissionableTotalSourceAmount;
    return this;
  }

   /**
   * Get commissionableTotalSourceAmount
   * @return commissionableTotalSourceAmount
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_COMMISSIONABLE_TOTAL_SOURCE_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomMonetaryAmount getCommissionableTotalSourceAmount() {
    return commissionableTotalSourceAmount;
  }


  @JsonProperty(JSON_PROPERTY_COMMISSIONABLE_TOTAL_SOURCE_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCommissionableTotalSourceAmount(CustomMonetaryAmount commissionableTotalSourceAmount) {
    this.commissionableTotalSourceAmount = commissionableTotalSourceAmount;
  }


  public BookingContractAffiliate commissionableTotalCaptureAmount(CustomMonetaryAmount commissionableTotalCaptureAmount) {
    
    this.commissionableTotalCaptureAmount = commissionableTotalCaptureAmount;
    return this;
  }

   /**
   * Get commissionableTotalCaptureAmount
   * @return commissionableTotalCaptureAmount
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_COMMISSIONABLE_TOTAL_CAPTURE_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomMonetaryAmount getCommissionableTotalCaptureAmount() {
    return commissionableTotalCaptureAmount;
  }


  @JsonProperty(JSON_PROPERTY_COMMISSIONABLE_TOTAL_CAPTURE_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCommissionableTotalCaptureAmount(CustomMonetaryAmount commissionableTotalCaptureAmount) {
    this.commissionableTotalCaptureAmount = commissionableTotalCaptureAmount;
  }


  public BookingContractAffiliate commissionableTotalDisplayAmount(CustomMonetaryAmount commissionableTotalDisplayAmount) {
    
    this.commissionableTotalDisplayAmount = commissionableTotalDisplayAmount;
    return this;
  }

   /**
   * Get commissionableTotalDisplayAmount
   * @return commissionableTotalDisplayAmount
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_COMMISSIONABLE_TOTAL_DISPLAY_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomMonetaryAmount getCommissionableTotalDisplayAmount() {
    return commissionableTotalDisplayAmount;
  }


  @JsonProperty(JSON_PROPERTY_COMMISSIONABLE_TOTAL_DISPLAY_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCommissionableTotalDisplayAmount(CustomMonetaryAmount commissionableTotalDisplayAmount) {
    this.commissionableTotalDisplayAmount = commissionableTotalDisplayAmount;
  }


  public BookingContractAffiliate commissionableTotalInternalAmount(CustomMonetaryAmount commissionableTotalInternalAmount) {
    
    this.commissionableTotalInternalAmount = commissionableTotalInternalAmount;
    return this;
  }

   /**
   * Get commissionableTotalInternalAmount
   * @return commissionableTotalInternalAmount
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_COMMISSIONABLE_TOTAL_INTERNAL_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomMonetaryAmount getCommissionableTotalInternalAmount() {
    return commissionableTotalInternalAmount;
  }


  @JsonProperty(JSON_PROPERTY_COMMISSIONABLE_TOTAL_INTERNAL_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCommissionableTotalInternalAmount(CustomMonetaryAmount commissionableTotalInternalAmount) {
    this.commissionableTotalInternalAmount = commissionableTotalInternalAmount;
  }


  public BookingContractAffiliate totalFeesAndCommissionsSourceAmount(CustomMonetaryAmount totalFeesAndCommissionsSourceAmount) {
    
    this.totalFeesAndCommissionsSourceAmount = totalFeesAndCommissionsSourceAmount;
    return this;
  }

   /**
   * Get totalFeesAndCommissionsSourceAmount
   * @return totalFeesAndCommissionsSourceAmount
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_TOTAL_FEES_AND_COMMISSIONS_SOURCE_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomMonetaryAmount getTotalFeesAndCommissionsSourceAmount() {
    return totalFeesAndCommissionsSourceAmount;
  }


  @JsonProperty(JSON_PROPERTY_TOTAL_FEES_AND_COMMISSIONS_SOURCE_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTotalFeesAndCommissionsSourceAmount(CustomMonetaryAmount totalFeesAndCommissionsSourceAmount) {
    this.totalFeesAndCommissionsSourceAmount = totalFeesAndCommissionsSourceAmount;
  }


  public BookingContractAffiliate totalFeesAndCommissionsCaptureAmount(CustomMonetaryAmount totalFeesAndCommissionsCaptureAmount) {
    
    this.totalFeesAndCommissionsCaptureAmount = totalFeesAndCommissionsCaptureAmount;
    return this;
  }

   /**
   * Get totalFeesAndCommissionsCaptureAmount
   * @return totalFeesAndCommissionsCaptureAmount
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_TOTAL_FEES_AND_COMMISSIONS_CAPTURE_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomMonetaryAmount getTotalFeesAndCommissionsCaptureAmount() {
    return totalFeesAndCommissionsCaptureAmount;
  }


  @JsonProperty(JSON_PROPERTY_TOTAL_FEES_AND_COMMISSIONS_CAPTURE_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTotalFeesAndCommissionsCaptureAmount(CustomMonetaryAmount totalFeesAndCommissionsCaptureAmount) {
    this.totalFeesAndCommissionsCaptureAmount = totalFeesAndCommissionsCaptureAmount;
  }


  public BookingContractAffiliate totalFeesAndCommissionsDisplayAmount(CustomMonetaryAmount totalFeesAndCommissionsDisplayAmount) {
    
    this.totalFeesAndCommissionsDisplayAmount = totalFeesAndCommissionsDisplayAmount;
    return this;
  }

   /**
   * Get totalFeesAndCommissionsDisplayAmount
   * @return totalFeesAndCommissionsDisplayAmount
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_TOTAL_FEES_AND_COMMISSIONS_DISPLAY_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomMonetaryAmount getTotalFeesAndCommissionsDisplayAmount() {
    return totalFeesAndCommissionsDisplayAmount;
  }


  @JsonProperty(JSON_PROPERTY_TOTAL_FEES_AND_COMMISSIONS_DISPLAY_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTotalFeesAndCommissionsDisplayAmount(CustomMonetaryAmount totalFeesAndCommissionsDisplayAmount) {
    this.totalFeesAndCommissionsDisplayAmount = totalFeesAndCommissionsDisplayAmount;
  }


  public BookingContractAffiliate totalFeesAndCommissionsInternalAmount(CustomMonetaryAmount totalFeesAndCommissionsInternalAmount) {
    
    this.totalFeesAndCommissionsInternalAmount = totalFeesAndCommissionsInternalAmount;
    return this;
  }

   /**
   * Get totalFeesAndCommissionsInternalAmount
   * @return totalFeesAndCommissionsInternalAmount
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_TOTAL_FEES_AND_COMMISSIONS_INTERNAL_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomMonetaryAmount getTotalFeesAndCommissionsInternalAmount() {
    return totalFeesAndCommissionsInternalAmount;
  }


  @JsonProperty(JSON_PROPERTY_TOTAL_FEES_AND_COMMISSIONS_INTERNAL_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTotalFeesAndCommissionsInternalAmount(CustomMonetaryAmount totalFeesAndCommissionsInternalAmount) {
    this.totalFeesAndCommissionsInternalAmount = totalFeesAndCommissionsInternalAmount;
  }


  public BookingContractAffiliate totalFeesSourceAmount(CustomMonetaryAmount totalFeesSourceAmount) {
    
    this.totalFeesSourceAmount = totalFeesSourceAmount;
    return this;
  }

   /**
   * Get totalFeesSourceAmount
   * @return totalFeesSourceAmount
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_TOTAL_FEES_SOURCE_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomMonetaryAmount getTotalFeesSourceAmount() {
    return totalFeesSourceAmount;
  }


  @JsonProperty(JSON_PROPERTY_TOTAL_FEES_SOURCE_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTotalFeesSourceAmount(CustomMonetaryAmount totalFeesSourceAmount) {
    this.totalFeesSourceAmount = totalFeesSourceAmount;
  }


  public BookingContractAffiliate totalFeesCaptureAmount(CustomMonetaryAmount totalFeesCaptureAmount) {
    
    this.totalFeesCaptureAmount = totalFeesCaptureAmount;
    return this;
  }

   /**
   * Get totalFeesCaptureAmount
   * @return totalFeesCaptureAmount
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_TOTAL_FEES_CAPTURE_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomMonetaryAmount getTotalFeesCaptureAmount() {
    return totalFeesCaptureAmount;
  }


  @JsonProperty(JSON_PROPERTY_TOTAL_FEES_CAPTURE_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTotalFeesCaptureAmount(CustomMonetaryAmount totalFeesCaptureAmount) {
    this.totalFeesCaptureAmount = totalFeesCaptureAmount;
  }


  public BookingContractAffiliate totalFeesDisplayAmount(CustomMonetaryAmount totalFeesDisplayAmount) {
    
    this.totalFeesDisplayAmount = totalFeesDisplayAmount;
    return this;
  }

   /**
   * Get totalFeesDisplayAmount
   * @return totalFeesDisplayAmount
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_TOTAL_FEES_DISPLAY_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomMonetaryAmount getTotalFeesDisplayAmount() {
    return totalFeesDisplayAmount;
  }


  @JsonProperty(JSON_PROPERTY_TOTAL_FEES_DISPLAY_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTotalFeesDisplayAmount(CustomMonetaryAmount totalFeesDisplayAmount) {
    this.totalFeesDisplayAmount = totalFeesDisplayAmount;
  }


  public BookingContractAffiliate totalFeesInternalAmount(CustomMonetaryAmount totalFeesInternalAmount) {
    
    this.totalFeesInternalAmount = totalFeesInternalAmount;
    return this;
  }

   /**
   * Get totalFeesInternalAmount
   * @return totalFeesInternalAmount
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_TOTAL_FEES_INTERNAL_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomMonetaryAmount getTotalFeesInternalAmount() {
    return totalFeesInternalAmount;
  }


  @JsonProperty(JSON_PROPERTY_TOTAL_FEES_INTERNAL_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTotalFeesInternalAmount(CustomMonetaryAmount totalFeesInternalAmount) {
    this.totalFeesInternalAmount = totalFeesInternalAmount;
  }


  public BookingContractAffiliate totalTripPayFeeSourceAmount(CustomMonetaryAmount totalTripPayFeeSourceAmount) {
    
    this.totalTripPayFeeSourceAmount = totalTripPayFeeSourceAmount;
    return this;
  }

   /**
   * Get totalTripPayFeeSourceAmount
   * @return totalTripPayFeeSourceAmount
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_TOTAL_TRIP_PAY_FEE_SOURCE_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomMonetaryAmount getTotalTripPayFeeSourceAmount() {
    return totalTripPayFeeSourceAmount;
  }


  @JsonProperty(JSON_PROPERTY_TOTAL_TRIP_PAY_FEE_SOURCE_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTotalTripPayFeeSourceAmount(CustomMonetaryAmount totalTripPayFeeSourceAmount) {
    this.totalTripPayFeeSourceAmount = totalTripPayFeeSourceAmount;
  }


  public BookingContractAffiliate totalTripPayFeeCaptureAmount(CustomMonetaryAmount totalTripPayFeeCaptureAmount) {
    
    this.totalTripPayFeeCaptureAmount = totalTripPayFeeCaptureAmount;
    return this;
  }

   /**
   * Get totalTripPayFeeCaptureAmount
   * @return totalTripPayFeeCaptureAmount
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_TOTAL_TRIP_PAY_FEE_CAPTURE_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomMonetaryAmount getTotalTripPayFeeCaptureAmount() {
    return totalTripPayFeeCaptureAmount;
  }


  @JsonProperty(JSON_PROPERTY_TOTAL_TRIP_PAY_FEE_CAPTURE_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTotalTripPayFeeCaptureAmount(CustomMonetaryAmount totalTripPayFeeCaptureAmount) {
    this.totalTripPayFeeCaptureAmount = totalTripPayFeeCaptureAmount;
  }


  public BookingContractAffiliate totalTripPayFeeDisplayAmount(CustomMonetaryAmount totalTripPayFeeDisplayAmount) {
    
    this.totalTripPayFeeDisplayAmount = totalTripPayFeeDisplayAmount;
    return this;
  }

   /**
   * Get totalTripPayFeeDisplayAmount
   * @return totalTripPayFeeDisplayAmount
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_TOTAL_TRIP_PAY_FEE_DISPLAY_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomMonetaryAmount getTotalTripPayFeeDisplayAmount() {
    return totalTripPayFeeDisplayAmount;
  }


  @JsonProperty(JSON_PROPERTY_TOTAL_TRIP_PAY_FEE_DISPLAY_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTotalTripPayFeeDisplayAmount(CustomMonetaryAmount totalTripPayFeeDisplayAmount) {
    this.totalTripPayFeeDisplayAmount = totalTripPayFeeDisplayAmount;
  }


  public BookingContractAffiliate totalTripPayFeeInternalAmount(CustomMonetaryAmount totalTripPayFeeInternalAmount) {
    
    this.totalTripPayFeeInternalAmount = totalTripPayFeeInternalAmount;
    return this;
  }

   /**
   * Get totalTripPayFeeInternalAmount
   * @return totalTripPayFeeInternalAmount
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_TOTAL_TRIP_PAY_FEE_INTERNAL_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomMonetaryAmount getTotalTripPayFeeInternalAmount() {
    return totalTripPayFeeInternalAmount;
  }


  @JsonProperty(JSON_PROPERTY_TOTAL_TRIP_PAY_FEE_INTERNAL_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTotalTripPayFeeInternalAmount(CustomMonetaryAmount totalTripPayFeeInternalAmount) {
    this.totalTripPayFeeInternalAmount = totalTripPayFeeInternalAmount;
  }


  public BookingContractAffiliate totalSalesSourceAmount(CustomMonetaryAmount totalSalesSourceAmount) {
    
    this.totalSalesSourceAmount = totalSalesSourceAmount;
    return this;
  }

   /**
   * Get totalSalesSourceAmount
   * @return totalSalesSourceAmount
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_TOTAL_SALES_SOURCE_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomMonetaryAmount getTotalSalesSourceAmount() {
    return totalSalesSourceAmount;
  }


  @JsonProperty(JSON_PROPERTY_TOTAL_SALES_SOURCE_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTotalSalesSourceAmount(CustomMonetaryAmount totalSalesSourceAmount) {
    this.totalSalesSourceAmount = totalSalesSourceAmount;
  }


  public BookingContractAffiliate totalSalesCaptureAmount(CustomMonetaryAmount totalSalesCaptureAmount) {
    
    this.totalSalesCaptureAmount = totalSalesCaptureAmount;
    return this;
  }

   /**
   * Get totalSalesCaptureAmount
   * @return totalSalesCaptureAmount
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_TOTAL_SALES_CAPTURE_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomMonetaryAmount getTotalSalesCaptureAmount() {
    return totalSalesCaptureAmount;
  }


  @JsonProperty(JSON_PROPERTY_TOTAL_SALES_CAPTURE_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTotalSalesCaptureAmount(CustomMonetaryAmount totalSalesCaptureAmount) {
    this.totalSalesCaptureAmount = totalSalesCaptureAmount;
  }


  public BookingContractAffiliate totalSalesDisplayAmount(CustomMonetaryAmount totalSalesDisplayAmount) {
    
    this.totalSalesDisplayAmount = totalSalesDisplayAmount;
    return this;
  }

   /**
   * Get totalSalesDisplayAmount
   * @return totalSalesDisplayAmount
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_TOTAL_SALES_DISPLAY_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomMonetaryAmount getTotalSalesDisplayAmount() {
    return totalSalesDisplayAmount;
  }


  @JsonProperty(JSON_PROPERTY_TOTAL_SALES_DISPLAY_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTotalSalesDisplayAmount(CustomMonetaryAmount totalSalesDisplayAmount) {
    this.totalSalesDisplayAmount = totalSalesDisplayAmount;
  }


  public BookingContractAffiliate totalSalesSupplierAmount(CustomMonetaryAmount totalSalesSupplierAmount) {
    
    this.totalSalesSupplierAmount = totalSalesSupplierAmount;
    return this;
  }

   /**
   * Get totalSalesSupplierAmount
   * @return totalSalesSupplierAmount
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_TOTAL_SALES_SUPPLIER_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomMonetaryAmount getTotalSalesSupplierAmount() {
    return totalSalesSupplierAmount;
  }


  @JsonProperty(JSON_PROPERTY_TOTAL_SALES_SUPPLIER_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTotalSalesSupplierAmount(CustomMonetaryAmount totalSalesSupplierAmount) {
    this.totalSalesSupplierAmount = totalSalesSupplierAmount;
  }


  public BookingContractAffiliate totalSalesInternalAmount(CustomMonetaryAmount totalSalesInternalAmount) {
    
    this.totalSalesInternalAmount = totalSalesInternalAmount;
    return this;
  }

   /**
   * Get totalSalesInternalAmount
   * @return totalSalesInternalAmount
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_TOTAL_SALES_INTERNAL_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomMonetaryAmount getTotalSalesInternalAmount() {
    return totalSalesInternalAmount;
  }


  @JsonProperty(JSON_PROPERTY_TOTAL_SALES_INTERNAL_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTotalSalesInternalAmount(CustomMonetaryAmount totalSalesInternalAmount) {
    this.totalSalesInternalAmount = totalSalesInternalAmount;
  }


  public BookingContractAffiliate fundsAvailableDate(LocalDate fundsAvailableDate) {
    
    this.fundsAvailableDate = fundsAvailableDate;
    return this;
  }

   /**
   * Returns the date the funds will be released to the customer.
   * @return fundsAvailableDate
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_FUNDS_AVAILABLE_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public LocalDate getFundsAvailableDate() {
    return fundsAvailableDate;
  }


  @JsonProperty(JSON_PROPERTY_FUNDS_AVAILABLE_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFundsAvailableDate(LocalDate fundsAvailableDate) {
    this.fundsAvailableDate = fundsAvailableDate;
  }


  public BookingContractAffiliate totalFeesInPercent(Float totalFeesInPercent) {
    
    this.totalFeesInPercent = totalFeesInPercent;
    return this;
  }

   /**
   * All amounts that are not of type SALE before a refund was applied
   * @return totalFeesInPercent
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_TOTAL_FEES_IN_PERCENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Float getTotalFeesInPercent() {
    return totalFeesInPercent;
  }


  @JsonProperty(JSON_PROPERTY_TOTAL_FEES_IN_PERCENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTotalFeesInPercent(Float totalFeesInPercent) {
    this.totalFeesInPercent = totalFeesInPercent;
  }


  public BookingContractAffiliate totalCommissionsInPercent(Float totalCommissionsInPercent) {
    
    this.totalCommissionsInPercent = totalCommissionsInPercent;
    return this;
  }

   /**
   * All amounts that are not of type SALE before a refund was applied
   * @return totalCommissionsInPercent
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_TOTAL_COMMISSIONS_IN_PERCENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Float getTotalCommissionsInPercent() {
    return totalCommissionsInPercent;
  }


  @JsonProperty(JSON_PROPERTY_TOTAL_COMMISSIONS_IN_PERCENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTotalCommissionsInPercent(Float totalCommissionsInPercent) {
    this.totalCommissionsInPercent = totalCommissionsInPercent;
  }


  public BookingContractAffiliate totalFeesAndCommissionsInPercentWithRefund(Float totalFeesAndCommissionsInPercentWithRefund) {
    
    this.totalFeesAndCommissionsInPercentWithRefund = totalFeesAndCommissionsInPercentWithRefund;
    return this;
  }

   /**
   * All amounts that are not of type SALE
   * @return totalFeesAndCommissionsInPercentWithRefund
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_TOTAL_FEES_AND_COMMISSIONS_IN_PERCENT_WITH_REFUND)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Float getTotalFeesAndCommissionsInPercentWithRefund() {
    return totalFeesAndCommissionsInPercentWithRefund;
  }


  @JsonProperty(JSON_PROPERTY_TOTAL_FEES_AND_COMMISSIONS_IN_PERCENT_WITH_REFUND)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTotalFeesAndCommissionsInPercentWithRefund(Float totalFeesAndCommissionsInPercentWithRefund) {
    this.totalFeesAndCommissionsInPercentWithRefund = totalFeesAndCommissionsInPercentWithRefund;
  }


  public BookingContractAffiliate totalFeesAndCommissionsInPercent(Float totalFeesAndCommissionsInPercent) {
    
    this.totalFeesAndCommissionsInPercent = totalFeesAndCommissionsInPercent;
    return this;
  }

   /**
   * All amounts that are not of type SALE before a refund was applied
   * @return totalFeesAndCommissionsInPercent
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_TOTAL_FEES_AND_COMMISSIONS_IN_PERCENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Float getTotalFeesAndCommissionsInPercent() {
    return totalFeesAndCommissionsInPercent;
  }


  @JsonProperty(JSON_PROPERTY_TOTAL_FEES_AND_COMMISSIONS_IN_PERCENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTotalFeesAndCommissionsInPercent(Float totalFeesAndCommissionsInPercent) {
    this.totalFeesAndCommissionsInPercent = totalFeesAndCommissionsInPercent;
  }


  public BookingContractAffiliate netTotalCustomersSourceAmount(CustomMonetaryAmount netTotalCustomersSourceAmount) {
    
    this.netTotalCustomersSourceAmount = netTotalCustomersSourceAmount;
    return this;
  }

   /**
   * Get netTotalCustomersSourceAmount
   * @return netTotalCustomersSourceAmount
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_NET_TOTAL_CUSTOMERS_SOURCE_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomMonetaryAmount getNetTotalCustomersSourceAmount() {
    return netTotalCustomersSourceAmount;
  }


  @JsonProperty(JSON_PROPERTY_NET_TOTAL_CUSTOMERS_SOURCE_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setNetTotalCustomersSourceAmount(CustomMonetaryAmount netTotalCustomersSourceAmount) {
    this.netTotalCustomersSourceAmount = netTotalCustomersSourceAmount;
  }


  public BookingContractAffiliate netTotalCustomersCaptureAmount(CustomMonetaryAmount netTotalCustomersCaptureAmount) {
    
    this.netTotalCustomersCaptureAmount = netTotalCustomersCaptureAmount;
    return this;
  }

   /**
   * Get netTotalCustomersCaptureAmount
   * @return netTotalCustomersCaptureAmount
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_NET_TOTAL_CUSTOMERS_CAPTURE_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomMonetaryAmount getNetTotalCustomersCaptureAmount() {
    return netTotalCustomersCaptureAmount;
  }


  @JsonProperty(JSON_PROPERTY_NET_TOTAL_CUSTOMERS_CAPTURE_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setNetTotalCustomersCaptureAmount(CustomMonetaryAmount netTotalCustomersCaptureAmount) {
    this.netTotalCustomersCaptureAmount = netTotalCustomersCaptureAmount;
  }


  public BookingContractAffiliate netTotalCustomersDisplayAmount(CustomMonetaryAmount netTotalCustomersDisplayAmount) {
    
    this.netTotalCustomersDisplayAmount = netTotalCustomersDisplayAmount;
    return this;
  }

   /**
   * Get netTotalCustomersDisplayAmount
   * @return netTotalCustomersDisplayAmount
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_NET_TOTAL_CUSTOMERS_DISPLAY_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomMonetaryAmount getNetTotalCustomersDisplayAmount() {
    return netTotalCustomersDisplayAmount;
  }


  @JsonProperty(JSON_PROPERTY_NET_TOTAL_CUSTOMERS_DISPLAY_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setNetTotalCustomersDisplayAmount(CustomMonetaryAmount netTotalCustomersDisplayAmount) {
    this.netTotalCustomersDisplayAmount = netTotalCustomersDisplayAmount;
  }


  public BookingContractAffiliate netTotalCustomersSupplierAmount(CustomMonetaryAmount netTotalCustomersSupplierAmount) {
    
    this.netTotalCustomersSupplierAmount = netTotalCustomersSupplierAmount;
    return this;
  }

   /**
   * Get netTotalCustomersSupplierAmount
   * @return netTotalCustomersSupplierAmount
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_NET_TOTAL_CUSTOMERS_SUPPLIER_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomMonetaryAmount getNetTotalCustomersSupplierAmount() {
    return netTotalCustomersSupplierAmount;
  }


  @JsonProperty(JSON_PROPERTY_NET_TOTAL_CUSTOMERS_SUPPLIER_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setNetTotalCustomersSupplierAmount(CustomMonetaryAmount netTotalCustomersSupplierAmount) {
    this.netTotalCustomersSupplierAmount = netTotalCustomersSupplierAmount;
  }


  public BookingContractAffiliate netTotalCustomersInternalAmount(CustomMonetaryAmount netTotalCustomersInternalAmount) {
    
    this.netTotalCustomersInternalAmount = netTotalCustomersInternalAmount;
    return this;
  }

   /**
   * Get netTotalCustomersInternalAmount
   * @return netTotalCustomersInternalAmount
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_NET_TOTAL_CUSTOMERS_INTERNAL_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CustomMonetaryAmount getNetTotalCustomersInternalAmount() {
    return netTotalCustomersInternalAmount;
  }


  @JsonProperty(JSON_PROPERTY_NET_TOTAL_CUSTOMERS_INTERNAL_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setNetTotalCustomersInternalAmount(CustomMonetaryAmount netTotalCustomersInternalAmount) {
    this.netTotalCustomersInternalAmount = netTotalCustomersInternalAmount;
  }


  public BookingContractAffiliate hasSuccessfulRefunds(Boolean hasSuccessfulRefunds) {
    
    this.hasSuccessfulRefunds = hasSuccessfulRefunds;
    return this;
  }

   /**
   * Indicates whether a successful refund is present.
   * @return hasSuccessfulRefunds
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_HAS_SUCCESSFUL_REFUNDS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getHasSuccessfulRefunds() {
    return hasSuccessfulRefunds;
  }


  @JsonProperty(JSON_PROPERTY_HAS_SUCCESSFUL_REFUNDS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setHasSuccessfulRefunds(Boolean hasSuccessfulRefunds) {
    this.hasSuccessfulRefunds = hasSuccessfulRefunds;
  }


  public BookingContractAffiliate hasPendingRefunds(Boolean hasPendingRefunds) {
    
    this.hasPendingRefunds = hasPendingRefunds;
    return this;
  }

   /**
   * Indicates whether a pending refund is present.
   * @return hasPendingRefunds
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_HAS_PENDING_REFUNDS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getHasPendingRefunds() {
    return hasPendingRefunds;
  }


  @JsonProperty(JSON_PROPERTY_HAS_PENDING_REFUNDS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setHasPendingRefunds(Boolean hasPendingRefunds) {
    this.hasPendingRefunds = hasPendingRefunds;
  }


  public BookingContractAffiliate hasFailedRefunds(Boolean hasFailedRefunds) {
    
    this.hasFailedRefunds = hasFailedRefunds;
    return this;
  }

   /**
   * Indicates whether a failed refund is present.
   * @return hasFailedRefunds
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_HAS_FAILED_REFUNDS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getHasFailedRefunds() {
    return hasFailedRefunds;
  }


  @JsonProperty(JSON_PROPERTY_HAS_FAILED_REFUNDS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setHasFailedRefunds(Boolean hasFailedRefunds) {
    this.hasFailedRefunds = hasFailedRefunds;
  }


  public BookingContractAffiliate lodging(BookingContractItemAffiliate lodging) {
    
    this.lodging = lodging;
    return this;
  }

   /**
   * Get lodging
   * @return lodging
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_LODGING)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public BookingContractItemAffiliate getLodging() {
    return lodging;
  }


  @JsonProperty(JSON_PROPERTY_LODGING)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLodging(BookingContractItemAffiliate lodging) {
    this.lodging = lodging;
  }


  public BookingContractAffiliate cancellableBySupplier(Boolean cancellableBySupplier) {
    
    this.cancellableBySupplier = cancellableBySupplier;
    return this;
  }

   /**
   * Whether the booking can still be cancelled completely by the supplier.
   * @return cancellableBySupplier
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_CANCELLABLE_BY_SUPPLIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getCancellableBySupplier() {
    return cancellableBySupplier;
  }


  @JsonProperty(JSON_PROPERTY_CANCELLABLE_BY_SUPPLIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCancellableBySupplier(Boolean cancellableBySupplier) {
    this.cancellableBySupplier = cancellableBySupplier;
  }


  public BookingContractAffiliate cancellableByTraveler(Boolean cancellableByTraveler) {
    
    this.cancellableByTraveler = cancellableByTraveler;
    return this;
  }

   /**
   * Whether the booking can still be cancelled completely by the traveller.
   * @return cancellableByTraveler
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_CANCELLABLE_BY_TRAVELER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getCancellableByTraveler() {
    return cancellableByTraveler;
  }


  @JsonProperty(JSON_PROPERTY_CANCELLABLE_BY_TRAVELER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCancellableByTraveler(Boolean cancellableByTraveler) {
    this.cancellableByTraveler = cancellableByTraveler;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    BookingContractAffiliate bookingContractAffiliate = (BookingContractAffiliate) o;
    return Objects.equals(this.bookingContractIdentifier, bookingContractAffiliate.bookingContractIdentifier) &&
        Objects.equals(this.createdDate, bookingContractAffiliate.createdDate) &&
        Objects.equals(this.lastUpdate, bookingContractAffiliate.lastUpdate) &&
        Objects.equals(this.federatedOrganizationIdentifier, bookingContractAffiliate.federatedOrganizationIdentifier) &&
        Objects.equals(this.federatedOrganizationName, bookingContractAffiliate.federatedOrganizationName) &&
        Objects.equals(this.user, bookingContractAffiliate.user) &&
        Objects.equals(this.ipAddress, bookingContractAffiliate.ipAddress) &&
        Objects.equals(this.traceId, bookingContractAffiliate.traceId) &&
        Objects.equals(this.sourceUrl, bookingContractAffiliate.sourceUrl) &&
        Objects.equals(this.identifier, bookingContractAffiliate.identifier) &&
        Objects.equals(this.supplierIdentifier, bookingContractAffiliate.supplierIdentifier) &&
        Objects.equals(this.supplierName, bookingContractAffiliate.supplierName) &&
        Objects.equals(this.displayPriceQuote, bookingContractAffiliate.displayPriceQuote) &&
        Objects.equals(this.supplierPriceQuote, bookingContractAffiliate.supplierPriceQuote) &&
        Objects.equals(this.internalPriceQuote, bookingContractAffiliate.internalPriceQuote) &&
        Objects.equals(this.capturePriceQuote, bookingContractAffiliate.capturePriceQuote) &&
        Objects.equals(this.itemList, bookingContractAffiliate.itemList) &&
        Objects.equals(this.externalSupplierIdentifier, bookingContractAffiliate.externalSupplierIdentifier) &&
        Objects.equals(this.externalSupplierBookingCode, bookingContractAffiliate.externalSupplierBookingCode) &&
        Objects.equals(this.payment, bookingContractAffiliate.payment) &&
        Objects.equals(this.cancelled, bookingContractAffiliate.cancelled) &&
        Objects.equals(this.cancelledOn, bookingContractAffiliate.cancelledOn) &&
        Objects.equals(this.canceller, bookingContractAffiliate.canceller) &&
        Objects.equals(this.cancellationType, bookingContractAffiliate.cancellationType) &&
        Objects.equals(this.cancellerUserIdentifier, bookingContractAffiliate.cancellerUserIdentifier) &&
        Objects.equals(this.cancelReason, bookingContractAffiliate.cancelReason) &&
        Objects.equals(this.fundsProcessed, bookingContractAffiliate.fundsProcessed) &&
        Objects.equals(this.refunds, bookingContractAffiliate.refunds) &&
        Objects.equals(this.payouts, bookingContractAffiliate.payouts) &&
        Objects.equals(this.sourceCurrency, bookingContractAffiliate.sourceCurrency) &&
        Objects.equals(this.displayCurrency, bookingContractAffiliate.displayCurrency) &&
        Objects.equals(this.supplierCurrency, bookingContractAffiliate.supplierCurrency) &&
        Objects.equals(this.internalCurrency, bookingContractAffiliate.internalCurrency) &&
        Objects.equals(this.captureCurrency, bookingContractAffiliate.captureCurrency) &&
        Objects.equals(this.sourceAmount, bookingContractAffiliate.sourceAmount) &&
        Objects.equals(this.displayAmount, bookingContractAffiliate.displayAmount) &&
        Objects.equals(this.supplierAmount, bookingContractAffiliate.supplierAmount) &&
        Objects.equals(this.internalAmount, bookingContractAffiliate.internalAmount) &&
        Objects.equals(this.captureAmount, bookingContractAffiliate.captureAmount) &&
        Objects.equals(this.sourceAmountRefundModifier, bookingContractAffiliate.sourceAmountRefundModifier) &&
        Objects.equals(this.displayAmountRefundModifier, bookingContractAffiliate.displayAmountRefundModifier) &&
        Objects.equals(this.supplierAmountRefundModifier, bookingContractAffiliate.supplierAmountRefundModifier) &&
        Objects.equals(this.internalAmountRefundModifier, bookingContractAffiliate.internalAmountRefundModifier) &&
        Objects.equals(this.captureAmountRefundModifier, bookingContractAffiliate.captureAmountRefundModifier) &&
        Objects.equals(this.netSourceAmount, bookingContractAffiliate.netSourceAmount) &&
        Objects.equals(this.netDisplayAmount, bookingContractAffiliate.netDisplayAmount) &&
        Objects.equals(this.netSupplierAmount, bookingContractAffiliate.netSupplierAmount) &&
        Objects.equals(this.netInternalAmount, bookingContractAffiliate.netInternalAmount) &&
        Objects.equals(this.netCaptureAmount, bookingContractAffiliate.netCaptureAmount) &&
        Objects.equals(this.totalTokensEarned, bookingContractAffiliate.totalTokensEarned) &&
        Objects.equals(this.metadata, bookingContractAffiliate.metadata) &&
        Objects.equals(this.totalTripPayFeeInPercent, bookingContractAffiliate.totalTripPayFeeInPercent) &&
        Objects.equals(this.hasRefunds, bookingContractAffiliate.hasRefunds) &&
        Objects.equals(this.originalCommissionsInPercent, bookingContractAffiliate.originalCommissionsInPercent) &&
        Objects.equals(this.originalFeesInPercent, bookingContractAffiliate.originalFeesInPercent) &&
        Objects.equals(this.totalCommissionsInPercentWithRefund, bookingContractAffiliate.totalCommissionsInPercentWithRefund) &&
        Objects.equals(this.totalFeesInPercentWithRefund, bookingContractAffiliate.totalFeesInPercentWithRefund) &&
        Objects.equals(this.totalTripPayFeeInPercentWithRefund, bookingContractAffiliate.totalTripPayFeeInPercentWithRefund) &&
        Objects.equals(this.netTotalFeesSupplierAmount, bookingContractAffiliate.netTotalFeesSupplierAmount) &&
        Objects.equals(this.totalFeesSupplierAmount, bookingContractAffiliate.totalFeesSupplierAmount) &&
        Objects.equals(this.netTotalTripPayFeeSupplierAmount, bookingContractAffiliate.netTotalTripPayFeeSupplierAmount) &&
        Objects.equals(this.totalTripPayFeeSupplierAmount, bookingContractAffiliate.totalTripPayFeeSupplierAmount) &&
        Objects.equals(this.netCommissionableTotalSupplierAmount, bookingContractAffiliate.netCommissionableTotalSupplierAmount) &&
        Objects.equals(this.commissionableTotalSupplierAmount, bookingContractAffiliate.commissionableTotalSupplierAmount) &&
        Objects.equals(this.netTotalFeesAndCommissionsSupplierAmount, bookingContractAffiliate.netTotalFeesAndCommissionsSupplierAmount) &&
        Objects.equals(this.totalFeesAndCommissionsSupplierAmount, bookingContractAffiliate.totalFeesAndCommissionsSupplierAmount) &&
        Objects.equals(this.cancellableWithNoCharges, bookingContractAffiliate.cancellableWithNoCharges) &&
        Objects.equals(this.isCancellableWithPotentialCharges, bookingContractAffiliate.isCancellableWithPotentialCharges) &&
        Objects.equals(this.netCommissionableTotalSourceAmount, bookingContractAffiliate.netCommissionableTotalSourceAmount) &&
        Objects.equals(this.netCommissionableTotalCaptureAmount, bookingContractAffiliate.netCommissionableTotalCaptureAmount) &&
        Objects.equals(this.netCommissionableTotalDisplayAmount, bookingContractAffiliate.netCommissionableTotalDisplayAmount) &&
        Objects.equals(this.netCommissionableTotalInternalAmount, bookingContractAffiliate.netCommissionableTotalInternalAmount) &&
        Objects.equals(this.netTotalFeesAndCommissionsSourceAmount, bookingContractAffiliate.netTotalFeesAndCommissionsSourceAmount) &&
        Objects.equals(this.netTotalFeesAndCommissionsCaptureAmount, bookingContractAffiliate.netTotalFeesAndCommissionsCaptureAmount) &&
        Objects.equals(this.netTotalFeesAndCommissionsDisplayAmount, bookingContractAffiliate.netTotalFeesAndCommissionsDisplayAmount) &&
        Objects.equals(this.netTotalFeesAndCommissionsInternalAmount, bookingContractAffiliate.netTotalFeesAndCommissionsInternalAmount) &&
        Objects.equals(this.netTotalFeesSourceAmount, bookingContractAffiliate.netTotalFeesSourceAmount) &&
        Objects.equals(this.netTotalFeesCaptureAmount, bookingContractAffiliate.netTotalFeesCaptureAmount) &&
        Objects.equals(this.netTotalFeesDisplayAmount, bookingContractAffiliate.netTotalFeesDisplayAmount) &&
        Objects.equals(this.netTotalFeesInternalAmount, bookingContractAffiliate.netTotalFeesInternalAmount) &&
        Objects.equals(this.netTotalTripPayFeeSourceAmount, bookingContractAffiliate.netTotalTripPayFeeSourceAmount) &&
        Objects.equals(this.netTotalTripPayFeeCaptureAmount, bookingContractAffiliate.netTotalTripPayFeeCaptureAmount) &&
        Objects.equals(this.netTotalTripPayFeeDisplayAmount, bookingContractAffiliate.netTotalTripPayFeeDisplayAmount) &&
        Objects.equals(this.netTotalTripPayFeeInternalAmount, bookingContractAffiliate.netTotalTripPayFeeInternalAmount) &&
        Objects.equals(this.netTotalSalesSourceAmount, bookingContractAffiliate.netTotalSalesSourceAmount) &&
        Objects.equals(this.netTotalSalesCaptureAmount, bookingContractAffiliate.netTotalSalesCaptureAmount) &&
        Objects.equals(this.netTotalSalesDisplayAmount, bookingContractAffiliate.netTotalSalesDisplayAmount) &&
        Objects.equals(this.netTotalSalesSupplierAmount, bookingContractAffiliate.netTotalSalesSupplierAmount) &&
        Objects.equals(this.netTotalSalesInternalAmount, bookingContractAffiliate.netTotalSalesInternalAmount) &&
        Objects.equals(this.commissionableTotalSourceAmount, bookingContractAffiliate.commissionableTotalSourceAmount) &&
        Objects.equals(this.commissionableTotalCaptureAmount, bookingContractAffiliate.commissionableTotalCaptureAmount) &&
        Objects.equals(this.commissionableTotalDisplayAmount, bookingContractAffiliate.commissionableTotalDisplayAmount) &&
        Objects.equals(this.commissionableTotalInternalAmount, bookingContractAffiliate.commissionableTotalInternalAmount) &&
        Objects.equals(this.totalFeesAndCommissionsSourceAmount, bookingContractAffiliate.totalFeesAndCommissionsSourceAmount) &&
        Objects.equals(this.totalFeesAndCommissionsCaptureAmount, bookingContractAffiliate.totalFeesAndCommissionsCaptureAmount) &&
        Objects.equals(this.totalFeesAndCommissionsDisplayAmount, bookingContractAffiliate.totalFeesAndCommissionsDisplayAmount) &&
        Objects.equals(this.totalFeesAndCommissionsInternalAmount, bookingContractAffiliate.totalFeesAndCommissionsInternalAmount) &&
        Objects.equals(this.totalFeesSourceAmount, bookingContractAffiliate.totalFeesSourceAmount) &&
        Objects.equals(this.totalFeesCaptureAmount, bookingContractAffiliate.totalFeesCaptureAmount) &&
        Objects.equals(this.totalFeesDisplayAmount, bookingContractAffiliate.totalFeesDisplayAmount) &&
        Objects.equals(this.totalFeesInternalAmount, bookingContractAffiliate.totalFeesInternalAmount) &&
        Objects.equals(this.totalTripPayFeeSourceAmount, bookingContractAffiliate.totalTripPayFeeSourceAmount) &&
        Objects.equals(this.totalTripPayFeeCaptureAmount, bookingContractAffiliate.totalTripPayFeeCaptureAmount) &&
        Objects.equals(this.totalTripPayFeeDisplayAmount, bookingContractAffiliate.totalTripPayFeeDisplayAmount) &&
        Objects.equals(this.totalTripPayFeeInternalAmount, bookingContractAffiliate.totalTripPayFeeInternalAmount) &&
        Objects.equals(this.totalSalesSourceAmount, bookingContractAffiliate.totalSalesSourceAmount) &&
        Objects.equals(this.totalSalesCaptureAmount, bookingContractAffiliate.totalSalesCaptureAmount) &&
        Objects.equals(this.totalSalesDisplayAmount, bookingContractAffiliate.totalSalesDisplayAmount) &&
        Objects.equals(this.totalSalesSupplierAmount, bookingContractAffiliate.totalSalesSupplierAmount) &&
        Objects.equals(this.totalSalesInternalAmount, bookingContractAffiliate.totalSalesInternalAmount) &&
        Objects.equals(this.fundsAvailableDate, bookingContractAffiliate.fundsAvailableDate) &&
        Objects.equals(this.totalFeesInPercent, bookingContractAffiliate.totalFeesInPercent) &&
        Objects.equals(this.totalCommissionsInPercent, bookingContractAffiliate.totalCommissionsInPercent) &&
        Objects.equals(this.totalFeesAndCommissionsInPercentWithRefund, bookingContractAffiliate.totalFeesAndCommissionsInPercentWithRefund) &&
        Objects.equals(this.totalFeesAndCommissionsInPercent, bookingContractAffiliate.totalFeesAndCommissionsInPercent) &&
        Objects.equals(this.netTotalCustomersSourceAmount, bookingContractAffiliate.netTotalCustomersSourceAmount) &&
        Objects.equals(this.netTotalCustomersCaptureAmount, bookingContractAffiliate.netTotalCustomersCaptureAmount) &&
        Objects.equals(this.netTotalCustomersDisplayAmount, bookingContractAffiliate.netTotalCustomersDisplayAmount) &&
        Objects.equals(this.netTotalCustomersSupplierAmount, bookingContractAffiliate.netTotalCustomersSupplierAmount) &&
        Objects.equals(this.netTotalCustomersInternalAmount, bookingContractAffiliate.netTotalCustomersInternalAmount) &&
        Objects.equals(this.hasSuccessfulRefunds, bookingContractAffiliate.hasSuccessfulRefunds) &&
        Objects.equals(this.hasPendingRefunds, bookingContractAffiliate.hasPendingRefunds) &&
        Objects.equals(this.hasFailedRefunds, bookingContractAffiliate.hasFailedRefunds) &&
        Objects.equals(this.lodging, bookingContractAffiliate.lodging) &&
        Objects.equals(this.cancellableBySupplier, bookingContractAffiliate.cancellableBySupplier) &&
        Objects.equals(this.cancellableByTraveler, bookingContractAffiliate.cancellableByTraveler);
  }

  @Override
  public int hashCode() {
    return Objects.hash(bookingContractIdentifier, createdDate, lastUpdate, federatedOrganizationIdentifier, federatedOrganizationName, user, ipAddress, traceId, sourceUrl, identifier, supplierIdentifier, supplierName, displayPriceQuote, supplierPriceQuote, internalPriceQuote, capturePriceQuote, itemList, externalSupplierIdentifier, externalSupplierBookingCode, payment, cancelled, cancelledOn, canceller, cancellationType, cancellerUserIdentifier, cancelReason, fundsProcessed, refunds, payouts, sourceCurrency, displayCurrency, supplierCurrency, internalCurrency, captureCurrency, sourceAmount, displayAmount, supplierAmount, internalAmount, captureAmount, sourceAmountRefundModifier, displayAmountRefundModifier, supplierAmountRefundModifier, internalAmountRefundModifier, captureAmountRefundModifier, netSourceAmount, netDisplayAmount, netSupplierAmount, netInternalAmount, netCaptureAmount, totalTokensEarned, metadata, totalTripPayFeeInPercent, hasRefunds, originalCommissionsInPercent, originalFeesInPercent, totalCommissionsInPercentWithRefund, totalFeesInPercentWithRefund, totalTripPayFeeInPercentWithRefund, netTotalFeesSupplierAmount, totalFeesSupplierAmount, netTotalTripPayFeeSupplierAmount, totalTripPayFeeSupplierAmount, netCommissionableTotalSupplierAmount, commissionableTotalSupplierAmount, netTotalFeesAndCommissionsSupplierAmount, totalFeesAndCommissionsSupplierAmount, cancellableWithNoCharges, isCancellableWithPotentialCharges, netCommissionableTotalSourceAmount, netCommissionableTotalCaptureAmount, netCommissionableTotalDisplayAmount, netCommissionableTotalInternalAmount, netTotalFeesAndCommissionsSourceAmount, netTotalFeesAndCommissionsCaptureAmount, netTotalFeesAndCommissionsDisplayAmount, netTotalFeesAndCommissionsInternalAmount, netTotalFeesSourceAmount, netTotalFeesCaptureAmount, netTotalFeesDisplayAmount, netTotalFeesInternalAmount, netTotalTripPayFeeSourceAmount, netTotalTripPayFeeCaptureAmount, netTotalTripPayFeeDisplayAmount, netTotalTripPayFeeInternalAmount, netTotalSalesSourceAmount, netTotalSalesCaptureAmount, netTotalSalesDisplayAmount, netTotalSalesSupplierAmount, netTotalSalesInternalAmount, commissionableTotalSourceAmount, commissionableTotalCaptureAmount, commissionableTotalDisplayAmount, commissionableTotalInternalAmount, totalFeesAndCommissionsSourceAmount, totalFeesAndCommissionsCaptureAmount, totalFeesAndCommissionsDisplayAmount, totalFeesAndCommissionsInternalAmount, totalFeesSourceAmount, totalFeesCaptureAmount, totalFeesDisplayAmount, totalFeesInternalAmount, totalTripPayFeeSourceAmount, totalTripPayFeeCaptureAmount, totalTripPayFeeDisplayAmount, totalTripPayFeeInternalAmount, totalSalesSourceAmount, totalSalesCaptureAmount, totalSalesDisplayAmount, totalSalesSupplierAmount, totalSalesInternalAmount, fundsAvailableDate, totalFeesInPercent, totalCommissionsInPercent, totalFeesAndCommissionsInPercentWithRefund, totalFeesAndCommissionsInPercent, netTotalCustomersSourceAmount, netTotalCustomersCaptureAmount, netTotalCustomersDisplayAmount, netTotalCustomersSupplierAmount, netTotalCustomersInternalAmount, hasSuccessfulRefunds, hasPendingRefunds, hasFailedRefunds, lodging, cancellableBySupplier, cancellableByTraveler);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class BookingContractAffiliate {\n");
    sb.append("    bookingContractIdentifier: ").append(toIndentedString(bookingContractIdentifier)).append("\n");
    sb.append("    createdDate: ").append(toIndentedString(createdDate)).append("\n");
    sb.append("    lastUpdate: ").append(toIndentedString(lastUpdate)).append("\n");
    sb.append("    federatedOrganizationIdentifier: ").append(toIndentedString(federatedOrganizationIdentifier)).append("\n");
    sb.append("    federatedOrganizationName: ").append(toIndentedString(federatedOrganizationName)).append("\n");
    sb.append("    user: ").append(toIndentedString(user)).append("\n");
    sb.append("    ipAddress: ").append(toIndentedString(ipAddress)).append("\n");
    sb.append("    traceId: ").append(toIndentedString(traceId)).append("\n");
    sb.append("    sourceUrl: ").append(toIndentedString(sourceUrl)).append("\n");
    sb.append("    identifier: ").append(toIndentedString(identifier)).append("\n");
    sb.append("    supplierIdentifier: ").append(toIndentedString(supplierIdentifier)).append("\n");
    sb.append("    supplierName: ").append(toIndentedString(supplierName)).append("\n");
    sb.append("    displayPriceQuote: ").append(toIndentedString(displayPriceQuote)).append("\n");
    sb.append("    supplierPriceQuote: ").append(toIndentedString(supplierPriceQuote)).append("\n");
    sb.append("    internalPriceQuote: ").append(toIndentedString(internalPriceQuote)).append("\n");
    sb.append("    capturePriceQuote: ").append(toIndentedString(capturePriceQuote)).append("\n");
    sb.append("    itemList: ").append(toIndentedString(itemList)).append("\n");
    sb.append("    externalSupplierIdentifier: ").append(toIndentedString(externalSupplierIdentifier)).append("\n");
    sb.append("    externalSupplierBookingCode: ").append(toIndentedString(externalSupplierBookingCode)).append("\n");
    sb.append("    payment: ").append(toIndentedString(payment)).append("\n");
    sb.append("    cancelled: ").append(toIndentedString(cancelled)).append("\n");
    sb.append("    cancelledOn: ").append(toIndentedString(cancelledOn)).append("\n");
    sb.append("    canceller: ").append(toIndentedString(canceller)).append("\n");
    sb.append("    cancellationType: ").append(toIndentedString(cancellationType)).append("\n");
    sb.append("    cancellerUserIdentifier: ").append(toIndentedString(cancellerUserIdentifier)).append("\n");
    sb.append("    cancelReason: ").append(toIndentedString(cancelReason)).append("\n");
    sb.append("    fundsProcessed: ").append(toIndentedString(fundsProcessed)).append("\n");
    sb.append("    refunds: ").append(toIndentedString(refunds)).append("\n");
    sb.append("    payouts: ").append(toIndentedString(payouts)).append("\n");
    sb.append("    sourceCurrency: ").append(toIndentedString(sourceCurrency)).append("\n");
    sb.append("    displayCurrency: ").append(toIndentedString(displayCurrency)).append("\n");
    sb.append("    supplierCurrency: ").append(toIndentedString(supplierCurrency)).append("\n");
    sb.append("    internalCurrency: ").append(toIndentedString(internalCurrency)).append("\n");
    sb.append("    captureCurrency: ").append(toIndentedString(captureCurrency)).append("\n");
    sb.append("    sourceAmount: ").append(toIndentedString(sourceAmount)).append("\n");
    sb.append("    displayAmount: ").append(toIndentedString(displayAmount)).append("\n");
    sb.append("    supplierAmount: ").append(toIndentedString(supplierAmount)).append("\n");
    sb.append("    internalAmount: ").append(toIndentedString(internalAmount)).append("\n");
    sb.append("    captureAmount: ").append(toIndentedString(captureAmount)).append("\n");
    sb.append("    sourceAmountRefundModifier: ").append(toIndentedString(sourceAmountRefundModifier)).append("\n");
    sb.append("    displayAmountRefundModifier: ").append(toIndentedString(displayAmountRefundModifier)).append("\n");
    sb.append("    supplierAmountRefundModifier: ").append(toIndentedString(supplierAmountRefundModifier)).append("\n");
    sb.append("    internalAmountRefundModifier: ").append(toIndentedString(internalAmountRefundModifier)).append("\n");
    sb.append("    captureAmountRefundModifier: ").append(toIndentedString(captureAmountRefundModifier)).append("\n");
    sb.append("    netSourceAmount: ").append(toIndentedString(netSourceAmount)).append("\n");
    sb.append("    netDisplayAmount: ").append(toIndentedString(netDisplayAmount)).append("\n");
    sb.append("    netSupplierAmount: ").append(toIndentedString(netSupplierAmount)).append("\n");
    sb.append("    netInternalAmount: ").append(toIndentedString(netInternalAmount)).append("\n");
    sb.append("    netCaptureAmount: ").append(toIndentedString(netCaptureAmount)).append("\n");
    sb.append("    totalTokensEarned: ").append(toIndentedString(totalTokensEarned)).append("\n");
    sb.append("    metadata: ").append(toIndentedString(metadata)).append("\n");
    sb.append("    totalTripPayFeeInPercent: ").append(toIndentedString(totalTripPayFeeInPercent)).append("\n");
    sb.append("    hasRefunds: ").append(toIndentedString(hasRefunds)).append("\n");
    sb.append("    originalCommissionsInPercent: ").append(toIndentedString(originalCommissionsInPercent)).append("\n");
    sb.append("    originalFeesInPercent: ").append(toIndentedString(originalFeesInPercent)).append("\n");
    sb.append("    totalCommissionsInPercentWithRefund: ").append(toIndentedString(totalCommissionsInPercentWithRefund)).append("\n");
    sb.append("    totalFeesInPercentWithRefund: ").append(toIndentedString(totalFeesInPercentWithRefund)).append("\n");
    sb.append("    totalTripPayFeeInPercentWithRefund: ").append(toIndentedString(totalTripPayFeeInPercentWithRefund)).append("\n");
    sb.append("    netTotalFeesSupplierAmount: ").append(toIndentedString(netTotalFeesSupplierAmount)).append("\n");
    sb.append("    totalFeesSupplierAmount: ").append(toIndentedString(totalFeesSupplierAmount)).append("\n");
    sb.append("    netTotalTripPayFeeSupplierAmount: ").append(toIndentedString(netTotalTripPayFeeSupplierAmount)).append("\n");
    sb.append("    totalTripPayFeeSupplierAmount: ").append(toIndentedString(totalTripPayFeeSupplierAmount)).append("\n");
    sb.append("    netCommissionableTotalSupplierAmount: ").append(toIndentedString(netCommissionableTotalSupplierAmount)).append("\n");
    sb.append("    commissionableTotalSupplierAmount: ").append(toIndentedString(commissionableTotalSupplierAmount)).append("\n");
    sb.append("    netTotalFeesAndCommissionsSupplierAmount: ").append(toIndentedString(netTotalFeesAndCommissionsSupplierAmount)).append("\n");
    sb.append("    totalFeesAndCommissionsSupplierAmount: ").append(toIndentedString(totalFeesAndCommissionsSupplierAmount)).append("\n");
    sb.append("    cancellableWithNoCharges: ").append(toIndentedString(cancellableWithNoCharges)).append("\n");
    sb.append("    isCancellableWithPotentialCharges: ").append(toIndentedString(isCancellableWithPotentialCharges)).append("\n");
    sb.append("    netCommissionableTotalSourceAmount: ").append(toIndentedString(netCommissionableTotalSourceAmount)).append("\n");
    sb.append("    netCommissionableTotalCaptureAmount: ").append(toIndentedString(netCommissionableTotalCaptureAmount)).append("\n");
    sb.append("    netCommissionableTotalDisplayAmount: ").append(toIndentedString(netCommissionableTotalDisplayAmount)).append("\n");
    sb.append("    netCommissionableTotalInternalAmount: ").append(toIndentedString(netCommissionableTotalInternalAmount)).append("\n");
    sb.append("    netTotalFeesAndCommissionsSourceAmount: ").append(toIndentedString(netTotalFeesAndCommissionsSourceAmount)).append("\n");
    sb.append("    netTotalFeesAndCommissionsCaptureAmount: ").append(toIndentedString(netTotalFeesAndCommissionsCaptureAmount)).append("\n");
    sb.append("    netTotalFeesAndCommissionsDisplayAmount: ").append(toIndentedString(netTotalFeesAndCommissionsDisplayAmount)).append("\n");
    sb.append("    netTotalFeesAndCommissionsInternalAmount: ").append(toIndentedString(netTotalFeesAndCommissionsInternalAmount)).append("\n");
    sb.append("    netTotalFeesSourceAmount: ").append(toIndentedString(netTotalFeesSourceAmount)).append("\n");
    sb.append("    netTotalFeesCaptureAmount: ").append(toIndentedString(netTotalFeesCaptureAmount)).append("\n");
    sb.append("    netTotalFeesDisplayAmount: ").append(toIndentedString(netTotalFeesDisplayAmount)).append("\n");
    sb.append("    netTotalFeesInternalAmount: ").append(toIndentedString(netTotalFeesInternalAmount)).append("\n");
    sb.append("    netTotalTripPayFeeSourceAmount: ").append(toIndentedString(netTotalTripPayFeeSourceAmount)).append("\n");
    sb.append("    netTotalTripPayFeeCaptureAmount: ").append(toIndentedString(netTotalTripPayFeeCaptureAmount)).append("\n");
    sb.append("    netTotalTripPayFeeDisplayAmount: ").append(toIndentedString(netTotalTripPayFeeDisplayAmount)).append("\n");
    sb.append("    netTotalTripPayFeeInternalAmount: ").append(toIndentedString(netTotalTripPayFeeInternalAmount)).append("\n");
    sb.append("    netTotalSalesSourceAmount: ").append(toIndentedString(netTotalSalesSourceAmount)).append("\n");
    sb.append("    netTotalSalesCaptureAmount: ").append(toIndentedString(netTotalSalesCaptureAmount)).append("\n");
    sb.append("    netTotalSalesDisplayAmount: ").append(toIndentedString(netTotalSalesDisplayAmount)).append("\n");
    sb.append("    netTotalSalesSupplierAmount: ").append(toIndentedString(netTotalSalesSupplierAmount)).append("\n");
    sb.append("    netTotalSalesInternalAmount: ").append(toIndentedString(netTotalSalesInternalAmount)).append("\n");
    sb.append("    commissionableTotalSourceAmount: ").append(toIndentedString(commissionableTotalSourceAmount)).append("\n");
    sb.append("    commissionableTotalCaptureAmount: ").append(toIndentedString(commissionableTotalCaptureAmount)).append("\n");
    sb.append("    commissionableTotalDisplayAmount: ").append(toIndentedString(commissionableTotalDisplayAmount)).append("\n");
    sb.append("    commissionableTotalInternalAmount: ").append(toIndentedString(commissionableTotalInternalAmount)).append("\n");
    sb.append("    totalFeesAndCommissionsSourceAmount: ").append(toIndentedString(totalFeesAndCommissionsSourceAmount)).append("\n");
    sb.append("    totalFeesAndCommissionsCaptureAmount: ").append(toIndentedString(totalFeesAndCommissionsCaptureAmount)).append("\n");
    sb.append("    totalFeesAndCommissionsDisplayAmount: ").append(toIndentedString(totalFeesAndCommissionsDisplayAmount)).append("\n");
    sb.append("    totalFeesAndCommissionsInternalAmount: ").append(toIndentedString(totalFeesAndCommissionsInternalAmount)).append("\n");
    sb.append("    totalFeesSourceAmount: ").append(toIndentedString(totalFeesSourceAmount)).append("\n");
    sb.append("    totalFeesCaptureAmount: ").append(toIndentedString(totalFeesCaptureAmount)).append("\n");
    sb.append("    totalFeesDisplayAmount: ").append(toIndentedString(totalFeesDisplayAmount)).append("\n");
    sb.append("    totalFeesInternalAmount: ").append(toIndentedString(totalFeesInternalAmount)).append("\n");
    sb.append("    totalTripPayFeeSourceAmount: ").append(toIndentedString(totalTripPayFeeSourceAmount)).append("\n");
    sb.append("    totalTripPayFeeCaptureAmount: ").append(toIndentedString(totalTripPayFeeCaptureAmount)).append("\n");
    sb.append("    totalTripPayFeeDisplayAmount: ").append(toIndentedString(totalTripPayFeeDisplayAmount)).append("\n");
    sb.append("    totalTripPayFeeInternalAmount: ").append(toIndentedString(totalTripPayFeeInternalAmount)).append("\n");
    sb.append("    totalSalesSourceAmount: ").append(toIndentedString(totalSalesSourceAmount)).append("\n");
    sb.append("    totalSalesCaptureAmount: ").append(toIndentedString(totalSalesCaptureAmount)).append("\n");
    sb.append("    totalSalesDisplayAmount: ").append(toIndentedString(totalSalesDisplayAmount)).append("\n");
    sb.append("    totalSalesSupplierAmount: ").append(toIndentedString(totalSalesSupplierAmount)).append("\n");
    sb.append("    totalSalesInternalAmount: ").append(toIndentedString(totalSalesInternalAmount)).append("\n");
    sb.append("    fundsAvailableDate: ").append(toIndentedString(fundsAvailableDate)).append("\n");
    sb.append("    totalFeesInPercent: ").append(toIndentedString(totalFeesInPercent)).append("\n");
    sb.append("    totalCommissionsInPercent: ").append(toIndentedString(totalCommissionsInPercent)).append("\n");
    sb.append("    totalFeesAndCommissionsInPercentWithRefund: ").append(toIndentedString(totalFeesAndCommissionsInPercentWithRefund)).append("\n");
    sb.append("    totalFeesAndCommissionsInPercent: ").append(toIndentedString(totalFeesAndCommissionsInPercent)).append("\n");
    sb.append("    netTotalCustomersSourceAmount: ").append(toIndentedString(netTotalCustomersSourceAmount)).append("\n");
    sb.append("    netTotalCustomersCaptureAmount: ").append(toIndentedString(netTotalCustomersCaptureAmount)).append("\n");
    sb.append("    netTotalCustomersDisplayAmount: ").append(toIndentedString(netTotalCustomersDisplayAmount)).append("\n");
    sb.append("    netTotalCustomersSupplierAmount: ").append(toIndentedString(netTotalCustomersSupplierAmount)).append("\n");
    sb.append("    netTotalCustomersInternalAmount: ").append(toIndentedString(netTotalCustomersInternalAmount)).append("\n");
    sb.append("    hasSuccessfulRefunds: ").append(toIndentedString(hasSuccessfulRefunds)).append("\n");
    sb.append("    hasPendingRefunds: ").append(toIndentedString(hasPendingRefunds)).append("\n");
    sb.append("    hasFailedRefunds: ").append(toIndentedString(hasFailedRefunds)).append("\n");
    sb.append("    lodging: ").append(toIndentedString(lodging)).append("\n");
    sb.append("    cancellableBySupplier: ").append(toIndentedString(cancellableBySupplier)).append("\n");
    sb.append("    cancellableByTraveler: ").append(toIndentedString(cancellableByTraveler)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

