/*
 * Wink API
 * ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Affiliate](/affiliate): All APIs related to selling travel inventory as an affiliate. - [Analytics](/analytics): All APIs related to tracking metrics across a wide variety of data source segments including, more entertaining, leaderboard metrics. - [Booking](/booking): All APIs related to creating platform bookings. - [Channel Manager](/channel-manager): All APIs related to channel managers who want to integrate with our platform. - [Extranet](/extranet): All APIs related to managing travel inventory and suppliers. - [Inventory](/inventory): All APIs related to retrieve known travel inventory as it was found using the Lookup API.. - [Lookup](/lookup): All APIs related to locating inventory by region, locale and property flags. - [Reference](/reference): All APIs related to retrieving platform-supported taxonomies. - [TripPay Acquiring](/payment-acquiring): All APIs related to capture payment details such as a Stripe payment intent. - [TripPay](/payment): All APIs related to TripPay account management, booking, mapping and integration features.  ## SDKs We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).  - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)  ## Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Wink-Version` header. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints.  ## Release history - 2022-10-15: v2.0 - Removed HATEOAS and added Wink-Version header - 2022-05-08: v1 - Exposed channel manager API - 2021-07-01: v1 - Initial release  # Affiliate API Welcome to the Affiliate API - A programmer-friendly way to search for and display bespoke travel inventory for your audience. Use this API to help you prepare travel inventory for sale.  # Intended Audience Programmers are a requirement to start integrating with wink. You will benefit from an API integration if you are new or existing travel related company that want easy access to great inventory.## Examples: - Hotel brands / chains that want to make their own booking engine - Travel tech companies that want to create the next hot mobile travel app - Destination sites that want to make their own booking engine - Bloggers and influencers who want to sell travel inventory to their audience - OTAs that want access direct relationships with suppliers and better quality hotel inventory
 *
 * The version of the OpenAPI document: 29.12.0
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.affiliate.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.UUID;
import travel.wink.sdk.affiliate.model.BookingUserAddressAffiliate;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * GuestUserAffiliate
 */
@JsonPropertyOrder({
  GuestUserAffiliate.JSON_PROPERTY_USER_IDENTIFIER,
  GuestUserAffiliate.JSON_PROPERTY_FIRST_NAME,
  GuestUserAffiliate.JSON_PROPERTY_LAST_NAME,
  GuestUserAffiliate.JSON_PROPERTY_EMAIL,
  GuestUserAffiliate.JSON_PROPERTY_TELEPHONE,
  GuestUserAffiliate.JSON_PROPERTY_ADDRESS,
  GuestUserAffiliate.JSON_PROPERTY_FULL_NAME
})
@JsonTypeName("GuestUser_Affiliate")
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-10-16T10:17:15.847873815+07:00[Asia/Bangkok]")
public class GuestUserAffiliate {
  public static final String JSON_PROPERTY_USER_IDENTIFIER = "userIdentifier";
  private UUID userIdentifier;

  public static final String JSON_PROPERTY_FIRST_NAME = "firstName";
  private String firstName;

  public static final String JSON_PROPERTY_LAST_NAME = "lastName";
  private String lastName;

  public static final String JSON_PROPERTY_EMAIL = "email";
  private String email;

  public static final String JSON_PROPERTY_TELEPHONE = "telephone";
  private String telephone;

  public static final String JSON_PROPERTY_ADDRESS = "address";
  private BookingUserAddressAffiliate address;

  public static final String JSON_PROPERTY_FULL_NAME = "fullName";
  private String fullName;

  public GuestUserAffiliate() {
  }

  @JsonCreator
  public GuestUserAffiliate(
    @JsonProperty(JSON_PROPERTY_FULL_NAME) String fullName
  ) {
    this();
    this.fullName = fullName;
  }

  public GuestUserAffiliate userIdentifier(UUID userIdentifier) {
    
    this.userIdentifier = userIdentifier;
    return this;
  }

   /**
   * User identifier
   * @return userIdentifier
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_USER_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public UUID getUserIdentifier() {
    return userIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_USER_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setUserIdentifier(UUID userIdentifier) {
    this.userIdentifier = userIdentifier;
  }


  public GuestUserAffiliate firstName(String firstName) {
    
    this.firstName = firstName;
    return this;
  }

   /**
   * First name
   * @return firstName
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_FIRST_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getFirstName() {
    return firstName;
  }


  @JsonProperty(JSON_PROPERTY_FIRST_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setFirstName(String firstName) {
    this.firstName = firstName;
  }


  public GuestUserAffiliate lastName(String lastName) {
    
    this.lastName = lastName;
    return this;
  }

   /**
   * Last name
   * @return lastName
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_LAST_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getLastName() {
    return lastName;
  }


  @JsonProperty(JSON_PROPERTY_LAST_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setLastName(String lastName) {
    this.lastName = lastName;
  }


  public GuestUserAffiliate email(String email) {
    
    this.email = email;
    return this;
  }

   /**
   * Email
   * @return email
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_EMAIL)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getEmail() {
    return email;
  }


  @JsonProperty(JSON_PROPERTY_EMAIL)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setEmail(String email) {
    this.email = email;
  }


  public GuestUserAffiliate telephone(String telephone) {
    
    this.telephone = telephone;
    return this;
  }

   /**
   * Telephone
   * @return telephone
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_TELEPHONE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getTelephone() {
    return telephone;
  }


  @JsonProperty(JSON_PROPERTY_TELEPHONE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTelephone(String telephone) {
    this.telephone = telephone;
  }


  public GuestUserAffiliate address(BookingUserAddressAffiliate address) {
    
    this.address = address;
    return this;
  }

   /**
   * Get address
   * @return address
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_ADDRESS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public BookingUserAddressAffiliate getAddress() {
    return address;
  }


  @JsonProperty(JSON_PROPERTY_ADDRESS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAddress(BookingUserAddressAffiliate address) {
    this.address = address;
  }


   /**
   * Full name
   * @return fullName
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_FULL_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getFullName() {
    return fullName;
  }



  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    GuestUserAffiliate guestUserAffiliate = (GuestUserAffiliate) o;
    return Objects.equals(this.userIdentifier, guestUserAffiliate.userIdentifier) &&
        Objects.equals(this.firstName, guestUserAffiliate.firstName) &&
        Objects.equals(this.lastName, guestUserAffiliate.lastName) &&
        Objects.equals(this.email, guestUserAffiliate.email) &&
        Objects.equals(this.telephone, guestUserAffiliate.telephone) &&
        Objects.equals(this.address, guestUserAffiliate.address) &&
        Objects.equals(this.fullName, guestUserAffiliate.fullName);
  }

  @Override
  public int hashCode() {
    return Objects.hash(userIdentifier, firstName, lastName, email, telephone, address, fullName);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class GuestUserAffiliate {\n");
    sb.append("    userIdentifier: ").append(toIndentedString(userIdentifier)).append("\n");
    sb.append("    firstName: ").append(toIndentedString(firstName)).append("\n");
    sb.append("    lastName: ").append(toIndentedString(lastName)).append("\n");
    sb.append("    email: ").append(toIndentedString(email)).append("\n");
    sb.append("    telephone: ").append(toIndentedString(telephone)).append("\n");
    sb.append("    address: ").append(toIndentedString(address)).append("\n");
    sb.append("    fullName: ").append(toIndentedString(fullName)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

