/*
 * Wink API
 * ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Affiliate](/affiliate): All APIs related to selling travel inventory as an affiliate. - [Analytics](/analytics): All APIs related to tracking metrics across a wide variety of data source segments including, more entertaining, leaderboard metrics. - [Booking](/booking): All APIs related to creating platform bookings. - [Channel Manager](/channel-manager): All APIs related to channel managers who want to integrate with our platform. - [Extranet](/extranet): All APIs related to managing travel inventory and suppliers. - [Inventory](/inventory): All APIs related to retrieve known travel inventory as it was found using the Lookup API.. - [Lookup](/lookup): All APIs related to locating inventory by region, locale and property flags. - [Reference](/reference): All APIs related to retrieving platform-supported taxonomies. - [TripPay Acquiring](/payment-acquiring): All APIs related to capture payment details such as a Stripe payment intent. - [TripPay](/payment): All APIs related to TripPay account management, booking, mapping and integration features.  ## SDKs We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).  - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)  ## Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Wink-Version` header. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints.  ## Release history - 2022-10-15: v2.0 - Removed HATEOAS and added Wink-Version header - 2022-05-08: v1 - Exposed channel manager API - 2021-07-01: v1 - Initial release  # Affiliate API Welcome to the Affiliate API - A programmer-friendly way to search for and display bespoke travel inventory for your audience. Use this API to help you prepare travel inventory for sale.  # Intended Audience Programmers are a requirement to start integrating with wink. You will benefit from an API integration if you are new or existing travel related company that want easy access to great inventory.## Examples: - Hotel brands / chains that want to make their own booking engine - Travel tech companies that want to create the next hot mobile travel app - Destination sites that want to make their own booking engine - Bloggers and influencers who want to sell travel inventory to their audience - OTAs that want access direct relationships with suppliers and better quality hotel inventory
 *
 * The version of the OpenAPI document: 29.12.0
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.affiliate.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.UUID;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * A request for relationship between two parties.
 */
@JsonPropertyOrder({
  SalesChannelRelationshipRequest.JSON_PROPERTY_IDENTIFIER,
  SalesChannelRelationshipRequest.JSON_PROPERTY_STATUS,
  SalesChannelRelationshipRequest.JSON_PROPERTY_REQUEST_TYPE,
  SalesChannelRelationshipRequest.JSON_PROPERTY_SUPPLIER_IDENTIFIER,
  SalesChannelRelationshipRequest.JSON_PROPERTY_SUPPLIER_NAME,
  SalesChannelRelationshipRequest.JSON_PROPERTY_SUB_TYPE,
  SalesChannelRelationshipRequest.JSON_PROPERTY_OWNER_IDENTIFIER,
  SalesChannelRelationshipRequest.JSON_PROPERTY_OWNER_NAME,
  SalesChannelRelationshipRequest.JSON_PROPERTY_INTRODUCTORY_MESSAGE
})
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-10-16T10:17:15.847873815+07:00[Asia/Bangkok]")
public class SalesChannelRelationshipRequest {
  public static final String JSON_PROPERTY_IDENTIFIER = "identifier";
  private UUID identifier;

  /**
   * status of relationship request
   */
  public enum StatusEnum {
    REQUESTING("REQUESTING"),
    
    REJECTED("REJECTED");

    private String value;

    StatusEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static StatusEnum fromValue(String value) {
      for (StatusEnum b : StatusEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_STATUS = "status";
  private StatusEnum status;

  /**
   * type of relationship request
   */
  public enum RequestTypeEnum {
    DIRECT_CONNECTION("DIRECT_CONNECTION");

    private String value;

    RequestTypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static RequestTypeEnum fromValue(String value) {
      for (RequestTypeEnum b : RequestTypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_REQUEST_TYPE = "requestType";
  private RequestTypeEnum requestType;

  public static final String JSON_PROPERTY_SUPPLIER_IDENTIFIER = "supplierIdentifier";
  private UUID supplierIdentifier;

  public static final String JSON_PROPERTY_SUPPLIER_NAME = "supplierName";
  private String supplierName;

  /**
   * What type of segment of channel is this.
   */
  public enum SubTypeEnum {
    DIRECT("DIRECT"),
    
    APPLICATION("APPLICATION"),
    
    HOTEL("HOTEL"),
    
    TRAVELIKO("TRAVELIKO"),
    
    CORPORATE("CORPORATE"),
    
    TRAVEL_AGENT("TRAVEL_AGENT"),
    
    INFLUENCER("INFLUENCER"),
    
    BLOGGER("BLOGGER"),
    
    DESTINATION("DESTINATION"),
    
    CHANNEL_MANAGER("CHANNEL_MANAGER"),
    
    PROPERTY_MANAGEMENT_SYSTEM("PROPERTY_MANAGEMENT_SYSTEM"),
    
    CENTRAL_RESERVATION_SYSTEM("CENTRAL_RESERVATION_SYSTEM");

    private String value;

    SubTypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static SubTypeEnum fromValue(String value) {
      for (SubTypeEnum b : SubTypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_SUB_TYPE = "subType";
  private SubTypeEnum subType;

  public static final String JSON_PROPERTY_OWNER_IDENTIFIER = "ownerIdentifier";
  private UUID ownerIdentifier;

  public static final String JSON_PROPERTY_OWNER_NAME = "ownerName";
  private String ownerName;

  public static final String JSON_PROPERTY_INTRODUCTORY_MESSAGE = "introductoryMessage";
  private String introductoryMessage;

  public SalesChannelRelationshipRequest() {
  }

  public SalesChannelRelationshipRequest identifier(UUID identifier) {
    
    this.identifier = identifier;
    return this;
  }

   /**
   * Unique record identifier
   * @return identifier
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public UUID getIdentifier() {
    return identifier;
  }


  @JsonProperty(JSON_PROPERTY_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setIdentifier(UUID identifier) {
    this.identifier = identifier;
  }


  public SalesChannelRelationshipRequest status(StatusEnum status) {
    
    this.status = status;
    return this;
  }

   /**
   * status of relationship request
   * @return status
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_STATUS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public StatusEnum getStatus() {
    return status;
  }


  @JsonProperty(JSON_PROPERTY_STATUS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setStatus(StatusEnum status) {
    this.status = status;
  }


  public SalesChannelRelationshipRequest requestType(RequestTypeEnum requestType) {
    
    this.requestType = requestType;
    return this;
  }

   /**
   * type of relationship request
   * @return requestType
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_REQUEST_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public RequestTypeEnum getRequestType() {
    return requestType;
  }


  @JsonProperty(JSON_PROPERTY_REQUEST_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setRequestType(RequestTypeEnum requestType) {
    this.requestType = requestType;
  }


  public SalesChannelRelationshipRequest supplierIdentifier(UUID supplierIdentifier) {
    
    this.supplierIdentifier = supplierIdentifier;
    return this;
  }

   /**
   * Request goes to this supplier identifier.
   * @return supplierIdentifier
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_SUPPLIER_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public UUID getSupplierIdentifier() {
    return supplierIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_SUPPLIER_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setSupplierIdentifier(UUID supplierIdentifier) {
    this.supplierIdentifier = supplierIdentifier;
  }


  public SalesChannelRelationshipRequest supplierName(String supplierName) {
    
    this.supplierName = supplierName;
    return this;
  }

   /**
   * Request goes to this supplier name.
   * @return supplierName
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_SUPPLIER_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getSupplierName() {
    return supplierName;
  }


  @JsonProperty(JSON_PROPERTY_SUPPLIER_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setSupplierName(String supplierName) {
    this.supplierName = supplierName;
  }


  public SalesChannelRelationshipRequest subType(SubTypeEnum subType) {
    
    this.subType = subType;
    return this;
  }

   /**
   * What type of segment of channel is this.
   * @return subType
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_SUB_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public SubTypeEnum getSubType() {
    return subType;
  }


  @JsonProperty(JSON_PROPERTY_SUB_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setSubType(SubTypeEnum subType) {
    this.subType = subType;
  }


  public SalesChannelRelationshipRequest ownerIdentifier(UUID ownerIdentifier) {
    
    this.ownerIdentifier = ownerIdentifier;
    return this;
  }

   /**
   * Specific identifier for the company / corporation / travel agency that is retrieving the rates
   * @return ownerIdentifier
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_OWNER_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public UUID getOwnerIdentifier() {
    return ownerIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_OWNER_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setOwnerIdentifier(UUID ownerIdentifier) {
    this.ownerIdentifier = ownerIdentifier;
  }


  public SalesChannelRelationshipRequest ownerName(String ownerName) {
    
    this.ownerName = ownerName;
    return this;
  }

   /**
   * Name of the owner / affiliate.
   * @return ownerName
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_OWNER_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getOwnerName() {
    return ownerName;
  }


  @JsonProperty(JSON_PROPERTY_OWNER_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setOwnerName(String ownerName) {
    this.ownerName = ownerName;
  }


  public SalesChannelRelationshipRequest introductoryMessage(String introductoryMessage) {
    
    this.introductoryMessage = introductoryMessage;
    return this;
  }

   /**
   * Owner / affiliate writes an intro to request a connection.
   * @return introductoryMessage
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_INTRODUCTORY_MESSAGE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getIntroductoryMessage() {
    return introductoryMessage;
  }


  @JsonProperty(JSON_PROPERTY_INTRODUCTORY_MESSAGE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setIntroductoryMessage(String introductoryMessage) {
    this.introductoryMessage = introductoryMessage;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    SalesChannelRelationshipRequest salesChannelRelationshipRequest = (SalesChannelRelationshipRequest) o;
    return Objects.equals(this.identifier, salesChannelRelationshipRequest.identifier) &&
        Objects.equals(this.status, salesChannelRelationshipRequest.status) &&
        Objects.equals(this.requestType, salesChannelRelationshipRequest.requestType) &&
        Objects.equals(this.supplierIdentifier, salesChannelRelationshipRequest.supplierIdentifier) &&
        Objects.equals(this.supplierName, salesChannelRelationshipRequest.supplierName) &&
        Objects.equals(this.subType, salesChannelRelationshipRequest.subType) &&
        Objects.equals(this.ownerIdentifier, salesChannelRelationshipRequest.ownerIdentifier) &&
        Objects.equals(this.ownerName, salesChannelRelationshipRequest.ownerName) &&
        Objects.equals(this.introductoryMessage, salesChannelRelationshipRequest.introductoryMessage);
  }

  @Override
  public int hashCode() {
    return Objects.hash(identifier, status, requestType, supplierIdentifier, supplierName, subType, ownerIdentifier, ownerName, introductoryMessage);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class SalesChannelRelationshipRequest {\n");
    sb.append("    identifier: ").append(toIndentedString(identifier)).append("\n");
    sb.append("    status: ").append(toIndentedString(status)).append("\n");
    sb.append("    requestType: ").append(toIndentedString(requestType)).append("\n");
    sb.append("    supplierIdentifier: ").append(toIndentedString(supplierIdentifier)).append("\n");
    sb.append("    supplierName: ").append(toIndentedString(supplierName)).append("\n");
    sb.append("    subType: ").append(toIndentedString(subType)).append("\n");
    sb.append("    ownerIdentifier: ").append(toIndentedString(ownerIdentifier)).append("\n");
    sb.append("    ownerName: ").append(toIndentedString(ownerName)).append("\n");
    sb.append("    introductoryMessage: ").append(toIndentedString(introductoryMessage)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

