package travel.wink.sdk.affiliate.api;

import travel.wink.sdk.affiliate.invoker.ApiClient;

import travel.wink.sdk.affiliate.model.GenericErrorMessage;
import travel.wink.sdk.affiliate.model.RemoveEntryResponseAffiliate;
import travel.wink.sdk.affiliate.model.ShowSupplierUrl400Response;
import travel.wink.sdk.affiliate.model.SupplierUrlViewAffiliate;
import travel.wink.sdk.affiliate.model.UpsertSupplierUrlRequestAffiliate;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.web.reactive.function.client.WebClient.ResponseSpec;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Flux;

@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-10-30T09:49:19.643676512+07:00[Asia/Bangkok]")
public class SupplierLinksApi {
    private ApiClient apiClient;

    public SupplierLinksApi() {
        this(new ApiClient());
    }

    @Autowired
    public SupplierLinksApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Create Link
     * Create a new shareable link
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>201</b> - Created
     * @param companyIdentifier Create link owned by this owner identifier.
     * @param upsertSupplierUrlRequestAffiliate The upsertSupplierUrlRequestAffiliate parameter
     * @param winkVersion The winkVersion parameter
     * @return SupplierUrlViewAffiliate
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec createSupplierUrlRequestCreation(String companyIdentifier, UpsertSupplierUrlRequestAffiliate upsertSupplierUrlRequestAffiliate, String winkVersion) throws WebClientResponseException {
        Object postBody = upsertSupplierUrlRequestAffiliate;
        // verify the required parameter 'companyIdentifier' is set
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling createSupplierUrl", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'upsertSupplierUrlRequestAffiliate' is set
        if (upsertSupplierUrlRequestAffiliate == null) {
            throw new WebClientResponseException("Missing the required parameter 'upsertSupplierUrlRequestAffiliate' when calling createSupplierUrl", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("companyIdentifier", companyIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<SupplierUrlViewAffiliate> localVarReturnType = new ParameterizedTypeReference<SupplierUrlViewAffiliate>() {};
        return apiClient.invokeAPI("/api/company/{companyIdentifier}/supplier-url", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Create Link
     * Create a new shareable link
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>201</b> - Created
     * @param companyIdentifier Create link owned by this owner identifier.
     * @param upsertSupplierUrlRequestAffiliate The upsertSupplierUrlRequestAffiliate parameter
     * @param winkVersion The winkVersion parameter
     * @return SupplierUrlViewAffiliate
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<SupplierUrlViewAffiliate> createSupplierUrl(String companyIdentifier, UpsertSupplierUrlRequestAffiliate upsertSupplierUrlRequestAffiliate, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<SupplierUrlViewAffiliate> localVarReturnType = new ParameterizedTypeReference<SupplierUrlViewAffiliate>() {};
        return createSupplierUrlRequestCreation(companyIdentifier, upsertSupplierUrlRequestAffiliate, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Create Link
     * Create a new shareable link
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>201</b> - Created
     * @param companyIdentifier Create link owned by this owner identifier.
     * @param upsertSupplierUrlRequestAffiliate The upsertSupplierUrlRequestAffiliate parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;SupplierUrlViewAffiliate&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<SupplierUrlViewAffiliate>> createSupplierUrlWithHttpInfo(String companyIdentifier, UpsertSupplierUrlRequestAffiliate upsertSupplierUrlRequestAffiliate, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<SupplierUrlViewAffiliate> localVarReturnType = new ParameterizedTypeReference<SupplierUrlViewAffiliate>() {};
        return createSupplierUrlRequestCreation(companyIdentifier, upsertSupplierUrlRequestAffiliate, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Create Link
     * Create a new shareable link
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>201</b> - Created
     * @param companyIdentifier Create link owned by this owner identifier.
     * @param upsertSupplierUrlRequestAffiliate The upsertSupplierUrlRequestAffiliate parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec createSupplierUrlWithResponseSpec(String companyIdentifier, UpsertSupplierUrlRequestAffiliate upsertSupplierUrlRequestAffiliate, String winkVersion) throws WebClientResponseException {
        return createSupplierUrlRequestCreation(companyIdentifier, upsertSupplierUrlRequestAffiliate, winkVersion);
    }
    /**
     * Delete Link
     * Delete a shareable link
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>202</b> - Accepted
     * @param companyIdentifier Remove link owned by this owner identifier.
     * @param supplierUrlIdentifier Remove url with this identifier.
     * @param winkVersion The winkVersion parameter
     * @return RemoveEntryResponseAffiliate
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec removeSupplierUrlRequestCreation(String companyIdentifier, String supplierUrlIdentifier, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'companyIdentifier' is set
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling removeSupplierUrl", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'supplierUrlIdentifier' is set
        if (supplierUrlIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'supplierUrlIdentifier' when calling removeSupplierUrl", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("companyIdentifier", companyIdentifier);
        pathParams.put("supplierUrlIdentifier", supplierUrlIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<RemoveEntryResponseAffiliate> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponseAffiliate>() {};
        return apiClient.invokeAPI("/api/company/{companyIdentifier}/supplier-url/{supplierUrlIdentifier}", HttpMethod.DELETE, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Delete Link
     * Delete a shareable link
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>202</b> - Accepted
     * @param companyIdentifier Remove link owned by this owner identifier.
     * @param supplierUrlIdentifier Remove url with this identifier.
     * @param winkVersion The winkVersion parameter
     * @return RemoveEntryResponseAffiliate
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<RemoveEntryResponseAffiliate> removeSupplierUrl(String companyIdentifier, String supplierUrlIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<RemoveEntryResponseAffiliate> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponseAffiliate>() {};
        return removeSupplierUrlRequestCreation(companyIdentifier, supplierUrlIdentifier, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Delete Link
     * Delete a shareable link
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>202</b> - Accepted
     * @param companyIdentifier Remove link owned by this owner identifier.
     * @param supplierUrlIdentifier Remove url with this identifier.
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;RemoveEntryResponseAffiliate&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<RemoveEntryResponseAffiliate>> removeSupplierUrlWithHttpInfo(String companyIdentifier, String supplierUrlIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<RemoveEntryResponseAffiliate> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponseAffiliate>() {};
        return removeSupplierUrlRequestCreation(companyIdentifier, supplierUrlIdentifier, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Delete Link
     * Delete a shareable link
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>202</b> - Accepted
     * @param companyIdentifier Remove link owned by this owner identifier.
     * @param supplierUrlIdentifier Remove url with this identifier.
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec removeSupplierUrlWithResponseSpec(String companyIdentifier, String supplierUrlIdentifier, String winkVersion) throws WebClientResponseException {
        return removeSupplierUrlRequestCreation(companyIdentifier, supplierUrlIdentifier, winkVersion);
    }
    /**
     * Show Link
     * Retrieve a specific shareable url for this seller
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier Show link owned by this owner identifier.
     * @param supplierUrlIdentifier Show link with this identifier.
     * @param winkVersion The winkVersion parameter
     * @return SupplierUrlViewAffiliate
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showSupplierUrlRequestCreation(String companyIdentifier, String supplierUrlIdentifier, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'companyIdentifier' is set
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling showSupplierUrl", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'supplierUrlIdentifier' is set
        if (supplierUrlIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'supplierUrlIdentifier' when calling showSupplierUrl", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("companyIdentifier", companyIdentifier);
        pathParams.put("supplierUrlIdentifier", supplierUrlIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<SupplierUrlViewAffiliate> localVarReturnType = new ParameterizedTypeReference<SupplierUrlViewAffiliate>() {};
        return apiClient.invokeAPI("/api/company/{companyIdentifier}/supplier-url/{supplierUrlIdentifier}", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Link
     * Retrieve a specific shareable url for this seller
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier Show link owned by this owner identifier.
     * @param supplierUrlIdentifier Show link with this identifier.
     * @param winkVersion The winkVersion parameter
     * @return SupplierUrlViewAffiliate
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<SupplierUrlViewAffiliate> showSupplierUrl(String companyIdentifier, String supplierUrlIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<SupplierUrlViewAffiliate> localVarReturnType = new ParameterizedTypeReference<SupplierUrlViewAffiliate>() {};
        return showSupplierUrlRequestCreation(companyIdentifier, supplierUrlIdentifier, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Show Link
     * Retrieve a specific shareable url for this seller
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier Show link owned by this owner identifier.
     * @param supplierUrlIdentifier Show link with this identifier.
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;SupplierUrlViewAffiliate&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<SupplierUrlViewAffiliate>> showSupplierUrlWithHttpInfo(String companyIdentifier, String supplierUrlIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<SupplierUrlViewAffiliate> localVarReturnType = new ParameterizedTypeReference<SupplierUrlViewAffiliate>() {};
        return showSupplierUrlRequestCreation(companyIdentifier, supplierUrlIdentifier, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Show Link
     * Retrieve a specific shareable url for this seller
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier Show link owned by this owner identifier.
     * @param supplierUrlIdentifier Show link with this identifier.
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec showSupplierUrlWithResponseSpec(String companyIdentifier, String supplierUrlIdentifier, String winkVersion) throws WebClientResponseException {
        return showSupplierUrlRequestCreation(companyIdentifier, supplierUrlIdentifier, winkVersion);
    }
    /**
     * Show Links
     * Retrieve list of shareable urls for this seller
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier Show links list owned by this owner identifier.
     * @param winkVersion The winkVersion parameter
     * @return List&lt;SupplierUrlViewAffiliate&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showSupplierUrlsRequestCreation(String companyIdentifier, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'companyIdentifier' is set
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling showSupplierUrls", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("companyIdentifier", companyIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<SupplierUrlViewAffiliate> localVarReturnType = new ParameterizedTypeReference<SupplierUrlViewAffiliate>() {};
        return apiClient.invokeAPI("/api/company/{companyIdentifier}/supplier-url/list", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Links
     * Retrieve list of shareable urls for this seller
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier Show links list owned by this owner identifier.
     * @param winkVersion The winkVersion parameter
     * @return List&lt;SupplierUrlViewAffiliate&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Flux<SupplierUrlViewAffiliate> showSupplierUrls(String companyIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<SupplierUrlViewAffiliate> localVarReturnType = new ParameterizedTypeReference<SupplierUrlViewAffiliate>() {};
        return showSupplierUrlsRequestCreation(companyIdentifier, winkVersion).bodyToFlux(localVarReturnType);
    }

    /**
     * Show Links
     * Retrieve list of shareable urls for this seller
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier Show links list owned by this owner identifier.
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;List&lt;SupplierUrlViewAffiliate&gt;&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<List<SupplierUrlViewAffiliate>>> showSupplierUrlsWithHttpInfo(String companyIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<SupplierUrlViewAffiliate> localVarReturnType = new ParameterizedTypeReference<SupplierUrlViewAffiliate>() {};
        return showSupplierUrlsRequestCreation(companyIdentifier, winkVersion).toEntityList(localVarReturnType);
    }

    /**
     * Show Links
     * Retrieve list of shareable urls for this seller
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier Show links list owned by this owner identifier.
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec showSupplierUrlsWithResponseSpec(String companyIdentifier, String winkVersion) throws WebClientResponseException {
        return showSupplierUrlsRequestCreation(companyIdentifier, winkVersion);
    }
    /**
     * Update link
     * Modify a shareable link
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier Update link owned by this owner identifier.
     * @param supplierUrlIdentifier Update url with this identifier.
     * @param upsertSupplierUrlRequestAffiliate The upsertSupplierUrlRequestAffiliate parameter
     * @param winkVersion The winkVersion parameter
     * @return SupplierUrlViewAffiliate
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec updateSupplierUrlRequestCreation(String companyIdentifier, String supplierUrlIdentifier, UpsertSupplierUrlRequestAffiliate upsertSupplierUrlRequestAffiliate, String winkVersion) throws WebClientResponseException {
        Object postBody = upsertSupplierUrlRequestAffiliate;
        // verify the required parameter 'companyIdentifier' is set
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling updateSupplierUrl", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'supplierUrlIdentifier' is set
        if (supplierUrlIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'supplierUrlIdentifier' when calling updateSupplierUrl", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'upsertSupplierUrlRequestAffiliate' is set
        if (upsertSupplierUrlRequestAffiliate == null) {
            throw new WebClientResponseException("Missing the required parameter 'upsertSupplierUrlRequestAffiliate' when calling updateSupplierUrl", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("companyIdentifier", companyIdentifier);
        pathParams.put("supplierUrlIdentifier", supplierUrlIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<SupplierUrlViewAffiliate> localVarReturnType = new ParameterizedTypeReference<SupplierUrlViewAffiliate>() {};
        return apiClient.invokeAPI("/api/company/{companyIdentifier}/supplier-url/{supplierUrlIdentifier}", HttpMethod.PUT, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Update link
     * Modify a shareable link
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier Update link owned by this owner identifier.
     * @param supplierUrlIdentifier Update url with this identifier.
     * @param upsertSupplierUrlRequestAffiliate The upsertSupplierUrlRequestAffiliate parameter
     * @param winkVersion The winkVersion parameter
     * @return SupplierUrlViewAffiliate
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<SupplierUrlViewAffiliate> updateSupplierUrl(String companyIdentifier, String supplierUrlIdentifier, UpsertSupplierUrlRequestAffiliate upsertSupplierUrlRequestAffiliate, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<SupplierUrlViewAffiliate> localVarReturnType = new ParameterizedTypeReference<SupplierUrlViewAffiliate>() {};
        return updateSupplierUrlRequestCreation(companyIdentifier, supplierUrlIdentifier, upsertSupplierUrlRequestAffiliate, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Update link
     * Modify a shareable link
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier Update link owned by this owner identifier.
     * @param supplierUrlIdentifier Update url with this identifier.
     * @param upsertSupplierUrlRequestAffiliate The upsertSupplierUrlRequestAffiliate parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;SupplierUrlViewAffiliate&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<SupplierUrlViewAffiliate>> updateSupplierUrlWithHttpInfo(String companyIdentifier, String supplierUrlIdentifier, UpsertSupplierUrlRequestAffiliate upsertSupplierUrlRequestAffiliate, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<SupplierUrlViewAffiliate> localVarReturnType = new ParameterizedTypeReference<SupplierUrlViewAffiliate>() {};
        return updateSupplierUrlRequestCreation(companyIdentifier, supplierUrlIdentifier, upsertSupplierUrlRequestAffiliate, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Update link
     * Modify a shareable link
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier Update link owned by this owner identifier.
     * @param supplierUrlIdentifier Update url with this identifier.
     * @param upsertSupplierUrlRequestAffiliate The upsertSupplierUrlRequestAffiliate parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec updateSupplierUrlWithResponseSpec(String companyIdentifier, String supplierUrlIdentifier, UpsertSupplierUrlRequestAffiliate upsertSupplierUrlRequestAffiliate, String winkVersion) throws WebClientResponseException {
        return updateSupplierUrlRequestCreation(companyIdentifier, supplierUrlIdentifier, upsertSupplierUrlRequestAffiliate, winkVersion);
    }
}
