/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.affiliate.api;

import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import travel.wink.sdk.affiliate.invoker.ApiClient;
import travel.wink.sdk.affiliate.model.RemoveEntryResponseAffiliate;
import travel.wink.sdk.affiliate.model.SellerInventoryItemViewAffiliate;
import travel.wink.sdk.affiliate.model.SimpleMultimediaAffiliate;
import travel.wink.sdk.affiliate.model.UpsertSellerInventoryItemRequestAffiliate;
import travel.wink.sdk.affiliate.model.UpsertSupplierSellerInventoryItemRequestAffiliate;

public class InventoryCardsApi {
    private ApiClient apiClient;

    public InventoryCardsApi() {
        this(new ApiClient());
    }

    @Autowired
    public InventoryCardsApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    private WebClient.ResponseSpec createSellerInventoryItemRequestCreation(String companyIdentifier, UpsertSellerInventoryItemRequestAffiliate upsertSellerInventoryItemRequestAffiliate, String winkVersion) throws WebClientResponseException {
        UpsertSellerInventoryItemRequestAffiliate postBody = upsertSellerInventoryItemRequestAffiliate;
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling createSellerInventoryItem", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (upsertSellerInventoryItemRequestAffiliate == null) {
            throw new WebClientResponseException("Missing the required parameter 'upsertSellerInventoryItemRequestAffiliate' when calling createSellerInventoryItem", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("companyIdentifier", companyIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<SellerInventoryItemViewAffiliate> localVarReturnType = new ParameterizedTypeReference<SellerInventoryItemViewAffiliate>(this){};
        return this.apiClient.invokeAPI("/api/company/{companyIdentifier}/inventory/item", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<SellerInventoryItemViewAffiliate> createSellerInventoryItem(String companyIdentifier, UpsertSellerInventoryItemRequestAffiliate upsertSellerInventoryItemRequestAffiliate, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<SellerInventoryItemViewAffiliate> localVarReturnType = new ParameterizedTypeReference<SellerInventoryItemViewAffiliate>(this){};
        return this.createSellerInventoryItemRequestCreation(companyIdentifier, upsertSellerInventoryItemRequestAffiliate, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<SellerInventoryItemViewAffiliate>> createSellerInventoryItemWithHttpInfo(String companyIdentifier, UpsertSellerInventoryItemRequestAffiliate upsertSellerInventoryItemRequestAffiliate, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<SellerInventoryItemViewAffiliate> localVarReturnType = new ParameterizedTypeReference<SellerInventoryItemViewAffiliate>(this){};
        return this.createSellerInventoryItemRequestCreation(companyIdentifier, upsertSellerInventoryItemRequestAffiliate, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec createSellerInventoryItemWithResponseSpec(String companyIdentifier, UpsertSellerInventoryItemRequestAffiliate upsertSellerInventoryItemRequestAffiliate, String winkVersion) throws WebClientResponseException {
        return this.createSellerInventoryItemRequestCreation(companyIdentifier, upsertSellerInventoryItemRequestAffiliate, winkVersion);
    }

    private WebClient.ResponseSpec createSupplierSellerInventoryItemRequestCreation(String companyIdentifier, UpsertSupplierSellerInventoryItemRequestAffiliate upsertSupplierSellerInventoryItemRequestAffiliate, String winkVersion) throws WebClientResponseException {
        UpsertSupplierSellerInventoryItemRequestAffiliate postBody = upsertSupplierSellerInventoryItemRequestAffiliate;
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling createSupplierSellerInventoryItem", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (upsertSupplierSellerInventoryItemRequestAffiliate == null) {
            throw new WebClientResponseException("Missing the required parameter 'upsertSupplierSellerInventoryItemRequestAffiliate' when calling createSupplierSellerInventoryItem", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("companyIdentifier", companyIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<SellerInventoryItemViewAffiliate> localVarReturnType = new ParameterizedTypeReference<SellerInventoryItemViewAffiliate>(this){};
        return this.apiClient.invokeAPI("/api/company/{companyIdentifier}/inventory/item/supplier", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<SellerInventoryItemViewAffiliate> createSupplierSellerInventoryItem(String companyIdentifier, UpsertSupplierSellerInventoryItemRequestAffiliate upsertSupplierSellerInventoryItemRequestAffiliate, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<SellerInventoryItemViewAffiliate> localVarReturnType = new ParameterizedTypeReference<SellerInventoryItemViewAffiliate>(this){};
        return this.createSupplierSellerInventoryItemRequestCreation(companyIdentifier, upsertSupplierSellerInventoryItemRequestAffiliate, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<SellerInventoryItemViewAffiliate>> createSupplierSellerInventoryItemWithHttpInfo(String companyIdentifier, UpsertSupplierSellerInventoryItemRequestAffiliate upsertSupplierSellerInventoryItemRequestAffiliate, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<SellerInventoryItemViewAffiliate> localVarReturnType = new ParameterizedTypeReference<SellerInventoryItemViewAffiliate>(this){};
        return this.createSupplierSellerInventoryItemRequestCreation(companyIdentifier, upsertSupplierSellerInventoryItemRequestAffiliate, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec createSupplierSellerInventoryItemWithResponseSpec(String companyIdentifier, UpsertSupplierSellerInventoryItemRequestAffiliate upsertSupplierSellerInventoryItemRequestAffiliate, String winkVersion) throws WebClientResponseException {
        return this.createSupplierSellerInventoryItemRequestCreation(companyIdentifier, upsertSupplierSellerInventoryItemRequestAffiliate, winkVersion);
    }

    private WebClient.ResponseSpec removeSellerInventoryItemRequestCreation(String companyIdentifier, String inventoryIdentifier, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling removeSellerInventoryItem", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (inventoryIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'inventoryIdentifier' when calling removeSellerInventoryItem", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("companyIdentifier", companyIdentifier);
        pathParams.put("inventoryIdentifier", inventoryIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<RemoveEntryResponseAffiliate> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponseAffiliate>(this){};
        return this.apiClient.invokeAPI("/api/company/{companyIdentifier}/inventory/item/{inventoryIdentifier}", HttpMethod.DELETE, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<RemoveEntryResponseAffiliate> removeSellerInventoryItem(String companyIdentifier, String inventoryIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<RemoveEntryResponseAffiliate> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponseAffiliate>(this){};
        return this.removeSellerInventoryItemRequestCreation(companyIdentifier, inventoryIdentifier, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<RemoveEntryResponseAffiliate>> removeSellerInventoryItemWithHttpInfo(String companyIdentifier, String inventoryIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<RemoveEntryResponseAffiliate> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponseAffiliate>(this){};
        return this.removeSellerInventoryItemRequestCreation(companyIdentifier, inventoryIdentifier, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec removeSellerInventoryItemWithResponseSpec(String companyIdentifier, String inventoryIdentifier, String winkVersion) throws WebClientResponseException {
        return this.removeSellerInventoryItemRequestCreation(companyIdentifier, inventoryIdentifier, winkVersion);
    }

    private WebClient.ResponseSpec showInventoryMedia1RequestCreation(String companyIdentifier, String channelInventoryIdentifier, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling showInventoryMedia1", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (channelInventoryIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'channelInventoryIdentifier' when calling showInventoryMedia1", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("companyIdentifier", companyIdentifier);
        pathParams.put("channelInventoryIdentifier", channelInventoryIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<SimpleMultimediaAffiliate> localVarReturnType = new ParameterizedTypeReference<SimpleMultimediaAffiliate>(this){};
        return this.apiClient.invokeAPI("/api/company/{companyIdentifier}/inventory/item/inventory/{channelInventoryIdentifier}/media/list", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Flux<SimpleMultimediaAffiliate> showInventoryMedia1(String companyIdentifier, String channelInventoryIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<SimpleMultimediaAffiliate> localVarReturnType = new ParameterizedTypeReference<SimpleMultimediaAffiliate>(this){};
        return this.showInventoryMedia1RequestCreation(companyIdentifier, channelInventoryIdentifier, winkVersion).bodyToFlux((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<List<SimpleMultimediaAffiliate>>> showInventoryMedia1WithHttpInfo(String companyIdentifier, String channelInventoryIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<SimpleMultimediaAffiliate> localVarReturnType = new ParameterizedTypeReference<SimpleMultimediaAffiliate>(this){};
        return this.showInventoryMedia1RequestCreation(companyIdentifier, channelInventoryIdentifier, winkVersion).toEntityList((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showInventoryMedia1WithResponseSpec(String companyIdentifier, String channelInventoryIdentifier, String winkVersion) throws WebClientResponseException {
        return this.showInventoryMedia1RequestCreation(companyIdentifier, channelInventoryIdentifier, winkVersion);
    }

    private WebClient.ResponseSpec showSellerInventoryItemRequestCreation(String companyIdentifier, String inventoryIdentifier, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling showSellerInventoryItem", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (inventoryIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'inventoryIdentifier' when calling showSellerInventoryItem", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("companyIdentifier", companyIdentifier);
        pathParams.put("inventoryIdentifier", inventoryIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<SellerInventoryItemViewAffiliate> localVarReturnType = new ParameterizedTypeReference<SellerInventoryItemViewAffiliate>(this){};
        return this.apiClient.invokeAPI("/api/company/{companyIdentifier}/inventory/item/{inventoryIdentifier}", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<SellerInventoryItemViewAffiliate> showSellerInventoryItem(String companyIdentifier, String inventoryIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<SellerInventoryItemViewAffiliate> localVarReturnType = new ParameterizedTypeReference<SellerInventoryItemViewAffiliate>(this){};
        return this.showSellerInventoryItemRequestCreation(companyIdentifier, inventoryIdentifier, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<SellerInventoryItemViewAffiliate>> showSellerInventoryItemWithHttpInfo(String companyIdentifier, String inventoryIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<SellerInventoryItemViewAffiliate> localVarReturnType = new ParameterizedTypeReference<SellerInventoryItemViewAffiliate>(this){};
        return this.showSellerInventoryItemRequestCreation(companyIdentifier, inventoryIdentifier, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showSellerInventoryItemWithResponseSpec(String companyIdentifier, String inventoryIdentifier, String winkVersion) throws WebClientResponseException {
        return this.showSellerInventoryItemRequestCreation(companyIdentifier, inventoryIdentifier, winkVersion);
    }

    private WebClient.ResponseSpec showSellerInventoryItemsForCompanyRequestCreation(String companyIdentifier, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling showSellerInventoryItemsForCompany", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("companyIdentifier", companyIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<SellerInventoryItemViewAffiliate> localVarReturnType = new ParameterizedTypeReference<SellerInventoryItemViewAffiliate>(this){};
        return this.apiClient.invokeAPI("/api/company/{companyIdentifier}/inventory/item/list", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Flux<SellerInventoryItemViewAffiliate> showSellerInventoryItemsForCompany(String companyIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<SellerInventoryItemViewAffiliate> localVarReturnType = new ParameterizedTypeReference<SellerInventoryItemViewAffiliate>(this){};
        return this.showSellerInventoryItemsForCompanyRequestCreation(companyIdentifier, winkVersion).bodyToFlux((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<List<SellerInventoryItemViewAffiliate>>> showSellerInventoryItemsForCompanyWithHttpInfo(String companyIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<SellerInventoryItemViewAffiliate> localVarReturnType = new ParameterizedTypeReference<SellerInventoryItemViewAffiliate>(this){};
        return this.showSellerInventoryItemsForCompanyRequestCreation(companyIdentifier, winkVersion).toEntityList((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showSellerInventoryItemsForCompanyWithResponseSpec(String companyIdentifier, String winkVersion) throws WebClientResponseException {
        return this.showSellerInventoryItemsForCompanyRequestCreation(companyIdentifier, winkVersion);
    }

    private WebClient.ResponseSpec updateSellerInventoryItemRequestCreation(String companyIdentifier, String inventoryIdentifier, UpsertSellerInventoryItemRequestAffiliate upsertSellerInventoryItemRequestAffiliate, String winkVersion) throws WebClientResponseException {
        UpsertSellerInventoryItemRequestAffiliate postBody = upsertSellerInventoryItemRequestAffiliate;
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling updateSellerInventoryItem", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (inventoryIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'inventoryIdentifier' when calling updateSellerInventoryItem", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (upsertSellerInventoryItemRequestAffiliate == null) {
            throw new WebClientResponseException("Missing the required parameter 'upsertSellerInventoryItemRequestAffiliate' when calling updateSellerInventoryItem", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("companyIdentifier", companyIdentifier);
        pathParams.put("inventoryIdentifier", inventoryIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<SellerInventoryItemViewAffiliate> localVarReturnType = new ParameterizedTypeReference<SellerInventoryItemViewAffiliate>(this){};
        return this.apiClient.invokeAPI("/api/company/{companyIdentifier}/inventory/item/{inventoryIdentifier}", HttpMethod.PUT, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<SellerInventoryItemViewAffiliate> updateSellerInventoryItem(String companyIdentifier, String inventoryIdentifier, UpsertSellerInventoryItemRequestAffiliate upsertSellerInventoryItemRequestAffiliate, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<SellerInventoryItemViewAffiliate> localVarReturnType = new ParameterizedTypeReference<SellerInventoryItemViewAffiliate>(this){};
        return this.updateSellerInventoryItemRequestCreation(companyIdentifier, inventoryIdentifier, upsertSellerInventoryItemRequestAffiliate, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<SellerInventoryItemViewAffiliate>> updateSellerInventoryItemWithHttpInfo(String companyIdentifier, String inventoryIdentifier, UpsertSellerInventoryItemRequestAffiliate upsertSellerInventoryItemRequestAffiliate, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<SellerInventoryItemViewAffiliate> localVarReturnType = new ParameterizedTypeReference<SellerInventoryItemViewAffiliate>(this){};
        return this.updateSellerInventoryItemRequestCreation(companyIdentifier, inventoryIdentifier, upsertSellerInventoryItemRequestAffiliate, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec updateSellerInventoryItemWithResponseSpec(String companyIdentifier, String inventoryIdentifier, UpsertSellerInventoryItemRequestAffiliate upsertSellerInventoryItemRequestAffiliate, String winkVersion) throws WebClientResponseException {
        return this.updateSellerInventoryItemRequestCreation(companyIdentifier, inventoryIdentifier, upsertSellerInventoryItemRequestAffiliate, winkVersion);
    }
}

