package travel.wink.sdk.affiliate.api;

import travel.wink.sdk.affiliate.invoker.ApiClient;

import travel.wink.sdk.affiliate.model.EngineConfigurationViewAffiliate;
import travel.wink.sdk.affiliate.model.GenericErrorMessage;
import travel.wink.sdk.affiliate.model.RemoveEntryResponseAffiliate;
import travel.wink.sdk.affiliate.model.ShowSupplierUrl400Response;
import travel.wink.sdk.affiliate.model.UpsertEngineConfigurationRequestAffiliate;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.web.reactive.function.client.WebClient.ResponseSpec;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Flux;

@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-11-28T12:48:10.520361873+07:00[Asia/Bangkok]")
public class CustomizationApi {
    private ApiClient apiClient;

    public CustomizationApi() {
        this(new ApiClient());
    }

    @Autowired
    public CustomizationApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Create Customization
     * Create a new customization and associate it with the specified application.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>201</b> - Created
     * @param companyIdentifier Create customization for this company
     * @param upsertEngineConfigurationRequestAffiliate The upsertEngineConfigurationRequestAffiliate parameter
     * @param winkVersion The winkVersion parameter
     * @return EngineConfigurationViewAffiliate
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec createCustomizationRequestCreation(String companyIdentifier, UpsertEngineConfigurationRequestAffiliate upsertEngineConfigurationRequestAffiliate, String winkVersion) throws WebClientResponseException {
        Object postBody = upsertEngineConfigurationRequestAffiliate;
        // verify the required parameter 'companyIdentifier' is set
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling createCustomization", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'upsertEngineConfigurationRequestAffiliate' is set
        if (upsertEngineConfigurationRequestAffiliate == null) {
            throw new WebClientResponseException("Missing the required parameter 'upsertEngineConfigurationRequestAffiliate' when calling createCustomization", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("companyIdentifier", companyIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<EngineConfigurationViewAffiliate> localVarReturnType = new ParameterizedTypeReference<EngineConfigurationViewAffiliate>() {};
        return apiClient.invokeAPI("/api/company/{companyIdentifier}/configuration", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Create Customization
     * Create a new customization and associate it with the specified application.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>201</b> - Created
     * @param companyIdentifier Create customization for this company
     * @param upsertEngineConfigurationRequestAffiliate The upsertEngineConfigurationRequestAffiliate parameter
     * @param winkVersion The winkVersion parameter
     * @return EngineConfigurationViewAffiliate
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<EngineConfigurationViewAffiliate> createCustomization(String companyIdentifier, UpsertEngineConfigurationRequestAffiliate upsertEngineConfigurationRequestAffiliate, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<EngineConfigurationViewAffiliate> localVarReturnType = new ParameterizedTypeReference<EngineConfigurationViewAffiliate>() {};
        return createCustomizationRequestCreation(companyIdentifier, upsertEngineConfigurationRequestAffiliate, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Create Customization
     * Create a new customization and associate it with the specified application.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>201</b> - Created
     * @param companyIdentifier Create customization for this company
     * @param upsertEngineConfigurationRequestAffiliate The upsertEngineConfigurationRequestAffiliate parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;EngineConfigurationViewAffiliate&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<EngineConfigurationViewAffiliate>> createCustomizationWithHttpInfo(String companyIdentifier, UpsertEngineConfigurationRequestAffiliate upsertEngineConfigurationRequestAffiliate, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<EngineConfigurationViewAffiliate> localVarReturnType = new ParameterizedTypeReference<EngineConfigurationViewAffiliate>() {};
        return createCustomizationRequestCreation(companyIdentifier, upsertEngineConfigurationRequestAffiliate, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Create Customization
     * Create a new customization and associate it with the specified application.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>201</b> - Created
     * @param companyIdentifier Create customization for this company
     * @param upsertEngineConfigurationRequestAffiliate The upsertEngineConfigurationRequestAffiliate parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec createCustomizationWithResponseSpec(String companyIdentifier, UpsertEngineConfigurationRequestAffiliate upsertEngineConfigurationRequestAffiliate, String winkVersion) throws WebClientResponseException {
        return createCustomizationRequestCreation(companyIdentifier, upsertEngineConfigurationRequestAffiliate, winkVersion);
    }
    /**
     * Remove Customization
     * Remove an existing customization.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>202</b> - Accepted
     * @param companyIdentifier Remove customization for this company
     * @param engineConfigurationIdentifier Remove customization with this identifier
     * @param winkVersion The winkVersion parameter
     * @return RemoveEntryResponseAffiliate
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec removeApplicationConfigurationRequestCreation(String companyIdentifier, String engineConfigurationIdentifier, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'companyIdentifier' is set
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling removeApplicationConfiguration", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'engineConfigurationIdentifier' is set
        if (engineConfigurationIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'engineConfigurationIdentifier' when calling removeApplicationConfiguration", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("companyIdentifier", companyIdentifier);
        pathParams.put("engineConfigurationIdentifier", engineConfigurationIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<RemoveEntryResponseAffiliate> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponseAffiliate>() {};
        return apiClient.invokeAPI("/api/company/{companyIdentifier}/configuration/{engineConfigurationIdentifier}", HttpMethod.DELETE, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Remove Customization
     * Remove an existing customization.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>202</b> - Accepted
     * @param companyIdentifier Remove customization for this company
     * @param engineConfigurationIdentifier Remove customization with this identifier
     * @param winkVersion The winkVersion parameter
     * @return RemoveEntryResponseAffiliate
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<RemoveEntryResponseAffiliate> removeApplicationConfiguration(String companyIdentifier, String engineConfigurationIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<RemoveEntryResponseAffiliate> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponseAffiliate>() {};
        return removeApplicationConfigurationRequestCreation(companyIdentifier, engineConfigurationIdentifier, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Remove Customization
     * Remove an existing customization.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>202</b> - Accepted
     * @param companyIdentifier Remove customization for this company
     * @param engineConfigurationIdentifier Remove customization with this identifier
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;RemoveEntryResponseAffiliate&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<RemoveEntryResponseAffiliate>> removeApplicationConfigurationWithHttpInfo(String companyIdentifier, String engineConfigurationIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<RemoveEntryResponseAffiliate> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponseAffiliate>() {};
        return removeApplicationConfigurationRequestCreation(companyIdentifier, engineConfigurationIdentifier, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Remove Customization
     * Remove an existing customization.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>202</b> - Accepted
     * @param companyIdentifier Remove customization for this company
     * @param engineConfigurationIdentifier Remove customization with this identifier
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec removeApplicationConfigurationWithResponseSpec(String companyIdentifier, String engineConfigurationIdentifier, String winkVersion) throws WebClientResponseException {
        return removeApplicationConfigurationRequestCreation(companyIdentifier, engineConfigurationIdentifier, winkVersion);
    }
    /**
     * Show Customization
     * Retrieve the primary customization for an application.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier Show customization for this company
     * @param engineConfigurationIdentifier Load customization with this identifier
     * @param winkVersion The winkVersion parameter
     * @return EngineConfigurationViewAffiliate
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showApplicationConfigurationRequestCreation(String companyIdentifier, String engineConfigurationIdentifier, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'companyIdentifier' is set
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling showApplicationConfiguration", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'engineConfigurationIdentifier' is set
        if (engineConfigurationIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'engineConfigurationIdentifier' when calling showApplicationConfiguration", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("companyIdentifier", companyIdentifier);
        pathParams.put("engineConfigurationIdentifier", engineConfigurationIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<EngineConfigurationViewAffiliate> localVarReturnType = new ParameterizedTypeReference<EngineConfigurationViewAffiliate>() {};
        return apiClient.invokeAPI("/api/company/{companyIdentifier}/configuration/{engineConfigurationIdentifier}", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Customization
     * Retrieve the primary customization for an application.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier Show customization for this company
     * @param engineConfigurationIdentifier Load customization with this identifier
     * @param winkVersion The winkVersion parameter
     * @return EngineConfigurationViewAffiliate
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<EngineConfigurationViewAffiliate> showApplicationConfiguration(String companyIdentifier, String engineConfigurationIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<EngineConfigurationViewAffiliate> localVarReturnType = new ParameterizedTypeReference<EngineConfigurationViewAffiliate>() {};
        return showApplicationConfigurationRequestCreation(companyIdentifier, engineConfigurationIdentifier, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Show Customization
     * Retrieve the primary customization for an application.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier Show customization for this company
     * @param engineConfigurationIdentifier Load customization with this identifier
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;EngineConfigurationViewAffiliate&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<EngineConfigurationViewAffiliate>> showApplicationConfigurationWithHttpInfo(String companyIdentifier, String engineConfigurationIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<EngineConfigurationViewAffiliate> localVarReturnType = new ParameterizedTypeReference<EngineConfigurationViewAffiliate>() {};
        return showApplicationConfigurationRequestCreation(companyIdentifier, engineConfigurationIdentifier, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Show Customization
     * Retrieve the primary customization for an application.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier Show customization for this company
     * @param engineConfigurationIdentifier Load customization with this identifier
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec showApplicationConfigurationWithResponseSpec(String companyIdentifier, String engineConfigurationIdentifier, String winkVersion) throws WebClientResponseException {
        return showApplicationConfigurationRequestCreation(companyIdentifier, engineConfigurationIdentifier, winkVersion);
    }
    /**
     * Show Customizations
     * Retrieve a list of customizations for specified company.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier Show customizations for this company
     * @param winkVersion The winkVersion parameter
     * @return List&lt;EngineConfigurationViewAffiliate&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showApplicationConfigurationsByOwnerRequestCreation(String companyIdentifier, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'companyIdentifier' is set
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling showApplicationConfigurationsByOwner", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("companyIdentifier", companyIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<EngineConfigurationViewAffiliate> localVarReturnType = new ParameterizedTypeReference<EngineConfigurationViewAffiliate>() {};
        return apiClient.invokeAPI("/api/company/{companyIdentifier}/configuration/list", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Customizations
     * Retrieve a list of customizations for specified company.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier Show customizations for this company
     * @param winkVersion The winkVersion parameter
     * @return List&lt;EngineConfigurationViewAffiliate&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Flux<EngineConfigurationViewAffiliate> showApplicationConfigurationsByOwner(String companyIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<EngineConfigurationViewAffiliate> localVarReturnType = new ParameterizedTypeReference<EngineConfigurationViewAffiliate>() {};
        return showApplicationConfigurationsByOwnerRequestCreation(companyIdentifier, winkVersion).bodyToFlux(localVarReturnType);
    }

    /**
     * Show Customizations
     * Retrieve a list of customizations for specified company.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier Show customizations for this company
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;List&lt;EngineConfigurationViewAffiliate&gt;&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<List<EngineConfigurationViewAffiliate>>> showApplicationConfigurationsByOwnerWithHttpInfo(String companyIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<EngineConfigurationViewAffiliate> localVarReturnType = new ParameterizedTypeReference<EngineConfigurationViewAffiliate>() {};
        return showApplicationConfigurationsByOwnerRequestCreation(companyIdentifier, winkVersion).toEntityList(localVarReturnType);
    }

    /**
     * Show Customizations
     * Retrieve a list of customizations for specified company.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier Show customizations for this company
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec showApplicationConfigurationsByOwnerWithResponseSpec(String companyIdentifier, String winkVersion) throws WebClientResponseException {
        return showApplicationConfigurationsByOwnerRequestCreation(companyIdentifier, winkVersion);
    }
    /**
     * Show Primary Customization
     * Retrieve the primary customization for an application.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier Show customization for this company
     * @param winkVersion The winkVersion parameter
     * @return EngineConfigurationViewAffiliate
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showPrimaryApplicationConfigurationRequestCreation(String companyIdentifier, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'companyIdentifier' is set
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling showPrimaryApplicationConfiguration", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("companyIdentifier", companyIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<EngineConfigurationViewAffiliate> localVarReturnType = new ParameterizedTypeReference<EngineConfigurationViewAffiliate>() {};
        return apiClient.invokeAPI("/api/company/{companyIdentifier}/configuration", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Primary Customization
     * Retrieve the primary customization for an application.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier Show customization for this company
     * @param winkVersion The winkVersion parameter
     * @return EngineConfigurationViewAffiliate
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<EngineConfigurationViewAffiliate> showPrimaryApplicationConfiguration(String companyIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<EngineConfigurationViewAffiliate> localVarReturnType = new ParameterizedTypeReference<EngineConfigurationViewAffiliate>() {};
        return showPrimaryApplicationConfigurationRequestCreation(companyIdentifier, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Show Primary Customization
     * Retrieve the primary customization for an application.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier Show customization for this company
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;EngineConfigurationViewAffiliate&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<EngineConfigurationViewAffiliate>> showPrimaryApplicationConfigurationWithHttpInfo(String companyIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<EngineConfigurationViewAffiliate> localVarReturnType = new ParameterizedTypeReference<EngineConfigurationViewAffiliate>() {};
        return showPrimaryApplicationConfigurationRequestCreation(companyIdentifier, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Show Primary Customization
     * Retrieve the primary customization for an application.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier Show customization for this company
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec showPrimaryApplicationConfigurationWithResponseSpec(String companyIdentifier, String winkVersion) throws WebClientResponseException {
        return showPrimaryApplicationConfigurationRequestCreation(companyIdentifier, winkVersion);
    }
    /**
     * Update Customization
     * Update an existing customization.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier Update customization for this company
     * @param engineConfigurationIdentifier Update customization with this application
     * @param upsertEngineConfigurationRequestAffiliate The upsertEngineConfigurationRequestAffiliate parameter
     * @param winkVersion The winkVersion parameter
     * @return EngineConfigurationViewAffiliate
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec updateCustomizationRequestCreation(String companyIdentifier, String engineConfigurationIdentifier, UpsertEngineConfigurationRequestAffiliate upsertEngineConfigurationRequestAffiliate, String winkVersion) throws WebClientResponseException {
        Object postBody = upsertEngineConfigurationRequestAffiliate;
        // verify the required parameter 'companyIdentifier' is set
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling updateCustomization", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'engineConfigurationIdentifier' is set
        if (engineConfigurationIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'engineConfigurationIdentifier' when calling updateCustomization", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'upsertEngineConfigurationRequestAffiliate' is set
        if (upsertEngineConfigurationRequestAffiliate == null) {
            throw new WebClientResponseException("Missing the required parameter 'upsertEngineConfigurationRequestAffiliate' when calling updateCustomization", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("companyIdentifier", companyIdentifier);
        pathParams.put("engineConfigurationIdentifier", engineConfigurationIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<EngineConfigurationViewAffiliate> localVarReturnType = new ParameterizedTypeReference<EngineConfigurationViewAffiliate>() {};
        return apiClient.invokeAPI("/api/company/{companyIdentifier}/configuration/{engineConfigurationIdentifier}", HttpMethod.PUT, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Update Customization
     * Update an existing customization.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier Update customization for this company
     * @param engineConfigurationIdentifier Update customization with this application
     * @param upsertEngineConfigurationRequestAffiliate The upsertEngineConfigurationRequestAffiliate parameter
     * @param winkVersion The winkVersion parameter
     * @return EngineConfigurationViewAffiliate
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<EngineConfigurationViewAffiliate> updateCustomization(String companyIdentifier, String engineConfigurationIdentifier, UpsertEngineConfigurationRequestAffiliate upsertEngineConfigurationRequestAffiliate, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<EngineConfigurationViewAffiliate> localVarReturnType = new ParameterizedTypeReference<EngineConfigurationViewAffiliate>() {};
        return updateCustomizationRequestCreation(companyIdentifier, engineConfigurationIdentifier, upsertEngineConfigurationRequestAffiliate, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Update Customization
     * Update an existing customization.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier Update customization for this company
     * @param engineConfigurationIdentifier Update customization with this application
     * @param upsertEngineConfigurationRequestAffiliate The upsertEngineConfigurationRequestAffiliate parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;EngineConfigurationViewAffiliate&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<EngineConfigurationViewAffiliate>> updateCustomizationWithHttpInfo(String companyIdentifier, String engineConfigurationIdentifier, UpsertEngineConfigurationRequestAffiliate upsertEngineConfigurationRequestAffiliate, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<EngineConfigurationViewAffiliate> localVarReturnType = new ParameterizedTypeReference<EngineConfigurationViewAffiliate>() {};
        return updateCustomizationRequestCreation(companyIdentifier, engineConfigurationIdentifier, upsertEngineConfigurationRequestAffiliate, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Update Customization
     * Update an existing customization.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier Update customization for this company
     * @param engineConfigurationIdentifier Update customization with this application
     * @param upsertEngineConfigurationRequestAffiliate The upsertEngineConfigurationRequestAffiliate parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec updateCustomizationWithResponseSpec(String companyIdentifier, String engineConfigurationIdentifier, UpsertEngineConfigurationRequestAffiliate upsertEngineConfigurationRequestAffiliate, String winkVersion) throws WebClientResponseException {
        return updateCustomizationRequestCreation(companyIdentifier, engineConfigurationIdentifier, upsertEngineConfigurationRequestAffiliate, winkVersion);
    }
}
