package travel.wink.sdk.affiliate.api;

import travel.wink.sdk.affiliate.invoker.ApiClient;

import travel.wink.sdk.affiliate.model.ConsumeExternalUrlRequestAffiliate;
import travel.wink.sdk.affiliate.model.GenericErrorMessage;
import travel.wink.sdk.affiliate.model.ShowSupplierUrl400Response;
import travel.wink.sdk.affiliate.model.UpsertSyndicationEntryAffiliate;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.web.reactive.function.client.WebClient.ResponseSpec;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Flux;

@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-11-28T12:48:10.520361873+07:00[Asia/Bangkok]")
public class SyndicationEntryPublisherApi {
    private ApiClient apiClient;

    public SyndicationEntryPublisherApi() {
        this(new ApiClient());
    }

    @Autowired
    public SyndicationEntryPublisherApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Show Syndication Entries
     * Retrieve list of syndication entries.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier List syndication entries owned by this owner identifier.
     * @param consumeExternalUrlRequestAffiliate Body payload filtering and sorting preferences
     * @param winkVersion The winkVersion parameter
     * @return UpsertSyndicationEntryAffiliate
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec consumeExternalUrlForSyndicationEntryRequestCreation(String companyIdentifier, ConsumeExternalUrlRequestAffiliate consumeExternalUrlRequestAffiliate, String winkVersion) throws WebClientResponseException {
        Object postBody = consumeExternalUrlRequestAffiliate;
        // verify the required parameter 'companyIdentifier' is set
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling consumeExternalUrlForSyndicationEntry", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'consumeExternalUrlRequestAffiliate' is set
        if (consumeExternalUrlRequestAffiliate == null) {
            throw new WebClientResponseException("Missing the required parameter 'consumeExternalUrlRequestAffiliate' when calling consumeExternalUrlForSyndicationEntry", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("companyIdentifier", companyIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<UpsertSyndicationEntryAffiliate> localVarReturnType = new ParameterizedTypeReference<UpsertSyndicationEntryAffiliate>() {};
        return apiClient.invokeAPI("/api/company/{companyIdentifier}/syndication-entry/consume-url", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Syndication Entries
     * Retrieve list of syndication entries.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier List syndication entries owned by this owner identifier.
     * @param consumeExternalUrlRequestAffiliate Body payload filtering and sorting preferences
     * @param winkVersion The winkVersion parameter
     * @return UpsertSyndicationEntryAffiliate
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<UpsertSyndicationEntryAffiliate> consumeExternalUrlForSyndicationEntry(String companyIdentifier, ConsumeExternalUrlRequestAffiliate consumeExternalUrlRequestAffiliate, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<UpsertSyndicationEntryAffiliate> localVarReturnType = new ParameterizedTypeReference<UpsertSyndicationEntryAffiliate>() {};
        return consumeExternalUrlForSyndicationEntryRequestCreation(companyIdentifier, consumeExternalUrlRequestAffiliate, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Show Syndication Entries
     * Retrieve list of syndication entries.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier List syndication entries owned by this owner identifier.
     * @param consumeExternalUrlRequestAffiliate Body payload filtering and sorting preferences
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;UpsertSyndicationEntryAffiliate&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<UpsertSyndicationEntryAffiliate>> consumeExternalUrlForSyndicationEntryWithHttpInfo(String companyIdentifier, ConsumeExternalUrlRequestAffiliate consumeExternalUrlRequestAffiliate, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<UpsertSyndicationEntryAffiliate> localVarReturnType = new ParameterizedTypeReference<UpsertSyndicationEntryAffiliate>() {};
        return consumeExternalUrlForSyndicationEntryRequestCreation(companyIdentifier, consumeExternalUrlRequestAffiliate, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Show Syndication Entries
     * Retrieve list of syndication entries.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier List syndication entries owned by this owner identifier.
     * @param consumeExternalUrlRequestAffiliate Body payload filtering and sorting preferences
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec consumeExternalUrlForSyndicationEntryWithResponseSpec(String companyIdentifier, ConsumeExternalUrlRequestAffiliate consumeExternalUrlRequestAffiliate, String winkVersion) throws WebClientResponseException {
        return consumeExternalUrlForSyndicationEntryRequestCreation(companyIdentifier, consumeExternalUrlRequestAffiliate, winkVersion);
    }
}
