/*
 * Wink API
 * ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Affiliate](/affiliate): All APIs related to selling travel inventory as an affiliate. - [Analytics](/analytics): All APIs related to tracking metrics across a wide variety of data source segments including, more entertaining, leaderboard metrics. - [Booking](/booking): All APIs related to creating platform bookings. - [Channel Manager](/channel-manager): All APIs related to channel managers who want to integrate with our platform. - [Extranet](/extranet): All APIs related to managing travel inventory and suppliers. - [Inventory](/inventory): All APIs related to retrieve known travel inventory as it was found using the Lookup API.. - [Lookup](/lookup): All APIs related to locating inventory by region, locale and property flags. - [Reference](/reference): All APIs related to retrieving platform-supported taxonomies. - [TripPay Acquiring](/payment-acquiring): All APIs related to capture payment details such as a Stripe payment intent. - [TripPay](/payment): All APIs related to TripPay account management, booking, mapping and integration features.  ## SDKs We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).  - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)  ## Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Wink-Version` header. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints.  ## Release history - 2022-10-15: v2.0 - Removed HATEOAS and added Wink-Version header - 2022-05-08: v1 - Exposed channel manager API - 2021-07-01: v1 - Initial release  # Affiliate API Welcome to the Affiliate API - A programmer-friendly way to search for and display bespoke travel inventory for your audience. Use this API to help you prepare travel inventory for sale.  # Intended Audience Programmers are a requirement to start integrating with wink. You will benefit from an API integration if you are new or existing travel related company that want easy access to great inventory.## Examples: - Hotel brands / chains that want to make their own booking engine - Travel tech companies that want to create the next hot mobile travel app - Destination sites that want to make their own booking engine - Bloggers and influencers who want to sell travel inventory to their audience - OTAs that want access direct relationships with suppliers and better quality hotel inventory
 *
 * The version of the OpenAPI document: 29.30.0
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.affiliate.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.math.BigDecimal;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * Displays ancillary accounting details
 */
@JsonPropertyOrder({
  ReportingAncillaryAffiliate.JSON_PROPERTY_NAME,
  ReportingAncillaryAffiliate.JSON_PROPERTY_TYPE,
  ReportingAncillaryAffiliate.JSON_PROPERTY_GROSS_AMOUNT,
  ReportingAncillaryAffiliate.JSON_PROPERTY_NET_AMOUNT,
  ReportingAncillaryAffiliate.JSON_PROPERTY_NET_AMOUNT_WITH_REFUND,
  ReportingAncillaryAffiliate.JSON_PROPERTY_CURRENCY
})
@JsonTypeName("ReportingAncillary_Affiliate")
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-12-27T18:00:24.319118463+07:00[Asia/Bangkok]")
public class ReportingAncillaryAffiliate {
  public static final String JSON_PROPERTY_NAME = "name";
  private String name;

  /**
   * The type
   */
  public enum TypeEnum {
    LODGING("LODGING"),
    
    RAIL("RAIL"),
    
    AIR("AIR"),
    
    CAR("CAR"),
    
    CRUISE("CRUISE"),
    
    PACKAGE("PACKAGE"),
    
    ADD_ON("ADD_ON"),
    
    RENTAL("RENTAL"),
    
    EXPERIENCE("EXPERIENCE"),
    
    ANCILLARY_BOOKING("ANCILLARY_BOOKING"),
    
    ANCILLARY_FEE("ANCILLARY_FEE");

    private String value;

    TypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static TypeEnum fromValue(String value) {
      for (TypeEnum b : TypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_TYPE = "type";
  private TypeEnum type;

  public static final String JSON_PROPERTY_GROSS_AMOUNT = "grossAmount";
  private BigDecimal grossAmount;

  public static final String JSON_PROPERTY_NET_AMOUNT = "netAmount";
  private BigDecimal netAmount;

  public static final String JSON_PROPERTY_NET_AMOUNT_WITH_REFUND = "netAmountWithRefund";
  private BigDecimal netAmountWithRefund;

  public static final String JSON_PROPERTY_CURRENCY = "currency";
  private String currency;

  public ReportingAncillaryAffiliate() {
  }

  public ReportingAncillaryAffiliate name(String name) {
    
    this.name = name;
    return this;
  }

   /**
   * Full name of ancillary in English.
   * @return name
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getName() {
    return name;
  }


  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setName(String name) {
    this.name = name;
  }


  public ReportingAncillaryAffiliate type(TypeEnum type) {
    
    this.type = type;
    return this;
  }

   /**
   * The type
   * @return type
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public TypeEnum getType() {
    return type;
  }


  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setType(TypeEnum type) {
    this.type = type;
  }


  public ReportingAncillaryAffiliate grossAmount(BigDecimal grossAmount) {
    
    this.grossAmount = grossAmount;
    return this;
  }

   /**
   * The gross amount.
   * @return grossAmount
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_GROSS_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public BigDecimal getGrossAmount() {
    return grossAmount;
  }


  @JsonProperty(JSON_PROPERTY_GROSS_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setGrossAmount(BigDecimal grossAmount) {
    this.grossAmount = grossAmount;
  }


  public ReportingAncillaryAffiliate netAmount(BigDecimal netAmount) {
    
    this.netAmount = netAmount;
    return this;
  }

   /**
   * The gross amount minus fees and commissions.
   * @return netAmount
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_NET_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public BigDecimal getNetAmount() {
    return netAmount;
  }


  @JsonProperty(JSON_PROPERTY_NET_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setNetAmount(BigDecimal netAmount) {
    this.netAmount = netAmount;
  }


  public ReportingAncillaryAffiliate netAmountWithRefund(BigDecimal netAmountWithRefund) {
    
    this.netAmountWithRefund = netAmountWithRefund;
    return this;
  }

   /**
   * The gross amount minus fees and commissions.
   * @return netAmountWithRefund
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_NET_AMOUNT_WITH_REFUND)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public BigDecimal getNetAmountWithRefund() {
    return netAmountWithRefund;
  }


  @JsonProperty(JSON_PROPERTY_NET_AMOUNT_WITH_REFUND)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setNetAmountWithRefund(BigDecimal netAmountWithRefund) {
    this.netAmountWithRefund = netAmountWithRefund;
  }


  public ReportingAncillaryAffiliate currency(String currency) {
    
    this.currency = currency;
    return this;
  }

   /**
   * The currency for these amounts.
   * @return currency
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getCurrency() {
    return currency;
  }


  @JsonProperty(JSON_PROPERTY_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCurrency(String currency) {
    this.currency = currency;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ReportingAncillaryAffiliate reportingAncillaryAffiliate = (ReportingAncillaryAffiliate) o;
    return Objects.equals(this.name, reportingAncillaryAffiliate.name) &&
        Objects.equals(this.type, reportingAncillaryAffiliate.type) &&
        Objects.equals(this.grossAmount, reportingAncillaryAffiliate.grossAmount) &&
        Objects.equals(this.netAmount, reportingAncillaryAffiliate.netAmount) &&
        Objects.equals(this.netAmountWithRefund, reportingAncillaryAffiliate.netAmountWithRefund) &&
        Objects.equals(this.currency, reportingAncillaryAffiliate.currency);
  }

  @Override
  public int hashCode() {
    return Objects.hash(name, type, grossAmount, netAmount, netAmountWithRefund, currency);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ReportingAncillaryAffiliate {\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    grossAmount: ").append(toIndentedString(grossAmount)).append("\n");
    sb.append("    netAmount: ").append(toIndentedString(netAmount)).append("\n");
    sb.append("    netAmountWithRefund: ").append(toIndentedString(netAmountWithRefund)).append("\n");
    sb.append("    currency: ").append(toIndentedString(currency)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

