package travel.wink.sdk.affiliate.api;

import travel.wink.sdk.affiliate.invoker.ApiClient;

import travel.wink.sdk.affiliate.model.CountResponseAffiliate;
import travel.wink.sdk.affiliate.model.GenericErrorMessage;
import travel.wink.sdk.affiliate.model.NotificationViewAffiliate;
import travel.wink.sdk.affiliate.model.RemoveEntryResponseAffiliate;
import travel.wink.sdk.affiliate.model.ShowSupplierUrl400Response;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.web.reactive.function.client.WebClient.ResponseSpec;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Flux;

@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-01-28T21:18:10.241822052+07:00[Asia/Bangkok]")
public class NotificationApi {
    private ApiClient apiClient;

    public NotificationApi() {
        this(new ApiClient());
    }

    @Autowired
    public NotificationApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Mark as read
     * Mark notification as read.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier The companyIdentifier parameter
     * @param identifier The identifier parameter
     * @param winkVersion The winkVersion parameter
     * @return NotificationViewAffiliate
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec markAsReadRequestCreation(String companyIdentifier, String identifier, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'companyIdentifier' is set
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling markAsRead", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'identifier' is set
        if (identifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'identifier' when calling markAsRead", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("companyIdentifier", companyIdentifier);
        pathParams.put("identifier", identifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<NotificationViewAffiliate> localVarReturnType = new ParameterizedTypeReference<NotificationViewAffiliate>() {};
        return apiClient.invokeAPI("/api/company/{companyIdentifier}/message/{identifier}", HttpMethod.PATCH, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Mark as read
     * Mark notification as read.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier The companyIdentifier parameter
     * @param identifier The identifier parameter
     * @param winkVersion The winkVersion parameter
     * @return NotificationViewAffiliate
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<NotificationViewAffiliate> markAsRead(String companyIdentifier, String identifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<NotificationViewAffiliate> localVarReturnType = new ParameterizedTypeReference<NotificationViewAffiliate>() {};
        return markAsReadRequestCreation(companyIdentifier, identifier, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Mark as read
     * Mark notification as read.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier The companyIdentifier parameter
     * @param identifier The identifier parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;NotificationViewAffiliate&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<NotificationViewAffiliate>> markAsReadWithHttpInfo(String companyIdentifier, String identifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<NotificationViewAffiliate> localVarReturnType = new ParameterizedTypeReference<NotificationViewAffiliate>() {};
        return markAsReadRequestCreation(companyIdentifier, identifier, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Mark as read
     * Mark notification as read.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier The companyIdentifier parameter
     * @param identifier The identifier parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec markAsReadWithResponseSpec(String companyIdentifier, String identifier, String winkVersion) throws WebClientResponseException {
        return markAsReadRequestCreation(companyIdentifier, identifier, winkVersion);
    }
    /**
     * Delete notification
     * Remove notification specified by its identifier.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>202</b> - Accepted
     * @param companyIdentifier The companyIdentifier parameter
     * @param identifier The identifier parameter
     * @param winkVersion The winkVersion parameter
     * @return RemoveEntryResponseAffiliate
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec removeNotificationRequestCreation(String companyIdentifier, String identifier, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'companyIdentifier' is set
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling removeNotification", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'identifier' is set
        if (identifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'identifier' when calling removeNotification", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("companyIdentifier", companyIdentifier);
        pathParams.put("identifier", identifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<RemoveEntryResponseAffiliate> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponseAffiliate>() {};
        return apiClient.invokeAPI("/api/company/{companyIdentifier}/message/{identifier}", HttpMethod.DELETE, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Delete notification
     * Remove notification specified by its identifier.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>202</b> - Accepted
     * @param companyIdentifier The companyIdentifier parameter
     * @param identifier The identifier parameter
     * @param winkVersion The winkVersion parameter
     * @return RemoveEntryResponseAffiliate
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<RemoveEntryResponseAffiliate> removeNotification(String companyIdentifier, String identifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<RemoveEntryResponseAffiliate> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponseAffiliate>() {};
        return removeNotificationRequestCreation(companyIdentifier, identifier, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Delete notification
     * Remove notification specified by its identifier.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>202</b> - Accepted
     * @param companyIdentifier The companyIdentifier parameter
     * @param identifier The identifier parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;RemoveEntryResponseAffiliate&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<RemoveEntryResponseAffiliate>> removeNotificationWithHttpInfo(String companyIdentifier, String identifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<RemoveEntryResponseAffiliate> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponseAffiliate>() {};
        return removeNotificationRequestCreation(companyIdentifier, identifier, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Delete notification
     * Remove notification specified by its identifier.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>202</b> - Accepted
     * @param companyIdentifier The companyIdentifier parameter
     * @param identifier The identifier parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec removeNotificationWithResponseSpec(String companyIdentifier, String identifier, String winkVersion) throws WebClientResponseException {
        return removeNotificationRequestCreation(companyIdentifier, identifier, winkVersion);
    }
    /**
     * Show notification
     * Retrieve messages for a specific company by id
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier The companyIdentifier parameter
     * @param identifier The identifier parameter
     * @param winkVersion The winkVersion parameter
     * @return NotificationViewAffiliate
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showNotificationsRequestCreation(String companyIdentifier, String identifier, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'companyIdentifier' is set
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling showNotifications", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'identifier' is set
        if (identifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'identifier' when calling showNotifications", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("companyIdentifier", companyIdentifier);
        pathParams.put("identifier", identifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<NotificationViewAffiliate> localVarReturnType = new ParameterizedTypeReference<NotificationViewAffiliate>() {};
        return apiClient.invokeAPI("/api/company/{companyIdentifier}/message/{identifier}", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show notification
     * Retrieve messages for a specific company by id
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier The companyIdentifier parameter
     * @param identifier The identifier parameter
     * @param winkVersion The winkVersion parameter
     * @return NotificationViewAffiliate
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<NotificationViewAffiliate> showNotifications(String companyIdentifier, String identifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<NotificationViewAffiliate> localVarReturnType = new ParameterizedTypeReference<NotificationViewAffiliate>() {};
        return showNotificationsRequestCreation(companyIdentifier, identifier, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Show notification
     * Retrieve messages for a specific company by id
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier The companyIdentifier parameter
     * @param identifier The identifier parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;NotificationViewAffiliate&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<NotificationViewAffiliate>> showNotificationsWithHttpInfo(String companyIdentifier, String identifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<NotificationViewAffiliate> localVarReturnType = new ParameterizedTypeReference<NotificationViewAffiliate>() {};
        return showNotificationsRequestCreation(companyIdentifier, identifier, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Show notification
     * Retrieve messages for a specific company by id
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier The companyIdentifier parameter
     * @param identifier The identifier parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec showNotificationsWithResponseSpec(String companyIdentifier, String identifier, String winkVersion) throws WebClientResponseException {
        return showNotificationsRequestCreation(companyIdentifier, identifier, winkVersion);
    }
    /**
     * Show notifications
     * Retrieve all the messages for this company
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier The companyIdentifier parameter
     * @param winkVersion The winkVersion parameter
     * @return List&lt;NotificationViewAffiliate&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showNotifications1RequestCreation(String companyIdentifier, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'companyIdentifier' is set
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling showNotifications1", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("companyIdentifier", companyIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<NotificationViewAffiliate> localVarReturnType = new ParameterizedTypeReference<NotificationViewAffiliate>() {};
        return apiClient.invokeAPI("/api/company/{companyIdentifier}/message/list", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show notifications
     * Retrieve all the messages for this company
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier The companyIdentifier parameter
     * @param winkVersion The winkVersion parameter
     * @return List&lt;NotificationViewAffiliate&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Flux<NotificationViewAffiliate> showNotifications1(String companyIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<NotificationViewAffiliate> localVarReturnType = new ParameterizedTypeReference<NotificationViewAffiliate>() {};
        return showNotifications1RequestCreation(companyIdentifier, winkVersion).bodyToFlux(localVarReturnType);
    }

    /**
     * Show notifications
     * Retrieve all the messages for this company
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier The companyIdentifier parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;List&lt;NotificationViewAffiliate&gt;&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<List<NotificationViewAffiliate>>> showNotifications1WithHttpInfo(String companyIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<NotificationViewAffiliate> localVarReturnType = new ParameterizedTypeReference<NotificationViewAffiliate>() {};
        return showNotifications1RequestCreation(companyIdentifier, winkVersion).toEntityList(localVarReturnType);
    }

    /**
     * Show notifications
     * Retrieve all the messages for this company
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier The companyIdentifier parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec showNotifications1WithResponseSpec(String companyIdentifier, String winkVersion) throws WebClientResponseException {
        return showNotifications1RequestCreation(companyIdentifier, winkVersion);
    }
    /**
     * Show unread message count
     * Retrieve count of unread messages
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier The companyIdentifier parameter
     * @param winkVersion The winkVersion parameter
     * @return CountResponseAffiliate
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showUnreadMessageCountRequestCreation(String companyIdentifier, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'companyIdentifier' is set
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling showUnreadMessageCount", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("companyIdentifier", companyIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<CountResponseAffiliate> localVarReturnType = new ParameterizedTypeReference<CountResponseAffiliate>() {};
        return apiClient.invokeAPI("/api/company/{companyIdentifier}/message/count", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show unread message count
     * Retrieve count of unread messages
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier The companyIdentifier parameter
     * @param winkVersion The winkVersion parameter
     * @return CountResponseAffiliate
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<CountResponseAffiliate> showUnreadMessageCount(String companyIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<CountResponseAffiliate> localVarReturnType = new ParameterizedTypeReference<CountResponseAffiliate>() {};
        return showUnreadMessageCountRequestCreation(companyIdentifier, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Show unread message count
     * Retrieve count of unread messages
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier The companyIdentifier parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;CountResponseAffiliate&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<CountResponseAffiliate>> showUnreadMessageCountWithHttpInfo(String companyIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<CountResponseAffiliate> localVarReturnType = new ParameterizedTypeReference<CountResponseAffiliate>() {};
        return showUnreadMessageCountRequestCreation(companyIdentifier, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Show unread message count
     * Retrieve count of unread messages
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier The companyIdentifier parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec showUnreadMessageCountWithResponseSpec(String companyIdentifier, String winkVersion) throws WebClientResponseException {
        return showUnreadMessageCountRequestCreation(companyIdentifier, winkVersion);
    }
}
