/*
 * Wink API
 * ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Affiliate](/affiliate): All APIs related to selling travel inventory as an affiliate. - [Analytics](/analytics): All APIs related to tracking metrics across a wide variety of data source segments including, more entertaining, leaderboard metrics. - [Booking](/booking): All APIs related to creating platform bookings. - [Channel Manager](/channel-manager): All APIs related to channel managers who want to integrate with our platform. - [Extranet](/extranet): All APIs related to managing travel inventory and suppliers. - [Inventory](/inventory): All APIs related to retrieve known travel inventory as it was found using the Lookup API.. - [Lookup](/lookup): All APIs related to locating inventory by region, locale and property flags. - [Reference](/reference): All APIs related to retrieving platform-supported taxonomies. - [TripPay Acquiring](/payment-acquiring): All APIs related to capture payment details such as a Stripe payment intent. - [TripPay](/payment): All APIs related to TripPay account management, booking, mapping and integration features.  ## SDKs We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).  - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)  ## Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Wink-Version` header. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints.  ## Release history - 2022-10-15: v2.0 - Removed HATEOAS and added Wink-Version header - 2022-05-08: v1 - Exposed channel manager API - 2021-07-01: v1 - Initial release  # Affiliate API Welcome to the Affiliate API - A programmer-friendly way to search for and display bespoke travel inventory for your audience. Use this API to help you prepare travel inventory for sale.  # Intended Audience Programmers are a requirement to start integrating with wink. You will benefit from an API integration if you are new or existing travel related company that want easy access to great inventory.## Examples: - Hotel brands / chains that want to make their own booking engine - Travel tech companies that want to create the next hot mobile travel app - Destination sites that want to make their own booking engine - Bloggers and influencers who want to sell travel inventory to their audience - OTAs that want access direct relationships with suppliers and better quality hotel inventory
 *
 * The version of the OpenAPI document: 29.36.0
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.affiliate.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import travel.wink.sdk.affiliate.model.EngineConfigurationThemeAffiliate;
import travel.wink.sdk.affiliate.model.GeoNameAffiliate;
import travel.wink.sdk.affiliate.model.RoomConfigurationAffiliate;
import travel.wink.sdk.affiliate.model.SimpleMultimediaAffiliate;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * Which engine configuration record did the entity application used to facilitate in making this booking happen.
 */
@JsonPropertyOrder({
  EngineConfigurationBookingReportAffiliate.JSON_PROPERTY_IDENTIFIER,
  EngineConfigurationBookingReportAffiliate.JSON_PROPERTY_NAME,
  EngineConfigurationBookingReportAffiliate.JSON_PROPERTY_USER_IDENTIFIER,
  EngineConfigurationBookingReportAffiliate.JSON_PROPERTY_OWNER_IDENTIFIER,
  EngineConfigurationBookingReportAffiliate.JSON_PROPERTY_OWNER_NAME,
  EngineConfigurationBookingReportAffiliate.JSON_PROPERTY_SUB_TYPE,
  EngineConfigurationBookingReportAffiliate.JSON_PROPERTY_DEFAULT_CURRENCY,
  EngineConfigurationBookingReportAffiliate.JSON_PROPERTY_DEFAULT_LANGUAGE,
  EngineConfigurationBookingReportAffiliate.JSON_PROPERTY_LOGOS,
  EngineConfigurationBookingReportAffiliate.JSON_PROPERTY_HOSTED_BOOKING_ENGINE_URL,
  EngineConfigurationBookingReportAffiliate.JSON_PROPERTY_SELF_HOSTED,
  EngineConfigurationBookingReportAffiliate.JSON_PROPERTY_THEME_COLORS,
  EngineConfigurationBookingReportAffiliate.JSON_PROPERTY_NUMBER_OF_ADVANCE_DAYS,
  EngineConfigurationBookingReportAffiliate.JSON_PROPERTY_NUMBER_OF_STAY_DAYS,
  EngineConfigurationBookingReportAffiliate.JSON_PROPERTY_START_DATE,
  EngineConfigurationBookingReportAffiliate.JSON_PROPERTY_END_DATE,
  EngineConfigurationBookingReportAffiliate.JSON_PROPERTY_ROOM_CONFIGURATIONS,
  EngineConfigurationBookingReportAffiliate.JSON_PROPERTY_USE_DAYS,
  EngineConfigurationBookingReportAffiliate.JSON_PROPERTY_PROMOTIONAL_CODES,
  EngineConfigurationBookingReportAffiliate.JSON_PROPERTY_SEND_BOOKING_NOTIFICATION_EMAILS_TO_PROPERTY,
  EngineConfigurationBookingReportAffiliate.JSON_PROPERTY_SEND_BOOKING_NOTIFICATION_EMAILS_TO_BOOKER,
  EngineConfigurationBookingReportAffiliate.JSON_PROPERTY_SEND_BOOKING_NOTIFICATION_EMAILS_TO_CHANNEL_MANAGER,
  EngineConfigurationBookingReportAffiliate.JSON_PROPERTY_WC_BOOK_CLICK_ACTION,
  EngineConfigurationBookingReportAffiliate.JSON_PROPERTY_CITY,
  EngineConfigurationBookingReportAffiliate.JSON_PROPERTY_SHOW_UNAVAILABLE_CARD,
  EngineConfigurationBookingReportAffiliate.JSON_PROPERTY_SHOW_RANKINGS
})
@JsonTypeName("EngineConfigurationBookingReport_Affiliate")
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-01-28T21:18:10.241822052+07:00[Asia/Bangkok]")
public class EngineConfigurationBookingReportAffiliate {
  public static final String JSON_PROPERTY_IDENTIFIER = "identifier";
  private UUID identifier;

  public static final String JSON_PROPERTY_NAME = "name";
  private String name;

  public static final String JSON_PROPERTY_USER_IDENTIFIER = "userIdentifier";
  private UUID userIdentifier;

  public static final String JSON_PROPERTY_OWNER_IDENTIFIER = "ownerIdentifier";
  private UUID ownerIdentifier;

  public static final String JSON_PROPERTY_OWNER_NAME = "ownerName";
  private String ownerName;

  /**
   * Sales channel sub-type.
   */
  public enum SubTypeEnum {
    DIRECT("DIRECT"),
    
    APPLICATION("APPLICATION"),
    
    HOTEL("HOTEL"),
    
    TRAVELIKO("TRAVELIKO"),
    
    CORPORATE("CORPORATE"),
    
    TRAVEL_AGENT("TRAVEL_AGENT"),
    
    INFLUENCER("INFLUENCER"),
    
    BLOGGER("BLOGGER"),
    
    DESTINATION("DESTINATION"),
    
    CHANNEL_MANAGER("CHANNEL_MANAGER"),
    
    PROPERTY_MANAGEMENT_SYSTEM("PROPERTY_MANAGEMENT_SYSTEM"),
    
    CENTRAL_RESERVATION_SYSTEM("CENTRAL_RESERVATION_SYSTEM"),
    
    GOOGLE_HOTEL_API("GOOGLE_HOTEL_API");

    private String value;

    SubTypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static SubTypeEnum fromValue(String value) {
      for (SubTypeEnum b : SubTypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_SUB_TYPE = "subType";
  private SubTypeEnum subType;

  public static final String JSON_PROPERTY_DEFAULT_CURRENCY = "defaultCurrency";
  private String defaultCurrency = "USD";

  public static final String JSON_PROPERTY_DEFAULT_LANGUAGE = "defaultLanguage";
  private String defaultLanguage = "en";

  public static final String JSON_PROPERTY_LOGOS = "logos";
  private List<SimpleMultimediaAffiliate> logos;

  public static final String JSON_PROPERTY_HOSTED_BOOKING_ENGINE_URL = "hostedBookingEngineUrl";
  private String hostedBookingEngineUrl = "https://ota.wink.travel";

  public static final String JSON_PROPERTY_SELF_HOSTED = "selfHosted";
  private Boolean selfHosted = false;

  public static final String JSON_PROPERTY_THEME_COLORS = "themeColors";
  private EngineConfigurationThemeAffiliate themeColors;

  public static final String JSON_PROPERTY_NUMBER_OF_ADVANCE_DAYS = "numberOfAdvanceDays";
  private Integer numberOfAdvanceDays;

  public static final String JSON_PROPERTY_NUMBER_OF_STAY_DAYS = "numberOfStayDays";
  private Integer numberOfStayDays;

  public static final String JSON_PROPERTY_START_DATE = "startDate";
  private LocalDate startDate;

  public static final String JSON_PROPERTY_END_DATE = "endDate";
  private LocalDate endDate;

  public static final String JSON_PROPERTY_ROOM_CONFIGURATIONS = "roomConfigurations";
  private List<RoomConfigurationAffiliate> roomConfigurations;

  public static final String JSON_PROPERTY_USE_DAYS = "useDays";
  private Boolean useDays;

  public static final String JSON_PROPERTY_PROMOTIONAL_CODES = "promotionalCodes";
  private List<String> promotionalCodes;

  public static final String JSON_PROPERTY_SEND_BOOKING_NOTIFICATION_EMAILS_TO_PROPERTY = "sendBookingNotificationEmailsToProperty";
  private Boolean sendBookingNotificationEmailsToProperty = true;

  public static final String JSON_PROPERTY_SEND_BOOKING_NOTIFICATION_EMAILS_TO_BOOKER = "sendBookingNotificationEmailsToBooker";
  private Boolean sendBookingNotificationEmailsToBooker = true;

  public static final String JSON_PROPERTY_SEND_BOOKING_NOTIFICATION_EMAILS_TO_CHANNEL_MANAGER = "sendBookingNotificationEmailsToChannelManager";
  private Boolean sendBookingNotificationEmailsToChannelManager = true;

  /**
   * Action to complete once a user clicks on the CTA button on inventory.
   */
  public enum WcBookClickActionEnum {
    FORWARD_TO_IBE("FORWARD_TO_IBE"),
    
    IBE_MODAL("IBE_MODAL");

    private String value;

    WcBookClickActionEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static WcBookClickActionEnum fromValue(String value) {
      for (WcBookClickActionEnum b : WcBookClickActionEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_WC_BOOK_CLICK_ACTION = "wcBookClickAction";
  private WcBookClickActionEnum wcBookClickAction;

  public static final String JSON_PROPERTY_CITY = "city";
  private GeoNameAffiliate city;

  public static final String JSON_PROPERTY_SHOW_UNAVAILABLE_CARD = "showUnavailableCard";
  private Boolean showUnavailableCard;

  public static final String JSON_PROPERTY_SHOW_RANKINGS = "showRankings";
  private Boolean showRankings;

  public EngineConfigurationBookingReportAffiliate() {
  }

  public EngineConfigurationBookingReportAffiliate identifier(UUID identifier) {
    
    this.identifier = identifier;
    return this;
  }

   /**
   * Unique engine configuration identifier
   * @return identifier
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public UUID getIdentifier() {
    return identifier;
  }


  @JsonProperty(JSON_PROPERTY_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setIdentifier(UUID identifier) {
    this.identifier = identifier;
  }


  public EngineConfigurationBookingReportAffiliate name(String name) {
    
    this.name = name;
    return this;
  }

   /**
   * Engine configuration name
   * @return name
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getName() {
    return name;
  }


  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setName(String name) {
    this.name = name;
  }


  public EngineConfigurationBookingReportAffiliate userIdentifier(UUID userIdentifier) {
    
    this.userIdentifier = userIdentifier;
    return this;
  }

   /**
   * Authenticated user identifier
   * @return userIdentifier
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_USER_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public UUID getUserIdentifier() {
    return userIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_USER_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setUserIdentifier(UUID userIdentifier) {
    this.userIdentifier = userIdentifier;
  }


  public EngineConfigurationBookingReportAffiliate ownerIdentifier(UUID ownerIdentifier) {
    
    this.ownerIdentifier = ownerIdentifier;
    return this;
  }

   /**
   * Engine configuration record creator identifier
   * @return ownerIdentifier
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_OWNER_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public UUID getOwnerIdentifier() {
    return ownerIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_OWNER_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setOwnerIdentifier(UUID ownerIdentifier) {
    this.ownerIdentifier = ownerIdentifier;
  }


  public EngineConfigurationBookingReportAffiliate ownerName(String ownerName) {
    
    this.ownerName = ownerName;
    return this;
  }

   /**
   * Name of company owner.
   * @return ownerName
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_OWNER_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getOwnerName() {
    return ownerName;
  }


  @JsonProperty(JSON_PROPERTY_OWNER_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setOwnerName(String ownerName) {
    this.ownerName = ownerName;
  }


  public EngineConfigurationBookingReportAffiliate subType(SubTypeEnum subType) {
    
    this.subType = subType;
    return this;
  }

   /**
   * Sales channel sub-type.
   * @return subType
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_SUB_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public SubTypeEnum getSubType() {
    return subType;
  }


  @JsonProperty(JSON_PROPERTY_SUB_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setSubType(SubTypeEnum subType) {
    this.subType = subType;
  }


  public EngineConfigurationBookingReportAffiliate defaultCurrency(String defaultCurrency) {
    
    this.defaultCurrency = defaultCurrency;
    return this;
  }

   /**
   * Control which currency your users see prices in initially.
   * @return defaultCurrency
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_DEFAULT_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getDefaultCurrency() {
    return defaultCurrency;
  }


  @JsonProperty(JSON_PROPERTY_DEFAULT_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDefaultCurrency(String defaultCurrency) {
    this.defaultCurrency = defaultCurrency;
  }


  public EngineConfigurationBookingReportAffiliate defaultLanguage(String defaultLanguage) {
    
    this.defaultLanguage = defaultLanguage;
    return this;
  }

   /**
   * Control which language your users see text in initially.
   * @return defaultLanguage
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_DEFAULT_LANGUAGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getDefaultLanguage() {
    return defaultLanguage;
  }


  @JsonProperty(JSON_PROPERTY_DEFAULT_LANGUAGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDefaultLanguage(String defaultLanguage) {
    this.defaultLanguage = defaultLanguage;
  }


  public EngineConfigurationBookingReportAffiliate logos(List<SimpleMultimediaAffiliate> logos) {
    
    this.logos = logos;
    return this;
  }

  public EngineConfigurationBookingReportAffiliate addLogosItem(SimpleMultimediaAffiliate logosItem) {
    if (this.logos == null) {
      this.logos = new ArrayList<>();
    }
    this.logos.add(logosItem);
    return this;
  }

   /**
   * Customize booking confirmation emails by adding a custom logo to your configuration.
   * @return logos
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_LOGOS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<SimpleMultimediaAffiliate> getLogos() {
    return logos;
  }


  @JsonProperty(JSON_PROPERTY_LOGOS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLogos(List<SimpleMultimediaAffiliate> logos) {
    this.logos = logos;
  }


  public EngineConfigurationBookingReportAffiliate hostedBookingEngineUrl(String hostedBookingEngineUrl) {
    
    this.hostedBookingEngineUrl = hostedBookingEngineUrl;
    return this;
  }

   /**
   * If you are self-hosting our booking engine, let us know where it is hosted. Note: This url needs to be secured with SSL.
   * @return hostedBookingEngineUrl
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_HOSTED_BOOKING_ENGINE_URL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getHostedBookingEngineUrl() {
    return hostedBookingEngineUrl;
  }


  @JsonProperty(JSON_PROPERTY_HOSTED_BOOKING_ENGINE_URL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setHostedBookingEngineUrl(String hostedBookingEngineUrl) {
    this.hostedBookingEngineUrl = hostedBookingEngineUrl;
  }


  public EngineConfigurationBookingReportAffiliate selfHosted(Boolean selfHosted) {
    
    this.selfHosted = selfHosted;
    return this;
  }

   /**
   * Flag to indicate you are self-hosting our booking engine and not using our default booking engine url.
   * @return selfHosted
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_SELF_HOSTED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getSelfHosted() {
    return selfHosted;
  }


  @JsonProperty(JSON_PROPERTY_SELF_HOSTED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSelfHosted(Boolean selfHosted) {
    this.selfHosted = selfHosted;
  }


  public EngineConfigurationBookingReportAffiliate themeColors(EngineConfigurationThemeAffiliate themeColors) {
    
    this.themeColors = themeColors;
    return this;
  }

   /**
   * Get themeColors
   * @return themeColors
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_THEME_COLORS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public EngineConfigurationThemeAffiliate getThemeColors() {
    return themeColors;
  }


  @JsonProperty(JSON_PROPERTY_THEME_COLORS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setThemeColors(EngineConfigurationThemeAffiliate themeColors) {
    this.themeColors = themeColors;
  }


  public EngineConfigurationBookingReportAffiliate numberOfAdvanceDays(Integer numberOfAdvanceDays) {
    
    this.numberOfAdvanceDays = numberOfAdvanceDays;
    return this;
  }

   /**
   * You can control the initial itinerary date used to retrieve travel inventory prices. You can do it in one of two ways: 1. Dynamically set the date by indicating how long and how many days in advance (this field), of today&#39;s date, you want to display prices for. 2. Set a fixed date to display prices for. Option 1 is the most shared. Option 2 is for when you want to create a new customization and apply it to a specific event that occurs on a specific date. If you don&#39;t use either of these options, the itinerary will default to today&#39;s date with one night stay. ONLY populate this field if you want to control the itinerary date. Also, leave &#x60;startDate&#x60; and &#x60;endDate&#x60; empty.
   * @return numberOfAdvanceDays
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_NUMBER_OF_ADVANCE_DAYS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getNumberOfAdvanceDays() {
    return numberOfAdvanceDays;
  }


  @JsonProperty(JSON_PROPERTY_NUMBER_OF_ADVANCE_DAYS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setNumberOfAdvanceDays(Integer numberOfAdvanceDays) {
    this.numberOfAdvanceDays = numberOfAdvanceDays;
  }


  public EngineConfigurationBookingReportAffiliate numberOfStayDays(Integer numberOfStayDays) {
    
    this.numberOfStayDays = numberOfStayDays;
    return this;
  }

   /**
   * You can control the initial itinerary date used to retrieve travel inventory prices. You can do it in one of two ways: 1. Dynamically set the date by indicating how long (this field) and how many days in advance, of today&#39;s date, you want to display prices for. 2. Set a fixed date to display prices for. Option 1 is the most shared. Option 2 is for when you want to create a new customization and apply it to a specific event that occurs on a specific date. If you don&#39;t use either of these options, the itinerary will default to today&#39;s date with one night stay. ONLY populate this field if you want to control the itinerary date. Also, leave &#x60;startDate&#x60; and &#x60;endDate&#x60; empty.
   * @return numberOfStayDays
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_NUMBER_OF_STAY_DAYS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getNumberOfStayDays() {
    return numberOfStayDays;
  }


  @JsonProperty(JSON_PROPERTY_NUMBER_OF_STAY_DAYS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setNumberOfStayDays(Integer numberOfStayDays) {
    this.numberOfStayDays = numberOfStayDays;
  }


  public EngineConfigurationBookingReportAffiliate startDate(LocalDate startDate) {
    
    this.startDate = startDate;
    return this;
  }

   /**
   * Set a fixed itinerary start date. ONLY populate this field if you want to fix the itinerary date. Also, leave &#x60;numberOfAdvanceDays&#x60; and &#x60;numberOfStayDays&#x60; empty.
   * @return startDate
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_START_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public LocalDate getStartDate() {
    return startDate;
  }


  @JsonProperty(JSON_PROPERTY_START_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setStartDate(LocalDate startDate) {
    this.startDate = startDate;
  }


  public EngineConfigurationBookingReportAffiliate endDate(LocalDate endDate) {
    
    this.endDate = endDate;
    return this;
  }

   /**
   * Set a fixed itinerary end date ONLY populate this field if you want to fix the itinerary date. Also, leave &#x60;numberOfAdvanceDays&#x60; and &#x60;numberOfStayDays&#x60; empty.
   * @return endDate
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_END_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public LocalDate getEndDate() {
    return endDate;
  }


  @JsonProperty(JSON_PROPERTY_END_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setEndDate(LocalDate endDate) {
    this.endDate = endDate;
  }


  public EngineConfigurationBookingReportAffiliate roomConfigurations(List<RoomConfigurationAffiliate> roomConfigurations) {
    
    this.roomConfigurations = roomConfigurations;
    return this;
  }

  public EngineConfigurationBookingReportAffiliate addRoomConfigurationsItem(RoomConfigurationAffiliate roomConfigurationsItem) {
    if (this.roomConfigurations == null) {
      this.roomConfigurations = new ArrayList<>();
    }
    this.roomConfigurations.add(roomConfigurationsItem);
    return this;
  }

   /**
   * Control how many adults / children will be staying and how many rooms. Defaults to: One room, two adults.
   * @return roomConfigurations
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_ROOM_CONFIGURATIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<RoomConfigurationAffiliate> getRoomConfigurations() {
    return roomConfigurations;
  }


  @JsonProperty(JSON_PROPERTY_ROOM_CONFIGURATIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRoomConfigurations(List<RoomConfigurationAffiliate> roomConfigurations) {
    this.roomConfigurations = roomConfigurations;
  }


  public EngineConfigurationBookingReportAffiliate useDays(Boolean useDays) {
    
    this.useDays = useDays;
    return this;
  }

   /**
   * if true, we use numberOfAdvanceDays / numberOfStayDays properties - false, we use startDate / endDate
   * @return useDays
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_USE_DAYS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getUseDays() {
    return useDays;
  }


  @JsonProperty(JSON_PROPERTY_USE_DAYS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setUseDays(Boolean useDays) {
    this.useDays = useDays;
  }


  public EngineConfigurationBookingReportAffiliate promotionalCodes(List<String> promotionalCodes) {
    
    this.promotionalCodes = promotionalCodes;
    return this;
  }

  public EngineConfigurationBookingReportAffiliate addPromotionalCodesItem(String promotionalCodesItem) {
    if (this.promotionalCodes == null) {
      this.promotionalCodes = new ArrayList<>();
    }
    this.promotionalCodes.add(promotionalCodesItem);
    return this;
  }

   /**
   * If you&#39;ve received special promotional codes from suppliers to give to your audience, you can choose to bake these code directly into the price by entering them here.
   * @return promotionalCodes
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_PROMOTIONAL_CODES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<String> getPromotionalCodes() {
    return promotionalCodes;
  }


  @JsonProperty(JSON_PROPERTY_PROMOTIONAL_CODES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPromotionalCodes(List<String> promotionalCodes) {
    this.promotionalCodes = promotionalCodes;
  }


  public EngineConfigurationBookingReportAffiliate sendBookingNotificationEmailsToProperty(Boolean sendBookingNotificationEmailsToProperty) {
    
    this.sendBookingNotificationEmailsToProperty = sendBookingNotificationEmailsToProperty;
    return this;
  }

   /**
   * An integrator can choose to disable outgoing emails to properties because they want to do that themselves.
   * @return sendBookingNotificationEmailsToProperty
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_SEND_BOOKING_NOTIFICATION_EMAILS_TO_PROPERTY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getSendBookingNotificationEmailsToProperty() {
    return sendBookingNotificationEmailsToProperty;
  }


  @JsonProperty(JSON_PROPERTY_SEND_BOOKING_NOTIFICATION_EMAILS_TO_PROPERTY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSendBookingNotificationEmailsToProperty(Boolean sendBookingNotificationEmailsToProperty) {
    this.sendBookingNotificationEmailsToProperty = sendBookingNotificationEmailsToProperty;
  }


  public EngineConfigurationBookingReportAffiliate sendBookingNotificationEmailsToBooker(Boolean sendBookingNotificationEmailsToBooker) {
    
    this.sendBookingNotificationEmailsToBooker = sendBookingNotificationEmailsToBooker;
    return this;
  }

   /**
   * An integrator can choose to disable outgoing emails to users because they want to do that themselves.
   * @return sendBookingNotificationEmailsToBooker
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_SEND_BOOKING_NOTIFICATION_EMAILS_TO_BOOKER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getSendBookingNotificationEmailsToBooker() {
    return sendBookingNotificationEmailsToBooker;
  }


  @JsonProperty(JSON_PROPERTY_SEND_BOOKING_NOTIFICATION_EMAILS_TO_BOOKER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSendBookingNotificationEmailsToBooker(Boolean sendBookingNotificationEmailsToBooker) {
    this.sendBookingNotificationEmailsToBooker = sendBookingNotificationEmailsToBooker;
  }


  public EngineConfigurationBookingReportAffiliate sendBookingNotificationEmailsToChannelManager(Boolean sendBookingNotificationEmailsToChannelManager) {
    
    this.sendBookingNotificationEmailsToChannelManager = sendBookingNotificationEmailsToChannelManager;
    return this;
  }

   /**
   * An integrator can choose to disable notifying the property&#39;s channel manager. Note: This should ONLY be done for testing.
   * @return sendBookingNotificationEmailsToChannelManager
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_SEND_BOOKING_NOTIFICATION_EMAILS_TO_CHANNEL_MANAGER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getSendBookingNotificationEmailsToChannelManager() {
    return sendBookingNotificationEmailsToChannelManager;
  }


  @JsonProperty(JSON_PROPERTY_SEND_BOOKING_NOTIFICATION_EMAILS_TO_CHANNEL_MANAGER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSendBookingNotificationEmailsToChannelManager(Boolean sendBookingNotificationEmailsToChannelManager) {
    this.sendBookingNotificationEmailsToChannelManager = sendBookingNotificationEmailsToChannelManager;
  }


  public EngineConfigurationBookingReportAffiliate wcBookClickAction(WcBookClickActionEnum wcBookClickAction) {
    
    this.wcBookClickAction = wcBookClickAction;
    return this;
  }

   /**
   * Action to complete once a user clicks on the CTA button on inventory.
   * @return wcBookClickAction
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_WC_BOOK_CLICK_ACTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public WcBookClickActionEnum getWcBookClickAction() {
    return wcBookClickAction;
  }


  @JsonProperty(JSON_PROPERTY_WC_BOOK_CLICK_ACTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setWcBookClickAction(WcBookClickActionEnum wcBookClickAction) {
    this.wcBookClickAction = wcBookClickAction;
  }


  public EngineConfigurationBookingReportAffiliate city(GeoNameAffiliate city) {
    
    this.city = city;
    return this;
  }

   /**
   * Get city
   * @return city
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_CITY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public GeoNameAffiliate getCity() {
    return city;
  }


  @JsonProperty(JSON_PROPERTY_CITY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCity(GeoNameAffiliate city) {
    this.city = city;
  }


  public EngineConfigurationBookingReportAffiliate showUnavailableCard(Boolean showUnavailableCard) {
    
    this.showUnavailableCard = showUnavailableCard;
    return this;
  }

   /**
   * Show unavailable inventory card when inventory not currently for sale. Otherwise, it displays a normal card but without the price.
   * @return showUnavailableCard
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_SHOW_UNAVAILABLE_CARD)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getShowUnavailableCard() {
    return showUnavailableCard;
  }


  @JsonProperty(JSON_PROPERTY_SHOW_UNAVAILABLE_CARD)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setShowUnavailableCard(Boolean showUnavailableCard) {
    this.showUnavailableCard = showUnavailableCard;
  }


  public EngineConfigurationBookingReportAffiliate showRankings(Boolean showRankings) {
    
    this.showRankings = showRankings;
    return this;
  }

   /**
   * Whether to display rankings (lifestyle, eco score and reviews) on hotel landing page.
   * @return showRankings
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_SHOW_RANKINGS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getShowRankings() {
    return showRankings;
  }


  @JsonProperty(JSON_PROPERTY_SHOW_RANKINGS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setShowRankings(Boolean showRankings) {
    this.showRankings = showRankings;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    EngineConfigurationBookingReportAffiliate engineConfigurationBookingReportAffiliate = (EngineConfigurationBookingReportAffiliate) o;
    return Objects.equals(this.identifier, engineConfigurationBookingReportAffiliate.identifier) &&
        Objects.equals(this.name, engineConfigurationBookingReportAffiliate.name) &&
        Objects.equals(this.userIdentifier, engineConfigurationBookingReportAffiliate.userIdentifier) &&
        Objects.equals(this.ownerIdentifier, engineConfigurationBookingReportAffiliate.ownerIdentifier) &&
        Objects.equals(this.ownerName, engineConfigurationBookingReportAffiliate.ownerName) &&
        Objects.equals(this.subType, engineConfigurationBookingReportAffiliate.subType) &&
        Objects.equals(this.defaultCurrency, engineConfigurationBookingReportAffiliate.defaultCurrency) &&
        Objects.equals(this.defaultLanguage, engineConfigurationBookingReportAffiliate.defaultLanguage) &&
        Objects.equals(this.logos, engineConfigurationBookingReportAffiliate.logos) &&
        Objects.equals(this.hostedBookingEngineUrl, engineConfigurationBookingReportAffiliate.hostedBookingEngineUrl) &&
        Objects.equals(this.selfHosted, engineConfigurationBookingReportAffiliate.selfHosted) &&
        Objects.equals(this.themeColors, engineConfigurationBookingReportAffiliate.themeColors) &&
        Objects.equals(this.numberOfAdvanceDays, engineConfigurationBookingReportAffiliate.numberOfAdvanceDays) &&
        Objects.equals(this.numberOfStayDays, engineConfigurationBookingReportAffiliate.numberOfStayDays) &&
        Objects.equals(this.startDate, engineConfigurationBookingReportAffiliate.startDate) &&
        Objects.equals(this.endDate, engineConfigurationBookingReportAffiliate.endDate) &&
        Objects.equals(this.roomConfigurations, engineConfigurationBookingReportAffiliate.roomConfigurations) &&
        Objects.equals(this.useDays, engineConfigurationBookingReportAffiliate.useDays) &&
        Objects.equals(this.promotionalCodes, engineConfigurationBookingReportAffiliate.promotionalCodes) &&
        Objects.equals(this.sendBookingNotificationEmailsToProperty, engineConfigurationBookingReportAffiliate.sendBookingNotificationEmailsToProperty) &&
        Objects.equals(this.sendBookingNotificationEmailsToBooker, engineConfigurationBookingReportAffiliate.sendBookingNotificationEmailsToBooker) &&
        Objects.equals(this.sendBookingNotificationEmailsToChannelManager, engineConfigurationBookingReportAffiliate.sendBookingNotificationEmailsToChannelManager) &&
        Objects.equals(this.wcBookClickAction, engineConfigurationBookingReportAffiliate.wcBookClickAction) &&
        Objects.equals(this.city, engineConfigurationBookingReportAffiliate.city) &&
        Objects.equals(this.showUnavailableCard, engineConfigurationBookingReportAffiliate.showUnavailableCard) &&
        Objects.equals(this.showRankings, engineConfigurationBookingReportAffiliate.showRankings);
  }

  @Override
  public int hashCode() {
    return Objects.hash(identifier, name, userIdentifier, ownerIdentifier, ownerName, subType, defaultCurrency, defaultLanguage, logos, hostedBookingEngineUrl, selfHosted, themeColors, numberOfAdvanceDays, numberOfStayDays, startDate, endDate, roomConfigurations, useDays, promotionalCodes, sendBookingNotificationEmailsToProperty, sendBookingNotificationEmailsToBooker, sendBookingNotificationEmailsToChannelManager, wcBookClickAction, city, showUnavailableCard, showRankings);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class EngineConfigurationBookingReportAffiliate {\n");
    sb.append("    identifier: ").append(toIndentedString(identifier)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    userIdentifier: ").append(toIndentedString(userIdentifier)).append("\n");
    sb.append("    ownerIdentifier: ").append(toIndentedString(ownerIdentifier)).append("\n");
    sb.append("    ownerName: ").append(toIndentedString(ownerName)).append("\n");
    sb.append("    subType: ").append(toIndentedString(subType)).append("\n");
    sb.append("    defaultCurrency: ").append(toIndentedString(defaultCurrency)).append("\n");
    sb.append("    defaultLanguage: ").append(toIndentedString(defaultLanguage)).append("\n");
    sb.append("    logos: ").append(toIndentedString(logos)).append("\n");
    sb.append("    hostedBookingEngineUrl: ").append(toIndentedString(hostedBookingEngineUrl)).append("\n");
    sb.append("    selfHosted: ").append(toIndentedString(selfHosted)).append("\n");
    sb.append("    themeColors: ").append(toIndentedString(themeColors)).append("\n");
    sb.append("    numberOfAdvanceDays: ").append(toIndentedString(numberOfAdvanceDays)).append("\n");
    sb.append("    numberOfStayDays: ").append(toIndentedString(numberOfStayDays)).append("\n");
    sb.append("    startDate: ").append(toIndentedString(startDate)).append("\n");
    sb.append("    endDate: ").append(toIndentedString(endDate)).append("\n");
    sb.append("    roomConfigurations: ").append(toIndentedString(roomConfigurations)).append("\n");
    sb.append("    useDays: ").append(toIndentedString(useDays)).append("\n");
    sb.append("    promotionalCodes: ").append(toIndentedString(promotionalCodes)).append("\n");
    sb.append("    sendBookingNotificationEmailsToProperty: ").append(toIndentedString(sendBookingNotificationEmailsToProperty)).append("\n");
    sb.append("    sendBookingNotificationEmailsToBooker: ").append(toIndentedString(sendBookingNotificationEmailsToBooker)).append("\n");
    sb.append("    sendBookingNotificationEmailsToChannelManager: ").append(toIndentedString(sendBookingNotificationEmailsToChannelManager)).append("\n");
    sb.append("    wcBookClickAction: ").append(toIndentedString(wcBookClickAction)).append("\n");
    sb.append("    city: ").append(toIndentedString(city)).append("\n");
    sb.append("    showUnavailableCard: ").append(toIndentedString(showUnavailableCard)).append("\n");
    sb.append("    showRankings: ").append(toIndentedString(showRankings)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

