/*
 * Wink API
 * ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Affiliate](/affiliate): All APIs related to selling travel inventory as an affiliate. - [Analytics](/analytics): All APIs related to tracking metrics across a wide variety of data source segments including, more entertaining, leaderboard metrics. - [Booking](/booking): All APIs related to creating platform bookings. - [Channel Manager](/channel-manager): All APIs related to channel managers who want to integrate with our platform. - [Extranet](/extranet): All APIs related to managing travel inventory and suppliers. - [Inventory](/inventory): All APIs related to retrieve known travel inventory as it was found using the Lookup API.. - [Lookup](/lookup): All APIs related to locating inventory by region, locale and property flags. - [Reference](/reference): All APIs related to retrieving platform-supported taxonomies. - [TripPay Acquiring](/payment-acquiring): All APIs related to capture payment details such as a Stripe payment intent. - [TripPay](/payment): All APIs related to TripPay account management, booking, mapping and integration features.  ## SDKs We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).  - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)  ## Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Wink-Version` header. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints.  ## Release history - 2022-10-15: v2.0 - Removed HATEOAS and added Wink-Version header - 2022-05-08: v1 - Exposed channel manager API - 2021-07-01: v1 - Initial release  # Affiliate API Welcome to the Affiliate API - A programmer-friendly way to search for and display bespoke travel inventory for your audience. Use this API to help you prepare travel inventory for sale.  # Intended Audience Programmers are a requirement to start integrating with wink. You will benefit from an API integration if you are new or existing travel related company that want easy access to great inventory.## Examples: - Hotel brands / chains that want to make their own booking engine - Travel tech companies that want to create the next hot mobile travel app - Destination sites that want to make their own booking engine - Bloggers and influencers who want to sell travel inventory to their audience - OTAs that want access direct relationships with suppliers and better quality hotel inventory
 *
 * The version of the OpenAPI document: 29.36.0
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.affiliate.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import travel.wink.sdk.affiliate.model.PlanTierAffiliate;
import travel.wink.sdk.affiliate.model.TransformUsageAffiliate;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * PlanAffiliate
 */
@JsonPropertyOrder({
  PlanAffiliate.JSON_PROPERTY_ACTIVE,
  PlanAffiliate.JSON_PROPERTY_AGGREGATE_USAGE,
  PlanAffiliate.JSON_PROPERTY_AMOUNT,
  PlanAffiliate.JSON_PROPERTY_AMOUNT_DECIMAL,
  PlanAffiliate.JSON_PROPERTY_BILLING_SCHEME,
  PlanAffiliate.JSON_PROPERTY_CREATED,
  PlanAffiliate.JSON_PROPERTY_CURRENCY,
  PlanAffiliate.JSON_PROPERTY_DELETED,
  PlanAffiliate.JSON_PROPERTY_ID,
  PlanAffiliate.JSON_PROPERTY_INTERVAL,
  PlanAffiliate.JSON_PROPERTY_INTERVAL_COUNT,
  PlanAffiliate.JSON_PROPERTY_LIVEMODE,
  PlanAffiliate.JSON_PROPERTY_METADATA,
  PlanAffiliate.JSON_PROPERTY_NICKNAME,
  PlanAffiliate.JSON_PROPERTY_OBJECT,
  PlanAffiliate.JSON_PROPERTY_TIERS,
  PlanAffiliate.JSON_PROPERTY_TIERS_MODE,
  PlanAffiliate.JSON_PROPERTY_TRANSFORM_USAGE,
  PlanAffiliate.JSON_PROPERTY_TRIAL_PERIOD_DAYS,
  PlanAffiliate.JSON_PROPERTY_USAGE_TYPE,
  PlanAffiliate.JSON_PROPERTY_SORT
})
@JsonTypeName("Plan_Affiliate")
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-01-28T21:18:10.241822052+07:00[Asia/Bangkok]")
public class PlanAffiliate {
  public static final String JSON_PROPERTY_ACTIVE = "active";
  private Boolean active;

  public static final String JSON_PROPERTY_AGGREGATE_USAGE = "aggregateUsage";
  private String aggregateUsage;

  public static final String JSON_PROPERTY_AMOUNT = "amount";
  private Long amount;

  public static final String JSON_PROPERTY_AMOUNT_DECIMAL = "amountDecimal";
  private BigDecimal amountDecimal;

  public static final String JSON_PROPERTY_BILLING_SCHEME = "billingScheme";
  private String billingScheme;

  public static final String JSON_PROPERTY_CREATED = "created";
  private Long created;

  public static final String JSON_PROPERTY_CURRENCY = "currency";
  private String currency;

  public static final String JSON_PROPERTY_DELETED = "deleted";
  private Boolean deleted;

  public static final String JSON_PROPERTY_ID = "id";
  private String id;

  public static final String JSON_PROPERTY_INTERVAL = "interval";
  private String interval;

  public static final String JSON_PROPERTY_INTERVAL_COUNT = "intervalCount";
  private Long intervalCount;

  public static final String JSON_PROPERTY_LIVEMODE = "livemode";
  private Boolean livemode;

  public static final String JSON_PROPERTY_METADATA = "metadata";
  private Map<String, String> metadata = new HashMap<>();

  public static final String JSON_PROPERTY_NICKNAME = "nickname";
  private String nickname;

  public static final String JSON_PROPERTY_OBJECT = "object";
  private String _object;

  public static final String JSON_PROPERTY_TIERS = "tiers";
  private List<PlanTierAffiliate> tiers;

  public static final String JSON_PROPERTY_TIERS_MODE = "tiersMode";
  private String tiersMode;

  public static final String JSON_PROPERTY_TRANSFORM_USAGE = "transformUsage";
  private TransformUsageAffiliate transformUsage;

  public static final String JSON_PROPERTY_TRIAL_PERIOD_DAYS = "trialPeriodDays";
  private Long trialPeriodDays;

  public static final String JSON_PROPERTY_USAGE_TYPE = "usageType";
  private String usageType;

  public static final String JSON_PROPERTY_SORT = "sort";
  private Integer sort;

  public PlanAffiliate() {
  }

  public PlanAffiliate active(Boolean active) {
    
    this.active = active;
    return this;
  }

   /**
   * Get active
   * @return active
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_ACTIVE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getActive() {
    return active;
  }


  @JsonProperty(JSON_PROPERTY_ACTIVE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setActive(Boolean active) {
    this.active = active;
  }


  public PlanAffiliate aggregateUsage(String aggregateUsage) {
    
    this.aggregateUsage = aggregateUsage;
    return this;
  }

   /**
   * Get aggregateUsage
   * @return aggregateUsage
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_AGGREGATE_USAGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getAggregateUsage() {
    return aggregateUsage;
  }


  @JsonProperty(JSON_PROPERTY_AGGREGATE_USAGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAggregateUsage(String aggregateUsage) {
    this.aggregateUsage = aggregateUsage;
  }


  public PlanAffiliate amount(Long amount) {
    
    this.amount = amount;
    return this;
  }

   /**
   * Get amount
   * @return amount
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Long getAmount() {
    return amount;
  }


  @JsonProperty(JSON_PROPERTY_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAmount(Long amount) {
    this.amount = amount;
  }


  public PlanAffiliate amountDecimal(BigDecimal amountDecimal) {
    
    this.amountDecimal = amountDecimal;
    return this;
  }

   /**
   * Get amountDecimal
   * @return amountDecimal
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_AMOUNT_DECIMAL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public BigDecimal getAmountDecimal() {
    return amountDecimal;
  }


  @JsonProperty(JSON_PROPERTY_AMOUNT_DECIMAL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAmountDecimal(BigDecimal amountDecimal) {
    this.amountDecimal = amountDecimal;
  }


  public PlanAffiliate billingScheme(String billingScheme) {
    
    this.billingScheme = billingScheme;
    return this;
  }

   /**
   * Get billingScheme
   * @return billingScheme
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_BILLING_SCHEME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getBillingScheme() {
    return billingScheme;
  }


  @JsonProperty(JSON_PROPERTY_BILLING_SCHEME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setBillingScheme(String billingScheme) {
    this.billingScheme = billingScheme;
  }


  public PlanAffiliate created(Long created) {
    
    this.created = created;
    return this;
  }

   /**
   * Get created
   * @return created
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_CREATED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Long getCreated() {
    return created;
  }


  @JsonProperty(JSON_PROPERTY_CREATED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCreated(Long created) {
    this.created = created;
  }


  public PlanAffiliate currency(String currency) {
    
    this.currency = currency;
    return this;
  }

   /**
   * Get currency
   * @return currency
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getCurrency() {
    return currency;
  }


  @JsonProperty(JSON_PROPERTY_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCurrency(String currency) {
    this.currency = currency;
  }


  public PlanAffiliate deleted(Boolean deleted) {
    
    this.deleted = deleted;
    return this;
  }

   /**
   * Get deleted
   * @return deleted
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_DELETED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getDeleted() {
    return deleted;
  }


  @JsonProperty(JSON_PROPERTY_DELETED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDeleted(Boolean deleted) {
    this.deleted = deleted;
  }


  public PlanAffiliate id(String id) {
    
    this.id = id;
    return this;
  }

   /**
   * Get id
   * @return id
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getId() {
    return id;
  }


  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setId(String id) {
    this.id = id;
  }


  public PlanAffiliate interval(String interval) {
    
    this.interval = interval;
    return this;
  }

   /**
   * Get interval
   * @return interval
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_INTERVAL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getInterval() {
    return interval;
  }


  @JsonProperty(JSON_PROPERTY_INTERVAL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setInterval(String interval) {
    this.interval = interval;
  }


  public PlanAffiliate intervalCount(Long intervalCount) {
    
    this.intervalCount = intervalCount;
    return this;
  }

   /**
   * Get intervalCount
   * @return intervalCount
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_INTERVAL_COUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Long getIntervalCount() {
    return intervalCount;
  }


  @JsonProperty(JSON_PROPERTY_INTERVAL_COUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIntervalCount(Long intervalCount) {
    this.intervalCount = intervalCount;
  }


  public PlanAffiliate livemode(Boolean livemode) {
    
    this.livemode = livemode;
    return this;
  }

   /**
   * Get livemode
   * @return livemode
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_LIVEMODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getLivemode() {
    return livemode;
  }


  @JsonProperty(JSON_PROPERTY_LIVEMODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLivemode(Boolean livemode) {
    this.livemode = livemode;
  }


  public PlanAffiliate metadata(Map<String, String> metadata) {
    
    this.metadata = metadata;
    return this;
  }

  public PlanAffiliate putMetadataItem(String key, String metadataItem) {
    if (this.metadata == null) {
      this.metadata = new HashMap<>();
    }
    this.metadata.put(key, metadataItem);
    return this;
  }

   /**
   * Get metadata
   * @return metadata
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_METADATA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Map<String, String> getMetadata() {
    return metadata;
  }


  @JsonProperty(JSON_PROPERTY_METADATA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMetadata(Map<String, String> metadata) {
    this.metadata = metadata;
  }


  public PlanAffiliate nickname(String nickname) {
    
    this.nickname = nickname;
    return this;
  }

   /**
   * Get nickname
   * @return nickname
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_NICKNAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getNickname() {
    return nickname;
  }


  @JsonProperty(JSON_PROPERTY_NICKNAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setNickname(String nickname) {
    this.nickname = nickname;
  }


  public PlanAffiliate _object(String _object) {
    
    this._object = _object;
    return this;
  }

   /**
   * Get _object
   * @return _object
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_OBJECT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getObject() {
    return _object;
  }


  @JsonProperty(JSON_PROPERTY_OBJECT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setObject(String _object) {
    this._object = _object;
  }


  public PlanAffiliate tiers(List<PlanTierAffiliate> tiers) {
    
    this.tiers = tiers;
    return this;
  }

  public PlanAffiliate addTiersItem(PlanTierAffiliate tiersItem) {
    if (this.tiers == null) {
      this.tiers = new ArrayList<>();
    }
    this.tiers.add(tiersItem);
    return this;
  }

   /**
   * Get tiers
   * @return tiers
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_TIERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<PlanTierAffiliate> getTiers() {
    return tiers;
  }


  @JsonProperty(JSON_PROPERTY_TIERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTiers(List<PlanTierAffiliate> tiers) {
    this.tiers = tiers;
  }


  public PlanAffiliate tiersMode(String tiersMode) {
    
    this.tiersMode = tiersMode;
    return this;
  }

   /**
   * Get tiersMode
   * @return tiersMode
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_TIERS_MODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getTiersMode() {
    return tiersMode;
  }


  @JsonProperty(JSON_PROPERTY_TIERS_MODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTiersMode(String tiersMode) {
    this.tiersMode = tiersMode;
  }


  public PlanAffiliate transformUsage(TransformUsageAffiliate transformUsage) {
    
    this.transformUsage = transformUsage;
    return this;
  }

   /**
   * Get transformUsage
   * @return transformUsage
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_TRANSFORM_USAGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public TransformUsageAffiliate getTransformUsage() {
    return transformUsage;
  }


  @JsonProperty(JSON_PROPERTY_TRANSFORM_USAGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTransformUsage(TransformUsageAffiliate transformUsage) {
    this.transformUsage = transformUsage;
  }


  public PlanAffiliate trialPeriodDays(Long trialPeriodDays) {
    
    this.trialPeriodDays = trialPeriodDays;
    return this;
  }

   /**
   * Get trialPeriodDays
   * @return trialPeriodDays
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_TRIAL_PERIOD_DAYS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Long getTrialPeriodDays() {
    return trialPeriodDays;
  }


  @JsonProperty(JSON_PROPERTY_TRIAL_PERIOD_DAYS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTrialPeriodDays(Long trialPeriodDays) {
    this.trialPeriodDays = trialPeriodDays;
  }


  public PlanAffiliate usageType(String usageType) {
    
    this.usageType = usageType;
    return this;
  }

   /**
   * Get usageType
   * @return usageType
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_USAGE_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getUsageType() {
    return usageType;
  }


  @JsonProperty(JSON_PROPERTY_USAGE_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setUsageType(String usageType) {
    this.usageType = usageType;
  }


  public PlanAffiliate sort(Integer sort) {
    
    this.sort = sort;
    return this;
  }

   /**
   * Get sort
   * @return sort
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_SORT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getSort() {
    return sort;
  }


  @JsonProperty(JSON_PROPERTY_SORT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSort(Integer sort) {
    this.sort = sort;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    PlanAffiliate planAffiliate = (PlanAffiliate) o;
    return Objects.equals(this.active, planAffiliate.active) &&
        Objects.equals(this.aggregateUsage, planAffiliate.aggregateUsage) &&
        Objects.equals(this.amount, planAffiliate.amount) &&
        Objects.equals(this.amountDecimal, planAffiliate.amountDecimal) &&
        Objects.equals(this.billingScheme, planAffiliate.billingScheme) &&
        Objects.equals(this.created, planAffiliate.created) &&
        Objects.equals(this.currency, planAffiliate.currency) &&
        Objects.equals(this.deleted, planAffiliate.deleted) &&
        Objects.equals(this.id, planAffiliate.id) &&
        Objects.equals(this.interval, planAffiliate.interval) &&
        Objects.equals(this.intervalCount, planAffiliate.intervalCount) &&
        Objects.equals(this.livemode, planAffiliate.livemode) &&
        Objects.equals(this.metadata, planAffiliate.metadata) &&
        Objects.equals(this.nickname, planAffiliate.nickname) &&
        Objects.equals(this._object, planAffiliate._object) &&
        Objects.equals(this.tiers, planAffiliate.tiers) &&
        Objects.equals(this.tiersMode, planAffiliate.tiersMode) &&
        Objects.equals(this.transformUsage, planAffiliate.transformUsage) &&
        Objects.equals(this.trialPeriodDays, planAffiliate.trialPeriodDays) &&
        Objects.equals(this.usageType, planAffiliate.usageType) &&
        Objects.equals(this.sort, planAffiliate.sort);
  }

  @Override
  public int hashCode() {
    return Objects.hash(active, aggregateUsage, amount, amountDecimal, billingScheme, created, currency, deleted, id, interval, intervalCount, livemode, metadata, nickname, _object, tiers, tiersMode, transformUsage, trialPeriodDays, usageType, sort);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class PlanAffiliate {\n");
    sb.append("    active: ").append(toIndentedString(active)).append("\n");
    sb.append("    aggregateUsage: ").append(toIndentedString(aggregateUsage)).append("\n");
    sb.append("    amount: ").append(toIndentedString(amount)).append("\n");
    sb.append("    amountDecimal: ").append(toIndentedString(amountDecimal)).append("\n");
    sb.append("    billingScheme: ").append(toIndentedString(billingScheme)).append("\n");
    sb.append("    created: ").append(toIndentedString(created)).append("\n");
    sb.append("    currency: ").append(toIndentedString(currency)).append("\n");
    sb.append("    deleted: ").append(toIndentedString(deleted)).append("\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    interval: ").append(toIndentedString(interval)).append("\n");
    sb.append("    intervalCount: ").append(toIndentedString(intervalCount)).append("\n");
    sb.append("    livemode: ").append(toIndentedString(livemode)).append("\n");
    sb.append("    metadata: ").append(toIndentedString(metadata)).append("\n");
    sb.append("    nickname: ").append(toIndentedString(nickname)).append("\n");
    sb.append("    _object: ").append(toIndentedString(_object)).append("\n");
    sb.append("    tiers: ").append(toIndentedString(tiers)).append("\n");
    sb.append("    tiersMode: ").append(toIndentedString(tiersMode)).append("\n");
    sb.append("    transformUsage: ").append(toIndentedString(transformUsage)).append("\n");
    sb.append("    trialPeriodDays: ").append(toIndentedString(trialPeriodDays)).append("\n");
    sb.append("    usageType: ").append(toIndentedString(usageType)).append("\n");
    sb.append("    sort: ").append(toIndentedString(sort)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

