package travel.wink.sdk.affiliate.api;

import travel.wink.sdk.affiliate.invoker.ApiClient;

import travel.wink.sdk.affiliate.model.GenericErrorMessage;
import travel.wink.sdk.affiliate.model.RemoveEntryResponseAffiliate;
import travel.wink.sdk.affiliate.model.ShowSupplierUrl400Response;
import travel.wink.sdk.affiliate.model.SupplierLeadAffiliate;
import travel.wink.sdk.affiliate.model.UpsertSupplierLeadAffiliate;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.web.reactive.function.client.WebClient.ResponseSpec;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Flux;

@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-02-23T13:11:09.149753540+07:00[Asia/Bangkok]")
public class LeadApi {
    private ApiClient apiClient;

    public LeadApi() {
        this(new ApiClient());
    }

    @Autowired
    public LeadApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Create lead
     * Creates a new supplier lead based on information retrieved from Google Places
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>405</b> - Method Not Allowed
     * <p><b>201</b> - Created
     * @param companyIdentifier Create lead by this owner identifier.
     * @param upsertSupplierLeadAffiliate The upsertSupplierLeadAffiliate parameter
     * @param winkVersion The winkVersion parameter
     * @return SupplierLeadAffiliate
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec createLeadRequestCreation(String companyIdentifier, UpsertSupplierLeadAffiliate upsertSupplierLeadAffiliate, String winkVersion) throws WebClientResponseException {
        Object postBody = upsertSupplierLeadAffiliate;
        // verify the required parameter 'companyIdentifier' is set
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling createLead", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'upsertSupplierLeadAffiliate' is set
        if (upsertSupplierLeadAffiliate == null) {
            throw new WebClientResponseException("Missing the required parameter 'upsertSupplierLeadAffiliate' when calling createLead", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("companyIdentifier", companyIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<SupplierLeadAffiliate> localVarReturnType = new ParameterizedTypeReference<SupplierLeadAffiliate>() {};
        return apiClient.invokeAPI("/api/company/{companyIdentifier}/lead", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Create lead
     * Creates a new supplier lead based on information retrieved from Google Places
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>405</b> - Method Not Allowed
     * <p><b>201</b> - Created
     * @param companyIdentifier Create lead by this owner identifier.
     * @param upsertSupplierLeadAffiliate The upsertSupplierLeadAffiliate parameter
     * @param winkVersion The winkVersion parameter
     * @return SupplierLeadAffiliate
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<SupplierLeadAffiliate> createLead(String companyIdentifier, UpsertSupplierLeadAffiliate upsertSupplierLeadAffiliate, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<SupplierLeadAffiliate> localVarReturnType = new ParameterizedTypeReference<SupplierLeadAffiliate>() {};
        return createLeadRequestCreation(companyIdentifier, upsertSupplierLeadAffiliate, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Create lead
     * Creates a new supplier lead based on information retrieved from Google Places
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>405</b> - Method Not Allowed
     * <p><b>201</b> - Created
     * @param companyIdentifier Create lead by this owner identifier.
     * @param upsertSupplierLeadAffiliate The upsertSupplierLeadAffiliate parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;SupplierLeadAffiliate&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<SupplierLeadAffiliate>> createLeadWithHttpInfo(String companyIdentifier, UpsertSupplierLeadAffiliate upsertSupplierLeadAffiliate, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<SupplierLeadAffiliate> localVarReturnType = new ParameterizedTypeReference<SupplierLeadAffiliate>() {};
        return createLeadRequestCreation(companyIdentifier, upsertSupplierLeadAffiliate, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Create lead
     * Creates a new supplier lead based on information retrieved from Google Places
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>405</b> - Method Not Allowed
     * <p><b>201</b> - Created
     * @param companyIdentifier Create lead by this owner identifier.
     * @param upsertSupplierLeadAffiliate The upsertSupplierLeadAffiliate parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec createLeadWithResponseSpec(String companyIdentifier, UpsertSupplierLeadAffiliate upsertSupplierLeadAffiliate, String winkVersion) throws WebClientResponseException {
        return createLeadRequestCreation(companyIdentifier, upsertSupplierLeadAffiliate, winkVersion);
    }
    /**
     * Delete Lead
     * Remove a supplier lead
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>405</b> - Method Not Allowed
     * <p><b>202</b> - Accepted
     * @param companyIdentifier Remove lead owned by this owner identifier.
     * @param leadIdentifier Remove lead record with this identifier.
     * @param winkVersion The winkVersion parameter
     * @return RemoveEntryResponseAffiliate
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec removeLeadRequestCreation(String companyIdentifier, String leadIdentifier, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'companyIdentifier' is set
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling removeLead", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'leadIdentifier' is set
        if (leadIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'leadIdentifier' when calling removeLead", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("companyIdentifier", companyIdentifier);
        pathParams.put("leadIdentifier", leadIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<RemoveEntryResponseAffiliate> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponseAffiliate>() {};
        return apiClient.invokeAPI("/api/company/{companyIdentifier}/lead/{leadIdentifier}", HttpMethod.DELETE, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Delete Lead
     * Remove a supplier lead
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>405</b> - Method Not Allowed
     * <p><b>202</b> - Accepted
     * @param companyIdentifier Remove lead owned by this owner identifier.
     * @param leadIdentifier Remove lead record with this identifier.
     * @param winkVersion The winkVersion parameter
     * @return RemoveEntryResponseAffiliate
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<RemoveEntryResponseAffiliate> removeLead(String companyIdentifier, String leadIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<RemoveEntryResponseAffiliate> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponseAffiliate>() {};
        return removeLeadRequestCreation(companyIdentifier, leadIdentifier, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Delete Lead
     * Remove a supplier lead
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>405</b> - Method Not Allowed
     * <p><b>202</b> - Accepted
     * @param companyIdentifier Remove lead owned by this owner identifier.
     * @param leadIdentifier Remove lead record with this identifier.
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;RemoveEntryResponseAffiliate&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<RemoveEntryResponseAffiliate>> removeLeadWithHttpInfo(String companyIdentifier, String leadIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<RemoveEntryResponseAffiliate> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponseAffiliate>() {};
        return removeLeadRequestCreation(companyIdentifier, leadIdentifier, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Delete Lead
     * Remove a supplier lead
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>405</b> - Method Not Allowed
     * <p><b>202</b> - Accepted
     * @param companyIdentifier Remove lead owned by this owner identifier.
     * @param leadIdentifier Remove lead record with this identifier.
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec removeLeadWithResponseSpec(String companyIdentifier, String leadIdentifier, String winkVersion) throws WebClientResponseException {
        return removeLeadRequestCreation(companyIdentifier, leadIdentifier, winkVersion);
    }
    /**
     * Update lead
     * Updates an existing supplier lead based on information retrieved from Google Places
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>405</b> - Method Not Allowed
     * <p><b>200</b> - OK
     * @param companyIdentifier Create lead by this owner identifier.
     * @param leadIdentifier Create lead by this lead identifier.
     * @param upsertSupplierLeadAffiliate The upsertSupplierLeadAffiliate parameter
     * @param winkVersion The winkVersion parameter
     * @return SupplierLeadAffiliate
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec updateLeadRequestCreation(String companyIdentifier, String leadIdentifier, UpsertSupplierLeadAffiliate upsertSupplierLeadAffiliate, String winkVersion) throws WebClientResponseException {
        Object postBody = upsertSupplierLeadAffiliate;
        // verify the required parameter 'companyIdentifier' is set
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling updateLead", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'leadIdentifier' is set
        if (leadIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'leadIdentifier' when calling updateLead", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'upsertSupplierLeadAffiliate' is set
        if (upsertSupplierLeadAffiliate == null) {
            throw new WebClientResponseException("Missing the required parameter 'upsertSupplierLeadAffiliate' when calling updateLead", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("companyIdentifier", companyIdentifier);
        pathParams.put("leadIdentifier", leadIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<SupplierLeadAffiliate> localVarReturnType = new ParameterizedTypeReference<SupplierLeadAffiliate>() {};
        return apiClient.invokeAPI("/api/company/{companyIdentifier}/lead/{leadIdentifier}", HttpMethod.PUT, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Update lead
     * Updates an existing supplier lead based on information retrieved from Google Places
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>405</b> - Method Not Allowed
     * <p><b>200</b> - OK
     * @param companyIdentifier Create lead by this owner identifier.
     * @param leadIdentifier Create lead by this lead identifier.
     * @param upsertSupplierLeadAffiliate The upsertSupplierLeadAffiliate parameter
     * @param winkVersion The winkVersion parameter
     * @return SupplierLeadAffiliate
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<SupplierLeadAffiliate> updateLead(String companyIdentifier, String leadIdentifier, UpsertSupplierLeadAffiliate upsertSupplierLeadAffiliate, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<SupplierLeadAffiliate> localVarReturnType = new ParameterizedTypeReference<SupplierLeadAffiliate>() {};
        return updateLeadRequestCreation(companyIdentifier, leadIdentifier, upsertSupplierLeadAffiliate, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Update lead
     * Updates an existing supplier lead based on information retrieved from Google Places
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>405</b> - Method Not Allowed
     * <p><b>200</b> - OK
     * @param companyIdentifier Create lead by this owner identifier.
     * @param leadIdentifier Create lead by this lead identifier.
     * @param upsertSupplierLeadAffiliate The upsertSupplierLeadAffiliate parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;SupplierLeadAffiliate&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<SupplierLeadAffiliate>> updateLeadWithHttpInfo(String companyIdentifier, String leadIdentifier, UpsertSupplierLeadAffiliate upsertSupplierLeadAffiliate, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<SupplierLeadAffiliate> localVarReturnType = new ParameterizedTypeReference<SupplierLeadAffiliate>() {};
        return updateLeadRequestCreation(companyIdentifier, leadIdentifier, upsertSupplierLeadAffiliate, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Update lead
     * Updates an existing supplier lead based on information retrieved from Google Places
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>405</b> - Method Not Allowed
     * <p><b>200</b> - OK
     * @param companyIdentifier Create lead by this owner identifier.
     * @param leadIdentifier Create lead by this lead identifier.
     * @param upsertSupplierLeadAffiliate The upsertSupplierLeadAffiliate parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec updateLeadWithResponseSpec(String companyIdentifier, String leadIdentifier, UpsertSupplierLeadAffiliate upsertSupplierLeadAffiliate, String winkVersion) throws WebClientResponseException {
        return updateLeadRequestCreation(companyIdentifier, leadIdentifier, upsertSupplierLeadAffiliate, winkVersion);
    }
}
