/*
 * Wink API
 * ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Affiliate](/affiliate): All APIs related to selling travel inventory as an affiliate. - [Analytics](/analytics): All APIs related to tracking metrics across a wide variety of data source segments including, more entertaining, leaderboard metrics. - [Booking](/booking): All APIs related to creating platform bookings. - [Channel Manager](/channel-manager): All APIs related to channel managers who want to integrate with our platform. - [Extranet](/extranet): All APIs related to managing travel inventory and suppliers. - [Inventory](/inventory): All APIs related to retrieve known travel inventory as it was found using the Lookup API.. - [Lookup](/lookup): All APIs related to locating inventory by region, locale and property flags. - [Reference](/reference): All APIs related to retrieving platform-supported taxonomies. - [TripPay Acquiring](/payment-acquiring): All APIs related to capture payment details such as a Stripe payment intent. - [TripPay](/payment): All APIs related to TripPay account management, booking, mapping and integration features.  ## SDKs We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).  - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)  ## Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Wink-Version` header. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints.  ## Release history - 2022-10-15: v2.0 - Removed HATEOAS and added Wink-Version header - 2022-05-08: v1 - Exposed channel manager API - 2021-07-01: v1 - Initial release  # Affiliate API Welcome to the Affiliate API - A programmer-friendly way to search for and display bespoke travel inventory for your audience. Use this API to help you prepare travel inventory for sale.  # Intended Audience Programmers are a requirement to start integrating with wink. You will benefit from an API integration if you are new or existing travel related company that want easy access to great inventory.## Examples: - Hotel brands / chains that want to make their own booking engine - Travel tech companies that want to create the next hot mobile travel app - Destination sites that want to make their own booking engine - Bloggers and influencers who want to sell travel inventory to their audience - OTAs that want access direct relationships with suppliers and better quality hotel inventory
 *
 * The version of the OpenAPI document: 29.41.0
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.affiliate.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * DowPatternGroupAffiliate
 */
@JsonPropertyOrder({
  DowPatternGroupAffiliate.JSON_PROPERTY_MON,
  DowPatternGroupAffiliate.JSON_PROPERTY_TUE,
  DowPatternGroupAffiliate.JSON_PROPERTY_WED,
  DowPatternGroupAffiliate.JSON_PROPERTY_THU,
  DowPatternGroupAffiliate.JSON_PROPERTY_FRI,
  DowPatternGroupAffiliate.JSON_PROPERTY_SAT,
  DowPatternGroupAffiliate.JSON_PROPERTY_SUN,
  DowPatternGroupAffiliate.JSON_PROPERTY_DISABLED
})
@JsonTypeName("DowPatternGroup_Affiliate")
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-02-23T13:11:09.149753540+07:00[Asia/Bangkok]")
public class DowPatternGroupAffiliate {
  public static final String JSON_PROPERTY_MON = "mon";
  private Boolean mon;

  public static final String JSON_PROPERTY_TUE = "tue";
  private Boolean tue;

  public static final String JSON_PROPERTY_WED = "wed";
  private Boolean wed;

  public static final String JSON_PROPERTY_THU = "thu";
  private Boolean thu;

  public static final String JSON_PROPERTY_FRI = "fri";
  private Boolean fri;

  public static final String JSON_PROPERTY_SAT = "sat";
  private Boolean sat;

  public static final String JSON_PROPERTY_SUN = "sun";
  private Boolean sun;

  public static final String JSON_PROPERTY_DISABLED = "disabled";
  private Boolean disabled;

  public DowPatternGroupAffiliate() {
  }

  public DowPatternGroupAffiliate mon(Boolean mon) {
    
    this.mon = mon;
    return this;
  }

   /**
   * Set to &#x60;true&#x60; to enable Monday.
   * @return mon
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_MON)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getMon() {
    return mon;
  }


  @JsonProperty(JSON_PROPERTY_MON)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMon(Boolean mon) {
    this.mon = mon;
  }


  public DowPatternGroupAffiliate tue(Boolean tue) {
    
    this.tue = tue;
    return this;
  }

   /**
   * Set to &#x60;true&#x60; to enable Tuesday.
   * @return tue
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_TUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getTue() {
    return tue;
  }


  @JsonProperty(JSON_PROPERTY_TUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTue(Boolean tue) {
    this.tue = tue;
  }


  public DowPatternGroupAffiliate wed(Boolean wed) {
    
    this.wed = wed;
    return this;
  }

   /**
   * Set to &#x60;true&#x60; to enable Wednesday.
   * @return wed
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_WED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getWed() {
    return wed;
  }


  @JsonProperty(JSON_PROPERTY_WED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setWed(Boolean wed) {
    this.wed = wed;
  }


  public DowPatternGroupAffiliate thu(Boolean thu) {
    
    this.thu = thu;
    return this;
  }

   /**
   * Set to &#x60;true&#x60; to enable Thursday.
   * @return thu
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_THU)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getThu() {
    return thu;
  }


  @JsonProperty(JSON_PROPERTY_THU)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setThu(Boolean thu) {
    this.thu = thu;
  }


  public DowPatternGroupAffiliate fri(Boolean fri) {
    
    this.fri = fri;
    return this;
  }

   /**
   * Set to &#x60;true&#x60; to enable Friday.
   * @return fri
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_FRI)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getFri() {
    return fri;
  }


  @JsonProperty(JSON_PROPERTY_FRI)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFri(Boolean fri) {
    this.fri = fri;
  }


  public DowPatternGroupAffiliate sat(Boolean sat) {
    
    this.sat = sat;
    return this;
  }

   /**
   * Set to &#x60;true&#x60; to enable Saturday.
   * @return sat
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_SAT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getSat() {
    return sat;
  }


  @JsonProperty(JSON_PROPERTY_SAT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSat(Boolean sat) {
    this.sat = sat;
  }


  public DowPatternGroupAffiliate sun(Boolean sun) {
    
    this.sun = sun;
    return this;
  }

   /**
   * Set to &#x60;true&#x60; to enable Sunday.
   * @return sun
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_SUN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getSun() {
    return sun;
  }


  @JsonProperty(JSON_PROPERTY_SUN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSun(Boolean sun) {
    this.sun = sun;
  }


  public DowPatternGroupAffiliate disabled(Boolean disabled) {
    
    this.disabled = disabled;
    return this;
  }

   /**
   * Convenience property to quickly determine if this existing object has any active days enabled.
   * @return disabled
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_DISABLED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getDisabled() {
    return disabled;
  }


  @JsonProperty(JSON_PROPERTY_DISABLED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDisabled(Boolean disabled) {
    this.disabled = disabled;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    DowPatternGroupAffiliate dowPatternGroupAffiliate = (DowPatternGroupAffiliate) o;
    return Objects.equals(this.mon, dowPatternGroupAffiliate.mon) &&
        Objects.equals(this.tue, dowPatternGroupAffiliate.tue) &&
        Objects.equals(this.wed, dowPatternGroupAffiliate.wed) &&
        Objects.equals(this.thu, dowPatternGroupAffiliate.thu) &&
        Objects.equals(this.fri, dowPatternGroupAffiliate.fri) &&
        Objects.equals(this.sat, dowPatternGroupAffiliate.sat) &&
        Objects.equals(this.sun, dowPatternGroupAffiliate.sun) &&
        Objects.equals(this.disabled, dowPatternGroupAffiliate.disabled);
  }

  @Override
  public int hashCode() {
    return Objects.hash(mon, tue, wed, thu, fri, sat, sun, disabled);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class DowPatternGroupAffiliate {\n");
    sb.append("    mon: ").append(toIndentedString(mon)).append("\n");
    sb.append("    tue: ").append(toIndentedString(tue)).append("\n");
    sb.append("    wed: ").append(toIndentedString(wed)).append("\n");
    sb.append("    thu: ").append(toIndentedString(thu)).append("\n");
    sb.append("    fri: ").append(toIndentedString(fri)).append("\n");
    sb.append("    sat: ").append(toIndentedString(sat)).append("\n");
    sb.append("    sun: ").append(toIndentedString(sun)).append("\n");
    sb.append("    disabled: ").append(toIndentedString(disabled)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

