/*
 * Wink API
 * ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Affiliate](/affiliate): All APIs related to selling travel inventory as an affiliate. - [Analytics](/analytics): All APIs related to tracking metrics across a wide variety of data source segments including, more entertaining, leaderboard metrics. - [Booking](/booking): All APIs related to creating platform bookings. - [Channel Manager](/channel-manager): All APIs related to channel managers who want to integrate with our platform. - [Extranet](/extranet): All APIs related to managing travel inventory and suppliers. - [Inventory](/inventory): All APIs related to retrieve known travel inventory as it was found using the Lookup API.. - [Lookup](/lookup): All APIs related to locating inventory by region, locale and property flags. - [Reference](/reference): All APIs related to retrieving platform-supported taxonomies. - [TripPay Acquiring](/payment-acquiring): All APIs related to capture payment details such as a Stripe payment intent. - [TripPay](/payment): All APIs related to TripPay account management, booking, mapping and integration features.  ## SDKs We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).  - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)  ## Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Wink-Version` header. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints.  ## Release history - 2022-10-15: v2.0 - Removed HATEOAS and added Wink-Version header - 2022-05-08: v1 - Exposed channel manager API - 2021-07-01: v1 - Initial release  # Affiliate API Welcome to the Affiliate API - A programmer-friendly way to search for and display bespoke travel inventory for your audience. Use this API to help you prepare travel inventory for sale.  # Intended Audience Programmers are a requirement to start integrating with wink. You will benefit from an API integration if you are new or existing travel related company that want easy access to great inventory.## Examples: - Hotel brands / chains that want to make their own booking engine - Travel tech companies that want to create the next hot mobile travel app - Destination sites that want to make their own booking engine - Bloggers and influencers who want to sell travel inventory to their audience - OTAs that want access direct relationships with suppliers and better quality hotel inventory
 *
 * The version of the OpenAPI document: 29.41.0
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.affiliate.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.time.OffsetDateTime;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import travel.wink.sdk.affiliate.model.GeoJsonPointAffiliate;
import travel.wink.sdk.affiliate.model.SimpleMultimediaAffiliate;
import travel.wink.sdk.affiliate.model.SupplierLeadAddressAffiliate;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * SupplierLeadAffiliate
 */
@JsonPropertyOrder({
  SupplierLeadAffiliate.JSON_PROPERTY_ID,
  SupplierLeadAffiliate.JSON_PROPERTY_CREATED_DATE,
  SupplierLeadAffiliate.JSON_PROPERTY_LAST_UPDATE,
  SupplierLeadAffiliate.JSON_PROPERTY_VERSION,
  SupplierLeadAffiliate.JSON_PROPERTY_STATUS,
  SupplierLeadAffiliate.JSON_PROPERTY_PLACE_ID,
  SupplierLeadAffiliate.JSON_PROPERTY_NAME,
  SupplierLeadAffiliate.JSON_PROPERTY_GOOGLE_MAPS_URL,
  SupplierLeadAffiliate.JSON_PROPERTY_PHONE,
  SupplierLeadAffiliate.JSON_PROPERTY_FORMATTED_ADDRESS,
  SupplierLeadAffiliate.JSON_PROPERTY_ADDRESS,
  SupplierLeadAffiliate.JSON_PROPERTY_LOCATION,
  SupplierLeadAffiliate.JSON_PROPERTY_PHOTOS,
  SupplierLeadAffiliate.JSON_PROPERTY_RATING,
  SupplierLeadAffiliate.JSON_PROPERTY_USER_RATING_TOTAL,
  SupplierLeadAffiliate.JSON_PROPERTY_UTC_OFFSET_MINUTES,
  SupplierLeadAffiliate.JSON_PROPERTY_WEBSITE,
  SupplierLeadAffiliate.JSON_PROPERTY_MESSAGE_FROM_USER
})
@JsonTypeName("SupplierLead_Affiliate")
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-02-23T13:11:09.149753540+07:00[Asia/Bangkok]")
public class SupplierLeadAffiliate {
  public static final String JSON_PROPERTY_ID = "id";
  private String id;

  public static final String JSON_PROPERTY_CREATED_DATE = "createdDate";
  private java.time.LocalDateTime createdDate;

  public static final String JSON_PROPERTY_LAST_UPDATE = "lastUpdate";
  private java.time.LocalDateTime lastUpdate;

  public static final String JSON_PROPERTY_VERSION = "version";
  private Long version;

  /**
   * Lead status
   */
  public enum StatusEnum {
    CREATED("CREATED"),
    
    IN_PROGRESS("IN_PROGRESS"),
    
    INVITED("INVITED"),
    
    CLAIMED("CLAIMED"),
    
    REJECTED("REJECTED"),
    
    INACTIVE("INACTIVE");

    private String value;

    StatusEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static StatusEnum fromValue(String value) {
      for (StatusEnum b : StatusEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_STATUS = "status";
  private StatusEnum status;

  public static final String JSON_PROPERTY_PLACE_ID = "placeId";
  private String placeId;

  public static final String JSON_PROPERTY_NAME = "name";
  private String name;

  public static final String JSON_PROPERTY_GOOGLE_MAPS_URL = "googleMapsUrl";
  private String googleMapsUrl;

  public static final String JSON_PROPERTY_PHONE = "phone";
  private String phone;

  public static final String JSON_PROPERTY_FORMATTED_ADDRESS = "formattedAddress";
  private String formattedAddress;

  public static final String JSON_PROPERTY_ADDRESS = "address";
  private List<SupplierLeadAddressAffiliate> address;

  public static final String JSON_PROPERTY_LOCATION = "location";
  private GeoJsonPointAffiliate location;

  public static final String JSON_PROPERTY_PHOTOS = "photos";
  private List<SimpleMultimediaAffiliate> photos;

  public static final String JSON_PROPERTY_RATING = "rating";
  private Float rating;

  public static final String JSON_PROPERTY_USER_RATING_TOTAL = "userRatingTotal";
  private Integer userRatingTotal;

  public static final String JSON_PROPERTY_UTC_OFFSET_MINUTES = "utcOffsetMinutes";
  private Integer utcOffsetMinutes;

  public static final String JSON_PROPERTY_WEBSITE = "website";
  private String website;

  public static final String JSON_PROPERTY_MESSAGE_FROM_USER = "messageFromUser";
  private String messageFromUser;

  public SupplierLeadAffiliate() {
  }

  public SupplierLeadAffiliate id(String id) {
    
    this.id = id;
    return this;
  }

   /**
   * Document UUID
   * @return id
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getId() {
    return id;
  }


  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setId(String id) {
    this.id = id;
  }


  public SupplierLeadAffiliate createdDate(java.time.LocalDateTime createdDate) {
    
    this.createdDate = createdDate;
    return this;
  }

   /**
   * Datetime this record was first created
   * @return createdDate
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_CREATED_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public java.time.LocalDateTime getCreatedDate() {
    return createdDate;
  }


  @JsonProperty(JSON_PROPERTY_CREATED_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCreatedDate(java.time.LocalDateTime createdDate) {
    this.createdDate = createdDate;
  }


  public SupplierLeadAffiliate lastUpdate(java.time.LocalDateTime lastUpdate) {
    
    this.lastUpdate = lastUpdate;
    return this;
  }

   /**
   * Datetime this record was last updated
   * @return lastUpdate
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_LAST_UPDATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public java.time.LocalDateTime getLastUpdate() {
    return lastUpdate;
  }


  @JsonProperty(JSON_PROPERTY_LAST_UPDATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLastUpdate(java.time.LocalDateTime lastUpdate) {
    this.lastUpdate = lastUpdate;
  }


  public SupplierLeadAffiliate version(Long version) {
    
    this.version = version;
    return this;
  }

   /**
   * Version property that shows how many times this document has been persisted. Document will not persist if the version property is less than current version property in the system. Result in an optimistic locking exception.
   * @return version
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_VERSION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Long getVersion() {
    return version;
  }


  @JsonProperty(JSON_PROPERTY_VERSION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setVersion(Long version) {
    this.version = version;
  }


  public SupplierLeadAffiliate status(StatusEnum status) {
    
    this.status = status;
    return this;
  }

   /**
   * Lead status
   * @return status
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_STATUS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public StatusEnum getStatus() {
    return status;
  }


  @JsonProperty(JSON_PROPERTY_STATUS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setStatus(StatusEnum status) {
    this.status = status;
  }


  public SupplierLeadAffiliate placeId(String placeId) {
    
    this.placeId = placeId;
    return this;
  }

   /**
   * Unique ID
   * @return placeId
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_PLACE_ID)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getPlaceId() {
    return placeId;
  }


  @JsonProperty(JSON_PROPERTY_PLACE_ID)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setPlaceId(String placeId) {
    this.placeId = placeId;
  }


  public SupplierLeadAffiliate name(String name) {
    
    this.name = name;
    return this;
  }

   /**
   * Name of lead
   * @return name
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getName() {
    return name;
  }


  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setName(String name) {
    this.name = name;
  }


  public SupplierLeadAffiliate googleMapsUrl(String googleMapsUrl) {
    
    this.googleMapsUrl = googleMapsUrl;
    return this;
  }

   /**
   * Google Maps URL of the place
   * @return googleMapsUrl
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_GOOGLE_MAPS_URL)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getGoogleMapsUrl() {
    return googleMapsUrl;
  }


  @JsonProperty(JSON_PROPERTY_GOOGLE_MAPS_URL)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setGoogleMapsUrl(String googleMapsUrl) {
    this.googleMapsUrl = googleMapsUrl;
  }


  public SupplierLeadAffiliate phone(String phone) {
    
    this.phone = phone;
    return this;
  }

   /**
   * Telephone of lead
   * @return phone
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_PHONE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getPhone() {
    return phone;
  }


  @JsonProperty(JSON_PROPERTY_PHONE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPhone(String phone) {
    this.phone = phone;
  }


  public SupplierLeadAffiliate formattedAddress(String formattedAddress) {
    
    this.formattedAddress = formattedAddress;
    return this;
  }

   /**
   * Display address
   * @return formattedAddress
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_FORMATTED_ADDRESS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getFormattedAddress() {
    return formattedAddress;
  }


  @JsonProperty(JSON_PROPERTY_FORMATTED_ADDRESS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFormattedAddress(String formattedAddress) {
    this.formattedAddress = formattedAddress;
  }


  public SupplierLeadAffiliate address(List<SupplierLeadAddressAffiliate> address) {
    
    this.address = address;
    return this;
  }

  public SupplierLeadAffiliate addAddressItem(SupplierLeadAddressAffiliate addressItem) {
    if (this.address == null) {
      this.address = new ArrayList<>();
    }
    this.address.add(addressItem);
    return this;
  }

   /**
   * Address components
   * @return address
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_ADDRESS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<SupplierLeadAddressAffiliate> getAddress() {
    return address;
  }


  @JsonProperty(JSON_PROPERTY_ADDRESS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAddress(List<SupplierLeadAddressAffiliate> address) {
    this.address = address;
  }


  public SupplierLeadAffiliate location(GeoJsonPointAffiliate location) {
    
    this.location = location;
    return this;
  }

   /**
   * Get location
   * @return location
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_LOCATION)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public GeoJsonPointAffiliate getLocation() {
    return location;
  }


  @JsonProperty(JSON_PROPERTY_LOCATION)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setLocation(GeoJsonPointAffiliate location) {
    this.location = location;
  }


  public SupplierLeadAffiliate photos(List<SimpleMultimediaAffiliate> photos) {
    
    this.photos = photos;
    return this;
  }

  public SupplierLeadAffiliate addPhotosItem(SimpleMultimediaAffiliate photosItem) {
    if (this.photos == null) {
      this.photos = new ArrayList<>();
    }
    this.photos.add(photosItem);
    return this;
  }

   /**
   * Photos for property
   * @return photos
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_PHOTOS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<SimpleMultimediaAffiliate> getPhotos() {
    return photos;
  }


  @JsonProperty(JSON_PROPERTY_PHOTOS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPhotos(List<SimpleMultimediaAffiliate> photos) {
    this.photos = photos;
  }


  public SupplierLeadAffiliate rating(Float rating) {
    
    this.rating = rating;
    return this;
  }

   /**
   * Hotel rating
   * @return rating
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_RATING)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Float getRating() {
    return rating;
  }


  @JsonProperty(JSON_PROPERTY_RATING)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRating(Float rating) {
    this.rating = rating;
  }


  public SupplierLeadAffiliate userRatingTotal(Integer userRatingTotal) {
    
    this.userRatingTotal = userRatingTotal;
    return this;
  }

   /**
   * Total umber of user ratings
   * @return userRatingTotal
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_USER_RATING_TOTAL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getUserRatingTotal() {
    return userRatingTotal;
  }


  @JsonProperty(JSON_PROPERTY_USER_RATING_TOTAL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setUserRatingTotal(Integer userRatingTotal) {
    this.userRatingTotal = userRatingTotal;
  }


  public SupplierLeadAffiliate utcOffsetMinutes(Integer utcOffsetMinutes) {
    
    this.utcOffsetMinutes = utcOffsetMinutes;
    return this;
  }

   /**
   * UTC offset minutes
   * @return utcOffsetMinutes
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_UTC_OFFSET_MINUTES)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Integer getUtcOffsetMinutes() {
    return utcOffsetMinutes;
  }


  @JsonProperty(JSON_PROPERTY_UTC_OFFSET_MINUTES)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setUtcOffsetMinutes(Integer utcOffsetMinutes) {
    this.utcOffsetMinutes = utcOffsetMinutes;
  }


  public SupplierLeadAffiliate website(String website) {
    
    this.website = website;
    return this;
  }

   /**
   * Website
   * @return website
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_WEBSITE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getWebsite() {
    return website;
  }


  @JsonProperty(JSON_PROPERTY_WEBSITE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setWebsite(String website) {
    this.website = website;
  }


  public SupplierLeadAffiliate messageFromUser(String messageFromUser) {
    
    this.messageFromUser = messageFromUser;
    return this;
  }

   /**
   * A personalized message from the inviter
   * @return messageFromUser
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_MESSAGE_FROM_USER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getMessageFromUser() {
    return messageFromUser;
  }


  @JsonProperty(JSON_PROPERTY_MESSAGE_FROM_USER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMessageFromUser(String messageFromUser) {
    this.messageFromUser = messageFromUser;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    SupplierLeadAffiliate supplierLeadAffiliate = (SupplierLeadAffiliate) o;
    return Objects.equals(this.id, supplierLeadAffiliate.id) &&
        Objects.equals(this.createdDate, supplierLeadAffiliate.createdDate) &&
        Objects.equals(this.lastUpdate, supplierLeadAffiliate.lastUpdate) &&
        Objects.equals(this.version, supplierLeadAffiliate.version) &&
        Objects.equals(this.status, supplierLeadAffiliate.status) &&
        Objects.equals(this.placeId, supplierLeadAffiliate.placeId) &&
        Objects.equals(this.name, supplierLeadAffiliate.name) &&
        Objects.equals(this.googleMapsUrl, supplierLeadAffiliate.googleMapsUrl) &&
        Objects.equals(this.phone, supplierLeadAffiliate.phone) &&
        Objects.equals(this.formattedAddress, supplierLeadAffiliate.formattedAddress) &&
        Objects.equals(this.address, supplierLeadAffiliate.address) &&
        Objects.equals(this.location, supplierLeadAffiliate.location) &&
        Objects.equals(this.photos, supplierLeadAffiliate.photos) &&
        Objects.equals(this.rating, supplierLeadAffiliate.rating) &&
        Objects.equals(this.userRatingTotal, supplierLeadAffiliate.userRatingTotal) &&
        Objects.equals(this.utcOffsetMinutes, supplierLeadAffiliate.utcOffsetMinutes) &&
        Objects.equals(this.website, supplierLeadAffiliate.website) &&
        Objects.equals(this.messageFromUser, supplierLeadAffiliate.messageFromUser);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, createdDate, lastUpdate, version, status, placeId, name, googleMapsUrl, phone, formattedAddress, address, location, photos, rating, userRatingTotal, utcOffsetMinutes, website, messageFromUser);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class SupplierLeadAffiliate {\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    createdDate: ").append(toIndentedString(createdDate)).append("\n");
    sb.append("    lastUpdate: ").append(toIndentedString(lastUpdate)).append("\n");
    sb.append("    version: ").append(toIndentedString(version)).append("\n");
    sb.append("    status: ").append(toIndentedString(status)).append("\n");
    sb.append("    placeId: ").append(toIndentedString(placeId)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    googleMapsUrl: ").append(toIndentedString(googleMapsUrl)).append("\n");
    sb.append("    phone: ").append(toIndentedString(phone)).append("\n");
    sb.append("    formattedAddress: ").append(toIndentedString(formattedAddress)).append("\n");
    sb.append("    address: ").append(toIndentedString(address)).append("\n");
    sb.append("    location: ").append(toIndentedString(location)).append("\n");
    sb.append("    photos: ").append(toIndentedString(photos)).append("\n");
    sb.append("    rating: ").append(toIndentedString(rating)).append("\n");
    sb.append("    userRatingTotal: ").append(toIndentedString(userRatingTotal)).append("\n");
    sb.append("    utcOffsetMinutes: ").append(toIndentedString(utcOffsetMinutes)).append("\n");
    sb.append("    website: ").append(toIndentedString(website)).append("\n");
    sb.append("    messageFromUser: ").append(toIndentedString(messageFromUser)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

