/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.affiliate.api;

import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import reactor.core.publisher.Mono;
import travel.wink.sdk.affiliate.invoker.ApiClient;
import travel.wink.sdk.affiliate.model.RemoveEntryResponseAffiliate;
import travel.wink.sdk.affiliate.model.SupplierLeadAffiliate;
import travel.wink.sdk.affiliate.model.UpsertSupplierLeadAffiliate;

public class LeadApi {
    private ApiClient apiClient;

    public LeadApi() {
        this(new ApiClient());
    }

    @Autowired
    public LeadApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    private WebClient.ResponseSpec createLeadRequestCreation(String companyIdentifier, UpsertSupplierLeadAffiliate upsertSupplierLeadAffiliate, String winkVersion) throws WebClientResponseException {
        UpsertSupplierLeadAffiliate postBody = upsertSupplierLeadAffiliate;
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling createLead", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (upsertSupplierLeadAffiliate == null) {
            throw new WebClientResponseException("Missing the required parameter 'upsertSupplierLeadAffiliate' when calling createLead", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("companyIdentifier", companyIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<SupplierLeadAffiliate> localVarReturnType = new ParameterizedTypeReference<SupplierLeadAffiliate>(this){};
        return this.apiClient.invokeAPI("/api/company/{companyIdentifier}/lead", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<SupplierLeadAffiliate> createLead(String companyIdentifier, UpsertSupplierLeadAffiliate upsertSupplierLeadAffiliate, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<SupplierLeadAffiliate> localVarReturnType = new ParameterizedTypeReference<SupplierLeadAffiliate>(this){};
        return this.createLeadRequestCreation(companyIdentifier, upsertSupplierLeadAffiliate, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<SupplierLeadAffiliate>> createLeadWithHttpInfo(String companyIdentifier, UpsertSupplierLeadAffiliate upsertSupplierLeadAffiliate, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<SupplierLeadAffiliate> localVarReturnType = new ParameterizedTypeReference<SupplierLeadAffiliate>(this){};
        return this.createLeadRequestCreation(companyIdentifier, upsertSupplierLeadAffiliate, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec createLeadWithResponseSpec(String companyIdentifier, UpsertSupplierLeadAffiliate upsertSupplierLeadAffiliate, String winkVersion) throws WebClientResponseException {
        return this.createLeadRequestCreation(companyIdentifier, upsertSupplierLeadAffiliate, winkVersion);
    }

    private WebClient.ResponseSpec removeLeadRequestCreation(String companyIdentifier, String leadIdentifier, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling removeLead", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (leadIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'leadIdentifier' when calling removeLead", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("companyIdentifier", companyIdentifier);
        pathParams.put("leadIdentifier", leadIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<RemoveEntryResponseAffiliate> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponseAffiliate>(this){};
        return this.apiClient.invokeAPI("/api/company/{companyIdentifier}/lead/{leadIdentifier}", HttpMethod.DELETE, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<RemoveEntryResponseAffiliate> removeLead(String companyIdentifier, String leadIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<RemoveEntryResponseAffiliate> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponseAffiliate>(this){};
        return this.removeLeadRequestCreation(companyIdentifier, leadIdentifier, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<RemoveEntryResponseAffiliate>> removeLeadWithHttpInfo(String companyIdentifier, String leadIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<RemoveEntryResponseAffiliate> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponseAffiliate>(this){};
        return this.removeLeadRequestCreation(companyIdentifier, leadIdentifier, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec removeLeadWithResponseSpec(String companyIdentifier, String leadIdentifier, String winkVersion) throws WebClientResponseException {
        return this.removeLeadRequestCreation(companyIdentifier, leadIdentifier, winkVersion);
    }

    private WebClient.ResponseSpec updateLeadRequestCreation(String companyIdentifier, String leadIdentifier, UpsertSupplierLeadAffiliate upsertSupplierLeadAffiliate, String winkVersion) throws WebClientResponseException {
        UpsertSupplierLeadAffiliate postBody = upsertSupplierLeadAffiliate;
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling updateLead", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (leadIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'leadIdentifier' when calling updateLead", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (upsertSupplierLeadAffiliate == null) {
            throw new WebClientResponseException("Missing the required parameter 'upsertSupplierLeadAffiliate' when calling updateLead", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("companyIdentifier", companyIdentifier);
        pathParams.put("leadIdentifier", leadIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<SupplierLeadAffiliate> localVarReturnType = new ParameterizedTypeReference<SupplierLeadAffiliate>(this){};
        return this.apiClient.invokeAPI("/api/company/{companyIdentifier}/lead/{leadIdentifier}", HttpMethod.PUT, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<SupplierLeadAffiliate> updateLead(String companyIdentifier, String leadIdentifier, UpsertSupplierLeadAffiliate upsertSupplierLeadAffiliate, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<SupplierLeadAffiliate> localVarReturnType = new ParameterizedTypeReference<SupplierLeadAffiliate>(this){};
        return this.updateLeadRequestCreation(companyIdentifier, leadIdentifier, upsertSupplierLeadAffiliate, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<SupplierLeadAffiliate>> updateLeadWithHttpInfo(String companyIdentifier, String leadIdentifier, UpsertSupplierLeadAffiliate upsertSupplierLeadAffiliate, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<SupplierLeadAffiliate> localVarReturnType = new ParameterizedTypeReference<SupplierLeadAffiliate>(this){};
        return this.updateLeadRequestCreation(companyIdentifier, leadIdentifier, upsertSupplierLeadAffiliate, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec updateLeadWithResponseSpec(String companyIdentifier, String leadIdentifier, UpsertSupplierLeadAffiliate upsertSupplierLeadAffiliate, String winkVersion) throws WebClientResponseException {
        return this.updateLeadRequestCreation(companyIdentifier, leadIdentifier, upsertSupplierLeadAffiliate, winkVersion);
    }
}

