/*
 * Wink API
 * ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Affiliate](/affiliate): All APIs related to selling travel inventory as an affiliate. - [Analytics](/analytics): All APIs related to tracking metrics across a wide variety of data source segments including, more entertaining, leaderboard metrics. - [Booking](/booking): All APIs related to creating platform bookings. - [Channel Manager](/channel-manager): All APIs related to channel managers who want to integrate with our platform. - [Extranet](/extranet): All APIs related to managing travel inventory and suppliers. - [Inventory](/inventory): All APIs related to retrieve known travel inventory as it was found using the Lookup API.. - [Lookup](/lookup): All APIs related to locating inventory by region, locale and property flags. - [Reference](/reference): All APIs related to retrieving platform-supported taxonomies. - [TripPay Acquiring](/payment-acquiring): All APIs related to capture payment details such as a Stripe payment intent. - [TripPay](/payment): All APIs related to TripPay account management, booking, mapping and integration features.  ## SDKs We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).  - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)  ## Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Wink-Version` header. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints.  ## Release history - 2022-10-15: v2.0 - Removed HATEOAS and added Wink-Version header - 2022-05-08: v1 - Exposed channel manager API - 2021-07-01: v1 - Initial release  # Affiliate API Welcome to the Affiliate API - A programmer-friendly way to search for and display bespoke travel inventory for your audience. Use this API to help you prepare travel inventory for sale.  # Intended Audience Programmers are a requirement to start integrating with wink. You will benefit from an API integration if you are new or existing travel related company that want easy access to great inventory.## Examples: - Hotel brands / chains that want to make their own booking engine - Travel tech companies that want to create the next hot mobile travel app - Destination sites that want to make their own booking engine - Bloggers and influencers who want to sell travel inventory to their audience - OTAs that want access direct relationships with suppliers and better quality hotel inventory
 *
 * The version of the OpenAPI document: 29.42.12
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.affiliate.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * Address
 */
@JsonPropertyOrder({
  SupplierLeadAddressAffiliate.JSON_PROPERTY_LONG_NAME,
  SupplierLeadAddressAffiliate.JSON_PROPERTY_SHORT_NAME,
  SupplierLeadAddressAffiliate.JSON_PROPERTY_TYPES
})
@JsonTypeName("SupplierLeadAddress_Affiliate")
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-03-08T10:43:28.131207073+07:00[Asia/Bangkok]")
public class SupplierLeadAddressAffiliate {
  public static final String JSON_PROPERTY_LONG_NAME = "longName";
  private String longName;

  public static final String JSON_PROPERTY_SHORT_NAME = "shortName";
  private String shortName;

  /**
   * City name
   */
  public enum TypesEnum {
    STREET_ADDRESS("street_address"),
    
    ROUTE("route"),
    
    INTERSECTION("intersection"),
    
    POLITICAL("political"),
    
    COUNTRY("country"),
    
    ADMINISTRATIVE_AREA_LEVEL_1("administrative_area_level_1"),
    
    ADMINISTRATIVE_AREA_LEVEL_2("administrative_area_level_2"),
    
    ADMINISTRATIVE_AREA_LEVEL_3("administrative_area_level_3"),
    
    ADMINISTRATIVE_AREA_LEVEL_4("administrative_area_level_4"),
    
    ADMINISTRATIVE_AREA_LEVEL_5("administrative_area_level_5"),
    
    ADMINISTRATIVE_AREA_LEVEL_6("administrative_area_level_6"),
    
    ADMINISTRATIVE_AREA_LEVEL_7("administrative_area_level_7"),
    
    COLLOQUIAL_AREA("colloquial_area"),
    
    LOCALITY("locality"),
    
    SUBLOCALITY("sublocality"),
    
    SUBLOCALITY_LEVEL_1("sublocality_level_1"),
    
    SUBLOCALITY_LEVEL_2("sublocality_level_2"),
    
    SUBLOCALITY_LEVEL_3("sublocality_level_3"),
    
    SUBLOCALITY_LEVEL_4("sublocality_level_4"),
    
    SUBLOCALITY_LEVEL_5("sublocality_level_5"),
    
    NEIGHBORHOOD("neighborhood"),
    
    PREMISE("premise"),
    
    SUBPREMISE("subpremise"),
    
    PLUS_CODE("plus_code"),
    
    POSTAL_CODE("postal_code"),
    
    NATURAL_FEATURE("natural_feature"),
    
    AIRPORT("airport"),
    
    PARK("park"),
    
    POINT_OF_INTEREST("point_of_interest"),
    
    FLOOR("floor"),
    
    ESTABLISHMENT("establishment"),
    
    LANDMARK("landmark"),
    
    PARKING("parking"),
    
    POST_BOX("post_box"),
    
    POSTAL_TOWN("postal_town"),
    
    ROOM("room"),
    
    STREET_NUMBER("street_number"),
    
    BUS_STATION("bus_station"),
    
    TRAIN_STATION("train_station"),
    
    TRANSIT_STATION("transit_station");

    private String value;

    TypesEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static TypesEnum fromValue(String value) {
      for (TypesEnum b : TypesEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_TYPES = "types";
  private List<TypesEnum> types = new ArrayList<>();

  public SupplierLeadAddressAffiliate() {
  }

  public SupplierLeadAddressAffiliate longName(String longName) {
    
    this.longName = longName;
    return this;
  }

   /**
   * Long name
   * @return longName
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_LONG_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getLongName() {
    return longName;
  }


  @JsonProperty(JSON_PROPERTY_LONG_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLongName(String longName) {
    this.longName = longName;
  }


  public SupplierLeadAddressAffiliate shortName(String shortName) {
    
    this.shortName = shortName;
    return this;
  }

   /**
   * Short name
   * @return shortName
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_SHORT_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getShortName() {
    return shortName;
  }


  @JsonProperty(JSON_PROPERTY_SHORT_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setShortName(String shortName) {
    this.shortName = shortName;
  }


  public SupplierLeadAddressAffiliate types(List<TypesEnum> types) {
    
    this.types = types;
    return this;
  }

  public SupplierLeadAddressAffiliate addTypesItem(TypesEnum typesItem) {
    if (this.types == null) {
      this.types = new ArrayList<>();
    }
    this.types.add(typesItem);
    return this;
  }

   /**
   * City name
   * @return types
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_TYPES)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public List<TypesEnum> getTypes() {
    return types;
  }


  @JsonProperty(JSON_PROPERTY_TYPES)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setTypes(List<TypesEnum> types) {
    this.types = types;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    SupplierLeadAddressAffiliate supplierLeadAddressAffiliate = (SupplierLeadAddressAffiliate) o;
    return Objects.equals(this.longName, supplierLeadAddressAffiliate.longName) &&
        Objects.equals(this.shortName, supplierLeadAddressAffiliate.shortName) &&
        Objects.equals(this.types, supplierLeadAddressAffiliate.types);
  }

  @Override
  public int hashCode() {
    return Objects.hash(longName, shortName, types);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class SupplierLeadAddressAffiliate {\n");
    sb.append("    longName: ").append(toIndentedString(longName)).append("\n");
    sb.append("    shortName: ").append(toIndentedString(shortName)).append("\n");
    sb.append("    types: ").append(toIndentedString(types)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

