/*
 * Wink API
 * ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Affiliate](/affiliate): All APIs related to selling travel inventory as an affiliate. - [Analytics](/analytics): All APIs related to tracking metrics across a wide variety of data source segments including, more entertaining, leaderboard metrics. - [Booking](/booking): All APIs related to creating platform bookings. - [Channel Manager](/channel-manager): All APIs related to channel managers who want to integrate with our platform. - [Extranet](/extranet): All APIs related to managing travel inventory and suppliers. - [Inventory](/inventory): All APIs related to retrieve known travel inventory as it was found using the Lookup API.. - [Lookup](/lookup): All APIs related to locating inventory by region, locale and property flags. - [Reference](/reference): All APIs related to retrieving platform-supported taxonomies. - [TripPay Acquiring](/payment-acquiring): All APIs related to capture payment details such as a Stripe payment intent. - [TripPay](/payment): All APIs related to TripPay account management, booking, mapping and integration features.  ## SDKs We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).  - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)  ## Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Wink-Version` header. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints.  ## Release history - 2022-10-15: v2.0 - Removed HATEOAS and added Wink-Version header - 2022-05-08: v1 - Exposed channel manager API - 2021-07-01: v1 - Initial release  # Affiliate API Welcome to the Affiliate API - A programmer-friendly way to search for and display bespoke travel inventory for your audience. Use this API to help you prepare travel inventory for sale.  # Intended Audience Programmers are a requirement to start integrating with wink. You will benefit from an API integration if you are new or existing travel related company that want easy access to great inventory.## Examples: - Hotel brands / chains that want to make their own booking engine - Travel tech companies that want to create the next hot mobile travel app - Destination sites that want to make their own booking engine - Bloggers and influencers who want to sell travel inventory to their audience - OTAs that want access direct relationships with suppliers and better quality hotel inventory
 *
 * The version of the OpenAPI document: 29.42.12
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.affiliate.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import travel.wink.sdk.affiliate.model.SimpleDescriptionAffiliate;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * UpsertSellerInventoryListRequestAffiliate
 */
@JsonPropertyOrder({
  UpsertSellerInventoryListRequestAffiliate.JSON_PROPERTY_SELLER_INVENTORY_LIST_NAME,
  UpsertSellerInventoryListRequestAffiliate.JSON_PROPERTY_ENGINE_CONFIGURATION_IDENTIFIER,
  UpsertSellerInventoryListRequestAffiliate.JSON_PROPERTY_DESCRIPTIONS,
  UpsertSellerInventoryListRequestAffiliate.JSON_PROPERTY_KEYWORDS,
  UpsertSellerInventoryListRequestAffiliate.JSON_PROPERTY_LIST_TYPE,
  UpsertSellerInventoryListRequestAffiliate.JSON_PROPERTY_LIST_IDENTIFIER,
  UpsertSellerInventoryListRequestAffiliate.JSON_PROPERTY_ANIMATE,
  UpsertSellerInventoryListRequestAffiliate.JSON_PROPERTY_ANIMATE_DELAY,
  UpsertSellerInventoryListRequestAffiliate.JSON_PROPERTY_SORT,
  UpsertSellerInventoryListRequestAffiliate.JSON_PROPERTY_DISPLAY_TYPE
})
@JsonTypeName("UpsertSellerInventoryListRequest_Affiliate")
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-03-08T10:43:28.131207073+07:00[Asia/Bangkok]")
public class UpsertSellerInventoryListRequestAffiliate {
  public static final String JSON_PROPERTY_SELLER_INVENTORY_LIST_NAME = "sellerInventoryListName";
  private String sellerInventoryListName;

  public static final String JSON_PROPERTY_ENGINE_CONFIGURATION_IDENTIFIER = "engineConfigurationIdentifier";
  private UUID engineConfigurationIdentifier;

  public static final String JSON_PROPERTY_DESCRIPTIONS = "descriptions";
  private List<SimpleDescriptionAffiliate> descriptions = new ArrayList<>();

  public static final String JSON_PROPERTY_KEYWORDS = "keywords";
  private List<String> keywords = new ArrayList<>();

  /**
   * List type
   */
  public enum ListTypeEnum {
    SINGLE("SINGLE"),
    
    LIST("LIST"),
    
    SEARCH("SEARCH");

    private String value;

    ListTypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static ListTypeEnum fromValue(String value) {
      for (ListTypeEnum b : ListTypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_LIST_TYPE = "listType";
  private ListTypeEnum listType;

  public static final String JSON_PROPERTY_LIST_IDENTIFIER = "listIdentifier";
  private UUID listIdentifier;

  public static final String JSON_PROPERTY_ANIMATE = "animate";
  private Boolean animate = false;

  public static final String JSON_PROPERTY_ANIMATE_DELAY = "animateDelay";
  private Integer animateDelay = -1;

  /**
   * Determines which badge to show on the Web Component. Is also used to sort properties for search grids.
   */
  public enum SortEnum {
    MEMBER("MEMBER"),
    
    PRICE_LOW_TO_HIGH("PRICE_LOW_TO_HIGH"),
    
    PRICE_HIGH_TO_LOW("PRICE_HIGH_TO_LOW"),
    
    PRICE("PRICE"),
    
    POPULARITY("POPULARITY"),
    
    ECO("ECO"),
    
    EXPERIENCE("EXPERIENCE"),
    
    PERK("PERK"),
    
    LOYALTY("LOYALTY"),
    
    PACKAGE("PACKAGE");

    private String value;

    SortEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static SortEnum fromValue(String value) {
      for (SortEnum b : SortEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_SORT = "sort";
  private SortEnum sort;

  /**
   * Indicate which initial values to display first on the front-facing card
   */
  public enum DisplayTypeEnum {
    NATIVE("NATIVE"),
    
    HOTEL("HOTEL"),
    
    ROOM("ROOM");

    private String value;

    DisplayTypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static DisplayTypeEnum fromValue(String value) {
      for (DisplayTypeEnum b : DisplayTypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_DISPLAY_TYPE = "displayType";
  private DisplayTypeEnum displayType = DisplayTypeEnum.NATIVE;

  public UpsertSellerInventoryListRequestAffiliate() {
  }

  public UpsertSellerInventoryListRequestAffiliate sellerInventoryListName(String sellerInventoryListName) {
    
    this.sellerInventoryListName = sellerInventoryListName;
    return this;
  }

   /**
   * Descriptive name of this list for seller use only
   * @return sellerInventoryListName
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_SELLER_INVENTORY_LIST_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getSellerInventoryListName() {
    return sellerInventoryListName;
  }


  @JsonProperty(JSON_PROPERTY_SELLER_INVENTORY_LIST_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setSellerInventoryListName(String sellerInventoryListName) {
    this.sellerInventoryListName = sellerInventoryListName;
  }


  public UpsertSellerInventoryListRequestAffiliate engineConfigurationIdentifier(UUID engineConfigurationIdentifier) {
    
    this.engineConfigurationIdentifier = engineConfigurationIdentifier;
    return this;
  }

   /**
   * Customization identifier
   * @return engineConfigurationIdentifier
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_ENGINE_CONFIGURATION_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public UUID getEngineConfigurationIdentifier() {
    return engineConfigurationIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_ENGINE_CONFIGURATION_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setEngineConfigurationIdentifier(UUID engineConfigurationIdentifier) {
    this.engineConfigurationIdentifier = engineConfigurationIdentifier;
  }


  public UpsertSellerInventoryListRequestAffiliate descriptions(List<SimpleDescriptionAffiliate> descriptions) {
    
    this.descriptions = descriptions;
    return this;
  }

  public UpsertSellerInventoryListRequestAffiliate addDescriptionsItem(SimpleDescriptionAffiliate descriptionsItem) {
    if (this.descriptions == null) {
      this.descriptions = new ArrayList<>();
    }
    this.descriptions.add(descriptionsItem);
    return this;
  }

   /**
   * Contains custom title and description of grid
   * @return descriptions
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid
 @Size(min=1,max=2147483647)
  @JsonProperty(JSON_PROPERTY_DESCRIPTIONS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public List<SimpleDescriptionAffiliate> getDescriptions() {
    return descriptions;
  }


  @JsonProperty(JSON_PROPERTY_DESCRIPTIONS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setDescriptions(List<SimpleDescriptionAffiliate> descriptions) {
    this.descriptions = descriptions;
  }


  public UpsertSellerInventoryListRequestAffiliate keywords(List<String> keywords) {
    
    this.keywords = keywords;
    return this;
  }

  public UpsertSellerInventoryListRequestAffiliate addKeywordsItem(String keywordsItem) {
    if (this.keywords == null) {
      this.keywords = new ArrayList<>();
    }
    this.keywords.add(keywordsItem);
    return this;
  }

   /**
   * Keywords is meta data for the grid you created that can be used for SEO purposes.
   * @return keywords
  **/
  @jakarta.annotation.Nonnull
  @NotNull
 @Size(min=1,max=2147483647)
  @JsonProperty(JSON_PROPERTY_KEYWORDS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public List<String> getKeywords() {
    return keywords;
  }


  @JsonProperty(JSON_PROPERTY_KEYWORDS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setKeywords(List<String> keywords) {
    this.keywords = keywords;
  }


  public UpsertSellerInventoryListRequestAffiliate listType(ListTypeEnum listType) {
    
    this.listType = listType;
    return this;
  }

   /**
   * List type
   * @return listType
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_LIST_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public ListTypeEnum getListType() {
    return listType;
  }


  @JsonProperty(JSON_PROPERTY_LIST_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setListType(ListTypeEnum listType) {
    this.listType = listType;
  }


  public UpsertSellerInventoryListRequestAffiliate listIdentifier(UUID listIdentifier) {
    
    this.listIdentifier = listIdentifier;
    return this;
  }

   /**
   * Depending on the &#x60;listType&#x60;, this is either the list / search / channel inventory identifier.
   * @return listIdentifier
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_LIST_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public UUID getListIdentifier() {
    return listIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_LIST_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setListIdentifier(UUID listIdentifier) {
    this.listIdentifier = listIdentifier;
  }


  public UpsertSellerInventoryListRequestAffiliate animate(Boolean animate) {
    
    this.animate = animate;
    return this;
  }

   /**
   * Create an animated gif instead of a list of images
   * @return animate
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_ANIMATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getAnimate() {
    return animate;
  }


  @JsonProperty(JSON_PROPERTY_ANIMATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAnimate(Boolean animate) {
    this.animate = animate;
  }


  public UpsertSellerInventoryListRequestAffiliate animateDelay(Integer animateDelay) {
    
    this.animateDelay = animateDelay;
    return this;
  }

   /**
   * Controls animation delay in milliseconds. -1 is disabled
   * @return animateDelay
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_ANIMATE_DELAY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getAnimateDelay() {
    return animateDelay;
  }


  @JsonProperty(JSON_PROPERTY_ANIMATE_DELAY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAnimateDelay(Integer animateDelay) {
    this.animateDelay = animateDelay;
  }


  public UpsertSellerInventoryListRequestAffiliate sort(SortEnum sort) {
    
    this.sort = sort;
    return this;
  }

   /**
   * Determines which badge to show on the Web Component. Is also used to sort properties for search grids.
   * @return sort
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_SORT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public SortEnum getSort() {
    return sort;
  }


  @JsonProperty(JSON_PROPERTY_SORT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSort(SortEnum sort) {
    this.sort = sort;
  }


  public UpsertSellerInventoryListRequestAffiliate displayType(DisplayTypeEnum displayType) {
    
    this.displayType = displayType;
    return this;
  }

   /**
   * Indicate which initial values to display first on the front-facing card
   * @return displayType
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_DISPLAY_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public DisplayTypeEnum getDisplayType() {
    return displayType;
  }


  @JsonProperty(JSON_PROPERTY_DISPLAY_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setDisplayType(DisplayTypeEnum displayType) {
    this.displayType = displayType;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    UpsertSellerInventoryListRequestAffiliate upsertSellerInventoryListRequestAffiliate = (UpsertSellerInventoryListRequestAffiliate) o;
    return Objects.equals(this.sellerInventoryListName, upsertSellerInventoryListRequestAffiliate.sellerInventoryListName) &&
        Objects.equals(this.engineConfigurationIdentifier, upsertSellerInventoryListRequestAffiliate.engineConfigurationIdentifier) &&
        Objects.equals(this.descriptions, upsertSellerInventoryListRequestAffiliate.descriptions) &&
        Objects.equals(this.keywords, upsertSellerInventoryListRequestAffiliate.keywords) &&
        Objects.equals(this.listType, upsertSellerInventoryListRequestAffiliate.listType) &&
        Objects.equals(this.listIdentifier, upsertSellerInventoryListRequestAffiliate.listIdentifier) &&
        Objects.equals(this.animate, upsertSellerInventoryListRequestAffiliate.animate) &&
        Objects.equals(this.animateDelay, upsertSellerInventoryListRequestAffiliate.animateDelay) &&
        Objects.equals(this.sort, upsertSellerInventoryListRequestAffiliate.sort) &&
        Objects.equals(this.displayType, upsertSellerInventoryListRequestAffiliate.displayType);
  }

  @Override
  public int hashCode() {
    return Objects.hash(sellerInventoryListName, engineConfigurationIdentifier, descriptions, keywords, listType, listIdentifier, animate, animateDelay, sort, displayType);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class UpsertSellerInventoryListRequestAffiliate {\n");
    sb.append("    sellerInventoryListName: ").append(toIndentedString(sellerInventoryListName)).append("\n");
    sb.append("    engineConfigurationIdentifier: ").append(toIndentedString(engineConfigurationIdentifier)).append("\n");
    sb.append("    descriptions: ").append(toIndentedString(descriptions)).append("\n");
    sb.append("    keywords: ").append(toIndentedString(keywords)).append("\n");
    sb.append("    listType: ").append(toIndentedString(listType)).append("\n");
    sb.append("    listIdentifier: ").append(toIndentedString(listIdentifier)).append("\n");
    sb.append("    animate: ").append(toIndentedString(animate)).append("\n");
    sb.append("    animateDelay: ").append(toIndentedString(animateDelay)).append("\n");
    sb.append("    sort: ").append(toIndentedString(sort)).append("\n");
    sb.append("    displayType: ").append(toIndentedString(displayType)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

