/*
 * Wink API
 * ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Affiliate](/affiliate): All APIs related to selling travel inventory as an affiliate. - [Analytics](/analytics): All APIs related to tracking metrics across a wide variety of data source segments including, more entertaining, leaderboard metrics. - [Booking](/booking): All APIs related to creating platform bookings. - [Channel Manager](/channel-manager): All APIs related to channel managers who want to integrate with our platform. - [Extranet](/extranet): All APIs related to managing travel inventory and suppliers. - [Inventory](/inventory): All APIs related to retrieve known travel inventory as it was found using the Lookup API.. - [Lookup](/lookup): All APIs related to locating inventory by region, locale and property flags. - [Reference](/reference): All APIs related to retrieving platform-supported taxonomies. - [TripPay Acquiring](/payment-acquiring): All APIs related to capture payment details such as a Stripe payment intent. - [TripPay](/payment): All APIs related to TripPay account management, booking, mapping and integration features.  ## SDKs We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).  - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)  ## Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Wink-Version` header. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints.  ## Release history - 2022-10-15: v2.0 - Removed HATEOAS and added Wink-Version header - 2022-05-08: v1 - Exposed channel manager API - 2021-07-01: v1 - Initial release  # Affiliate API Welcome to the Affiliate API - A programmer-friendly way to search for and display bespoke travel inventory for your audience. Use this API to help you prepare travel inventory for sale.  # Intended Audience Programmers are a requirement to start integrating with wink. You will benefit from an API integration if you are new or existing travel related company that want easy access to great inventory.## Examples: - Hotel brands / chains that want to make their own booking engine - Travel tech companies that want to create the next hot mobile travel app - Destination sites that want to make their own booking engine - Bloggers and influencers who want to sell travel inventory to their audience - OTAs that want access direct relationships with suppliers and better quality hotel inventory
 *
 * The version of the OpenAPI document: 29.53.6
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.affiliate.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.time.LocalDate;
import java.util.UUID;
import travel.wink.sdk.affiliate.model.CancellationPolicyAffiliate;
import travel.wink.sdk.affiliate.model.CancellationPolicyExceptionsAffiliate;
import travel.wink.sdk.affiliate.model.DowPatternGroupAffiliate;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * Rate plan used for this stay
 */
@JsonPropertyOrder({
  RatePlanAffiliate.JSON_PROPERTY_IDENTIFIER,
  RatePlanAffiliate.JSON_PROPERTY_HOTEL_IDENTIFIER,
  RatePlanAffiliate.JSON_PROPERTY_NAME,
  RatePlanAffiliate.JSON_PROPERTY_PREPAID,
  RatePlanAffiliate.JSON_PROPERTY_BREAKFAST,
  RatePlanAffiliate.JSON_PROPERTY_BRUNCH,
  RatePlanAffiliate.JSON_PROPERTY_LUNCH,
  RatePlanAffiliate.JSON_PROPERTY_DINNER,
  RatePlanAffiliate.JSON_PROPERTY_ALL_INCLUSIVE,
  RatePlanAffiliate.JSON_PROPERTY_ALL_INCLUSIVE_PLUS_ALCOHOL,
  RatePlanAffiliate.JSON_PROPERTY_SELL_START_DATE,
  RatePlanAffiliate.JSON_PROPERTY_SELL_END_DATE,
  RatePlanAffiliate.JSON_PROPERTY_STAY_START_DATE,
  RatePlanAffiliate.JSON_PROPERTY_STAY_END_DATE,
  RatePlanAffiliate.JSON_PROPERTY_LOYALTY_POINTS_ACCRUE,
  RatePlanAffiliate.JSON_PROPERTY_MAX_ADVANCE_BOOKING_OFFSET,
  RatePlanAffiliate.JSON_PROPERTY_MIN_ADVANCE_BOOKING_OFFSET,
  RatePlanAffiliate.JSON_PROPERTY_MIN_TOTAL_OCCUPANCY,
  RatePlanAffiliate.JSON_PROPERTY_MAX_TOTAL_OCCUPANCY,
  RatePlanAffiliate.JSON_PROPERTY_MIN_L_O_S,
  RatePlanAffiliate.JSON_PROPERTY_MAX_L_O_S,
  RatePlanAffiliate.JSON_PROPERTY_MIN_AGE,
  RatePlanAffiliate.JSON_PROPERTY_MAX_AGE,
  RatePlanAffiliate.JSON_PROPERTY_AVAILABLE_DAYS_OF_WEEK,
  RatePlanAffiliate.JSON_PROPERTY_ARRIVAL_DAYS_OF_WEEK,
  RatePlanAffiliate.JSON_PROPERTY_DEPARTURE_DAYS_OF_WEEK,
  RatePlanAffiliate.JSON_PROPERTY_REQUIRED_DAYS_OF_WEEK,
  RatePlanAffiliate.JSON_PROPERTY_EARLY_CHECK_IN_CHARGE,
  RatePlanAffiliate.JSON_PROPERTY_LATE_CHECK_OUT_CHARGE,
  RatePlanAffiliate.JSON_PROPERTY_CANCELLATION_POLICY_IDENTIFIER,
  RatePlanAffiliate.JSON_PROPERTY_CANCELLATION_POLICY,
  RatePlanAffiliate.JSON_PROPERTY_CANCELLATION_POLICY_EXCEPTIONS
})
@JsonTypeName("RatePlan_Affiliate")
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-04-15T11:53:55.998059534+07:00[Asia/Bangkok]")
public class RatePlanAffiliate {
  public static final String JSON_PROPERTY_IDENTIFIER = "identifier";
  private UUID identifier;

  public static final String JSON_PROPERTY_HOTEL_IDENTIFIER = "hotelIdentifier";
  private UUID hotelIdentifier;

  public static final String JSON_PROPERTY_NAME = "name";
  private String name;

  public static final String JSON_PROPERTY_PREPAID = "prepaid";
  private Boolean prepaid = false;

  public static final String JSON_PROPERTY_BREAKFAST = "breakfast";
  private Boolean breakfast = false;

  public static final String JSON_PROPERTY_BRUNCH = "brunch";
  private Boolean brunch = false;

  public static final String JSON_PROPERTY_LUNCH = "lunch";
  private Boolean lunch = false;

  public static final String JSON_PROPERTY_DINNER = "dinner";
  private Boolean dinner = false;

  public static final String JSON_PROPERTY_ALL_INCLUSIVE = "allInclusive";
  private Boolean allInclusive = false;

  public static final String JSON_PROPERTY_ALL_INCLUSIVE_PLUS_ALCOHOL = "allInclusivePlusAlcohol";
  private Boolean allInclusivePlusAlcohol = false;

  public static final String JSON_PROPERTY_SELL_START_DATE = "sellStartDate";
  private LocalDate sellStartDate;

  public static final String JSON_PROPERTY_SELL_END_DATE = "sellEndDate";
  private LocalDate sellEndDate;

  public static final String JSON_PROPERTY_STAY_START_DATE = "stayStartDate";
  private LocalDate stayStartDate;

  public static final String JSON_PROPERTY_STAY_END_DATE = "stayEndDate";
  private LocalDate stayEndDate;

  public static final String JSON_PROPERTY_LOYALTY_POINTS_ACCRUE = "loyaltyPointsAccrue";
  private Boolean loyaltyPointsAccrue = false;

  public static final String JSON_PROPERTY_MAX_ADVANCE_BOOKING_OFFSET = "maxAdvanceBookingOffset";
  private Integer maxAdvanceBookingOffset;

  public static final String JSON_PROPERTY_MIN_ADVANCE_BOOKING_OFFSET = "minAdvanceBookingOffset";
  private Integer minAdvanceBookingOffset;

  public static final String JSON_PROPERTY_MIN_TOTAL_OCCUPANCY = "minTotalOccupancy";
  private Integer minTotalOccupancy;

  public static final String JSON_PROPERTY_MAX_TOTAL_OCCUPANCY = "maxTotalOccupancy";
  private Integer maxTotalOccupancy;

  public static final String JSON_PROPERTY_MIN_L_O_S = "minLOS";
  private Integer minLOS;

  public static final String JSON_PROPERTY_MAX_L_O_S = "maxLOS";
  private Integer maxLOS;

  public static final String JSON_PROPERTY_MIN_AGE = "minAge";
  private Integer minAge;

  public static final String JSON_PROPERTY_MAX_AGE = "maxAge";
  private Integer maxAge;

  public static final String JSON_PROPERTY_AVAILABLE_DAYS_OF_WEEK = "availableDaysOfWeek";
  private DowPatternGroupAffiliate availableDaysOfWeek;

  public static final String JSON_PROPERTY_ARRIVAL_DAYS_OF_WEEK = "arrivalDaysOfWeek";
  private DowPatternGroupAffiliate arrivalDaysOfWeek;

  public static final String JSON_PROPERTY_DEPARTURE_DAYS_OF_WEEK = "departureDaysOfWeek";
  private DowPatternGroupAffiliate departureDaysOfWeek;

  public static final String JSON_PROPERTY_REQUIRED_DAYS_OF_WEEK = "requiredDaysOfWeek";
  private DowPatternGroupAffiliate requiredDaysOfWeek;

  public static final String JSON_PROPERTY_EARLY_CHECK_IN_CHARGE = "earlyCheckInCharge";
  private Object earlyCheckInCharge;

  public static final String JSON_PROPERTY_LATE_CHECK_OUT_CHARGE = "lateCheckOutCharge";
  private Object lateCheckOutCharge;

  public static final String JSON_PROPERTY_CANCELLATION_POLICY_IDENTIFIER = "cancellationPolicyIdentifier";
  private String cancellationPolicyIdentifier;

  public static final String JSON_PROPERTY_CANCELLATION_POLICY = "cancellationPolicy";
  private CancellationPolicyAffiliate cancellationPolicy;

  public static final String JSON_PROPERTY_CANCELLATION_POLICY_EXCEPTIONS = "cancellationPolicyExceptions";
  private CancellationPolicyExceptionsAffiliate cancellationPolicyExceptions;

  public RatePlanAffiliate() {
  }

  public RatePlanAffiliate identifier(UUID identifier) {
    
    this.identifier = identifier;
    return this;
  }

   /**
   * Rate plan identifier
   * @return identifier
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public UUID getIdentifier() {
    return identifier;
  }


  @JsonProperty(JSON_PROPERTY_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setIdentifier(UUID identifier) {
    this.identifier = identifier;
  }


  public RatePlanAffiliate hotelIdentifier(UUID hotelIdentifier) {
    
    this.hotelIdentifier = hotelIdentifier;
    return this;
  }

   /**
   * Hotel Identifier
   * @return hotelIdentifier
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_HOTEL_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public UUID getHotelIdentifier() {
    return hotelIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_HOTEL_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setHotelIdentifier(UUID hotelIdentifier) {
    this.hotelIdentifier = hotelIdentifier;
  }


  public RatePlanAffiliate name(String name) {
    
    this.name = name;
    return this;
  }

   /**
   * Provides the name of the rate plan.
   * @return name
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getName() {
    return name;
  }


  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setName(String name) {
    this.name = name;
  }


  public RatePlanAffiliate prepaid(Boolean prepaid) {
    
    this.prepaid = prepaid;
    return this;
  }

   /**
   * When true, indicates if the rate is a prepaid rate.
   * @return prepaid
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_PREPAID)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Boolean getPrepaid() {
    return prepaid;
  }


  @JsonProperty(JSON_PROPERTY_PREPAID)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setPrepaid(Boolean prepaid) {
    this.prepaid = prepaid;
  }


  public RatePlanAffiliate breakfast(Boolean breakfast) {
    
    this.breakfast = breakfast;
    return this;
  }

   /**
   * When true, indicates breakfast is included.
   * @return breakfast
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_BREAKFAST)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Boolean getBreakfast() {
    return breakfast;
  }


  @JsonProperty(JSON_PROPERTY_BREAKFAST)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setBreakfast(Boolean breakfast) {
    this.breakfast = breakfast;
  }


  public RatePlanAffiliate brunch(Boolean brunch) {
    
    this.brunch = brunch;
    return this;
  }

   /**
   * When true, indicates brunch is included.
   * @return brunch
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_BRUNCH)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Boolean getBrunch() {
    return brunch;
  }


  @JsonProperty(JSON_PROPERTY_BRUNCH)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setBrunch(Boolean brunch) {
    this.brunch = brunch;
  }


  public RatePlanAffiliate lunch(Boolean lunch) {
    
    this.lunch = lunch;
    return this;
  }

   /**
   * When true, indicates lunch is included.
   * @return lunch
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_LUNCH)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Boolean getLunch() {
    return lunch;
  }


  @JsonProperty(JSON_PROPERTY_LUNCH)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setLunch(Boolean lunch) {
    this.lunch = lunch;
  }


  public RatePlanAffiliate dinner(Boolean dinner) {
    
    this.dinner = dinner;
    return this;
  }

   /**
   * When true, indicates dinner is included.
   * @return dinner
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_DINNER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Boolean getDinner() {
    return dinner;
  }


  @JsonProperty(JSON_PROPERTY_DINNER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setDinner(Boolean dinner) {
    this.dinner = dinner;
  }


  public RatePlanAffiliate allInclusive(Boolean allInclusive) {
    
    this.allInclusive = allInclusive;
    return this;
  }

   /**
   * Everything included except alcohol
   * @return allInclusive
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_ALL_INCLUSIVE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Boolean getAllInclusive() {
    return allInclusive;
  }


  @JsonProperty(JSON_PROPERTY_ALL_INCLUSIVE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setAllInclusive(Boolean allInclusive) {
    this.allInclusive = allInclusive;
  }


  public RatePlanAffiliate allInclusivePlusAlcohol(Boolean allInclusivePlusAlcohol) {
    
    this.allInclusivePlusAlcohol = allInclusivePlusAlcohol;
    return this;
  }

   /**
   * Everything included with alcohol
   * @return allInclusivePlusAlcohol
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_ALL_INCLUSIVE_PLUS_ALCOHOL)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Boolean getAllInclusivePlusAlcohol() {
    return allInclusivePlusAlcohol;
  }


  @JsonProperty(JSON_PROPERTY_ALL_INCLUSIVE_PLUS_ALCOHOL)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setAllInclusivePlusAlcohol(Boolean allInclusivePlusAlcohol) {
    this.allInclusivePlusAlcohol = allInclusivePlusAlcohol;
  }


  public RatePlanAffiliate sellStartDate(LocalDate sellStartDate) {
    
    this.sellStartDate = sellStartDate;
    return this;
  }

   /**
   * Set a start date for when to start selling this rate. When sellStartDate and sellEndDate are set, this rate is only available for sale within that date range.
   * @return sellStartDate
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_SELL_START_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public LocalDate getSellStartDate() {
    return sellStartDate;
  }


  @JsonProperty(JSON_PROPERTY_SELL_START_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSellStartDate(LocalDate sellStartDate) {
    this.sellStartDate = sellStartDate;
  }


  public RatePlanAffiliate sellEndDate(LocalDate sellEndDate) {
    
    this.sellEndDate = sellEndDate;
    return this;
  }

   /**
   * Set an end date for when to finish selling this rate. When sellStartDate and sellEndDate are set, this rate is only available for sale within that date range.
   * @return sellEndDate
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_SELL_END_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public LocalDate getSellEndDate() {
    return sellEndDate;
  }


  @JsonProperty(JSON_PROPERTY_SELL_END_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSellEndDate(LocalDate sellEndDate) {
    this.sellEndDate = sellEndDate;
  }


  public RatePlanAffiliate stayStartDate(LocalDate stayStartDate) {
    
    this.stayStartDate = stayStartDate;
    return this;
  }

   /**
   * Set a start date for when the guest can visit. When stayStartDate and stayEndDate are set, this rate is only available for stay within that date range.
   * @return stayStartDate
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_STAY_START_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public LocalDate getStayStartDate() {
    return stayStartDate;
  }


  @JsonProperty(JSON_PROPERTY_STAY_START_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setStayStartDate(LocalDate stayStartDate) {
    this.stayStartDate = stayStartDate;
  }


  public RatePlanAffiliate stayEndDate(LocalDate stayEndDate) {
    
    this.stayEndDate = stayEndDate;
    return this;
  }

   /**
   * Set an end date for when the guest can visit. When stayStartDate and stayEndDate are set, this rate is only available for stay within that date range.
   * @return stayEndDate
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_STAY_END_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public LocalDate getStayEndDate() {
    return stayEndDate;
  }


  @JsonProperty(JSON_PROPERTY_STAY_END_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setStayEndDate(LocalDate stayEndDate) {
    this.stayEndDate = stayEndDate;
  }


  public RatePlanAffiliate loyaltyPointsAccrue(Boolean loyaltyPointsAccrue) {
    
    this.loyaltyPointsAccrue = loyaltyPointsAccrue;
    return this;
  }

   /**
   * Property honors loyalty points with this rate plan.
   * @return loyaltyPointsAccrue
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_LOYALTY_POINTS_ACCRUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getLoyaltyPointsAccrue() {
    return loyaltyPointsAccrue;
  }


  @JsonProperty(JSON_PROPERTY_LOYALTY_POINTS_ACCRUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLoyaltyPointsAccrue(Boolean loyaltyPointsAccrue) {
    this.loyaltyPointsAccrue = loyaltyPointsAccrue;
  }


  public RatePlanAffiliate maxAdvanceBookingOffset(Integer maxAdvanceBookingOffset) {
    
    this.maxAdvanceBookingOffset = maxAdvanceBookingOffset;
    return this;
  }

   /**
   * Maximum days before the arrival date for which this rate plan may be booked.
   * @return maxAdvanceBookingOffset
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_MAX_ADVANCE_BOOKING_OFFSET)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getMaxAdvanceBookingOffset() {
    return maxAdvanceBookingOffset;
  }


  @JsonProperty(JSON_PROPERTY_MAX_ADVANCE_BOOKING_OFFSET)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMaxAdvanceBookingOffset(Integer maxAdvanceBookingOffset) {
    this.maxAdvanceBookingOffset = maxAdvanceBookingOffset;
  }


  public RatePlanAffiliate minAdvanceBookingOffset(Integer minAdvanceBookingOffset) {
    
    this.minAdvanceBookingOffset = minAdvanceBookingOffset;
    return this;
  }

   /**
   * Minimum days before the arrival date for which this rate plan may be booked.
   * @return minAdvanceBookingOffset
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_MIN_ADVANCE_BOOKING_OFFSET)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getMinAdvanceBookingOffset() {
    return minAdvanceBookingOffset;
  }


  @JsonProperty(JSON_PROPERTY_MIN_ADVANCE_BOOKING_OFFSET)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMinAdvanceBookingOffset(Integer minAdvanceBookingOffset) {
    this.minAdvanceBookingOffset = minAdvanceBookingOffset;
  }


  public RatePlanAffiliate minTotalOccupancy(Integer minTotalOccupancy) {
    
    this.minTotalOccupancy = minTotalOccupancy;
    return this;
  }

   /**
   * Defines the minimum number of total occupants required for this rate plan.
   * @return minTotalOccupancy
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_MIN_TOTAL_OCCUPANCY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getMinTotalOccupancy() {
    return minTotalOccupancy;
  }


  @JsonProperty(JSON_PROPERTY_MIN_TOTAL_OCCUPANCY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMinTotalOccupancy(Integer minTotalOccupancy) {
    this.minTotalOccupancy = minTotalOccupancy;
  }


  public RatePlanAffiliate maxTotalOccupancy(Integer maxTotalOccupancy) {
    
    this.maxTotalOccupancy = maxTotalOccupancy;
    return this;
  }

   /**
   * Defines the maximum number of total occupants required for this rate plan.
   * @return maxTotalOccupancy
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_MAX_TOTAL_OCCUPANCY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getMaxTotalOccupancy() {
    return maxTotalOccupancy;
  }


  @JsonProperty(JSON_PROPERTY_MAX_TOTAL_OCCUPANCY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMaxTotalOccupancy(Integer maxTotalOccupancy) {
    this.maxTotalOccupancy = maxTotalOccupancy;
  }


  public RatePlanAffiliate minLOS(Integer minLOS) {
    
    this.minLOS = minLOS;
    return this;
  }

   /**
   * Indicates the minimum length of stay required for this rate plan.
   * @return minLOS
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_MIN_L_O_S)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getMinLOS() {
    return minLOS;
  }


  @JsonProperty(JSON_PROPERTY_MIN_L_O_S)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMinLOS(Integer minLOS) {
    this.minLOS = minLOS;
  }


  public RatePlanAffiliate maxLOS(Integer maxLOS) {
    
    this.maxLOS = maxLOS;
    return this;
  }

   /**
   * Indicates the maximum length of stay.
   * @return maxLOS
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_MAX_L_O_S)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getMaxLOS() {
    return maxLOS;
  }


  @JsonProperty(JSON_PROPERTY_MAX_L_O_S)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMaxLOS(Integer maxLOS) {
    this.maxLOS = maxLOS;
  }


  public RatePlanAffiliate minAge(Integer minAge) {
    
    this.minAge = minAge;
    return this;
  }

   /**
   * The minimum age to qualify for this rate plan.
   * @return minAge
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_MIN_AGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getMinAge() {
    return minAge;
  }


  @JsonProperty(JSON_PROPERTY_MIN_AGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMinAge(Integer minAge) {
    this.minAge = minAge;
  }


  public RatePlanAffiliate maxAge(Integer maxAge) {
    
    this.maxAge = maxAge;
    return this;
  }

   /**
   * The maximum age to qualify for this rate plan.
   * @return maxAge
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_MAX_AGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getMaxAge() {
    return maxAge;
  }


  @JsonProperty(JSON_PROPERTY_MAX_AGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMaxAge(Integer maxAge) {
    this.maxAge = maxAge;
  }


  public RatePlanAffiliate availableDaysOfWeek(DowPatternGroupAffiliate availableDaysOfWeek) {
    
    this.availableDaysOfWeek = availableDaysOfWeek;
    return this;
  }

   /**
   * Get availableDaysOfWeek
   * @return availableDaysOfWeek
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_AVAILABLE_DAYS_OF_WEEK)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public DowPatternGroupAffiliate getAvailableDaysOfWeek() {
    return availableDaysOfWeek;
  }


  @JsonProperty(JSON_PROPERTY_AVAILABLE_DAYS_OF_WEEK)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAvailableDaysOfWeek(DowPatternGroupAffiliate availableDaysOfWeek) {
    this.availableDaysOfWeek = availableDaysOfWeek;
  }


  public RatePlanAffiliate arrivalDaysOfWeek(DowPatternGroupAffiliate arrivalDaysOfWeek) {
    
    this.arrivalDaysOfWeek = arrivalDaysOfWeek;
    return this;
  }

   /**
   * Get arrivalDaysOfWeek
   * @return arrivalDaysOfWeek
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_ARRIVAL_DAYS_OF_WEEK)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public DowPatternGroupAffiliate getArrivalDaysOfWeek() {
    return arrivalDaysOfWeek;
  }


  @JsonProperty(JSON_PROPERTY_ARRIVAL_DAYS_OF_WEEK)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setArrivalDaysOfWeek(DowPatternGroupAffiliate arrivalDaysOfWeek) {
    this.arrivalDaysOfWeek = arrivalDaysOfWeek;
  }


  public RatePlanAffiliate departureDaysOfWeek(DowPatternGroupAffiliate departureDaysOfWeek) {
    
    this.departureDaysOfWeek = departureDaysOfWeek;
    return this;
  }

   /**
   * Get departureDaysOfWeek
   * @return departureDaysOfWeek
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_DEPARTURE_DAYS_OF_WEEK)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public DowPatternGroupAffiliate getDepartureDaysOfWeek() {
    return departureDaysOfWeek;
  }


  @JsonProperty(JSON_PROPERTY_DEPARTURE_DAYS_OF_WEEK)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDepartureDaysOfWeek(DowPatternGroupAffiliate departureDaysOfWeek) {
    this.departureDaysOfWeek = departureDaysOfWeek;
  }


  public RatePlanAffiliate requiredDaysOfWeek(DowPatternGroupAffiliate requiredDaysOfWeek) {
    
    this.requiredDaysOfWeek = requiredDaysOfWeek;
    return this;
  }

   /**
   * Get requiredDaysOfWeek
   * @return requiredDaysOfWeek
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_REQUIRED_DAYS_OF_WEEK)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public DowPatternGroupAffiliate getRequiredDaysOfWeek() {
    return requiredDaysOfWeek;
  }


  @JsonProperty(JSON_PROPERTY_REQUIRED_DAYS_OF_WEEK)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRequiredDaysOfWeek(DowPatternGroupAffiliate requiredDaysOfWeek) {
    this.requiredDaysOfWeek = requiredDaysOfWeek;
  }


  public RatePlanAffiliate earlyCheckInCharge(Object earlyCheckInCharge) {
    
    this.earlyCheckInCharge = earlyCheckInCharge;
    return this;
  }

   /**
   * Get earlyCheckInCharge
   * @return earlyCheckInCharge
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_EARLY_CHECK_IN_CHARGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Object getEarlyCheckInCharge() {
    return earlyCheckInCharge;
  }


  @JsonProperty(JSON_PROPERTY_EARLY_CHECK_IN_CHARGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setEarlyCheckInCharge(Object earlyCheckInCharge) {
    this.earlyCheckInCharge = earlyCheckInCharge;
  }


  public RatePlanAffiliate lateCheckOutCharge(Object lateCheckOutCharge) {
    
    this.lateCheckOutCharge = lateCheckOutCharge;
    return this;
  }

   /**
   * Get lateCheckOutCharge
   * @return lateCheckOutCharge
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_LATE_CHECK_OUT_CHARGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Object getLateCheckOutCharge() {
    return lateCheckOutCharge;
  }


  @JsonProperty(JSON_PROPERTY_LATE_CHECK_OUT_CHARGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLateCheckOutCharge(Object lateCheckOutCharge) {
    this.lateCheckOutCharge = lateCheckOutCharge;
  }


  public RatePlanAffiliate cancellationPolicyIdentifier(String cancellationPolicyIdentifier) {
    
    this.cancellationPolicyIdentifier = cancellationPolicyIdentifier;
    return this;
  }

   /**
   * The cancellation policy for this rate plan.
   * @return cancellationPolicyIdentifier
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_CANCELLATION_POLICY_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getCancellationPolicyIdentifier() {
    return cancellationPolicyIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_CANCELLATION_POLICY_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setCancellationPolicyIdentifier(String cancellationPolicyIdentifier) {
    this.cancellationPolicyIdentifier = cancellationPolicyIdentifier;
  }


  public RatePlanAffiliate cancellationPolicy(CancellationPolicyAffiliate cancellationPolicy) {
    
    this.cancellationPolicy = cancellationPolicy;
    return this;
  }

   /**
   * Get cancellationPolicy
   * @return cancellationPolicy
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_CANCELLATION_POLICY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CancellationPolicyAffiliate getCancellationPolicy() {
    return cancellationPolicy;
  }


  @JsonProperty(JSON_PROPERTY_CANCELLATION_POLICY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCancellationPolicy(CancellationPolicyAffiliate cancellationPolicy) {
    this.cancellationPolicy = cancellationPolicy;
  }


  public RatePlanAffiliate cancellationPolicyExceptions(CancellationPolicyExceptionsAffiliate cancellationPolicyExceptions) {
    
    this.cancellationPolicyExceptions = cancellationPolicyExceptions;
    return this;
  }

   /**
   * Get cancellationPolicyExceptions
   * @return cancellationPolicyExceptions
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_CANCELLATION_POLICY_EXCEPTIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public CancellationPolicyExceptionsAffiliate getCancellationPolicyExceptions() {
    return cancellationPolicyExceptions;
  }


  @JsonProperty(JSON_PROPERTY_CANCELLATION_POLICY_EXCEPTIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCancellationPolicyExceptions(CancellationPolicyExceptionsAffiliate cancellationPolicyExceptions) {
    this.cancellationPolicyExceptions = cancellationPolicyExceptions;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    RatePlanAffiliate ratePlanAffiliate = (RatePlanAffiliate) o;
    return Objects.equals(this.identifier, ratePlanAffiliate.identifier) &&
        Objects.equals(this.hotelIdentifier, ratePlanAffiliate.hotelIdentifier) &&
        Objects.equals(this.name, ratePlanAffiliate.name) &&
        Objects.equals(this.prepaid, ratePlanAffiliate.prepaid) &&
        Objects.equals(this.breakfast, ratePlanAffiliate.breakfast) &&
        Objects.equals(this.brunch, ratePlanAffiliate.brunch) &&
        Objects.equals(this.lunch, ratePlanAffiliate.lunch) &&
        Objects.equals(this.dinner, ratePlanAffiliate.dinner) &&
        Objects.equals(this.allInclusive, ratePlanAffiliate.allInclusive) &&
        Objects.equals(this.allInclusivePlusAlcohol, ratePlanAffiliate.allInclusivePlusAlcohol) &&
        Objects.equals(this.sellStartDate, ratePlanAffiliate.sellStartDate) &&
        Objects.equals(this.sellEndDate, ratePlanAffiliate.sellEndDate) &&
        Objects.equals(this.stayStartDate, ratePlanAffiliate.stayStartDate) &&
        Objects.equals(this.stayEndDate, ratePlanAffiliate.stayEndDate) &&
        Objects.equals(this.loyaltyPointsAccrue, ratePlanAffiliate.loyaltyPointsAccrue) &&
        Objects.equals(this.maxAdvanceBookingOffset, ratePlanAffiliate.maxAdvanceBookingOffset) &&
        Objects.equals(this.minAdvanceBookingOffset, ratePlanAffiliate.minAdvanceBookingOffset) &&
        Objects.equals(this.minTotalOccupancy, ratePlanAffiliate.minTotalOccupancy) &&
        Objects.equals(this.maxTotalOccupancy, ratePlanAffiliate.maxTotalOccupancy) &&
        Objects.equals(this.minLOS, ratePlanAffiliate.minLOS) &&
        Objects.equals(this.maxLOS, ratePlanAffiliate.maxLOS) &&
        Objects.equals(this.minAge, ratePlanAffiliate.minAge) &&
        Objects.equals(this.maxAge, ratePlanAffiliate.maxAge) &&
        Objects.equals(this.availableDaysOfWeek, ratePlanAffiliate.availableDaysOfWeek) &&
        Objects.equals(this.arrivalDaysOfWeek, ratePlanAffiliate.arrivalDaysOfWeek) &&
        Objects.equals(this.departureDaysOfWeek, ratePlanAffiliate.departureDaysOfWeek) &&
        Objects.equals(this.requiredDaysOfWeek, ratePlanAffiliate.requiredDaysOfWeek) &&
        Objects.equals(this.earlyCheckInCharge, ratePlanAffiliate.earlyCheckInCharge) &&
        Objects.equals(this.lateCheckOutCharge, ratePlanAffiliate.lateCheckOutCharge) &&
        Objects.equals(this.cancellationPolicyIdentifier, ratePlanAffiliate.cancellationPolicyIdentifier) &&
        Objects.equals(this.cancellationPolicy, ratePlanAffiliate.cancellationPolicy) &&
        Objects.equals(this.cancellationPolicyExceptions, ratePlanAffiliate.cancellationPolicyExceptions);
  }

  @Override
  public int hashCode() {
    return Objects.hash(identifier, hotelIdentifier, name, prepaid, breakfast, brunch, lunch, dinner, allInclusive, allInclusivePlusAlcohol, sellStartDate, sellEndDate, stayStartDate, stayEndDate, loyaltyPointsAccrue, maxAdvanceBookingOffset, minAdvanceBookingOffset, minTotalOccupancy, maxTotalOccupancy, minLOS, maxLOS, minAge, maxAge, availableDaysOfWeek, arrivalDaysOfWeek, departureDaysOfWeek, requiredDaysOfWeek, earlyCheckInCharge, lateCheckOutCharge, cancellationPolicyIdentifier, cancellationPolicy, cancellationPolicyExceptions);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class RatePlanAffiliate {\n");
    sb.append("    identifier: ").append(toIndentedString(identifier)).append("\n");
    sb.append("    hotelIdentifier: ").append(toIndentedString(hotelIdentifier)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    prepaid: ").append(toIndentedString(prepaid)).append("\n");
    sb.append("    breakfast: ").append(toIndentedString(breakfast)).append("\n");
    sb.append("    brunch: ").append(toIndentedString(brunch)).append("\n");
    sb.append("    lunch: ").append(toIndentedString(lunch)).append("\n");
    sb.append("    dinner: ").append(toIndentedString(dinner)).append("\n");
    sb.append("    allInclusive: ").append(toIndentedString(allInclusive)).append("\n");
    sb.append("    allInclusivePlusAlcohol: ").append(toIndentedString(allInclusivePlusAlcohol)).append("\n");
    sb.append("    sellStartDate: ").append(toIndentedString(sellStartDate)).append("\n");
    sb.append("    sellEndDate: ").append(toIndentedString(sellEndDate)).append("\n");
    sb.append("    stayStartDate: ").append(toIndentedString(stayStartDate)).append("\n");
    sb.append("    stayEndDate: ").append(toIndentedString(stayEndDate)).append("\n");
    sb.append("    loyaltyPointsAccrue: ").append(toIndentedString(loyaltyPointsAccrue)).append("\n");
    sb.append("    maxAdvanceBookingOffset: ").append(toIndentedString(maxAdvanceBookingOffset)).append("\n");
    sb.append("    minAdvanceBookingOffset: ").append(toIndentedString(minAdvanceBookingOffset)).append("\n");
    sb.append("    minTotalOccupancy: ").append(toIndentedString(minTotalOccupancy)).append("\n");
    sb.append("    maxTotalOccupancy: ").append(toIndentedString(maxTotalOccupancy)).append("\n");
    sb.append("    minLOS: ").append(toIndentedString(minLOS)).append("\n");
    sb.append("    maxLOS: ").append(toIndentedString(maxLOS)).append("\n");
    sb.append("    minAge: ").append(toIndentedString(minAge)).append("\n");
    sb.append("    maxAge: ").append(toIndentedString(maxAge)).append("\n");
    sb.append("    availableDaysOfWeek: ").append(toIndentedString(availableDaysOfWeek)).append("\n");
    sb.append("    arrivalDaysOfWeek: ").append(toIndentedString(arrivalDaysOfWeek)).append("\n");
    sb.append("    departureDaysOfWeek: ").append(toIndentedString(departureDaysOfWeek)).append("\n");
    sb.append("    requiredDaysOfWeek: ").append(toIndentedString(requiredDaysOfWeek)).append("\n");
    sb.append("    earlyCheckInCharge: ").append(toIndentedString(earlyCheckInCharge)).append("\n");
    sb.append("    lateCheckOutCharge: ").append(toIndentedString(lateCheckOutCharge)).append("\n");
    sb.append("    cancellationPolicyIdentifier: ").append(toIndentedString(cancellationPolicyIdentifier)).append("\n");
    sb.append("    cancellationPolicy: ").append(toIndentedString(cancellationPolicy)).append("\n");
    sb.append("    cancellationPolicyExceptions: ").append(toIndentedString(cancellationPolicyExceptions)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

