/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.affiliate.api;

import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import travel.wink.sdk.affiliate.invoker.ApiClient;
import travel.wink.sdk.affiliate.model.CompanyViewAffiliate;
import travel.wink.sdk.affiliate.model.CreateCompanyRequestAffiliate;
import travel.wink.sdk.affiliate.model.InviteManagerRequestAffiliate;
import travel.wink.sdk.affiliate.model.RemoveEntryResponseAffiliate;
import travel.wink.sdk.affiliate.model.UniqueRequestAffiliate;
import travel.wink.sdk.affiliate.model.UniqueResultAffiliate;
import travel.wink.sdk.affiliate.model.UpsertCompanyRequestAffiliate;
import travel.wink.sdk.affiliate.model.UpsertCompanyStatusRequestAffiliate;

public class CompanyApi {
    private ApiClient apiClient;

    public CompanyApi() {
        this(new ApiClient());
    }

    @Autowired
    public CompanyApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    private WebClient.ResponseSpec createCompanyRequestCreation(CreateCompanyRequestAffiliate createCompanyRequestAffiliate, String winkVersion) throws WebClientResponseException {
        CreateCompanyRequestAffiliate postBody = createCompanyRequestAffiliate;
        if (createCompanyRequestAffiliate == null) {
            throw new WebClientResponseException("Missing the required parameter 'createCompanyRequestAffiliate' when calling createCompany", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<CompanyViewAffiliate> localVarReturnType = new ParameterizedTypeReference<CompanyViewAffiliate>(this){};
        return this.apiClient.invokeAPI("/api/company", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<CompanyViewAffiliate> createCompany(CreateCompanyRequestAffiliate createCompanyRequestAffiliate, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<CompanyViewAffiliate> localVarReturnType = new ParameterizedTypeReference<CompanyViewAffiliate>(this){};
        return this.createCompanyRequestCreation(createCompanyRequestAffiliate, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<CompanyViewAffiliate>> createCompanyWithHttpInfo(CreateCompanyRequestAffiliate createCompanyRequestAffiliate, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<CompanyViewAffiliate> localVarReturnType = new ParameterizedTypeReference<CompanyViewAffiliate>(this){};
        return this.createCompanyRequestCreation(createCompanyRequestAffiliate, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec createCompanyWithResponseSpec(CreateCompanyRequestAffiliate createCompanyRequestAffiliate, String winkVersion) throws WebClientResponseException {
        return this.createCompanyRequestCreation(createCompanyRequestAffiliate, winkVersion);
    }

    private WebClient.ResponseSpec inviteManagerRequestCreation(String companyIdentifier, InviteManagerRequestAffiliate inviteManagerRequestAffiliate, String winkVersion) throws WebClientResponseException {
        InviteManagerRequestAffiliate postBody = inviteManagerRequestAffiliate;
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling inviteManager", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (inviteManagerRequestAffiliate == null) {
            throw new WebClientResponseException("Missing the required parameter 'inviteManagerRequestAffiliate' when calling inviteManager", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("companyIdentifier", companyIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<CompanyViewAffiliate> localVarReturnType = new ParameterizedTypeReference<CompanyViewAffiliate>(this){};
        return this.apiClient.invokeAPI("/api/company/{companyIdentifier}/manager/invite", HttpMethod.PATCH, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<CompanyViewAffiliate> inviteManager(String companyIdentifier, InviteManagerRequestAffiliate inviteManagerRequestAffiliate, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<CompanyViewAffiliate> localVarReturnType = new ParameterizedTypeReference<CompanyViewAffiliate>(this){};
        return this.inviteManagerRequestCreation(companyIdentifier, inviteManagerRequestAffiliate, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<CompanyViewAffiliate>> inviteManagerWithHttpInfo(String companyIdentifier, InviteManagerRequestAffiliate inviteManagerRequestAffiliate, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<CompanyViewAffiliate> localVarReturnType = new ParameterizedTypeReference<CompanyViewAffiliate>(this){};
        return this.inviteManagerRequestCreation(companyIdentifier, inviteManagerRequestAffiliate, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec inviteManagerWithResponseSpec(String companyIdentifier, InviteManagerRequestAffiliate inviteManagerRequestAffiliate, String winkVersion) throws WebClientResponseException {
        return this.inviteManagerRequestCreation(companyIdentifier, inviteManagerRequestAffiliate, winkVersion);
    }

    private WebClient.ResponseSpec isCompanyNameUniqueRequestCreation(UniqueRequestAffiliate uniqueRequestAffiliate, String winkVersion) throws WebClientResponseException {
        UniqueRequestAffiliate postBody = uniqueRequestAffiliate;
        if (uniqueRequestAffiliate == null) {
            throw new WebClientResponseException("Missing the required parameter 'uniqueRequestAffiliate' when calling isCompanyNameUnique", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<UniqueResultAffiliate> localVarReturnType = new ParameterizedTypeReference<UniqueResultAffiliate>(this){};
        return this.apiClient.invokeAPI("/api/company/unique", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<UniqueResultAffiliate> isCompanyNameUnique(UniqueRequestAffiliate uniqueRequestAffiliate, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<UniqueResultAffiliate> localVarReturnType = new ParameterizedTypeReference<UniqueResultAffiliate>(this){};
        return this.isCompanyNameUniqueRequestCreation(uniqueRequestAffiliate, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<UniqueResultAffiliate>> isCompanyNameUniqueWithHttpInfo(UniqueRequestAffiliate uniqueRequestAffiliate, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<UniqueResultAffiliate> localVarReturnType = new ParameterizedTypeReference<UniqueResultAffiliate>(this){};
        return this.isCompanyNameUniqueRequestCreation(uniqueRequestAffiliate, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec isCompanyNameUniqueWithResponseSpec(UniqueRequestAffiliate uniqueRequestAffiliate, String winkVersion) throws WebClientResponseException {
        return this.isCompanyNameUniqueRequestCreation(uniqueRequestAffiliate, winkVersion);
    }

    private WebClient.ResponseSpec removeCompanyRequestCreation(String companyIdentifier, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling removeCompany", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("companyIdentifier", companyIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<RemoveEntryResponseAffiliate> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponseAffiliate>(this){};
        return this.apiClient.invokeAPI("/api/company/{companyIdentifier}", HttpMethod.DELETE, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<RemoveEntryResponseAffiliate> removeCompany(String companyIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<RemoveEntryResponseAffiliate> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponseAffiliate>(this){};
        return this.removeCompanyRequestCreation(companyIdentifier, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<RemoveEntryResponseAffiliate>> removeCompanyWithHttpInfo(String companyIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<RemoveEntryResponseAffiliate> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponseAffiliate>(this){};
        return this.removeCompanyRequestCreation(companyIdentifier, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec removeCompanyWithResponseSpec(String companyIdentifier, String winkVersion) throws WebClientResponseException {
        return this.removeCompanyRequestCreation(companyIdentifier, winkVersion);
    }

    private WebClient.ResponseSpec removeCompanyUserRequestCreation(String companyIdentifier, String email, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling removeCompanyUser", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (email == null) {
            throw new WebClientResponseException("Missing the required parameter 'email' when calling removeCompanyUser", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("companyIdentifier", companyIdentifier);
        pathParams.put("email", email);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<CompanyViewAffiliate> localVarReturnType = new ParameterizedTypeReference<CompanyViewAffiliate>(this){};
        return this.apiClient.invokeAPI("/api/company/{companyIdentifier}/manager/{email}", HttpMethod.DELETE, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<CompanyViewAffiliate> removeCompanyUser(String companyIdentifier, String email, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<CompanyViewAffiliate> localVarReturnType = new ParameterizedTypeReference<CompanyViewAffiliate>(this){};
        return this.removeCompanyUserRequestCreation(companyIdentifier, email, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<CompanyViewAffiliate>> removeCompanyUserWithHttpInfo(String companyIdentifier, String email, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<CompanyViewAffiliate> localVarReturnType = new ParameterizedTypeReference<CompanyViewAffiliate>(this){};
        return this.removeCompanyUserRequestCreation(companyIdentifier, email, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec removeCompanyUserWithResponseSpec(String companyIdentifier, String email, String winkVersion) throws WebClientResponseException {
        return this.removeCompanyUserRequestCreation(companyIdentifier, email, winkVersion);
    }

    private WebClient.ResponseSpec showCompaniesRequestCreation(String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<CompanyViewAffiliate> localVarReturnType = new ParameterizedTypeReference<CompanyViewAffiliate>(this){};
        return this.apiClient.invokeAPI("/api/company/list", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Flux<CompanyViewAffiliate> showCompanies(String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<CompanyViewAffiliate> localVarReturnType = new ParameterizedTypeReference<CompanyViewAffiliate>(this){};
        return this.showCompaniesRequestCreation(winkVersion).bodyToFlux((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<List<CompanyViewAffiliate>>> showCompaniesWithHttpInfo(String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<CompanyViewAffiliate> localVarReturnType = new ParameterizedTypeReference<CompanyViewAffiliate>(this){};
        return this.showCompaniesRequestCreation(winkVersion).toEntityList((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showCompaniesWithResponseSpec(String winkVersion) throws WebClientResponseException {
        return this.showCompaniesRequestCreation(winkVersion);
    }

    private WebClient.ResponseSpec showCompanyRequestCreation(String companyIdentifier, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling showCompany", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("companyIdentifier", companyIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<CompanyViewAffiliate> localVarReturnType = new ParameterizedTypeReference<CompanyViewAffiliate>(this){};
        return this.apiClient.invokeAPI("/api/company/{companyIdentifier}", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<CompanyViewAffiliate> showCompany(String companyIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<CompanyViewAffiliate> localVarReturnType = new ParameterizedTypeReference<CompanyViewAffiliate>(this){};
        return this.showCompanyRequestCreation(companyIdentifier, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<CompanyViewAffiliate>> showCompanyWithHttpInfo(String companyIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<CompanyViewAffiliate> localVarReturnType = new ParameterizedTypeReference<CompanyViewAffiliate>(this){};
        return this.showCompanyRequestCreation(companyIdentifier, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showCompanyWithResponseSpec(String companyIdentifier, String winkVersion) throws WebClientResponseException {
        return this.showCompanyRequestCreation(companyIdentifier, winkVersion);
    }

    private WebClient.ResponseSpec updateCompanyRequestCreation(String companyIdentifier, UpsertCompanyRequestAffiliate upsertCompanyRequestAffiliate, String winkVersion) throws WebClientResponseException {
        UpsertCompanyRequestAffiliate postBody = upsertCompanyRequestAffiliate;
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling updateCompany", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (upsertCompanyRequestAffiliate == null) {
            throw new WebClientResponseException("Missing the required parameter 'upsertCompanyRequestAffiliate' when calling updateCompany", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("companyIdentifier", companyIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<CompanyViewAffiliate> localVarReturnType = new ParameterizedTypeReference<CompanyViewAffiliate>(this){};
        return this.apiClient.invokeAPI("/api/company/{companyIdentifier}", HttpMethod.PATCH, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<CompanyViewAffiliate> updateCompany(String companyIdentifier, UpsertCompanyRequestAffiliate upsertCompanyRequestAffiliate, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<CompanyViewAffiliate> localVarReturnType = new ParameterizedTypeReference<CompanyViewAffiliate>(this){};
        return this.updateCompanyRequestCreation(companyIdentifier, upsertCompanyRequestAffiliate, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<CompanyViewAffiliate>> updateCompanyWithHttpInfo(String companyIdentifier, UpsertCompanyRequestAffiliate upsertCompanyRequestAffiliate, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<CompanyViewAffiliate> localVarReturnType = new ParameterizedTypeReference<CompanyViewAffiliate>(this){};
        return this.updateCompanyRequestCreation(companyIdentifier, upsertCompanyRequestAffiliate, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec updateCompanyWithResponseSpec(String companyIdentifier, UpsertCompanyRequestAffiliate upsertCompanyRequestAffiliate, String winkVersion) throws WebClientResponseException {
        return this.updateCompanyRequestCreation(companyIdentifier, upsertCompanyRequestAffiliate, winkVersion);
    }

    private WebClient.ResponseSpec updateCompany1RequestCreation(String companyIdentifier, UpsertCompanyStatusRequestAffiliate upsertCompanyStatusRequestAffiliate, String winkVersion) throws WebClientResponseException {
        UpsertCompanyStatusRequestAffiliate postBody = upsertCompanyStatusRequestAffiliate;
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling updateCompany1", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (upsertCompanyStatusRequestAffiliate == null) {
            throw new WebClientResponseException("Missing the required parameter 'upsertCompanyStatusRequestAffiliate' when calling updateCompany1", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("companyIdentifier", companyIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<CompanyViewAffiliate> localVarReturnType = new ParameterizedTypeReference<CompanyViewAffiliate>(this){};
        return this.apiClient.invokeAPI("/api/company/{companyIdentifier}/status", HttpMethod.PATCH, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<CompanyViewAffiliate> updateCompany1(String companyIdentifier, UpsertCompanyStatusRequestAffiliate upsertCompanyStatusRequestAffiliate, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<CompanyViewAffiliate> localVarReturnType = new ParameterizedTypeReference<CompanyViewAffiliate>(this){};
        return this.updateCompany1RequestCreation(companyIdentifier, upsertCompanyStatusRequestAffiliate, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<CompanyViewAffiliate>> updateCompany1WithHttpInfo(String companyIdentifier, UpsertCompanyStatusRequestAffiliate upsertCompanyStatusRequestAffiliate, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<CompanyViewAffiliate> localVarReturnType = new ParameterizedTypeReference<CompanyViewAffiliate>(this){};
        return this.updateCompany1RequestCreation(companyIdentifier, upsertCompanyStatusRequestAffiliate, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec updateCompany1WithResponseSpec(String companyIdentifier, UpsertCompanyStatusRequestAffiliate upsertCompanyStatusRequestAffiliate, String winkVersion) throws WebClientResponseException {
        return this.updateCompany1RequestCreation(companyIdentifier, upsertCompanyStatusRequestAffiliate, winkVersion);
    }
}

