/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.affiliate.api;

import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import reactor.core.publisher.Mono;
import travel.wink.sdk.affiliate.invoker.ApiClient;
import travel.wink.sdk.affiliate.model.InvoiceAffiliate;
import travel.wink.sdk.affiliate.model.InvoiceCollectionAffiliate;
import travel.wink.sdk.affiliate.model.InvoiceLineItemCollectionAffiliate;

public class InvoiceApi {
    private ApiClient apiClient;

    public InvoiceApi() {
        this(new ApiClient());
    }

    @Autowired
    public InvoiceApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    private WebClient.ResponseSpec showInvoicesForCompanyCustomerRequestCreation(String companyIdentifier, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling showInvoicesForCompanyCustomer", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("companyIdentifier", companyIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<InvoiceCollectionAffiliate> localVarReturnType = new ParameterizedTypeReference<InvoiceCollectionAffiliate>(this){};
        return this.apiClient.invokeAPI("/api/company/{companyIdentifier}/marketplace/customer/invoice/list", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<InvoiceCollectionAffiliate> showInvoicesForCompanyCustomer(String companyIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<InvoiceCollectionAffiliate> localVarReturnType = new ParameterizedTypeReference<InvoiceCollectionAffiliate>(this){};
        return this.showInvoicesForCompanyCustomerRequestCreation(companyIdentifier, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<InvoiceCollectionAffiliate>> showInvoicesForCompanyCustomerWithHttpInfo(String companyIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<InvoiceCollectionAffiliate> localVarReturnType = new ParameterizedTypeReference<InvoiceCollectionAffiliate>(this){};
        return this.showInvoicesForCompanyCustomerRequestCreation(companyIdentifier, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showInvoicesForCompanyCustomerWithResponseSpec(String companyIdentifier, String winkVersion) throws WebClientResponseException {
        return this.showInvoicesForCompanyCustomerRequestCreation(companyIdentifier, winkVersion);
    }

    private WebClient.ResponseSpec showUpcomingInvoiceForCompanyCustomerRequestCreation(String companyIdentifier, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling showUpcomingInvoiceForCompanyCustomer", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("companyIdentifier", companyIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<InvoiceAffiliate> localVarReturnType = new ParameterizedTypeReference<InvoiceAffiliate>(this){};
        return this.apiClient.invokeAPI("/api/company/{companyIdentifier}/marketplace/customer/invoice/upcoming", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<InvoiceAffiliate> showUpcomingInvoiceForCompanyCustomer(String companyIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<InvoiceAffiliate> localVarReturnType = new ParameterizedTypeReference<InvoiceAffiliate>(this){};
        return this.showUpcomingInvoiceForCompanyCustomerRequestCreation(companyIdentifier, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<InvoiceAffiliate>> showUpcomingInvoiceForCompanyCustomerWithHttpInfo(String companyIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<InvoiceAffiliate> localVarReturnType = new ParameterizedTypeReference<InvoiceAffiliate>(this){};
        return this.showUpcomingInvoiceForCompanyCustomerRequestCreation(companyIdentifier, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showUpcomingInvoiceForCompanyCustomerWithResponseSpec(String companyIdentifier, String winkVersion) throws WebClientResponseException {
        return this.showUpcomingInvoiceForCompanyCustomerRequestCreation(companyIdentifier, winkVersion);
    }

    private WebClient.ResponseSpec showUpcomingInvoiceLineItemsForCompanyCustomerRequestCreation(String companyIdentifier, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling showUpcomingInvoiceLineItemsForCompanyCustomer", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("companyIdentifier", companyIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<InvoiceLineItemCollectionAffiliate> localVarReturnType = new ParameterizedTypeReference<InvoiceLineItemCollectionAffiliate>(this){};
        return this.apiClient.invokeAPI("/api/company/{companyIdentifier}/marketplace/customer/invoice/upcoming/items", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<InvoiceLineItemCollectionAffiliate> showUpcomingInvoiceLineItemsForCompanyCustomer(String companyIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<InvoiceLineItemCollectionAffiliate> localVarReturnType = new ParameterizedTypeReference<InvoiceLineItemCollectionAffiliate>(this){};
        return this.showUpcomingInvoiceLineItemsForCompanyCustomerRequestCreation(companyIdentifier, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<InvoiceLineItemCollectionAffiliate>> showUpcomingInvoiceLineItemsForCompanyCustomerWithHttpInfo(String companyIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<InvoiceLineItemCollectionAffiliate> localVarReturnType = new ParameterizedTypeReference<InvoiceLineItemCollectionAffiliate>(this){};
        return this.showUpcomingInvoiceLineItemsForCompanyCustomerRequestCreation(companyIdentifier, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showUpcomingInvoiceLineItemsForCompanyCustomerWithResponseSpec(String companyIdentifier, String winkVersion) throws WebClientResponseException {
        return this.showUpcomingInvoiceLineItemsForCompanyCustomerRequestCreation(companyIdentifier, winkVersion);
    }
}

