/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.affiliate.api;

import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import travel.wink.sdk.affiliate.invoker.ApiClient;
import travel.wink.sdk.affiliate.model.BooleanResponseAffiliate;
import travel.wink.sdk.affiliate.model.CreateSupplierUrlSyndicationEntryRequestAffiliate;
import travel.wink.sdk.affiliate.model.RemoveEntryResponseAffiliate;
import travel.wink.sdk.affiliate.model.SupplierUrlViewAffiliate;
import travel.wink.sdk.affiliate.model.UpsertSupplierUrlRequestAffiliate;

public class SupplierLinksApi {
    private ApiClient apiClient;

    public SupplierLinksApi() {
        this(new ApiClient());
    }

    @Autowired
    public SupplierLinksApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    private WebClient.ResponseSpec createSupplierUrlRequestCreation(String companyIdentifier, UpsertSupplierUrlRequestAffiliate upsertSupplierUrlRequestAffiliate, String winkVersion) throws WebClientResponseException {
        UpsertSupplierUrlRequestAffiliate postBody = upsertSupplierUrlRequestAffiliate;
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling createSupplierUrl", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (upsertSupplierUrlRequestAffiliate == null) {
            throw new WebClientResponseException("Missing the required parameter 'upsertSupplierUrlRequestAffiliate' when calling createSupplierUrl", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("companyIdentifier", companyIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<SupplierUrlViewAffiliate> localVarReturnType = new ParameterizedTypeReference<SupplierUrlViewAffiliate>(this){};
        return this.apiClient.invokeAPI("/api/company/{companyIdentifier}/supplier-url", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<SupplierUrlViewAffiliate> createSupplierUrl(String companyIdentifier, UpsertSupplierUrlRequestAffiliate upsertSupplierUrlRequestAffiliate, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<SupplierUrlViewAffiliate> localVarReturnType = new ParameterizedTypeReference<SupplierUrlViewAffiliate>(this){};
        return this.createSupplierUrlRequestCreation(companyIdentifier, upsertSupplierUrlRequestAffiliate, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<SupplierUrlViewAffiliate>> createSupplierUrlWithHttpInfo(String companyIdentifier, UpsertSupplierUrlRequestAffiliate upsertSupplierUrlRequestAffiliate, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<SupplierUrlViewAffiliate> localVarReturnType = new ParameterizedTypeReference<SupplierUrlViewAffiliate>(this){};
        return this.createSupplierUrlRequestCreation(companyIdentifier, upsertSupplierUrlRequestAffiliate, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec createSupplierUrlWithResponseSpec(String companyIdentifier, UpsertSupplierUrlRequestAffiliate upsertSupplierUrlRequestAffiliate, String winkVersion) throws WebClientResponseException {
        return this.createSupplierUrlRequestCreation(companyIdentifier, upsertSupplierUrlRequestAffiliate, winkVersion);
    }

    private WebClient.ResponseSpec createSupplierUrlSyndicationEntryRequestCreation(String companyIdentifier, CreateSupplierUrlSyndicationEntryRequestAffiliate createSupplierUrlSyndicationEntryRequestAffiliate, String winkVersion) throws WebClientResponseException {
        CreateSupplierUrlSyndicationEntryRequestAffiliate postBody = createSupplierUrlSyndicationEntryRequestAffiliate;
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling createSupplierUrlSyndicationEntry", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (createSupplierUrlSyndicationEntryRequestAffiliate == null) {
            throw new WebClientResponseException("Missing the required parameter 'createSupplierUrlSyndicationEntryRequestAffiliate' when calling createSupplierUrlSyndicationEntry", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("companyIdentifier", companyIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<BooleanResponseAffiliate> localVarReturnType = new ParameterizedTypeReference<BooleanResponseAffiliate>(this){};
        return this.apiClient.invokeAPI("/api/company/{companyIdentifier}/supplier-url/syndication/entry", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<BooleanResponseAffiliate> createSupplierUrlSyndicationEntry(String companyIdentifier, CreateSupplierUrlSyndicationEntryRequestAffiliate createSupplierUrlSyndicationEntryRequestAffiliate, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<BooleanResponseAffiliate> localVarReturnType = new ParameterizedTypeReference<BooleanResponseAffiliate>(this){};
        return this.createSupplierUrlSyndicationEntryRequestCreation(companyIdentifier, createSupplierUrlSyndicationEntryRequestAffiliate, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<BooleanResponseAffiliate>> createSupplierUrlSyndicationEntryWithHttpInfo(String companyIdentifier, CreateSupplierUrlSyndicationEntryRequestAffiliate createSupplierUrlSyndicationEntryRequestAffiliate, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<BooleanResponseAffiliate> localVarReturnType = new ParameterizedTypeReference<BooleanResponseAffiliate>(this){};
        return this.createSupplierUrlSyndicationEntryRequestCreation(companyIdentifier, createSupplierUrlSyndicationEntryRequestAffiliate, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec createSupplierUrlSyndicationEntryWithResponseSpec(String companyIdentifier, CreateSupplierUrlSyndicationEntryRequestAffiliate createSupplierUrlSyndicationEntryRequestAffiliate, String winkVersion) throws WebClientResponseException {
        return this.createSupplierUrlSyndicationEntryRequestCreation(companyIdentifier, createSupplierUrlSyndicationEntryRequestAffiliate, winkVersion);
    }

    private WebClient.ResponseSpec removeSupplierUrlRequestCreation(String companyIdentifier, String supplierUrlIdentifier, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling removeSupplierUrl", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (supplierUrlIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'supplierUrlIdentifier' when calling removeSupplierUrl", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("companyIdentifier", companyIdentifier);
        pathParams.put("supplierUrlIdentifier", supplierUrlIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<RemoveEntryResponseAffiliate> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponseAffiliate>(this){};
        return this.apiClient.invokeAPI("/api/company/{companyIdentifier}/supplier-url/{supplierUrlIdentifier}", HttpMethod.DELETE, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<RemoveEntryResponseAffiliate> removeSupplierUrl(String companyIdentifier, String supplierUrlIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<RemoveEntryResponseAffiliate> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponseAffiliate>(this){};
        return this.removeSupplierUrlRequestCreation(companyIdentifier, supplierUrlIdentifier, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<RemoveEntryResponseAffiliate>> removeSupplierUrlWithHttpInfo(String companyIdentifier, String supplierUrlIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<RemoveEntryResponseAffiliate> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponseAffiliate>(this){};
        return this.removeSupplierUrlRequestCreation(companyIdentifier, supplierUrlIdentifier, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec removeSupplierUrlWithResponseSpec(String companyIdentifier, String supplierUrlIdentifier, String winkVersion) throws WebClientResponseException {
        return this.removeSupplierUrlRequestCreation(companyIdentifier, supplierUrlIdentifier, winkVersion);
    }

    private WebClient.ResponseSpec showSupplierUrlRequestCreation(String companyIdentifier, String supplierUrlIdentifier, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling showSupplierUrl", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (supplierUrlIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'supplierUrlIdentifier' when calling showSupplierUrl", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("companyIdentifier", companyIdentifier);
        pathParams.put("supplierUrlIdentifier", supplierUrlIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<SupplierUrlViewAffiliate> localVarReturnType = new ParameterizedTypeReference<SupplierUrlViewAffiliate>(this){};
        return this.apiClient.invokeAPI("/api/company/{companyIdentifier}/supplier-url/{supplierUrlIdentifier}", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<SupplierUrlViewAffiliate> showSupplierUrl(String companyIdentifier, String supplierUrlIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<SupplierUrlViewAffiliate> localVarReturnType = new ParameterizedTypeReference<SupplierUrlViewAffiliate>(this){};
        return this.showSupplierUrlRequestCreation(companyIdentifier, supplierUrlIdentifier, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<SupplierUrlViewAffiliate>> showSupplierUrlWithHttpInfo(String companyIdentifier, String supplierUrlIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<SupplierUrlViewAffiliate> localVarReturnType = new ParameterizedTypeReference<SupplierUrlViewAffiliate>(this){};
        return this.showSupplierUrlRequestCreation(companyIdentifier, supplierUrlIdentifier, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showSupplierUrlWithResponseSpec(String companyIdentifier, String supplierUrlIdentifier, String winkVersion) throws WebClientResponseException {
        return this.showSupplierUrlRequestCreation(companyIdentifier, supplierUrlIdentifier, winkVersion);
    }

    private WebClient.ResponseSpec showSupplierUrlsRequestCreation(String companyIdentifier, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling showSupplierUrls", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("companyIdentifier", companyIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<SupplierUrlViewAffiliate> localVarReturnType = new ParameterizedTypeReference<SupplierUrlViewAffiliate>(this){};
        return this.apiClient.invokeAPI("/api/company/{companyIdentifier}/supplier-url/list", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Flux<SupplierUrlViewAffiliate> showSupplierUrls(String companyIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<SupplierUrlViewAffiliate> localVarReturnType = new ParameterizedTypeReference<SupplierUrlViewAffiliate>(this){};
        return this.showSupplierUrlsRequestCreation(companyIdentifier, winkVersion).bodyToFlux((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<List<SupplierUrlViewAffiliate>>> showSupplierUrlsWithHttpInfo(String companyIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<SupplierUrlViewAffiliate> localVarReturnType = new ParameterizedTypeReference<SupplierUrlViewAffiliate>(this){};
        return this.showSupplierUrlsRequestCreation(companyIdentifier, winkVersion).toEntityList((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showSupplierUrlsWithResponseSpec(String companyIdentifier, String winkVersion) throws WebClientResponseException {
        return this.showSupplierUrlsRequestCreation(companyIdentifier, winkVersion);
    }

    private WebClient.ResponseSpec updateSupplierUrlRequestCreation(String companyIdentifier, String supplierUrlIdentifier, UpsertSupplierUrlRequestAffiliate upsertSupplierUrlRequestAffiliate, String winkVersion) throws WebClientResponseException {
        UpsertSupplierUrlRequestAffiliate postBody = upsertSupplierUrlRequestAffiliate;
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling updateSupplierUrl", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (supplierUrlIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'supplierUrlIdentifier' when calling updateSupplierUrl", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (upsertSupplierUrlRequestAffiliate == null) {
            throw new WebClientResponseException("Missing the required parameter 'upsertSupplierUrlRequestAffiliate' when calling updateSupplierUrl", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("companyIdentifier", companyIdentifier);
        pathParams.put("supplierUrlIdentifier", supplierUrlIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"application/json", "application/xml", "text/xml", "text/plain", "*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<SupplierUrlViewAffiliate> localVarReturnType = new ParameterizedTypeReference<SupplierUrlViewAffiliate>(this){};
        return this.apiClient.invokeAPI("/api/company/{companyIdentifier}/supplier-url/{supplierUrlIdentifier}", HttpMethod.PUT, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<SupplierUrlViewAffiliate> updateSupplierUrl(String companyIdentifier, String supplierUrlIdentifier, UpsertSupplierUrlRequestAffiliate upsertSupplierUrlRequestAffiliate, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<SupplierUrlViewAffiliate> localVarReturnType = new ParameterizedTypeReference<SupplierUrlViewAffiliate>(this){};
        return this.updateSupplierUrlRequestCreation(companyIdentifier, supplierUrlIdentifier, upsertSupplierUrlRequestAffiliate, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<SupplierUrlViewAffiliate>> updateSupplierUrlWithHttpInfo(String companyIdentifier, String supplierUrlIdentifier, UpsertSupplierUrlRequestAffiliate upsertSupplierUrlRequestAffiliate, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<SupplierUrlViewAffiliate> localVarReturnType = new ParameterizedTypeReference<SupplierUrlViewAffiliate>(this){};
        return this.updateSupplierUrlRequestCreation(companyIdentifier, supplierUrlIdentifier, upsertSupplierUrlRequestAffiliate, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec updateSupplierUrlWithResponseSpec(String companyIdentifier, String supplierUrlIdentifier, UpsertSupplierUrlRequestAffiliate upsertSupplierUrlRequestAffiliate, String winkVersion) throws WebClientResponseException {
        return this.updateSupplierUrlRequestCreation(companyIdentifier, supplierUrlIdentifier, upsertSupplierUrlRequestAffiliate, winkVersion);
    }
}

