package travel.wink.sdk.affiliate.api;

import travel.wink.sdk.affiliate.invoker.ApiClient;

import travel.wink.sdk.affiliate.model.GenericErrorMessage;
import travel.wink.sdk.affiliate.model.GooglePlaceDetailRequestAffiliate;
import travel.wink.sdk.affiliate.model.ShowSupplierUrl400Response;
import travel.wink.sdk.affiliate.model.SupplierLeadAffiliate;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.web.reactive.function.client.WebClient.ResponseSpec;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Flux;

@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-04-25T09:02:36.114206089+07:00[Asia/Bangkok]")
public class AffiliateLeadApi {
    private ApiClient apiClient;

    public AffiliateLeadApi() {
        this(new ApiClient());
    }

    @Autowired
    public AffiliateLeadApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Create lead
     * Creates a new supplier lead based on information retrieved from Google Places
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>201</b> - Created
     * @param companyIdentifier Create lead by this owner identifier.
     * @param googlePlaceDetailRequestAffiliate The googlePlaceDetailRequestAffiliate parameter
     * @param winkVersion The winkVersion parameter
     * @return SupplierLeadAffiliate
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec createLeadRequestCreation(String companyIdentifier, GooglePlaceDetailRequestAffiliate googlePlaceDetailRequestAffiliate, String winkVersion) throws WebClientResponseException {
        Object postBody = googlePlaceDetailRequestAffiliate;
        // verify the required parameter 'companyIdentifier' is set
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling createLead", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'googlePlaceDetailRequestAffiliate' is set
        if (googlePlaceDetailRequestAffiliate == null) {
            throw new WebClientResponseException("Missing the required parameter 'googlePlaceDetailRequestAffiliate' when calling createLead", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("companyIdentifier", companyIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<SupplierLeadAffiliate> localVarReturnType = new ParameterizedTypeReference<SupplierLeadAffiliate>() {};
        return apiClient.invokeAPI("/api/company/{companyIdentifier}/lead", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Create lead
     * Creates a new supplier lead based on information retrieved from Google Places
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>201</b> - Created
     * @param companyIdentifier Create lead by this owner identifier.
     * @param googlePlaceDetailRequestAffiliate The googlePlaceDetailRequestAffiliate parameter
     * @param winkVersion The winkVersion parameter
     * @return SupplierLeadAffiliate
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<SupplierLeadAffiliate> createLead(String companyIdentifier, GooglePlaceDetailRequestAffiliate googlePlaceDetailRequestAffiliate, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<SupplierLeadAffiliate> localVarReturnType = new ParameterizedTypeReference<SupplierLeadAffiliate>() {};
        return createLeadRequestCreation(companyIdentifier, googlePlaceDetailRequestAffiliate, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Create lead
     * Creates a new supplier lead based on information retrieved from Google Places
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>201</b> - Created
     * @param companyIdentifier Create lead by this owner identifier.
     * @param googlePlaceDetailRequestAffiliate The googlePlaceDetailRequestAffiliate parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;SupplierLeadAffiliate&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<SupplierLeadAffiliate>> createLeadWithHttpInfo(String companyIdentifier, GooglePlaceDetailRequestAffiliate googlePlaceDetailRequestAffiliate, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<SupplierLeadAffiliate> localVarReturnType = new ParameterizedTypeReference<SupplierLeadAffiliate>() {};
        return createLeadRequestCreation(companyIdentifier, googlePlaceDetailRequestAffiliate, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Create lead
     * Creates a new supplier lead based on information retrieved from Google Places
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>201</b> - Created
     * @param companyIdentifier Create lead by this owner identifier.
     * @param googlePlaceDetailRequestAffiliate The googlePlaceDetailRequestAffiliate parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec createLeadWithResponseSpec(String companyIdentifier, GooglePlaceDetailRequestAffiliate googlePlaceDetailRequestAffiliate, String winkVersion) throws WebClientResponseException {
        return createLeadRequestCreation(companyIdentifier, googlePlaceDetailRequestAffiliate, winkVersion);
    }
}
