package travel.wink.sdk.affiliate.api;

import travel.wink.sdk.affiliate.invoker.ApiClient;

import travel.wink.sdk.affiliate.model.BooleanResponseAffiliate;
import travel.wink.sdk.affiliate.model.CreateSellerUrlSyndicationEntryRequestAffiliate;
import travel.wink.sdk.affiliate.model.GenericErrorMessage;
import travel.wink.sdk.affiliate.model.RemoveEntryResponseAffiliate;
import travel.wink.sdk.affiliate.model.SellerUrlViewAffiliate;
import travel.wink.sdk.affiliate.model.ShowSupplierUrl400Response;
import travel.wink.sdk.affiliate.model.SimpleMultimediaAffiliate;
import travel.wink.sdk.affiliate.model.UpsertSellerUrlRequestAffiliate;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.web.reactive.function.client.WebClient.ResponseSpec;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Flux;

@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-04-25T09:02:36.114206089+07:00[Asia/Bangkok]")
public class ShareableLinksApi {
    private ApiClient apiClient;

    public ShareableLinksApi() {
        this(new ApiClient());
    }

    @Autowired
    public ShareableLinksApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Create Link
     * Create a new shareable link
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>201</b> - Created
     * @param companyIdentifier Create link owned by this owner identifier.
     * @param upsertSellerUrlRequestAffiliate The upsertSellerUrlRequestAffiliate parameter
     * @param winkVersion The winkVersion parameter
     * @return SellerUrlViewAffiliate
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec createSellerUrlRequestCreation(String companyIdentifier, UpsertSellerUrlRequestAffiliate upsertSellerUrlRequestAffiliate, String winkVersion) throws WebClientResponseException {
        Object postBody = upsertSellerUrlRequestAffiliate;
        // verify the required parameter 'companyIdentifier' is set
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling createSellerUrl", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'upsertSellerUrlRequestAffiliate' is set
        if (upsertSellerUrlRequestAffiliate == null) {
            throw new WebClientResponseException("Missing the required parameter 'upsertSellerUrlRequestAffiliate' when calling createSellerUrl", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("companyIdentifier", companyIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<SellerUrlViewAffiliate> localVarReturnType = new ParameterizedTypeReference<SellerUrlViewAffiliate>() {};
        return apiClient.invokeAPI("/api/company/{companyIdentifier}/seller-url", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Create Link
     * Create a new shareable link
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>201</b> - Created
     * @param companyIdentifier Create link owned by this owner identifier.
     * @param upsertSellerUrlRequestAffiliate The upsertSellerUrlRequestAffiliate parameter
     * @param winkVersion The winkVersion parameter
     * @return SellerUrlViewAffiliate
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<SellerUrlViewAffiliate> createSellerUrl(String companyIdentifier, UpsertSellerUrlRequestAffiliate upsertSellerUrlRequestAffiliate, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<SellerUrlViewAffiliate> localVarReturnType = new ParameterizedTypeReference<SellerUrlViewAffiliate>() {};
        return createSellerUrlRequestCreation(companyIdentifier, upsertSellerUrlRequestAffiliate, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Create Link
     * Create a new shareable link
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>201</b> - Created
     * @param companyIdentifier Create link owned by this owner identifier.
     * @param upsertSellerUrlRequestAffiliate The upsertSellerUrlRequestAffiliate parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;SellerUrlViewAffiliate&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<SellerUrlViewAffiliate>> createSellerUrlWithHttpInfo(String companyIdentifier, UpsertSellerUrlRequestAffiliate upsertSellerUrlRequestAffiliate, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<SellerUrlViewAffiliate> localVarReturnType = new ParameterizedTypeReference<SellerUrlViewAffiliate>() {};
        return createSellerUrlRequestCreation(companyIdentifier, upsertSellerUrlRequestAffiliate, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Create Link
     * Create a new shareable link
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>201</b> - Created
     * @param companyIdentifier Create link owned by this owner identifier.
     * @param upsertSellerUrlRequestAffiliate The upsertSellerUrlRequestAffiliate parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec createSellerUrlWithResponseSpec(String companyIdentifier, UpsertSellerUrlRequestAffiliate upsertSellerUrlRequestAffiliate, String winkVersion) throws WebClientResponseException {
        return createSellerUrlRequestCreation(companyIdentifier, upsertSellerUrlRequestAffiliate, winkVersion);
    }
    /**
     * Create Seller URL SyndicationCard
     * Creates a new WinkLinks card.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>201</b> - Created
     * @param companyIdentifier Company identifier to create item for
     * @param createSellerUrlSyndicationEntryRequestAffiliate The createSellerUrlSyndicationEntryRequestAffiliate parameter
     * @param winkVersion The winkVersion parameter
     * @return BooleanResponseAffiliate
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec createSupplierUrlSyndicationEntry1RequestCreation(String companyIdentifier, CreateSellerUrlSyndicationEntryRequestAffiliate createSellerUrlSyndicationEntryRequestAffiliate, String winkVersion) throws WebClientResponseException {
        Object postBody = createSellerUrlSyndicationEntryRequestAffiliate;
        // verify the required parameter 'companyIdentifier' is set
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling createSupplierUrlSyndicationEntry1", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'createSellerUrlSyndicationEntryRequestAffiliate' is set
        if (createSellerUrlSyndicationEntryRequestAffiliate == null) {
            throw new WebClientResponseException("Missing the required parameter 'createSellerUrlSyndicationEntryRequestAffiliate' when calling createSupplierUrlSyndicationEntry1", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("companyIdentifier", companyIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<BooleanResponseAffiliate> localVarReturnType = new ParameterizedTypeReference<BooleanResponseAffiliate>() {};
        return apiClient.invokeAPI("/api/company/{companyIdentifier}/seller-url/syndication/entry", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Create Seller URL SyndicationCard
     * Creates a new WinkLinks card.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>201</b> - Created
     * @param companyIdentifier Company identifier to create item for
     * @param createSellerUrlSyndicationEntryRequestAffiliate The createSellerUrlSyndicationEntryRequestAffiliate parameter
     * @param winkVersion The winkVersion parameter
     * @return BooleanResponseAffiliate
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<BooleanResponseAffiliate> createSupplierUrlSyndicationEntry1(String companyIdentifier, CreateSellerUrlSyndicationEntryRequestAffiliate createSellerUrlSyndicationEntryRequestAffiliate, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<BooleanResponseAffiliate> localVarReturnType = new ParameterizedTypeReference<BooleanResponseAffiliate>() {};
        return createSupplierUrlSyndicationEntry1RequestCreation(companyIdentifier, createSellerUrlSyndicationEntryRequestAffiliate, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Create Seller URL SyndicationCard
     * Creates a new WinkLinks card.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>201</b> - Created
     * @param companyIdentifier Company identifier to create item for
     * @param createSellerUrlSyndicationEntryRequestAffiliate The createSellerUrlSyndicationEntryRequestAffiliate parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;BooleanResponseAffiliate&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<BooleanResponseAffiliate>> createSupplierUrlSyndicationEntry1WithHttpInfo(String companyIdentifier, CreateSellerUrlSyndicationEntryRequestAffiliate createSellerUrlSyndicationEntryRequestAffiliate, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<BooleanResponseAffiliate> localVarReturnType = new ParameterizedTypeReference<BooleanResponseAffiliate>() {};
        return createSupplierUrlSyndicationEntry1RequestCreation(companyIdentifier, createSellerUrlSyndicationEntryRequestAffiliate, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Create Seller URL SyndicationCard
     * Creates a new WinkLinks card.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>201</b> - Created
     * @param companyIdentifier Company identifier to create item for
     * @param createSellerUrlSyndicationEntryRequestAffiliate The createSellerUrlSyndicationEntryRequestAffiliate parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec createSupplierUrlSyndicationEntry1WithResponseSpec(String companyIdentifier, CreateSellerUrlSyndicationEntryRequestAffiliate createSellerUrlSyndicationEntryRequestAffiliate, String winkVersion) throws WebClientResponseException {
        return createSupplierUrlSyndicationEntry1RequestCreation(companyIdentifier, createSellerUrlSyndicationEntryRequestAffiliate, winkVersion);
    }
    /**
     * Delete Link
     * Delete a shareable link
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>202</b> - Accepted
     * @param companyIdentifier Remove link owned by this owner identifier.
     * @param sellerUrlIdentifier Remove url with this identifier.
     * @param winkVersion The winkVersion parameter
     * @return RemoveEntryResponseAffiliate
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec removeSellerUrlRequestCreation(String companyIdentifier, String sellerUrlIdentifier, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'companyIdentifier' is set
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling removeSellerUrl", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'sellerUrlIdentifier' is set
        if (sellerUrlIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'sellerUrlIdentifier' when calling removeSellerUrl", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("companyIdentifier", companyIdentifier);
        pathParams.put("sellerUrlIdentifier", sellerUrlIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<RemoveEntryResponseAffiliate> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponseAffiliate>() {};
        return apiClient.invokeAPI("/api/company/{companyIdentifier}/seller-url/{sellerUrlIdentifier}", HttpMethod.DELETE, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Delete Link
     * Delete a shareable link
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>202</b> - Accepted
     * @param companyIdentifier Remove link owned by this owner identifier.
     * @param sellerUrlIdentifier Remove url with this identifier.
     * @param winkVersion The winkVersion parameter
     * @return RemoveEntryResponseAffiliate
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<RemoveEntryResponseAffiliate> removeSellerUrl(String companyIdentifier, String sellerUrlIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<RemoveEntryResponseAffiliate> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponseAffiliate>() {};
        return removeSellerUrlRequestCreation(companyIdentifier, sellerUrlIdentifier, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Delete Link
     * Delete a shareable link
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>202</b> - Accepted
     * @param companyIdentifier Remove link owned by this owner identifier.
     * @param sellerUrlIdentifier Remove url with this identifier.
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;RemoveEntryResponseAffiliate&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<RemoveEntryResponseAffiliate>> removeSellerUrlWithHttpInfo(String companyIdentifier, String sellerUrlIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<RemoveEntryResponseAffiliate> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponseAffiliate>() {};
        return removeSellerUrlRequestCreation(companyIdentifier, sellerUrlIdentifier, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Delete Link
     * Delete a shareable link
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>202</b> - Accepted
     * @param companyIdentifier Remove link owned by this owner identifier.
     * @param sellerUrlIdentifier Remove url with this identifier.
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec removeSellerUrlWithResponseSpec(String companyIdentifier, String sellerUrlIdentifier, String winkVersion) throws WebClientResponseException {
        return removeSellerUrlRequestCreation(companyIdentifier, sellerUrlIdentifier, winkVersion);
    }
    /**
     * Show Inventory Media
     * Retrieve a list of media for this channel inventory identifier
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier Owner identifier.
     * @param channelInventoryIdentifier Channel inventory identifier.
     * @param winkVersion The winkVersion parameter
     * @return List&lt;SimpleMultimediaAffiliate&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showInventoryMediaRequestCreation(String companyIdentifier, String channelInventoryIdentifier, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'companyIdentifier' is set
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling showInventoryMedia", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'channelInventoryIdentifier' is set
        if (channelInventoryIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'channelInventoryIdentifier' when calling showInventoryMedia", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("companyIdentifier", companyIdentifier);
        pathParams.put("channelInventoryIdentifier", channelInventoryIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<SimpleMultimediaAffiliate> localVarReturnType = new ParameterizedTypeReference<SimpleMultimediaAffiliate>() {};
        return apiClient.invokeAPI("/api/company/{companyIdentifier}/seller-url/inventory/{channelInventoryIdentifier}/media/list", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Inventory Media
     * Retrieve a list of media for this channel inventory identifier
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier Owner identifier.
     * @param channelInventoryIdentifier Channel inventory identifier.
     * @param winkVersion The winkVersion parameter
     * @return List&lt;SimpleMultimediaAffiliate&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Flux<SimpleMultimediaAffiliate> showInventoryMedia(String companyIdentifier, String channelInventoryIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<SimpleMultimediaAffiliate> localVarReturnType = new ParameterizedTypeReference<SimpleMultimediaAffiliate>() {};
        return showInventoryMediaRequestCreation(companyIdentifier, channelInventoryIdentifier, winkVersion).bodyToFlux(localVarReturnType);
    }

    /**
     * Show Inventory Media
     * Retrieve a list of media for this channel inventory identifier
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier Owner identifier.
     * @param channelInventoryIdentifier Channel inventory identifier.
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;List&lt;SimpleMultimediaAffiliate&gt;&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<List<SimpleMultimediaAffiliate>>> showInventoryMediaWithHttpInfo(String companyIdentifier, String channelInventoryIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<SimpleMultimediaAffiliate> localVarReturnType = new ParameterizedTypeReference<SimpleMultimediaAffiliate>() {};
        return showInventoryMediaRequestCreation(companyIdentifier, channelInventoryIdentifier, winkVersion).toEntityList(localVarReturnType);
    }

    /**
     * Show Inventory Media
     * Retrieve a list of media for this channel inventory identifier
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier Owner identifier.
     * @param channelInventoryIdentifier Channel inventory identifier.
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec showInventoryMediaWithResponseSpec(String companyIdentifier, String channelInventoryIdentifier, String winkVersion) throws WebClientResponseException {
        return showInventoryMediaRequestCreation(companyIdentifier, channelInventoryIdentifier, winkVersion);
    }
    /**
     * Show Link
     * Retrieve a specific shareable url for this seller
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier Show link owned by this owner identifier.
     * @param sellerUrlIdentifier Show link with this identifier.
     * @param winkVersion The winkVersion parameter
     * @return SellerUrlViewAffiliate
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showSellerUrlRequestCreation(String companyIdentifier, String sellerUrlIdentifier, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'companyIdentifier' is set
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling showSellerUrl", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'sellerUrlIdentifier' is set
        if (sellerUrlIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'sellerUrlIdentifier' when calling showSellerUrl", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("companyIdentifier", companyIdentifier);
        pathParams.put("sellerUrlIdentifier", sellerUrlIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<SellerUrlViewAffiliate> localVarReturnType = new ParameterizedTypeReference<SellerUrlViewAffiliate>() {};
        return apiClient.invokeAPI("/api/company/{companyIdentifier}/seller-url/{sellerUrlIdentifier}", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Link
     * Retrieve a specific shareable url for this seller
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier Show link owned by this owner identifier.
     * @param sellerUrlIdentifier Show link with this identifier.
     * @param winkVersion The winkVersion parameter
     * @return SellerUrlViewAffiliate
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<SellerUrlViewAffiliate> showSellerUrl(String companyIdentifier, String sellerUrlIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<SellerUrlViewAffiliate> localVarReturnType = new ParameterizedTypeReference<SellerUrlViewAffiliate>() {};
        return showSellerUrlRequestCreation(companyIdentifier, sellerUrlIdentifier, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Show Link
     * Retrieve a specific shareable url for this seller
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier Show link owned by this owner identifier.
     * @param sellerUrlIdentifier Show link with this identifier.
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;SellerUrlViewAffiliate&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<SellerUrlViewAffiliate>> showSellerUrlWithHttpInfo(String companyIdentifier, String sellerUrlIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<SellerUrlViewAffiliate> localVarReturnType = new ParameterizedTypeReference<SellerUrlViewAffiliate>() {};
        return showSellerUrlRequestCreation(companyIdentifier, sellerUrlIdentifier, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Show Link
     * Retrieve a specific shareable url for this seller
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier Show link owned by this owner identifier.
     * @param sellerUrlIdentifier Show link with this identifier.
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec showSellerUrlWithResponseSpec(String companyIdentifier, String sellerUrlIdentifier, String winkVersion) throws WebClientResponseException {
        return showSellerUrlRequestCreation(companyIdentifier, sellerUrlIdentifier, winkVersion);
    }
    /**
     * Show Links
     * Retrieve list of shareable urls for this seller
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier Show links list owned by this owner identifier.
     * @param winkVersion The winkVersion parameter
     * @return List&lt;SellerUrlViewAffiliate&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showSellerUrlsRequestCreation(String companyIdentifier, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'companyIdentifier' is set
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling showSellerUrls", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("companyIdentifier", companyIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<SellerUrlViewAffiliate> localVarReturnType = new ParameterizedTypeReference<SellerUrlViewAffiliate>() {};
        return apiClient.invokeAPI("/api/company/{companyIdentifier}/seller-url/list", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Links
     * Retrieve list of shareable urls for this seller
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier Show links list owned by this owner identifier.
     * @param winkVersion The winkVersion parameter
     * @return List&lt;SellerUrlViewAffiliate&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Flux<SellerUrlViewAffiliate> showSellerUrls(String companyIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<SellerUrlViewAffiliate> localVarReturnType = new ParameterizedTypeReference<SellerUrlViewAffiliate>() {};
        return showSellerUrlsRequestCreation(companyIdentifier, winkVersion).bodyToFlux(localVarReturnType);
    }

    /**
     * Show Links
     * Retrieve list of shareable urls for this seller
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier Show links list owned by this owner identifier.
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;List&lt;SellerUrlViewAffiliate&gt;&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<List<SellerUrlViewAffiliate>>> showSellerUrlsWithHttpInfo(String companyIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<SellerUrlViewAffiliate> localVarReturnType = new ParameterizedTypeReference<SellerUrlViewAffiliate>() {};
        return showSellerUrlsRequestCreation(companyIdentifier, winkVersion).toEntityList(localVarReturnType);
    }

    /**
     * Show Links
     * Retrieve list of shareable urls for this seller
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier Show links list owned by this owner identifier.
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec showSellerUrlsWithResponseSpec(String companyIdentifier, String winkVersion) throws WebClientResponseException {
        return showSellerUrlsRequestCreation(companyIdentifier, winkVersion);
    }
    /**
     * Update link
     * Modify a shareable link
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier Update link owned by this owner identifier.
     * @param sellerUrlIdentifier Update url with this identifier.
     * @param upsertSellerUrlRequestAffiliate The upsertSellerUrlRequestAffiliate parameter
     * @param winkVersion The winkVersion parameter
     * @return SellerUrlViewAffiliate
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec updateSellerUrlRequestCreation(String companyIdentifier, String sellerUrlIdentifier, UpsertSellerUrlRequestAffiliate upsertSellerUrlRequestAffiliate, String winkVersion) throws WebClientResponseException {
        Object postBody = upsertSellerUrlRequestAffiliate;
        // verify the required parameter 'companyIdentifier' is set
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling updateSellerUrl", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'sellerUrlIdentifier' is set
        if (sellerUrlIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'sellerUrlIdentifier' when calling updateSellerUrl", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'upsertSellerUrlRequestAffiliate' is set
        if (upsertSellerUrlRequestAffiliate == null) {
            throw new WebClientResponseException("Missing the required parameter 'upsertSellerUrlRequestAffiliate' when calling updateSellerUrl", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("companyIdentifier", companyIdentifier);
        pathParams.put("sellerUrlIdentifier", sellerUrlIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<SellerUrlViewAffiliate> localVarReturnType = new ParameterizedTypeReference<SellerUrlViewAffiliate>() {};
        return apiClient.invokeAPI("/api/company/{companyIdentifier}/seller-url/{sellerUrlIdentifier}", HttpMethod.PUT, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Update link
     * Modify a shareable link
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier Update link owned by this owner identifier.
     * @param sellerUrlIdentifier Update url with this identifier.
     * @param upsertSellerUrlRequestAffiliate The upsertSellerUrlRequestAffiliate parameter
     * @param winkVersion The winkVersion parameter
     * @return SellerUrlViewAffiliate
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<SellerUrlViewAffiliate> updateSellerUrl(String companyIdentifier, String sellerUrlIdentifier, UpsertSellerUrlRequestAffiliate upsertSellerUrlRequestAffiliate, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<SellerUrlViewAffiliate> localVarReturnType = new ParameterizedTypeReference<SellerUrlViewAffiliate>() {};
        return updateSellerUrlRequestCreation(companyIdentifier, sellerUrlIdentifier, upsertSellerUrlRequestAffiliate, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Update link
     * Modify a shareable link
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier Update link owned by this owner identifier.
     * @param sellerUrlIdentifier Update url with this identifier.
     * @param upsertSellerUrlRequestAffiliate The upsertSellerUrlRequestAffiliate parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;SellerUrlViewAffiliate&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<SellerUrlViewAffiliate>> updateSellerUrlWithHttpInfo(String companyIdentifier, String sellerUrlIdentifier, UpsertSellerUrlRequestAffiliate upsertSellerUrlRequestAffiliate, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<SellerUrlViewAffiliate> localVarReturnType = new ParameterizedTypeReference<SellerUrlViewAffiliate>() {};
        return updateSellerUrlRequestCreation(companyIdentifier, sellerUrlIdentifier, upsertSellerUrlRequestAffiliate, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Update link
     * Modify a shareable link
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier Update link owned by this owner identifier.
     * @param sellerUrlIdentifier Update url with this identifier.
     * @param upsertSellerUrlRequestAffiliate The upsertSellerUrlRequestAffiliate parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec updateSellerUrlWithResponseSpec(String companyIdentifier, String sellerUrlIdentifier, UpsertSellerUrlRequestAffiliate upsertSellerUrlRequestAffiliate, String winkVersion) throws WebClientResponseException {
        return updateSellerUrlRequestCreation(companyIdentifier, sellerUrlIdentifier, upsertSellerUrlRequestAffiliate, winkVersion);
    }
}
