/*
 * Wink API
 * ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Affiliate](/affiliate): All APIs related to selling travel inventory as an affiliate. - [Analytics](/analytics): All APIs related to tracking metrics across a wide variety of data source segments including, more entertaining, leaderboard metrics. - [Booking](/booking): All APIs related to creating platform bookings. - [Channel Manager](/channel-manager): All APIs related to channel managers who want to integrate with our platform. - [Extranet](/extranet): All APIs related to managing travel inventory and suppliers. - [Inventory](/inventory): All APIs related to retrieve known travel inventory as it was found using the Lookup API.. - [Lookup](/lookup): All APIs related to locating inventory by region, locale and property flags. - [Reference](/reference): All APIs related to retrieving platform-supported taxonomies. - [TripPay](/payment): All APIs related to TripPay account management, booking, mapping and integration features.  ## SDKs We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).  - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)  ## Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Wink-Version` header. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints.  ## Release history - 2022-10-15: v2.0 - Removed HATEOAS and added Wink-Version header - 2022-05-08: v1 - Exposed channel manager API - 2021-07-01: v1 - Initial release  # Affiliate API Welcome to the Affiliate API - A programmer-friendly way to search for and display bespoke travel inventory for your audience. Use this API to help you prepare travel inventory for sale.  # Intended Audience Programmers are a requirement to start integrating with wink. You will benefit from an API integration if you are new or existing travel related company that want easy access to great inventory.## Examples: - Hotel brands / chains that want to make their own booking engine - Travel tech companies that want to create the next hot mobile travel app - Destination sites that want to make their own booking engine - Bloggers and influencers who want to sell travel inventory to their audience - OTAs that want access direct relationships with suppliers and better quality hotel inventory
 *
 * The version of the OpenAPI document: 29.58.0
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.affiliate.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.time.OffsetDateTime;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import travel.wink.sdk.affiliate.model.KeyValuePairAffiliate;
import travel.wink.sdk.affiliate.model.OpenGraphMediaAffiliate;
import travel.wink.sdk.affiliate.model.SimpleMultimediaAffiliate;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * SyndicationEntryAffiliate
 */
@JsonPropertyOrder({
  SyndicationEntryAffiliate.JSON_PROPERTY_ID,
  SyndicationEntryAffiliate.JSON_PROPERTY_CREATED_DATE,
  SyndicationEntryAffiliate.JSON_PROPERTY_LAST_UPDATE,
  SyndicationEntryAffiliate.JSON_PROPERTY_VERSION,
  SyndicationEntryAffiliate.JSON_PROPERTY_USER_IDENTIFIER,
  SyndicationEntryAffiliate.JSON_PROPERTY_OWNER_IDENTIFIER,
  SyndicationEntryAffiliate.JSON_PROPERTY_CONTENT_URL,
  SyndicationEntryAffiliate.JSON_PROPERTY_SORT,
  SyndicationEntryAffiliate.JSON_PROPERTY_STATUS,
  SyndicationEntryAffiliate.JSON_PROPERTY_TYPE,
  SyndicationEntryAffiliate.JSON_PROPERTY_IMAGE_LIST,
  SyndicationEntryAffiliate.JSON_PROPERTY_VIDEO_LIST,
  SyndicationEntryAffiliate.JSON_PROPERTY_AUDIO_LIST,
  SyndicationEntryAffiliate.JSON_PROPERTY_METADATA,
  SyndicationEntryAffiliate.JSON_PROPERTY_TITLE,
  SyndicationEntryAffiliate.JSON_PROPERTY_DESCRIPTION,
  SyndicationEntryAffiliate.JSON_PROPERTY_OG_TYPE,
  SyndicationEntryAffiliate.JSON_PROPERTY_TAGS,
  SyndicationEntryAffiliate.JSON_PROPERTY_MEDIA
})
@JsonTypeName("SyndicationEntry_Affiliate")
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-05-28T20:17:04.479259926+07:00[Asia/Bangkok]")
public class SyndicationEntryAffiliate {
  public static final String JSON_PROPERTY_ID = "id";
  private String id;

  public static final String JSON_PROPERTY_CREATED_DATE = "createdDate";
  private java.time.LocalDateTime createdDate;

  public static final String JSON_PROPERTY_LAST_UPDATE = "lastUpdate";
  private java.time.LocalDateTime lastUpdate;

  public static final String JSON_PROPERTY_VERSION = "version";
  private Long version;

  public static final String JSON_PROPERTY_USER_IDENTIFIER = "userIdentifier";
  private UUID userIdentifier;

  public static final String JSON_PROPERTY_OWNER_IDENTIFIER = "ownerIdentifier";
  private UUID ownerIdentifier;

  public static final String JSON_PROPERTY_CONTENT_URL = "contentUrl";
  private String contentUrl;

  public static final String JSON_PROPERTY_SORT = "sort";
  private Integer sort;

  /**
   * The syndication entry status
   */
  public enum StatusEnum {
    ACTIVE("ACTIVE"),
    
    INACTIVE("INACTIVE"),
    
    REMOVED("REMOVED");

    private String value;

    StatusEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static StatusEnum fromValue(String value) {
      for (StatusEnum b : StatusEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_STATUS = "status";
  private StatusEnum status;

  /**
   * The syndication entry type
   */
  public enum TypeEnum {
    WEB_LINK("WEB_LINK"),
    
    MAP("MAP"),
    
    GRID("GRID"),
    
    CARD("CARD"),
    
    FILE("FILE");

    private String value;

    TypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static TypeEnum fromValue(String value) {
      for (TypeEnum b : TypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_TYPE = "type";
  private TypeEnum type;

  public static final String JSON_PROPERTY_IMAGE_LIST = "imageList";
  private List<OpenGraphMediaAffiliate> imageList;

  public static final String JSON_PROPERTY_VIDEO_LIST = "videoList";
  private List<OpenGraphMediaAffiliate> videoList;

  public static final String JSON_PROPERTY_AUDIO_LIST = "audioList";
  private List<OpenGraphMediaAffiliate> audioList;

  public static final String JSON_PROPERTY_METADATA = "metadata";
  private List<KeyValuePairAffiliate> metadata;

  public static final String JSON_PROPERTY_TITLE = "title";
  private String title;

  public static final String JSON_PROPERTY_DESCRIPTION = "description";
  private String description;

  public static final String JSON_PROPERTY_OG_TYPE = "ogType";
  private String ogType;

  public static final String JSON_PROPERTY_TAGS = "tags";
  private List<KeyValuePairAffiliate> tags;

  public static final String JSON_PROPERTY_MEDIA = "media";
  private SimpleMultimediaAffiliate media;

  public SyndicationEntryAffiliate() {
  }

  public SyndicationEntryAffiliate id(String id) {
    
    this.id = id;
    return this;
  }

   /**
   * Document UUID
   * @return id
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getId() {
    return id;
  }


  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setId(String id) {
    this.id = id;
  }


  public SyndicationEntryAffiliate createdDate(java.time.LocalDateTime createdDate) {
    
    this.createdDate = createdDate;
    return this;
  }

   /**
   * Datetime this record was first created
   * @return createdDate
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_CREATED_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public java.time.LocalDateTime getCreatedDate() {
    return createdDate;
  }


  @JsonProperty(JSON_PROPERTY_CREATED_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCreatedDate(java.time.LocalDateTime createdDate) {
    this.createdDate = createdDate;
  }


  public SyndicationEntryAffiliate lastUpdate(java.time.LocalDateTime lastUpdate) {
    
    this.lastUpdate = lastUpdate;
    return this;
  }

   /**
   * Datetime this record was last updated
   * @return lastUpdate
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_LAST_UPDATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public java.time.LocalDateTime getLastUpdate() {
    return lastUpdate;
  }


  @JsonProperty(JSON_PROPERTY_LAST_UPDATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLastUpdate(java.time.LocalDateTime lastUpdate) {
    this.lastUpdate = lastUpdate;
  }


  public SyndicationEntryAffiliate version(Long version) {
    
    this.version = version;
    return this;
  }

   /**
   * Version property that shows how many times this document has been persisted. Document will not persist if the version property is less than current version property in the system. Result in an optimistic locking exception.
   * @return version
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_VERSION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Long getVersion() {
    return version;
  }


  @JsonProperty(JSON_PROPERTY_VERSION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setVersion(Long version) {
    this.version = version;
  }


  public SyndicationEntryAffiliate userIdentifier(UUID userIdentifier) {
    
    this.userIdentifier = userIdentifier;
    return this;
  }

   /**
   * Creator of entry
   * @return userIdentifier
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_USER_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public UUID getUserIdentifier() {
    return userIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_USER_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setUserIdentifier(UUID userIdentifier) {
    this.userIdentifier = userIdentifier;
  }


  public SyndicationEntryAffiliate ownerIdentifier(UUID ownerIdentifier) {
    
    this.ownerIdentifier = ownerIdentifier;
    return this;
  }

   /**
   * The user&#39;s owner company this entry associates with
   * @return ownerIdentifier
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_OWNER_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public UUID getOwnerIdentifier() {
    return ownerIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_OWNER_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setOwnerIdentifier(UUID ownerIdentifier) {
    this.ownerIdentifier = ownerIdentifier;
  }


  public SyndicationEntryAffiliate contentUrl(String contentUrl) {
    
    this.contentUrl = contentUrl;
    return this;
  }

   /**
   * The url of this entry
   * @return contentUrl
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_CONTENT_URL)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getContentUrl() {
    return contentUrl;
  }


  @JsonProperty(JSON_PROPERTY_CONTENT_URL)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setContentUrl(String contentUrl) {
    this.contentUrl = contentUrl;
  }


  public SyndicationEntryAffiliate sort(Integer sort) {
    
    this.sort = sort;
    return this;
  }

   /**
   * How the author wants this entry to get sorted
   * @return sort
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_SORT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Integer getSort() {
    return sort;
  }


  @JsonProperty(JSON_PROPERTY_SORT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setSort(Integer sort) {
    this.sort = sort;
  }


  public SyndicationEntryAffiliate status(StatusEnum status) {
    
    this.status = status;
    return this;
  }

   /**
   * The syndication entry status
   * @return status
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_STATUS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public StatusEnum getStatus() {
    return status;
  }


  @JsonProperty(JSON_PROPERTY_STATUS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setStatus(StatusEnum status) {
    this.status = status;
  }


  public SyndicationEntryAffiliate type(TypeEnum type) {
    
    this.type = type;
    return this;
  }

   /**
   * The syndication entry type
   * @return type
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public TypeEnum getType() {
    return type;
  }


  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setType(TypeEnum type) {
    this.type = type;
  }


  public SyndicationEntryAffiliate imageList(List<OpenGraphMediaAffiliate> imageList) {
    
    this.imageList = imageList;
    return this;
  }

  public SyndicationEntryAffiliate addImageListItem(OpenGraphMediaAffiliate imageListItem) {
    if (this.imageList == null) {
      this.imageList = new ArrayList<>();
    }
    this.imageList.add(imageListItem);
    return this;
  }

   /**
   * The image list
   * @return imageList
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_IMAGE_LIST)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<OpenGraphMediaAffiliate> getImageList() {
    return imageList;
  }


  @JsonProperty(JSON_PROPERTY_IMAGE_LIST)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setImageList(List<OpenGraphMediaAffiliate> imageList) {
    this.imageList = imageList;
  }


  public SyndicationEntryAffiliate videoList(List<OpenGraphMediaAffiliate> videoList) {
    
    this.videoList = videoList;
    return this;
  }

  public SyndicationEntryAffiliate addVideoListItem(OpenGraphMediaAffiliate videoListItem) {
    if (this.videoList == null) {
      this.videoList = new ArrayList<>();
    }
    this.videoList.add(videoListItem);
    return this;
  }

   /**
   * The video list
   * @return videoList
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_VIDEO_LIST)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<OpenGraphMediaAffiliate> getVideoList() {
    return videoList;
  }


  @JsonProperty(JSON_PROPERTY_VIDEO_LIST)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setVideoList(List<OpenGraphMediaAffiliate> videoList) {
    this.videoList = videoList;
  }


  public SyndicationEntryAffiliate audioList(List<OpenGraphMediaAffiliate> audioList) {
    
    this.audioList = audioList;
    return this;
  }

  public SyndicationEntryAffiliate addAudioListItem(OpenGraphMediaAffiliate audioListItem) {
    if (this.audioList == null) {
      this.audioList = new ArrayList<>();
    }
    this.audioList.add(audioListItem);
    return this;
  }

   /**
   * The audio list
   * @return audioList
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_AUDIO_LIST)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<OpenGraphMediaAffiliate> getAudioList() {
    return audioList;
  }


  @JsonProperty(JSON_PROPERTY_AUDIO_LIST)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAudioList(List<OpenGraphMediaAffiliate> audioList) {
    this.audioList = audioList;
  }


  public SyndicationEntryAffiliate metadata(List<KeyValuePairAffiliate> metadata) {
    
    this.metadata = metadata;
    return this;
  }

  public SyndicationEntryAffiliate addMetadataItem(KeyValuePairAffiliate metadataItem) {
    if (this.metadata == null) {
      this.metadata = new ArrayList<>();
    }
    this.metadata.add(metadataItem);
    return this;
  }

   /**
   * Extended metadata
   * @return metadata
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_METADATA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<KeyValuePairAffiliate> getMetadata() {
    return metadata;
  }


  @JsonProperty(JSON_PROPERTY_METADATA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMetadata(List<KeyValuePairAffiliate> metadata) {
    this.metadata = metadata;
  }


  public SyndicationEntryAffiliate title(String title) {
    
    this.title = title;
    return this;
  }

   /**
   * The title of this entry
   * @return title
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_TITLE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getTitle() {
    return title;
  }


  @JsonProperty(JSON_PROPERTY_TITLE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setTitle(String title) {
    this.title = title;
  }


  public SyndicationEntryAffiliate description(String description) {
    
    this.description = description;
    return this;
  }

   /**
   * The description of this entry
   * @return description
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_DESCRIPTION)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getDescription() {
    return description;
  }


  @JsonProperty(JSON_PROPERTY_DESCRIPTION)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setDescription(String description) {
    this.description = description;
  }


  public SyndicationEntryAffiliate ogType(String ogType) {
    
    this.ogType = ogType;
    return this;
  }

   /**
   * The open graph content type
   * @return ogType
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_OG_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getOgType() {
    return ogType;
  }


  @JsonProperty(JSON_PROPERTY_OG_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setOgType(String ogType) {
    this.ogType = ogType;
  }


  public SyndicationEntryAffiliate tags(List<KeyValuePairAffiliate> tags) {
    
    this.tags = tags;
    return this;
  }

  public SyndicationEntryAffiliate addTagsItem(KeyValuePairAffiliate tagsItem) {
    if (this.tags == null) {
      this.tags = new ArrayList<>();
    }
    this.tags.add(tagsItem);
    return this;
  }

   /**
   * Optional user categories
   * @return tags
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_TAGS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<KeyValuePairAffiliate> getTags() {
    return tags;
  }


  @JsonProperty(JSON_PROPERTY_TAGS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTags(List<KeyValuePairAffiliate> tags) {
    this.tags = tags;
  }


  public SyndicationEntryAffiliate media(SimpleMultimediaAffiliate media) {
    
    this.media = media;
    return this;
  }

   /**
   * Get media
   * @return media
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_MEDIA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public SimpleMultimediaAffiliate getMedia() {
    return media;
  }


  @JsonProperty(JSON_PROPERTY_MEDIA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMedia(SimpleMultimediaAffiliate media) {
    this.media = media;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    SyndicationEntryAffiliate syndicationEntryAffiliate = (SyndicationEntryAffiliate) o;
    return Objects.equals(this.id, syndicationEntryAffiliate.id) &&
        Objects.equals(this.createdDate, syndicationEntryAffiliate.createdDate) &&
        Objects.equals(this.lastUpdate, syndicationEntryAffiliate.lastUpdate) &&
        Objects.equals(this.version, syndicationEntryAffiliate.version) &&
        Objects.equals(this.userIdentifier, syndicationEntryAffiliate.userIdentifier) &&
        Objects.equals(this.ownerIdentifier, syndicationEntryAffiliate.ownerIdentifier) &&
        Objects.equals(this.contentUrl, syndicationEntryAffiliate.contentUrl) &&
        Objects.equals(this.sort, syndicationEntryAffiliate.sort) &&
        Objects.equals(this.status, syndicationEntryAffiliate.status) &&
        Objects.equals(this.type, syndicationEntryAffiliate.type) &&
        Objects.equals(this.imageList, syndicationEntryAffiliate.imageList) &&
        Objects.equals(this.videoList, syndicationEntryAffiliate.videoList) &&
        Objects.equals(this.audioList, syndicationEntryAffiliate.audioList) &&
        Objects.equals(this.metadata, syndicationEntryAffiliate.metadata) &&
        Objects.equals(this.title, syndicationEntryAffiliate.title) &&
        Objects.equals(this.description, syndicationEntryAffiliate.description) &&
        Objects.equals(this.ogType, syndicationEntryAffiliate.ogType) &&
        Objects.equals(this.tags, syndicationEntryAffiliate.tags) &&
        Objects.equals(this.media, syndicationEntryAffiliate.media);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, createdDate, lastUpdate, version, userIdentifier, ownerIdentifier, contentUrl, sort, status, type, imageList, videoList, audioList, metadata, title, description, ogType, tags, media);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class SyndicationEntryAffiliate {\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    createdDate: ").append(toIndentedString(createdDate)).append("\n");
    sb.append("    lastUpdate: ").append(toIndentedString(lastUpdate)).append("\n");
    sb.append("    version: ").append(toIndentedString(version)).append("\n");
    sb.append("    userIdentifier: ").append(toIndentedString(userIdentifier)).append("\n");
    sb.append("    ownerIdentifier: ").append(toIndentedString(ownerIdentifier)).append("\n");
    sb.append("    contentUrl: ").append(toIndentedString(contentUrl)).append("\n");
    sb.append("    sort: ").append(toIndentedString(sort)).append("\n");
    sb.append("    status: ").append(toIndentedString(status)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    imageList: ").append(toIndentedString(imageList)).append("\n");
    sb.append("    videoList: ").append(toIndentedString(videoList)).append("\n");
    sb.append("    audioList: ").append(toIndentedString(audioList)).append("\n");
    sb.append("    metadata: ").append(toIndentedString(metadata)).append("\n");
    sb.append("    title: ").append(toIndentedString(title)).append("\n");
    sb.append("    description: ").append(toIndentedString(description)).append("\n");
    sb.append("    ogType: ").append(toIndentedString(ogType)).append("\n");
    sb.append("    tags: ").append(toIndentedString(tags)).append("\n");
    sb.append("    media: ").append(toIndentedString(media)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

