/*
 * Wink API
 * ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Affiliate](/affiliate): All APIs related to selling travel inventory as an affiliate. - [Analytics](/analytics): All APIs related to tracking metrics across a wide variety of data source segments including, more entertaining, leaderboard metrics. - [Booking](/booking): All APIs related to creating platform bookings. - [Channel Manager](/channel-manager): All APIs related to channel managers who want to integrate with our platform. - [Extranet](/extranet): All APIs related to managing travel inventory and suppliers. - [Inventory](/inventory): All APIs related to retrieve known travel inventory as it was found using the Lookup API.. - [Lookup](/lookup): All APIs related to locating inventory by region, locale and property flags. - [Reference](/reference): All APIs related to retrieving platform-supported taxonomies. - [TripPay](/payment): All APIs related to TripPay account management, booking, mapping and integration features.  ## SDKs We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).  - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)  ## Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Wink-Version` header. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints.  ## Release history - 2022-10-15: v2.0 - Removed HATEOAS and added Wink-Version header - 2022-05-08: v1 - Exposed channel manager API - 2021-07-01: v1 - Initial release  # Affiliate API Welcome to the Affiliate API - A programmer-friendly way to search for and display bespoke travel inventory for your audience. Use this API to help you prepare travel inventory for sale.  # Intended Audience Programmers are a requirement to start integrating with wink. You will benefit from an API integration if you are new or existing travel related company that want easy access to great inventory.## Examples: - Hotel brands / chains that want to make their own booking engine - Travel tech companies that want to create the next hot mobile travel app - Destination sites that want to make their own booking engine - Bloggers and influencers who want to sell travel inventory to their audience - OTAs that want access direct relationships with suppliers and better quality hotel inventory
 *
 * The version of the OpenAPI document: 29.58.0
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.affiliate.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import travel.wink.sdk.affiliate.model.ConfigurableGeoJsonCircleAffiliate;
import travel.wink.sdk.affiliate.model.ConfigurableGeoJsonPointAffiliate;
import travel.wink.sdk.affiliate.model.ConfigurableGeoJsonPolygonAffiliate;
import travel.wink.sdk.affiliate.model.ConfigurableGeoJsonRectangleAffiliate;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * Object to save AdvancedMapConfiguration
 */
@JsonPropertyOrder({
  UpsertSupplierAdvancedMapConfigurationRequestAffiliate.JSON_PROPERTY_ENGINE_CONFIGURATION_IDENTIFIER,
  UpsertSupplierAdvancedMapConfigurationRequestAffiliate.JSON_PROPERTY_NAME,
  UpsertSupplierAdvancedMapConfigurationRequestAffiliate.JSON_PROPERTY_SUPPLIER_IDENTIFIER,
  UpsertSupplierAdvancedMapConfigurationRequestAffiliate.JSON_PROPERTY_TYPE,
  UpsertSupplierAdvancedMapConfigurationRequestAffiliate.JSON_PROPERTY_DRAGGABLE,
  UpsertSupplierAdvancedMapConfigurationRequestAffiliate.JSON_PROPERTY_ZOOMABLE,
  UpsertSupplierAdvancedMapConfigurationRequestAffiliate.JSON_PROPERTY_INITIAL_ZOOM_LEVEL,
  UpsertSupplierAdvancedMapConfigurationRequestAffiliate.JSON_PROPERTY_MAP_STYLE,
  UpsertSupplierAdvancedMapConfigurationRequestAffiliate.JSON_PROPERTY_MAP_MARKER_COLOR,
  UpsertSupplierAdvancedMapConfigurationRequestAffiliate.JSON_PROPERTY_MAP_HEIGHT,
  UpsertSupplierAdvancedMapConfigurationRequestAffiliate.JSON_PROPERTY_DISPLAY_TYPE,
  UpsertSupplierAdvancedMapConfigurationRequestAffiliate.JSON_PROPERTY_CIRCLES,
  UpsertSupplierAdvancedMapConfigurationRequestAffiliate.JSON_PROPERTY_RECTANGLES,
  UpsertSupplierAdvancedMapConfigurationRequestAffiliate.JSON_PROPERTY_MARKERS,
  UpsertSupplierAdvancedMapConfigurationRequestAffiliate.JSON_PROPERTY_POLYGONS
})
@JsonTypeName("UpsertSupplierAdvancedMapConfigurationRequest_Affiliate")
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-05-28T20:17:04.479259926+07:00[Asia/Bangkok]")
public class UpsertSupplierAdvancedMapConfigurationRequestAffiliate {
  public static final String JSON_PROPERTY_ENGINE_CONFIGURATION_IDENTIFIER = "engineConfigurationIdentifier";
  private UUID engineConfigurationIdentifier;

  public static final String JSON_PROPERTY_NAME = "name";
  private String name;

  public static final String JSON_PROPERTY_SUPPLIER_IDENTIFIER = "supplierIdentifier";
  private UUID supplierIdentifier;

  /**
   * Type of inventory
   */
  public enum TypeEnum {
    GUEST_ROOM("GUEST_ROOM"),
    
    ADD_ON("ADD_ON"),
    
    MEETING_ROOM("MEETING_ROOM"),
    
    RESTAURANT("RESTAURANT"),
    
    SPA("SPA"),
    
    ATTRACTION("ATTRACTION"),
    
    PLACE("PLACE"),
    
    ACTIVITY("ACTIVITY");

    private String value;

    TypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static TypeEnum fromValue(String value) {
      for (TypeEnum b : TypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_TYPE = "type";
  private TypeEnum type;

  public static final String JSON_PROPERTY_DRAGGABLE = "draggable";
  private Boolean draggable = true;

  public static final String JSON_PROPERTY_ZOOMABLE = "zoomable";
  private Boolean zoomable = true;

  public static final String JSON_PROPERTY_INITIAL_ZOOM_LEVEL = "initialZoomLevel";
  private Integer initialZoomLevel;

  /**
   * Map style
   */
  public enum MapStyleEnum {
    NORMAL("normal"),
    
    CLEAN("clean"),
    
    BLUISH("bluish");

    private String value;

    MapStyleEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static MapStyleEnum fromValue(String value) {
      for (MapStyleEnum b : MapStyleEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_MAP_STYLE = "mapStyle";
  private MapStyleEnum mapStyle;

  /**
   * Map marker color
   */
  public enum MapMarkerColorEnum {
    CC2138("cc2138");

    private String value;

    MapMarkerColorEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static MapMarkerColorEnum fromValue(String value) {
      for (MapMarkerColorEnum b : MapMarkerColorEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_MAP_MARKER_COLOR = "mapMarkerColor";
  private MapMarkerColorEnum mapMarkerColor;

  public static final String JSON_PROPERTY_MAP_HEIGHT = "mapHeight";
  private Integer mapHeight;

  /**
   * Indicate which initial values to display first on the front-facing card
   */
  public enum DisplayTypeEnum {
    NATIVE("NATIVE"),
    
    HOTEL("HOTEL"),
    
    ROOM("ROOM");

    private String value;

    DisplayTypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static DisplayTypeEnum fromValue(String value) {
      for (DisplayTypeEnum b : DisplayTypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_DISPLAY_TYPE = "displayType";
  private DisplayTypeEnum displayType = DisplayTypeEnum.NATIVE;

  public static final String JSON_PROPERTY_CIRCLES = "circles";
  private List<ConfigurableGeoJsonCircleAffiliate> circles;

  public static final String JSON_PROPERTY_RECTANGLES = "rectangles";
  private List<ConfigurableGeoJsonRectangleAffiliate> rectangles;

  public static final String JSON_PROPERTY_MARKERS = "markers";
  private List<ConfigurableGeoJsonPointAffiliate> markers;

  public static final String JSON_PROPERTY_POLYGONS = "polygons";
  private List<ConfigurableGeoJsonPolygonAffiliate> polygons;

  public UpsertSupplierAdvancedMapConfigurationRequestAffiliate() {
  }

  public UpsertSupplierAdvancedMapConfigurationRequestAffiliate engineConfigurationIdentifier(UUID engineConfigurationIdentifier) {
    
    this.engineConfigurationIdentifier = engineConfigurationIdentifier;
    return this;
  }

   /**
   * Customization identifier
   * @return engineConfigurationIdentifier
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_ENGINE_CONFIGURATION_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public UUID getEngineConfigurationIdentifier() {
    return engineConfigurationIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_ENGINE_CONFIGURATION_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setEngineConfigurationIdentifier(UUID engineConfigurationIdentifier) {
    this.engineConfigurationIdentifier = engineConfigurationIdentifier;
  }


  public UpsertSupplierAdvancedMapConfigurationRequestAffiliate name(String name) {
    
    this.name = name;
    return this;
  }

   /**
   * Name of map
   * @return name
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getName() {
    return name;
  }


  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setName(String name) {
    this.name = name;
  }


  public UpsertSupplierAdvancedMapConfigurationRequestAffiliate supplierIdentifier(UUID supplierIdentifier) {
    
    this.supplierIdentifier = supplierIdentifier;
    return this;
  }

   /**
   * Inventory type identifier. Either a single channel inventory identifier, a list identifier or a dynamic search identifier.
   * @return supplierIdentifier
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_SUPPLIER_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public UUID getSupplierIdentifier() {
    return supplierIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_SUPPLIER_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setSupplierIdentifier(UUID supplierIdentifier) {
    this.supplierIdentifier = supplierIdentifier;
  }


  public UpsertSupplierAdvancedMapConfigurationRequestAffiliate type(TypeEnum type) {
    
    this.type = type;
    return this;
  }

   /**
   * Type of inventory
   * @return type
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public TypeEnum getType() {
    return type;
  }


  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setType(TypeEnum type) {
    this.type = type;
  }


  public UpsertSupplierAdvancedMapConfigurationRequestAffiliate draggable(Boolean draggable) {
    
    this.draggable = draggable;
    return this;
  }

   /**
   * User can move around / pan the map
   * @return draggable
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_DRAGGABLE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Boolean getDraggable() {
    return draggable;
  }


  @JsonProperty(JSON_PROPERTY_DRAGGABLE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setDraggable(Boolean draggable) {
    this.draggable = draggable;
  }


  public UpsertSupplierAdvancedMapConfigurationRequestAffiliate zoomable(Boolean zoomable) {
    
    this.zoomable = zoomable;
    return this;
  }

   /**
   * User can zoom in/out of the map
   * @return zoomable
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_ZOOMABLE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Boolean getZoomable() {
    return zoomable;
  }


  @JsonProperty(JSON_PROPERTY_ZOOMABLE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setZoomable(Boolean zoomable) {
    this.zoomable = zoomable;
  }


  public UpsertSupplierAdvancedMapConfigurationRequestAffiliate initialZoomLevel(Integer initialZoomLevel) {
    
    this.initialZoomLevel = initialZoomLevel;
    return this;
  }

   /**
   * Valid Google maps zoom level
   * minimum: 0
   * maximum: 21
   * @return initialZoomLevel
  **/
  @jakarta.annotation.Nonnull
  @NotNull
 @Min(0) @Max(21)
  @JsonProperty(JSON_PROPERTY_INITIAL_ZOOM_LEVEL)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Integer getInitialZoomLevel() {
    return initialZoomLevel;
  }


  @JsonProperty(JSON_PROPERTY_INITIAL_ZOOM_LEVEL)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setInitialZoomLevel(Integer initialZoomLevel) {
    this.initialZoomLevel = initialZoomLevel;
  }


  public UpsertSupplierAdvancedMapConfigurationRequestAffiliate mapStyle(MapStyleEnum mapStyle) {
    
    this.mapStyle = mapStyle;
    return this;
  }

   /**
   * Map style
   * @return mapStyle
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_MAP_STYLE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public MapStyleEnum getMapStyle() {
    return mapStyle;
  }


  @JsonProperty(JSON_PROPERTY_MAP_STYLE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setMapStyle(MapStyleEnum mapStyle) {
    this.mapStyle = mapStyle;
  }


  public UpsertSupplierAdvancedMapConfigurationRequestAffiliate mapMarkerColor(MapMarkerColorEnum mapMarkerColor) {
    
    this.mapMarkerColor = mapMarkerColor;
    return this;
  }

   /**
   * Map marker color
   * @return mapMarkerColor
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_MAP_MARKER_COLOR)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public MapMarkerColorEnum getMapMarkerColor() {
    return mapMarkerColor;
  }


  @JsonProperty(JSON_PROPERTY_MAP_MARKER_COLOR)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setMapMarkerColor(MapMarkerColorEnum mapMarkerColor) {
    this.mapMarkerColor = mapMarkerColor;
  }


  public UpsertSupplierAdvancedMapConfigurationRequestAffiliate mapHeight(Integer mapHeight) {
    
    this.mapHeight = mapHeight;
    return this;
  }

   /**
   * Map height in pixels
   * minimum: 1
   * @return mapHeight
  **/
  @jakarta.annotation.Nonnull
  @NotNull
 @Min(1)
  @JsonProperty(JSON_PROPERTY_MAP_HEIGHT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Integer getMapHeight() {
    return mapHeight;
  }


  @JsonProperty(JSON_PROPERTY_MAP_HEIGHT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setMapHeight(Integer mapHeight) {
    this.mapHeight = mapHeight;
  }


  public UpsertSupplierAdvancedMapConfigurationRequestAffiliate displayType(DisplayTypeEnum displayType) {
    
    this.displayType = displayType;
    return this;
  }

   /**
   * Indicate which initial values to display first on the front-facing card
   * @return displayType
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_DISPLAY_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public DisplayTypeEnum getDisplayType() {
    return displayType;
  }


  @JsonProperty(JSON_PROPERTY_DISPLAY_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setDisplayType(DisplayTypeEnum displayType) {
    this.displayType = displayType;
  }


  public UpsertSupplierAdvancedMapConfigurationRequestAffiliate circles(List<ConfigurableGeoJsonCircleAffiliate> circles) {
    
    this.circles = circles;
    return this;
  }

  public UpsertSupplierAdvancedMapConfigurationRequestAffiliate addCirclesItem(ConfigurableGeoJsonCircleAffiliate circlesItem) {
    if (this.circles == null) {
      this.circles = new ArrayList<>();
    }
    this.circles.add(circlesItem);
    return this;
  }

   /**
   * Get circles
   * @return circles
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_CIRCLES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<ConfigurableGeoJsonCircleAffiliate> getCircles() {
    return circles;
  }


  @JsonProperty(JSON_PROPERTY_CIRCLES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCircles(List<ConfigurableGeoJsonCircleAffiliate> circles) {
    this.circles = circles;
  }


  public UpsertSupplierAdvancedMapConfigurationRequestAffiliate rectangles(List<ConfigurableGeoJsonRectangleAffiliate> rectangles) {
    
    this.rectangles = rectangles;
    return this;
  }

  public UpsertSupplierAdvancedMapConfigurationRequestAffiliate addRectanglesItem(ConfigurableGeoJsonRectangleAffiliate rectanglesItem) {
    if (this.rectangles == null) {
      this.rectangles = new ArrayList<>();
    }
    this.rectangles.add(rectanglesItem);
    return this;
  }

   /**
   * Get rectangles
   * @return rectangles
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_RECTANGLES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<ConfigurableGeoJsonRectangleAffiliate> getRectangles() {
    return rectangles;
  }


  @JsonProperty(JSON_PROPERTY_RECTANGLES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRectangles(List<ConfigurableGeoJsonRectangleAffiliate> rectangles) {
    this.rectangles = rectangles;
  }


  public UpsertSupplierAdvancedMapConfigurationRequestAffiliate markers(List<ConfigurableGeoJsonPointAffiliate> markers) {
    
    this.markers = markers;
    return this;
  }

  public UpsertSupplierAdvancedMapConfigurationRequestAffiliate addMarkersItem(ConfigurableGeoJsonPointAffiliate markersItem) {
    if (this.markers == null) {
      this.markers = new ArrayList<>();
    }
    this.markers.add(markersItem);
    return this;
  }

   /**
   * Get markers
   * @return markers
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_MARKERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<ConfigurableGeoJsonPointAffiliate> getMarkers() {
    return markers;
  }


  @JsonProperty(JSON_PROPERTY_MARKERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMarkers(List<ConfigurableGeoJsonPointAffiliate> markers) {
    this.markers = markers;
  }


  public UpsertSupplierAdvancedMapConfigurationRequestAffiliate polygons(List<ConfigurableGeoJsonPolygonAffiliate> polygons) {
    
    this.polygons = polygons;
    return this;
  }

  public UpsertSupplierAdvancedMapConfigurationRequestAffiliate addPolygonsItem(ConfigurableGeoJsonPolygonAffiliate polygonsItem) {
    if (this.polygons == null) {
      this.polygons = new ArrayList<>();
    }
    this.polygons.add(polygonsItem);
    return this;
  }

   /**
   * Get polygons
   * @return polygons
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_POLYGONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<ConfigurableGeoJsonPolygonAffiliate> getPolygons() {
    return polygons;
  }


  @JsonProperty(JSON_PROPERTY_POLYGONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPolygons(List<ConfigurableGeoJsonPolygonAffiliate> polygons) {
    this.polygons = polygons;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    UpsertSupplierAdvancedMapConfigurationRequestAffiliate upsertSupplierAdvancedMapConfigurationRequestAffiliate = (UpsertSupplierAdvancedMapConfigurationRequestAffiliate) o;
    return Objects.equals(this.engineConfigurationIdentifier, upsertSupplierAdvancedMapConfigurationRequestAffiliate.engineConfigurationIdentifier) &&
        Objects.equals(this.name, upsertSupplierAdvancedMapConfigurationRequestAffiliate.name) &&
        Objects.equals(this.supplierIdentifier, upsertSupplierAdvancedMapConfigurationRequestAffiliate.supplierIdentifier) &&
        Objects.equals(this.type, upsertSupplierAdvancedMapConfigurationRequestAffiliate.type) &&
        Objects.equals(this.draggable, upsertSupplierAdvancedMapConfigurationRequestAffiliate.draggable) &&
        Objects.equals(this.zoomable, upsertSupplierAdvancedMapConfigurationRequestAffiliate.zoomable) &&
        Objects.equals(this.initialZoomLevel, upsertSupplierAdvancedMapConfigurationRequestAffiliate.initialZoomLevel) &&
        Objects.equals(this.mapStyle, upsertSupplierAdvancedMapConfigurationRequestAffiliate.mapStyle) &&
        Objects.equals(this.mapMarkerColor, upsertSupplierAdvancedMapConfigurationRequestAffiliate.mapMarkerColor) &&
        Objects.equals(this.mapHeight, upsertSupplierAdvancedMapConfigurationRequestAffiliate.mapHeight) &&
        Objects.equals(this.displayType, upsertSupplierAdvancedMapConfigurationRequestAffiliate.displayType) &&
        Objects.equals(this.circles, upsertSupplierAdvancedMapConfigurationRequestAffiliate.circles) &&
        Objects.equals(this.rectangles, upsertSupplierAdvancedMapConfigurationRequestAffiliate.rectangles) &&
        Objects.equals(this.markers, upsertSupplierAdvancedMapConfigurationRequestAffiliate.markers) &&
        Objects.equals(this.polygons, upsertSupplierAdvancedMapConfigurationRequestAffiliate.polygons);
  }

  @Override
  public int hashCode() {
    return Objects.hash(engineConfigurationIdentifier, name, supplierIdentifier, type, draggable, zoomable, initialZoomLevel, mapStyle, mapMarkerColor, mapHeight, displayType, circles, rectangles, markers, polygons);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class UpsertSupplierAdvancedMapConfigurationRequestAffiliate {\n");
    sb.append("    engineConfigurationIdentifier: ").append(toIndentedString(engineConfigurationIdentifier)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    supplierIdentifier: ").append(toIndentedString(supplierIdentifier)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    draggable: ").append(toIndentedString(draggable)).append("\n");
    sb.append("    zoomable: ").append(toIndentedString(zoomable)).append("\n");
    sb.append("    initialZoomLevel: ").append(toIndentedString(initialZoomLevel)).append("\n");
    sb.append("    mapStyle: ").append(toIndentedString(mapStyle)).append("\n");
    sb.append("    mapMarkerColor: ").append(toIndentedString(mapMarkerColor)).append("\n");
    sb.append("    mapHeight: ").append(toIndentedString(mapHeight)).append("\n");
    sb.append("    displayType: ").append(toIndentedString(displayType)).append("\n");
    sb.append("    circles: ").append(toIndentedString(circles)).append("\n");
    sb.append("    rectangles: ").append(toIndentedString(rectangles)).append("\n");
    sb.append("    markers: ").append(toIndentedString(markers)).append("\n");
    sb.append("    polygons: ").append(toIndentedString(polygons)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

