/*
 * Wink API
 * ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Affiliate](/affiliate): All APIs related to selling travel inventory as an affiliate. - [Analytics](/analytics): All APIs related to tracking metrics across a wide variety of data source segments including, more entertaining, leaderboard metrics. - [Booking](/booking): All APIs related to creating platform bookings. - [Channel Manager](/channel-manager): All APIs related to channel managers who want to integrate with our platform. - [Extranet](/extranet): All APIs related to managing travel inventory and suppliers. - [Inventory](/inventory): All APIs related to retrieve known travel inventory as it was found using the Lookup API.. - [Lookup](/lookup): All APIs related to locating inventory by region, locale and property flags. - [Reference](/reference): All APIs related to retrieving platform-supported taxonomies. - [TripPay](/payment): All APIs related to TripPay account management, booking, mapping and integration features.  ## SDKs We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).  - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)  ## Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Wink-Version` header. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints.  ## Release history - Follow updates on Github: https://github.com/wink-travel/wink-sdk-java/blob/master/CHANGELOG.md  # Affiliate API Welcome to the Affiliate API - A programmer-friendly way to search for and display bespoke travel inventory for your audience. Use this API to help you prepare travel inventory for sale.  # Intended Audience Programmers are a requirement to start integrating with wink. You will benefit from an API integration if you are new or existing travel related company that want easy access to great inventory.## Examples: - Hotel brands / chains that want to make their own booking engine - Travel tech companies that want to create the next hot mobile travel app - Destination sites that want to make their own booking engine - Bloggers and influencers who want to sell travel inventory to their audience - OTAs that want access direct relationships with suppliers and better quality hotel inventory
 *
 * The version of the OpenAPI document: 29.62.1
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.affiliate.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.math.BigDecimal;
import travel.wink.sdk.affiliate.model.BorderSupplier;
import travel.wink.sdk.affiliate.model.MarginSupplier;
import travel.wink.sdk.affiliate.model.PaddingSupplier;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * Title of axis
 */
@JsonPropertyOrder({
  CategoryAxisTitleSupplier.JSON_PROPERTY_BACKGROUND,
  CategoryAxisTitleSupplier.JSON_PROPERTY_BORDER,
  CategoryAxisTitleSupplier.JSON_PROPERTY_COLOR,
  CategoryAxisTitleSupplier.JSON_PROPERTY_FONT,
  CategoryAxisTitleSupplier.JSON_PROPERTY_MARGIN,
  CategoryAxisTitleSupplier.JSON_PROPERTY_PADDING,
  CategoryAxisTitleSupplier.JSON_PROPERTY_POSITION,
  CategoryAxisTitleSupplier.JSON_PROPERTY_ROTATION,
  CategoryAxisTitleSupplier.JSON_PROPERTY_TEXT,
  CategoryAxisTitleSupplier.JSON_PROPERTY_VISIBLE
})
@JsonTypeName("CategoryAxisTitle_Supplier")
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-06-12T16:59:18.389569124+07:00[Asia/Bangkok]")
public class CategoryAxisTitleSupplier {
  public static final String JSON_PROPERTY_BACKGROUND = "background";
  private String background;

  public static final String JSON_PROPERTY_BORDER = "border";
  private BorderSupplier border;

  public static final String JSON_PROPERTY_COLOR = "color";
  private String color;

  public static final String JSON_PROPERTY_FONT = "font";
  private String font;

  public static final String JSON_PROPERTY_MARGIN = "margin";
  private MarginSupplier margin;

  public static final String JSON_PROPERTY_PADDING = "padding";
  private PaddingSupplier padding;

  /**
   * Gets or Sets position
   */
  public enum PositionEnum {
    TOP("top"),
    
    BOTTOM("bottom"),
    
    LEFT("left"),
    
    RIGHT("right"),
    
    CENTER("center");

    private String value;

    PositionEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static PositionEnum fromValue(String value) {
      for (PositionEnum b : PositionEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_POSITION = "position";
  private PositionEnum position;

  public static final String JSON_PROPERTY_ROTATION = "rotation";
  private BigDecimal rotation;

  public static final String JSON_PROPERTY_TEXT = "text";
  private String text;

  public static final String JSON_PROPERTY_VISIBLE = "visible";
  private Boolean visible;

  public CategoryAxisTitleSupplier() {
  }

  public CategoryAxisTitleSupplier background(String background) {
    
    this.background = background;
    return this;
  }

   /**
   * Get background
   * @return background
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_BACKGROUND)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getBackground() {
    return background;
  }


  @JsonProperty(JSON_PROPERTY_BACKGROUND)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setBackground(String background) {
    this.background = background;
  }


  public CategoryAxisTitleSupplier border(BorderSupplier border) {
    
    this.border = border;
    return this;
  }

   /**
   * Get border
   * @return border
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_BORDER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public BorderSupplier getBorder() {
    return border;
  }


  @JsonProperty(JSON_PROPERTY_BORDER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setBorder(BorderSupplier border) {
    this.border = border;
  }


  public CategoryAxisTitleSupplier color(String color) {
    
    this.color = color;
    return this;
  }

   /**
   * Get color
   * @return color
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_COLOR)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getColor() {
    return color;
  }


  @JsonProperty(JSON_PROPERTY_COLOR)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setColor(String color) {
    this.color = color;
  }


  public CategoryAxisTitleSupplier font(String font) {
    
    this.font = font;
    return this;
  }

   /**
   * Get font
   * @return font
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_FONT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getFont() {
    return font;
  }


  @JsonProperty(JSON_PROPERTY_FONT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFont(String font) {
    this.font = font;
  }


  public CategoryAxisTitleSupplier margin(MarginSupplier margin) {
    
    this.margin = margin;
    return this;
  }

   /**
   * Get margin
   * @return margin
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_MARGIN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public MarginSupplier getMargin() {
    return margin;
  }


  @JsonProperty(JSON_PROPERTY_MARGIN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMargin(MarginSupplier margin) {
    this.margin = margin;
  }


  public CategoryAxisTitleSupplier padding(PaddingSupplier padding) {
    
    this.padding = padding;
    return this;
  }

   /**
   * Get padding
   * @return padding
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_PADDING)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public PaddingSupplier getPadding() {
    return padding;
  }


  @JsonProperty(JSON_PROPERTY_PADDING)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPadding(PaddingSupplier padding) {
    this.padding = padding;
  }


  public CategoryAxisTitleSupplier position(PositionEnum position) {
    
    this.position = position;
    return this;
  }

   /**
   * Get position
   * @return position
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_POSITION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public PositionEnum getPosition() {
    return position;
  }


  @JsonProperty(JSON_PROPERTY_POSITION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPosition(PositionEnum position) {
    this.position = position;
  }


  public CategoryAxisTitleSupplier rotation(BigDecimal rotation) {
    
    this.rotation = rotation;
    return this;
  }

   /**
   * Get rotation
   * @return rotation
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_ROTATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public BigDecimal getRotation() {
    return rotation;
  }


  @JsonProperty(JSON_PROPERTY_ROTATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRotation(BigDecimal rotation) {
    this.rotation = rotation;
  }


  public CategoryAxisTitleSupplier text(String text) {
    
    this.text = text;
    return this;
  }

   /**
   * Get text
   * @return text
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_TEXT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getText() {
    return text;
  }


  @JsonProperty(JSON_PROPERTY_TEXT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setText(String text) {
    this.text = text;
  }


  public CategoryAxisTitleSupplier visible(Boolean visible) {
    
    this.visible = visible;
    return this;
  }

   /**
   * Get visible
   * @return visible
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_VISIBLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getVisible() {
    return visible;
  }


  @JsonProperty(JSON_PROPERTY_VISIBLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setVisible(Boolean visible) {
    this.visible = visible;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    CategoryAxisTitleSupplier categoryAxisTitleSupplier = (CategoryAxisTitleSupplier) o;
    return Objects.equals(this.background, categoryAxisTitleSupplier.background) &&
        Objects.equals(this.border, categoryAxisTitleSupplier.border) &&
        Objects.equals(this.color, categoryAxisTitleSupplier.color) &&
        Objects.equals(this.font, categoryAxisTitleSupplier.font) &&
        Objects.equals(this.margin, categoryAxisTitleSupplier.margin) &&
        Objects.equals(this.padding, categoryAxisTitleSupplier.padding) &&
        Objects.equals(this.position, categoryAxisTitleSupplier.position) &&
        Objects.equals(this.rotation, categoryAxisTitleSupplier.rotation) &&
        Objects.equals(this.text, categoryAxisTitleSupplier.text) &&
        Objects.equals(this.visible, categoryAxisTitleSupplier.visible);
  }

  @Override
  public int hashCode() {
    return Objects.hash(background, border, color, font, margin, padding, position, rotation, text, visible);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class CategoryAxisTitleSupplier {\n");
    sb.append("    background: ").append(toIndentedString(background)).append("\n");
    sb.append("    border: ").append(toIndentedString(border)).append("\n");
    sb.append("    color: ").append(toIndentedString(color)).append("\n");
    sb.append("    font: ").append(toIndentedString(font)).append("\n");
    sb.append("    margin: ").append(toIndentedString(margin)).append("\n");
    sb.append("    padding: ").append(toIndentedString(padding)).append("\n");
    sb.append("    position: ").append(toIndentedString(position)).append("\n");
    sb.append("    rotation: ").append(toIndentedString(rotation)).append("\n");
    sb.append("    text: ").append(toIndentedString(text)).append("\n");
    sb.append("    visible: ").append(toIndentedString(visible)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

