/*
 * Wink API
 * ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Affiliate](/affiliate): All APIs related to selling travel inventory as an affiliate. - [Analytics](/analytics): All APIs related to tracking metrics across a wide variety of data source segments including, more entertaining, leaderboard metrics. - [Booking](/booking): All APIs related to creating platform bookings. - [Channel Manager](/channel-manager): All APIs related to channel managers who want to integrate with our platform. - [Extranet](/extranet): All APIs related to managing travel inventory and suppliers. - [Inventory](/inventory): All APIs related to retrieve known travel inventory as it was found using the Lookup API.. - [Lookup](/lookup): All APIs related to locating inventory by region, locale and property flags. - [Reference](/reference): All APIs related to retrieving platform-supported taxonomies. - [TripPay](/payment): All APIs related to TripPay account management, booking, mapping and integration features.  ## SDKs We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).  - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)  ## Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Wink-Version` header. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints.  ## Release history - Follow updates on Github: https://github.com/wink-travel/wink-sdk-java/blob/master/CHANGELOG.md  # Affiliate API Welcome to the Affiliate API - A programmer-friendly way to search for and display bespoke travel inventory for your audience. Use this API to help you prepare travel inventory for sale.  # Intended Audience Programmers are a requirement to start integrating with wink. You will benefit from an API integration if you are new or existing travel related company that want easy access to great inventory.## Examples: - Hotel brands / chains that want to make their own booking engine - Travel tech companies that want to create the next hot mobile travel app - Destination sites that want to make their own booking engine - Bloggers and influencers who want to sell travel inventory to their audience - OTAs that want access direct relationships with suppliers and better quality hotel inventory
 *
 * The version of the OpenAPI document: 29.62.1
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.affiliate.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * The media list
 */
@JsonPropertyOrder({
  OpenGraphMediaAffiliate.JSON_PROPERTY_URL,
  OpenGraphMediaAffiliate.JSON_PROPERTY_SECURE_URL,
  OpenGraphMediaAffiliate.JSON_PROPERTY_TYPE,
  OpenGraphMediaAffiliate.JSON_PROPERTY_WIDTH,
  OpenGraphMediaAffiliate.JSON_PROPERTY_HEIGHT,
  OpenGraphMediaAffiliate.JSON_PROPERTY_ALT
})
@JsonTypeName("OpenGraphMedia_Affiliate")
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-06-12T16:59:18.389569124+07:00[Asia/Bangkok]")
public class OpenGraphMediaAffiliate {
  public static final String JSON_PROPERTY_URL = "url";
  private String url;

  public static final String JSON_PROPERTY_SECURE_URL = "secureUrl";
  private String secureUrl;

  public static final String JSON_PROPERTY_TYPE = "type";
  private String type;

  public static final String JSON_PROPERTY_WIDTH = "width";
  private String width;

  public static final String JSON_PROPERTY_HEIGHT = "height";
  private String height;

  public static final String JSON_PROPERTY_ALT = "alt";
  private String alt;

  public OpenGraphMediaAffiliate() {
  }

  public OpenGraphMediaAffiliate url(String url) {
    
    this.url = url;
    return this;
  }

   /**
   * The image url
   * @return url
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_URL)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getUrl() {
    return url;
  }


  @JsonProperty(JSON_PROPERTY_URL)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setUrl(String url) {
    this.url = url;
  }


  public OpenGraphMediaAffiliate secureUrl(String secureUrl) {
    
    this.secureUrl = secureUrl;
    return this;
  }

   /**
   * The secure url
   * @return secureUrl
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_SECURE_URL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getSecureUrl() {
    return secureUrl;
  }


  @JsonProperty(JSON_PROPERTY_SECURE_URL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSecureUrl(String secureUrl) {
    this.secureUrl = secureUrl;
  }


  public OpenGraphMediaAffiliate type(String type) {
    
    this.type = type;
    return this;
  }

   /**
   * Image content type
   * @return type
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getType() {
    return type;
  }


  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setType(String type) {
    this.type = type;
  }


  public OpenGraphMediaAffiliate width(String width) {
    
    this.width = width;
    return this;
  }

   /**
   * Image width
   * @return width
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_WIDTH)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getWidth() {
    return width;
  }


  @JsonProperty(JSON_PROPERTY_WIDTH)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setWidth(String width) {
    this.width = width;
  }


  public OpenGraphMediaAffiliate height(String height) {
    
    this.height = height;
    return this;
  }

   /**
   * Image height
   * @return height
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_HEIGHT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getHeight() {
    return height;
  }


  @JsonProperty(JSON_PROPERTY_HEIGHT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setHeight(String height) {
    this.height = height;
  }


  public OpenGraphMediaAffiliate alt(String alt) {
    
    this.alt = alt;
    return this;
  }

   /**
   * Alt text
   * @return alt
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_ALT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getAlt() {
    return alt;
  }


  @JsonProperty(JSON_PROPERTY_ALT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAlt(String alt) {
    this.alt = alt;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    OpenGraphMediaAffiliate openGraphMediaAffiliate = (OpenGraphMediaAffiliate) o;
    return Objects.equals(this.url, openGraphMediaAffiliate.url) &&
        Objects.equals(this.secureUrl, openGraphMediaAffiliate.secureUrl) &&
        Objects.equals(this.type, openGraphMediaAffiliate.type) &&
        Objects.equals(this.width, openGraphMediaAffiliate.width) &&
        Objects.equals(this.height, openGraphMediaAffiliate.height) &&
        Objects.equals(this.alt, openGraphMediaAffiliate.alt);
  }

  @Override
  public int hashCode() {
    return Objects.hash(url, secureUrl, type, width, height, alt);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class OpenGraphMediaAffiliate {\n");
    sb.append("    url: ").append(toIndentedString(url)).append("\n");
    sb.append("    secureUrl: ").append(toIndentedString(secureUrl)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    width: ").append(toIndentedString(width)).append("\n");
    sb.append("    height: ").append(toIndentedString(height)).append("\n");
    sb.append("    alt: ").append(toIndentedString(alt)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

