/*
 * Wink API
 * ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Affiliate](/affiliate): All APIs related to selling travel inventory as an affiliate. - [Analytics](/analytics): All APIs related to tracking metrics across a wide variety of data source segments including, more entertaining, leaderboard metrics. - [Booking](/booking): All APIs related to creating platform bookings. - [Channel Manager](/channel-manager): All APIs related to channel managers who want to integrate with our platform. - [Extranet](/extranet): All APIs related to managing travel inventory and suppliers. - [Inventory](/inventory): All APIs related to retrieve known travel inventory as it was found using the Lookup API.. - [Lookup](/lookup): All APIs related to locating inventory by region, locale and property flags. - [Reference](/reference): All APIs related to retrieving platform-supported taxonomies. - [TripPay](/payment): All APIs related to TripPay account management, booking, mapping and integration features.  ## SDKs We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).  - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)  ## Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Wink-Version` header. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints.  ## Release history - Follow updates on Github: https://github.com/wink-travel/wink-sdk-java/blob/master/CHANGELOG.md  # Affiliate API Welcome to the Affiliate API - A programmer-friendly way to search for and display bespoke travel inventory for your audience. Use this API to help you prepare travel inventory for sale.  # Intended Audience Programmers are a requirement to start integrating with wink. You will benefit from an API integration if you are new or existing travel related company that want easy access to great inventory.## Examples: - Hotel brands / chains that want to make their own booking engine - Travel tech companies that want to create the next hot mobile travel app - Destination sites that want to make their own booking engine - Bloggers and influencers who want to sell travel inventory to their audience - OTAs that want access direct relationships with suppliers and better quality hotel inventory
 *
 * The version of the OpenAPI document: 29.62.1
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.affiliate.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import travel.wink.sdk.affiliate.model.ContactAffiliate;
import travel.wink.sdk.affiliate.model.PetInfoDtoAffiliate;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * Detailed customer information for this profile
 */
@JsonPropertyOrder({
  PersonalAffiliate.JSON_PROPERTY_GENDER,
  PersonalAffiliate.JSON_PROPERTY_BIRTH_DATE,
  PersonalAffiliate.JSON_PROPERTY_MARITAL_STATUS,
  PersonalAffiliate.JSON_PROPERTY_CHILD_QUANTITY,
  PersonalAffiliate.JSON_PROPERTY_CITIZENSHIP,
  PersonalAffiliate.JSON_PROPERTY_ADDRESS1,
  PersonalAffiliate.JSON_PROPERTY_ADDRESS2,
  PersonalAffiliate.JSON_PROPERTY_CITY,
  PersonalAffiliate.JSON_PROPERTY_STATE,
  PersonalAffiliate.JSON_PROPERTY_POSTAL_CODE,
  PersonalAffiliate.JSON_PROPERTY_COUNTRY,
  PersonalAffiliate.JSON_PROPERTY_PREFERRED_CURRENCY,
  PersonalAffiliate.JSON_PROPERTY_LANGUAGE,
  PersonalAffiliate.JSON_PROPERTY_CONTACT_PERSON,
  PersonalAffiliate.JSON_PROPERTY_PHYS_CHALL_NAME,
  PersonalAffiliate.JSON_PROPERTY_PET_INFO
})
@JsonTypeName("Personal_Affiliate")
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-06-12T16:59:18.389569124+07:00[Asia/Bangkok]")
public class PersonalAffiliate {
  /**
   * Identifier the gender of the customer.
   */
  public enum GenderEnum {
    MALE("MALE"),
    
    FEMALE("FEMALE"),
    
    OTHER("OTHER");

    private String value;

    GenderEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static GenderEnum fromValue(String value) {
      for (GenderEnum b : GenderEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_GENDER = "gender";
  private GenderEnum gender;

  public static final String JSON_PROPERTY_BIRTH_DATE = "birthDate";
  private LocalDate birthDate;

  /**
   * Marital status of the traveler.
   */
  public enum MaritalStatusEnum {
    ANNULLED("ANNULLED"),
    
    COHABITATING("COHABITATING"),
    
    DIVORCED("DIVORCED"),
    
    ENGAGED("ENGAGED"),
    
    MARRIED("MARRIED"),
    
    SEPARATED("SEPARATED"),
    
    SINGLE("SINGLE"),
    
    WIDOWED("WIDOWED"),
    
    UNKNOWN("UNKNOWN");

    private String value;

    MaritalStatusEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static MaritalStatusEnum fromValue(String value) {
      for (MaritalStatusEnum b : MaritalStatusEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_MARITAL_STATUS = "maritalStatus";
  private MaritalStatusEnum maritalStatus;

  public static final String JSON_PROPERTY_CHILD_QUANTITY = "childQuantity";
  private Integer childQuantity;

  public static final String JSON_PROPERTY_CITIZENSHIP = "citizenship";
  private String citizenship;

  public static final String JSON_PROPERTY_ADDRESS1 = "address1";
  private String address1;

  public static final String JSON_PROPERTY_ADDRESS2 = "address2";
  private String address2;

  public static final String JSON_PROPERTY_CITY = "city";
  private String city;

  public static final String JSON_PROPERTY_STATE = "state";
  private String state;

  public static final String JSON_PROPERTY_POSTAL_CODE = "postalCode";
  private String postalCode;

  public static final String JSON_PROPERTY_COUNTRY = "country";
  private String country;

  public static final String JSON_PROPERTY_PREFERRED_CURRENCY = "preferredCurrency";
  private String preferredCurrency;

  public static final String JSON_PROPERTY_LANGUAGE = "language";
  private String language;

  public static final String JSON_PROPERTY_CONTACT_PERSON = "contactPerson";
  private List<ContactAffiliate> contactPerson;

  public static final String JSON_PROPERTY_PHYS_CHALL_NAME = "physChallName";
  private List<String> physChallName;

  public static final String JSON_PROPERTY_PET_INFO = "petInfo";
  private List<PetInfoDtoAffiliate> petInfo;

  public PersonalAffiliate() {
  }

  public PersonalAffiliate gender(GenderEnum gender) {
    
    this.gender = gender;
    return this;
  }

   /**
   * Identifier the gender of the customer.
   * @return gender
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_GENDER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public GenderEnum getGender() {
    return gender;
  }


  @JsonProperty(JSON_PROPERTY_GENDER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setGender(GenderEnum gender) {
    this.gender = gender;
  }


  public PersonalAffiliate birthDate(LocalDate birthDate) {
    
    this.birthDate = birthDate;
    return this;
  }

   /**
   * Indicates the date of birth as indicated in the document, in ISO 8601 prescribed format.
   * @return birthDate
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_BIRTH_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public LocalDate getBirthDate() {
    return birthDate;
  }


  @JsonProperty(JSON_PROPERTY_BIRTH_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setBirthDate(LocalDate birthDate) {
    this.birthDate = birthDate;
  }


  public PersonalAffiliate maritalStatus(MaritalStatusEnum maritalStatus) {
    
    this.maritalStatus = maritalStatus;
    return this;
  }

   /**
   * Marital status of the traveler.
   * @return maritalStatus
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_MARITAL_STATUS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public MaritalStatusEnum getMaritalStatus() {
    return maritalStatus;
  }


  @JsonProperty(JSON_PROPERTY_MARITAL_STATUS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMaritalStatus(MaritalStatusEnum maritalStatus) {
    this.maritalStatus = maritalStatus;
  }


  public PersonalAffiliate childQuantity(Integer childQuantity) {
    
    this.childQuantity = childQuantity;
    return this;
  }

   /**
   * The number of children of the customer.
   * @return childQuantity
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_CHILD_QUANTITY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getChildQuantity() {
    return childQuantity;
  }


  @JsonProperty(JSON_PROPERTY_CHILD_QUANTITY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setChildQuantity(Integer childQuantity) {
    this.childQuantity = childQuantity;
  }


  public PersonalAffiliate citizenship(String citizenship) {
    
    this.citizenship = citizenship;
    return this;
  }

   /**
   * Name of the (self-professed) country that is clamided for citizenship.
   * @return citizenship
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_CITIZENSHIP)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getCitizenship() {
    return citizenship;
  }


  @JsonProperty(JSON_PROPERTY_CITIZENSHIP)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCitizenship(String citizenship) {
    this.citizenship = citizenship;
  }


  public PersonalAffiliate address1(String address1) {
    
    this.address1 = address1;
    return this;
  }

   /**
   * Address line 1
   * @return address1
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_ADDRESS1)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getAddress1() {
    return address1;
  }


  @JsonProperty(JSON_PROPERTY_ADDRESS1)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAddress1(String address1) {
    this.address1 = address1;
  }


  public PersonalAffiliate address2(String address2) {
    
    this.address2 = address2;
    return this;
  }

   /**
   * Address line 2
   * @return address2
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_ADDRESS2)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getAddress2() {
    return address2;
  }


  @JsonProperty(JSON_PROPERTY_ADDRESS2)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAddress2(String address2) {
    this.address2 = address2;
  }


  public PersonalAffiliate city(String city) {
    
    this.city = city;
    return this;
  }

   /**
   * City
   * @return city
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_CITY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getCity() {
    return city;
  }


  @JsonProperty(JSON_PROPERTY_CITY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCity(String city) {
    this.city = city;
  }


  public PersonalAffiliate state(String state) {
    
    this.state = state;
    return this;
  }

   /**
   * State
   * @return state
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_STATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getState() {
    return state;
  }


  @JsonProperty(JSON_PROPERTY_STATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setState(String state) {
    this.state = state;
  }


  public PersonalAffiliate postalCode(String postalCode) {
    
    this.postalCode = postalCode;
    return this;
  }

   /**
   * Postal code
   * @return postalCode
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_POSTAL_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getPostalCode() {
    return postalCode;
  }


  @JsonProperty(JSON_PROPERTY_POSTAL_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPostalCode(String postalCode) {
    this.postalCode = postalCode;
  }


  public PersonalAffiliate country(String country) {
    
    this.country = country;
    return this;
  }

   /**
   * Country
   * @return country
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_COUNTRY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getCountry() {
    return country;
  }


  @JsonProperty(JSON_PROPERTY_COUNTRY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCountry(String country) {
    this.country = country;
  }


  public PersonalAffiliate preferredCurrency(String preferredCurrency) {
    
    this.preferredCurrency = preferredCurrency;
    return this;
  }

   /**
   * Type of funds preferred for reviewing monetary values, in ISO 4217 codes
   * @return preferredCurrency
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_PREFERRED_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getPreferredCurrency() {
    return preferredCurrency;
  }


  @JsonProperty(JSON_PROPERTY_PREFERRED_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPreferredCurrency(String preferredCurrency) {
    this.preferredCurrency = preferredCurrency;
  }


  public PersonalAffiliate language(String language) {
    
    this.language = language;
    return this;
  }

   /**
   * The primary language of the customer
   * @return language
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_LANGUAGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getLanguage() {
    return language;
  }


  @JsonProperty(JSON_PROPERTY_LANGUAGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLanguage(String language) {
    this.language = language;
  }


  public PersonalAffiliate contactPerson(List<ContactAffiliate> contactPerson) {
    
    this.contactPerson = contactPerson;
    return this;
  }

  public PersonalAffiliate addContactPersonItem(ContactAffiliate contactPersonItem) {
    if (this.contactPerson == null) {
      this.contactPerson = new ArrayList<>();
    }
    this.contactPerson.add(contactPersonItem);
    return this;
  }

   /**
   * Get contactPerson
   * @return contactPerson
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_CONTACT_PERSON)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<ContactAffiliate> getContactPerson() {
    return contactPerson;
  }


  @JsonProperty(JSON_PROPERTY_CONTACT_PERSON)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setContactPerson(List<ContactAffiliate> contactPerson) {
    this.contactPerson = contactPerson;
  }


  public PersonalAffiliate physChallName(List<String> physChallName) {
    
    this.physChallName = physChallName;
    return this;
  }

  public PersonalAffiliate addPhysChallNameItem(String physChallNameItem) {
    if (this.physChallName == null) {
      this.physChallName = new ArrayList<>();
    }
    this.physChallName.add(physChallNameItem);
    return this;
  }

   /**
   * Get physChallName
   * @return physChallName
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_PHYS_CHALL_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<String> getPhysChallName() {
    return physChallName;
  }


  @JsonProperty(JSON_PROPERTY_PHYS_CHALL_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPhysChallName(List<String> physChallName) {
    this.physChallName = physChallName;
  }


  public PersonalAffiliate petInfo(List<PetInfoDtoAffiliate> petInfo) {
    
    this.petInfo = petInfo;
    return this;
  }

  public PersonalAffiliate addPetInfoItem(PetInfoDtoAffiliate petInfoItem) {
    if (this.petInfo == null) {
      this.petInfo = new ArrayList<>();
    }
    this.petInfo.add(petInfoItem);
    return this;
  }

   /**
   * Get petInfo
   * @return petInfo
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_PET_INFO)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<PetInfoDtoAffiliate> getPetInfo() {
    return petInfo;
  }


  @JsonProperty(JSON_PROPERTY_PET_INFO)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPetInfo(List<PetInfoDtoAffiliate> petInfo) {
    this.petInfo = petInfo;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    PersonalAffiliate personalAffiliate = (PersonalAffiliate) o;
    return Objects.equals(this.gender, personalAffiliate.gender) &&
        Objects.equals(this.birthDate, personalAffiliate.birthDate) &&
        Objects.equals(this.maritalStatus, personalAffiliate.maritalStatus) &&
        Objects.equals(this.childQuantity, personalAffiliate.childQuantity) &&
        Objects.equals(this.citizenship, personalAffiliate.citizenship) &&
        Objects.equals(this.address1, personalAffiliate.address1) &&
        Objects.equals(this.address2, personalAffiliate.address2) &&
        Objects.equals(this.city, personalAffiliate.city) &&
        Objects.equals(this.state, personalAffiliate.state) &&
        Objects.equals(this.postalCode, personalAffiliate.postalCode) &&
        Objects.equals(this.country, personalAffiliate.country) &&
        Objects.equals(this.preferredCurrency, personalAffiliate.preferredCurrency) &&
        Objects.equals(this.language, personalAffiliate.language) &&
        Objects.equals(this.contactPerson, personalAffiliate.contactPerson) &&
        Objects.equals(this.physChallName, personalAffiliate.physChallName) &&
        Objects.equals(this.petInfo, personalAffiliate.petInfo);
  }

  @Override
  public int hashCode() {
    return Objects.hash(gender, birthDate, maritalStatus, childQuantity, citizenship, address1, address2, city, state, postalCode, country, preferredCurrency, language, contactPerson, physChallName, petInfo);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class PersonalAffiliate {\n");
    sb.append("    gender: ").append(toIndentedString(gender)).append("\n");
    sb.append("    birthDate: ").append(toIndentedString(birthDate)).append("\n");
    sb.append("    maritalStatus: ").append(toIndentedString(maritalStatus)).append("\n");
    sb.append("    childQuantity: ").append(toIndentedString(childQuantity)).append("\n");
    sb.append("    citizenship: ").append(toIndentedString(citizenship)).append("\n");
    sb.append("    address1: ").append(toIndentedString(address1)).append("\n");
    sb.append("    address2: ").append(toIndentedString(address2)).append("\n");
    sb.append("    city: ").append(toIndentedString(city)).append("\n");
    sb.append("    state: ").append(toIndentedString(state)).append("\n");
    sb.append("    postalCode: ").append(toIndentedString(postalCode)).append("\n");
    sb.append("    country: ").append(toIndentedString(country)).append("\n");
    sb.append("    preferredCurrency: ").append(toIndentedString(preferredCurrency)).append("\n");
    sb.append("    language: ").append(toIndentedString(language)).append("\n");
    sb.append("    contactPerson: ").append(toIndentedString(contactPerson)).append("\n");
    sb.append("    physChallName: ").append(toIndentedString(physChallName)).append("\n");
    sb.append("    petInfo: ").append(toIndentedString(petInfo)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

