/*
 * Wink API
 * ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Affiliate](/affiliate): All APIs related to selling travel inventory as an affiliate. - [Analytics](/analytics): All APIs related to tracking metrics across a wide variety of data source segments including, more entertaining, leaderboard metrics. - [Booking](/booking): All APIs related to creating platform bookings. - [Channel Manager](/channel-manager): All APIs related to channel managers who want to integrate with our platform. - [Extranet](/extranet): All APIs related to managing travel inventory and suppliers. - [Inventory](/inventory): All APIs related to retrieve known travel inventory as it was found using the Lookup API.. - [Lookup](/lookup): All APIs related to locating inventory by region, locale and property flags. - [Reference](/reference): All APIs related to retrieving platform-supported taxonomies. - [TripPay](/payment): All APIs related to TripPay account management, booking, mapping and integration features.  ## SDKs We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).  - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)  ## Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Wink-Version` header. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints.  ## Release history - Follow updates on Github: https://github.com/wink-travel/wink-sdk-java/blob/master/CHANGELOG.md  # Affiliate API Welcome to the Affiliate API - A programmer-friendly way to search for and display bespoke travel inventory for your audience. Use this API to help you prepare travel inventory for sale.  # Intended Audience Programmers are a requirement to start integrating with wink. You will benefit from an API integration if you are new or existing travel related company that want easy access to great inventory.## Examples: - Hotel brands / chains that want to make their own booking engine - Travel tech companies that want to create the next hot mobile travel app - Destination sites that want to make their own booking engine - Bloggers and influencers who want to sell travel inventory to their audience - OTAs that want access direct relationships with suppliers and better quality hotel inventory
 *
 * The version of the OpenAPI document: 29.62.1
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.affiliate.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import travel.wink.sdk.affiliate.model.SimpleDescriptionAffiliate;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * UpsertSellerInventoryItemRequestAffiliate
 */
@JsonPropertyOrder({
  UpsertSellerInventoryItemRequestAffiliate.JSON_PROPERTY_SELLER_INVENTORY_ITEM_NAME,
  UpsertSellerInventoryItemRequestAffiliate.JSON_PROPERTY_ENGINE_CONFIGURATION_IDENTIFIER,
  UpsertSellerInventoryItemRequestAffiliate.JSON_PROPERTY_DESCRIPTIONS,
  UpsertSellerInventoryItemRequestAffiliate.JSON_PROPERTY_KEYWORDS,
  UpsertSellerInventoryItemRequestAffiliate.JSON_PROPERTY_INVENTORY_TYPE,
  UpsertSellerInventoryItemRequestAffiliate.JSON_PROPERTY_CHANNEL_INVENTORY_TYPE,
  UpsertSellerInventoryItemRequestAffiliate.JSON_PROPERTY_SUPPLIER_IDENTIFIER,
  UpsertSellerInventoryItemRequestAffiliate.JSON_PROPERTY_CHANNEL_INVENTORY_IDENTIFIER,
  UpsertSellerInventoryItemRequestAffiliate.JSON_PROPERTY_MULTIMEDIA_IDENTIFIERS,
  UpsertSellerInventoryItemRequestAffiliate.JSON_PROPERTY_ANIMATE,
  UpsertSellerInventoryItemRequestAffiliate.JSON_PROPERTY_ANIMATE_DELAY,
  UpsertSellerInventoryItemRequestAffiliate.JSON_PROPERTY_SORT,
  UpsertSellerInventoryItemRequestAffiliate.JSON_PROPERTY_DISPLAY_TYPE
})
@JsonTypeName("UpsertSellerInventoryItemRequest_Affiliate")
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-06-12T16:59:18.389569124+07:00[Asia/Bangkok]")
public class UpsertSellerInventoryItemRequestAffiliate {
  public static final String JSON_PROPERTY_SELLER_INVENTORY_ITEM_NAME = "sellerInventoryItemName";
  private String sellerInventoryItemName;

  public static final String JSON_PROPERTY_ENGINE_CONFIGURATION_IDENTIFIER = "engineConfigurationIdentifier";
  private UUID engineConfigurationIdentifier;

  public static final String JSON_PROPERTY_DESCRIPTIONS = "descriptions";
  private List<SimpleDescriptionAffiliate> descriptions = new ArrayList<>();

  public static final String JSON_PROPERTY_KEYWORDS = "keywords";
  private List<String> keywords = new ArrayList<>();

  /**
   * The type of inventory being offer up for sale
   */
  public enum InventoryTypeEnum {
    HOTEL("HOTEL"),
    
    GUEST_ROOM("GUEST_ROOM"),
    
    MEETING_ROOM("MEETING_ROOM"),
    
    RESTAURANT("RESTAURANT"),
    
    SPA("SPA"),
    
    ADD_ON("ADD_ON"),
    
    ATTRACTION("ATTRACTION"),
    
    ACTIVITY("ACTIVITY"),
    
    PLACE("PLACE");

    private String value;

    InventoryTypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static InventoryTypeEnum fromValue(String value) {
      for (InventoryTypeEnum b : InventoryTypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_INVENTORY_TYPE = "inventoryType";
  private InventoryTypeEnum inventoryType;

  /**
   * Channel inventory type is a subset of inventory type in that it does not include the &#x60;HOTEL&#x60; type. THe way it works is, as a seller you might want to sell a guest room but instead of showing the price of that guest room, you would like to display the best room type price for the property.
   */
  public enum ChannelInventoryTypeEnum {
    GUEST_ROOM("GUEST_ROOM"),
    
    ADD_ON("ADD_ON"),
    
    MEETING_ROOM("MEETING_ROOM"),
    
    RESTAURANT("RESTAURANT"),
    
    SPA("SPA"),
    
    ATTRACTION("ATTRACTION"),
    
    PLACE("PLACE"),
    
    ACTIVITY("ACTIVITY");

    private String value;

    ChannelInventoryTypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static ChannelInventoryTypeEnum fromValue(String value) {
      for (ChannelInventoryTypeEnum b : ChannelInventoryTypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_CHANNEL_INVENTORY_TYPE = "channelInventoryType";
  private ChannelInventoryTypeEnum channelInventoryType;

  public static final String JSON_PROPERTY_SUPPLIER_IDENTIFIER = "supplierIdentifier";
  private UUID supplierIdentifier;

  public static final String JSON_PROPERTY_CHANNEL_INVENTORY_IDENTIFIER = "channelInventoryIdentifier";
  private UUID channelInventoryIdentifier;

  public static final String JSON_PROPERTY_MULTIMEDIA_IDENTIFIERS = "multimediaIdentifiers";
  private List<String> multimediaIdentifiers = new ArrayList<>();

  public static final String JSON_PROPERTY_ANIMATE = "animate";
  private Boolean animate = false;

  public static final String JSON_PROPERTY_ANIMATE_DELAY = "animateDelay";
  private Integer animateDelay;

  /**
   * The specific badge to display over the image on the Web Component.
   */
  public enum SortEnum {
    MEMBER("MEMBER"),
    
    PRICE_LOW_TO_HIGH("PRICE_LOW_TO_HIGH"),
    
    PRICE_HIGH_TO_LOW("PRICE_HIGH_TO_LOW"),
    
    PRICE("PRICE"),
    
    POPULARITY("POPULARITY"),
    
    ECO("ECO"),
    
    EXPERIENCE("EXPERIENCE"),
    
    PERK("PERK"),
    
    LOYALTY("LOYALTY"),
    
    PACKAGE("PACKAGE");

    private String value;

    SortEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static SortEnum fromValue(String value) {
      for (SortEnum b : SortEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_SORT = "sort";
  private SortEnum sort;

  /**
   * Indicate which initial values to display first on the front-facing card
   */
  public enum DisplayTypeEnum {
    NATIVE("NATIVE"),
    
    HOTEL("HOTEL"),
    
    ROOM("ROOM");

    private String value;

    DisplayTypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static DisplayTypeEnum fromValue(String value) {
      for (DisplayTypeEnum b : DisplayTypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_DISPLAY_TYPE = "displayType";
  private DisplayTypeEnum displayType = DisplayTypeEnum.NATIVE;

  public UpsertSellerInventoryItemRequestAffiliate() {
  }

  public UpsertSellerInventoryItemRequestAffiliate sellerInventoryItemName(String sellerInventoryItemName) {
    
    this.sellerInventoryItemName = sellerInventoryItemName;
    return this;
  }

   /**
   * Descriptive name of this item for seller use
   * @return sellerInventoryItemName
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_SELLER_INVENTORY_ITEM_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getSellerInventoryItemName() {
    return sellerInventoryItemName;
  }


  @JsonProperty(JSON_PROPERTY_SELLER_INVENTORY_ITEM_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setSellerInventoryItemName(String sellerInventoryItemName) {
    this.sellerInventoryItemName = sellerInventoryItemName;
  }


  public UpsertSellerInventoryItemRequestAffiliate engineConfigurationIdentifier(UUID engineConfigurationIdentifier) {
    
    this.engineConfigurationIdentifier = engineConfigurationIdentifier;
    return this;
  }

   /**
   * Which configuration to use with this item
   * @return engineConfigurationIdentifier
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_ENGINE_CONFIGURATION_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public UUID getEngineConfigurationIdentifier() {
    return engineConfigurationIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_ENGINE_CONFIGURATION_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setEngineConfigurationIdentifier(UUID engineConfigurationIdentifier) {
    this.engineConfigurationIdentifier = engineConfigurationIdentifier;
  }


  public UpsertSellerInventoryItemRequestAffiliate descriptions(List<SimpleDescriptionAffiliate> descriptions) {
    
    this.descriptions = descriptions;
    return this;
  }

  public UpsertSellerInventoryItemRequestAffiliate addDescriptionsItem(SimpleDescriptionAffiliate descriptionsItem) {
    if (this.descriptions == null) {
      this.descriptions = new ArrayList<>();
    }
    this.descriptions.add(descriptionsItem);
    return this;
  }

   /**
   * Title and description of inventory.
   * @return descriptions
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid
 @Size(min=1,max=2147483647)
  @JsonProperty(JSON_PROPERTY_DESCRIPTIONS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public List<SimpleDescriptionAffiliate> getDescriptions() {
    return descriptions;
  }


  @JsonProperty(JSON_PROPERTY_DESCRIPTIONS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setDescriptions(List<SimpleDescriptionAffiliate> descriptions) {
    this.descriptions = descriptions;
  }


  public UpsertSellerInventoryItemRequestAffiliate keywords(List<String> keywords) {
    
    this.keywords = keywords;
    return this;
  }

  public UpsertSellerInventoryItemRequestAffiliate addKeywordsItem(String keywordsItem) {
    if (this.keywords == null) {
      this.keywords = new ArrayList<>();
    }
    this.keywords.add(keywordsItem);
    return this;
  }

   /**
   * Get keywords
   * @return keywords
  **/
  @jakarta.annotation.Nonnull
  @NotNull
 @Size(min=1,max=2147483647)
  @JsonProperty(JSON_PROPERTY_KEYWORDS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public List<String> getKeywords() {
    return keywords;
  }


  @JsonProperty(JSON_PROPERTY_KEYWORDS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setKeywords(List<String> keywords) {
    this.keywords = keywords;
  }


  public UpsertSellerInventoryItemRequestAffiliate inventoryType(InventoryTypeEnum inventoryType) {
    
    this.inventoryType = inventoryType;
    return this;
  }

   /**
   * The type of inventory being offer up for sale
   * @return inventoryType
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_INVENTORY_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public InventoryTypeEnum getInventoryType() {
    return inventoryType;
  }


  @JsonProperty(JSON_PROPERTY_INVENTORY_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setInventoryType(InventoryTypeEnum inventoryType) {
    this.inventoryType = inventoryType;
  }


  public UpsertSellerInventoryItemRequestAffiliate channelInventoryType(ChannelInventoryTypeEnum channelInventoryType) {
    
    this.channelInventoryType = channelInventoryType;
    return this;
  }

   /**
   * Channel inventory type is a subset of inventory type in that it does not include the &#x60;HOTEL&#x60; type. THe way it works is, as a seller you might want to sell a guest room but instead of showing the price of that guest room, you would like to display the best room type price for the property.
   * @return channelInventoryType
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_CHANNEL_INVENTORY_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public ChannelInventoryTypeEnum getChannelInventoryType() {
    return channelInventoryType;
  }


  @JsonProperty(JSON_PROPERTY_CHANNEL_INVENTORY_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setChannelInventoryType(ChannelInventoryTypeEnum channelInventoryType) {
    this.channelInventoryType = channelInventoryType;
  }


  public UpsertSellerInventoryItemRequestAffiliate supplierIdentifier(UUID supplierIdentifier) {
    
    this.supplierIdentifier = supplierIdentifier;
    return this;
  }

   /**
   * Supplier / Hotel identifier that owns this inventory.
   * @return supplierIdentifier
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_SUPPLIER_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public UUID getSupplierIdentifier() {
    return supplierIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_SUPPLIER_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setSupplierIdentifier(UUID supplierIdentifier) {
    this.supplierIdentifier = supplierIdentifier;
  }


  public UpsertSellerInventoryItemRequestAffiliate channelInventoryIdentifier(UUID channelInventoryIdentifier) {
    
    this.channelInventoryIdentifier = channelInventoryIdentifier;
    return this;
  }

   /**
   * The channel inventory record identifier describing the relationship between supplier and seller.
   * @return channelInventoryIdentifier
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_CHANNEL_INVENTORY_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public UUID getChannelInventoryIdentifier() {
    return channelInventoryIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_CHANNEL_INVENTORY_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setChannelInventoryIdentifier(UUID channelInventoryIdentifier) {
    this.channelInventoryIdentifier = channelInventoryIdentifier;
  }


  public UpsertSellerInventoryItemRequestAffiliate multimediaIdentifiers(List<String> multimediaIdentifiers) {
    
    this.multimediaIdentifiers = multimediaIdentifiers;
    return this;
  }

  public UpsertSellerInventoryItemRequestAffiliate addMultimediaIdentifiersItem(String multimediaIdentifiersItem) {
    if (this.multimediaIdentifiers == null) {
      this.multimediaIdentifiers = new ArrayList<>();
    }
    this.multimediaIdentifiers.add(multimediaIdentifiersItem);
    return this;
  }

   /**
   * Reference identifiers to Cloudinary media assets
   * @return multimediaIdentifiers
  **/
  @jakarta.annotation.Nonnull
  @NotNull
 @Size(min=1,max=2147483647)
  @JsonProperty(JSON_PROPERTY_MULTIMEDIA_IDENTIFIERS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public List<String> getMultimediaIdentifiers() {
    return multimediaIdentifiers;
  }


  @JsonProperty(JSON_PROPERTY_MULTIMEDIA_IDENTIFIERS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setMultimediaIdentifiers(List<String> multimediaIdentifiers) {
    this.multimediaIdentifiers = multimediaIdentifiers;
  }


  public UpsertSellerInventoryItemRequestAffiliate animate(Boolean animate) {
    
    this.animate = animate;
    return this;
  }

   /**
   * Create an animated gif instead of a list of images. Feature currently not available. Feel free to enable and it will become available at a later date.
   * @return animate
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_ANIMATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getAnimate() {
    return animate;
  }


  @JsonProperty(JSON_PROPERTY_ANIMATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAnimate(Boolean animate) {
    this.animate = animate;
  }


  public UpsertSellerInventoryItemRequestAffiliate animateDelay(Integer animateDelay) {
    
    this.animateDelay = animateDelay;
    return this;
  }

   /**
   * Controls animation delay in milliseconds.
   * @return animateDelay
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_ANIMATE_DELAY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getAnimateDelay() {
    return animateDelay;
  }


  @JsonProperty(JSON_PROPERTY_ANIMATE_DELAY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAnimateDelay(Integer animateDelay) {
    this.animateDelay = animateDelay;
  }


  public UpsertSellerInventoryItemRequestAffiliate sort(SortEnum sort) {
    
    this.sort = sort;
    return this;
  }

   /**
   * The specific badge to display over the image on the Web Component.
   * @return sort
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_SORT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public SortEnum getSort() {
    return sort;
  }


  @JsonProperty(JSON_PROPERTY_SORT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSort(SortEnum sort) {
    this.sort = sort;
  }


  public UpsertSellerInventoryItemRequestAffiliate displayType(DisplayTypeEnum displayType) {
    
    this.displayType = displayType;
    return this;
  }

   /**
   * Indicate which initial values to display first on the front-facing card
   * @return displayType
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_DISPLAY_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public DisplayTypeEnum getDisplayType() {
    return displayType;
  }


  @JsonProperty(JSON_PROPERTY_DISPLAY_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setDisplayType(DisplayTypeEnum displayType) {
    this.displayType = displayType;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    UpsertSellerInventoryItemRequestAffiliate upsertSellerInventoryItemRequestAffiliate = (UpsertSellerInventoryItemRequestAffiliate) o;
    return Objects.equals(this.sellerInventoryItemName, upsertSellerInventoryItemRequestAffiliate.sellerInventoryItemName) &&
        Objects.equals(this.engineConfigurationIdentifier, upsertSellerInventoryItemRequestAffiliate.engineConfigurationIdentifier) &&
        Objects.equals(this.descriptions, upsertSellerInventoryItemRequestAffiliate.descriptions) &&
        Objects.equals(this.keywords, upsertSellerInventoryItemRequestAffiliate.keywords) &&
        Objects.equals(this.inventoryType, upsertSellerInventoryItemRequestAffiliate.inventoryType) &&
        Objects.equals(this.channelInventoryType, upsertSellerInventoryItemRequestAffiliate.channelInventoryType) &&
        Objects.equals(this.supplierIdentifier, upsertSellerInventoryItemRequestAffiliate.supplierIdentifier) &&
        Objects.equals(this.channelInventoryIdentifier, upsertSellerInventoryItemRequestAffiliate.channelInventoryIdentifier) &&
        Objects.equals(this.multimediaIdentifiers, upsertSellerInventoryItemRequestAffiliate.multimediaIdentifiers) &&
        Objects.equals(this.animate, upsertSellerInventoryItemRequestAffiliate.animate) &&
        Objects.equals(this.animateDelay, upsertSellerInventoryItemRequestAffiliate.animateDelay) &&
        Objects.equals(this.sort, upsertSellerInventoryItemRequestAffiliate.sort) &&
        Objects.equals(this.displayType, upsertSellerInventoryItemRequestAffiliate.displayType);
  }

  @Override
  public int hashCode() {
    return Objects.hash(sellerInventoryItemName, engineConfigurationIdentifier, descriptions, keywords, inventoryType, channelInventoryType, supplierIdentifier, channelInventoryIdentifier, multimediaIdentifiers, animate, animateDelay, sort, displayType);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class UpsertSellerInventoryItemRequestAffiliate {\n");
    sb.append("    sellerInventoryItemName: ").append(toIndentedString(sellerInventoryItemName)).append("\n");
    sb.append("    engineConfigurationIdentifier: ").append(toIndentedString(engineConfigurationIdentifier)).append("\n");
    sb.append("    descriptions: ").append(toIndentedString(descriptions)).append("\n");
    sb.append("    keywords: ").append(toIndentedString(keywords)).append("\n");
    sb.append("    inventoryType: ").append(toIndentedString(inventoryType)).append("\n");
    sb.append("    channelInventoryType: ").append(toIndentedString(channelInventoryType)).append("\n");
    sb.append("    supplierIdentifier: ").append(toIndentedString(supplierIdentifier)).append("\n");
    sb.append("    channelInventoryIdentifier: ").append(toIndentedString(channelInventoryIdentifier)).append("\n");
    sb.append("    multimediaIdentifiers: ").append(toIndentedString(multimediaIdentifiers)).append("\n");
    sb.append("    animate: ").append(toIndentedString(animate)).append("\n");
    sb.append("    animateDelay: ").append(toIndentedString(animateDelay)).append("\n");
    sb.append("    sort: ").append(toIndentedString(sort)).append("\n");
    sb.append("    displayType: ").append(toIndentedString(displayType)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

