package travel.wink.sdk.affiliate.api;

import travel.wink.sdk.affiliate.invoker.ApiClient;

import travel.wink.sdk.affiliate.model.BookingAnalyticsSupplier;
import travel.wink.sdk.affiliate.model.BookingOverviewRequestSupplier;
import travel.wink.sdk.affiliate.model.CompanyViewAffiliate;
import travel.wink.sdk.affiliate.model.CreateCompanyRequestAffiliate;
import travel.wink.sdk.affiliate.model.GenericErrorMessage;
import travel.wink.sdk.affiliate.model.GroupedBookingSalesMetricsSupplierDetails;
import travel.wink.sdk.affiliate.model.InviteManagerRequestAffiliate;
import travel.wink.sdk.affiliate.model.RemoveEntryResponseAffiliate;
import travel.wink.sdk.affiliate.model.ShowSupplierUrl400Response;
import travel.wink.sdk.affiliate.model.UniqueRequestAffiliate;
import travel.wink.sdk.affiliate.model.UniqueResultAffiliate;
import travel.wink.sdk.affiliate.model.UpsertAddressRequestAffiliate;
import travel.wink.sdk.affiliate.model.UpsertCompanyLogoRequestAffiliate;
import travel.wink.sdk.affiliate.model.UpsertCompanyRequestAffiliate;
import travel.wink.sdk.affiliate.model.UpsertCompanyStatusRequestAffiliate;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.web.reactive.function.client.WebClient.ResponseSpec;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Flux;

@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-06-21T16:17:19.654348185+07:00[Asia/Bangkok]")
public class CompanyApi {
    private ApiClient apiClient;

    public CompanyApi() {
        this(new ApiClient());
    }

    @Autowired
    public CompanyApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Create company
     * Create a new company
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>201</b> - Created
     * @param createCompanyRequestAffiliate The createCompanyRequestAffiliate parameter
     * @param winkVersion The winkVersion parameter
     * @return CompanyViewAffiliate
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec createCompanyRequestCreation(CreateCompanyRequestAffiliate createCompanyRequestAffiliate, String winkVersion) throws WebClientResponseException {
        Object postBody = createCompanyRequestAffiliate;
        // verify the required parameter 'createCompanyRequestAffiliate' is set
        if (createCompanyRequestAffiliate == null) {
            throw new WebClientResponseException("Missing the required parameter 'createCompanyRequestAffiliate' when calling createCompany", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<CompanyViewAffiliate> localVarReturnType = new ParameterizedTypeReference<CompanyViewAffiliate>() {};
        return apiClient.invokeAPI("/api/company", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Create company
     * Create a new company
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>201</b> - Created
     * @param createCompanyRequestAffiliate The createCompanyRequestAffiliate parameter
     * @param winkVersion The winkVersion parameter
     * @return CompanyViewAffiliate
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<CompanyViewAffiliate> createCompany(CreateCompanyRequestAffiliate createCompanyRequestAffiliate, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<CompanyViewAffiliate> localVarReturnType = new ParameterizedTypeReference<CompanyViewAffiliate>() {};
        return createCompanyRequestCreation(createCompanyRequestAffiliate, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Create company
     * Create a new company
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>201</b> - Created
     * @param createCompanyRequestAffiliate The createCompanyRequestAffiliate parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;CompanyViewAffiliate&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<CompanyViewAffiliate>> createCompanyWithHttpInfo(CreateCompanyRequestAffiliate createCompanyRequestAffiliate, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<CompanyViewAffiliate> localVarReturnType = new ParameterizedTypeReference<CompanyViewAffiliate>() {};
        return createCompanyRequestCreation(createCompanyRequestAffiliate, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Create company
     * Create a new company
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>201</b> - Created
     * @param createCompanyRequestAffiliate The createCompanyRequestAffiliate parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec createCompanyWithResponseSpec(CreateCompanyRequestAffiliate createCompanyRequestAffiliate, String winkVersion) throws WebClientResponseException {
        return createCompanyRequestCreation(createCompanyRequestAffiliate, winkVersion);
    }
    /**
     * Invite Manager
     * Invite user to be a manager for this company.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier The companyIdentifier parameter
     * @param inviteManagerRequestAffiliate The inviteManagerRequestAffiliate parameter
     * @param winkVersion The winkVersion parameter
     * @return CompanyViewAffiliate
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec inviteManagerRequestCreation(String companyIdentifier, InviteManagerRequestAffiliate inviteManagerRequestAffiliate, String winkVersion) throws WebClientResponseException {
        Object postBody = inviteManagerRequestAffiliate;
        // verify the required parameter 'companyIdentifier' is set
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling inviteManager", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'inviteManagerRequestAffiliate' is set
        if (inviteManagerRequestAffiliate == null) {
            throw new WebClientResponseException("Missing the required parameter 'inviteManagerRequestAffiliate' when calling inviteManager", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("companyIdentifier", companyIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<CompanyViewAffiliate> localVarReturnType = new ParameterizedTypeReference<CompanyViewAffiliate>() {};
        return apiClient.invokeAPI("/api/company/{companyIdentifier}/manager/invite", HttpMethod.PATCH, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Invite Manager
     * Invite user to be a manager for this company.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier The companyIdentifier parameter
     * @param inviteManagerRequestAffiliate The inviteManagerRequestAffiliate parameter
     * @param winkVersion The winkVersion parameter
     * @return CompanyViewAffiliate
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<CompanyViewAffiliate> inviteManager(String companyIdentifier, InviteManagerRequestAffiliate inviteManagerRequestAffiliate, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<CompanyViewAffiliate> localVarReturnType = new ParameterizedTypeReference<CompanyViewAffiliate>() {};
        return inviteManagerRequestCreation(companyIdentifier, inviteManagerRequestAffiliate, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Invite Manager
     * Invite user to be a manager for this company.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier The companyIdentifier parameter
     * @param inviteManagerRequestAffiliate The inviteManagerRequestAffiliate parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;CompanyViewAffiliate&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<CompanyViewAffiliate>> inviteManagerWithHttpInfo(String companyIdentifier, InviteManagerRequestAffiliate inviteManagerRequestAffiliate, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<CompanyViewAffiliate> localVarReturnType = new ParameterizedTypeReference<CompanyViewAffiliate>() {};
        return inviteManagerRequestCreation(companyIdentifier, inviteManagerRequestAffiliate, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Invite Manager
     * Invite user to be a manager for this company.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier The companyIdentifier parameter
     * @param inviteManagerRequestAffiliate The inviteManagerRequestAffiliate parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec inviteManagerWithResponseSpec(String companyIdentifier, InviteManagerRequestAffiliate inviteManagerRequestAffiliate, String winkVersion) throws WebClientResponseException {
        return inviteManagerRequestCreation(companyIdentifier, inviteManagerRequestAffiliate, winkVersion);
    }
    /**
     * Verify company name
     * Check if company name is unique
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param uniqueRequestAffiliate The uniqueRequestAffiliate parameter
     * @param winkVersion The winkVersion parameter
     * @return UniqueResultAffiliate
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec isCompanyNameUniqueRequestCreation(UniqueRequestAffiliate uniqueRequestAffiliate, String winkVersion) throws WebClientResponseException {
        Object postBody = uniqueRequestAffiliate;
        // verify the required parameter 'uniqueRequestAffiliate' is set
        if (uniqueRequestAffiliate == null) {
            throw new WebClientResponseException("Missing the required parameter 'uniqueRequestAffiliate' when calling isCompanyNameUnique", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<UniqueResultAffiliate> localVarReturnType = new ParameterizedTypeReference<UniqueResultAffiliate>() {};
        return apiClient.invokeAPI("/api/company/unique", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Verify company name
     * Check if company name is unique
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param uniqueRequestAffiliate The uniqueRequestAffiliate parameter
     * @param winkVersion The winkVersion parameter
     * @return UniqueResultAffiliate
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<UniqueResultAffiliate> isCompanyNameUnique(UniqueRequestAffiliate uniqueRequestAffiliate, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<UniqueResultAffiliate> localVarReturnType = new ParameterizedTypeReference<UniqueResultAffiliate>() {};
        return isCompanyNameUniqueRequestCreation(uniqueRequestAffiliate, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Verify company name
     * Check if company name is unique
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param uniqueRequestAffiliate The uniqueRequestAffiliate parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;UniqueResultAffiliate&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<UniqueResultAffiliate>> isCompanyNameUniqueWithHttpInfo(UniqueRequestAffiliate uniqueRequestAffiliate, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<UniqueResultAffiliate> localVarReturnType = new ParameterizedTypeReference<UniqueResultAffiliate>() {};
        return isCompanyNameUniqueRequestCreation(uniqueRequestAffiliate, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Verify company name
     * Check if company name is unique
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param uniqueRequestAffiliate The uniqueRequestAffiliate parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec isCompanyNameUniqueWithResponseSpec(UniqueRequestAffiliate uniqueRequestAffiliate, String winkVersion) throws WebClientResponseException {
        return isCompanyNameUniqueRequestCreation(uniqueRequestAffiliate, winkVersion);
    }
    /**
     * Delete Company
     * Delete a company by identifier
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>202</b> - Accepted
     * @param companyIdentifier The companyIdentifier parameter
     * @param winkVersion The winkVersion parameter
     * @return RemoveEntryResponseAffiliate
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec removeCompanyRequestCreation(String companyIdentifier, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'companyIdentifier' is set
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling removeCompany", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("companyIdentifier", companyIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<RemoveEntryResponseAffiliate> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponseAffiliate>() {};
        return apiClient.invokeAPI("/api/company/{companyIdentifier}", HttpMethod.DELETE, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Delete Company
     * Delete a company by identifier
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>202</b> - Accepted
     * @param companyIdentifier The companyIdentifier parameter
     * @param winkVersion The winkVersion parameter
     * @return RemoveEntryResponseAffiliate
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<RemoveEntryResponseAffiliate> removeCompany(String companyIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<RemoveEntryResponseAffiliate> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponseAffiliate>() {};
        return removeCompanyRequestCreation(companyIdentifier, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Delete Company
     * Delete a company by identifier
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>202</b> - Accepted
     * @param companyIdentifier The companyIdentifier parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;RemoveEntryResponseAffiliate&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<RemoveEntryResponseAffiliate>> removeCompanyWithHttpInfo(String companyIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<RemoveEntryResponseAffiliate> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponseAffiliate>() {};
        return removeCompanyRequestCreation(companyIdentifier, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Delete Company
     * Delete a company by identifier
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>202</b> - Accepted
     * @param companyIdentifier The companyIdentifier parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec removeCompanyWithResponseSpec(String companyIdentifier, String winkVersion) throws WebClientResponseException {
        return removeCompanyRequestCreation(companyIdentifier, winkVersion);
    }
    /**
     * Remove Manager
     * Disassociate user from this company.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier The companyIdentifier parameter
     * @param email The email parameter
     * @param winkVersion The winkVersion parameter
     * @return CompanyViewAffiliate
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec removeCompanyUserRequestCreation(String companyIdentifier, String email, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'companyIdentifier' is set
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling removeCompanyUser", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'email' is set
        if (email == null) {
            throw new WebClientResponseException("Missing the required parameter 'email' when calling removeCompanyUser", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("companyIdentifier", companyIdentifier);
        pathParams.put("email", email);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<CompanyViewAffiliate> localVarReturnType = new ParameterizedTypeReference<CompanyViewAffiliate>() {};
        return apiClient.invokeAPI("/api/company/{companyIdentifier}/manager/{email}", HttpMethod.DELETE, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Remove Manager
     * Disassociate user from this company.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier The companyIdentifier parameter
     * @param email The email parameter
     * @param winkVersion The winkVersion parameter
     * @return CompanyViewAffiliate
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<CompanyViewAffiliate> removeCompanyUser(String companyIdentifier, String email, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<CompanyViewAffiliate> localVarReturnType = new ParameterizedTypeReference<CompanyViewAffiliate>() {};
        return removeCompanyUserRequestCreation(companyIdentifier, email, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Remove Manager
     * Disassociate user from this company.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier The companyIdentifier parameter
     * @param email The email parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;CompanyViewAffiliate&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<CompanyViewAffiliate>> removeCompanyUserWithHttpInfo(String companyIdentifier, String email, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<CompanyViewAffiliate> localVarReturnType = new ParameterizedTypeReference<CompanyViewAffiliate>() {};
        return removeCompanyUserRequestCreation(companyIdentifier, email, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Remove Manager
     * Disassociate user from this company.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier The companyIdentifier parameter
     * @param email The email parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec removeCompanyUserWithResponseSpec(String companyIdentifier, String email, String winkVersion) throws WebClientResponseException {
        return removeCompanyUserRequestCreation(companyIdentifier, email, winkVersion);
    }
    /**
     * Company Booking Analytics
     * Retrieve the number of upcoming bookings that arrive today for the specific company.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier Show active booking count for company with this identifier
     * @param bookingOverviewRequestSupplier Overview request body
     * @param winkVersion The winkVersion parameter
     * @return BookingAnalyticsSupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showBookingAnalyticsRequestCreation(String companyIdentifier, BookingOverviewRequestSupplier bookingOverviewRequestSupplier, String winkVersion) throws WebClientResponseException {
        Object postBody = bookingOverviewRequestSupplier;
        // verify the required parameter 'companyIdentifier' is set
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling showBookingAnalytics", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'bookingOverviewRequestSupplier' is set
        if (bookingOverviewRequestSupplier == null) {
            throw new WebClientResponseException("Missing the required parameter 'bookingOverviewRequestSupplier' when calling showBookingAnalytics", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("companyIdentifier", companyIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<BookingAnalyticsSupplier> localVarReturnType = new ParameterizedTypeReference<BookingAnalyticsSupplier>() {};
        return apiClient.invokeAPI("/api/company/{companyIdentifier}/booking/analytics", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Company Booking Analytics
     * Retrieve the number of upcoming bookings that arrive today for the specific company.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier Show active booking count for company with this identifier
     * @param bookingOverviewRequestSupplier Overview request body
     * @param winkVersion The winkVersion parameter
     * @return BookingAnalyticsSupplier
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<BookingAnalyticsSupplier> showBookingAnalytics(String companyIdentifier, BookingOverviewRequestSupplier bookingOverviewRequestSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<BookingAnalyticsSupplier> localVarReturnType = new ParameterizedTypeReference<BookingAnalyticsSupplier>() {};
        return showBookingAnalyticsRequestCreation(companyIdentifier, bookingOverviewRequestSupplier, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Company Booking Analytics
     * Retrieve the number of upcoming bookings that arrive today for the specific company.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier Show active booking count for company with this identifier
     * @param bookingOverviewRequestSupplier Overview request body
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;BookingAnalyticsSupplier&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<BookingAnalyticsSupplier>> showBookingAnalyticsWithHttpInfo(String companyIdentifier, BookingOverviewRequestSupplier bookingOverviewRequestSupplier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<BookingAnalyticsSupplier> localVarReturnType = new ParameterizedTypeReference<BookingAnalyticsSupplier>() {};
        return showBookingAnalyticsRequestCreation(companyIdentifier, bookingOverviewRequestSupplier, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Company Booking Analytics
     * Retrieve the number of upcoming bookings that arrive today for the specific company.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier Show active booking count for company with this identifier
     * @param bookingOverviewRequestSupplier Overview request body
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec showBookingAnalyticsWithResponseSpec(String companyIdentifier, BookingOverviewRequestSupplier bookingOverviewRequestSupplier, String winkVersion) throws WebClientResponseException {
        return showBookingAnalyticsRequestCreation(companyIdentifier, bookingOverviewRequestSupplier, winkVersion);
    }
    /**
     * Company Booking Overview
     * Basic booking overview data
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier Show booking owned by this company
     * @param winkVersion The winkVersion parameter
     * @return GroupedBookingSalesMetricsSupplierDetails
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showBookingOverviewRequestCreation(String companyIdentifier, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'companyIdentifier' is set
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling showBookingOverview", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("companyIdentifier", companyIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<GroupedBookingSalesMetricsSupplierDetails> localVarReturnType = new ParameterizedTypeReference<GroupedBookingSalesMetricsSupplierDetails>() {};
        return apiClient.invokeAPI("/api/company/{companyIdentifier}/booking/overview", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Company Booking Overview
     * Basic booking overview data
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier Show booking owned by this company
     * @param winkVersion The winkVersion parameter
     * @return GroupedBookingSalesMetricsSupplierDetails
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<GroupedBookingSalesMetricsSupplierDetails> showBookingOverview(String companyIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<GroupedBookingSalesMetricsSupplierDetails> localVarReturnType = new ParameterizedTypeReference<GroupedBookingSalesMetricsSupplierDetails>() {};
        return showBookingOverviewRequestCreation(companyIdentifier, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Company Booking Overview
     * Basic booking overview data
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier Show booking owned by this company
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;GroupedBookingSalesMetricsSupplierDetails&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<GroupedBookingSalesMetricsSupplierDetails>> showBookingOverviewWithHttpInfo(String companyIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<GroupedBookingSalesMetricsSupplierDetails> localVarReturnType = new ParameterizedTypeReference<GroupedBookingSalesMetricsSupplierDetails>() {};
        return showBookingOverviewRequestCreation(companyIdentifier, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Company Booking Overview
     * Basic booking overview data
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier Show booking owned by this company
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec showBookingOverviewWithResponseSpec(String companyIdentifier, String winkVersion) throws WebClientResponseException {
        return showBookingOverviewRequestCreation(companyIdentifier, winkVersion);
    }
    /**
     * Show Companies
     * List all companies owned by caller
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param winkVersion The winkVersion parameter
     * @return List&lt;CompanyViewAffiliate&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showCompaniesRequestCreation(String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<CompanyViewAffiliate> localVarReturnType = new ParameterizedTypeReference<CompanyViewAffiliate>() {};
        return apiClient.invokeAPI("/api/company/list", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Companies
     * List all companies owned by caller
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param winkVersion The winkVersion parameter
     * @return List&lt;CompanyViewAffiliate&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Flux<CompanyViewAffiliate> showCompanies(String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<CompanyViewAffiliate> localVarReturnType = new ParameterizedTypeReference<CompanyViewAffiliate>() {};
        return showCompaniesRequestCreation(winkVersion).bodyToFlux(localVarReturnType);
    }

    /**
     * Show Companies
     * List all companies owned by caller
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;List&lt;CompanyViewAffiliate&gt;&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<List<CompanyViewAffiliate>>> showCompaniesWithHttpInfo(String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<CompanyViewAffiliate> localVarReturnType = new ParameterizedTypeReference<CompanyViewAffiliate>() {};
        return showCompaniesRequestCreation(winkVersion).toEntityList(localVarReturnType);
    }

    /**
     * Show Companies
     * List all companies owned by caller
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec showCompaniesWithResponseSpec(String winkVersion) throws WebClientResponseException {
        return showCompaniesRequestCreation(winkVersion);
    }
    /**
     * Show Company
     * Retrieve company by identifier
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier The companyIdentifier parameter
     * @param winkVersion The winkVersion parameter
     * @return CompanyViewAffiliate
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showCompanyRequestCreation(String companyIdentifier, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'companyIdentifier' is set
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling showCompany", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("companyIdentifier", companyIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<CompanyViewAffiliate> localVarReturnType = new ParameterizedTypeReference<CompanyViewAffiliate>() {};
        return apiClient.invokeAPI("/api/company/{companyIdentifier}", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Company
     * Retrieve company by identifier
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier The companyIdentifier parameter
     * @param winkVersion The winkVersion parameter
     * @return CompanyViewAffiliate
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<CompanyViewAffiliate> showCompany(String companyIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<CompanyViewAffiliate> localVarReturnType = new ParameterizedTypeReference<CompanyViewAffiliate>() {};
        return showCompanyRequestCreation(companyIdentifier, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Show Company
     * Retrieve company by identifier
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier The companyIdentifier parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;CompanyViewAffiliate&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<CompanyViewAffiliate>> showCompanyWithHttpInfo(String companyIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<CompanyViewAffiliate> localVarReturnType = new ParameterizedTypeReference<CompanyViewAffiliate>() {};
        return showCompanyRequestCreation(companyIdentifier, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Show Company
     * Retrieve company by identifier
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier The companyIdentifier parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec showCompanyWithResponseSpec(String companyIdentifier, String winkVersion) throws WebClientResponseException {
        return showCompanyRequestCreation(companyIdentifier, winkVersion);
    }
    /**
     * Update Company
     * Update an existing company
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier The companyIdentifier parameter
     * @param upsertCompanyRequestAffiliate The upsertCompanyRequestAffiliate parameter
     * @param winkVersion The winkVersion parameter
     * @return CompanyViewAffiliate
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec updateCompanyRequestCreation(String companyIdentifier, UpsertCompanyRequestAffiliate upsertCompanyRequestAffiliate, String winkVersion) throws WebClientResponseException {
        Object postBody = upsertCompanyRequestAffiliate;
        // verify the required parameter 'companyIdentifier' is set
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling updateCompany", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'upsertCompanyRequestAffiliate' is set
        if (upsertCompanyRequestAffiliate == null) {
            throw new WebClientResponseException("Missing the required parameter 'upsertCompanyRequestAffiliate' when calling updateCompany", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("companyIdentifier", companyIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<CompanyViewAffiliate> localVarReturnType = new ParameterizedTypeReference<CompanyViewAffiliate>() {};
        return apiClient.invokeAPI("/api/company/{companyIdentifier}", HttpMethod.PATCH, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Update Company
     * Update an existing company
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier The companyIdentifier parameter
     * @param upsertCompanyRequestAffiliate The upsertCompanyRequestAffiliate parameter
     * @param winkVersion The winkVersion parameter
     * @return CompanyViewAffiliate
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<CompanyViewAffiliate> updateCompany(String companyIdentifier, UpsertCompanyRequestAffiliate upsertCompanyRequestAffiliate, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<CompanyViewAffiliate> localVarReturnType = new ParameterizedTypeReference<CompanyViewAffiliate>() {};
        return updateCompanyRequestCreation(companyIdentifier, upsertCompanyRequestAffiliate, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Update Company
     * Update an existing company
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier The companyIdentifier parameter
     * @param upsertCompanyRequestAffiliate The upsertCompanyRequestAffiliate parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;CompanyViewAffiliate&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<CompanyViewAffiliate>> updateCompanyWithHttpInfo(String companyIdentifier, UpsertCompanyRequestAffiliate upsertCompanyRequestAffiliate, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<CompanyViewAffiliate> localVarReturnType = new ParameterizedTypeReference<CompanyViewAffiliate>() {};
        return updateCompanyRequestCreation(companyIdentifier, upsertCompanyRequestAffiliate, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Update Company
     * Update an existing company
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier The companyIdentifier parameter
     * @param upsertCompanyRequestAffiliate The upsertCompanyRequestAffiliate parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec updateCompanyWithResponseSpec(String companyIdentifier, UpsertCompanyRequestAffiliate upsertCompanyRequestAffiliate, String winkVersion) throws WebClientResponseException {
        return updateCompanyRequestCreation(companyIdentifier, upsertCompanyRequestAffiliate, winkVersion);
    }
    /**
     * Toggle Company Status
     * Update company status
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier The companyIdentifier parameter
     * @param upsertCompanyStatusRequestAffiliate The upsertCompanyStatusRequestAffiliate parameter
     * @param winkVersion The winkVersion parameter
     * @return CompanyViewAffiliate
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec updateCompany1RequestCreation(String companyIdentifier, UpsertCompanyStatusRequestAffiliate upsertCompanyStatusRequestAffiliate, String winkVersion) throws WebClientResponseException {
        Object postBody = upsertCompanyStatusRequestAffiliate;
        // verify the required parameter 'companyIdentifier' is set
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling updateCompany1", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'upsertCompanyStatusRequestAffiliate' is set
        if (upsertCompanyStatusRequestAffiliate == null) {
            throw new WebClientResponseException("Missing the required parameter 'upsertCompanyStatusRequestAffiliate' when calling updateCompany1", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("companyIdentifier", companyIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<CompanyViewAffiliate> localVarReturnType = new ParameterizedTypeReference<CompanyViewAffiliate>() {};
        return apiClient.invokeAPI("/api/company/{companyIdentifier}/status", HttpMethod.PATCH, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Toggle Company Status
     * Update company status
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier The companyIdentifier parameter
     * @param upsertCompanyStatusRequestAffiliate The upsertCompanyStatusRequestAffiliate parameter
     * @param winkVersion The winkVersion parameter
     * @return CompanyViewAffiliate
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<CompanyViewAffiliate> updateCompany1(String companyIdentifier, UpsertCompanyStatusRequestAffiliate upsertCompanyStatusRequestAffiliate, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<CompanyViewAffiliate> localVarReturnType = new ParameterizedTypeReference<CompanyViewAffiliate>() {};
        return updateCompany1RequestCreation(companyIdentifier, upsertCompanyStatusRequestAffiliate, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Toggle Company Status
     * Update company status
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier The companyIdentifier parameter
     * @param upsertCompanyStatusRequestAffiliate The upsertCompanyStatusRequestAffiliate parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;CompanyViewAffiliate&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<CompanyViewAffiliate>> updateCompany1WithHttpInfo(String companyIdentifier, UpsertCompanyStatusRequestAffiliate upsertCompanyStatusRequestAffiliate, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<CompanyViewAffiliate> localVarReturnType = new ParameterizedTypeReference<CompanyViewAffiliate>() {};
        return updateCompany1RequestCreation(companyIdentifier, upsertCompanyStatusRequestAffiliate, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Toggle Company Status
     * Update company status
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier The companyIdentifier parameter
     * @param upsertCompanyStatusRequestAffiliate The upsertCompanyStatusRequestAffiliate parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec updateCompany1WithResponseSpec(String companyIdentifier, UpsertCompanyStatusRequestAffiliate upsertCompanyStatusRequestAffiliate, String winkVersion) throws WebClientResponseException {
        return updateCompany1RequestCreation(companyIdentifier, upsertCompanyStatusRequestAffiliate, winkVersion);
    }
    /**
     * Update Company Address
     * Updates company address.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier The companyIdentifier parameter
     * @param upsertAddressRequestAffiliate The upsertAddressRequestAffiliate parameter
     * @param winkVersion The winkVersion parameter
     * @return CompanyViewAffiliate
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec updateCompanyAddressRequestCreation(String companyIdentifier, UpsertAddressRequestAffiliate upsertAddressRequestAffiliate, String winkVersion) throws WebClientResponseException {
        Object postBody = upsertAddressRequestAffiliate;
        // verify the required parameter 'companyIdentifier' is set
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling updateCompanyAddress", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'upsertAddressRequestAffiliate' is set
        if (upsertAddressRequestAffiliate == null) {
            throw new WebClientResponseException("Missing the required parameter 'upsertAddressRequestAffiliate' when calling updateCompanyAddress", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("companyIdentifier", companyIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<CompanyViewAffiliate> localVarReturnType = new ParameterizedTypeReference<CompanyViewAffiliate>() {};
        return apiClient.invokeAPI("/api/company/{companyIdentifier}/address", HttpMethod.PATCH, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Update Company Address
     * Updates company address.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier The companyIdentifier parameter
     * @param upsertAddressRequestAffiliate The upsertAddressRequestAffiliate parameter
     * @param winkVersion The winkVersion parameter
     * @return CompanyViewAffiliate
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<CompanyViewAffiliate> updateCompanyAddress(String companyIdentifier, UpsertAddressRequestAffiliate upsertAddressRequestAffiliate, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<CompanyViewAffiliate> localVarReturnType = new ParameterizedTypeReference<CompanyViewAffiliate>() {};
        return updateCompanyAddressRequestCreation(companyIdentifier, upsertAddressRequestAffiliate, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Update Company Address
     * Updates company address.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier The companyIdentifier parameter
     * @param upsertAddressRequestAffiliate The upsertAddressRequestAffiliate parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;CompanyViewAffiliate&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<CompanyViewAffiliate>> updateCompanyAddressWithHttpInfo(String companyIdentifier, UpsertAddressRequestAffiliate upsertAddressRequestAffiliate, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<CompanyViewAffiliate> localVarReturnType = new ParameterizedTypeReference<CompanyViewAffiliate>() {};
        return updateCompanyAddressRequestCreation(companyIdentifier, upsertAddressRequestAffiliate, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Update Company Address
     * Updates company address.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier The companyIdentifier parameter
     * @param upsertAddressRequestAffiliate The upsertAddressRequestAffiliate parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec updateCompanyAddressWithResponseSpec(String companyIdentifier, UpsertAddressRequestAffiliate upsertAddressRequestAffiliate, String winkVersion) throws WebClientResponseException {
        return updateCompanyAddressRequestCreation(companyIdentifier, upsertAddressRequestAffiliate, winkVersion);
    }
    /**
     * Update Company Logo
     * Updates company logo.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier The companyIdentifier parameter
     * @param upsertCompanyLogoRequestAffiliate The upsertCompanyLogoRequestAffiliate parameter
     * @param winkVersion The winkVersion parameter
     * @return CompanyViewAffiliate
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec updateCompanyPhotoRequestCreation(String companyIdentifier, UpsertCompanyLogoRequestAffiliate upsertCompanyLogoRequestAffiliate, String winkVersion) throws WebClientResponseException {
        Object postBody = upsertCompanyLogoRequestAffiliate;
        // verify the required parameter 'companyIdentifier' is set
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling updateCompanyPhoto", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'upsertCompanyLogoRequestAffiliate' is set
        if (upsertCompanyLogoRequestAffiliate == null) {
            throw new WebClientResponseException("Missing the required parameter 'upsertCompanyLogoRequestAffiliate' when calling updateCompanyPhoto", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("companyIdentifier", companyIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<CompanyViewAffiliate> localVarReturnType = new ParameterizedTypeReference<CompanyViewAffiliate>() {};
        return apiClient.invokeAPI("/api/company/{companyIdentifier}/logo", HttpMethod.PATCH, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Update Company Logo
     * Updates company logo.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier The companyIdentifier parameter
     * @param upsertCompanyLogoRequestAffiliate The upsertCompanyLogoRequestAffiliate parameter
     * @param winkVersion The winkVersion parameter
     * @return CompanyViewAffiliate
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<CompanyViewAffiliate> updateCompanyPhoto(String companyIdentifier, UpsertCompanyLogoRequestAffiliate upsertCompanyLogoRequestAffiliate, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<CompanyViewAffiliate> localVarReturnType = new ParameterizedTypeReference<CompanyViewAffiliate>() {};
        return updateCompanyPhotoRequestCreation(companyIdentifier, upsertCompanyLogoRequestAffiliate, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Update Company Logo
     * Updates company logo.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier The companyIdentifier parameter
     * @param upsertCompanyLogoRequestAffiliate The upsertCompanyLogoRequestAffiliate parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;CompanyViewAffiliate&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<CompanyViewAffiliate>> updateCompanyPhotoWithHttpInfo(String companyIdentifier, UpsertCompanyLogoRequestAffiliate upsertCompanyLogoRequestAffiliate, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<CompanyViewAffiliate> localVarReturnType = new ParameterizedTypeReference<CompanyViewAffiliate>() {};
        return updateCompanyPhotoRequestCreation(companyIdentifier, upsertCompanyLogoRequestAffiliate, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Update Company Logo
     * Updates company logo.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier The companyIdentifier parameter
     * @param upsertCompanyLogoRequestAffiliate The upsertCompanyLogoRequestAffiliate parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec updateCompanyPhotoWithResponseSpec(String companyIdentifier, UpsertCompanyLogoRequestAffiliate upsertCompanyLogoRequestAffiliate, String winkVersion) throws WebClientResponseException {
        return updateCompanyPhotoRequestCreation(companyIdentifier, upsertCompanyLogoRequestAffiliate, winkVersion);
    }
}
