package travel.wink.sdk.affiliate.api;

import travel.wink.sdk.affiliate.invoker.ApiClient;

import travel.wink.sdk.affiliate.model.BooleanResponseAffiliate;
import travel.wink.sdk.affiliate.model.ConsumeExternalUrlRequestAffiliate;
import travel.wink.sdk.affiliate.model.GenericErrorMessage;
import travel.wink.sdk.affiliate.model.RemoveEntryResponseAffiliate;
import travel.wink.sdk.affiliate.model.ShowSupplierUrl400Response;
import travel.wink.sdk.affiliate.model.SortedAffiliate;
import travel.wink.sdk.affiliate.model.SyndicationCategoryAffiliate;
import travel.wink.sdk.affiliate.model.SyndicationEntryAffiliate;
import travel.wink.sdk.affiliate.model.SyndicationSettingsAffiliate;
import travel.wink.sdk.affiliate.model.UpsertSyndicationCategoryAffiliate;
import travel.wink.sdk.affiliate.model.UpsertSyndicationEntryAffiliate;
import travel.wink.sdk.affiliate.model.UpsertSyndicationSettingsAffiliate;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.web.reactive.function.client.WebClient.ResponseSpec;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Flux;

@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-06-21T16:17:19.654348185+07:00[Asia/Bangkok]")
public class SyndicationEntryPublisherApi {
    private ApiClient apiClient;

    public SyndicationEntryPublisherApi() {
        this(new ApiClient());
    }

    @Autowired
    public SyndicationEntryPublisherApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Consume external URL
     * Utility method for reading Open Graph data from an external URL.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier Consume URL for this owner identifier.
     * @param consumeExternalUrlRequestAffiliate Body payload filtering and sorting preferences
     * @param winkVersion The winkVersion parameter
     * @return UpsertSyndicationEntryAffiliate
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec consumeExternalUrlForSyndicationEntryRequestCreation(String companyIdentifier, ConsumeExternalUrlRequestAffiliate consumeExternalUrlRequestAffiliate, String winkVersion) throws WebClientResponseException {
        Object postBody = consumeExternalUrlRequestAffiliate;
        // verify the required parameter 'companyIdentifier' is set
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling consumeExternalUrlForSyndicationEntry", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'consumeExternalUrlRequestAffiliate' is set
        if (consumeExternalUrlRequestAffiliate == null) {
            throw new WebClientResponseException("Missing the required parameter 'consumeExternalUrlRequestAffiliate' when calling consumeExternalUrlForSyndicationEntry", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("companyIdentifier", companyIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<UpsertSyndicationEntryAffiliate> localVarReturnType = new ParameterizedTypeReference<UpsertSyndicationEntryAffiliate>() {};
        return apiClient.invokeAPI("/api/company/{companyIdentifier}/syndication/entry/consume-url", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Consume external URL
     * Utility method for reading Open Graph data from an external URL.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier Consume URL for this owner identifier.
     * @param consumeExternalUrlRequestAffiliate Body payload filtering and sorting preferences
     * @param winkVersion The winkVersion parameter
     * @return UpsertSyndicationEntryAffiliate
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<UpsertSyndicationEntryAffiliate> consumeExternalUrlForSyndicationEntry(String companyIdentifier, ConsumeExternalUrlRequestAffiliate consumeExternalUrlRequestAffiliate, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<UpsertSyndicationEntryAffiliate> localVarReturnType = new ParameterizedTypeReference<UpsertSyndicationEntryAffiliate>() {};
        return consumeExternalUrlForSyndicationEntryRequestCreation(companyIdentifier, consumeExternalUrlRequestAffiliate, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Consume external URL
     * Utility method for reading Open Graph data from an external URL.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier Consume URL for this owner identifier.
     * @param consumeExternalUrlRequestAffiliate Body payload filtering and sorting preferences
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;UpsertSyndicationEntryAffiliate&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<UpsertSyndicationEntryAffiliate>> consumeExternalUrlForSyndicationEntryWithHttpInfo(String companyIdentifier, ConsumeExternalUrlRequestAffiliate consumeExternalUrlRequestAffiliate, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<UpsertSyndicationEntryAffiliate> localVarReturnType = new ParameterizedTypeReference<UpsertSyndicationEntryAffiliate>() {};
        return consumeExternalUrlForSyndicationEntryRequestCreation(companyIdentifier, consumeExternalUrlRequestAffiliate, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Consume external URL
     * Utility method for reading Open Graph data from an external URL.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier Consume URL for this owner identifier.
     * @param consumeExternalUrlRequestAffiliate Body payload filtering and sorting preferences
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec consumeExternalUrlForSyndicationEntryWithResponseSpec(String companyIdentifier, ConsumeExternalUrlRequestAffiliate consumeExternalUrlRequestAffiliate, String winkVersion) throws WebClientResponseException {
        return consumeExternalUrlForSyndicationEntryRequestCreation(companyIdentifier, consumeExternalUrlRequestAffiliate, winkVersion);
    }
    /**
     * Create syndication category
     * Creates a new syndication category.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>201</b> - Created
     * @param companyIdentifier Create category for this owner identifier.
     * @param upsertSyndicationCategoryAffiliate Request body
     * @param winkVersion The winkVersion parameter
     * @return SyndicationCategoryAffiliate
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec createSyndicationCategoryRequestCreation(String companyIdentifier, UpsertSyndicationCategoryAffiliate upsertSyndicationCategoryAffiliate, String winkVersion) throws WebClientResponseException {
        Object postBody = upsertSyndicationCategoryAffiliate;
        // verify the required parameter 'companyIdentifier' is set
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling createSyndicationCategory", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'upsertSyndicationCategoryAffiliate' is set
        if (upsertSyndicationCategoryAffiliate == null) {
            throw new WebClientResponseException("Missing the required parameter 'upsertSyndicationCategoryAffiliate' when calling createSyndicationCategory", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("companyIdentifier", companyIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<SyndicationCategoryAffiliate> localVarReturnType = new ParameterizedTypeReference<SyndicationCategoryAffiliate>() {};
        return apiClient.invokeAPI("/api/company/{companyIdentifier}/syndication/category", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Create syndication category
     * Creates a new syndication category.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>201</b> - Created
     * @param companyIdentifier Create category for this owner identifier.
     * @param upsertSyndicationCategoryAffiliate Request body
     * @param winkVersion The winkVersion parameter
     * @return SyndicationCategoryAffiliate
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<SyndicationCategoryAffiliate> createSyndicationCategory(String companyIdentifier, UpsertSyndicationCategoryAffiliate upsertSyndicationCategoryAffiliate, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<SyndicationCategoryAffiliate> localVarReturnType = new ParameterizedTypeReference<SyndicationCategoryAffiliate>() {};
        return createSyndicationCategoryRequestCreation(companyIdentifier, upsertSyndicationCategoryAffiliate, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Create syndication category
     * Creates a new syndication category.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>201</b> - Created
     * @param companyIdentifier Create category for this owner identifier.
     * @param upsertSyndicationCategoryAffiliate Request body
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;SyndicationCategoryAffiliate&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<SyndicationCategoryAffiliate>> createSyndicationCategoryWithHttpInfo(String companyIdentifier, UpsertSyndicationCategoryAffiliate upsertSyndicationCategoryAffiliate, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<SyndicationCategoryAffiliate> localVarReturnType = new ParameterizedTypeReference<SyndicationCategoryAffiliate>() {};
        return createSyndicationCategoryRequestCreation(companyIdentifier, upsertSyndicationCategoryAffiliate, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Create syndication category
     * Creates a new syndication category.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>201</b> - Created
     * @param companyIdentifier Create category for this owner identifier.
     * @param upsertSyndicationCategoryAffiliate Request body
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec createSyndicationCategoryWithResponseSpec(String companyIdentifier, UpsertSyndicationCategoryAffiliate upsertSyndicationCategoryAffiliate, String winkVersion) throws WebClientResponseException {
        return createSyndicationCategoryRequestCreation(companyIdentifier, upsertSyndicationCategoryAffiliate, winkVersion);
    }
    /**
     * Create syndication entry
     * Creates a new syndication entry.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>201</b> - Created
     * @param companyIdentifier Create entry for this owner identifier.
     * @param upsertSyndicationEntryAffiliate Request body
     * @param winkVersion The winkVersion parameter
     * @return SyndicationEntryAffiliate
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec createSyndicationEntryRequestCreation(String companyIdentifier, UpsertSyndicationEntryAffiliate upsertSyndicationEntryAffiliate, String winkVersion) throws WebClientResponseException {
        Object postBody = upsertSyndicationEntryAffiliate;
        // verify the required parameter 'companyIdentifier' is set
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling createSyndicationEntry", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'upsertSyndicationEntryAffiliate' is set
        if (upsertSyndicationEntryAffiliate == null) {
            throw new WebClientResponseException("Missing the required parameter 'upsertSyndicationEntryAffiliate' when calling createSyndicationEntry", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("companyIdentifier", companyIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<SyndicationEntryAffiliate> localVarReturnType = new ParameterizedTypeReference<SyndicationEntryAffiliate>() {};
        return apiClient.invokeAPI("/api/company/{companyIdentifier}/syndication/entry", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Create syndication entry
     * Creates a new syndication entry.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>201</b> - Created
     * @param companyIdentifier Create entry for this owner identifier.
     * @param upsertSyndicationEntryAffiliate Request body
     * @param winkVersion The winkVersion parameter
     * @return SyndicationEntryAffiliate
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<SyndicationEntryAffiliate> createSyndicationEntry(String companyIdentifier, UpsertSyndicationEntryAffiliate upsertSyndicationEntryAffiliate, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<SyndicationEntryAffiliate> localVarReturnType = new ParameterizedTypeReference<SyndicationEntryAffiliate>() {};
        return createSyndicationEntryRequestCreation(companyIdentifier, upsertSyndicationEntryAffiliate, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Create syndication entry
     * Creates a new syndication entry.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>201</b> - Created
     * @param companyIdentifier Create entry for this owner identifier.
     * @param upsertSyndicationEntryAffiliate Request body
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;SyndicationEntryAffiliate&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<SyndicationEntryAffiliate>> createSyndicationEntryWithHttpInfo(String companyIdentifier, UpsertSyndicationEntryAffiliate upsertSyndicationEntryAffiliate, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<SyndicationEntryAffiliate> localVarReturnType = new ParameterizedTypeReference<SyndicationEntryAffiliate>() {};
        return createSyndicationEntryRequestCreation(companyIdentifier, upsertSyndicationEntryAffiliate, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Create syndication entry
     * Creates a new syndication entry.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>201</b> - Created
     * @param companyIdentifier Create entry for this owner identifier.
     * @param upsertSyndicationEntryAffiliate Request body
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec createSyndicationEntryWithResponseSpec(String companyIdentifier, UpsertSyndicationEntryAffiliate upsertSyndicationEntryAffiliate, String winkVersion) throws WebClientResponseException {
        return createSyndicationEntryRequestCreation(companyIdentifier, upsertSyndicationEntryAffiliate, winkVersion);
    }
    /**
     * Delete WinkLinks category
     * Deletes a syndication category.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier Syndication category owned by this owner identifier.
     * @param syndicationCategoryIdentifier Syndication category identifier.
     * @param winkVersion The winkVersion parameter
     * @return RemoveEntryResponseAffiliate
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec removeSyndicationCategoryRequestCreation(String companyIdentifier, String syndicationCategoryIdentifier, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'companyIdentifier' is set
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling removeSyndicationCategory", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'syndicationCategoryIdentifier' is set
        if (syndicationCategoryIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'syndicationCategoryIdentifier' when calling removeSyndicationCategory", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("companyIdentifier", companyIdentifier);
        pathParams.put("syndicationCategoryIdentifier", syndicationCategoryIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<RemoveEntryResponseAffiliate> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponseAffiliate>() {};
        return apiClient.invokeAPI("/api/company/{companyIdentifier}/syndication/category/{syndicationCategoryIdentifier}", HttpMethod.DELETE, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Delete WinkLinks category
     * Deletes a syndication category.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier Syndication category owned by this owner identifier.
     * @param syndicationCategoryIdentifier Syndication category identifier.
     * @param winkVersion The winkVersion parameter
     * @return RemoveEntryResponseAffiliate
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<RemoveEntryResponseAffiliate> removeSyndicationCategory(String companyIdentifier, String syndicationCategoryIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<RemoveEntryResponseAffiliate> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponseAffiliate>() {};
        return removeSyndicationCategoryRequestCreation(companyIdentifier, syndicationCategoryIdentifier, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Delete WinkLinks category
     * Deletes a syndication category.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier Syndication category owned by this owner identifier.
     * @param syndicationCategoryIdentifier Syndication category identifier.
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;RemoveEntryResponseAffiliate&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<RemoveEntryResponseAffiliate>> removeSyndicationCategoryWithHttpInfo(String companyIdentifier, String syndicationCategoryIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<RemoveEntryResponseAffiliate> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponseAffiliate>() {};
        return removeSyndicationCategoryRequestCreation(companyIdentifier, syndicationCategoryIdentifier, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Delete WinkLinks category
     * Deletes a syndication category.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier Syndication category owned by this owner identifier.
     * @param syndicationCategoryIdentifier Syndication category identifier.
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec removeSyndicationCategoryWithResponseSpec(String companyIdentifier, String syndicationCategoryIdentifier, String winkVersion) throws WebClientResponseException {
        return removeSyndicationCategoryRequestCreation(companyIdentifier, syndicationCategoryIdentifier, winkVersion);
    }
    /**
     * Delete WinkLinks entry
     * Deletes a syndication entry.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier Syndication entry owned by this owner identifier.
     * @param syndicationEntryIdentifier Syndication entry identifier.
     * @param winkVersion The winkVersion parameter
     * @return RemoveEntryResponseAffiliate
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec removeSyndicationEntryRequestCreation(String companyIdentifier, String syndicationEntryIdentifier, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'companyIdentifier' is set
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling removeSyndicationEntry", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'syndicationEntryIdentifier' is set
        if (syndicationEntryIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'syndicationEntryIdentifier' when calling removeSyndicationEntry", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("companyIdentifier", companyIdentifier);
        pathParams.put("syndicationEntryIdentifier", syndicationEntryIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<RemoveEntryResponseAffiliate> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponseAffiliate>() {};
        return apiClient.invokeAPI("/api/company/{companyIdentifier}/syndication/entry/{syndicationEntryIdentifier}", HttpMethod.DELETE, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Delete WinkLinks entry
     * Deletes a syndication entry.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier Syndication entry owned by this owner identifier.
     * @param syndicationEntryIdentifier Syndication entry identifier.
     * @param winkVersion The winkVersion parameter
     * @return RemoveEntryResponseAffiliate
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<RemoveEntryResponseAffiliate> removeSyndicationEntry(String companyIdentifier, String syndicationEntryIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<RemoveEntryResponseAffiliate> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponseAffiliate>() {};
        return removeSyndicationEntryRequestCreation(companyIdentifier, syndicationEntryIdentifier, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Delete WinkLinks entry
     * Deletes a syndication entry.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier Syndication entry owned by this owner identifier.
     * @param syndicationEntryIdentifier Syndication entry identifier.
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;RemoveEntryResponseAffiliate&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<RemoveEntryResponseAffiliate>> removeSyndicationEntryWithHttpInfo(String companyIdentifier, String syndicationEntryIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<RemoveEntryResponseAffiliate> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponseAffiliate>() {};
        return removeSyndicationEntryRequestCreation(companyIdentifier, syndicationEntryIdentifier, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Delete WinkLinks entry
     * Deletes a syndication entry.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier Syndication entry owned by this owner identifier.
     * @param syndicationEntryIdentifier Syndication entry identifier.
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec removeSyndicationEntryWithResponseSpec(String companyIdentifier, String syndicationEntryIdentifier, String winkVersion) throws WebClientResponseException {
        return removeSyndicationEntryRequestCreation(companyIdentifier, syndicationEntryIdentifier, winkVersion);
    }
    /**
     * Show WinkLinks category
     * Retrieve syndication category.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier Syndication category owned by this owner identifier.
     * @param syndicationCategoryIdentifier Syndication category identifier.
     * @param winkVersion The winkVersion parameter
     * @return SyndicationCategoryAffiliate
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showSyndicationCategoryRequestCreation(String companyIdentifier, String syndicationCategoryIdentifier, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'companyIdentifier' is set
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling showSyndicationCategory", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'syndicationCategoryIdentifier' is set
        if (syndicationCategoryIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'syndicationCategoryIdentifier' when calling showSyndicationCategory", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("companyIdentifier", companyIdentifier);
        pathParams.put("syndicationCategoryIdentifier", syndicationCategoryIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<SyndicationCategoryAffiliate> localVarReturnType = new ParameterizedTypeReference<SyndicationCategoryAffiliate>() {};
        return apiClient.invokeAPI("/api/company/{companyIdentifier}/syndication/category/{syndicationCategoryIdentifier}", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show WinkLinks category
     * Retrieve syndication category.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier Syndication category owned by this owner identifier.
     * @param syndicationCategoryIdentifier Syndication category identifier.
     * @param winkVersion The winkVersion parameter
     * @return SyndicationCategoryAffiliate
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<SyndicationCategoryAffiliate> showSyndicationCategory(String companyIdentifier, String syndicationCategoryIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<SyndicationCategoryAffiliate> localVarReturnType = new ParameterizedTypeReference<SyndicationCategoryAffiliate>() {};
        return showSyndicationCategoryRequestCreation(companyIdentifier, syndicationCategoryIdentifier, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Show WinkLinks category
     * Retrieve syndication category.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier Syndication category owned by this owner identifier.
     * @param syndicationCategoryIdentifier Syndication category identifier.
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;SyndicationCategoryAffiliate&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<SyndicationCategoryAffiliate>> showSyndicationCategoryWithHttpInfo(String companyIdentifier, String syndicationCategoryIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<SyndicationCategoryAffiliate> localVarReturnType = new ParameterizedTypeReference<SyndicationCategoryAffiliate>() {};
        return showSyndicationCategoryRequestCreation(companyIdentifier, syndicationCategoryIdentifier, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Show WinkLinks category
     * Retrieve syndication category.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier Syndication category owned by this owner identifier.
     * @param syndicationCategoryIdentifier Syndication category identifier.
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec showSyndicationCategoryWithResponseSpec(String companyIdentifier, String syndicationCategoryIdentifier, String winkVersion) throws WebClientResponseException {
        return showSyndicationCategoryRequestCreation(companyIdentifier, syndicationCategoryIdentifier, winkVersion);
    }
    /**
     * Show WinkLinks list
     * Retrieve list of syndication categories.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier List syndication categories owned by this owner identifier.
     * @param winkVersion The winkVersion parameter
     * @return List&lt;SyndicationCategoryAffiliate&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showSyndicationCategoryListRequestCreation(String companyIdentifier, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'companyIdentifier' is set
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling showSyndicationCategoryList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("companyIdentifier", companyIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<SyndicationCategoryAffiliate> localVarReturnType = new ParameterizedTypeReference<SyndicationCategoryAffiliate>() {};
        return apiClient.invokeAPI("/api/company/{companyIdentifier}/syndication/category/list", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show WinkLinks list
     * Retrieve list of syndication categories.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier List syndication categories owned by this owner identifier.
     * @param winkVersion The winkVersion parameter
     * @return List&lt;SyndicationCategoryAffiliate&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Flux<SyndicationCategoryAffiliate> showSyndicationCategoryList(String companyIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<SyndicationCategoryAffiliate> localVarReturnType = new ParameterizedTypeReference<SyndicationCategoryAffiliate>() {};
        return showSyndicationCategoryListRequestCreation(companyIdentifier, winkVersion).bodyToFlux(localVarReturnType);
    }

    /**
     * Show WinkLinks list
     * Retrieve list of syndication categories.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier List syndication categories owned by this owner identifier.
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;List&lt;SyndicationCategoryAffiliate&gt;&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<List<SyndicationCategoryAffiliate>>> showSyndicationCategoryListWithHttpInfo(String companyIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<SyndicationCategoryAffiliate> localVarReturnType = new ParameterizedTypeReference<SyndicationCategoryAffiliate>() {};
        return showSyndicationCategoryListRequestCreation(companyIdentifier, winkVersion).toEntityList(localVarReturnType);
    }

    /**
     * Show WinkLinks list
     * Retrieve list of syndication categories.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier List syndication categories owned by this owner identifier.
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec showSyndicationCategoryListWithResponseSpec(String companyIdentifier, String winkVersion) throws WebClientResponseException {
        return showSyndicationCategoryListRequestCreation(companyIdentifier, winkVersion);
    }
    /**
     * Show WinkLinks entry
     * Retrieve syndication entry.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier Syndication entry owned by this owner identifier.
     * @param syndicationEntryIdentifier Syndication entry identifier.
     * @param winkVersion The winkVersion parameter
     * @return SyndicationEntryAffiliate
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showSyndicationEntryRequestCreation(String companyIdentifier, String syndicationEntryIdentifier, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'companyIdentifier' is set
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling showSyndicationEntry", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'syndicationEntryIdentifier' is set
        if (syndicationEntryIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'syndicationEntryIdentifier' when calling showSyndicationEntry", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("companyIdentifier", companyIdentifier);
        pathParams.put("syndicationEntryIdentifier", syndicationEntryIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<SyndicationEntryAffiliate> localVarReturnType = new ParameterizedTypeReference<SyndicationEntryAffiliate>() {};
        return apiClient.invokeAPI("/api/company/{companyIdentifier}/syndication/entry/{syndicationEntryIdentifier}", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show WinkLinks entry
     * Retrieve syndication entry.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier Syndication entry owned by this owner identifier.
     * @param syndicationEntryIdentifier Syndication entry identifier.
     * @param winkVersion The winkVersion parameter
     * @return SyndicationEntryAffiliate
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<SyndicationEntryAffiliate> showSyndicationEntry(String companyIdentifier, String syndicationEntryIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<SyndicationEntryAffiliate> localVarReturnType = new ParameterizedTypeReference<SyndicationEntryAffiliate>() {};
        return showSyndicationEntryRequestCreation(companyIdentifier, syndicationEntryIdentifier, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Show WinkLinks entry
     * Retrieve syndication entry.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier Syndication entry owned by this owner identifier.
     * @param syndicationEntryIdentifier Syndication entry identifier.
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;SyndicationEntryAffiliate&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<SyndicationEntryAffiliate>> showSyndicationEntryWithHttpInfo(String companyIdentifier, String syndicationEntryIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<SyndicationEntryAffiliate> localVarReturnType = new ParameterizedTypeReference<SyndicationEntryAffiliate>() {};
        return showSyndicationEntryRequestCreation(companyIdentifier, syndicationEntryIdentifier, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Show WinkLinks entry
     * Retrieve syndication entry.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier Syndication entry owned by this owner identifier.
     * @param syndicationEntryIdentifier Syndication entry identifier.
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec showSyndicationEntryWithResponseSpec(String companyIdentifier, String syndicationEntryIdentifier, String winkVersion) throws WebClientResponseException {
        return showSyndicationEntryRequestCreation(companyIdentifier, syndicationEntryIdentifier, winkVersion);
    }
    /**
     * Show WinkLinks list
     * Retrieve list of syndication entries.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier List syndication entries owned by this owner identifier.
     * @param winkVersion The winkVersion parameter
     * @return List&lt;SyndicationEntryAffiliate&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showSyndicationEntryListRequestCreation(String companyIdentifier, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'companyIdentifier' is set
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling showSyndicationEntryList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("companyIdentifier", companyIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<SyndicationEntryAffiliate> localVarReturnType = new ParameterizedTypeReference<SyndicationEntryAffiliate>() {};
        return apiClient.invokeAPI("/api/company/{companyIdentifier}/syndication/entry/list", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show WinkLinks list
     * Retrieve list of syndication entries.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier List syndication entries owned by this owner identifier.
     * @param winkVersion The winkVersion parameter
     * @return List&lt;SyndicationEntryAffiliate&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Flux<SyndicationEntryAffiliate> showSyndicationEntryList(String companyIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<SyndicationEntryAffiliate> localVarReturnType = new ParameterizedTypeReference<SyndicationEntryAffiliate>() {};
        return showSyndicationEntryListRequestCreation(companyIdentifier, winkVersion).bodyToFlux(localVarReturnType);
    }

    /**
     * Show WinkLinks list
     * Retrieve list of syndication entries.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier List syndication entries owned by this owner identifier.
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;List&lt;SyndicationEntryAffiliate&gt;&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<List<SyndicationEntryAffiliate>>> showSyndicationEntryListWithHttpInfo(String companyIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<SyndicationEntryAffiliate> localVarReturnType = new ParameterizedTypeReference<SyndicationEntryAffiliate>() {};
        return showSyndicationEntryListRequestCreation(companyIdentifier, winkVersion).toEntityList(localVarReturnType);
    }

    /**
     * Show WinkLinks list
     * Retrieve list of syndication entries.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier List syndication entries owned by this owner identifier.
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec showSyndicationEntryListWithResponseSpec(String companyIdentifier, String winkVersion) throws WebClientResponseException {
        return showSyndicationEntryListRequestCreation(companyIdentifier, winkVersion);
    }
    /**
     * Show WinkLinks settings
     * Load WinkLinks settings.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier List syndication entries owned by this owner identifier.
     * @param winkVersion The winkVersion parameter
     * @return SyndicationSettingsAffiliate
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showSyndicationSettingsRequestCreation(String companyIdentifier, String winkVersion) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'companyIdentifier' is set
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling showSyndicationSettings", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("companyIdentifier", companyIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<SyndicationSettingsAffiliate> localVarReturnType = new ParameterizedTypeReference<SyndicationSettingsAffiliate>() {};
        return apiClient.invokeAPI("/api/company/{companyIdentifier}/syndication/settings", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show WinkLinks settings
     * Load WinkLinks settings.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier List syndication entries owned by this owner identifier.
     * @param winkVersion The winkVersion parameter
     * @return SyndicationSettingsAffiliate
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<SyndicationSettingsAffiliate> showSyndicationSettings(String companyIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<SyndicationSettingsAffiliate> localVarReturnType = new ParameterizedTypeReference<SyndicationSettingsAffiliate>() {};
        return showSyndicationSettingsRequestCreation(companyIdentifier, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Show WinkLinks settings
     * Load WinkLinks settings.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier List syndication entries owned by this owner identifier.
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;SyndicationSettingsAffiliate&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<SyndicationSettingsAffiliate>> showSyndicationSettingsWithHttpInfo(String companyIdentifier, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<SyndicationSettingsAffiliate> localVarReturnType = new ParameterizedTypeReference<SyndicationSettingsAffiliate>() {};
        return showSyndicationSettingsRequestCreation(companyIdentifier, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Show WinkLinks settings
     * Load WinkLinks settings.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier List syndication entries owned by this owner identifier.
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec showSyndicationSettingsWithResponseSpec(String companyIdentifier, String winkVersion) throws WebClientResponseException {
        return showSyndicationSettingsRequestCreation(companyIdentifier, winkVersion);
    }
    /**
     * Sort entire list
     * Re-sorts all list entries.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier Consume URL for this owner identifier.
     * @param sortedAffiliate List if ids and their new sort slot
     * @param winkVersion The winkVersion parameter
     * @return BooleanResponseAffiliate
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec sortSyndicationEntryListRequestCreation(String companyIdentifier, List<SortedAffiliate> sortedAffiliate, String winkVersion) throws WebClientResponseException {
        Object postBody = sortedAffiliate;
        // verify the required parameter 'companyIdentifier' is set
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling sortSyndicationEntryList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'sortedAffiliate' is set
        if (sortedAffiliate == null) {
            throw new WebClientResponseException("Missing the required parameter 'sortedAffiliate' when calling sortSyndicationEntryList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("companyIdentifier", companyIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<BooleanResponseAffiliate> localVarReturnType = new ParameterizedTypeReference<BooleanResponseAffiliate>() {};
        return apiClient.invokeAPI("/api/company/{companyIdentifier}/syndication/entry/list/sort", HttpMethod.PATCH, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Sort entire list
     * Re-sorts all list entries.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier Consume URL for this owner identifier.
     * @param sortedAffiliate List if ids and their new sort slot
     * @param winkVersion The winkVersion parameter
     * @return BooleanResponseAffiliate
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<BooleanResponseAffiliate> sortSyndicationEntryList(String companyIdentifier, List<SortedAffiliate> sortedAffiliate, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<BooleanResponseAffiliate> localVarReturnType = new ParameterizedTypeReference<BooleanResponseAffiliate>() {};
        return sortSyndicationEntryListRequestCreation(companyIdentifier, sortedAffiliate, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Sort entire list
     * Re-sorts all list entries.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier Consume URL for this owner identifier.
     * @param sortedAffiliate List if ids and their new sort slot
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;BooleanResponseAffiliate&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<BooleanResponseAffiliate>> sortSyndicationEntryListWithHttpInfo(String companyIdentifier, List<SortedAffiliate> sortedAffiliate, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<BooleanResponseAffiliate> localVarReturnType = new ParameterizedTypeReference<BooleanResponseAffiliate>() {};
        return sortSyndicationEntryListRequestCreation(companyIdentifier, sortedAffiliate, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Sort entire list
     * Re-sorts all list entries.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier Consume URL for this owner identifier.
     * @param sortedAffiliate List if ids and their new sort slot
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec sortSyndicationEntryListWithResponseSpec(String companyIdentifier, List<SortedAffiliate> sortedAffiliate, String winkVersion) throws WebClientResponseException {
        return sortSyndicationEntryListRequestCreation(companyIdentifier, sortedAffiliate, winkVersion);
    }
    /**
     * Update syndication category
     * Updates an existing syndication category.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier Create category for this owner identifier.
     * @param syndicationCategoryIdentifier Syndication category identifier.
     * @param upsertSyndicationCategoryAffiliate Request body
     * @param winkVersion The winkVersion parameter
     * @return SyndicationCategoryAffiliate
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec updateSyndicationCategoryRequestCreation(String companyIdentifier, String syndicationCategoryIdentifier, UpsertSyndicationCategoryAffiliate upsertSyndicationCategoryAffiliate, String winkVersion) throws WebClientResponseException {
        Object postBody = upsertSyndicationCategoryAffiliate;
        // verify the required parameter 'companyIdentifier' is set
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling updateSyndicationCategory", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'syndicationCategoryIdentifier' is set
        if (syndicationCategoryIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'syndicationCategoryIdentifier' when calling updateSyndicationCategory", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'upsertSyndicationCategoryAffiliate' is set
        if (upsertSyndicationCategoryAffiliate == null) {
            throw new WebClientResponseException("Missing the required parameter 'upsertSyndicationCategoryAffiliate' when calling updateSyndicationCategory", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("companyIdentifier", companyIdentifier);
        pathParams.put("syndicationCategoryIdentifier", syndicationCategoryIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<SyndicationCategoryAffiliate> localVarReturnType = new ParameterizedTypeReference<SyndicationCategoryAffiliate>() {};
        return apiClient.invokeAPI("/api/company/{companyIdentifier}/syndication/category/{syndicationCategoryIdentifier}", HttpMethod.PUT, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Update syndication category
     * Updates an existing syndication category.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier Create category for this owner identifier.
     * @param syndicationCategoryIdentifier Syndication category identifier.
     * @param upsertSyndicationCategoryAffiliate Request body
     * @param winkVersion The winkVersion parameter
     * @return SyndicationCategoryAffiliate
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<SyndicationCategoryAffiliate> updateSyndicationCategory(String companyIdentifier, String syndicationCategoryIdentifier, UpsertSyndicationCategoryAffiliate upsertSyndicationCategoryAffiliate, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<SyndicationCategoryAffiliate> localVarReturnType = new ParameterizedTypeReference<SyndicationCategoryAffiliate>() {};
        return updateSyndicationCategoryRequestCreation(companyIdentifier, syndicationCategoryIdentifier, upsertSyndicationCategoryAffiliate, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Update syndication category
     * Updates an existing syndication category.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier Create category for this owner identifier.
     * @param syndicationCategoryIdentifier Syndication category identifier.
     * @param upsertSyndicationCategoryAffiliate Request body
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;SyndicationCategoryAffiliate&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<SyndicationCategoryAffiliate>> updateSyndicationCategoryWithHttpInfo(String companyIdentifier, String syndicationCategoryIdentifier, UpsertSyndicationCategoryAffiliate upsertSyndicationCategoryAffiliate, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<SyndicationCategoryAffiliate> localVarReturnType = new ParameterizedTypeReference<SyndicationCategoryAffiliate>() {};
        return updateSyndicationCategoryRequestCreation(companyIdentifier, syndicationCategoryIdentifier, upsertSyndicationCategoryAffiliate, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Update syndication category
     * Updates an existing syndication category.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier Create category for this owner identifier.
     * @param syndicationCategoryIdentifier Syndication category identifier.
     * @param upsertSyndicationCategoryAffiliate Request body
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec updateSyndicationCategoryWithResponseSpec(String companyIdentifier, String syndicationCategoryIdentifier, UpsertSyndicationCategoryAffiliate upsertSyndicationCategoryAffiliate, String winkVersion) throws WebClientResponseException {
        return updateSyndicationCategoryRequestCreation(companyIdentifier, syndicationCategoryIdentifier, upsertSyndicationCategoryAffiliate, winkVersion);
    }
    /**
     * Update syndication entry
     * Updates an existing syndication entry.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier Create entry for this owner identifier.
     * @param syndicationEntryIdentifier Syndication entry identifier.
     * @param upsertSyndicationEntryAffiliate Request body
     * @param winkVersion The winkVersion parameter
     * @return SyndicationEntryAffiliate
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec updateSyndicationEntryRequestCreation(String companyIdentifier, String syndicationEntryIdentifier, UpsertSyndicationEntryAffiliate upsertSyndicationEntryAffiliate, String winkVersion) throws WebClientResponseException {
        Object postBody = upsertSyndicationEntryAffiliate;
        // verify the required parameter 'companyIdentifier' is set
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling updateSyndicationEntry", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'syndicationEntryIdentifier' is set
        if (syndicationEntryIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'syndicationEntryIdentifier' when calling updateSyndicationEntry", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'upsertSyndicationEntryAffiliate' is set
        if (upsertSyndicationEntryAffiliate == null) {
            throw new WebClientResponseException("Missing the required parameter 'upsertSyndicationEntryAffiliate' when calling updateSyndicationEntry", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("companyIdentifier", companyIdentifier);
        pathParams.put("syndicationEntryIdentifier", syndicationEntryIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<SyndicationEntryAffiliate> localVarReturnType = new ParameterizedTypeReference<SyndicationEntryAffiliate>() {};
        return apiClient.invokeAPI("/api/company/{companyIdentifier}/syndication/entry/{syndicationEntryIdentifier}", HttpMethod.PUT, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Update syndication entry
     * Updates an existing syndication entry.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier Create entry for this owner identifier.
     * @param syndicationEntryIdentifier Syndication entry identifier.
     * @param upsertSyndicationEntryAffiliate Request body
     * @param winkVersion The winkVersion parameter
     * @return SyndicationEntryAffiliate
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<SyndicationEntryAffiliate> updateSyndicationEntry(String companyIdentifier, String syndicationEntryIdentifier, UpsertSyndicationEntryAffiliate upsertSyndicationEntryAffiliate, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<SyndicationEntryAffiliate> localVarReturnType = new ParameterizedTypeReference<SyndicationEntryAffiliate>() {};
        return updateSyndicationEntryRequestCreation(companyIdentifier, syndicationEntryIdentifier, upsertSyndicationEntryAffiliate, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Update syndication entry
     * Updates an existing syndication entry.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier Create entry for this owner identifier.
     * @param syndicationEntryIdentifier Syndication entry identifier.
     * @param upsertSyndicationEntryAffiliate Request body
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;SyndicationEntryAffiliate&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<SyndicationEntryAffiliate>> updateSyndicationEntryWithHttpInfo(String companyIdentifier, String syndicationEntryIdentifier, UpsertSyndicationEntryAffiliate upsertSyndicationEntryAffiliate, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<SyndicationEntryAffiliate> localVarReturnType = new ParameterizedTypeReference<SyndicationEntryAffiliate>() {};
        return updateSyndicationEntryRequestCreation(companyIdentifier, syndicationEntryIdentifier, upsertSyndicationEntryAffiliate, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Update syndication entry
     * Updates an existing syndication entry.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier Create entry for this owner identifier.
     * @param syndicationEntryIdentifier Syndication entry identifier.
     * @param upsertSyndicationEntryAffiliate Request body
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec updateSyndicationEntryWithResponseSpec(String companyIdentifier, String syndicationEntryIdentifier, UpsertSyndicationEntryAffiliate upsertSyndicationEntryAffiliate, String winkVersion) throws WebClientResponseException {
        return updateSyndicationEntryRequestCreation(companyIdentifier, syndicationEntryIdentifier, upsertSyndicationEntryAffiliate, winkVersion);
    }
    /**
     * Upsert syndication settings
     * Upsert a new syndication settings.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier Update settings for this owner identifier.
     * @param upsertSyndicationSettingsAffiliate Request body
     * @param winkVersion The winkVersion parameter
     * @return SyndicationSettingsAffiliate
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec upsertSyndicationSettingsRequestCreation(String companyIdentifier, UpsertSyndicationSettingsAffiliate upsertSyndicationSettingsAffiliate, String winkVersion) throws WebClientResponseException {
        Object postBody = upsertSyndicationSettingsAffiliate;
        // verify the required parameter 'companyIdentifier' is set
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling upsertSyndicationSettings", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'upsertSyndicationSettingsAffiliate' is set
        if (upsertSyndicationSettingsAffiliate == null) {
            throw new WebClientResponseException("Missing the required parameter 'upsertSyndicationSettingsAffiliate' when calling upsertSyndicationSettings", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("companyIdentifier", companyIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<SyndicationSettingsAffiliate> localVarReturnType = new ParameterizedTypeReference<SyndicationSettingsAffiliate>() {};
        return apiClient.invokeAPI("/api/company/{companyIdentifier}/syndication/settings", HttpMethod.PUT, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Upsert syndication settings
     * Upsert a new syndication settings.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier Update settings for this owner identifier.
     * @param upsertSyndicationSettingsAffiliate Request body
     * @param winkVersion The winkVersion parameter
     * @return SyndicationSettingsAffiliate
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<SyndicationSettingsAffiliate> upsertSyndicationSettings(String companyIdentifier, UpsertSyndicationSettingsAffiliate upsertSyndicationSettingsAffiliate, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<SyndicationSettingsAffiliate> localVarReturnType = new ParameterizedTypeReference<SyndicationSettingsAffiliate>() {};
        return upsertSyndicationSettingsRequestCreation(companyIdentifier, upsertSyndicationSettingsAffiliate, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Upsert syndication settings
     * Upsert a new syndication settings.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier Update settings for this owner identifier.
     * @param upsertSyndicationSettingsAffiliate Request body
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;SyndicationSettingsAffiliate&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<SyndicationSettingsAffiliate>> upsertSyndicationSettingsWithHttpInfo(String companyIdentifier, UpsertSyndicationSettingsAffiliate upsertSyndicationSettingsAffiliate, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<SyndicationSettingsAffiliate> localVarReturnType = new ParameterizedTypeReference<SyndicationSettingsAffiliate>() {};
        return upsertSyndicationSettingsRequestCreation(companyIdentifier, upsertSyndicationSettingsAffiliate, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Upsert syndication settings
     * Upsert a new syndication settings.
     * <p><b>503</b> - Service Unavailable
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>415</b> - Unsupported Media Type
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>200</b> - OK
     * @param companyIdentifier Update settings for this owner identifier.
     * @param upsertSyndicationSettingsAffiliate Request body
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec upsertSyndicationSettingsWithResponseSpec(String companyIdentifier, UpsertSyndicationSettingsAffiliate upsertSyndicationSettingsAffiliate, String winkVersion) throws WebClientResponseException {
        return upsertSyndicationSettingsRequestCreation(companyIdentifier, upsertSyndicationSettingsAffiliate, winkVersion);
    }
}
