/*
 * Wink API
 * ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Affiliate](/affiliate): All APIs related to selling travel inventory as an affiliate. - [Analytics](/analytics): All APIs related to tracking metrics across a wide variety of data source segments including, more entertaining, leaderboard metrics. - [Booking](/booking): All APIs related to creating platform bookings. - [Channel Manager](/channel-manager): All APIs related to channel managers who want to integrate with our platform. - [Extranet](/extranet): All APIs related to managing travel inventory and suppliers. - [Inventory](/inventory): All APIs related to retrieve known travel inventory as it was found using the Lookup API.. - [Lookup](/lookup): All APIs related to locating inventory by region, locale and property flags. - [Reference](/reference): All APIs related to retrieving platform-supported taxonomies. - [TripPay](/payment): All APIs related to TripPay account management, booking, mapping and integration features.  ## SDKs We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).  - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)  ## Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Wink-Version` header. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints.  ## Release history - Follow updates on Github: https://github.com/wink-travel/wink-sdk-java/blob/master/CHANGELOG.md  # Affiliate API Welcome to the Affiliate API - A programmer-friendly way to search for and display bespoke travel inventory for your audience. Use this API to help you prepare travel inventory for sale.  # Intended Audience Programmers are a requirement to start integrating with wink. You will benefit from an API integration if you are new or existing travel related company that want easy access to great inventory.## Examples: - Hotel brands / chains that want to make their own booking engine - Travel tech companies that want to create the next hot mobile travel app - Destination sites that want to make their own booking engine - Bloggers and influencers who want to sell travel inventory to their audience - OTAs that want access direct relationships with suppliers and better quality hotel inventory
 *
 * The version of the OpenAPI document: 29.64.6
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.affiliate.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.UUID;
import travel.wink.sdk.affiliate.model.GeoJsonPointAffiliate;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * The destination to display ranked inventory from.
 */
@JsonPropertyOrder({
  LookupAffiliate.JSON_PROPERTY_IDENTIFIER,
  LookupAffiliate.JSON_PROPERTY_TYPE,
  LookupAffiliate.JSON_PROPERTY_TYPE_IDENTIFIER,
  LookupAffiliate.JSON_PROPERTY_NAME,
  LookupAffiliate.JSON_PROPERTY_URL_NAME,
  LookupAffiliate.JSON_PROPERTY_OWNER_IDENTIFIER,
  LookupAffiliate.JSON_PROPERTY_OWNER_NAME,
  LookupAffiliate.JSON_PROPERTY_CITY_NAME,
  LookupAffiliate.JSON_PROPERTY_COUNTRY_NAME,
  LookupAffiliate.JSON_PROPERTY_SUB_COUNTRY_NAME,
  LookupAffiliate.JSON_PROPERTY_SUB_SUB_COUNTRY_NAME,
  LookupAffiliate.JSON_PROPERTY_COUNTRY_CODE,
  LookupAffiliate.JSON_PROPERTY_OWNER_TYPE,
  LookupAffiliate.JSON_PROPERTY_LANGUAGE_CODE,
  LookupAffiliate.JSON_PROPERTY_SORT,
  LookupAffiliate.JSON_PROPERTY_ORIGIN,
  LookupAffiliate.JSON_PROPERTY_LOWERCASE_NAME,
  LookupAffiliate.JSON_PROPERTY_LOCATION
})
@JsonTypeName("Lookup_Affiliate")
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-06-21T16:17:19.654348185+07:00[Asia/Bangkok]")
public class LookupAffiliate {
  public static final String JSON_PROPERTY_IDENTIFIER = "identifier";
  private UUID identifier;

  /**
   * Type of lookup
   */
  public enum TypeEnum {
    CITY("CITY"),
    
    ISLAND("ISLAND"),
    
    HOTEL("HOTEL"),
    
    SPA("SPA"),
    
    MEETING_ROOM("MEETING_ROOM"),
    
    RESTAURANT("RESTAURANT"),
    
    ATTRACTION("ATTRACTION"),
    
    ACTIVITY("ACTIVITY"),
    
    PLACE("PLACE"),
    
    COUNTRY("COUNTRY");

    private String value;

    TypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static TypeEnum fromValue(String value) {
      for (TypeEnum b : TypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_TYPE = "type";
  private TypeEnum type;

  public static final String JSON_PROPERTY_TYPE_IDENTIFIER = "typeIdentifier";
  private UUID typeIdentifier;

  public static final String JSON_PROPERTY_NAME = "name";
  private String name;

  public static final String JSON_PROPERTY_URL_NAME = "urlName";
  private String urlName;

  public static final String JSON_PROPERTY_OWNER_IDENTIFIER = "ownerIdentifier";
  private UUID ownerIdentifier;

  public static final String JSON_PROPERTY_OWNER_NAME = "ownerName";
  private String ownerName;

  public static final String JSON_PROPERTY_CITY_NAME = "cityName";
  private String cityName;

  public static final String JSON_PROPERTY_COUNTRY_NAME = "countryName";
  private String countryName;

  public static final String JSON_PROPERTY_SUB_COUNTRY_NAME = "subCountryName";
  private String subCountryName;

  public static final String JSON_PROPERTY_SUB_SUB_COUNTRY_NAME = "subSubCountryName";
  private String subSubCountryName;

  public static final String JSON_PROPERTY_COUNTRY_CODE = "countryCode";
  private String countryCode;

  /**
   * The type of owner that created this lookup
   */
  public enum OwnerTypeEnum {
    TRAVELIKO("TRAVELIKO"),
    
    HOTEL("HOTEL");

    private String value;

    OwnerTypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static OwnerTypeEnum fromValue(String value) {
      for (OwnerTypeEnum b : OwnerTypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_OWNER_TYPE = "ownerType";
  private OwnerTypeEnum ownerType;

  public static final String JSON_PROPERTY_LANGUAGE_CODE = "languageCode";
  private String languageCode;

  public static final String JSON_PROPERTY_SORT = "sort";
  private Integer sort;

  public static final String JSON_PROPERTY_ORIGIN = "origin";
  private Boolean origin;

  public static final String JSON_PROPERTY_LOWERCASE_NAME = "lowercaseName";
  private String lowercaseName;

  public static final String JSON_PROPERTY_LOCATION = "location";
  private GeoJsonPointAffiliate location;

  public LookupAffiliate() {
  }

  public LookupAffiliate identifier(UUID identifier) {
    
    this.identifier = identifier;
    return this;
  }

   /**
   * Unique lookup identifier
   * @return identifier
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public UUID getIdentifier() {
    return identifier;
  }


  @JsonProperty(JSON_PROPERTY_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIdentifier(UUID identifier) {
    this.identifier = identifier;
  }


  public LookupAffiliate type(TypeEnum type) {
    
    this.type = type;
    return this;
  }

   /**
   * Type of lookup
   * @return type
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public TypeEnum getType() {
    return type;
  }


  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setType(TypeEnum type) {
    this.type = type;
  }


  public LookupAffiliate typeIdentifier(UUID typeIdentifier) {
    
    this.typeIdentifier = typeIdentifier;
    return this;
  }

   /**
   * Unique lookup type identifier
   * @return typeIdentifier
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_TYPE_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public UUID getTypeIdentifier() {
    return typeIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_TYPE_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTypeIdentifier(UUID typeIdentifier) {
    this.typeIdentifier = typeIdentifier;
  }


  public LookupAffiliate name(String name) {
    
    this.name = name;
    return this;
  }

   /**
   * Name of lookup
   * @return name
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getName() {
    return name;
  }


  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setName(String name) {
    this.name = name;
  }


  public LookupAffiliate urlName(String urlName) {
    
    this.urlName = urlName;
    return this;
  }

   /**
   * Url-friendly slug that uniquely identifies this lookup
   * @return urlName
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_URL_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getUrlName() {
    return urlName;
  }


  @JsonProperty(JSON_PROPERTY_URL_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setUrlName(String urlName) {
    this.urlName = urlName;
  }


  public LookupAffiliate ownerIdentifier(UUID ownerIdentifier) {
    
    this.ownerIdentifier = ownerIdentifier;
    return this;
  }

   /**
   * Lookup that is supplier inventory includes the supplier identifier
   * @return ownerIdentifier
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_OWNER_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public UUID getOwnerIdentifier() {
    return ownerIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_OWNER_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setOwnerIdentifier(UUID ownerIdentifier) {
    this.ownerIdentifier = ownerIdentifier;
  }


  public LookupAffiliate ownerName(String ownerName) {
    
    this.ownerName = ownerName;
    return this;
  }

   /**
   * Lookup that is supplier inventory includes the supplier name
   * @return ownerName
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_OWNER_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getOwnerName() {
    return ownerName;
  }


  @JsonProperty(JSON_PROPERTY_OWNER_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setOwnerName(String ownerName) {
    this.ownerName = ownerName;
  }


  public LookupAffiliate cityName(String cityName) {
    
    this.cityName = cityName;
    return this;
  }

   /**
   * Closest city where lookup entry is located
   * @return cityName
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_CITY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getCityName() {
    return cityName;
  }


  @JsonProperty(JSON_PROPERTY_CITY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCityName(String cityName) {
    this.cityName = cityName;
  }


  public LookupAffiliate countryName(String countryName) {
    
    this.countryName = countryName;
    return this;
  }

   /**
   * Country where lookup entry is located
   * @return countryName
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_COUNTRY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getCountryName() {
    return countryName;
  }


  @JsonProperty(JSON_PROPERTY_COUNTRY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCountryName(String countryName) {
    this.countryName = countryName;
  }


  public LookupAffiliate subCountryName(String subCountryName) {
    
    this.subCountryName = subCountryName;
    return this;
  }

   /**
   * State where lookup entry is located
   * @return subCountryName
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_SUB_COUNTRY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getSubCountryName() {
    return subCountryName;
  }


  @JsonProperty(JSON_PROPERTY_SUB_COUNTRY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSubCountryName(String subCountryName) {
    this.subCountryName = subCountryName;
  }


  public LookupAffiliate subSubCountryName(String subSubCountryName) {
    
    this.subSubCountryName = subSubCountryName;
    return this;
  }

   /**
   * County where lookup entry is located
   * @return subSubCountryName
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_SUB_SUB_COUNTRY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getSubSubCountryName() {
    return subSubCountryName;
  }


  @JsonProperty(JSON_PROPERTY_SUB_SUB_COUNTRY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSubSubCountryName(String subSubCountryName) {
    this.subSubCountryName = subSubCountryName;
  }


  public LookupAffiliate countryCode(String countryCode) {
    
    this.countryCode = countryCode;
    return this;
  }

   /**
   * Country code
   * @return countryCode
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_COUNTRY_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getCountryCode() {
    return countryCode;
  }


  @JsonProperty(JSON_PROPERTY_COUNTRY_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCountryCode(String countryCode) {
    this.countryCode = countryCode;
  }


  public LookupAffiliate ownerType(OwnerTypeEnum ownerType) {
    
    this.ownerType = ownerType;
    return this;
  }

   /**
   * The type of owner that created this lookup
   * @return ownerType
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_OWNER_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public OwnerTypeEnum getOwnerType() {
    return ownerType;
  }


  @JsonProperty(JSON_PROPERTY_OWNER_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setOwnerType(OwnerTypeEnum ownerType) {
    this.ownerType = ownerType;
  }


  public LookupAffiliate languageCode(String languageCode) {
    
    this.languageCode = languageCode;
    return this;
  }

   /**
   * The language the lookup code was written in
   * @return languageCode
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_LANGUAGE_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getLanguageCode() {
    return languageCode;
  }


  @JsonProperty(JSON_PROPERTY_LANGUAGE_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLanguageCode(String languageCode) {
    this.languageCode = languageCode;
  }


  public LookupAffiliate sort(Integer sort) {
    
    this.sort = sort;
    return this;
  }

   /**
   * Platform-specific sort
   * @return sort
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_SORT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getSort() {
    return sort;
  }


  @JsonProperty(JSON_PROPERTY_SORT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSort(Integer sort) {
    this.sort = sort;
  }


  public LookupAffiliate origin(Boolean origin) {
    
    this.origin = origin;
    return this;
  }

   /**
   * If this lookup is the origin lookup.
   * @return origin
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_ORIGIN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getOrigin() {
    return origin;
  }


  @JsonProperty(JSON_PROPERTY_ORIGIN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setOrigin(Boolean origin) {
    this.origin = origin;
  }


  public LookupAffiliate lowercaseName(String lowercaseName) {
    
    this.lowercaseName = lowercaseName;
    return this;
  }

   /**
   * Name in lower case
   * @return lowercaseName
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_LOWERCASE_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getLowercaseName() {
    return lowercaseName;
  }


  @JsonProperty(JSON_PROPERTY_LOWERCASE_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLowercaseName(String lowercaseName) {
    this.lowercaseName = lowercaseName;
  }


  public LookupAffiliate location(GeoJsonPointAffiliate location) {
    
    this.location = location;
    return this;
  }

   /**
   * Get location
   * @return location
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_LOCATION)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public GeoJsonPointAffiliate getLocation() {
    return location;
  }


  @JsonProperty(JSON_PROPERTY_LOCATION)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setLocation(GeoJsonPointAffiliate location) {
    this.location = location;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    LookupAffiliate lookupAffiliate = (LookupAffiliate) o;
    return Objects.equals(this.identifier, lookupAffiliate.identifier) &&
        Objects.equals(this.type, lookupAffiliate.type) &&
        Objects.equals(this.typeIdentifier, lookupAffiliate.typeIdentifier) &&
        Objects.equals(this.name, lookupAffiliate.name) &&
        Objects.equals(this.urlName, lookupAffiliate.urlName) &&
        Objects.equals(this.ownerIdentifier, lookupAffiliate.ownerIdentifier) &&
        Objects.equals(this.ownerName, lookupAffiliate.ownerName) &&
        Objects.equals(this.cityName, lookupAffiliate.cityName) &&
        Objects.equals(this.countryName, lookupAffiliate.countryName) &&
        Objects.equals(this.subCountryName, lookupAffiliate.subCountryName) &&
        Objects.equals(this.subSubCountryName, lookupAffiliate.subSubCountryName) &&
        Objects.equals(this.countryCode, lookupAffiliate.countryCode) &&
        Objects.equals(this.ownerType, lookupAffiliate.ownerType) &&
        Objects.equals(this.languageCode, lookupAffiliate.languageCode) &&
        Objects.equals(this.sort, lookupAffiliate.sort) &&
        Objects.equals(this.origin, lookupAffiliate.origin) &&
        Objects.equals(this.lowercaseName, lookupAffiliate.lowercaseName) &&
        Objects.equals(this.location, lookupAffiliate.location);
  }

  @Override
  public int hashCode() {
    return Objects.hash(identifier, type, typeIdentifier, name, urlName, ownerIdentifier, ownerName, cityName, countryName, subCountryName, subSubCountryName, countryCode, ownerType, languageCode, sort, origin, lowercaseName, location);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class LookupAffiliate {\n");
    sb.append("    identifier: ").append(toIndentedString(identifier)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    typeIdentifier: ").append(toIndentedString(typeIdentifier)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    urlName: ").append(toIndentedString(urlName)).append("\n");
    sb.append("    ownerIdentifier: ").append(toIndentedString(ownerIdentifier)).append("\n");
    sb.append("    ownerName: ").append(toIndentedString(ownerName)).append("\n");
    sb.append("    cityName: ").append(toIndentedString(cityName)).append("\n");
    sb.append("    countryName: ").append(toIndentedString(countryName)).append("\n");
    sb.append("    subCountryName: ").append(toIndentedString(subCountryName)).append("\n");
    sb.append("    subSubCountryName: ").append(toIndentedString(subSubCountryName)).append("\n");
    sb.append("    countryCode: ").append(toIndentedString(countryCode)).append("\n");
    sb.append("    ownerType: ").append(toIndentedString(ownerType)).append("\n");
    sb.append("    languageCode: ").append(toIndentedString(languageCode)).append("\n");
    sb.append("    sort: ").append(toIndentedString(sort)).append("\n");
    sb.append("    origin: ").append(toIndentedString(origin)).append("\n");
    sb.append("    lowercaseName: ").append(toIndentedString(lowercaseName)).append("\n");
    sb.append("    location: ").append(toIndentedString(location)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

