/*
 * Wink API
 * ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Affiliate](/affiliate): All APIs related to selling travel inventory as an affiliate. - [Analytics](/analytics): All APIs related to tracking metrics across a wide variety of data source segments including, more entertaining, leaderboard metrics. - [Booking](/booking): All APIs related to creating platform bookings. - [Channel Manager](/channel-manager): All APIs related to channel managers who want to integrate with our platform. - [Extranet](/extranet): All APIs related to managing travel inventory and suppliers. - [Inventory](/inventory): All APIs related to retrieve known travel inventory as it was found using the Lookup API.. - [Lookup](/lookup): All APIs related to locating inventory by region, locale and property flags. - [Reference](/reference): All APIs related to retrieving platform-supported taxonomies. - [TripPay Acquiring](/payment-acquiring): All APIs related to capture payment details such as a Stripe payment intent. - [TripPay](/payment): All APIs related to TripPay account management, booking, mapping and integration features.  ## SDKs We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).  - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)  ## Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Wink-Version` header. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints.  ## Release history - 2022-10-15: v2.0 - Removed HATEOAS and added Wink-Version header - 2022-05-08: v1 - Exposed channel manager API - 2021-07-01: v1 - Initial release  # Affiliate API Welcome to the Affiliate API - A programmer-friendly way to search for and display bespoke travel inventory for your audience. Use this API to help you prepare travel inventory for sale.  # Intended Audience Programmers are a requirement to start integrating with wink. You will benefit from an API integration if you are new or existing travel related company that want easy access to great inventory.## Examples: - Hotel brands / chains that want to make their own booking engine - Travel tech companies that want to create the next hot mobile travel app - Destination sites that want to make their own booking engine - Bloggers and influencers who want to sell travel inventory to their audience - OTAs that want access direct relationships with suppliers and better quality hotel inventory
 *
 * The version of the OpenAPI document: 29.7.0
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.affiliate.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import travel.wink.sdk.affiliate.model.InvoiceLineItemPeriodAffiliate;
import travel.wink.sdk.affiliate.model.PlanAffiliate;
import travel.wink.sdk.affiliate.model.PriceAffiliate;
import travel.wink.sdk.affiliate.model.TaxAmountAffiliate;
import travel.wink.sdk.affiliate.model.TaxRateAffiliate;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * InvoiceLineItemAffiliate
 */
@JsonPropertyOrder({
  InvoiceLineItemAffiliate.JSON_PROPERTY_AMOUNT,
  InvoiceLineItemAffiliate.JSON_PROPERTY_CURRENCY,
  InvoiceLineItemAffiliate.JSON_PROPERTY_DESCRIPTION,
  InvoiceLineItemAffiliate.JSON_PROPERTY_DISCOUNTABLE,
  InvoiceLineItemAffiliate.JSON_PROPERTY_ID,
  InvoiceLineItemAffiliate.JSON_PROPERTY_INVOICE_ITEM,
  InvoiceLineItemAffiliate.JSON_PROPERTY_LIVEMODE,
  InvoiceLineItemAffiliate.JSON_PROPERTY_METADATA,
  InvoiceLineItemAffiliate.JSON_PROPERTY_OBJECT,
  InvoiceLineItemAffiliate.JSON_PROPERTY_PERIOD,
  InvoiceLineItemAffiliate.JSON_PROPERTY_PLAN,
  InvoiceLineItemAffiliate.JSON_PROPERTY_PRICE,
  InvoiceLineItemAffiliate.JSON_PROPERTY_PRORATION,
  InvoiceLineItemAffiliate.JSON_PROPERTY_QUANTITY,
  InvoiceLineItemAffiliate.JSON_PROPERTY_SUBSCRIPTION,
  InvoiceLineItemAffiliate.JSON_PROPERTY_SUBSCRIPTION_ITEM,
  InvoiceLineItemAffiliate.JSON_PROPERTY_TAX_AMOUNTS,
  InvoiceLineItemAffiliate.JSON_PROPERTY_TAX_RATES,
  InvoiceLineItemAffiliate.JSON_PROPERTY_TYPE
})
@JsonTypeName("InvoiceLineItem_Affiliate")
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-08-17T14:15:33.206017455+07:00[Asia/Bangkok]")
public class InvoiceLineItemAffiliate {
  public static final String JSON_PROPERTY_AMOUNT = "amount";
  private Long amount;

  public static final String JSON_PROPERTY_CURRENCY = "currency";
  private String currency;

  public static final String JSON_PROPERTY_DESCRIPTION = "description";
  private String description;

  public static final String JSON_PROPERTY_DISCOUNTABLE = "discountable";
  private Boolean discountable;

  public static final String JSON_PROPERTY_ID = "id";
  private String id;

  public static final String JSON_PROPERTY_INVOICE_ITEM = "invoiceItem";
  private String invoiceItem;

  public static final String JSON_PROPERTY_LIVEMODE = "livemode";
  private Boolean livemode;

  public static final String JSON_PROPERTY_METADATA = "metadata";
  private Map<String, String> metadata = new HashMap<>();

  public static final String JSON_PROPERTY_OBJECT = "object";
  private String _object;

  public static final String JSON_PROPERTY_PERIOD = "period";
  private InvoiceLineItemPeriodAffiliate period;

  public static final String JSON_PROPERTY_PLAN = "plan";
  private PlanAffiliate plan;

  public static final String JSON_PROPERTY_PRICE = "price";
  private PriceAffiliate price;

  public static final String JSON_PROPERTY_PRORATION = "proration";
  private Boolean proration;

  public static final String JSON_PROPERTY_QUANTITY = "quantity";
  private Long quantity;

  public static final String JSON_PROPERTY_SUBSCRIPTION = "subscription";
  private String subscription;

  public static final String JSON_PROPERTY_SUBSCRIPTION_ITEM = "subscriptionItem";
  private String subscriptionItem;

  public static final String JSON_PROPERTY_TAX_AMOUNTS = "taxAmounts";
  private List<TaxAmountAffiliate> taxAmounts = new ArrayList<>();

  public static final String JSON_PROPERTY_TAX_RATES = "taxRates";
  private List<TaxRateAffiliate> taxRates = new ArrayList<>();

  public static final String JSON_PROPERTY_TYPE = "type";
  private String type;

  public InvoiceLineItemAffiliate() {
  }

  public InvoiceLineItemAffiliate amount(Long amount) {
    
    this.amount = amount;
    return this;
  }

   /**
   * Get amount
   * @return amount
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Long getAmount() {
    return amount;
  }


  @JsonProperty(JSON_PROPERTY_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAmount(Long amount) {
    this.amount = amount;
  }


  public InvoiceLineItemAffiliate currency(String currency) {
    
    this.currency = currency;
    return this;
  }

   /**
   * Get currency
   * @return currency
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getCurrency() {
    return currency;
  }


  @JsonProperty(JSON_PROPERTY_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCurrency(String currency) {
    this.currency = currency;
  }


  public InvoiceLineItemAffiliate description(String description) {
    
    this.description = description;
    return this;
  }

   /**
   * Get description
   * @return description
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_DESCRIPTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getDescription() {
    return description;
  }


  @JsonProperty(JSON_PROPERTY_DESCRIPTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDescription(String description) {
    this.description = description;
  }


  public InvoiceLineItemAffiliate discountable(Boolean discountable) {
    
    this.discountable = discountable;
    return this;
  }

   /**
   * Get discountable
   * @return discountable
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_DISCOUNTABLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getDiscountable() {
    return discountable;
  }


  @JsonProperty(JSON_PROPERTY_DISCOUNTABLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDiscountable(Boolean discountable) {
    this.discountable = discountable;
  }


  public InvoiceLineItemAffiliate id(String id) {
    
    this.id = id;
    return this;
  }

   /**
   * Get id
   * @return id
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getId() {
    return id;
  }


  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setId(String id) {
    this.id = id;
  }


  public InvoiceLineItemAffiliate invoiceItem(String invoiceItem) {
    
    this.invoiceItem = invoiceItem;
    return this;
  }

   /**
   * Get invoiceItem
   * @return invoiceItem
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_INVOICE_ITEM)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getInvoiceItem() {
    return invoiceItem;
  }


  @JsonProperty(JSON_PROPERTY_INVOICE_ITEM)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setInvoiceItem(String invoiceItem) {
    this.invoiceItem = invoiceItem;
  }


  public InvoiceLineItemAffiliate livemode(Boolean livemode) {
    
    this.livemode = livemode;
    return this;
  }

   /**
   * Get livemode
   * @return livemode
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_LIVEMODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getLivemode() {
    return livemode;
  }


  @JsonProperty(JSON_PROPERTY_LIVEMODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLivemode(Boolean livemode) {
    this.livemode = livemode;
  }


  public InvoiceLineItemAffiliate metadata(Map<String, String> metadata) {
    
    this.metadata = metadata;
    return this;
  }

  public InvoiceLineItemAffiliate putMetadataItem(String key, String metadataItem) {
    if (this.metadata == null) {
      this.metadata = new HashMap<>();
    }
    this.metadata.put(key, metadataItem);
    return this;
  }

   /**
   * Get metadata
   * @return metadata
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_METADATA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Map<String, String> getMetadata() {
    return metadata;
  }


  @JsonProperty(JSON_PROPERTY_METADATA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMetadata(Map<String, String> metadata) {
    this.metadata = metadata;
  }


  public InvoiceLineItemAffiliate _object(String _object) {
    
    this._object = _object;
    return this;
  }

   /**
   * Get _object
   * @return _object
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_OBJECT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getObject() {
    return _object;
  }


  @JsonProperty(JSON_PROPERTY_OBJECT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setObject(String _object) {
    this._object = _object;
  }


  public InvoiceLineItemAffiliate period(InvoiceLineItemPeriodAffiliate period) {
    
    this.period = period;
    return this;
  }

   /**
   * Get period
   * @return period
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_PERIOD)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public InvoiceLineItemPeriodAffiliate getPeriod() {
    return period;
  }


  @JsonProperty(JSON_PROPERTY_PERIOD)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPeriod(InvoiceLineItemPeriodAffiliate period) {
    this.period = period;
  }


  public InvoiceLineItemAffiliate plan(PlanAffiliate plan) {
    
    this.plan = plan;
    return this;
  }

   /**
   * Get plan
   * @return plan
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_PLAN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public PlanAffiliate getPlan() {
    return plan;
  }


  @JsonProperty(JSON_PROPERTY_PLAN)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPlan(PlanAffiliate plan) {
    this.plan = plan;
  }


  public InvoiceLineItemAffiliate price(PriceAffiliate price) {
    
    this.price = price;
    return this;
  }

   /**
   * Get price
   * @return price
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_PRICE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public PriceAffiliate getPrice() {
    return price;
  }


  @JsonProperty(JSON_PROPERTY_PRICE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPrice(PriceAffiliate price) {
    this.price = price;
  }


  public InvoiceLineItemAffiliate proration(Boolean proration) {
    
    this.proration = proration;
    return this;
  }

   /**
   * Get proration
   * @return proration
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_PRORATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getProration() {
    return proration;
  }


  @JsonProperty(JSON_PROPERTY_PRORATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setProration(Boolean proration) {
    this.proration = proration;
  }


  public InvoiceLineItemAffiliate quantity(Long quantity) {
    
    this.quantity = quantity;
    return this;
  }

   /**
   * Get quantity
   * @return quantity
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_QUANTITY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Long getQuantity() {
    return quantity;
  }


  @JsonProperty(JSON_PROPERTY_QUANTITY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setQuantity(Long quantity) {
    this.quantity = quantity;
  }


  public InvoiceLineItemAffiliate subscription(String subscription) {
    
    this.subscription = subscription;
    return this;
  }

   /**
   * Get subscription
   * @return subscription
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_SUBSCRIPTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getSubscription() {
    return subscription;
  }


  @JsonProperty(JSON_PROPERTY_SUBSCRIPTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSubscription(String subscription) {
    this.subscription = subscription;
  }


  public InvoiceLineItemAffiliate subscriptionItem(String subscriptionItem) {
    
    this.subscriptionItem = subscriptionItem;
    return this;
  }

   /**
   * Get subscriptionItem
   * @return subscriptionItem
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_SUBSCRIPTION_ITEM)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getSubscriptionItem() {
    return subscriptionItem;
  }


  @JsonProperty(JSON_PROPERTY_SUBSCRIPTION_ITEM)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSubscriptionItem(String subscriptionItem) {
    this.subscriptionItem = subscriptionItem;
  }


  public InvoiceLineItemAffiliate taxAmounts(List<TaxAmountAffiliate> taxAmounts) {
    
    this.taxAmounts = taxAmounts;
    return this;
  }

  public InvoiceLineItemAffiliate addTaxAmountsItem(TaxAmountAffiliate taxAmountsItem) {
    if (this.taxAmounts == null) {
      this.taxAmounts = new ArrayList<>();
    }
    this.taxAmounts.add(taxAmountsItem);
    return this;
  }

   /**
   * Get taxAmounts
   * @return taxAmounts
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_TAX_AMOUNTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<TaxAmountAffiliate> getTaxAmounts() {
    return taxAmounts;
  }


  @JsonProperty(JSON_PROPERTY_TAX_AMOUNTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTaxAmounts(List<TaxAmountAffiliate> taxAmounts) {
    this.taxAmounts = taxAmounts;
  }


  public InvoiceLineItemAffiliate taxRates(List<TaxRateAffiliate> taxRates) {
    
    this.taxRates = taxRates;
    return this;
  }

  public InvoiceLineItemAffiliate addTaxRatesItem(TaxRateAffiliate taxRatesItem) {
    if (this.taxRates == null) {
      this.taxRates = new ArrayList<>();
    }
    this.taxRates.add(taxRatesItem);
    return this;
  }

   /**
   * Get taxRates
   * @return taxRates
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_TAX_RATES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<TaxRateAffiliate> getTaxRates() {
    return taxRates;
  }


  @JsonProperty(JSON_PROPERTY_TAX_RATES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTaxRates(List<TaxRateAffiliate> taxRates) {
    this.taxRates = taxRates;
  }


  public InvoiceLineItemAffiliate type(String type) {
    
    this.type = type;
    return this;
  }

   /**
   * Get type
   * @return type
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getType() {
    return type;
  }


  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setType(String type) {
    this.type = type;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    InvoiceLineItemAffiliate invoiceLineItemAffiliate = (InvoiceLineItemAffiliate) o;
    return Objects.equals(this.amount, invoiceLineItemAffiliate.amount) &&
        Objects.equals(this.currency, invoiceLineItemAffiliate.currency) &&
        Objects.equals(this.description, invoiceLineItemAffiliate.description) &&
        Objects.equals(this.discountable, invoiceLineItemAffiliate.discountable) &&
        Objects.equals(this.id, invoiceLineItemAffiliate.id) &&
        Objects.equals(this.invoiceItem, invoiceLineItemAffiliate.invoiceItem) &&
        Objects.equals(this.livemode, invoiceLineItemAffiliate.livemode) &&
        Objects.equals(this.metadata, invoiceLineItemAffiliate.metadata) &&
        Objects.equals(this._object, invoiceLineItemAffiliate._object) &&
        Objects.equals(this.period, invoiceLineItemAffiliate.period) &&
        Objects.equals(this.plan, invoiceLineItemAffiliate.plan) &&
        Objects.equals(this.price, invoiceLineItemAffiliate.price) &&
        Objects.equals(this.proration, invoiceLineItemAffiliate.proration) &&
        Objects.equals(this.quantity, invoiceLineItemAffiliate.quantity) &&
        Objects.equals(this.subscription, invoiceLineItemAffiliate.subscription) &&
        Objects.equals(this.subscriptionItem, invoiceLineItemAffiliate.subscriptionItem) &&
        Objects.equals(this.taxAmounts, invoiceLineItemAffiliate.taxAmounts) &&
        Objects.equals(this.taxRates, invoiceLineItemAffiliate.taxRates) &&
        Objects.equals(this.type, invoiceLineItemAffiliate.type);
  }

  @Override
  public int hashCode() {
    return Objects.hash(amount, currency, description, discountable, id, invoiceItem, livemode, metadata, _object, period, plan, price, proration, quantity, subscription, subscriptionItem, taxAmounts, taxRates, type);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class InvoiceLineItemAffiliate {\n");
    sb.append("    amount: ").append(toIndentedString(amount)).append("\n");
    sb.append("    currency: ").append(toIndentedString(currency)).append("\n");
    sb.append("    description: ").append(toIndentedString(description)).append("\n");
    sb.append("    discountable: ").append(toIndentedString(discountable)).append("\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    invoiceItem: ").append(toIndentedString(invoiceItem)).append("\n");
    sb.append("    livemode: ").append(toIndentedString(livemode)).append("\n");
    sb.append("    metadata: ").append(toIndentedString(metadata)).append("\n");
    sb.append("    _object: ").append(toIndentedString(_object)).append("\n");
    sb.append("    period: ").append(toIndentedString(period)).append("\n");
    sb.append("    plan: ").append(toIndentedString(plan)).append("\n");
    sb.append("    price: ").append(toIndentedString(price)).append("\n");
    sb.append("    proration: ").append(toIndentedString(proration)).append("\n");
    sb.append("    quantity: ").append(toIndentedString(quantity)).append("\n");
    sb.append("    subscription: ").append(toIndentedString(subscription)).append("\n");
    sb.append("    subscriptionItem: ").append(toIndentedString(subscriptionItem)).append("\n");
    sb.append("    taxAmounts: ").append(toIndentedString(taxAmounts)).append("\n");
    sb.append("    taxRates: ").append(toIndentedString(taxRates)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

