/*
 * Wink API
 * ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Affiliate](/affiliate): All APIs related to selling travel inventory as an affiliate. - [Analytics](/analytics): All APIs related to tracking metrics across a wide variety of data source segments including, more entertaining, leaderboard metrics. - [Booking](/booking): All APIs related to creating platform bookings. - [Channel Manager](/channel-manager): All APIs related to channel managers who want to integrate with our platform. - [Extranet](/extranet): All APIs related to managing travel inventory and suppliers. - [Inventory](/inventory): All APIs related to retrieve known travel inventory as it was found using the Lookup API.. - [Lookup](/lookup): All APIs related to locating inventory by region, locale and property flags. - [Reference](/reference): All APIs related to retrieving platform-supported taxonomies. - [TripPay Acquiring](/payment-acquiring): All APIs related to capture payment details such as a Stripe payment intent. - [TripPay](/payment): All APIs related to TripPay account management, booking, mapping and integration features.  ## SDKs We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).  - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)  ## Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Wink-Version` header. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints.  ## Release history - 2022-10-15: v2.0 - Removed HATEOAS and added Wink-Version header - 2022-05-08: v1 - Exposed channel manager API - 2021-07-01: v1 - Initial release  # Affiliate API Welcome to the Affiliate API - A programmer-friendly way to search for and display bespoke travel inventory for your audience. Use this API to help you prepare travel inventory for sale.  # Intended Audience Programmers are a requirement to start integrating with wink. You will benefit from an API integration if you are new or existing travel related company that want easy access to great inventory.## Examples: - Hotel brands / chains that want to make their own booking engine - Travel tech companies that want to create the next hot mobile travel app - Destination sites that want to make their own booking engine - Bloggers and influencers who want to sell travel inventory to their audience - OTAs that want access direct relationships with suppliers and better quality hotel inventory
 *
 * The version of the OpenAPI document: 29.7.0
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.affiliate.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import travel.wink.sdk.affiliate.model.RateModifierAffiliate;
import travel.wink.sdk.affiliate.model.RateModifierBundleAffiliate;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * Parent sales channel
 */
@JsonPropertyOrder({
  SalesChannelAffiliate.JSON_PROPERTY_IDENTIFIER,
  SalesChannelAffiliate.JSON_PROPERTY_SUPPLIER_IDENTIFIER,
  SalesChannelAffiliate.JSON_PROPERTY_SUPPLIER_NAME,
  SalesChannelAffiliate.JSON_PROPERTY_SUPPLIER_AVAILABLE,
  SalesChannelAffiliate.JSON_PROPERTY_SUB_TYPE,
  SalesChannelAffiliate.JSON_PROPERTY_OWNER_IDENTIFIER,
  SalesChannelAffiliate.JSON_PROPERTY_OWNER_NAME,
  SalesChannelAffiliate.JSON_PROPERTY_ENABLED,
  SalesChannelAffiliate.JSON_PROPERTY_CHANNEL_DISABLED,
  SalesChannelAffiliate.JSON_PROPERTY_BLACKLISTED,
  SalesChannelAffiliate.JSON_PROPERTY_PERCENT_DISCOUNT,
  SalesChannelAffiliate.JSON_PROPERTY_COMMISSION,
  SalesChannelAffiliate.JSON_PROPERTY_RATE_MODIFIERS,
  SalesChannelAffiliate.JSON_PROPERTY_RATE_MODIFIER_BUNDLES
})
@JsonTypeName("SalesChannel_Affiliate")
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-08-17T14:15:33.206017455+07:00[Asia/Bangkok]")
public class SalesChannelAffiliate {
  public static final String JSON_PROPERTY_IDENTIFIER = "identifier";
  private UUID identifier;

  public static final String JSON_PROPERTY_SUPPLIER_IDENTIFIER = "supplierIdentifier";
  private UUID supplierIdentifier;

  public static final String JSON_PROPERTY_SUPPLIER_NAME = "supplierName";
  private String supplierName;

  public static final String JSON_PROPERTY_SUPPLIER_AVAILABLE = "supplierAvailable";
  private Boolean supplierAvailable = true;

  /**
   * What type of segment of channel is this.
   */
  public enum SubTypeEnum {
    DIRECT("DIRECT"),
    
    APPLICATION("APPLICATION"),
    
    HOTEL("HOTEL"),
    
    TRAVELIKO("TRAVELIKO"),
    
    CORPORATE("CORPORATE"),
    
    TRAVEL_AGENT("TRAVEL_AGENT"),
    
    INFLUENCER("INFLUENCER"),
    
    BLOGGER("BLOGGER"),
    
    DESTINATION("DESTINATION"),
    
    CHANNEL_MANAGER("CHANNEL_MANAGER"),
    
    PROPERTY_MANAGEMENT_SYSTEM("PROPERTY_MANAGEMENT_SYSTEM"),
    
    CENTRAL_RESERVATION_SYSTEM("CENTRAL_RESERVATION_SYSTEM");

    private String value;

    SubTypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static SubTypeEnum fromValue(String value) {
      for (SubTypeEnum b : SubTypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_SUB_TYPE = "subType";
  private SubTypeEnum subType;

  public static final String JSON_PROPERTY_OWNER_IDENTIFIER = "ownerIdentifier";
  private UUID ownerIdentifier;

  public static final String JSON_PROPERTY_OWNER_NAME = "ownerName";
  private String ownerName;

  public static final String JSON_PROPERTY_ENABLED = "enabled";
  private Boolean enabled = true;

  public static final String JSON_PROPERTY_CHANNEL_DISABLED = "channelDisabled";
  private Boolean channelDisabled;

  public static final String JSON_PROPERTY_BLACKLISTED = "blacklisted";
  private Boolean blacklisted;

  public static final String JSON_PROPERTY_PERCENT_DISCOUNT = "percentDiscount";
  private Float percentDiscount;

  public static final String JSON_PROPERTY_COMMISSION = "commission";
  private Float commission;

  public static final String JSON_PROPERTY_RATE_MODIFIERS = "rateModifiers";
  private List<RateModifierAffiliate> rateModifiers = new ArrayList<>();

  public static final String JSON_PROPERTY_RATE_MODIFIER_BUNDLES = "rateModifierBundles";
  private List<RateModifierBundleAffiliate> rateModifierBundles = new ArrayList<>();

  public SalesChannelAffiliate() {
  }

  public SalesChannelAffiliate identifier(UUID identifier) {
    
    this.identifier = identifier;
    return this;
  }

   /**
   * Unique record identifier of this segment / account
   * @return identifier
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public UUID getIdentifier() {
    return identifier;
  }


  @JsonProperty(JSON_PROPERTY_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setIdentifier(UUID identifier) {
    this.identifier = identifier;
  }


  public SalesChannelAffiliate supplierIdentifier(UUID supplierIdentifier) {
    
    this.supplierIdentifier = supplierIdentifier;
    return this;
  }

   /**
   * Channel is owned by this supplier identifier.
   * @return supplierIdentifier
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_SUPPLIER_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public UUID getSupplierIdentifier() {
    return supplierIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_SUPPLIER_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setSupplierIdentifier(UUID supplierIdentifier) {
    this.supplierIdentifier = supplierIdentifier;
  }


  public SalesChannelAffiliate supplierName(String supplierName) {
    
    this.supplierName = supplierName;
    return this;
  }

   /**
   * Name of property / supplier that owns this channel
   * @return supplierName
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_SUPPLIER_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getSupplierName() {
    return supplierName;
  }


  @JsonProperty(JSON_PROPERTY_SUPPLIER_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setSupplierName(String supplierName) {
    this.supplierName = supplierName;
  }


  public SalesChannelAffiliate supplierAvailable(Boolean supplierAvailable) {
    
    this.supplierAvailable = supplierAvailable;
    return this;
  }

   /**
   * Flag when supplier not available. E.g. Hotel disables property
   * @return supplierAvailable
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_SUPPLIER_AVAILABLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getSupplierAvailable() {
    return supplierAvailable;
  }


  @JsonProperty(JSON_PROPERTY_SUPPLIER_AVAILABLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSupplierAvailable(Boolean supplierAvailable) {
    this.supplierAvailable = supplierAvailable;
  }


  public SalesChannelAffiliate subType(SubTypeEnum subType) {
    
    this.subType = subType;
    return this;
  }

   /**
   * What type of segment of channel is this.
   * @return subType
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_SUB_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public SubTypeEnum getSubType() {
    return subType;
  }


  @JsonProperty(JSON_PROPERTY_SUB_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setSubType(SubTypeEnum subType) {
    this.subType = subType;
  }


  public SalesChannelAffiliate ownerIdentifier(UUID ownerIdentifier) {
    
    this.ownerIdentifier = ownerIdentifier;
    return this;
  }

   /**
   * A specific identifier for the company / corporation / travel agency that is retrieving the rates
   * @return ownerIdentifier
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_OWNER_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public UUID getOwnerIdentifier() {
    return ownerIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_OWNER_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setOwnerIdentifier(UUID ownerIdentifier) {
    this.ownerIdentifier = ownerIdentifier;
  }


  public SalesChannelAffiliate ownerName(String ownerName) {
    
    this.ownerName = ownerName;
    return this;
  }

   /**
   * Name of the owner / affiliate. &#x60;Hotel booking engine&#x60; when it&#39;s the booking engine.
   * @return ownerName
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_OWNER_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getOwnerName() {
    return ownerName;
  }


  @JsonProperty(JSON_PROPERTY_OWNER_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setOwnerName(String ownerName) {
    this.ownerName = ownerName;
  }


  public SalesChannelAffiliate enabled(Boolean enabled) {
    
    this.enabled = enabled;
    return this;
  }

   /**
   * Flag the supplier can use to enable / disable this channel
   * @return enabled
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_ENABLED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getEnabled() {
    return enabled;
  }


  @JsonProperty(JSON_PROPERTY_ENABLED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setEnabled(Boolean enabled) {
    this.enabled = enabled;
  }


  public SalesChannelAffiliate channelDisabled(Boolean channelDisabled) {
    
    this.channelDisabled = channelDisabled;
    return this;
  }

   /**
   * System override by payment to disable. E.g. Platform disables supplier.
   * @return channelDisabled
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_CHANNEL_DISABLED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getChannelDisabled() {
    return channelDisabled;
  }


  @JsonProperty(JSON_PROPERTY_CHANNEL_DISABLED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setChannelDisabled(Boolean channelDisabled) {
    this.channelDisabled = channelDisabled;
  }


  public SalesChannelAffiliate blacklisted(Boolean blacklisted) {
    
    this.blacklisted = blacklisted;
    return this;
  }

   /**
   * A way to blacklist a specific channel a property doesn&#39;t want to send inventory to.
   * @return blacklisted
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_BLACKLISTED)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Boolean getBlacklisted() {
    return blacklisted;
  }


  @JsonProperty(JSON_PROPERTY_BLACKLISTED)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setBlacklisted(Boolean blacklisted) {
    this.blacklisted = blacklisted;
  }


  public SalesChannelAffiliate percentDiscount(Float percentDiscount) {
    
    this.percentDiscount = percentDiscount;
    return this;
  }

   /**
   * Percent discount on this channel and all its children [unless configured at the child level].
   * minimum: 0.0
   * maximum: 1.0
   * @return percentDiscount
  **/
  @jakarta.annotation.Nullable
 @DecimalMin("0.0") @DecimalMax("1.0")
  @JsonProperty(JSON_PROPERTY_PERCENT_DISCOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Float getPercentDiscount() {
    return percentDiscount;
  }


  @JsonProperty(JSON_PROPERTY_PERCENT_DISCOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPercentDiscount(Float percentDiscount) {
    this.percentDiscount = percentDiscount;
  }


  public SalesChannelAffiliate commission(Float commission) {
    
    this.commission = commission;
    return this;
  }

   /**
   * Amount of sales commission earned through this channel and all its children [unless configured at the child level].
   * minimum: 0.0
   * maximum: 1.0
   * @return commission
  **/
  @jakarta.annotation.Nullable
 @DecimalMin("0.0") @DecimalMax("1.0")
  @JsonProperty(JSON_PROPERTY_COMMISSION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Float getCommission() {
    return commission;
  }


  @JsonProperty(JSON_PROPERTY_COMMISSION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCommission(Float commission) {
    this.commission = commission;
  }


  public SalesChannelAffiliate rateModifiers(List<RateModifierAffiliate> rateModifiers) {
    
    this.rateModifiers = rateModifiers;
    return this;
  }

  public SalesChannelAffiliate addRateModifiersItem(RateModifierAffiliate rateModifiersItem) {
    if (this.rateModifiers == null) {
      this.rateModifiers = new ArrayList<>();
    }
    this.rateModifiers.add(rateModifiersItem);
    return this;
  }

   /**
   * Promotions for this channel
   * @return rateModifiers
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_RATE_MODIFIERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<RateModifierAffiliate> getRateModifiers() {
    return rateModifiers;
  }


  @JsonProperty(JSON_PROPERTY_RATE_MODIFIERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRateModifiers(List<RateModifierAffiliate> rateModifiers) {
    this.rateModifiers = rateModifiers;
  }


  public SalesChannelAffiliate rateModifierBundles(List<RateModifierBundleAffiliate> rateModifierBundles) {
    
    this.rateModifierBundles = rateModifierBundles;
    return this;
  }

  public SalesChannelAffiliate addRateModifierBundlesItem(RateModifierBundleAffiliate rateModifierBundlesItem) {
    if (this.rateModifierBundles == null) {
      this.rateModifierBundles = new ArrayList<>();
    }
    this.rateModifierBundles.add(rateModifierBundlesItem);
    return this;
  }

   /**
   * Promotion bundles for this channel
   * @return rateModifierBundles
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_RATE_MODIFIER_BUNDLES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<RateModifierBundleAffiliate> getRateModifierBundles() {
    return rateModifierBundles;
  }


  @JsonProperty(JSON_PROPERTY_RATE_MODIFIER_BUNDLES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRateModifierBundles(List<RateModifierBundleAffiliate> rateModifierBundles) {
    this.rateModifierBundles = rateModifierBundles;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    SalesChannelAffiliate salesChannelAffiliate = (SalesChannelAffiliate) o;
    return Objects.equals(this.identifier, salesChannelAffiliate.identifier) &&
        Objects.equals(this.supplierIdentifier, salesChannelAffiliate.supplierIdentifier) &&
        Objects.equals(this.supplierName, salesChannelAffiliate.supplierName) &&
        Objects.equals(this.supplierAvailable, salesChannelAffiliate.supplierAvailable) &&
        Objects.equals(this.subType, salesChannelAffiliate.subType) &&
        Objects.equals(this.ownerIdentifier, salesChannelAffiliate.ownerIdentifier) &&
        Objects.equals(this.ownerName, salesChannelAffiliate.ownerName) &&
        Objects.equals(this.enabled, salesChannelAffiliate.enabled) &&
        Objects.equals(this.channelDisabled, salesChannelAffiliate.channelDisabled) &&
        Objects.equals(this.blacklisted, salesChannelAffiliate.blacklisted) &&
        Objects.equals(this.percentDiscount, salesChannelAffiliate.percentDiscount) &&
        Objects.equals(this.commission, salesChannelAffiliate.commission) &&
        Objects.equals(this.rateModifiers, salesChannelAffiliate.rateModifiers) &&
        Objects.equals(this.rateModifierBundles, salesChannelAffiliate.rateModifierBundles);
  }

  @Override
  public int hashCode() {
    return Objects.hash(identifier, supplierIdentifier, supplierName, supplierAvailable, subType, ownerIdentifier, ownerName, enabled, channelDisabled, blacklisted, percentDiscount, commission, rateModifiers, rateModifierBundles);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class SalesChannelAffiliate {\n");
    sb.append("    identifier: ").append(toIndentedString(identifier)).append("\n");
    sb.append("    supplierIdentifier: ").append(toIndentedString(supplierIdentifier)).append("\n");
    sb.append("    supplierName: ").append(toIndentedString(supplierName)).append("\n");
    sb.append("    supplierAvailable: ").append(toIndentedString(supplierAvailable)).append("\n");
    sb.append("    subType: ").append(toIndentedString(subType)).append("\n");
    sb.append("    ownerIdentifier: ").append(toIndentedString(ownerIdentifier)).append("\n");
    sb.append("    ownerName: ").append(toIndentedString(ownerName)).append("\n");
    sb.append("    enabled: ").append(toIndentedString(enabled)).append("\n");
    sb.append("    channelDisabled: ").append(toIndentedString(channelDisabled)).append("\n");
    sb.append("    blacklisted: ").append(toIndentedString(blacklisted)).append("\n");
    sb.append("    percentDiscount: ").append(toIndentedString(percentDiscount)).append("\n");
    sb.append("    commission: ").append(toIndentedString(commission)).append("\n");
    sb.append("    rateModifiers: ").append(toIndentedString(rateModifiers)).append("\n");
    sb.append("    rateModifierBundles: ").append(toIndentedString(rateModifierBundles)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

