/*
 * Wink API
 * ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Affiliate](/affiliate): All APIs related to selling travel inventory as an affiliate. - [Analytics](/analytics): All APIs related to tracking metrics across a wide variety of data source segments including, more entertaining, leaderboard metrics. - [Booking](/booking): All APIs related to creating platform bookings. - [Channel Manager](/channel-manager): All APIs related to channel managers who want to integrate with our platform. - [Extranet](/extranet): All APIs related to managing travel inventory and suppliers. - [Inventory](/inventory): All APIs related to retrieve known travel inventory as it was found using the Lookup API.. - [Lookup](/lookup): All APIs related to locating inventory by region, locale and property flags. - [Reference](/reference): All APIs related to retrieving platform-supported taxonomies. - [TripPay Acquiring](/payment-acquiring): All APIs related to capture payment details such as a Stripe payment intent. - [TripPay](/payment): All APIs related to TripPay account management, booking, mapping and integration features.  ## SDKs We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).  - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)  ## Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Wink-Version` header. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints.  ## Release history - 2022-10-15: v2.0 - Removed HATEOAS and added Wink-Version header - 2022-05-08: v1 - Exposed channel manager API - 2021-07-01: v1 - Initial release  # Affiliate API Welcome to the Affiliate API - A programmer-friendly way to search for and display bespoke travel inventory for your audience. Use this API to help you prepare travel inventory for sale.  # Intended Audience Programmers are a requirement to start integrating with wink. You will benefit from an API integration if you are new or existing travel related company that want easy access to great inventory.## Examples: - Hotel brands / chains that want to make their own booking engine - Travel tech companies that want to create the next hot mobile travel app - Destination sites that want to make their own booking engine - Bloggers and influencers who want to sell travel inventory to their audience - OTAs that want access direct relationships with suppliers and better quality hotel inventory
 *
 * The version of the OpenAPI document: 29.8.3
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.affiliate.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * Descriptors used for filtering the result set
 */
@JsonPropertyOrder({
  CompositeFilterDescriptorAffiliate.JSON_PROPERTY_FIELD,
  CompositeFilterDescriptorAffiliate.JSON_PROPERTY_OPERATOR,
  CompositeFilterDescriptorAffiliate.JSON_PROPERTY_VALUE,
  CompositeFilterDescriptorAffiliate.JSON_PROPERTY_IGNORE_CASE
})
@JsonTypeName("CompositeFilterDescriptor_Affiliate")
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-08-24T16:35:23.308163582+07:00[Asia/Bangkok]")
public class CompositeFilterDescriptorAffiliate {
  public static final String JSON_PROPERTY_FIELD = "field";
  private String field;

  /**
   * Filter operator to use on field
   */
  public enum OperatorEnum {
    NEQ("neq"),
    
    EQ("eq"),
    
    CONTAINS("contains"),
    
    DOESNOTCONTAIN("doesnotcontain"),
    
    ISNULL("isnull"),
    
    ISNOTNULL("isnotnull"),
    
    ISEMPTY("isempty"),
    
    ISNOTEMPTY("isnotempty"),
    
    STARTSWITH("startsWith"),
    
    ENDSWITH("endsWith"),
    
    GTE("gte"),
    
    LTE("lte"),
    
    GT("gt"),
    
    LT("lt");

    private String value;

    OperatorEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static OperatorEnum fromValue(String value) {
      for (OperatorEnum b : OperatorEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_OPERATOR = "operator";
  private OperatorEnum operator;

  public static final String JSON_PROPERTY_VALUE = "value";
  private Object value;

  public static final String JSON_PROPERTY_IGNORE_CASE = "ignoreCase";
  private Boolean ignoreCase;

  public CompositeFilterDescriptorAffiliate() {
  }

  public CompositeFilterDescriptorAffiliate field(String field) {
    
    this.field = field;
    return this;
  }

   /**
   * Field name to filter on
   * @return field
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_FIELD)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getField() {
    return field;
  }


  @JsonProperty(JSON_PROPERTY_FIELD)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setField(String field) {
    this.field = field;
  }


  public CompositeFilterDescriptorAffiliate operator(OperatorEnum operator) {
    
    this.operator = operator;
    return this;
  }

   /**
   * Filter operator to use on field
   * @return operator
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_OPERATOR)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public OperatorEnum getOperator() {
    return operator;
  }


  @JsonProperty(JSON_PROPERTY_OPERATOR)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setOperator(OperatorEnum operator) {
    this.operator = operator;
  }


  public CompositeFilterDescriptorAffiliate value(Object value) {
    
    this.value = value;
    return this;
  }

   /**
   * Value to filter dataset against
   * @return value
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_VALUE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Object getValue() {
    return value;
  }


  @JsonProperty(JSON_PROPERTY_VALUE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setValue(Object value) {
    this.value = value;
  }


  public CompositeFilterDescriptorAffiliate ignoreCase(Boolean ignoreCase) {
    
    this.ignoreCase = ignoreCase;
    return this;
  }

   /**
   * Make filter comparison case insensitive. Default: Case sensitive 
   * @return ignoreCase
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_IGNORE_CASE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getIgnoreCase() {
    return ignoreCase;
  }


  @JsonProperty(JSON_PROPERTY_IGNORE_CASE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIgnoreCase(Boolean ignoreCase) {
    this.ignoreCase = ignoreCase;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    CompositeFilterDescriptorAffiliate compositeFilterDescriptorAffiliate = (CompositeFilterDescriptorAffiliate) o;
    return Objects.equals(this.field, compositeFilterDescriptorAffiliate.field) &&
        Objects.equals(this.operator, compositeFilterDescriptorAffiliate.operator) &&
        Objects.equals(this.value, compositeFilterDescriptorAffiliate.value) &&
        Objects.equals(this.ignoreCase, compositeFilterDescriptorAffiliate.ignoreCase);
  }

  @Override
  public int hashCode() {
    return Objects.hash(field, operator, value, ignoreCase);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class CompositeFilterDescriptorAffiliate {\n");
    sb.append("    field: ").append(toIndentedString(field)).append("\n");
    sb.append("    operator: ").append(toIndentedString(operator)).append("\n");
    sb.append("    value: ").append(toIndentedString(value)).append("\n");
    sb.append("    ignoreCase: ").append(toIndentedString(ignoreCase)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

