/*
 * Wink API
 * ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Affiliate](/affiliate): All APIs related to selling travel inventory as an affiliate. - [Analytics](/analytics): All APIs related to tracking metrics across a wide variety of data source segments including, more entertaining, leaderboard metrics. - [Booking](/booking): All APIs related to creating platform bookings. - [Channel Manager](/channel-manager): All APIs related to channel managers who want to integrate with our platform. - [Extranet](/extranet): All APIs related to managing travel inventory and suppliers. - [Inventory](/inventory): All APIs related to retrieve known travel inventory as it was found using the Lookup API.. - [Lookup](/lookup): All APIs related to locating inventory by region, locale and property flags. - [Reference](/reference): All APIs related to retrieving platform-supported taxonomies. - [TripPay Acquiring](/payment-acquiring): All APIs related to capture payment details such as a Stripe payment intent. - [TripPay](/payment): All APIs related to TripPay account management, booking, mapping and integration features.  ## SDKs We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).  - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)  ## Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Wink-Version` header. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints.  ## Release history - 2022-10-15: v2.0 - Removed HATEOAS and added Wink-Version header - 2022-05-08: v1 - Exposed channel manager API - 2021-07-01: v1 - Initial release  # Affiliate API Welcome to the Affiliate API - A programmer-friendly way to search for and display bespoke travel inventory for your audience. Use this API to help you prepare travel inventory for sale.  # Intended Audience Programmers are a requirement to start integrating with wink. You will benefit from an API integration if you are new or existing travel related company that want easy access to great inventory.## Examples: - Hotel brands / chains that want to make their own booking engine - Travel tech companies that want to create the next hot mobile travel app - Destination sites that want to make their own booking engine - Bloggers and influencers who want to sell travel inventory to their audience - OTAs that want access direct relationships with suppliers and better quality hotel inventory
 *
 * The version of the OpenAPI document: 29.8.8
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.affiliate.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * CouponAffiliate
 */
@JsonPropertyOrder({
  CouponAffiliate.JSON_PROPERTY_AMOUNT_OFF,
  CouponAffiliate.JSON_PROPERTY_CREATED,
  CouponAffiliate.JSON_PROPERTY_CURRENCY,
  CouponAffiliate.JSON_PROPERTY_DELETED,
  CouponAffiliate.JSON_PROPERTY_DURATION,
  CouponAffiliate.JSON_PROPERTY_DURATION_IN_MONTHS,
  CouponAffiliate.JSON_PROPERTY_ID,
  CouponAffiliate.JSON_PROPERTY_LIVEMODE,
  CouponAffiliate.JSON_PROPERTY_MAX_REDEMPTIONS,
  CouponAffiliate.JSON_PROPERTY_METADATA,
  CouponAffiliate.JSON_PROPERTY_NAME,
  CouponAffiliate.JSON_PROPERTY_OBJECT,
  CouponAffiliate.JSON_PROPERTY_PERCENT_OFF,
  CouponAffiliate.JSON_PROPERTY_REDEEM_BY,
  CouponAffiliate.JSON_PROPERTY_TIMES_REDEEMED,
  CouponAffiliate.JSON_PROPERTY_VALID
})
@JsonTypeName("Coupon_Affiliate")
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-08-27T09:54:22.092689314+07:00[Asia/Bangkok]")
public class CouponAffiliate {
  public static final String JSON_PROPERTY_AMOUNT_OFF = "amountOff";
  private Long amountOff;

  public static final String JSON_PROPERTY_CREATED = "created";
  private Long created;

  public static final String JSON_PROPERTY_CURRENCY = "currency";
  private String currency;

  public static final String JSON_PROPERTY_DELETED = "deleted";
  private Boolean deleted;

  public static final String JSON_PROPERTY_DURATION = "duration";
  private String duration;

  public static final String JSON_PROPERTY_DURATION_IN_MONTHS = "durationInMonths";
  private Long durationInMonths;

  public static final String JSON_PROPERTY_ID = "id";
  private String id;

  public static final String JSON_PROPERTY_LIVEMODE = "livemode";
  private Boolean livemode;

  public static final String JSON_PROPERTY_MAX_REDEMPTIONS = "maxRedemptions";
  private Long maxRedemptions;

  public static final String JSON_PROPERTY_METADATA = "metadata";
  private Map<String, String> metadata = new HashMap<>();

  public static final String JSON_PROPERTY_NAME = "name";
  private String name;

  public static final String JSON_PROPERTY_OBJECT = "object";
  private String _object;

  public static final String JSON_PROPERTY_PERCENT_OFF = "percentOff";
  private BigDecimal percentOff;

  public static final String JSON_PROPERTY_REDEEM_BY = "redeemBy";
  private Long redeemBy;

  public static final String JSON_PROPERTY_TIMES_REDEEMED = "timesRedeemed";
  private Long timesRedeemed;

  public static final String JSON_PROPERTY_VALID = "valid";
  private Boolean valid;

  public CouponAffiliate() {
  }

  public CouponAffiliate amountOff(Long amountOff) {
    
    this.amountOff = amountOff;
    return this;
  }

   /**
   * Get amountOff
   * @return amountOff
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_AMOUNT_OFF)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Long getAmountOff() {
    return amountOff;
  }


  @JsonProperty(JSON_PROPERTY_AMOUNT_OFF)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAmountOff(Long amountOff) {
    this.amountOff = amountOff;
  }


  public CouponAffiliate created(Long created) {
    
    this.created = created;
    return this;
  }

   /**
   * Get created
   * @return created
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_CREATED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Long getCreated() {
    return created;
  }


  @JsonProperty(JSON_PROPERTY_CREATED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCreated(Long created) {
    this.created = created;
  }


  public CouponAffiliate currency(String currency) {
    
    this.currency = currency;
    return this;
  }

   /**
   * Get currency
   * @return currency
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getCurrency() {
    return currency;
  }


  @JsonProperty(JSON_PROPERTY_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCurrency(String currency) {
    this.currency = currency;
  }


  public CouponAffiliate deleted(Boolean deleted) {
    
    this.deleted = deleted;
    return this;
  }

   /**
   * Get deleted
   * @return deleted
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_DELETED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getDeleted() {
    return deleted;
  }


  @JsonProperty(JSON_PROPERTY_DELETED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDeleted(Boolean deleted) {
    this.deleted = deleted;
  }


  public CouponAffiliate duration(String duration) {
    
    this.duration = duration;
    return this;
  }

   /**
   * Get duration
   * @return duration
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_DURATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getDuration() {
    return duration;
  }


  @JsonProperty(JSON_PROPERTY_DURATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDuration(String duration) {
    this.duration = duration;
  }


  public CouponAffiliate durationInMonths(Long durationInMonths) {
    
    this.durationInMonths = durationInMonths;
    return this;
  }

   /**
   * Get durationInMonths
   * @return durationInMonths
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_DURATION_IN_MONTHS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Long getDurationInMonths() {
    return durationInMonths;
  }


  @JsonProperty(JSON_PROPERTY_DURATION_IN_MONTHS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDurationInMonths(Long durationInMonths) {
    this.durationInMonths = durationInMonths;
  }


  public CouponAffiliate id(String id) {
    
    this.id = id;
    return this;
  }

   /**
   * Get id
   * @return id
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getId() {
    return id;
  }


  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setId(String id) {
    this.id = id;
  }


  public CouponAffiliate livemode(Boolean livemode) {
    
    this.livemode = livemode;
    return this;
  }

   /**
   * Get livemode
   * @return livemode
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_LIVEMODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getLivemode() {
    return livemode;
  }


  @JsonProperty(JSON_PROPERTY_LIVEMODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLivemode(Boolean livemode) {
    this.livemode = livemode;
  }


  public CouponAffiliate maxRedemptions(Long maxRedemptions) {
    
    this.maxRedemptions = maxRedemptions;
    return this;
  }

   /**
   * Get maxRedemptions
   * @return maxRedemptions
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_MAX_REDEMPTIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Long getMaxRedemptions() {
    return maxRedemptions;
  }


  @JsonProperty(JSON_PROPERTY_MAX_REDEMPTIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMaxRedemptions(Long maxRedemptions) {
    this.maxRedemptions = maxRedemptions;
  }


  public CouponAffiliate metadata(Map<String, String> metadata) {
    
    this.metadata = metadata;
    return this;
  }

  public CouponAffiliate putMetadataItem(String key, String metadataItem) {
    if (this.metadata == null) {
      this.metadata = new HashMap<>();
    }
    this.metadata.put(key, metadataItem);
    return this;
  }

   /**
   * Get metadata
   * @return metadata
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_METADATA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Map<String, String> getMetadata() {
    return metadata;
  }


  @JsonProperty(JSON_PROPERTY_METADATA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMetadata(Map<String, String> metadata) {
    this.metadata = metadata;
  }


  public CouponAffiliate name(String name) {
    
    this.name = name;
    return this;
  }

   /**
   * Get name
   * @return name
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getName() {
    return name;
  }


  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setName(String name) {
    this.name = name;
  }


  public CouponAffiliate _object(String _object) {
    
    this._object = _object;
    return this;
  }

   /**
   * Get _object
   * @return _object
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_OBJECT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getObject() {
    return _object;
  }


  @JsonProperty(JSON_PROPERTY_OBJECT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setObject(String _object) {
    this._object = _object;
  }


  public CouponAffiliate percentOff(BigDecimal percentOff) {
    
    this.percentOff = percentOff;
    return this;
  }

   /**
   * Get percentOff
   * @return percentOff
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_PERCENT_OFF)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public BigDecimal getPercentOff() {
    return percentOff;
  }


  @JsonProperty(JSON_PROPERTY_PERCENT_OFF)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPercentOff(BigDecimal percentOff) {
    this.percentOff = percentOff;
  }


  public CouponAffiliate redeemBy(Long redeemBy) {
    
    this.redeemBy = redeemBy;
    return this;
  }

   /**
   * Get redeemBy
   * @return redeemBy
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_REDEEM_BY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Long getRedeemBy() {
    return redeemBy;
  }


  @JsonProperty(JSON_PROPERTY_REDEEM_BY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRedeemBy(Long redeemBy) {
    this.redeemBy = redeemBy;
  }


  public CouponAffiliate timesRedeemed(Long timesRedeemed) {
    
    this.timesRedeemed = timesRedeemed;
    return this;
  }

   /**
   * Get timesRedeemed
   * @return timesRedeemed
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_TIMES_REDEEMED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Long getTimesRedeemed() {
    return timesRedeemed;
  }


  @JsonProperty(JSON_PROPERTY_TIMES_REDEEMED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTimesRedeemed(Long timesRedeemed) {
    this.timesRedeemed = timesRedeemed;
  }


  public CouponAffiliate valid(Boolean valid) {
    
    this.valid = valid;
    return this;
  }

   /**
   * Get valid
   * @return valid
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_VALID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getValid() {
    return valid;
  }


  @JsonProperty(JSON_PROPERTY_VALID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setValid(Boolean valid) {
    this.valid = valid;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    CouponAffiliate couponAffiliate = (CouponAffiliate) o;
    return Objects.equals(this.amountOff, couponAffiliate.amountOff) &&
        Objects.equals(this.created, couponAffiliate.created) &&
        Objects.equals(this.currency, couponAffiliate.currency) &&
        Objects.equals(this.deleted, couponAffiliate.deleted) &&
        Objects.equals(this.duration, couponAffiliate.duration) &&
        Objects.equals(this.durationInMonths, couponAffiliate.durationInMonths) &&
        Objects.equals(this.id, couponAffiliate.id) &&
        Objects.equals(this.livemode, couponAffiliate.livemode) &&
        Objects.equals(this.maxRedemptions, couponAffiliate.maxRedemptions) &&
        Objects.equals(this.metadata, couponAffiliate.metadata) &&
        Objects.equals(this.name, couponAffiliate.name) &&
        Objects.equals(this._object, couponAffiliate._object) &&
        Objects.equals(this.percentOff, couponAffiliate.percentOff) &&
        Objects.equals(this.redeemBy, couponAffiliate.redeemBy) &&
        Objects.equals(this.timesRedeemed, couponAffiliate.timesRedeemed) &&
        Objects.equals(this.valid, couponAffiliate.valid);
  }

  @Override
  public int hashCode() {
    return Objects.hash(amountOff, created, currency, deleted, duration, durationInMonths, id, livemode, maxRedemptions, metadata, name, _object, percentOff, redeemBy, timesRedeemed, valid);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class CouponAffiliate {\n");
    sb.append("    amountOff: ").append(toIndentedString(amountOff)).append("\n");
    sb.append("    created: ").append(toIndentedString(created)).append("\n");
    sb.append("    currency: ").append(toIndentedString(currency)).append("\n");
    sb.append("    deleted: ").append(toIndentedString(deleted)).append("\n");
    sb.append("    duration: ").append(toIndentedString(duration)).append("\n");
    sb.append("    durationInMonths: ").append(toIndentedString(durationInMonths)).append("\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    livemode: ").append(toIndentedString(livemode)).append("\n");
    sb.append("    maxRedemptions: ").append(toIndentedString(maxRedemptions)).append("\n");
    sb.append("    metadata: ").append(toIndentedString(metadata)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    _object: ").append(toIndentedString(_object)).append("\n");
    sb.append("    percentOff: ").append(toIndentedString(percentOff)).append("\n");
    sb.append("    redeemBy: ").append(toIndentedString(redeemBy)).append("\n");
    sb.append("    timesRedeemed: ").append(toIndentedString(timesRedeemed)).append("\n");
    sb.append("    valid: ").append(toIndentedString(valid)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

