/*
 * Wink API
 * ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Affiliate](/affiliate): All APIs related to selling travel inventory as an affiliate. - [Analytics](/analytics): All APIs related to tracking metrics across a wide variety of data source segments including, more entertaining, leaderboard metrics. - [Booking](/booking): All APIs related to creating platform bookings. - [Channel Manager](/channel-manager): All APIs related to channel managers who want to integrate with our platform. - [Extranet](/extranet): All APIs related to managing travel inventory and suppliers. - [Inventory](/inventory): All APIs related to retrieve known travel inventory as it was found using the Lookup API.. - [Lookup](/lookup): All APIs related to locating inventory by region, locale and property flags. - [Reference](/reference): All APIs related to retrieving platform-supported taxonomies. - [TripPay Acquiring](/payment-acquiring): All APIs related to capture payment details such as a Stripe payment intent. - [TripPay](/payment): All APIs related to TripPay account management, booking, mapping and integration features.  ## SDKs We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).  - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)  ## Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Wink-Version` header. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints.  ## Release history - 2022-10-15: v2.0 - Removed HATEOAS and added Wink-Version header - 2022-05-08: v1 - Exposed channel manager API - 2021-07-01: v1 - Initial release  # Affiliate API Welcome to the Affiliate API - A programmer-friendly way to search for and display bespoke travel inventory for your audience. Use this API to help you prepare travel inventory for sale.  # Intended Audience Programmers are a requirement to start integrating with wink. You will benefit from an API integration if you are new or existing travel related company that want easy access to great inventory.## Examples: - Hotel brands / chains that want to make their own booking engine - Travel tech companies that want to create the next hot mobile travel app - Destination sites that want to make their own booking engine - Bloggers and influencers who want to sell travel inventory to their audience - OTAs that want access direct relationships with suppliers and better quality hotel inventory
 *
 * The version of the OpenAPI document: 29.8.8
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.affiliate.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import travel.wink.sdk.affiliate.model.EngineConfigurationThemeAffiliate;
import travel.wink.sdk.affiliate.model.GeoNameAffiliate;
import travel.wink.sdk.affiliate.model.RoomConfigurationAffiliate;
import travel.wink.sdk.affiliate.model.SimpleMultimediaAffiliate;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * EngineConfigurationAffiliate
 */
@JsonPropertyOrder({
  EngineConfigurationAffiliate.JSON_PROPERTY_IDENTIFIER,
  EngineConfigurationAffiliate.JSON_PROPERTY_NAME,
  EngineConfigurationAffiliate.JSON_PROPERTY_APPEND_TO_PAGE_TITLE,
  EngineConfigurationAffiliate.JSON_PROPERTY_OWNER_IDENTIFIER,
  EngineConfigurationAffiliate.JSON_PROPERTY_OWNER_NAME,
  EngineConfigurationAffiliate.JSON_PROPERTY_SUB_TYPE,
  EngineConfigurationAffiliate.JSON_PROPERTY_PRIMARY,
  EngineConfigurationAffiliate.JSON_PROPERTY_GOOGLE_ANALYTICS_MEASUREMENT_ID,
  EngineConfigurationAffiliate.JSON_PROPERTY_GOOGLE_MAPS_A_P_I_KEY,
  EngineConfigurationAffiliate.JSON_PROPERTY_TAWK_TO_KEY,
  EngineConfigurationAffiliate.JSON_PROPERTY_DEFAULT_CURRENCY,
  EngineConfigurationAffiliate.JSON_PROPERTY_DEFAULT_LANGUAGE,
  EngineConfigurationAffiliate.JSON_PROPERTY_LOGOS,
  EngineConfigurationAffiliate.JSON_PROPERTY_HOSTED_BOOKING_ENGINE_URL,
  EngineConfigurationAffiliate.JSON_PROPERTY_SELF_HOSTED,
  EngineConfigurationAffiliate.JSON_PROPERTY_THEME_COLORS,
  EngineConfigurationAffiliate.JSON_PROPERTY_NUMBER_OF_ADVANCE_DAYS,
  EngineConfigurationAffiliate.JSON_PROPERTY_NUMBER_OF_STAY_DAYS,
  EngineConfigurationAffiliate.JSON_PROPERTY_START_DATE,
  EngineConfigurationAffiliate.JSON_PROPERTY_END_DATE,
  EngineConfigurationAffiliate.JSON_PROPERTY_ROOM_CONFIGURATIONS,
  EngineConfigurationAffiliate.JSON_PROPERTY_USE_DAYS,
  EngineConfigurationAffiliate.JSON_PROPERTY_PROMOTIONAL_CODES,
  EngineConfigurationAffiliate.JSON_PROPERTY_SEND_BOOKING_NOTIFICATION_EMAILS_TO_PROPERTY,
  EngineConfigurationAffiliate.JSON_PROPERTY_SEND_BOOKING_NOTIFICATION_EMAILS_TO_BOOKER,
  EngineConfigurationAffiliate.JSON_PROPERTY_SEND_BOOKING_NOTIFICATION_EMAILS_TO_CHANNEL_MANAGER,
  EngineConfigurationAffiliate.JSON_PROPERTY_WC_BOOK_CLICK_ACTION,
  EngineConfigurationAffiliate.JSON_PROPERTY_CITY,
  EngineConfigurationAffiliate.JSON_PROPERTY_SHOW_UNAVAILABLE_CARD,
  EngineConfigurationAffiliate.JSON_PROPERTY_SHOW_RANKINGS
})
@JsonTypeName("EngineConfiguration_Affiliate")
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-08-27T09:54:22.092689314+07:00[Asia/Bangkok]")
public class EngineConfigurationAffiliate {
  public static final String JSON_PROPERTY_IDENTIFIER = "identifier";
  private UUID identifier;

  public static final String JSON_PROPERTY_NAME = "name";
  private String name;

  public static final String JSON_PROPERTY_APPEND_TO_PAGE_TITLE = "appendToPageTitle";
  private String appendToPageTitle;

  public static final String JSON_PROPERTY_OWNER_IDENTIFIER = "ownerIdentifier";
  private UUID ownerIdentifier;

  public static final String JSON_PROPERTY_OWNER_NAME = "ownerName";
  private String ownerName;

  /**
   * Sales channel sub-type.
   */
  public enum SubTypeEnum {
    DIRECT("DIRECT"),
    
    APPLICATION("APPLICATION"),
    
    HOTEL("HOTEL"),
    
    TRAVELIKO("TRAVELIKO"),
    
    CORPORATE("CORPORATE"),
    
    TRAVEL_AGENT("TRAVEL_AGENT"),
    
    INFLUENCER("INFLUENCER"),
    
    BLOGGER("BLOGGER"),
    
    DESTINATION("DESTINATION"),
    
    CHANNEL_MANAGER("CHANNEL_MANAGER"),
    
    PROPERTY_MANAGEMENT_SYSTEM("PROPERTY_MANAGEMENT_SYSTEM"),
    
    CENTRAL_RESERVATION_SYSTEM("CENTRAL_RESERVATION_SYSTEM");

    private String value;

    SubTypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static SubTypeEnum fromValue(String value) {
      for (SubTypeEnum b : SubTypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_SUB_TYPE = "subType";
  private SubTypeEnum subType;

  public static final String JSON_PROPERTY_PRIMARY = "primary";
  private Boolean primary = false;

  public static final String JSON_PROPERTY_GOOGLE_ANALYTICS_MEASUREMENT_ID = "googleAnalyticsMeasurementId";
  private String googleAnalyticsMeasurementId;

  public static final String JSON_PROPERTY_GOOGLE_MAPS_A_P_I_KEY = "googleMapsAPIKey";
  private String googleMapsAPIKey;

  public static final String JSON_PROPERTY_TAWK_TO_KEY = "tawkToKey";
  private String tawkToKey;

  public static final String JSON_PROPERTY_DEFAULT_CURRENCY = "defaultCurrency";
  private String defaultCurrency = "USD";

  public static final String JSON_PROPERTY_DEFAULT_LANGUAGE = "defaultLanguage";
  private String defaultLanguage = "en";

  public static final String JSON_PROPERTY_LOGOS = "logos";
  private List<SimpleMultimediaAffiliate> logos = new ArrayList<>();

  public static final String JSON_PROPERTY_HOSTED_BOOKING_ENGINE_URL = "hostedBookingEngineUrl";
  private String hostedBookingEngineUrl = "https://ota.wink.travel";

  public static final String JSON_PROPERTY_SELF_HOSTED = "selfHosted";
  private Boolean selfHosted = false;

  public static final String JSON_PROPERTY_THEME_COLORS = "themeColors";
  private EngineConfigurationThemeAffiliate themeColors;

  public static final String JSON_PROPERTY_NUMBER_OF_ADVANCE_DAYS = "numberOfAdvanceDays";
  private Integer numberOfAdvanceDays;

  public static final String JSON_PROPERTY_NUMBER_OF_STAY_DAYS = "numberOfStayDays";
  private Integer numberOfStayDays;

  public static final String JSON_PROPERTY_START_DATE = "startDate";
  private LocalDate startDate;

  public static final String JSON_PROPERTY_END_DATE = "endDate";
  private LocalDate endDate;

  public static final String JSON_PROPERTY_ROOM_CONFIGURATIONS = "roomConfigurations";
  private List<RoomConfigurationAffiliate> roomConfigurations = new ArrayList<>();

  public static final String JSON_PROPERTY_USE_DAYS = "useDays";
  private Boolean useDays;

  public static final String JSON_PROPERTY_PROMOTIONAL_CODES = "promotionalCodes";
  private List<String> promotionalCodes = new ArrayList<>();

  public static final String JSON_PROPERTY_SEND_BOOKING_NOTIFICATION_EMAILS_TO_PROPERTY = "sendBookingNotificationEmailsToProperty";
  private Boolean sendBookingNotificationEmailsToProperty = true;

  public static final String JSON_PROPERTY_SEND_BOOKING_NOTIFICATION_EMAILS_TO_BOOKER = "sendBookingNotificationEmailsToBooker";
  private Boolean sendBookingNotificationEmailsToBooker = true;

  public static final String JSON_PROPERTY_SEND_BOOKING_NOTIFICATION_EMAILS_TO_CHANNEL_MANAGER = "sendBookingNotificationEmailsToChannelManager";
  private Boolean sendBookingNotificationEmailsToChannelManager = true;

  /**
   * Action to complete once a user clicks on the CTA button on inventory.
   */
  public enum WcBookClickActionEnum {
    FORWARD_TO_IBE("FORWARD_TO_IBE"),
    
    IBE_MODAL("IBE_MODAL");

    private String value;

    WcBookClickActionEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static WcBookClickActionEnum fromValue(String value) {
      for (WcBookClickActionEnum b : WcBookClickActionEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_WC_BOOK_CLICK_ACTION = "wcBookClickAction";
  private WcBookClickActionEnum wcBookClickAction;

  public static final String JSON_PROPERTY_CITY = "city";
  private GeoNameAffiliate city;

  public static final String JSON_PROPERTY_SHOW_UNAVAILABLE_CARD = "showUnavailableCard";
  private Boolean showUnavailableCard;

  public static final String JSON_PROPERTY_SHOW_RANKINGS = "showRankings";
  private Boolean showRankings;

  public EngineConfigurationAffiliate() {
  }

  public EngineConfigurationAffiliate identifier(UUID identifier) {
    
    this.identifier = identifier;
    return this;
  }

   /**
   * Unique engine configuration identifier
   * @return identifier
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public UUID getIdentifier() {
    return identifier;
  }


  @JsonProperty(JSON_PROPERTY_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setIdentifier(UUID identifier) {
    this.identifier = identifier;
  }


  public EngineConfigurationAffiliate name(String name) {
    
    this.name = name;
    return this;
  }

   /**
   * Engine configuration name
   * @return name
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getName() {
    return name;
  }


  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setName(String name) {
    this.name = name;
  }


  public EngineConfigurationAffiliate appendToPageTitle(String appendToPageTitle) {
    
    this.appendToPageTitle = appendToPageTitle;
    return this;
  }

   /**
   * Whether to append text to the existing booking engine page title.
   * @return appendToPageTitle
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_APPEND_TO_PAGE_TITLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getAppendToPageTitle() {
    return appendToPageTitle;
  }


  @JsonProperty(JSON_PROPERTY_APPEND_TO_PAGE_TITLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAppendToPageTitle(String appendToPageTitle) {
    this.appendToPageTitle = appendToPageTitle;
  }


  public EngineConfigurationAffiliate ownerIdentifier(UUID ownerIdentifier) {
    
    this.ownerIdentifier = ownerIdentifier;
    return this;
  }

   /**
   * Engine configuration record creator identifier
   * @return ownerIdentifier
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_OWNER_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public UUID getOwnerIdentifier() {
    return ownerIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_OWNER_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setOwnerIdentifier(UUID ownerIdentifier) {
    this.ownerIdentifier = ownerIdentifier;
  }


  public EngineConfigurationAffiliate ownerName(String ownerName) {
    
    this.ownerName = ownerName;
    return this;
  }

   /**
   * Name of company owner.
   * @return ownerName
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_OWNER_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getOwnerName() {
    return ownerName;
  }


  @JsonProperty(JSON_PROPERTY_OWNER_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setOwnerName(String ownerName) {
    this.ownerName = ownerName;
  }


  public EngineConfigurationAffiliate subType(SubTypeEnum subType) {
    
    this.subType = subType;
    return this;
  }

   /**
   * Sales channel sub-type.
   * @return subType
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_SUB_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public SubTypeEnum getSubType() {
    return subType;
  }


  @JsonProperty(JSON_PROPERTY_SUB_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setSubType(SubTypeEnum subType) {
    this.subType = subType;
  }


  public EngineConfigurationAffiliate primary(Boolean primary) {
    
    this.primary = primary;
    return this;
  }

   /**
   * Indicates whether this configuration is primary. A primary configuration cannot be removed.
   * @return primary
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_PRIMARY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getPrimary() {
    return primary;
  }


  @JsonProperty(JSON_PROPERTY_PRIMARY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPrimary(Boolean primary) {
    this.primary = primary;
  }


  public EngineConfigurationAffiliate googleAnalyticsMeasurementId(String googleAnalyticsMeasurementId) {
    
    this.googleAnalyticsMeasurementId = googleAnalyticsMeasurementId;
    return this;
  }

   /**
   * If you want to track analytics with Google Analytics and GTM for your self-hosted booking engine, you need to import our [GTM profile](https://www.dropbox.com/s/o6rwluclvsgydma/gtm-template-2020-2.json?dl&#x3D;0) into your GTM container and link it with your Google Analytics account. [More about that here](https://bearchoke.atlassian.net/wiki/spaces/TC/pages/2941648897/Linking+your+Google+Tag+Manager+account) 
   * @return googleAnalyticsMeasurementId
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_GOOGLE_ANALYTICS_MEASUREMENT_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getGoogleAnalyticsMeasurementId() {
    return googleAnalyticsMeasurementId;
  }


  @JsonProperty(JSON_PROPERTY_GOOGLE_ANALYTICS_MEASUREMENT_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setGoogleAnalyticsMeasurementId(String googleAnalyticsMeasurementId) {
    this.googleAnalyticsMeasurementId = googleAnalyticsMeasurementId;
  }


  public EngineConfigurationAffiliate googleMapsAPIKey(String googleMapsAPIKey) {
    
    this.googleMapsAPIKey = googleMapsAPIKey;
    return this;
  }

   /**
   * If you want your users to see Google Maps in your hosted booking engine, go to [Google Maps](https://console.developers.google.com/projectselector2/apis/credentials?supportedpurview&#x3D;project) and create an API key for your site.
   * @return googleMapsAPIKey
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_GOOGLE_MAPS_A_P_I_KEY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getGoogleMapsAPIKey() {
    return googleMapsAPIKey;
  }


  @JsonProperty(JSON_PROPERTY_GOOGLE_MAPS_A_P_I_KEY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setGoogleMapsAPIKey(String googleMapsAPIKey) {
    this.googleMapsAPIKey = googleMapsAPIKey;
  }


  public EngineConfigurationAffiliate tawkToKey(String tawkToKey) {
    
    this.tawkToKey = tawkToKey;
    return this;
  }

   /**
   * If you want your users to be able to chat with you on your hosted booking engine, set yourself up with a [tawk.to account](https://dashboard.tawk.to/signup) and add your API key here.
   * @return tawkToKey
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_TAWK_TO_KEY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getTawkToKey() {
    return tawkToKey;
  }


  @JsonProperty(JSON_PROPERTY_TAWK_TO_KEY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTawkToKey(String tawkToKey) {
    this.tawkToKey = tawkToKey;
  }


  public EngineConfigurationAffiliate defaultCurrency(String defaultCurrency) {
    
    this.defaultCurrency = defaultCurrency;
    return this;
  }

   /**
   * Control which currency your users see prices in initially.
   * @return defaultCurrency
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_DEFAULT_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getDefaultCurrency() {
    return defaultCurrency;
  }


  @JsonProperty(JSON_PROPERTY_DEFAULT_CURRENCY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDefaultCurrency(String defaultCurrency) {
    this.defaultCurrency = defaultCurrency;
  }


  public EngineConfigurationAffiliate defaultLanguage(String defaultLanguage) {
    
    this.defaultLanguage = defaultLanguage;
    return this;
  }

   /**
   * Control which language your users see text in initially.
   * @return defaultLanguage
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_DEFAULT_LANGUAGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getDefaultLanguage() {
    return defaultLanguage;
  }


  @JsonProperty(JSON_PROPERTY_DEFAULT_LANGUAGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDefaultLanguage(String defaultLanguage) {
    this.defaultLanguage = defaultLanguage;
  }


  public EngineConfigurationAffiliate logos(List<SimpleMultimediaAffiliate> logos) {
    
    this.logos = logos;
    return this;
  }

  public EngineConfigurationAffiliate addLogosItem(SimpleMultimediaAffiliate logosItem) {
    if (this.logos == null) {
      this.logos = new ArrayList<>();
    }
    this.logos.add(logosItem);
    return this;
  }

   /**
   * Customize booking confirmation emails by adding a custom logo to your configuration.
   * @return logos
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_LOGOS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<SimpleMultimediaAffiliate> getLogos() {
    return logos;
  }


  @JsonProperty(JSON_PROPERTY_LOGOS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLogos(List<SimpleMultimediaAffiliate> logos) {
    this.logos = logos;
  }


  public EngineConfigurationAffiliate hostedBookingEngineUrl(String hostedBookingEngineUrl) {
    
    this.hostedBookingEngineUrl = hostedBookingEngineUrl;
    return this;
  }

   /**
   * If you are self-hosting our booking engine, let us know where it is hosted. Note: This url needs to be secured with SSL.
   * @return hostedBookingEngineUrl
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_HOSTED_BOOKING_ENGINE_URL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getHostedBookingEngineUrl() {
    return hostedBookingEngineUrl;
  }


  @JsonProperty(JSON_PROPERTY_HOSTED_BOOKING_ENGINE_URL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setHostedBookingEngineUrl(String hostedBookingEngineUrl) {
    this.hostedBookingEngineUrl = hostedBookingEngineUrl;
  }


  public EngineConfigurationAffiliate selfHosted(Boolean selfHosted) {
    
    this.selfHosted = selfHosted;
    return this;
  }

   /**
   * Flag to indicate you are self-hosting our booking engine and not using our default booking engine url.
   * @return selfHosted
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_SELF_HOSTED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getSelfHosted() {
    return selfHosted;
  }


  @JsonProperty(JSON_PROPERTY_SELF_HOSTED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSelfHosted(Boolean selfHosted) {
    this.selfHosted = selfHosted;
  }


  public EngineConfigurationAffiliate themeColors(EngineConfigurationThemeAffiliate themeColors) {
    
    this.themeColors = themeColors;
    return this;
  }

   /**
   * Get themeColors
   * @return themeColors
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_THEME_COLORS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public EngineConfigurationThemeAffiliate getThemeColors() {
    return themeColors;
  }


  @JsonProperty(JSON_PROPERTY_THEME_COLORS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setThemeColors(EngineConfigurationThemeAffiliate themeColors) {
    this.themeColors = themeColors;
  }


  public EngineConfigurationAffiliate numberOfAdvanceDays(Integer numberOfAdvanceDays) {
    
    this.numberOfAdvanceDays = numberOfAdvanceDays;
    return this;
  }

   /**
   * You can control the initial itinerary date used to retrieve travel inventory prices. You can do it in one of two ways: 1. Dynamically set the date by indicating how long and how many days in advance (this field), of today&#39;s date, you want to display prices for. 2. Set a fixed date to display prices for. Option 1 is the most shared. Option 2 is for when you want to create a new customization and apply it to a specific event that occurs on a specific date. If you don&#39;t use either of these options, the itinerary will default to today&#39;s date with one night stay. ONLY populate this field if you want to control the itinerary date. Also, leave &#x60;startDate&#x60; and &#x60;endDate&#x60; empty.
   * @return numberOfAdvanceDays
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_NUMBER_OF_ADVANCE_DAYS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getNumberOfAdvanceDays() {
    return numberOfAdvanceDays;
  }


  @JsonProperty(JSON_PROPERTY_NUMBER_OF_ADVANCE_DAYS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setNumberOfAdvanceDays(Integer numberOfAdvanceDays) {
    this.numberOfAdvanceDays = numberOfAdvanceDays;
  }


  public EngineConfigurationAffiliate numberOfStayDays(Integer numberOfStayDays) {
    
    this.numberOfStayDays = numberOfStayDays;
    return this;
  }

   /**
   * You can control the initial itinerary date used to retrieve travel inventory prices. You can do it in one of two ways: 1. Dynamically set the date by indicating how long (this field) and how many days in advance, of today&#39;s date, you want to display prices for. 2. Set a fixed date to display prices for. Option 1 is the most shared. Option 2 is for when you want to create a new customization and apply it to a specific event that occurs on a specific date. If you don&#39;t use either of these options, the itinerary will default to today&#39;s date with one night stay. ONLY populate this field if you want to control the itinerary date. Also, leave &#x60;startDate&#x60; and &#x60;endDate&#x60; empty.
   * @return numberOfStayDays
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_NUMBER_OF_STAY_DAYS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getNumberOfStayDays() {
    return numberOfStayDays;
  }


  @JsonProperty(JSON_PROPERTY_NUMBER_OF_STAY_DAYS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setNumberOfStayDays(Integer numberOfStayDays) {
    this.numberOfStayDays = numberOfStayDays;
  }


  public EngineConfigurationAffiliate startDate(LocalDate startDate) {
    
    this.startDate = startDate;
    return this;
  }

   /**
   * Set a fixed itinerary start date. ONLY populate this field if you want to fix the itinerary date. Also, leave &#x60;numberOfAdvanceDays&#x60; and &#x60;numberOfStayDays&#x60; empty.
   * @return startDate
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_START_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public LocalDate getStartDate() {
    return startDate;
  }


  @JsonProperty(JSON_PROPERTY_START_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setStartDate(LocalDate startDate) {
    this.startDate = startDate;
  }


  public EngineConfigurationAffiliate endDate(LocalDate endDate) {
    
    this.endDate = endDate;
    return this;
  }

   /**
   * Set a fixed itinerary end date ONLY populate this field if you want to fix the itinerary date. Also, leave &#x60;numberOfAdvanceDays&#x60; and &#x60;numberOfStayDays&#x60; empty.
   * @return endDate
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_END_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public LocalDate getEndDate() {
    return endDate;
  }


  @JsonProperty(JSON_PROPERTY_END_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setEndDate(LocalDate endDate) {
    this.endDate = endDate;
  }


  public EngineConfigurationAffiliate roomConfigurations(List<RoomConfigurationAffiliate> roomConfigurations) {
    
    this.roomConfigurations = roomConfigurations;
    return this;
  }

  public EngineConfigurationAffiliate addRoomConfigurationsItem(RoomConfigurationAffiliate roomConfigurationsItem) {
    if (this.roomConfigurations == null) {
      this.roomConfigurations = new ArrayList<>();
    }
    this.roomConfigurations.add(roomConfigurationsItem);
    return this;
  }

   /**
   * Control how many adults / children will be staying and how many rooms. Defaults to: One room, two adults.
   * @return roomConfigurations
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_ROOM_CONFIGURATIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<RoomConfigurationAffiliate> getRoomConfigurations() {
    return roomConfigurations;
  }


  @JsonProperty(JSON_PROPERTY_ROOM_CONFIGURATIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRoomConfigurations(List<RoomConfigurationAffiliate> roomConfigurations) {
    this.roomConfigurations = roomConfigurations;
  }


  public EngineConfigurationAffiliate useDays(Boolean useDays) {
    
    this.useDays = useDays;
    return this;
  }

   /**
   * if true, we use numberOfAdvanceDays / numberOfStayDays properties - false, we use startDate / endDate
   * @return useDays
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_USE_DAYS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getUseDays() {
    return useDays;
  }


  @JsonProperty(JSON_PROPERTY_USE_DAYS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setUseDays(Boolean useDays) {
    this.useDays = useDays;
  }


  public EngineConfigurationAffiliate promotionalCodes(List<String> promotionalCodes) {
    
    this.promotionalCodes = promotionalCodes;
    return this;
  }

  public EngineConfigurationAffiliate addPromotionalCodesItem(String promotionalCodesItem) {
    if (this.promotionalCodes == null) {
      this.promotionalCodes = new ArrayList<>();
    }
    this.promotionalCodes.add(promotionalCodesItem);
    return this;
  }

   /**
   * If you&#39;ve received special promotional codes from suppliers to give to your audience, you can choose to bake these code directly into the price by entering them here.
   * @return promotionalCodes
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_PROMOTIONAL_CODES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<String> getPromotionalCodes() {
    return promotionalCodes;
  }


  @JsonProperty(JSON_PROPERTY_PROMOTIONAL_CODES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPromotionalCodes(List<String> promotionalCodes) {
    this.promotionalCodes = promotionalCodes;
  }


  public EngineConfigurationAffiliate sendBookingNotificationEmailsToProperty(Boolean sendBookingNotificationEmailsToProperty) {
    
    this.sendBookingNotificationEmailsToProperty = sendBookingNotificationEmailsToProperty;
    return this;
  }

   /**
   * An integrator can choose to disable outgoing emails to properties because they want to do that themselves.
   * @return sendBookingNotificationEmailsToProperty
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_SEND_BOOKING_NOTIFICATION_EMAILS_TO_PROPERTY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getSendBookingNotificationEmailsToProperty() {
    return sendBookingNotificationEmailsToProperty;
  }


  @JsonProperty(JSON_PROPERTY_SEND_BOOKING_NOTIFICATION_EMAILS_TO_PROPERTY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSendBookingNotificationEmailsToProperty(Boolean sendBookingNotificationEmailsToProperty) {
    this.sendBookingNotificationEmailsToProperty = sendBookingNotificationEmailsToProperty;
  }


  public EngineConfigurationAffiliate sendBookingNotificationEmailsToBooker(Boolean sendBookingNotificationEmailsToBooker) {
    
    this.sendBookingNotificationEmailsToBooker = sendBookingNotificationEmailsToBooker;
    return this;
  }

   /**
   * An integrator can choose to disable outgoing emails to users because they want to do that themselves.
   * @return sendBookingNotificationEmailsToBooker
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_SEND_BOOKING_NOTIFICATION_EMAILS_TO_BOOKER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getSendBookingNotificationEmailsToBooker() {
    return sendBookingNotificationEmailsToBooker;
  }


  @JsonProperty(JSON_PROPERTY_SEND_BOOKING_NOTIFICATION_EMAILS_TO_BOOKER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSendBookingNotificationEmailsToBooker(Boolean sendBookingNotificationEmailsToBooker) {
    this.sendBookingNotificationEmailsToBooker = sendBookingNotificationEmailsToBooker;
  }


  public EngineConfigurationAffiliate sendBookingNotificationEmailsToChannelManager(Boolean sendBookingNotificationEmailsToChannelManager) {
    
    this.sendBookingNotificationEmailsToChannelManager = sendBookingNotificationEmailsToChannelManager;
    return this;
  }

   /**
   * An integrator can choose to disable notifying the property&#39;s channel manager. Note: This should ONLY be done for testing.
   * @return sendBookingNotificationEmailsToChannelManager
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_SEND_BOOKING_NOTIFICATION_EMAILS_TO_CHANNEL_MANAGER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getSendBookingNotificationEmailsToChannelManager() {
    return sendBookingNotificationEmailsToChannelManager;
  }


  @JsonProperty(JSON_PROPERTY_SEND_BOOKING_NOTIFICATION_EMAILS_TO_CHANNEL_MANAGER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSendBookingNotificationEmailsToChannelManager(Boolean sendBookingNotificationEmailsToChannelManager) {
    this.sendBookingNotificationEmailsToChannelManager = sendBookingNotificationEmailsToChannelManager;
  }


  public EngineConfigurationAffiliate wcBookClickAction(WcBookClickActionEnum wcBookClickAction) {
    
    this.wcBookClickAction = wcBookClickAction;
    return this;
  }

   /**
   * Action to complete once a user clicks on the CTA button on inventory.
   * @return wcBookClickAction
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_WC_BOOK_CLICK_ACTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public WcBookClickActionEnum getWcBookClickAction() {
    return wcBookClickAction;
  }


  @JsonProperty(JSON_PROPERTY_WC_BOOK_CLICK_ACTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setWcBookClickAction(WcBookClickActionEnum wcBookClickAction) {
    this.wcBookClickAction = wcBookClickAction;
  }


  public EngineConfigurationAffiliate city(GeoNameAffiliate city) {
    
    this.city = city;
    return this;
  }

   /**
   * Get city
   * @return city
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_CITY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public GeoNameAffiliate getCity() {
    return city;
  }


  @JsonProperty(JSON_PROPERTY_CITY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCity(GeoNameAffiliate city) {
    this.city = city;
  }


  public EngineConfigurationAffiliate showUnavailableCard(Boolean showUnavailableCard) {
    
    this.showUnavailableCard = showUnavailableCard;
    return this;
  }

   /**
   * Show unavailable inventory card when inventory not currently for sale. Otherwise, it displays a normal card but without the price.
   * @return showUnavailableCard
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_SHOW_UNAVAILABLE_CARD)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getShowUnavailableCard() {
    return showUnavailableCard;
  }


  @JsonProperty(JSON_PROPERTY_SHOW_UNAVAILABLE_CARD)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setShowUnavailableCard(Boolean showUnavailableCard) {
    this.showUnavailableCard = showUnavailableCard;
  }


  public EngineConfigurationAffiliate showRankings(Boolean showRankings) {
    
    this.showRankings = showRankings;
    return this;
  }

   /**
   * Whether to display rankings (lifestyle, eco score and reviews) on hotel landing page.
   * @return showRankings
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_SHOW_RANKINGS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getShowRankings() {
    return showRankings;
  }


  @JsonProperty(JSON_PROPERTY_SHOW_RANKINGS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setShowRankings(Boolean showRankings) {
    this.showRankings = showRankings;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    EngineConfigurationAffiliate engineConfigurationAffiliate = (EngineConfigurationAffiliate) o;
    return Objects.equals(this.identifier, engineConfigurationAffiliate.identifier) &&
        Objects.equals(this.name, engineConfigurationAffiliate.name) &&
        Objects.equals(this.appendToPageTitle, engineConfigurationAffiliate.appendToPageTitle) &&
        Objects.equals(this.ownerIdentifier, engineConfigurationAffiliate.ownerIdentifier) &&
        Objects.equals(this.ownerName, engineConfigurationAffiliate.ownerName) &&
        Objects.equals(this.subType, engineConfigurationAffiliate.subType) &&
        Objects.equals(this.primary, engineConfigurationAffiliate.primary) &&
        Objects.equals(this.googleAnalyticsMeasurementId, engineConfigurationAffiliate.googleAnalyticsMeasurementId) &&
        Objects.equals(this.googleMapsAPIKey, engineConfigurationAffiliate.googleMapsAPIKey) &&
        Objects.equals(this.tawkToKey, engineConfigurationAffiliate.tawkToKey) &&
        Objects.equals(this.defaultCurrency, engineConfigurationAffiliate.defaultCurrency) &&
        Objects.equals(this.defaultLanguage, engineConfigurationAffiliate.defaultLanguage) &&
        Objects.equals(this.logos, engineConfigurationAffiliate.logos) &&
        Objects.equals(this.hostedBookingEngineUrl, engineConfigurationAffiliate.hostedBookingEngineUrl) &&
        Objects.equals(this.selfHosted, engineConfigurationAffiliate.selfHosted) &&
        Objects.equals(this.themeColors, engineConfigurationAffiliate.themeColors) &&
        Objects.equals(this.numberOfAdvanceDays, engineConfigurationAffiliate.numberOfAdvanceDays) &&
        Objects.equals(this.numberOfStayDays, engineConfigurationAffiliate.numberOfStayDays) &&
        Objects.equals(this.startDate, engineConfigurationAffiliate.startDate) &&
        Objects.equals(this.endDate, engineConfigurationAffiliate.endDate) &&
        Objects.equals(this.roomConfigurations, engineConfigurationAffiliate.roomConfigurations) &&
        Objects.equals(this.useDays, engineConfigurationAffiliate.useDays) &&
        Objects.equals(this.promotionalCodes, engineConfigurationAffiliate.promotionalCodes) &&
        Objects.equals(this.sendBookingNotificationEmailsToProperty, engineConfigurationAffiliate.sendBookingNotificationEmailsToProperty) &&
        Objects.equals(this.sendBookingNotificationEmailsToBooker, engineConfigurationAffiliate.sendBookingNotificationEmailsToBooker) &&
        Objects.equals(this.sendBookingNotificationEmailsToChannelManager, engineConfigurationAffiliate.sendBookingNotificationEmailsToChannelManager) &&
        Objects.equals(this.wcBookClickAction, engineConfigurationAffiliate.wcBookClickAction) &&
        Objects.equals(this.city, engineConfigurationAffiliate.city) &&
        Objects.equals(this.showUnavailableCard, engineConfigurationAffiliate.showUnavailableCard) &&
        Objects.equals(this.showRankings, engineConfigurationAffiliate.showRankings);
  }

  @Override
  public int hashCode() {
    return Objects.hash(identifier, name, appendToPageTitle, ownerIdentifier, ownerName, subType, primary, googleAnalyticsMeasurementId, googleMapsAPIKey, tawkToKey, defaultCurrency, defaultLanguage, logos, hostedBookingEngineUrl, selfHosted, themeColors, numberOfAdvanceDays, numberOfStayDays, startDate, endDate, roomConfigurations, useDays, promotionalCodes, sendBookingNotificationEmailsToProperty, sendBookingNotificationEmailsToBooker, sendBookingNotificationEmailsToChannelManager, wcBookClickAction, city, showUnavailableCard, showRankings);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class EngineConfigurationAffiliate {\n");
    sb.append("    identifier: ").append(toIndentedString(identifier)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    appendToPageTitle: ").append(toIndentedString(appendToPageTitle)).append("\n");
    sb.append("    ownerIdentifier: ").append(toIndentedString(ownerIdentifier)).append("\n");
    sb.append("    ownerName: ").append(toIndentedString(ownerName)).append("\n");
    sb.append("    subType: ").append(toIndentedString(subType)).append("\n");
    sb.append("    primary: ").append(toIndentedString(primary)).append("\n");
    sb.append("    googleAnalyticsMeasurementId: ").append(toIndentedString(googleAnalyticsMeasurementId)).append("\n");
    sb.append("    googleMapsAPIKey: ").append(toIndentedString(googleMapsAPIKey)).append("\n");
    sb.append("    tawkToKey: ").append(toIndentedString(tawkToKey)).append("\n");
    sb.append("    defaultCurrency: ").append(toIndentedString(defaultCurrency)).append("\n");
    sb.append("    defaultLanguage: ").append(toIndentedString(defaultLanguage)).append("\n");
    sb.append("    logos: ").append(toIndentedString(logos)).append("\n");
    sb.append("    hostedBookingEngineUrl: ").append(toIndentedString(hostedBookingEngineUrl)).append("\n");
    sb.append("    selfHosted: ").append(toIndentedString(selfHosted)).append("\n");
    sb.append("    themeColors: ").append(toIndentedString(themeColors)).append("\n");
    sb.append("    numberOfAdvanceDays: ").append(toIndentedString(numberOfAdvanceDays)).append("\n");
    sb.append("    numberOfStayDays: ").append(toIndentedString(numberOfStayDays)).append("\n");
    sb.append("    startDate: ").append(toIndentedString(startDate)).append("\n");
    sb.append("    endDate: ").append(toIndentedString(endDate)).append("\n");
    sb.append("    roomConfigurations: ").append(toIndentedString(roomConfigurations)).append("\n");
    sb.append("    useDays: ").append(toIndentedString(useDays)).append("\n");
    sb.append("    promotionalCodes: ").append(toIndentedString(promotionalCodes)).append("\n");
    sb.append("    sendBookingNotificationEmailsToProperty: ").append(toIndentedString(sendBookingNotificationEmailsToProperty)).append("\n");
    sb.append("    sendBookingNotificationEmailsToBooker: ").append(toIndentedString(sendBookingNotificationEmailsToBooker)).append("\n");
    sb.append("    sendBookingNotificationEmailsToChannelManager: ").append(toIndentedString(sendBookingNotificationEmailsToChannelManager)).append("\n");
    sb.append("    wcBookClickAction: ").append(toIndentedString(wcBookClickAction)).append("\n");
    sb.append("    city: ").append(toIndentedString(city)).append("\n");
    sb.append("    showUnavailableCard: ").append(toIndentedString(showUnavailableCard)).append("\n");
    sb.append("    showRankings: ").append(toIndentedString(showRankings)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

