/*
 * Wink API
 * ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Affiliate](/affiliate): All APIs related to selling travel inventory as an affiliate. - [Analytics](/analytics): All APIs related to tracking metrics across a wide variety of data source segments including, more entertaining, leaderboard metrics. - [Booking](/booking): All APIs related to creating platform bookings. - [Channel Manager](/channel-manager): All APIs related to channel managers who want to integrate with our platform. - [Extranet](/extranet): All APIs related to managing travel inventory and suppliers. - [Inventory](/inventory): All APIs related to retrieve known travel inventory as it was found using the Lookup API.. - [Lookup](/lookup): All APIs related to locating inventory by region, locale and property flags. - [Reference](/reference): All APIs related to retrieving platform-supported taxonomies. - [TripPay Acquiring](/payment-acquiring): All APIs related to capture payment details such as a Stripe payment intent. - [TripPay](/payment): All APIs related to TripPay account management, booking, mapping and integration features.  ## SDKs We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).  - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)  ## Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Wink-Version` header. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints.  ## Release history - 2022-10-15: v2.0 - Removed HATEOAS and added Wink-Version header - 2022-05-08: v1 - Exposed channel manager API - 2021-07-01: v1 - Initial release  # Affiliate API Welcome to the Affiliate API - A programmer-friendly way to search for and display bespoke travel inventory for your audience. Use this API to help you prepare travel inventory for sale.  # Intended Audience Programmers are a requirement to start integrating with wink. You will benefit from an API integration if you are new or existing travel related company that want easy access to great inventory.## Examples: - Hotel brands / chains that want to make their own booking engine - Travel tech companies that want to create the next hot mobile travel app - Destination sites that want to make their own booking engine - Bloggers and influencers who want to sell travel inventory to their audience - OTAs that want access direct relationships with suppliers and better quality hotel inventory
 *
 * The version of the OpenAPI document: 29.8.8
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.affiliate.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.math.BigDecimal;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * PriceTierAffiliate
 */
@JsonPropertyOrder({
  PriceTierAffiliate.JSON_PROPERTY_FLAT_AMOUNT,
  PriceTierAffiliate.JSON_PROPERTY_FLAT_AMOUNT_DECIMAL,
  PriceTierAffiliate.JSON_PROPERTY_UNIT_AMOUNT,
  PriceTierAffiliate.JSON_PROPERTY_UNIT_AMOUNT_DECIMAL,
  PriceTierAffiliate.JSON_PROPERTY_UP_TO
})
@JsonTypeName("PriceTier_Affiliate")
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-08-27T09:54:22.092689314+07:00[Asia/Bangkok]")
public class PriceTierAffiliate {
  public static final String JSON_PROPERTY_FLAT_AMOUNT = "flatAmount";
  private Long flatAmount;

  public static final String JSON_PROPERTY_FLAT_AMOUNT_DECIMAL = "flatAmountDecimal";
  private BigDecimal flatAmountDecimal;

  public static final String JSON_PROPERTY_UNIT_AMOUNT = "unitAmount";
  private Long unitAmount;

  public static final String JSON_PROPERTY_UNIT_AMOUNT_DECIMAL = "unitAmountDecimal";
  private BigDecimal unitAmountDecimal;

  public static final String JSON_PROPERTY_UP_TO = "upTo";
  private Long upTo;

  public PriceTierAffiliate() {
  }

  public PriceTierAffiliate flatAmount(Long flatAmount) {
    
    this.flatAmount = flatAmount;
    return this;
  }

   /**
   * Get flatAmount
   * @return flatAmount
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_FLAT_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Long getFlatAmount() {
    return flatAmount;
  }


  @JsonProperty(JSON_PROPERTY_FLAT_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFlatAmount(Long flatAmount) {
    this.flatAmount = flatAmount;
  }


  public PriceTierAffiliate flatAmountDecimal(BigDecimal flatAmountDecimal) {
    
    this.flatAmountDecimal = flatAmountDecimal;
    return this;
  }

   /**
   * Get flatAmountDecimal
   * @return flatAmountDecimal
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_FLAT_AMOUNT_DECIMAL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public BigDecimal getFlatAmountDecimal() {
    return flatAmountDecimal;
  }


  @JsonProperty(JSON_PROPERTY_FLAT_AMOUNT_DECIMAL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFlatAmountDecimal(BigDecimal flatAmountDecimal) {
    this.flatAmountDecimal = flatAmountDecimal;
  }


  public PriceTierAffiliate unitAmount(Long unitAmount) {
    
    this.unitAmount = unitAmount;
    return this;
  }

   /**
   * Get unitAmount
   * @return unitAmount
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_UNIT_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Long getUnitAmount() {
    return unitAmount;
  }


  @JsonProperty(JSON_PROPERTY_UNIT_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setUnitAmount(Long unitAmount) {
    this.unitAmount = unitAmount;
  }


  public PriceTierAffiliate unitAmountDecimal(BigDecimal unitAmountDecimal) {
    
    this.unitAmountDecimal = unitAmountDecimal;
    return this;
  }

   /**
   * Get unitAmountDecimal
   * @return unitAmountDecimal
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_UNIT_AMOUNT_DECIMAL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public BigDecimal getUnitAmountDecimal() {
    return unitAmountDecimal;
  }


  @JsonProperty(JSON_PROPERTY_UNIT_AMOUNT_DECIMAL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setUnitAmountDecimal(BigDecimal unitAmountDecimal) {
    this.unitAmountDecimal = unitAmountDecimal;
  }


  public PriceTierAffiliate upTo(Long upTo) {
    
    this.upTo = upTo;
    return this;
  }

   /**
   * Get upTo
   * @return upTo
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_UP_TO)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Long getUpTo() {
    return upTo;
  }


  @JsonProperty(JSON_PROPERTY_UP_TO)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setUpTo(Long upTo) {
    this.upTo = upTo;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    PriceTierAffiliate priceTierAffiliate = (PriceTierAffiliate) o;
    return Objects.equals(this.flatAmount, priceTierAffiliate.flatAmount) &&
        Objects.equals(this.flatAmountDecimal, priceTierAffiliate.flatAmountDecimal) &&
        Objects.equals(this.unitAmount, priceTierAffiliate.unitAmount) &&
        Objects.equals(this.unitAmountDecimal, priceTierAffiliate.unitAmountDecimal) &&
        Objects.equals(this.upTo, priceTierAffiliate.upTo);
  }

  @Override
  public int hashCode() {
    return Objects.hash(flatAmount, flatAmountDecimal, unitAmount, unitAmountDecimal, upTo);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class PriceTierAffiliate {\n");
    sb.append("    flatAmount: ").append(toIndentedString(flatAmount)).append("\n");
    sb.append("    flatAmountDecimal: ").append(toIndentedString(flatAmountDecimal)).append("\n");
    sb.append("    unitAmount: ").append(toIndentedString(unitAmount)).append("\n");
    sb.append("    unitAmountDecimal: ").append(toIndentedString(unitAmountDecimal)).append("\n");
    sb.append("    upTo: ").append(toIndentedString(upTo)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

