package travel.wink.sdk.affiliate.api;

import travel.wink.sdk.affiliate.invoker.ApiClient;

import travel.wink.sdk.affiliate.model.BooleanResponseAffiliate;
import travel.wink.sdk.affiliate.model.CreateSellerInventoryItemSyndicationEntryRequestAffiliate;
import travel.wink.sdk.affiliate.model.GenericErrorMessage;
import travel.wink.sdk.affiliate.model.RemoveEntryResponseAffiliate;
import travel.wink.sdk.affiliate.model.SellerInventoryItemViewAffiliate;
import travel.wink.sdk.affiliate.model.ShowSupplierUrl400Response;
import travel.wink.sdk.affiliate.model.SimpleMultimediaAffiliate;
import travel.wink.sdk.affiliate.model.UpsertSellerInventoryItemRequestAffiliate;
import travel.wink.sdk.affiliate.model.UpsertSupplierSellerInventoryItemRequestAffiliate;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.web.reactive.function.client.WebClient.ResponseSpec;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Flux;

@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-08-01T16:15:08.357577389+07:00[Asia/Bangkok]")
public class InventoryCardsApi {
    private ApiClient apiClient;

    public InventoryCardsApi() {
        this(new ApiClient());
    }

    @Autowired
    public InventoryCardsApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Create Card
     * Create a new inventory card
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>201</b> - Created
     * @param companyIdentifier Company identifier to create item for
     * @param upsertSellerInventoryItemRequestAffiliate The upsertSellerInventoryItemRequestAffiliate parameter
     * @param winkVersion The winkVersion parameter
     * @return SellerInventoryItemViewAffiliate
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec createSellerInventoryItemRequestCreation(String companyIdentifier, UpsertSellerInventoryItemRequestAffiliate upsertSellerInventoryItemRequestAffiliate, String winkVersion) throws WebClientResponseException {
        Object postBody = upsertSellerInventoryItemRequestAffiliate;
        // verify the required parameter 'companyIdentifier' is set
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling createSellerInventoryItem", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'upsertSellerInventoryItemRequestAffiliate' is set
        if (upsertSellerInventoryItemRequestAffiliate == null) {
            throw new WebClientResponseException("Missing the required parameter 'upsertSellerInventoryItemRequestAffiliate' when calling createSellerInventoryItem", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("companyIdentifier", companyIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "application/json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<SellerInventoryItemViewAffiliate> localVarReturnType = new ParameterizedTypeReference<SellerInventoryItemViewAffiliate>() {};
        return apiClient.invokeAPI("/api/company/{companyIdentifier}/inventory/item", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Create Card
     * Create a new inventory card
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>201</b> - Created
     * @param companyIdentifier Company identifier to create item for
     * @param upsertSellerInventoryItemRequestAffiliate The upsertSellerInventoryItemRequestAffiliate parameter
     * @param winkVersion The winkVersion parameter
     * @return SellerInventoryItemViewAffiliate
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<SellerInventoryItemViewAffiliate> createSellerInventoryItem(String companyIdentifier, UpsertSellerInventoryItemRequestAffiliate upsertSellerInventoryItemRequestAffiliate, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<SellerInventoryItemViewAffiliate> localVarReturnType = new ParameterizedTypeReference<SellerInventoryItemViewAffiliate>() {};
        return createSellerInventoryItemRequestCreation(companyIdentifier, upsertSellerInventoryItemRequestAffiliate, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Create Card
     * Create a new inventory card
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>201</b> - Created
     * @param companyIdentifier Company identifier to create item for
     * @param upsertSellerInventoryItemRequestAffiliate The upsertSellerInventoryItemRequestAffiliate parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;SellerInventoryItemViewAffiliate&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<SellerInventoryItemViewAffiliate>> createSellerInventoryItemWithHttpInfo(String companyIdentifier, UpsertSellerInventoryItemRequestAffiliate upsertSellerInventoryItemRequestAffiliate, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<SellerInventoryItemViewAffiliate> localVarReturnType = new ParameterizedTypeReference<SellerInventoryItemViewAffiliate>() {};
        return createSellerInventoryItemRequestCreation(companyIdentifier, upsertSellerInventoryItemRequestAffiliate, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Create Card
     * Create a new inventory card
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>201</b> - Created
     * @param companyIdentifier Company identifier to create item for
     * @param upsertSellerInventoryItemRequestAffiliate The upsertSellerInventoryItemRequestAffiliate parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec createSellerInventoryItemWithResponseSpec(String companyIdentifier, UpsertSellerInventoryItemRequestAffiliate upsertSellerInventoryItemRequestAffiliate, String winkVersion) throws WebClientResponseException {
        return createSellerInventoryItemRequestCreation(companyIdentifier, upsertSellerInventoryItemRequestAffiliate, winkVersion);
    }
    /**
     * Create Inventory Syndication Card
     * Creates a new WinkLinks card.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>201</b> - Created
     * @param companyIdentifier Company identifier to create item for
     * @param createSellerInventoryItemSyndicationEntryRequestAffiliate The createSellerInventoryItemSyndicationEntryRequestAffiliate parameter
     * @param winkVersion The winkVersion parameter
     * @return BooleanResponseAffiliate
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec createSellerInventoryItemSyndicationEntryRequestCreation(String companyIdentifier, CreateSellerInventoryItemSyndicationEntryRequestAffiliate createSellerInventoryItemSyndicationEntryRequestAffiliate, String winkVersion) throws WebClientResponseException {
        Object postBody = createSellerInventoryItemSyndicationEntryRequestAffiliate;
        // verify the required parameter 'companyIdentifier' is set
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling createSellerInventoryItemSyndicationEntry", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'createSellerInventoryItemSyndicationEntryRequestAffiliate' is set
        if (createSellerInventoryItemSyndicationEntryRequestAffiliate == null) {
            throw new WebClientResponseException("Missing the required parameter 'createSellerInventoryItemSyndicationEntryRequestAffiliate' when calling createSellerInventoryItemSyndicationEntry", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("companyIdentifier", companyIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "application/json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<BooleanResponseAffiliate> localVarReturnType = new ParameterizedTypeReference<BooleanResponseAffiliate>() {};
        return apiClient.invokeAPI("/api/company/{companyIdentifier}/inventory/item/syndication/entry", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Create Inventory Syndication Card
     * Creates a new WinkLinks card.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>201</b> - Created
     * @param companyIdentifier Company identifier to create item for
     * @param createSellerInventoryItemSyndicationEntryRequestAffiliate The createSellerInventoryItemSyndicationEntryRequestAffiliate parameter
     * @param winkVersion The winkVersion parameter
     * @return BooleanResponseAffiliate
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<BooleanResponseAffiliate> createSellerInventoryItemSyndicationEntry(String companyIdentifier, CreateSellerInventoryItemSyndicationEntryRequestAffiliate createSellerInventoryItemSyndicationEntryRequestAffiliate, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<BooleanResponseAffiliate> localVarReturnType = new ParameterizedTypeReference<BooleanResponseAffiliate>() {};
        return createSellerInventoryItemSyndicationEntryRequestCreation(companyIdentifier, createSellerInventoryItemSyndicationEntryRequestAffiliate, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Create Inventory Syndication Card
     * Creates a new WinkLinks card.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>201</b> - Created
     * @param companyIdentifier Company identifier to create item for
     * @param createSellerInventoryItemSyndicationEntryRequestAffiliate The createSellerInventoryItemSyndicationEntryRequestAffiliate parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;BooleanResponseAffiliate&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<BooleanResponseAffiliate>> createSellerInventoryItemSyndicationEntryWithHttpInfo(String companyIdentifier, CreateSellerInventoryItemSyndicationEntryRequestAffiliate createSellerInventoryItemSyndicationEntryRequestAffiliate, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<BooleanResponseAffiliate> localVarReturnType = new ParameterizedTypeReference<BooleanResponseAffiliate>() {};
        return createSellerInventoryItemSyndicationEntryRequestCreation(companyIdentifier, createSellerInventoryItemSyndicationEntryRequestAffiliate, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Create Inventory Syndication Card
     * Creates a new WinkLinks card.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>201</b> - Created
     * @param companyIdentifier Company identifier to create item for
     * @param createSellerInventoryItemSyndicationEntryRequestAffiliate The createSellerInventoryItemSyndicationEntryRequestAffiliate parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec createSellerInventoryItemSyndicationEntryWithResponseSpec(String companyIdentifier, CreateSellerInventoryItemSyndicationEntryRequestAffiliate createSellerInventoryItemSyndicationEntryRequestAffiliate, String winkVersion) throws WebClientResponseException {
        return createSellerInventoryItemSyndicationEntryRequestCreation(companyIdentifier, createSellerInventoryItemSyndicationEntryRequestAffiliate, winkVersion);
    }
    /**
     * Create Supplier Card
     * Creates a new inventory card for a supplier showing the best priced room.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>201</b> - Created
     * @param companyIdentifier Company identifier to create item for
     * @param upsertSupplierSellerInventoryItemRequestAffiliate The upsertSupplierSellerInventoryItemRequestAffiliate parameter
     * @param winkVersion The winkVersion parameter
     * @return SellerInventoryItemViewAffiliate
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec createSupplierSellerInventoryItemRequestCreation(String companyIdentifier, UpsertSupplierSellerInventoryItemRequestAffiliate upsertSupplierSellerInventoryItemRequestAffiliate, String winkVersion) throws WebClientResponseException {
        Object postBody = upsertSupplierSellerInventoryItemRequestAffiliate;
        // verify the required parameter 'companyIdentifier' is set
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling createSupplierSellerInventoryItem", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'upsertSupplierSellerInventoryItemRequestAffiliate' is set
        if (upsertSupplierSellerInventoryItemRequestAffiliate == null) {
            throw new WebClientResponseException("Missing the required parameter 'upsertSupplierSellerInventoryItemRequestAffiliate' when calling createSupplierSellerInventoryItem", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("companyIdentifier", companyIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "application/json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<SellerInventoryItemViewAffiliate> localVarReturnType = new ParameterizedTypeReference<SellerInventoryItemViewAffiliate>() {};
        return apiClient.invokeAPI("/api/company/{companyIdentifier}/inventory/item/supplier", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Create Supplier Card
     * Creates a new inventory card for a supplier showing the best priced room.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>201</b> - Created
     * @param companyIdentifier Company identifier to create item for
     * @param upsertSupplierSellerInventoryItemRequestAffiliate The upsertSupplierSellerInventoryItemRequestAffiliate parameter
     * @param winkVersion The winkVersion parameter
     * @return SellerInventoryItemViewAffiliate
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<SellerInventoryItemViewAffiliate> createSupplierSellerInventoryItem(String companyIdentifier, UpsertSupplierSellerInventoryItemRequestAffiliate upsertSupplierSellerInventoryItemRequestAffiliate, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<SellerInventoryItemViewAffiliate> localVarReturnType = new ParameterizedTypeReference<SellerInventoryItemViewAffiliate>() {};
        return createSupplierSellerInventoryItemRequestCreation(companyIdentifier, upsertSupplierSellerInventoryItemRequestAffiliate, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Create Supplier Card
     * Creates a new inventory card for a supplier showing the best priced room.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>201</b> - Created
     * @param companyIdentifier Company identifier to create item for
     * @param upsertSupplierSellerInventoryItemRequestAffiliate The upsertSupplierSellerInventoryItemRequestAffiliate parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;SellerInventoryItemViewAffiliate&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<SellerInventoryItemViewAffiliate>> createSupplierSellerInventoryItemWithHttpInfo(String companyIdentifier, UpsertSupplierSellerInventoryItemRequestAffiliate upsertSupplierSellerInventoryItemRequestAffiliate, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<SellerInventoryItemViewAffiliate> localVarReturnType = new ParameterizedTypeReference<SellerInventoryItemViewAffiliate>() {};
        return createSupplierSellerInventoryItemRequestCreation(companyIdentifier, upsertSupplierSellerInventoryItemRequestAffiliate, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Create Supplier Card
     * Creates a new inventory card for a supplier showing the best priced room.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>201</b> - Created
     * @param companyIdentifier Company identifier to create item for
     * @param upsertSupplierSellerInventoryItemRequestAffiliate The upsertSupplierSellerInventoryItemRequestAffiliate parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec createSupplierSellerInventoryItemWithResponseSpec(String companyIdentifier, UpsertSupplierSellerInventoryItemRequestAffiliate upsertSupplierSellerInventoryItemRequestAffiliate, String winkVersion) throws WebClientResponseException {
        return createSupplierSellerInventoryItemRequestCreation(companyIdentifier, upsertSupplierSellerInventoryItemRequestAffiliate, winkVersion);
    }
    /**
     * Delete Card
     * Remove a unique inventory item
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>202</b> - Accepted
     * @param companyIdentifier Company identifier to delete item from
     * @param inventoryIdentifier Delete inventory with this identifier.
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return RemoveEntryResponseAffiliate
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec removeSellerInventoryItemRequestCreation(String companyIdentifier, String inventoryIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'companyIdentifier' is set
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling removeSellerInventoryItem", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'inventoryIdentifier' is set
        if (inventoryIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'inventoryIdentifier' when calling removeSellerInventoryItem", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("companyIdentifier", companyIdentifier);
        pathParams.put("inventoryIdentifier", inventoryIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<RemoveEntryResponseAffiliate> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponseAffiliate>() {};
        return apiClient.invokeAPI("/api/company/{companyIdentifier}/inventory/item/{inventoryIdentifier}", HttpMethod.DELETE, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Delete Card
     * Remove a unique inventory item
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>202</b> - Accepted
     * @param companyIdentifier Company identifier to delete item from
     * @param inventoryIdentifier Delete inventory with this identifier.
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return RemoveEntryResponseAffiliate
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<RemoveEntryResponseAffiliate> removeSellerInventoryItem(String companyIdentifier, String inventoryIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<RemoveEntryResponseAffiliate> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponseAffiliate>() {};
        return removeSellerInventoryItemRequestCreation(companyIdentifier, inventoryIdentifier, winkVersion, accept).bodyToMono(localVarReturnType);
    }

    /**
     * Delete Card
     * Remove a unique inventory item
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>202</b> - Accepted
     * @param companyIdentifier Company identifier to delete item from
     * @param inventoryIdentifier Delete inventory with this identifier.
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseEntity&lt;RemoveEntryResponseAffiliate&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<RemoveEntryResponseAffiliate>> removeSellerInventoryItemWithHttpInfo(String companyIdentifier, String inventoryIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<RemoveEntryResponseAffiliate> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponseAffiliate>() {};
        return removeSellerInventoryItemRequestCreation(companyIdentifier, inventoryIdentifier, winkVersion, accept).toEntity(localVarReturnType);
    }

    /**
     * Delete Card
     * Remove a unique inventory item
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>202</b> - Accepted
     * @param companyIdentifier Company identifier to delete item from
     * @param inventoryIdentifier Delete inventory with this identifier.
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec removeSellerInventoryItemWithResponseSpec(String companyIdentifier, String inventoryIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        return removeSellerInventoryItemRequestCreation(companyIdentifier, inventoryIdentifier, winkVersion, accept);
    }
    /**
     * Show Card Media
     * Retrieve list of all media associated with this channel inventory identifier.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param companyIdentifier Company identifier to retrieve items for
     * @param channelInventoryIdentifier Retrieve media for this channel inventory identifier.
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return List&lt;SimpleMultimediaAffiliate&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showInventoryMedia1RequestCreation(String companyIdentifier, String channelInventoryIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'companyIdentifier' is set
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling showInventoryMedia1", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'channelInventoryIdentifier' is set
        if (channelInventoryIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'channelInventoryIdentifier' when calling showInventoryMedia1", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("companyIdentifier", companyIdentifier);
        pathParams.put("channelInventoryIdentifier", channelInventoryIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<SimpleMultimediaAffiliate> localVarReturnType = new ParameterizedTypeReference<SimpleMultimediaAffiliate>() {};
        return apiClient.invokeAPI("/api/company/{companyIdentifier}/inventory/item/inventory/{channelInventoryIdentifier}/media/list", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Card Media
     * Retrieve list of all media associated with this channel inventory identifier.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param companyIdentifier Company identifier to retrieve items for
     * @param channelInventoryIdentifier Retrieve media for this channel inventory identifier.
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return List&lt;SimpleMultimediaAffiliate&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Flux<SimpleMultimediaAffiliate> showInventoryMedia1(String companyIdentifier, String channelInventoryIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<SimpleMultimediaAffiliate> localVarReturnType = new ParameterizedTypeReference<SimpleMultimediaAffiliate>() {};
        return showInventoryMedia1RequestCreation(companyIdentifier, channelInventoryIdentifier, winkVersion, accept).bodyToFlux(localVarReturnType);
    }

    /**
     * Show Card Media
     * Retrieve list of all media associated with this channel inventory identifier.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param companyIdentifier Company identifier to retrieve items for
     * @param channelInventoryIdentifier Retrieve media for this channel inventory identifier.
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseEntity&lt;List&lt;SimpleMultimediaAffiliate&gt;&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<List<SimpleMultimediaAffiliate>>> showInventoryMedia1WithHttpInfo(String companyIdentifier, String channelInventoryIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<SimpleMultimediaAffiliate> localVarReturnType = new ParameterizedTypeReference<SimpleMultimediaAffiliate>() {};
        return showInventoryMedia1RequestCreation(companyIdentifier, channelInventoryIdentifier, winkVersion, accept).toEntityList(localVarReturnType);
    }

    /**
     * Show Card Media
     * Retrieve list of all media associated with this channel inventory identifier.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param companyIdentifier Company identifier to retrieve items for
     * @param channelInventoryIdentifier Retrieve media for this channel inventory identifier.
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec showInventoryMedia1WithResponseSpec(String companyIdentifier, String channelInventoryIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        return showInventoryMedia1RequestCreation(companyIdentifier, channelInventoryIdentifier, winkVersion, accept);
    }
    /**
     * Show Card
     * Retrieve a single inventory card.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param companyIdentifier Company identifier to retrieve item for
     * @param inventoryIdentifier Retrieve inventory with this identifier.
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return SellerInventoryItemViewAffiliate
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showSellerInventoryItemRequestCreation(String companyIdentifier, String inventoryIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'companyIdentifier' is set
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling showSellerInventoryItem", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'inventoryIdentifier' is set
        if (inventoryIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'inventoryIdentifier' when calling showSellerInventoryItem", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("companyIdentifier", companyIdentifier);
        pathParams.put("inventoryIdentifier", inventoryIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<SellerInventoryItemViewAffiliate> localVarReturnType = new ParameterizedTypeReference<SellerInventoryItemViewAffiliate>() {};
        return apiClient.invokeAPI("/api/company/{companyIdentifier}/inventory/item/{inventoryIdentifier}", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Card
     * Retrieve a single inventory card.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param companyIdentifier Company identifier to retrieve item for
     * @param inventoryIdentifier Retrieve inventory with this identifier.
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return SellerInventoryItemViewAffiliate
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<SellerInventoryItemViewAffiliate> showSellerInventoryItem(String companyIdentifier, String inventoryIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<SellerInventoryItemViewAffiliate> localVarReturnType = new ParameterizedTypeReference<SellerInventoryItemViewAffiliate>() {};
        return showSellerInventoryItemRequestCreation(companyIdentifier, inventoryIdentifier, winkVersion, accept).bodyToMono(localVarReturnType);
    }

    /**
     * Show Card
     * Retrieve a single inventory card.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param companyIdentifier Company identifier to retrieve item for
     * @param inventoryIdentifier Retrieve inventory with this identifier.
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseEntity&lt;SellerInventoryItemViewAffiliate&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<SellerInventoryItemViewAffiliate>> showSellerInventoryItemWithHttpInfo(String companyIdentifier, String inventoryIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<SellerInventoryItemViewAffiliate> localVarReturnType = new ParameterizedTypeReference<SellerInventoryItemViewAffiliate>() {};
        return showSellerInventoryItemRequestCreation(companyIdentifier, inventoryIdentifier, winkVersion, accept).toEntity(localVarReturnType);
    }

    /**
     * Show Card
     * Retrieve a single inventory card.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param companyIdentifier Company identifier to retrieve item for
     * @param inventoryIdentifier Retrieve inventory with this identifier.
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec showSellerInventoryItemWithResponseSpec(String companyIdentifier, String inventoryIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        return showSellerInventoryItemRequestCreation(companyIdentifier, inventoryIdentifier, winkVersion, accept);
    }
    /**
     * Show Inventory Cards
     * Retrieve a list of all inventory cards for company.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param companyIdentifier Company identifier to retrieve items for
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return List&lt;SellerInventoryItemViewAffiliate&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec showSellerInventoryItemsForCompanyRequestCreation(String companyIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'companyIdentifier' is set
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling showSellerInventoryItemsForCompany", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("companyIdentifier", companyIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        if (accept != null)
        headerParams.add("Accept", apiClient.parameterToString(accept));
        final String[] localVarAccepts = { 
            "application/json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<SellerInventoryItemViewAffiliate> localVarReturnType = new ParameterizedTypeReference<SellerInventoryItemViewAffiliate>() {};
        return apiClient.invokeAPI("/api/company/{companyIdentifier}/inventory/item/list", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Show Inventory Cards
     * Retrieve a list of all inventory cards for company.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param companyIdentifier Company identifier to retrieve items for
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return List&lt;SellerInventoryItemViewAffiliate&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Flux<SellerInventoryItemViewAffiliate> showSellerInventoryItemsForCompany(String companyIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<SellerInventoryItemViewAffiliate> localVarReturnType = new ParameterizedTypeReference<SellerInventoryItemViewAffiliate>() {};
        return showSellerInventoryItemsForCompanyRequestCreation(companyIdentifier, winkVersion, accept).bodyToFlux(localVarReturnType);
    }

    /**
     * Show Inventory Cards
     * Retrieve a list of all inventory cards for company.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param companyIdentifier Company identifier to retrieve items for
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseEntity&lt;List&lt;SellerInventoryItemViewAffiliate&gt;&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<List<SellerInventoryItemViewAffiliate>>> showSellerInventoryItemsForCompanyWithHttpInfo(String companyIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<SellerInventoryItemViewAffiliate> localVarReturnType = new ParameterizedTypeReference<SellerInventoryItemViewAffiliate>() {};
        return showSellerInventoryItemsForCompanyRequestCreation(companyIdentifier, winkVersion, accept).toEntityList(localVarReturnType);
    }

    /**
     * Show Inventory Cards
     * Retrieve a list of all inventory cards for company.
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param companyIdentifier Company identifier to retrieve items for
     * @param winkVersion The winkVersion parameter
     * @param accept The accept parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec showSellerInventoryItemsForCompanyWithResponseSpec(String companyIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        return showSellerInventoryItemsForCompanyRequestCreation(companyIdentifier, winkVersion, accept);
    }
    /**
     * Update Card
     * Update an existing card
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param companyIdentifier Company identifier to update item for
     * @param inventoryIdentifier Update inventory with this identifier.
     * @param upsertSellerInventoryItemRequestAffiliate The upsertSellerInventoryItemRequestAffiliate parameter
     * @param winkVersion The winkVersion parameter
     * @return SellerInventoryItemViewAffiliate
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec updateSellerInventoryItemRequestCreation(String companyIdentifier, String inventoryIdentifier, UpsertSellerInventoryItemRequestAffiliate upsertSellerInventoryItemRequestAffiliate, String winkVersion) throws WebClientResponseException {
        Object postBody = upsertSellerInventoryItemRequestAffiliate;
        // verify the required parameter 'companyIdentifier' is set
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling updateSellerInventoryItem", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'inventoryIdentifier' is set
        if (inventoryIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'inventoryIdentifier' when calling updateSellerInventoryItem", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'upsertSellerInventoryItemRequestAffiliate' is set
        if (upsertSellerInventoryItemRequestAffiliate == null) {
            throw new WebClientResponseException("Missing the required parameter 'upsertSellerInventoryItemRequestAffiliate' when calling updateSellerInventoryItem", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("companyIdentifier", companyIdentifier);
        pathParams.put("inventoryIdentifier", inventoryIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "application/json", "application/xml", "text/xml", "text/plain", "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<SellerInventoryItemViewAffiliate> localVarReturnType = new ParameterizedTypeReference<SellerInventoryItemViewAffiliate>() {};
        return apiClient.invokeAPI("/api/company/{companyIdentifier}/inventory/item/{inventoryIdentifier}", HttpMethod.PUT, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Update Card
     * Update an existing card
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param companyIdentifier Company identifier to update item for
     * @param inventoryIdentifier Update inventory with this identifier.
     * @param upsertSellerInventoryItemRequestAffiliate The upsertSellerInventoryItemRequestAffiliate parameter
     * @param winkVersion The winkVersion parameter
     * @return SellerInventoryItemViewAffiliate
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<SellerInventoryItemViewAffiliate> updateSellerInventoryItem(String companyIdentifier, String inventoryIdentifier, UpsertSellerInventoryItemRequestAffiliate upsertSellerInventoryItemRequestAffiliate, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<SellerInventoryItemViewAffiliate> localVarReturnType = new ParameterizedTypeReference<SellerInventoryItemViewAffiliate>() {};
        return updateSellerInventoryItemRequestCreation(companyIdentifier, inventoryIdentifier, upsertSellerInventoryItemRequestAffiliate, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Update Card
     * Update an existing card
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param companyIdentifier Company identifier to update item for
     * @param inventoryIdentifier Update inventory with this identifier.
     * @param upsertSellerInventoryItemRequestAffiliate The upsertSellerInventoryItemRequestAffiliate parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;SellerInventoryItemViewAffiliate&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<SellerInventoryItemViewAffiliate>> updateSellerInventoryItemWithHttpInfo(String companyIdentifier, String inventoryIdentifier, UpsertSellerInventoryItemRequestAffiliate upsertSellerInventoryItemRequestAffiliate, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<SellerInventoryItemViewAffiliate> localVarReturnType = new ParameterizedTypeReference<SellerInventoryItemViewAffiliate>() {};
        return updateSellerInventoryItemRequestCreation(companyIdentifier, inventoryIdentifier, upsertSellerInventoryItemRequestAffiliate, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Update Card
     * Update an existing card
     * <p><b>500</b> - Internal Server Error
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>200</b> - OK
     * @param companyIdentifier Company identifier to update item for
     * @param inventoryIdentifier Update inventory with this identifier.
     * @param upsertSellerInventoryItemRequestAffiliate The upsertSellerInventoryItemRequestAffiliate parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec updateSellerInventoryItemWithResponseSpec(String companyIdentifier, String inventoryIdentifier, UpsertSellerInventoryItemRequestAffiliate upsertSellerInventoryItemRequestAffiliate, String winkVersion) throws WebClientResponseException {
        return updateSellerInventoryItemRequestCreation(companyIdentifier, inventoryIdentifier, upsertSellerInventoryItemRequestAffiliate, winkVersion);
    }
}
