/*
 * Wink API
 * ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Affiliate](/affiliate): All APIs related to selling travel inventory as an affiliate. - [Analytics](/analytics): All APIs related to tracking metrics across a wide variety of data source segments including, more entertaining, leaderboard metrics. - [Booking](/booking): All APIs related to creating platform bookings. - [Channel Manager](/channel-manager): All APIs related to channel managers who want to integrate with our platform. - [Extranet](/extranet): All APIs related to managing travel inventory and suppliers. - [Inventory](/inventory): All APIs related to retrieve known travel inventory as it was found using the Lookup API.. - [Lookup](/lookup): All APIs related to locating inventory by region, locale and property flags. - [Reference](/reference): All APIs related to retrieving platform-supported taxonomies. - [TripPay](/payment): All APIs related to TripPay account management, booking, mapping and integration features.  ## SDKs We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).  - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)  ## Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Wink-Version` header. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints.  ## Release history - Follow updates on Github: https://github.com/wink-travel/wink-sdk-java/blob/master/CHANGELOG.md  # Affiliate API Welcome to the Affiliate API - A programmer-friendly way to search for and display bespoke travel inventory for your audience. Use this API to help you prepare travel inventory for sale.  # Intended Audience Programmers are a requirement to start integrating with wink. You will benefit from an API integration if you are new or existing travel related company that want easy access to great inventory.## Examples: - Hotel brands / chains that want to make their own booking engine - Travel tech companies that want to create the next hot mobile travel app - Destination sites that want to make their own booking engine - Bloggers and influencers who want to sell travel inventory to their audience - OTAs that want access direct relationships with suppliers and better quality hotel inventory
 *
 * The version of the OpenAPI document: 30.2.0
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.affiliate.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * CreateCompanyRequestAffiliate
 */
@JsonPropertyOrder({
  CreateCompanyRequestAffiliate.JSON_PROPERTY_NAME,
  CreateCompanyRequestAffiliate.JSON_PROPERTY_LEGAL_NAME,
  CreateCompanyRequestAffiliate.JSON_PROPERTY_COMPANY_TYPE,
  CreateCompanyRequestAffiliate.JSON_PROPERTY_TYPE,
  CreateCompanyRequestAffiliate.JSON_PROPERTY_VAT_I_D,
  CreateCompanyRequestAffiliate.JSON_PROPERTY_DESCRIPTION,
  CreateCompanyRequestAffiliate.JSON_PROPERTY_URL,
  CreateCompanyRequestAffiliate.JSON_PROPERTY_CITY_GEO_NAME_ID,
  CreateCompanyRequestAffiliate.JSON_PROPERTY_URLS,
  CreateCompanyRequestAffiliate.JSON_PROPERTY_TRAVEL_AGENT
})
@JsonTypeName("CreateCompanyRequest_Affiliate")
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-08-01T16:15:08.357577389+07:00[Asia/Bangkok]")
public class CreateCompanyRequestAffiliate {
  public static final String JSON_PROPERTY_NAME = "name";
  private String name;

  public static final String JSON_PROPERTY_LEGAL_NAME = "legalName";
  private String legalName;

  /**
   * Type of company
   */
  public enum CompanyTypeEnum {
    COMPANY("COMPANY"),
    
    INDIVIDUAL("INDIVIDUAL");

    private String value;

    CompanyTypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static CompanyTypeEnum fromValue(String value) {
      for (CompanyTypeEnum b : CompanyTypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_COMPANY_TYPE = "companyType";
  private CompanyTypeEnum companyType;

  /**
   * Type of company
   */
  public enum TypeEnum {
    DIRECT("DIRECT"),
    
    APPLICATION("APPLICATION"),
    
    HOTEL("HOTEL"),
    
    TRAVELIKO("TRAVELIKO"),
    
    CORPORATE("CORPORATE"),
    
    TRAVEL_AGENT("TRAVEL_AGENT"),
    
    INFLUENCER("INFLUENCER"),
    
    BLOGGER("BLOGGER"),
    
    DESTINATION("DESTINATION"),
    
    CHANNEL_MANAGER("CHANNEL_MANAGER"),
    
    PROPERTY_MANAGEMENT_SYSTEM("PROPERTY_MANAGEMENT_SYSTEM"),
    
    CENTRAL_RESERVATION_SYSTEM("CENTRAL_RESERVATION_SYSTEM"),
    
    GOOGLE_HOTEL_API("GOOGLE_HOTEL_API"),
    
    MANAGEMENT_COMPANY("MANAGEMENT_COMPANY"),
    
    CHAIN("CHAIN"),
    
    BRAND("BRAND"),
    
    EVENT_ORGANIZER("EVENT_ORGANIZER");

    private String value;

    TypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static TypeEnum fromValue(String value) {
      for (TypeEnum b : TypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_TYPE = "type";
  private TypeEnum type;

  public static final String JSON_PROPERTY_VAT_I_D = "vatID";
  private String vatID;

  public static final String JSON_PROPERTY_DESCRIPTION = "description";
  private String description;

  public static final String JSON_PROPERTY_URL = "url";
  private String url;

  public static final String JSON_PROPERTY_CITY_GEO_NAME_ID = "cityGeoNameId";
  private String cityGeoNameId;

  public static final String JSON_PROPERTY_URLS = "urls";
  private List<String> urls;

  public static final String JSON_PROPERTY_TRAVEL_AGENT = "travelAgent";
  private Object travelAgent;

  public CreateCompanyRequestAffiliate() {
  }

  public CreateCompanyRequestAffiliate name(String name) {
    
    this.name = name;
    return this;
  }

   /**
   * Name of company
   * @return name
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getName() {
    return name;
  }


  @JsonProperty(JSON_PROPERTY_NAME)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setName(String name) {
    this.name = name;
  }


  public CreateCompanyRequestAffiliate legalName(String legalName) {
    
    this.legalName = legalName;
    return this;
  }

   /**
   * Legal name of entity if other than name
   * @return legalName
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_LEGAL_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getLegalName() {
    return legalName;
  }


  @JsonProperty(JSON_PROPERTY_LEGAL_NAME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLegalName(String legalName) {
    this.legalName = legalName;
  }


  public CreateCompanyRequestAffiliate companyType(CompanyTypeEnum companyType) {
    
    this.companyType = companyType;
    return this;
  }

   /**
   * Type of company
   * @return companyType
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_COMPANY_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public CompanyTypeEnum getCompanyType() {
    return companyType;
  }


  @JsonProperty(JSON_PROPERTY_COMPANY_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setCompanyType(CompanyTypeEnum companyType) {
    this.companyType = companyType;
  }


  public CreateCompanyRequestAffiliate type(TypeEnum type) {
    
    this.type = type;
    return this;
  }

   /**
   * Type of company
   * @return type
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public TypeEnum getType() {
    return type;
  }


  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setType(TypeEnum type) {
    this.type = type;
  }


  public CreateCompanyRequestAffiliate vatID(String vatID) {
    
    this.vatID = vatID;
    return this;
  }

   /**
   * A VAT id if required
   * @return vatID
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_VAT_I_D)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getVatID() {
    return vatID;
  }


  @JsonProperty(JSON_PROPERTY_VAT_I_D)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setVatID(String vatID) {
    this.vatID = vatID;
  }


  public CreateCompanyRequestAffiliate description(String description) {
    
    this.description = description;
    return this;
  }

   /**
   * A personal message from the company.
   * @return description
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_DESCRIPTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getDescription() {
    return description;
  }


  @JsonProperty(JSON_PROPERTY_DESCRIPTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDescription(String description) {
    this.description = description;
  }


  public CreateCompanyRequestAffiliate url(String url) {
    
    this.url = url;
    return this;
  }

   /**
   * Company&#39;s main website
   * @return url
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_URL)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getUrl() {
    return url;
  }


  @JsonProperty(JSON_PROPERTY_URL)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setUrl(String url) {
    this.url = url;
  }


  public CreateCompanyRequestAffiliate cityGeoNameId(String cityGeoNameId) {
    
    this.cityGeoNameId = cityGeoNameId;
    return this;
  }

   /**
   * City geo name ID
   * @return cityGeoNameId
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_CITY_GEO_NAME_ID)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getCityGeoNameId() {
    return cityGeoNameId;
  }


  @JsonProperty(JSON_PROPERTY_CITY_GEO_NAME_ID)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setCityGeoNameId(String cityGeoNameId) {
    this.cityGeoNameId = cityGeoNameId;
  }


  public CreateCompanyRequestAffiliate urls(List<String> urls) {
    
    this.urls = urls;
    return this;
  }

  public CreateCompanyRequestAffiliate addUrlsItem(String urlsItem) {
    if (this.urls == null) {
      this.urls = new ArrayList<>();
    }
    this.urls.add(urlsItem);
    return this;
  }

   /**
   * List of all active accounts that could be used for selling or seeing a company&#39;s reach.
   * @return urls
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_URLS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<String> getUrls() {
    return urls;
  }


  @JsonProperty(JSON_PROPERTY_URLS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setUrls(List<String> urls) {
    this.urls = urls;
  }


  public CreateCompanyRequestAffiliate travelAgent(Object travelAgent) {
    
    this.travelAgent = travelAgent;
    return this;
  }

   /**
   * If the company type is travel agent, this object will be filled out too.
   * @return travelAgent
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_TRAVEL_AGENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Object getTravelAgent() {
    return travelAgent;
  }


  @JsonProperty(JSON_PROPERTY_TRAVEL_AGENT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTravelAgent(Object travelAgent) {
    this.travelAgent = travelAgent;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    CreateCompanyRequestAffiliate createCompanyRequestAffiliate = (CreateCompanyRequestAffiliate) o;
    return Objects.equals(this.name, createCompanyRequestAffiliate.name) &&
        Objects.equals(this.legalName, createCompanyRequestAffiliate.legalName) &&
        Objects.equals(this.companyType, createCompanyRequestAffiliate.companyType) &&
        Objects.equals(this.type, createCompanyRequestAffiliate.type) &&
        Objects.equals(this.vatID, createCompanyRequestAffiliate.vatID) &&
        Objects.equals(this.description, createCompanyRequestAffiliate.description) &&
        Objects.equals(this.url, createCompanyRequestAffiliate.url) &&
        Objects.equals(this.cityGeoNameId, createCompanyRequestAffiliate.cityGeoNameId) &&
        Objects.equals(this.urls, createCompanyRequestAffiliate.urls) &&
        Objects.equals(this.travelAgent, createCompanyRequestAffiliate.travelAgent);
  }

  @Override
  public int hashCode() {
    return Objects.hash(name, legalName, companyType, type, vatID, description, url, cityGeoNameId, urls, travelAgent);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class CreateCompanyRequestAffiliate {\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    legalName: ").append(toIndentedString(legalName)).append("\n");
    sb.append("    companyType: ").append(toIndentedString(companyType)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    vatID: ").append(toIndentedString(vatID)).append("\n");
    sb.append("    description: ").append(toIndentedString(description)).append("\n");
    sb.append("    url: ").append(toIndentedString(url)).append("\n");
    sb.append("    cityGeoNameId: ").append(toIndentedString(cityGeoNameId)).append("\n");
    sb.append("    urls: ").append(toIndentedString(urls)).append("\n");
    sb.append("    travelAgent: ").append(toIndentedString(travelAgent)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

