/*
 * Wink API
 * ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Affiliate](/affiliate): All APIs related to selling travel inventory as an affiliate. - [Analytics](/analytics): All APIs related to tracking metrics across a wide variety of data source segments including, more entertaining, leaderboard metrics. - [Booking](/booking): All APIs related to creating platform bookings. - [Channel Manager](/channel-manager): All APIs related to channel managers who want to integrate with our platform. - [Extranet](/extranet): All APIs related to managing travel inventory and suppliers. - [Inventory](/inventory): All APIs related to retrieve known travel inventory as it was found using the Lookup API.. - [Lookup](/lookup): All APIs related to locating inventory by region, locale and property flags. - [Reference](/reference): All APIs related to retrieving platform-supported taxonomies. - [TripPay](/payment): All APIs related to TripPay account management, booking, mapping and integration features.  ## SDKs We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).  - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)  ## Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Wink-Version` header. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints.  ## Release history - Follow updates on Github: https://github.com/wink-travel/wink-sdk-java/blob/master/CHANGELOG.md  # Affiliate API Welcome to the Affiliate API - A programmer-friendly way to search for and display bespoke travel inventory for your audience. Use this API to help you prepare travel inventory for sale.  # Intended Audience Programmers are a requirement to start integrating with wink. You will benefit from an API integration if you are new or existing travel related company that want easy access to great inventory.## Examples: - Hotel brands / chains that want to make their own booking engine - Travel tech companies that want to create the next hot mobile travel app - Destination sites that want to make their own booking engine - Bloggers and influencers who want to sell travel inventory to their audience - OTAs that want access direct relationships with suppliers and better quality hotel inventory
 *
 * The version of the OpenAPI document: 30.2.0
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.affiliate.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.time.OffsetDateTime;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import travel.wink.sdk.affiliate.model.AddressAffiliate;
import travel.wink.sdk.affiliate.model.GeoJsonPointAffiliate;
import travel.wink.sdk.affiliate.model.GeoNameAffiliate;
import travel.wink.sdk.affiliate.model.KeyValuePairAffiliate;
import travel.wink.sdk.affiliate.model.SimpleAddressAffiliate;
import travel.wink.sdk.affiliate.model.SimpleMultimediaAffiliate;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * SupplierLeadAffiliate
 */
@JsonPropertyOrder({
  SupplierLeadAffiliate.JSON_PROPERTY_ID,
  SupplierLeadAffiliate.JSON_PROPERTY_CREATED_DATE,
  SupplierLeadAffiliate.JSON_PROPERTY_LAST_UPDATE,
  SupplierLeadAffiliate.JSON_PROPERTY_VERSION,
  SupplierLeadAffiliate.JSON_PROPERTY_USER,
  SupplierLeadAffiliate.JSON_PROPERTY_OWNER,
  SupplierLeadAffiliate.JSON_PROPERTY_STATUS,
  SupplierLeadAffiliate.JSON_PROPERTY_PLACE_ID,
  SupplierLeadAffiliate.JSON_PROPERTY_NAME_IN_ENGLISH,
  SupplierLeadAffiliate.JSON_PROPERTY_NAME_IN_LOCAL_LANGUAGE,
  SupplierLeadAffiliate.JSON_PROPERTY_GOOGLE_MAPS_URL,
  SupplierLeadAffiliate.JSON_PROPERTY_PHONE,
  SupplierLeadAffiliate.JSON_PROPERTY_ADDRESS,
  SupplierLeadAffiliate.JSON_PROPERTY_ADDRESS_LOCAL,
  SupplierLeadAffiliate.JSON_PROPERTY_FORMATTED_ADDRESS,
  SupplierLeadAffiliate.JSON_PROPERTY_FORMATTED_ADDRESS_LOCAL,
  SupplierLeadAffiliate.JSON_PROPERTY_HTML_ADDRESS,
  SupplierLeadAffiliate.JSON_PROPERTY_HTML_ADDRESS_LOCAL,
  SupplierLeadAffiliate.JSON_PROPERTY_LOCATION,
  SupplierLeadAffiliate.JSON_PROPERTY_PHOTOS,
  SupplierLeadAffiliate.JSON_PROPERTY_RATING,
  SupplierLeadAffiliate.JSON_PROPERTY_USER_RATING_TOTAL,
  SupplierLeadAffiliate.JSON_PROPERTY_UTC_OFFSET_MINUTES,
  SupplierLeadAffiliate.JSON_PROPERTY_WEBSITE,
  SupplierLeadAffiliate.JSON_PROPERTY_MESSAGE_FROM_USER,
  SupplierLeadAffiliate.JSON_PROPERTY_CITY_OPTIONS
})
@JsonTypeName("SupplierLead_Affiliate")
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-08-01T16:15:08.357577389+07:00[Asia/Bangkok]")
public class SupplierLeadAffiliate {
  public static final String JSON_PROPERTY_ID = "id";
  private String id;

  public static final String JSON_PROPERTY_CREATED_DATE = "createdDate";
  private java.time.LocalDateTime createdDate;

  public static final String JSON_PROPERTY_LAST_UPDATE = "lastUpdate";
  private java.time.LocalDateTime lastUpdate;

  public static final String JSON_PROPERTY_VERSION = "version";
  private Long version;

  public static final String JSON_PROPERTY_USER = "user";
  private KeyValuePairAffiliate user;

  public static final String JSON_PROPERTY_OWNER = "owner";
  private KeyValuePairAffiliate owner;

  /**
   * Lead status
   */
  public enum StatusEnum {
    CREATED("CREATED"),
    
    IN_PROGRESS("IN_PROGRESS"),
    
    INVITED("INVITED"),
    
    CLAIMED("CLAIMED"),
    
    REJECTED("REJECTED"),
    
    INACTIVE("INACTIVE");

    private String value;

    StatusEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static StatusEnum fromValue(String value) {
      for (StatusEnum b : StatusEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_STATUS = "status";
  private StatusEnum status;

  public static final String JSON_PROPERTY_PLACE_ID = "placeId";
  private String placeId;

  public static final String JSON_PROPERTY_NAME_IN_ENGLISH = "nameInEnglish";
  private String nameInEnglish;

  public static final String JSON_PROPERTY_NAME_IN_LOCAL_LANGUAGE = "nameInLocalLanguage";
  private String nameInLocalLanguage;

  public static final String JSON_PROPERTY_GOOGLE_MAPS_URL = "googleMapsUrl";
  private String googleMapsUrl;

  public static final String JSON_PROPERTY_PHONE = "phone";
  private String phone;

  public static final String JSON_PROPERTY_ADDRESS = "address";
  private AddressAffiliate address;

  public static final String JSON_PROPERTY_ADDRESS_LOCAL = "addressLocal";
  private SimpleAddressAffiliate addressLocal;

  public static final String JSON_PROPERTY_FORMATTED_ADDRESS = "formattedAddress";
  private String formattedAddress;

  public static final String JSON_PROPERTY_FORMATTED_ADDRESS_LOCAL = "formattedAddressLocal";
  private String formattedAddressLocal;

  public static final String JSON_PROPERTY_HTML_ADDRESS = "htmlAddress";
  private String htmlAddress;

  public static final String JSON_PROPERTY_HTML_ADDRESS_LOCAL = "htmlAddressLocal";
  private String htmlAddressLocal;

  public static final String JSON_PROPERTY_LOCATION = "location";
  private GeoJsonPointAffiliate location;

  public static final String JSON_PROPERTY_PHOTOS = "photos";
  private List<SimpleMultimediaAffiliate> photos;

  public static final String JSON_PROPERTY_RATING = "rating";
  private Float rating;

  public static final String JSON_PROPERTY_USER_RATING_TOTAL = "userRatingTotal";
  private Integer userRatingTotal;

  public static final String JSON_PROPERTY_UTC_OFFSET_MINUTES = "utcOffsetMinutes";
  private Integer utcOffsetMinutes;

  public static final String JSON_PROPERTY_WEBSITE = "website";
  private String website;

  public static final String JSON_PROPERTY_MESSAGE_FROM_USER = "messageFromUser";
  private String messageFromUser;

  public static final String JSON_PROPERTY_CITY_OPTIONS = "cityOptions";
  private List<GeoNameAffiliate> cityOptions;

  public SupplierLeadAffiliate() {
  }

  public SupplierLeadAffiliate id(String id) {
    
    this.id = id;
    return this;
  }

   /**
   * Document UUID
   * @return id
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getId() {
    return id;
  }


  @JsonProperty(JSON_PROPERTY_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setId(String id) {
    this.id = id;
  }


  public SupplierLeadAffiliate createdDate(java.time.LocalDateTime createdDate) {
    
    this.createdDate = createdDate;
    return this;
  }

   /**
   * Datetime this record was first created
   * @return createdDate
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_CREATED_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public java.time.LocalDateTime getCreatedDate() {
    return createdDate;
  }


  @JsonProperty(JSON_PROPERTY_CREATED_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCreatedDate(java.time.LocalDateTime createdDate) {
    this.createdDate = createdDate;
  }


  public SupplierLeadAffiliate lastUpdate(java.time.LocalDateTime lastUpdate) {
    
    this.lastUpdate = lastUpdate;
    return this;
  }

   /**
   * Datetime this record was last updated
   * @return lastUpdate
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_LAST_UPDATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public java.time.LocalDateTime getLastUpdate() {
    return lastUpdate;
  }


  @JsonProperty(JSON_PROPERTY_LAST_UPDATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLastUpdate(java.time.LocalDateTime lastUpdate) {
    this.lastUpdate = lastUpdate;
  }


  public SupplierLeadAffiliate version(Long version) {
    
    this.version = version;
    return this;
  }

   /**
   * Version property that shows how many times this document has been persisted. Document will not persist if the version property is less than current version property in the system. Result in an optimistic locking exception.
   * @return version
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_VERSION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Long getVersion() {
    return version;
  }


  @JsonProperty(JSON_PROPERTY_VERSION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setVersion(Long version) {
    this.version = version;
  }


  public SupplierLeadAffiliate user(KeyValuePairAffiliate user) {
    
    this.user = user;
    return this;
  }

   /**
   * Get user
   * @return user
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_USER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public KeyValuePairAffiliate getUser() {
    return user;
  }


  @JsonProperty(JSON_PROPERTY_USER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setUser(KeyValuePairAffiliate user) {
    this.user = user;
  }


  public SupplierLeadAffiliate owner(KeyValuePairAffiliate owner) {
    
    this.owner = owner;
    return this;
  }

   /**
   * Get owner
   * @return owner
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_OWNER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public KeyValuePairAffiliate getOwner() {
    return owner;
  }


  @JsonProperty(JSON_PROPERTY_OWNER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setOwner(KeyValuePairAffiliate owner) {
    this.owner = owner;
  }


  public SupplierLeadAffiliate status(StatusEnum status) {
    
    this.status = status;
    return this;
  }

   /**
   * Lead status
   * @return status
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_STATUS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public StatusEnum getStatus() {
    return status;
  }


  @JsonProperty(JSON_PROPERTY_STATUS)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setStatus(StatusEnum status) {
    this.status = status;
  }


  public SupplierLeadAffiliate placeId(String placeId) {
    
    this.placeId = placeId;
    return this;
  }

   /**
   * Unique ID
   * @return placeId
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_PLACE_ID)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getPlaceId() {
    return placeId;
  }


  @JsonProperty(JSON_PROPERTY_PLACE_ID)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setPlaceId(String placeId) {
    this.placeId = placeId;
  }


  public SupplierLeadAffiliate nameInEnglish(String nameInEnglish) {
    
    this.nameInEnglish = nameInEnglish;
    return this;
  }

   /**
   * Name of lead
   * @return nameInEnglish
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_NAME_IN_ENGLISH)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getNameInEnglish() {
    return nameInEnglish;
  }


  @JsonProperty(JSON_PROPERTY_NAME_IN_ENGLISH)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setNameInEnglish(String nameInEnglish) {
    this.nameInEnglish = nameInEnglish;
  }


  public SupplierLeadAffiliate nameInLocalLanguage(String nameInLocalLanguage) {
    
    this.nameInLocalLanguage = nameInLocalLanguage;
    return this;
  }

   /**
   * Name of lead in local language
   * @return nameInLocalLanguage
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_NAME_IN_LOCAL_LANGUAGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getNameInLocalLanguage() {
    return nameInLocalLanguage;
  }


  @JsonProperty(JSON_PROPERTY_NAME_IN_LOCAL_LANGUAGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setNameInLocalLanguage(String nameInLocalLanguage) {
    this.nameInLocalLanguage = nameInLocalLanguage;
  }


  public SupplierLeadAffiliate googleMapsUrl(String googleMapsUrl) {
    
    this.googleMapsUrl = googleMapsUrl;
    return this;
  }

   /**
   * Google Maps URL of the place
   * @return googleMapsUrl
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_GOOGLE_MAPS_URL)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getGoogleMapsUrl() {
    return googleMapsUrl;
  }


  @JsonProperty(JSON_PROPERTY_GOOGLE_MAPS_URL)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setGoogleMapsUrl(String googleMapsUrl) {
    this.googleMapsUrl = googleMapsUrl;
  }


  public SupplierLeadAffiliate phone(String phone) {
    
    this.phone = phone;
    return this;
  }

   /**
   * Telephone of lead
   * @return phone
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_PHONE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getPhone() {
    return phone;
  }


  @JsonProperty(JSON_PROPERTY_PHONE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPhone(String phone) {
    this.phone = phone;
  }


  public SupplierLeadAffiliate address(AddressAffiliate address) {
    
    this.address = address;
    return this;
  }

   /**
   * Get address
   * @return address
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_ADDRESS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public AddressAffiliate getAddress() {
    return address;
  }


  @JsonProperty(JSON_PROPERTY_ADDRESS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAddress(AddressAffiliate address) {
    this.address = address;
  }


  public SupplierLeadAffiliate addressLocal(SimpleAddressAffiliate addressLocal) {
    
    this.addressLocal = addressLocal;
    return this;
  }

   /**
   * Get addressLocal
   * @return addressLocal
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_ADDRESS_LOCAL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public SimpleAddressAffiliate getAddressLocal() {
    return addressLocal;
  }


  @JsonProperty(JSON_PROPERTY_ADDRESS_LOCAL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAddressLocal(SimpleAddressAffiliate addressLocal) {
    this.addressLocal = addressLocal;
  }


  public SupplierLeadAffiliate formattedAddress(String formattedAddress) {
    
    this.formattedAddress = formattedAddress;
    return this;
  }

   /**
   * Formatted address in English
   * @return formattedAddress
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_FORMATTED_ADDRESS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getFormattedAddress() {
    return formattedAddress;
  }


  @JsonProperty(JSON_PROPERTY_FORMATTED_ADDRESS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFormattedAddress(String formattedAddress) {
    this.formattedAddress = formattedAddress;
  }


  public SupplierLeadAffiliate formattedAddressLocal(String formattedAddressLocal) {
    
    this.formattedAddressLocal = formattedAddressLocal;
    return this;
  }

   /**
   * Formatted address in local language if available
   * @return formattedAddressLocal
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_FORMATTED_ADDRESS_LOCAL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getFormattedAddressLocal() {
    return formattedAddressLocal;
  }


  @JsonProperty(JSON_PROPERTY_FORMATTED_ADDRESS_LOCAL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFormattedAddressLocal(String formattedAddressLocal) {
    this.formattedAddressLocal = formattedAddressLocal;
  }


  public SupplierLeadAffiliate htmlAddress(String htmlAddress) {
    
    this.htmlAddress = htmlAddress;
    return this;
  }

   /**
   * Html address in English
   * @return htmlAddress
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_HTML_ADDRESS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getHtmlAddress() {
    return htmlAddress;
  }


  @JsonProperty(JSON_PROPERTY_HTML_ADDRESS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setHtmlAddress(String htmlAddress) {
    this.htmlAddress = htmlAddress;
  }


  public SupplierLeadAffiliate htmlAddressLocal(String htmlAddressLocal) {
    
    this.htmlAddressLocal = htmlAddressLocal;
    return this;
  }

   /**
   * Html address in local language if available
   * @return htmlAddressLocal
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_HTML_ADDRESS_LOCAL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getHtmlAddressLocal() {
    return htmlAddressLocal;
  }


  @JsonProperty(JSON_PROPERTY_HTML_ADDRESS_LOCAL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setHtmlAddressLocal(String htmlAddressLocal) {
    this.htmlAddressLocal = htmlAddressLocal;
  }


  public SupplierLeadAffiliate location(GeoJsonPointAffiliate location) {
    
    this.location = location;
    return this;
  }

   /**
   * Get location
   * @return location
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_LOCATION)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public GeoJsonPointAffiliate getLocation() {
    return location;
  }


  @JsonProperty(JSON_PROPERTY_LOCATION)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setLocation(GeoJsonPointAffiliate location) {
    this.location = location;
  }


  public SupplierLeadAffiliate photos(List<SimpleMultimediaAffiliate> photos) {
    
    this.photos = photos;
    return this;
  }

  public SupplierLeadAffiliate addPhotosItem(SimpleMultimediaAffiliate photosItem) {
    if (this.photos == null) {
      this.photos = new ArrayList<>();
    }
    this.photos.add(photosItem);
    return this;
  }

   /**
   * Photos for property
   * @return photos
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_PHOTOS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<SimpleMultimediaAffiliate> getPhotos() {
    return photos;
  }


  @JsonProperty(JSON_PROPERTY_PHOTOS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPhotos(List<SimpleMultimediaAffiliate> photos) {
    this.photos = photos;
  }


  public SupplierLeadAffiliate rating(Float rating) {
    
    this.rating = rating;
    return this;
  }

   /**
   * Hotel rating
   * @return rating
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_RATING)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Float getRating() {
    return rating;
  }


  @JsonProperty(JSON_PROPERTY_RATING)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRating(Float rating) {
    this.rating = rating;
  }


  public SupplierLeadAffiliate userRatingTotal(Integer userRatingTotal) {
    
    this.userRatingTotal = userRatingTotal;
    return this;
  }

   /**
   * Total umber of user ratings
   * @return userRatingTotal
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_USER_RATING_TOTAL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getUserRatingTotal() {
    return userRatingTotal;
  }


  @JsonProperty(JSON_PROPERTY_USER_RATING_TOTAL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setUserRatingTotal(Integer userRatingTotal) {
    this.userRatingTotal = userRatingTotal;
  }


  public SupplierLeadAffiliate utcOffsetMinutes(Integer utcOffsetMinutes) {
    
    this.utcOffsetMinutes = utcOffsetMinutes;
    return this;
  }

   /**
   * UTC offset minutes
   * @return utcOffsetMinutes
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_UTC_OFFSET_MINUTES)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Integer getUtcOffsetMinutes() {
    return utcOffsetMinutes;
  }


  @JsonProperty(JSON_PROPERTY_UTC_OFFSET_MINUTES)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setUtcOffsetMinutes(Integer utcOffsetMinutes) {
    this.utcOffsetMinutes = utcOffsetMinutes;
  }


  public SupplierLeadAffiliate website(String website) {
    
    this.website = website;
    return this;
  }

   /**
   * Website
   * @return website
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_WEBSITE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getWebsite() {
    return website;
  }


  @JsonProperty(JSON_PROPERTY_WEBSITE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setWebsite(String website) {
    this.website = website;
  }


  public SupplierLeadAffiliate messageFromUser(String messageFromUser) {
    
    this.messageFromUser = messageFromUser;
    return this;
  }

   /**
   * A personalized message from the inviter
   * @return messageFromUser
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_MESSAGE_FROM_USER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getMessageFromUser() {
    return messageFromUser;
  }


  @JsonProperty(JSON_PROPERTY_MESSAGE_FROM_USER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMessageFromUser(String messageFromUser) {
    this.messageFromUser = messageFromUser;
  }


  public SupplierLeadAffiliate cityOptions(List<GeoNameAffiliate> cityOptions) {
    
    this.cityOptions = cityOptions;
    return this;
  }

  public SupplierLeadAffiliate addCityOptionsItem(GeoNameAffiliate cityOptionsItem) {
    if (this.cityOptions == null) {
      this.cityOptions = new ArrayList<>();
    }
    this.cityOptions.add(cityOptionsItem);
    return this;
  }

   /**
   * Get cityOptions
   * @return cityOptions
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_CITY_OPTIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<GeoNameAffiliate> getCityOptions() {
    return cityOptions;
  }


  @JsonProperty(JSON_PROPERTY_CITY_OPTIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCityOptions(List<GeoNameAffiliate> cityOptions) {
    this.cityOptions = cityOptions;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    SupplierLeadAffiliate supplierLeadAffiliate = (SupplierLeadAffiliate) o;
    return Objects.equals(this.id, supplierLeadAffiliate.id) &&
        Objects.equals(this.createdDate, supplierLeadAffiliate.createdDate) &&
        Objects.equals(this.lastUpdate, supplierLeadAffiliate.lastUpdate) &&
        Objects.equals(this.version, supplierLeadAffiliate.version) &&
        Objects.equals(this.user, supplierLeadAffiliate.user) &&
        Objects.equals(this.owner, supplierLeadAffiliate.owner) &&
        Objects.equals(this.status, supplierLeadAffiliate.status) &&
        Objects.equals(this.placeId, supplierLeadAffiliate.placeId) &&
        Objects.equals(this.nameInEnglish, supplierLeadAffiliate.nameInEnglish) &&
        Objects.equals(this.nameInLocalLanguage, supplierLeadAffiliate.nameInLocalLanguage) &&
        Objects.equals(this.googleMapsUrl, supplierLeadAffiliate.googleMapsUrl) &&
        Objects.equals(this.phone, supplierLeadAffiliate.phone) &&
        Objects.equals(this.address, supplierLeadAffiliate.address) &&
        Objects.equals(this.addressLocal, supplierLeadAffiliate.addressLocal) &&
        Objects.equals(this.formattedAddress, supplierLeadAffiliate.formattedAddress) &&
        Objects.equals(this.formattedAddressLocal, supplierLeadAffiliate.formattedAddressLocal) &&
        Objects.equals(this.htmlAddress, supplierLeadAffiliate.htmlAddress) &&
        Objects.equals(this.htmlAddressLocal, supplierLeadAffiliate.htmlAddressLocal) &&
        Objects.equals(this.location, supplierLeadAffiliate.location) &&
        Objects.equals(this.photos, supplierLeadAffiliate.photos) &&
        Objects.equals(this.rating, supplierLeadAffiliate.rating) &&
        Objects.equals(this.userRatingTotal, supplierLeadAffiliate.userRatingTotal) &&
        Objects.equals(this.utcOffsetMinutes, supplierLeadAffiliate.utcOffsetMinutes) &&
        Objects.equals(this.website, supplierLeadAffiliate.website) &&
        Objects.equals(this.messageFromUser, supplierLeadAffiliate.messageFromUser) &&
        Objects.equals(this.cityOptions, supplierLeadAffiliate.cityOptions);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, createdDate, lastUpdate, version, user, owner, status, placeId, nameInEnglish, nameInLocalLanguage, googleMapsUrl, phone, address, addressLocal, formattedAddress, formattedAddressLocal, htmlAddress, htmlAddressLocal, location, photos, rating, userRatingTotal, utcOffsetMinutes, website, messageFromUser, cityOptions);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class SupplierLeadAffiliate {\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    createdDate: ").append(toIndentedString(createdDate)).append("\n");
    sb.append("    lastUpdate: ").append(toIndentedString(lastUpdate)).append("\n");
    sb.append("    version: ").append(toIndentedString(version)).append("\n");
    sb.append("    user: ").append(toIndentedString(user)).append("\n");
    sb.append("    owner: ").append(toIndentedString(owner)).append("\n");
    sb.append("    status: ").append(toIndentedString(status)).append("\n");
    sb.append("    placeId: ").append(toIndentedString(placeId)).append("\n");
    sb.append("    nameInEnglish: ").append(toIndentedString(nameInEnglish)).append("\n");
    sb.append("    nameInLocalLanguage: ").append(toIndentedString(nameInLocalLanguage)).append("\n");
    sb.append("    googleMapsUrl: ").append(toIndentedString(googleMapsUrl)).append("\n");
    sb.append("    phone: ").append(toIndentedString(phone)).append("\n");
    sb.append("    address: ").append(toIndentedString(address)).append("\n");
    sb.append("    addressLocal: ").append(toIndentedString(addressLocal)).append("\n");
    sb.append("    formattedAddress: ").append(toIndentedString(formattedAddress)).append("\n");
    sb.append("    formattedAddressLocal: ").append(toIndentedString(formattedAddressLocal)).append("\n");
    sb.append("    htmlAddress: ").append(toIndentedString(htmlAddress)).append("\n");
    sb.append("    htmlAddressLocal: ").append(toIndentedString(htmlAddressLocal)).append("\n");
    sb.append("    location: ").append(toIndentedString(location)).append("\n");
    sb.append("    photos: ").append(toIndentedString(photos)).append("\n");
    sb.append("    rating: ").append(toIndentedString(rating)).append("\n");
    sb.append("    userRatingTotal: ").append(toIndentedString(userRatingTotal)).append("\n");
    sb.append("    utcOffsetMinutes: ").append(toIndentedString(utcOffsetMinutes)).append("\n");
    sb.append("    website: ").append(toIndentedString(website)).append("\n");
    sb.append("    messageFromUser: ").append(toIndentedString(messageFromUser)).append("\n");
    sb.append("    cityOptions: ").append(toIndentedString(cityOptions)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

