/*
 * Wink API
 * ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Affiliate](/affiliate): All APIs related to selling travel inventory as an affiliate. - [Analytics](/analytics): All APIs related to tracking metrics across a wide variety of data source segments including, more entertaining, leaderboard metrics. - [Booking](/booking): All APIs related to creating platform bookings. - [Channel Manager](/channel-manager): All APIs related to channel managers who want to integrate with our platform. - [Extranet](/extranet): All APIs related to managing travel inventory and suppliers. - [Inventory](/inventory): All APIs related to retrieve known travel inventory as it was found using the Lookup API.. - [Lookup](/lookup): All APIs related to locating inventory by region, locale and property flags. - [Reference](/reference): All APIs related to retrieving platform-supported taxonomies. - [TripPay](/payment): All APIs related to TripPay account management, booking, mapping and integration features.  ## SDKs We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).  - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)  ## Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Wink-Version` header. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints.  ## Release history - Follow updates on Github: https://github.com/wink-travel/wink-sdk-java/blob/master/CHANGELOG.md  # Affiliate API Welcome to the Affiliate API - A programmer-friendly way to search for and display bespoke travel inventory for your audience. Use this API to help you prepare travel inventory for sale.  # Intended Audience Programmers are a requirement to start integrating with wink. You will benefit from an API integration if you are new or existing travel related company that want easy access to great inventory.## Examples: - Hotel brands / chains that want to make their own booking engine - Travel tech companies that want to create the next hot mobile travel app - Destination sites that want to make their own booking engine - Bloggers and influencers who want to sell travel inventory to their audience - OTAs that want access direct relationships with suppliers and better quality hotel inventory
 *
 * The version of the OpenAPI document: 30.2.0
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.affiliate.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import travel.wink.sdk.affiliate.model.KeyValuePairAffiliate;
import travel.wink.sdk.affiliate.model.OpenGraphMediaAffiliate;
import travel.wink.sdk.affiliate.model.SimpleMultimediaAffiliate;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * UpsertSyndicationEntryAffiliate
 */
@JsonPropertyOrder({
  UpsertSyndicationEntryAffiliate.JSON_PROPERTY_CONTENT_URL,
  UpsertSyndicationEntryAffiliate.JSON_PROPERTY_SORT,
  UpsertSyndicationEntryAffiliate.JSON_PROPERTY_TYPE,
  UpsertSyndicationEntryAffiliate.JSON_PROPERTY_IMAGE_LIST,
  UpsertSyndicationEntryAffiliate.JSON_PROPERTY_VIDEO_LIST,
  UpsertSyndicationEntryAffiliate.JSON_PROPERTY_AUDIO_LIST,
  UpsertSyndicationEntryAffiliate.JSON_PROPERTY_METADATA,
  UpsertSyndicationEntryAffiliate.JSON_PROPERTY_TITLE,
  UpsertSyndicationEntryAffiliate.JSON_PROPERTY_DESCRIPTION,
  UpsertSyndicationEntryAffiliate.JSON_PROPERTY_OG_TYPE,
  UpsertSyndicationEntryAffiliate.JSON_PROPERTY_TAGS,
  UpsertSyndicationEntryAffiliate.JSON_PROPERTY_MEDIA,
  UpsertSyndicationEntryAffiliate.JSON_PROPERTY_LOCALE
})
@JsonTypeName("UpsertSyndicationEntry_Affiliate")
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-08-01T16:15:08.357577389+07:00[Asia/Bangkok]")
public class UpsertSyndicationEntryAffiliate {
  public static final String JSON_PROPERTY_CONTENT_URL = "contentUrl";
  private String contentUrl;

  public static final String JSON_PROPERTY_SORT = "sort";
  private Integer sort;

  /**
   * The syndication entry type
   */
  public enum TypeEnum {
    WEB_LINK("WEB_LINK"),
    
    MAP("MAP"),
    
    GRID("GRID"),
    
    CARD("CARD"),
    
    FILE("FILE");

    private String value;

    TypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static TypeEnum fromValue(String value) {
      for (TypeEnum b : TypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_TYPE = "type";
  private TypeEnum type;

  public static final String JSON_PROPERTY_IMAGE_LIST = "imageList";
  private List<OpenGraphMediaAffiliate> imageList;

  public static final String JSON_PROPERTY_VIDEO_LIST = "videoList";
  private List<OpenGraphMediaAffiliate> videoList;

  public static final String JSON_PROPERTY_AUDIO_LIST = "audioList";
  private List<OpenGraphMediaAffiliate> audioList;

  public static final String JSON_PROPERTY_METADATA = "metadata";
  private List<KeyValuePairAffiliate> metadata;

  public static final String JSON_PROPERTY_TITLE = "title";
  private String title;

  public static final String JSON_PROPERTY_DESCRIPTION = "description";
  private String description;

  public static final String JSON_PROPERTY_OG_TYPE = "ogType";
  private String ogType;

  public static final String JSON_PROPERTY_TAGS = "tags";
  private List<String> tags;

  public static final String JSON_PROPERTY_MEDIA = "media";
  private SimpleMultimediaAffiliate media;

  public static final String JSON_PROPERTY_LOCALE = "locale";
  private String locale;

  public UpsertSyndicationEntryAffiliate() {
  }

  public UpsertSyndicationEntryAffiliate contentUrl(String contentUrl) {
    
    this.contentUrl = contentUrl;
    return this;
  }

   /**
   * The url of this entry
   * @return contentUrl
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_CONTENT_URL)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getContentUrl() {
    return contentUrl;
  }


  @JsonProperty(JSON_PROPERTY_CONTENT_URL)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setContentUrl(String contentUrl) {
    this.contentUrl = contentUrl;
  }


  public UpsertSyndicationEntryAffiliate sort(Integer sort) {
    
    this.sort = sort;
    return this;
  }

   /**
   * How the author wants this entry to get sorted
   * @return sort
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_SORT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Integer getSort() {
    return sort;
  }


  @JsonProperty(JSON_PROPERTY_SORT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setSort(Integer sort) {
    this.sort = sort;
  }


  public UpsertSyndicationEntryAffiliate type(TypeEnum type) {
    
    this.type = type;
    return this;
  }

   /**
   * The syndication entry type
   * @return type
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public TypeEnum getType() {
    return type;
  }


  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setType(TypeEnum type) {
    this.type = type;
  }


  public UpsertSyndicationEntryAffiliate imageList(List<OpenGraphMediaAffiliate> imageList) {
    
    this.imageList = imageList;
    return this;
  }

  public UpsertSyndicationEntryAffiliate addImageListItem(OpenGraphMediaAffiliate imageListItem) {
    if (this.imageList == null) {
      this.imageList = new ArrayList<>();
    }
    this.imageList.add(imageListItem);
    return this;
  }

   /**
   * The image list
   * @return imageList
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_IMAGE_LIST)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<OpenGraphMediaAffiliate> getImageList() {
    return imageList;
  }


  @JsonProperty(JSON_PROPERTY_IMAGE_LIST)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setImageList(List<OpenGraphMediaAffiliate> imageList) {
    this.imageList = imageList;
  }


  public UpsertSyndicationEntryAffiliate videoList(List<OpenGraphMediaAffiliate> videoList) {
    
    this.videoList = videoList;
    return this;
  }

  public UpsertSyndicationEntryAffiliate addVideoListItem(OpenGraphMediaAffiliate videoListItem) {
    if (this.videoList == null) {
      this.videoList = new ArrayList<>();
    }
    this.videoList.add(videoListItem);
    return this;
  }

   /**
   * The video list
   * @return videoList
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_VIDEO_LIST)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<OpenGraphMediaAffiliate> getVideoList() {
    return videoList;
  }


  @JsonProperty(JSON_PROPERTY_VIDEO_LIST)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setVideoList(List<OpenGraphMediaAffiliate> videoList) {
    this.videoList = videoList;
  }


  public UpsertSyndicationEntryAffiliate audioList(List<OpenGraphMediaAffiliate> audioList) {
    
    this.audioList = audioList;
    return this;
  }

  public UpsertSyndicationEntryAffiliate addAudioListItem(OpenGraphMediaAffiliate audioListItem) {
    if (this.audioList == null) {
      this.audioList = new ArrayList<>();
    }
    this.audioList.add(audioListItem);
    return this;
  }

   /**
   * The audio list
   * @return audioList
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_AUDIO_LIST)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<OpenGraphMediaAffiliate> getAudioList() {
    return audioList;
  }


  @JsonProperty(JSON_PROPERTY_AUDIO_LIST)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAudioList(List<OpenGraphMediaAffiliate> audioList) {
    this.audioList = audioList;
  }


  public UpsertSyndicationEntryAffiliate metadata(List<KeyValuePairAffiliate> metadata) {
    
    this.metadata = metadata;
    return this;
  }

  public UpsertSyndicationEntryAffiliate addMetadataItem(KeyValuePairAffiliate metadataItem) {
    if (this.metadata == null) {
      this.metadata = new ArrayList<>();
    }
    this.metadata.add(metadataItem);
    return this;
  }

   /**
   * Extended metadata
   * @return metadata
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_METADATA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<KeyValuePairAffiliate> getMetadata() {
    return metadata;
  }


  @JsonProperty(JSON_PROPERTY_METADATA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMetadata(List<KeyValuePairAffiliate> metadata) {
    this.metadata = metadata;
  }


  public UpsertSyndicationEntryAffiliate title(String title) {
    
    this.title = title;
    return this;
  }

   /**
   * The title of this entry
   * @return title
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_TITLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getTitle() {
    return title;
  }


  @JsonProperty(JSON_PROPERTY_TITLE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTitle(String title) {
    this.title = title;
  }


  public UpsertSyndicationEntryAffiliate description(String description) {
    
    this.description = description;
    return this;
  }

   /**
   * The description of this entry
   * @return description
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_DESCRIPTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getDescription() {
    return description;
  }


  @JsonProperty(JSON_PROPERTY_DESCRIPTION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDescription(String description) {
    this.description = description;
  }


  public UpsertSyndicationEntryAffiliate ogType(String ogType) {
    
    this.ogType = ogType;
    return this;
  }

   /**
   * The open graph content ogType
   * @return ogType
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_OG_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getOgType() {
    return ogType;
  }


  @JsonProperty(JSON_PROPERTY_OG_TYPE)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setOgType(String ogType) {
    this.ogType = ogType;
  }


  public UpsertSyndicationEntryAffiliate tags(List<String> tags) {
    
    this.tags = tags;
    return this;
  }

  public UpsertSyndicationEntryAffiliate addTagsItem(String tagsItem) {
    if (this.tags == null) {
      this.tags = new ArrayList<>();
    }
    this.tags.add(tagsItem);
    return this;
  }

   /**
   * Optional user categories
   * @return tags
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_TAGS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<String> getTags() {
    return tags;
  }


  @JsonProperty(JSON_PROPERTY_TAGS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTags(List<String> tags) {
    this.tags = tags;
  }


  public UpsertSyndicationEntryAffiliate media(SimpleMultimediaAffiliate media) {
    
    this.media = media;
    return this;
  }

   /**
   * Get media
   * @return media
  **/
  @jakarta.annotation.Nullable
  @Valid

  @JsonProperty(JSON_PROPERTY_MEDIA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public SimpleMultimediaAffiliate getMedia() {
    return media;
  }


  @JsonProperty(JSON_PROPERTY_MEDIA)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMedia(SimpleMultimediaAffiliate media) {
    this.media = media;
  }


  public UpsertSyndicationEntryAffiliate locale(String locale) {
    
    this.locale = locale;
    return this;
  }

   /**
   * Get locale
   * @return locale
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_LOCALE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getLocale() {
    return locale;
  }


  @JsonProperty(JSON_PROPERTY_LOCALE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLocale(String locale) {
    this.locale = locale;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    UpsertSyndicationEntryAffiliate upsertSyndicationEntryAffiliate = (UpsertSyndicationEntryAffiliate) o;
    return Objects.equals(this.contentUrl, upsertSyndicationEntryAffiliate.contentUrl) &&
        Objects.equals(this.sort, upsertSyndicationEntryAffiliate.sort) &&
        Objects.equals(this.type, upsertSyndicationEntryAffiliate.type) &&
        Objects.equals(this.imageList, upsertSyndicationEntryAffiliate.imageList) &&
        Objects.equals(this.videoList, upsertSyndicationEntryAffiliate.videoList) &&
        Objects.equals(this.audioList, upsertSyndicationEntryAffiliate.audioList) &&
        Objects.equals(this.metadata, upsertSyndicationEntryAffiliate.metadata) &&
        Objects.equals(this.title, upsertSyndicationEntryAffiliate.title) &&
        Objects.equals(this.description, upsertSyndicationEntryAffiliate.description) &&
        Objects.equals(this.ogType, upsertSyndicationEntryAffiliate.ogType) &&
        Objects.equals(this.tags, upsertSyndicationEntryAffiliate.tags) &&
        Objects.equals(this.media, upsertSyndicationEntryAffiliate.media) &&
        Objects.equals(this.locale, upsertSyndicationEntryAffiliate.locale);
  }

  @Override
  public int hashCode() {
    return Objects.hash(contentUrl, sort, type, imageList, videoList, audioList, metadata, title, description, ogType, tags, media, locale);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class UpsertSyndicationEntryAffiliate {\n");
    sb.append("    contentUrl: ").append(toIndentedString(contentUrl)).append("\n");
    sb.append("    sort: ").append(toIndentedString(sort)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    imageList: ").append(toIndentedString(imageList)).append("\n");
    sb.append("    videoList: ").append(toIndentedString(videoList)).append("\n");
    sb.append("    audioList: ").append(toIndentedString(audioList)).append("\n");
    sb.append("    metadata: ").append(toIndentedString(metadata)).append("\n");
    sb.append("    title: ").append(toIndentedString(title)).append("\n");
    sb.append("    description: ").append(toIndentedString(description)).append("\n");
    sb.append("    ogType: ").append(toIndentedString(ogType)).append("\n");
    sb.append("    tags: ").append(toIndentedString(tags)).append("\n");
    sb.append("    media: ").append(toIndentedString(media)).append("\n");
    sb.append("    locale: ").append(toIndentedString(locale)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

