/*
 * Wink API
 * ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Affiliate](/affiliate): All APIs related to selling travel inventory as an affiliate. - [Analytics](/analytics): All APIs related to tracking metrics across a wide variety of data source segments including, more entertaining, leaderboard metrics. - [Booking](/booking): All APIs related to creating platform bookings. - [Channel Manager](/channel-manager): All APIs related to channel managers who want to integrate with our platform. - [Extranet](/extranet): All APIs related to managing travel inventory and suppliers. - [Inventory](/inventory): All APIs related to retrieve known travel inventory as it was found using the Lookup API.. - [Lookup](/lookup): All APIs related to locating inventory by region, locale and property flags. - [Reference](/reference): All APIs related to retrieving platform-supported taxonomies. - [TripPay](/payment): All APIs related to TripPay account management, booking, mapping and integration features.  ## SDKs We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).  - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)  ## Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Wink-Version` header. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints.  ## Release history - Follow updates on Github: https://github.com/wink-travel/wink-sdk-java/blob/master/CHANGELOG.md  # Affiliate API Welcome to the Affiliate API - A programmer-friendly way to search for and display bespoke travel inventory for your audience. Use this API to help you prepare travel inventory for sale.  # Intended Audience Programmers are a requirement to start integrating with wink. You will benefit from an API integration if you are new or existing travel related company that want easy access to great inventory.## Examples: - Hotel brands / chains that want to make their own booking engine - Travel tech companies that want to create the next hot mobile travel app - Destination sites that want to make their own booking engine - Bloggers and influencers who want to sell travel inventory to their audience - OTAs that want access direct relationships with suppliers and better quality hotel inventory
 *
 * The version of the OpenAPI document: 30.2.0
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.affiliate.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * UpsertTravelAgentRequestAgent
 */
@JsonPropertyOrder({
  UpsertTravelAgentRequestAgent.JSON_PROPERTY_SELF_ACQUIRES,
  UpsertTravelAgentRequestAgent.JSON_PROPERTY_SELF_DISBURSES
})
@JsonTypeName("UpsertTravelAgentRequest_Agent")
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-08-01T16:15:08.357577389+07:00[Asia/Bangkok]")
public class UpsertTravelAgentRequestAgent {
  public static final String JSON_PROPERTY_SELF_ACQUIRES = "selfAcquires";
  private Boolean selfAcquires;

  public static final String JSON_PROPERTY_SELF_DISBURSES = "selfDisburses";
  private Boolean selfDisburses;

  public UpsertTravelAgentRequestAgent() {
  }

  public UpsertTravelAgentRequestAgent selfAcquires(Boolean selfAcquires) {
    
    this.selfAcquires = selfAcquires;
    return this;
  }

   /**
   * Whether the agent is in charge of charging the property.
   * @return selfAcquires
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_SELF_ACQUIRES)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Boolean getSelfAcquires() {
    return selfAcquires;
  }


  @JsonProperty(JSON_PROPERTY_SELF_ACQUIRES)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setSelfAcquires(Boolean selfAcquires) {
    this.selfAcquires = selfAcquires;
  }


  public UpsertTravelAgentRequestAgent selfDisburses(Boolean selfDisburses) {
    
    this.selfDisburses = selfDisburses;
    return this;
  }

   /**
   * Whether the agent is in charge of paying the property.
   * @return selfDisburses
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_SELF_DISBURSES)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Boolean getSelfDisburses() {
    return selfDisburses;
  }


  @JsonProperty(JSON_PROPERTY_SELF_DISBURSES)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setSelfDisburses(Boolean selfDisburses) {
    this.selfDisburses = selfDisburses;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    UpsertTravelAgentRequestAgent upsertTravelAgentRequestAgent = (UpsertTravelAgentRequestAgent) o;
    return Objects.equals(this.selfAcquires, upsertTravelAgentRequestAgent.selfAcquires) &&
        Objects.equals(this.selfDisburses, upsertTravelAgentRequestAgent.selfDisburses);
  }

  @Override
  public int hashCode() {
    return Objects.hash(selfAcquires, selfDisburses);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class UpsertTravelAgentRequestAgent {\n");
    sb.append("    selfAcquires: ").append(toIndentedString(selfAcquires)).append("\n");
    sb.append("    selfDisburses: ").append(toIndentedString(selfDisburses)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

