package travel.wink.sdk.affiliate.api;

import travel.wink.sdk.affiliate.invoker.ApiClient;

import travel.wink.sdk.affiliate.model.CompanyViewAgent;
import travel.wink.sdk.affiliate.model.GenericErrorMessage;
import travel.wink.sdk.affiliate.model.ShowSupplierUrl400Response;
import travel.wink.sdk.affiliate.model.UpsertTravelAgentRequestAgent;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.web.reactive.function.client.WebClient.ResponseSpec;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Flux;

@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-08-05T21:40:05.799522131+07:00[Asia/Bangkok]")
public class AgentApi {
    private ApiClient apiClient;

    public AgentApi() {
        this(new ApiClient());
    }

    @Autowired
    public AgentApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Update Agent
     * Update an existing agent
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - OK
     * @param companyIdentifier Update agent by company id
     * @param upsertTravelAgentRequestAgent The upsertTravelAgentRequestAgent parameter
     * @param winkVersion The winkVersion parameter
     * @return CompanyViewAgent
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec updateAgentRequestCreation(String companyIdentifier, UpsertTravelAgentRequestAgent upsertTravelAgentRequestAgent, String winkVersion) throws WebClientResponseException {
        Object postBody = upsertTravelAgentRequestAgent;
        // verify the required parameter 'companyIdentifier' is set
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling updateAgent", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'upsertTravelAgentRequestAgent' is set
        if (upsertTravelAgentRequestAgent == null) {
            throw new WebClientResponseException("Missing the required parameter 'upsertTravelAgentRequestAgent' when calling updateAgent", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("companyIdentifier", companyIdentifier);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (winkVersion != null)
        headerParams.add("Wink-Version", apiClient.parameterToString(winkVersion));
        final String[] localVarAccepts = { 
            "*/*", "application/json", "application/xml", "text/xml", "text/plain"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "oauth2ClientCredentials" };

        ParameterizedTypeReference<CompanyViewAgent> localVarReturnType = new ParameterizedTypeReference<CompanyViewAgent>() {};
        return apiClient.invokeAPI("/api/company/{companyIdentifier}/agent", HttpMethod.PATCH, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Update Agent
     * Update an existing agent
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - OK
     * @param companyIdentifier Update agent by company id
     * @param upsertTravelAgentRequestAgent The upsertTravelAgentRequestAgent parameter
     * @param winkVersion The winkVersion parameter
     * @return CompanyViewAgent
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<CompanyViewAgent> updateAgent(String companyIdentifier, UpsertTravelAgentRequestAgent upsertTravelAgentRequestAgent, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<CompanyViewAgent> localVarReturnType = new ParameterizedTypeReference<CompanyViewAgent>() {};
        return updateAgentRequestCreation(companyIdentifier, upsertTravelAgentRequestAgent, winkVersion).bodyToMono(localVarReturnType);
    }

    /**
     * Update Agent
     * Update an existing agent
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - OK
     * @param companyIdentifier Update agent by company id
     * @param upsertTravelAgentRequestAgent The upsertTravelAgentRequestAgent parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseEntity&lt;CompanyViewAgent&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<CompanyViewAgent>> updateAgentWithHttpInfo(String companyIdentifier, UpsertTravelAgentRequestAgent upsertTravelAgentRequestAgent, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<CompanyViewAgent> localVarReturnType = new ParameterizedTypeReference<CompanyViewAgent>() {};
        return updateAgentRequestCreation(companyIdentifier, upsertTravelAgentRequestAgent, winkVersion).toEntity(localVarReturnType);
    }

    /**
     * Update Agent
     * Update an existing agent
     * <p><b>403</b> - Forbidden
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - OK
     * @param companyIdentifier Update agent by company id
     * @param upsertTravelAgentRequestAgent The upsertTravelAgentRequestAgent parameter
     * @param winkVersion The winkVersion parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec updateAgentWithResponseSpec(String companyIdentifier, UpsertTravelAgentRequestAgent upsertTravelAgentRequestAgent, String winkVersion) throws WebClientResponseException {
        return updateAgentRequestCreation(companyIdentifier, upsertTravelAgentRequestAgent, winkVersion);
    }
}
