/*
 * Wink API
 * ## APIs Not every integrator needs every APIs. For that reason, we have separated APIs into context.  - [Affiliate](/affiliate): All APIs related to selling travel inventory as an affiliate. - [Analytics](/analytics): All APIs related to tracking metrics across a wide variety of data source segments including, more entertaining, leaderboard metrics. - [Booking](/booking): All APIs related to creating platform bookings. - [Channel Manager](/channel-manager): All APIs related to channel managers who want to integrate with our platform. - [Extranet](/extranet): All APIs related to managing travel inventory and suppliers. - [Inventory](/inventory): All APIs related to retrieve known travel inventory as it was found using the Lookup API.. - [Lookup](/lookup): All APIs related to locating inventory by region, locale and property flags. - [Reference](/reference): All APIs related to retrieving platform-supported taxonomies. - [TripPay](/payment): All APIs related to TripPay account management, booking, mapping and integration features.  ## SDKs We are actively working on supporting the most used languages out there. If you don't see your language here, reach out to us with a request to officially add your language. In the meantime, if you want to roll your own SDK, you can do so by downloading the OpenAPI spec and using one of the many available OpenAPI generators available: [https://openapi-generator.tech/docs/generators](https://openapi-generator.tech/docs/generators).  - Java SDK [https://github.com/wink-travel/wink-sdk-java](https://github.com/wink-travel/wink-sdk-java)  ## Usage These features are made available to you via a [REST API](https://en.wikipedia.org/wiki/Representational_state_transfer). This API is language agnostic.  ## Versioning We chose to version our endpoints in a way that we hope affects your integration with us the least. You request the version of our API you wish to work with via the `Wink-Version` header. When it's time for you to upgrade, you only have to change the version number to get access to our updated endpoints.  ## Release history - Follow updates on Github: https://github.com/wink-travel/wink-sdk-java/blob/master/CHANGELOG.md  # Affiliate API Welcome to the Affiliate API - A programmer-friendly way to search for and display bespoke travel inventory for your audience. Use this API to help you prepare travel inventory for sale.  # Intended Audience Programmers are a requirement to start integrating with wink. You will benefit from an API integration if you are new or existing travel related company that want easy access to great inventory.## Examples: - Hotel brands / chains that want to make their own booking engine - Travel tech companies that want to create the next hot mobile travel app - Destination sites that want to make their own booking engine - Bloggers and influencers who want to sell travel inventory to their audience - OTAs that want access direct relationships with suppliers and better quality hotel inventory
 *
 * The version of the OpenAPI document: 30.2.1
 * Contact: bjorn@wink.travel
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package travel.wink.sdk.affiliate.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.UUID;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import org.hibernate.validator.constraints.*;

/**
 * UpsertSyndicationSettingsAffiliate
 */
@JsonPropertyOrder({
  UpsertSyndicationSettingsAffiliate.JSON_PROPERTY_INTELLIGENT,
  UpsertSyndicationSettingsAffiliate.JSON_PROPERTY_ENGINE_CONFIGURATION_IDENTIFIER,
  UpsertSyndicationSettingsAffiliate.JSON_PROPERTY_INITIAL_DISPLAY_TYPE,
  UpsertSyndicationSettingsAffiliate.JSON_PROPERTY_PROFILE_PICTURE_GEOMETRY
})
@JsonTypeName("UpsertSyndicationSettings_Affiliate")
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-08-05T21:40:05.799522131+07:00[Asia/Bangkok]")
public class UpsertSyndicationSettingsAffiliate {
  public static final String JSON_PROPERTY_INTELLIGENT = "intelligent";
  private Boolean intelligent;

  public static final String JSON_PROPERTY_ENGINE_CONFIGURATION_IDENTIFIER = "engineConfigurationIdentifier";
  private UUID engineConfigurationIdentifier;

  /**
   * Which way to display the list when WinkLinks first loads
   */
  public enum InitialDisplayTypeEnum {
    LIST("LIST"),
    
    GRID_ROWS("GRID_ROWS"),
    
    GRID_COLUMNS("GRID_COLUMNS");

    private String value;

    InitialDisplayTypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static InitialDisplayTypeEnum fromValue(String value) {
      for (InitialDisplayTypeEnum b : InitialDisplayTypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_INITIAL_DISPLAY_TYPE = "initialDisplayType";
  private InitialDisplayTypeEnum initialDisplayType = InitialDisplayTypeEnum.GRID_COLUMNS;

  /**
   * Controls how to display profile picture
   */
  public enum ProfilePictureGeometryEnum {
    CIRCLE("CIRCLE"),
    
    RECTANGLE("RECTANGLE");

    private String value;

    ProfilePictureGeometryEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static ProfilePictureGeometryEnum fromValue(String value) {
      for (ProfilePictureGeometryEnum b : ProfilePictureGeometryEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_PROFILE_PICTURE_GEOMETRY = "profilePictureGeometry";
  private ProfilePictureGeometryEnum profilePictureGeometry = ProfilePictureGeometryEnum.CIRCLE;

  public UpsertSyndicationSettingsAffiliate() {
  }

  public UpsertSyndicationSettingsAffiliate intelligent(Boolean intelligent) {
    
    this.intelligent = intelligent;
    return this;
  }

   /**
   * Whether to treat all links as flat web links or try to embed more advanced data.
   * @return intelligent
  **/
  @jakarta.annotation.Nonnull
  @NotNull

  @JsonProperty(JSON_PROPERTY_INTELLIGENT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Boolean getIntelligent() {
    return intelligent;
  }


  @JsonProperty(JSON_PROPERTY_INTELLIGENT)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setIntelligent(Boolean intelligent) {
    this.intelligent = intelligent;
  }


  public UpsertSyndicationSettingsAffiliate engineConfigurationIdentifier(UUID engineConfigurationIdentifier) {
    
    this.engineConfigurationIdentifier = engineConfigurationIdentifier;
    return this;
  }

   /**
   * Customization identifier
   * @return engineConfigurationIdentifier
  **/
  @jakarta.annotation.Nonnull
  @NotNull
  @Valid

  @JsonProperty(JSON_PROPERTY_ENGINE_CONFIGURATION_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public UUID getEngineConfigurationIdentifier() {
    return engineConfigurationIdentifier;
  }


  @JsonProperty(JSON_PROPERTY_ENGINE_CONFIGURATION_IDENTIFIER)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setEngineConfigurationIdentifier(UUID engineConfigurationIdentifier) {
    this.engineConfigurationIdentifier = engineConfigurationIdentifier;
  }


  public UpsertSyndicationSettingsAffiliate initialDisplayType(InitialDisplayTypeEnum initialDisplayType) {
    
    this.initialDisplayType = initialDisplayType;
    return this;
  }

   /**
   * Which way to display the list when WinkLinks first loads
   * @return initialDisplayType
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_INITIAL_DISPLAY_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public InitialDisplayTypeEnum getInitialDisplayType() {
    return initialDisplayType;
  }


  @JsonProperty(JSON_PROPERTY_INITIAL_DISPLAY_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setInitialDisplayType(InitialDisplayTypeEnum initialDisplayType) {
    this.initialDisplayType = initialDisplayType;
  }


  public UpsertSyndicationSettingsAffiliate profilePictureGeometry(ProfilePictureGeometryEnum profilePictureGeometry) {
    
    this.profilePictureGeometry = profilePictureGeometry;
    return this;
  }

   /**
   * Controls how to display profile picture
   * @return profilePictureGeometry
  **/
  @jakarta.annotation.Nullable

  @JsonProperty(JSON_PROPERTY_PROFILE_PICTURE_GEOMETRY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public ProfilePictureGeometryEnum getProfilePictureGeometry() {
    return profilePictureGeometry;
  }


  @JsonProperty(JSON_PROPERTY_PROFILE_PICTURE_GEOMETRY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setProfilePictureGeometry(ProfilePictureGeometryEnum profilePictureGeometry) {
    this.profilePictureGeometry = profilePictureGeometry;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    UpsertSyndicationSettingsAffiliate upsertSyndicationSettingsAffiliate = (UpsertSyndicationSettingsAffiliate) o;
    return Objects.equals(this.intelligent, upsertSyndicationSettingsAffiliate.intelligent) &&
        Objects.equals(this.engineConfigurationIdentifier, upsertSyndicationSettingsAffiliate.engineConfigurationIdentifier) &&
        Objects.equals(this.initialDisplayType, upsertSyndicationSettingsAffiliate.initialDisplayType) &&
        Objects.equals(this.profilePictureGeometry, upsertSyndicationSettingsAffiliate.profilePictureGeometry);
  }

  @Override
  public int hashCode() {
    return Objects.hash(intelligent, engineConfigurationIdentifier, initialDisplayType, profilePictureGeometry);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class UpsertSyndicationSettingsAffiliate {\n");
    sb.append("    intelligent: ").append(toIndentedString(intelligent)).append("\n");
    sb.append("    engineConfigurationIdentifier: ").append(toIndentedString(engineConfigurationIdentifier)).append("\n");
    sb.append("    initialDisplayType: ").append(toIndentedString(initialDisplayType)).append("\n");
    sb.append("    profilePictureGeometry: ").append(toIndentedString(profilePictureGeometry)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

