/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.affiliate.api;

import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import reactor.core.publisher.Mono;
import travel.wink.sdk.affiliate.invoker.ApiClient;
import travel.wink.sdk.affiliate.model.CompanyViewAgent;
import travel.wink.sdk.affiliate.model.UpsertTravelAgentRequestAgent;

public class AgentApi {
    private ApiClient apiClient;

    public AgentApi() {
        this(new ApiClient());
    }

    @Autowired
    public AgentApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    private WebClient.ResponseSpec updateAgentRequestCreation(String companyIdentifier, UpsertTravelAgentRequestAgent upsertTravelAgentRequestAgent, String winkVersion) throws WebClientResponseException {
        UpsertTravelAgentRequestAgent postBody = upsertTravelAgentRequestAgent;
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling updateAgent", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (upsertTravelAgentRequestAgent == null) {
            throw new WebClientResponseException("Missing the required parameter 'upsertTravelAgentRequestAgent' when calling updateAgent", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("companyIdentifier", companyIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<CompanyViewAgent> localVarReturnType = new ParameterizedTypeReference<CompanyViewAgent>(this){};
        return this.apiClient.invokeAPI("/api/company/{companyIdentifier}/agent", HttpMethod.PATCH, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<CompanyViewAgent> updateAgent(String companyIdentifier, UpsertTravelAgentRequestAgent upsertTravelAgentRequestAgent, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<CompanyViewAgent> localVarReturnType = new ParameterizedTypeReference<CompanyViewAgent>(this){};
        return this.updateAgentRequestCreation(companyIdentifier, upsertTravelAgentRequestAgent, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<CompanyViewAgent>> updateAgentWithHttpInfo(String companyIdentifier, UpsertTravelAgentRequestAgent upsertTravelAgentRequestAgent, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<CompanyViewAgent> localVarReturnType = new ParameterizedTypeReference<CompanyViewAgent>(this){};
        return this.updateAgentRequestCreation(companyIdentifier, upsertTravelAgentRequestAgent, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec updateAgentWithResponseSpec(String companyIdentifier, UpsertTravelAgentRequestAgent upsertTravelAgentRequestAgent, String winkVersion) throws WebClientResponseException {
        return this.updateAgentRequestCreation(companyIdentifier, upsertTravelAgentRequestAgent, winkVersion);
    }
}

