/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.affiliate.api;

import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import reactor.core.publisher.Mono;
import travel.wink.sdk.affiliate.invoker.ApiClient;
import travel.wink.sdk.affiliate.model.BookingViewAgent;
import travel.wink.sdk.affiliate.model.BooleanResponseAgent;
import travel.wink.sdk.affiliate.model.CancellationDetailAgent;
import travel.wink.sdk.affiliate.model.PageBookingViewAgent;
import travel.wink.sdk.affiliate.model.StateAgent;

public class BookingsApi {
    private ApiClient apiClient;

    public BookingsApi() {
        this(new ApiClient());
    }

    @Autowired
    public BookingsApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    private WebClient.ResponseSpec cancelBookingAsTravelAgentRequestCreation(String companyIdentifier, String bookingIdentifier, CancellationDetailAgent cancellationDetailAgent, String winkVersion) throws WebClientResponseException {
        CancellationDetailAgent postBody = cancellationDetailAgent;
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling cancelBookingAsTravelAgent", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (bookingIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'bookingIdentifier' when calling cancelBookingAsTravelAgent", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (cancellationDetailAgent == null) {
            throw new WebClientResponseException("Missing the required parameter 'cancellationDetailAgent' when calling cancelBookingAsTravelAgent", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("companyIdentifier", companyIdentifier);
        pathParams.put("bookingIdentifier", bookingIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<BookingViewAgent> localVarReturnType = new ParameterizedTypeReference<BookingViewAgent>(this){};
        return this.apiClient.invokeAPI("/api/company/{companyIdentifier}/booking/{bookingIdentifier}", HttpMethod.PATCH, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<BookingViewAgent> cancelBookingAsTravelAgent(String companyIdentifier, String bookingIdentifier, CancellationDetailAgent cancellationDetailAgent, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<BookingViewAgent> localVarReturnType = new ParameterizedTypeReference<BookingViewAgent>(this){};
        return this.cancelBookingAsTravelAgentRequestCreation(companyIdentifier, bookingIdentifier, cancellationDetailAgent, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<BookingViewAgent>> cancelBookingAsTravelAgentWithHttpInfo(String companyIdentifier, String bookingIdentifier, CancellationDetailAgent cancellationDetailAgent, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<BookingViewAgent> localVarReturnType = new ParameterizedTypeReference<BookingViewAgent>(this){};
        return this.cancelBookingAsTravelAgentRequestCreation(companyIdentifier, bookingIdentifier, cancellationDetailAgent, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec cancelBookingAsTravelAgentWithResponseSpec(String companyIdentifier, String bookingIdentifier, CancellationDetailAgent cancellationDetailAgent, String winkVersion) throws WebClientResponseException {
        return this.cancelBookingAsTravelAgentRequestCreation(companyIdentifier, bookingIdentifier, cancellationDetailAgent, winkVersion);
    }

    private WebClient.ResponseSpec resendBookingConfirmationEmailAsTravelAgentRequestCreation(String companyIdentifier, String bookingIdentifier, Object body, String winkVersion) throws WebClientResponseException {
        Object postBody = body;
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling resendBookingConfirmationEmailAsTravelAgent", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (bookingIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'bookingIdentifier' when calling resendBookingConfirmationEmailAsTravelAgent", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (body == null) {
            throw new WebClientResponseException("Missing the required parameter 'body' when calling resendBookingConfirmationEmailAsTravelAgent", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("companyIdentifier", companyIdentifier);
        pathParams.put("bookingIdentifier", bookingIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<BooleanResponseAgent> localVarReturnType = new ParameterizedTypeReference<BooleanResponseAgent>(this){};
        return this.apiClient.invokeAPI("/api/company/{companyIdentifier}/booking/{bookingIdentifier}/resend", HttpMethod.PATCH, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<BooleanResponseAgent> resendBookingConfirmationEmailAsTravelAgent(String companyIdentifier, String bookingIdentifier, Object body, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<BooleanResponseAgent> localVarReturnType = new ParameterizedTypeReference<BooleanResponseAgent>(this){};
        return this.resendBookingConfirmationEmailAsTravelAgentRequestCreation(companyIdentifier, bookingIdentifier, body, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<BooleanResponseAgent>> resendBookingConfirmationEmailAsTravelAgentWithHttpInfo(String companyIdentifier, String bookingIdentifier, Object body, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<BooleanResponseAgent> localVarReturnType = new ParameterizedTypeReference<BooleanResponseAgent>(this){};
        return this.resendBookingConfirmationEmailAsTravelAgentRequestCreation(companyIdentifier, bookingIdentifier, body, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec resendBookingConfirmationEmailAsTravelAgentWithResponseSpec(String companyIdentifier, String bookingIdentifier, Object body, String winkVersion) throws WebClientResponseException {
        return this.resendBookingConfirmationEmailAsTravelAgentRequestCreation(companyIdentifier, bookingIdentifier, body, winkVersion);
    }

    private WebClient.ResponseSpec showBookingAsTravelAgentRequestCreation(String companyIdentifier, String bookingIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling showBookingAsTravelAgent", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (bookingIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'bookingIdentifier' when calling showBookingAsTravelAgent", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("companyIdentifier", companyIdentifier);
        pathParams.put("bookingIdentifier", bookingIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<BookingViewAgent> localVarReturnType = new ParameterizedTypeReference<BookingViewAgent>(this){};
        return this.apiClient.invokeAPI("/api/company/{companyIdentifier}/booking/{bookingIdentifier}", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<BookingViewAgent> showBookingAsTravelAgent(String companyIdentifier, String bookingIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<BookingViewAgent> localVarReturnType = new ParameterizedTypeReference<BookingViewAgent>(this){};
        return this.showBookingAsTravelAgentRequestCreation(companyIdentifier, bookingIdentifier, winkVersion, accept).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<BookingViewAgent>> showBookingAsTravelAgentWithHttpInfo(String companyIdentifier, String bookingIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<BookingViewAgent> localVarReturnType = new ParameterizedTypeReference<BookingViewAgent>(this){};
        return this.showBookingAsTravelAgentRequestCreation(companyIdentifier, bookingIdentifier, winkVersion, accept).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showBookingAsTravelAgentWithResponseSpec(String companyIdentifier, String bookingIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        return this.showBookingAsTravelAgentRequestCreation(companyIdentifier, bookingIdentifier, winkVersion, accept);
    }

    private WebClient.ResponseSpec showBookingGridAsTravelAgentRequestCreation(String companyIdentifier, StateAgent stateAgent, String winkVersion) throws WebClientResponseException {
        StateAgent postBody = stateAgent;
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling showBookingGridAsTravelAgent", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (stateAgent == null) {
            throw new WebClientResponseException("Missing the required parameter 'stateAgent' when calling showBookingGridAsTravelAgent", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("companyIdentifier", companyIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<PageBookingViewAgent> localVarReturnType = new ParameterizedTypeReference<PageBookingViewAgent>(this){};
        return this.apiClient.invokeAPI("/api/company/{companyIdentifier}/booking/grid", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<PageBookingViewAgent> showBookingGridAsTravelAgent(String companyIdentifier, StateAgent stateAgent, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<PageBookingViewAgent> localVarReturnType = new ParameterizedTypeReference<PageBookingViewAgent>(this){};
        return this.showBookingGridAsTravelAgentRequestCreation(companyIdentifier, stateAgent, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<PageBookingViewAgent>> showBookingGridAsTravelAgentWithHttpInfo(String companyIdentifier, StateAgent stateAgent, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<PageBookingViewAgent> localVarReturnType = new ParameterizedTypeReference<PageBookingViewAgent>(this){};
        return this.showBookingGridAsTravelAgentRequestCreation(companyIdentifier, stateAgent, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showBookingGridAsTravelAgentWithResponseSpec(String companyIdentifier, StateAgent stateAgent, String winkVersion) throws WebClientResponseException {
        return this.showBookingGridAsTravelAgentRequestCreation(companyIdentifier, stateAgent, winkVersion);
    }
}

