/*
 * Decompiled with CFR 0.152.
 */
package travel.wink.sdk.affiliate.api;

import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import travel.wink.sdk.affiliate.invoker.ApiClient;
import travel.wink.sdk.affiliate.model.BooleanResponseAffiliate;
import travel.wink.sdk.affiliate.model.CreateSellerUrlSyndicationEntryRequestAffiliate;
import travel.wink.sdk.affiliate.model.RemoveEntryResponseAffiliate;
import travel.wink.sdk.affiliate.model.SellerUrlViewAffiliate;
import travel.wink.sdk.affiliate.model.SimpleMultimediaAffiliate;
import travel.wink.sdk.affiliate.model.UpsertSellerUrlRequestAffiliate;

public class InventoryLinksApi {
    private ApiClient apiClient;

    public InventoryLinksApi() {
        this(new ApiClient());
    }

    @Autowired
    public InventoryLinksApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    private WebClient.ResponseSpec createSellerUrlRequestCreation(String companyIdentifier, UpsertSellerUrlRequestAffiliate upsertSellerUrlRequestAffiliate, String winkVersion) throws WebClientResponseException {
        UpsertSellerUrlRequestAffiliate postBody = upsertSellerUrlRequestAffiliate;
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling createSellerUrl", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (upsertSellerUrlRequestAffiliate == null) {
            throw new WebClientResponseException("Missing the required parameter 'upsertSellerUrlRequestAffiliate' when calling createSellerUrl", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("companyIdentifier", companyIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<SellerUrlViewAffiliate> localVarReturnType = new ParameterizedTypeReference<SellerUrlViewAffiliate>(this){};
        return this.apiClient.invokeAPI("/api/company/{companyIdentifier}/seller-url", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<SellerUrlViewAffiliate> createSellerUrl(String companyIdentifier, UpsertSellerUrlRequestAffiliate upsertSellerUrlRequestAffiliate, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<SellerUrlViewAffiliate> localVarReturnType = new ParameterizedTypeReference<SellerUrlViewAffiliate>(this){};
        return this.createSellerUrlRequestCreation(companyIdentifier, upsertSellerUrlRequestAffiliate, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<SellerUrlViewAffiliate>> createSellerUrlWithHttpInfo(String companyIdentifier, UpsertSellerUrlRequestAffiliate upsertSellerUrlRequestAffiliate, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<SellerUrlViewAffiliate> localVarReturnType = new ParameterizedTypeReference<SellerUrlViewAffiliate>(this){};
        return this.createSellerUrlRequestCreation(companyIdentifier, upsertSellerUrlRequestAffiliate, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec createSellerUrlWithResponseSpec(String companyIdentifier, UpsertSellerUrlRequestAffiliate upsertSellerUrlRequestAffiliate, String winkVersion) throws WebClientResponseException {
        return this.createSellerUrlRequestCreation(companyIdentifier, upsertSellerUrlRequestAffiliate, winkVersion);
    }

    private WebClient.ResponseSpec createSupplierUrlSyndicationEntry1RequestCreation(String companyIdentifier, CreateSellerUrlSyndicationEntryRequestAffiliate createSellerUrlSyndicationEntryRequestAffiliate, String winkVersion) throws WebClientResponseException {
        CreateSellerUrlSyndicationEntryRequestAffiliate postBody = createSellerUrlSyndicationEntryRequestAffiliate;
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling createSupplierUrlSyndicationEntry1", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (createSellerUrlSyndicationEntryRequestAffiliate == null) {
            throw new WebClientResponseException("Missing the required parameter 'createSellerUrlSyndicationEntryRequestAffiliate' when calling createSupplierUrlSyndicationEntry1", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("companyIdentifier", companyIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<BooleanResponseAffiliate> localVarReturnType = new ParameterizedTypeReference<BooleanResponseAffiliate>(this){};
        return this.apiClient.invokeAPI("/api/company/{companyIdentifier}/seller-url/syndication/entry", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<BooleanResponseAffiliate> createSupplierUrlSyndicationEntry1(String companyIdentifier, CreateSellerUrlSyndicationEntryRequestAffiliate createSellerUrlSyndicationEntryRequestAffiliate, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<BooleanResponseAffiliate> localVarReturnType = new ParameterizedTypeReference<BooleanResponseAffiliate>(this){};
        return this.createSupplierUrlSyndicationEntry1RequestCreation(companyIdentifier, createSellerUrlSyndicationEntryRequestAffiliate, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<BooleanResponseAffiliate>> createSupplierUrlSyndicationEntry1WithHttpInfo(String companyIdentifier, CreateSellerUrlSyndicationEntryRequestAffiliate createSellerUrlSyndicationEntryRequestAffiliate, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<BooleanResponseAffiliate> localVarReturnType = new ParameterizedTypeReference<BooleanResponseAffiliate>(this){};
        return this.createSupplierUrlSyndicationEntry1RequestCreation(companyIdentifier, createSellerUrlSyndicationEntryRequestAffiliate, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec createSupplierUrlSyndicationEntry1WithResponseSpec(String companyIdentifier, CreateSellerUrlSyndicationEntryRequestAffiliate createSellerUrlSyndicationEntryRequestAffiliate, String winkVersion) throws WebClientResponseException {
        return this.createSupplierUrlSyndicationEntry1RequestCreation(companyIdentifier, createSellerUrlSyndicationEntryRequestAffiliate, winkVersion);
    }

    private WebClient.ResponseSpec removeSellerUrlRequestCreation(String companyIdentifier, String sellerUrlIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling removeSellerUrl", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (sellerUrlIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'sellerUrlIdentifier' when calling removeSellerUrl", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("companyIdentifier", companyIdentifier);
        pathParams.put("sellerUrlIdentifier", sellerUrlIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<RemoveEntryResponseAffiliate> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponseAffiliate>(this){};
        return this.apiClient.invokeAPI("/api/company/{companyIdentifier}/seller-url/{sellerUrlIdentifier}", HttpMethod.DELETE, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<RemoveEntryResponseAffiliate> removeSellerUrl(String companyIdentifier, String sellerUrlIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<RemoveEntryResponseAffiliate> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponseAffiliate>(this){};
        return this.removeSellerUrlRequestCreation(companyIdentifier, sellerUrlIdentifier, winkVersion, accept).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<RemoveEntryResponseAffiliate>> removeSellerUrlWithHttpInfo(String companyIdentifier, String sellerUrlIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<RemoveEntryResponseAffiliate> localVarReturnType = new ParameterizedTypeReference<RemoveEntryResponseAffiliate>(this){};
        return this.removeSellerUrlRequestCreation(companyIdentifier, sellerUrlIdentifier, winkVersion, accept).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec removeSellerUrlWithResponseSpec(String companyIdentifier, String sellerUrlIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        return this.removeSellerUrlRequestCreation(companyIdentifier, sellerUrlIdentifier, winkVersion, accept);
    }

    private WebClient.ResponseSpec showInventoryMediaRequestCreation(String companyIdentifier, String channelInventoryIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling showInventoryMedia", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (channelInventoryIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'channelInventoryIdentifier' when calling showInventoryMedia", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("companyIdentifier", companyIdentifier);
        pathParams.put("channelInventoryIdentifier", channelInventoryIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<SimpleMultimediaAffiliate> localVarReturnType = new ParameterizedTypeReference<SimpleMultimediaAffiliate>(this){};
        return this.apiClient.invokeAPI("/api/company/{companyIdentifier}/seller-url/inventory/{channelInventoryIdentifier}/media/list", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Flux<SimpleMultimediaAffiliate> showInventoryMedia(String companyIdentifier, String channelInventoryIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<SimpleMultimediaAffiliate> localVarReturnType = new ParameterizedTypeReference<SimpleMultimediaAffiliate>(this){};
        return this.showInventoryMediaRequestCreation(companyIdentifier, channelInventoryIdentifier, winkVersion, accept).bodyToFlux((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<List<SimpleMultimediaAffiliate>>> showInventoryMediaWithHttpInfo(String companyIdentifier, String channelInventoryIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<SimpleMultimediaAffiliate> localVarReturnType = new ParameterizedTypeReference<SimpleMultimediaAffiliate>(this){};
        return this.showInventoryMediaRequestCreation(companyIdentifier, channelInventoryIdentifier, winkVersion, accept).toEntityList((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showInventoryMediaWithResponseSpec(String companyIdentifier, String channelInventoryIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        return this.showInventoryMediaRequestCreation(companyIdentifier, channelInventoryIdentifier, winkVersion, accept);
    }

    private WebClient.ResponseSpec showSellerUrlRequestCreation(String companyIdentifier, String sellerUrlIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling showSellerUrl", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (sellerUrlIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'sellerUrlIdentifier' when calling showSellerUrl", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("companyIdentifier", companyIdentifier);
        pathParams.put("sellerUrlIdentifier", sellerUrlIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<SellerUrlViewAffiliate> localVarReturnType = new ParameterizedTypeReference<SellerUrlViewAffiliate>(this){};
        return this.apiClient.invokeAPI("/api/company/{companyIdentifier}/seller-url/{sellerUrlIdentifier}", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<SellerUrlViewAffiliate> showSellerUrl(String companyIdentifier, String sellerUrlIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<SellerUrlViewAffiliate> localVarReturnType = new ParameterizedTypeReference<SellerUrlViewAffiliate>(this){};
        return this.showSellerUrlRequestCreation(companyIdentifier, sellerUrlIdentifier, winkVersion, accept).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<SellerUrlViewAffiliate>> showSellerUrlWithHttpInfo(String companyIdentifier, String sellerUrlIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<SellerUrlViewAffiliate> localVarReturnType = new ParameterizedTypeReference<SellerUrlViewAffiliate>(this){};
        return this.showSellerUrlRequestCreation(companyIdentifier, sellerUrlIdentifier, winkVersion, accept).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showSellerUrlWithResponseSpec(String companyIdentifier, String sellerUrlIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        return this.showSellerUrlRequestCreation(companyIdentifier, sellerUrlIdentifier, winkVersion, accept);
    }

    private WebClient.ResponseSpec showSellerUrlsRequestCreation(String companyIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        Object postBody = null;
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling showSellerUrls", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("companyIdentifier", companyIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        if (accept != null) {
            headerParams.add("Accept", this.apiClient.parameterToString(accept));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<SellerUrlViewAffiliate> localVarReturnType = new ParameterizedTypeReference<SellerUrlViewAffiliate>(this){};
        return this.apiClient.invokeAPI("/api/company/{companyIdentifier}/seller-url/list", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Flux<SellerUrlViewAffiliate> showSellerUrls(String companyIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<SellerUrlViewAffiliate> localVarReturnType = new ParameterizedTypeReference<SellerUrlViewAffiliate>(this){};
        return this.showSellerUrlsRequestCreation(companyIdentifier, winkVersion, accept).bodyToFlux((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<List<SellerUrlViewAffiliate>>> showSellerUrlsWithHttpInfo(String companyIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        ParameterizedTypeReference<SellerUrlViewAffiliate> localVarReturnType = new ParameterizedTypeReference<SellerUrlViewAffiliate>(this){};
        return this.showSellerUrlsRequestCreation(companyIdentifier, winkVersion, accept).toEntityList((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec showSellerUrlsWithResponseSpec(String companyIdentifier, String winkVersion, String accept) throws WebClientResponseException {
        return this.showSellerUrlsRequestCreation(companyIdentifier, winkVersion, accept);
    }

    private WebClient.ResponseSpec updateSellerUrlRequestCreation(String companyIdentifier, String sellerUrlIdentifier, UpsertSellerUrlRequestAffiliate upsertSellerUrlRequestAffiliate, String winkVersion) throws WebClientResponseException {
        UpsertSellerUrlRequestAffiliate postBody = upsertSellerUrlRequestAffiliate;
        if (companyIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'companyIdentifier' when calling updateSellerUrl", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (sellerUrlIdentifier == null) {
            throw new WebClientResponseException("Missing the required parameter 'sellerUrlIdentifier' when calling updateSellerUrl", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (upsertSellerUrlRequestAffiliate == null) {
            throw new WebClientResponseException("Missing the required parameter 'upsertSellerUrlRequestAffiliate' when calling updateSellerUrl", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("companyIdentifier", companyIdentifier);
        pathParams.put("sellerUrlIdentifier", sellerUrlIdentifier);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (winkVersion != null) {
            headerParams.add("Wink-Version", this.apiClient.parameterToString(winkVersion));
        }
        String[] localVarAccepts = new String[]{"*/*", "application/json", "application/xml", "text/xml", "text/plain"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"oauth2ClientCredentials"};
        ParameterizedTypeReference<SellerUrlViewAffiliate> localVarReturnType = new ParameterizedTypeReference<SellerUrlViewAffiliate>(this){};
        return this.apiClient.invokeAPI("/api/company/{companyIdentifier}/seller-url/{sellerUrlIdentifier}", HttpMethod.PUT, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<SellerUrlViewAffiliate> updateSellerUrl(String companyIdentifier, String sellerUrlIdentifier, UpsertSellerUrlRequestAffiliate upsertSellerUrlRequestAffiliate, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<SellerUrlViewAffiliate> localVarReturnType = new ParameterizedTypeReference<SellerUrlViewAffiliate>(this){};
        return this.updateSellerUrlRequestCreation(companyIdentifier, sellerUrlIdentifier, upsertSellerUrlRequestAffiliate, winkVersion).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<SellerUrlViewAffiliate>> updateSellerUrlWithHttpInfo(String companyIdentifier, String sellerUrlIdentifier, UpsertSellerUrlRequestAffiliate upsertSellerUrlRequestAffiliate, String winkVersion) throws WebClientResponseException {
        ParameterizedTypeReference<SellerUrlViewAffiliate> localVarReturnType = new ParameterizedTypeReference<SellerUrlViewAffiliate>(this){};
        return this.updateSellerUrlRequestCreation(companyIdentifier, sellerUrlIdentifier, upsertSellerUrlRequestAffiliate, winkVersion).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec updateSellerUrlWithResponseSpec(String companyIdentifier, String sellerUrlIdentifier, UpsertSellerUrlRequestAffiliate upsertSellerUrlRequestAffiliate, String winkVersion) throws WebClientResponseException {
        return this.updateSellerUrlRequestCreation(companyIdentifier, sellerUrlIdentifier, upsertSellerUrlRequestAffiliate, winkVersion);
    }
}

